---
lang-ref: ch.06-1
title: 합성곱 신경망의 응용
authors: Shiqing Li, Chenqin Yang, Yakun Wang, Jimin Tan
date: 4 Mar 2020
lang: ko
translation-date: 17 Apr 2020
translator : Yujin
---


<!-- ## [Zip Code Recognition](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=43s) -->
## [우편번호 인식](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=43s)

<!-- In the previous lecture, we demonstrated that a convolutional network can recognize digits, however, the question remains, how does the model pick each digit and avoid perturbation on neighboring digits. The next step is to detect non/overlapping objects and use the general approach of Non-Maximum Suppression (NMS). Now, given the assumption that the input is a series of non-overlapping digits, the strategy is to train several convolutional networks and using either majority vote or picking the digits corresponding to the highest score generated by the convolutional network. -->
이전의 강의에서, 우리는 합성곱 신경망이 숫자를 인식할 수 있다는 것을 확인했지만, 합성곱 신경망이 과연 어떻게 각 숫자를 선택하고 주변 숫자에 의한 인식 교란을 막는지에 대한 의문이 남는다. 다음 단계는 겹치지 않는 개체를 감지하고 NMS<sup>Non-Maximum Suppression</sup> 알고리즘의 일반적인 접근 방식을 사용하는 것이다. 이제, 입력 데이터가 겹치지 않는 일련의 숫자라고 가정하면, 이를 인식해 내는 전략은 다수의 합성곱 신경망을 학습시키고 이들의 출력값들에 대한 과반수 투표<sup>majority vote</sup>를 진행하거나, 혹은 합성곱 신경망이 내놓는 최고 점수에 따라 숫자를 선택하는 것이다. 


<!-- ### Recognition with CNN -->
### CNN을 이용한 인식

<!-- Here we present the task of recognizing 5 non-overlapping zip codes. The system was not given any instructions on how to separate each digit but knows that is must predict 5 digits. The system (Figure 1) consists of 4 different sized convolutional networks, each producing one set of outputs. The output is represented in matrices. The four output matrices are from models with a different kernel width in the last layer. In each output, there are 10 rows, representing 10 categories from 0 to 9. The larger white square represents a higher score in that category. In these four output blocks, the horizontal sizes of the last kernel layers are 5, 4, 3 and 2 respectively. The size of the kernel decides the width of the model's viewing window on the input, therefore each model is predicting digits based on different window sizes. The model then takes a majority vote and selects the category that corresponds to the highest score in that window. To extract useful information, one should keep in mind that not all combinations of characters are possible, therefore error correction leveraging input restrictions is useful to ensure the outputs are true zip codes. -->
여기서 우리는 겹치지 않는 5자리의 우편번호 인식 과제에 대해 살펴본다. 시스템은 각 숫자를 어떻게 판별해 낼 것인지에 대한 어떠한 지시를 받지 않았으나, 5개의 숫자를 예측해야 한다는 것은 알고 있다.  시스템 (그림 1)은 각각 하나의 출력 내놓는 4개의 서로 다른 크기로 구성된 합성곱 신경망으로 이루어져 있다. 출력은 행렬으로 표현된다. 네 개의 출력은 합성곱 신경망의 마지막 레이어에서 서로 다른 커널 너비를 가진 모델에서 나온 것이다. 각 출력은 10개의 행을 가지는데, 이는 10 종류, 즉 0부터 9까지의 숫자 범주를 나타낸다. 흰색 사각형의 크기가 클수록 해당 범주에서 더 높은 점수를 나타낸다. 이 4개의 출력 블록에서 마지막 커널 레이어의 가로 크기는 각각 5, 4, 3, 그리고 2 이다. 이 커널의 크기는 모델이 입력을 읽어내는 창<sup>window</sup> 크기를 결정하고, 따라서 각 모델은 서로 다른 창 크기에 따라 숫자를 예측한다. 이 다음 모델은 과반수 투표를 하고 해당 창에서 가장 높은 점수를 얻은 숫자 범주를 선택한다. 유용한 정보를 추출하기 위해서, 모든 문자 조합이 가능한 것은 아니란 점을 명심해야 하고, 따라서 입력 제한을 활용하는 오류 수정은 모델의 출력이 실제 우편변호가 되도록하는데 유용하다. 


<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-1/O1IN3JD.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 1:</b> Multiple classifiers on zip code recognition
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-1/O1IN3JD.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>그림 1:</b> 우편번호 인식을 위한 여러 분류기
</center>

<!-- Now to impose the order of the characters. The trick is to utilize a shortest path algorithm. Since we are given ranges of possible characters and the total number of digits to predict, We can approach this problem by computing the minimum cost of producing digits and transitions between digit. The path has to be continuous from the lower left cell to the upper right cell on the graph, and the path is restricted to only contain movements from left to right and bottom to top. Note that if the same number is repeated next to each other, the algorithm should be able to distinguish there are repeated numbers instead of predicting a single digit. -->
이제 문자열의 순서를 부여하기 위해 우리가 사용할 트릭은 최단 경로 알고리즘이다. 가능한 문자의 범위와 예측할 총 숫자 갯수가 주어졌으므로, 우리는 이 문제를 숫자의 생성 및 숫자 간 전환의 최소 비용 측면에서 접근할 수 있다. 경로는 그래프의 왼쪽 하단 셀<sup>cell</sup>에서 오른쪽 상단 셀까지 연속적이어야하고, 경로 구성은 오른쪽에서 왼쪽으로, 그리고 아래에서 위로 이동하는 것으로만 제한한다. 여기서 알아둬야 할 점은, 만일 동일한 숫자가 바로 옆에서 반복된다면, 알고리즘은 단일한 숫자만 예측하는 것 대신 숫자가 반복되고 있음을 구분해 낼 수 있어야 한다.  


<!-- ## [Face detection](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1241s) -->
## [얼굴 인식](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1241s)

<!-- Convolutional neural networks perform well on detection tasks and face detection is no exception. To perform face detection we collect a dataset of images with faces and without faces, on which we train a convolutional net with a window size such as 30 $\times$ 30 pixels and ask the network to tell whether there is a face or not. Once trained, we apply the model to a new image and if there are faces roughly within a 30 $\times$ 30 pixel window, the convolutional net will light up the output at the corresponding locations. However, two problems exist. -->

합성곱 신경망은 탐지/인식<sup>detection</sup> 작업에서 높은 성과를 보이며, 이는 얼굴 인식<sup>face detection</sup> 분야에서도 예외는 아니다. 얼굴 인식을 수행하기 위해서 우리는 얼굴이 있는 이미지와 얼굴이 없는 이미지를 모아서 데이터셋을 만들고, 30 $\times$ 30 픽셀 윈도우<sup>window</sup> 등의 크기를 가진 합성곱 신경망을 학습시켜 여기에 얼굴이 있는지 없는지를 가려내게 한다. 일단 훈련이 되면, 우리는 이 모델을 새로운 이미지에 적용해보고 대략 30 $\times$ 30 픽셀 윈도우 창 내에 들어오는 얼굴이 있을시, 합성곱 신경망은 해당 위치의 출력을 밝게 표시할 것이다. 하지만 여기에는 두 개의 문제가 있다. 

<!-- - **False Positives**: There are many ways that a patch of an image is not a face. During the training stage, the model may not see all of them (i.e. a fully representative set.). Therefore, the model may suffer from a lot of false positives at test time. -->

- **거짓 양성 오류<sup>False Positive</sup>**: 이미지의 일부가 얼굴이 아닌 경우는 매우 많다. 합성곱 신경망의 학습 과정 동안, 이 모델은 이런 이미지 전부를 보지 못할 것이다 (즉, 완전히 대표적인 데이터셋). 따라서 모델을 테스트하는 시점에서 수많은 거짓 양성 오류가 발생할 수 있다. 

<!-- - **Different Face Size:** Not all faces are 30 $\times$ 30 pixels, so faces of differing sizes may not be detected. One way to handle this issue is to generate multi-scale versions of the same image. The original detector will detect faces around 30 $\times$ 30 pixels. If applying a scale on the image of factor $\sqrt 2$, the model will detect faces that were smaller in the original image since what was 30 $\times$ 30 is now 20 $\times$ 20 pixels roughly. To detect bigger faces, we can downsize the image. This process is inexpensive as half of the expense comes from processing the original non-scaled image. The sum of the expenses of all other networks combined is about the same as processing the original non-scaled image. The size of  the network is the square of the size of the image on one side, so if you scale down the image by $\sqrt 2$, the network you need to run is smaller by a factor of 2. So the overall cost is $1+1/2+1/4+1/8+1/16…$, which is 2. Performing a multi-scale model only doubles the computational cost. -->

- **다른 얼굴 크기:** 모든 얼굴이 30 $\times$ 30 사이즈 픽셀은 아니기에, 다른 사이즈의 얼굴의 경우 인식이 안 될 수 있다. 이 문제를 처리하는 한 가지 방법은 동일한 이미지의 멀티 스케일 (다배율)<sup>multi-scale</sup> 버전을 만들어내는 것이다. 원래의 얼굴 인식 모델은 30 $\times$ 30 픽셀 사이즈의 얼굴만 탐지해 낼 것이다. 만일 $\sqrt 2$ 를 이미지에 배율로 적용하면, 기존의 30 $\times$ 30 이 이제는 대략 20 $\times$ 20 사이즈의 픽셀이 되기 때문에, 모델은 원본 이미지에서 더 작은 사이즈의 얼굴을 인식해 낼 수 있다. 더 큰 사이즈의 얼굴을 인식해 내기 위해서, 우리는 이미지의 배율을 축소할 수 있다. 이 과정은 비용의 절반이 배율이 적용되지 않은 원본 이미지 처리에서 발생하기 때문에 연산 비용이 저렴하다. 다른 모든 네트워크의 비용 합계가 배율이 적용되지 않은 원본 이미지 처리에 드는 비용과 동일하다. 네트워크의 크기는 한쪽 이미지 크기의 제곱과 같으므로, 이미지를 $\sqrt 2$ 로 축소하면, 실행할 네트워크의 크기가 2배 작아지는 것과 같다. 따라서 전체 비용은 $1+1/2+1/4+1/8+1/16…$, 즉 2가 된다. 멀티 스케일 (다배율) 모델은 원래의 계산 비용의 딱 두 배일 뿐이다. 

<!-- ### A multi-scale face detection system -->
### 멀티 스케일 (다중 스케일) 얼굴 인식 시스템

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-1/8R3v0Dj.png" style="zoom: 30%; background-color:#DCDCDC;"/><br>
<b>Figure 2:</b> Face detection system
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-1/8R3v0Dj.png" style="zoom: 30%; background-color:#DCDCDC;"/><br>
<b>그림 2:</b> 얼굴 인식 시스템 
</center>
<!-- The maps shown in (Figure 3) indicate the scores of face detectors. This face detector recognizes faces that are 20 $\times$ 20 pixels in size. In fine-scale (Scale 3) there are many high scores but are not very definitive. When the scaling factor goes up (Scale 6), we see more clustered white regions. Those white regions represent detected faces. We then apply non-maximum suppression to get the final location of the face. -->
(그림 3) 에서 보여지는 그림들은 안면 인식기<sup>face detectors</sup>의 점수를 나타낸다. 이 인식기는 크기가 20 $\times$ 20 픽셀 사이즈인 얼굴을 인식한다. (Scale 3)의 세밀한 스케일의 경우 높은 점수를 보이는 부분이 많지만, 그 부분들이 명확하지가 않다. 스케일링 계수가 올라가면 (Scale 6), 우리는 더 많이 뭉쳐져 있는 흰색 영역을 볼 수 있다. 이러한 흰색 영역은 탐지된 얼굴을 가리킨다. 이 때 우리는 비최대값 억제<sup>non-maximum suppression</sup> 알고리즘을 적용해서 최종적으로 얼굴 위치를 얻는다. 

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-1/CQ8T00O.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 3:</b> Face detector scores for various scaling factors
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-1/CQ8T00O.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>그림 3:</b> 다양한 스케일링 계수에 따른 얼굴 인식기 점수 
</center>

<!-- ### Non-maximum suppression -->
### 비최댓값 억제<sup>Non-maximum suppression</sup> 

<!-- For each high-scoring region, there is probably a face underneath. If more faces are detected very close to the first, it means that only one should be considered correct and the rest are wrong. With non-maximum suppression, we take the highest-scoring of the overlapping bounding boxes and remove the others. The result will be a single bounding box at the optimum location. -->
각각의 높은 점수를 보이는 영역마다 얼굴을 탐지해 냈을 것이다. 만일 첫 번째 인식된 얼굴과 굉장히 가까운 부근에서 더 많은 수의 얼굴이 인식된다면, 이는 단 한 개의 인식된 얼굴만 옳은 것, 나머지는 잘못된 것이라고 볼 수 있다. 비최댓값 억제를 이용해서, 우리는 중첩된 경계의 인식된 이미지 경계 박스<sup>bounding box</sup> 들 중에서 가장 높은 점수를 얻는 한 개의 것만 취하고, 나머지는 버린다. 이에 따라 최적의 위치에 인식된 이미지 박스 하나만 남을 것이다. 


<!-- ### Negative mining -->
### 네거티브 마이닝<sup>Negative mining</sup>

<!-- In the last section, we discussed how the model will run into a large number of false positives at test time as there are many ways for objects to appear similar to a face. No training set will include all the non-face objects that look like faces. We can mitigate this problem through negative mining. In negative mining, we create a negative dataset of non-face patches that the model detects as faces. The data is collected by running the model on inputs that are known to contain no faces. Then we retrain the detector using the negative dataset. We can repeat this process to increase the robustness of our model against false positives. -->
마지막 섹션에서, 얼굴과 비슷하게 보이는 물체들이 많기 때문에, 훈련된 모델을 테스트 하는 과정에서 많은 수의 거짓 양성<sup>false positivees</sup>을 마주칠 경우에 대해 이야기했다. 얼굴처럼 보이지만 사실은 얼굴이 아닌 물체를 모두 다 포함하는 학습 데이터셋은 존재하지 않는다. 우리는 이 문제를 네거티브 마이닝<sup>negative mining</sup>을 통해 완화시킬 수 있다. 네거티브 마이닝에서는, 우리는 모델이 얼굴로 인식하지만 사실은 얼굴이 아닌 이미지 조각을 모아서 네거티브 데이터셋<sup>negative dataset</sup>으로 만든다. 얼굴 이미지가 포함되지 않은 입력 데이터에 대해 모델을 학습시켜서 이러한 데이터를 모은다. 그 다음으로 우리는 이렇게 만들어진 네거티브 데이터셋에 대해 얼굴 인식 모델을 다시 학습 시킨다. 이 과정을 반복해서 우리는 거짓 양성 오류에 대한 모델의 강건성<sup>robustness</sup>을 높일 수 있다. 


<!-- ## Semantic segmentation -->
## 의미론적 분할<sup>Semantic segmentation</sup>

<!-- Semantic segmentation is the task of assigning a category to every pixel in an input image. -->
의미론적 분할은 입력 이미지의 모든 픽셀에 대해 범주<sup>category</sup>를 할당하는 작업이다. 


<!-- ### [CNN for Long Range Adaptive Robot Vision](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1669s) -->
### [장거리 적응형 로봇 비전을 위한 CNN](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1669s)

<!-- In this project, the goal was to label regions from input images so that a robot can distinguish between roads and obstacles. In the figure, the green regions are areas the robot can drive on and the red regions are obstacles like tall grass. To train the network for this task, we took a patch from the image and manually label it traversable or not (green or red). We then train the convolutional network on the patches by asking it to predict the color of the patch. Once the system is sufficiently trained, it is applied to the entire image, labeling all the regions of the image as green or red. -->
이 프로젝트의 목표는 로봇이 도로와 장애물을 구분할 수 있도록 입력 이미지의 각 영역에 레이블<sup>label</sup> 값을 할당하는 것이었다. 그림에서 녹색 부분은 로봇이 주행할 수 있는 영역이고, 빨간색 부분은 큰 잔디와 같은 장애물을 나타낸다. 이 작업을 위한 네트워크를 훈련시키기 위해서, 우리는 이미지의 일부 영역<sup>patch</sup>을 대상으로 해당 영역이 통과 가능한 부분인지 아닌지 (녹색 또는 빨간색)에 대한 값을 직접 수동으로 할당했다. 그 다음 이렇게 레이블된 일부 영역에 대해 합성곱 신경망을 학습시켜서 해당 영역의 색상 값을 예측하도록 했다. 이 시스템이 충분히 훈련이 되고 나면, 이것을 전체 이미지에 적용해서, 이미지의 영역을 녹색 또는 빨간색으로 레이블 값을 매기도록 했다. 

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-1/5mM7dTT.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 4:</b> CNN for Long Range Adaptive Robot Vision (DARPA LAGR program 2005-2008)
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-1/5mM7dTT.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>그림 4:</b> 장거리 적응형 로봇 비전을 위한 CNN (DARPA LAGR 프로그램 2005-2008)
</center>

<!-- There were five categories for prediction: 1) super green, 2) green, 3) purple: obstacle foot line, 4) red obstacle  5) super red: definitely an obstacle. -->
여기에는 1) 슈퍼 초록<sup>super green</sup>, 2) 초록, 3) 보라: 장애물 말단 선, 4) 빨간 장애물, 5) 슈퍼 빨강, 확실한 장애물 의 다섯 개 범주가 있었다. 


<!-- **Stereo Labels** (Figure 4, Column 2)
 Images are captured by the 4 cameras on the robot, which are grouped into 2 stereo vision pairs. Using the known distances between the stereo pair cameras, the positions of every pixel in 3D space are then estimated by measuring the relative distances between the pixels that appear in both the cameras in a stereo pair. This is the same process our brains use to estimate the distance of the objects that we see. Using the estimated position information, a plane is fit to the ground, and pixels are then labeled as green if they are near the ground and red if they are above it. -->
 **스테레오 레이블** (그림 4, 칼럼 2)
이미지는 로봇의 4개 카메라로 캡쳐되며, 2개의 스테레오 비전 쌍으로 그룹화된다. 스테레오 카메라 두 개 사이의 알고 있는 거리를 사용해서, 3D 공간 상의 모든 픽셀 위치는 스테레오 쌍으로 두 카메라에 나타나는 픽셀 사이의 상대적 거리로 측정값으로 추정된다. 이는 우리가 보는 물체의 거리를 추정하기 위해 우리 뇌가 사용하는 방식과 같은 과정이다. 추정된 위치 정보를 활용해서 평면이 지면에 맞춰지고 픽셀이 지면 근처에 있으면 녹색, 지면 위에 있으면 빨간 색으로 표시된다.  

<!-- * **Limitations & Motivation for ConvNet**: The stereo vision only works up to 10 meters and driving a robot requires long-range vision. A ConvNet however, is capable of detecting objects at much greater distances, if trained correctly. -->
* **합성곱 신경망의 한계 및 동기부여<sup>motivation<sup>**: 스테레오 비전은 최대 10 미터까지만 작동하고 로봇을 구동하려면 장거리 비전<sup>vision</sup>이 필요하다. 그러나 합성곱 신경망의 경우 학습이 올바르게만 된다면 훨씬 더 먼 거리의 물체도 감지해 낼 수 있다. 

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-1/rcxY4Lb.png" style="zoom: 100%; background-color:#DCDCDC;"/><br>
<b>Figure 5:</b> Scale-invariant Pyramid of Distance-normalized Images
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-1/rcxY4Lb.png" style="zoom: 100%; background-color:#DCDCDC;"/><br>
<b>그림 5:</b> 거리 정규화<sup>Distance-normalized</sup> 이미지의 스케일 불변<sup>Scale-invariant</sup> 피라미드
</center>

<!-- * **Served as Model Inputs**: Important pre-processing includes building a scale-invariant pyramid of distance-normalized images (Figure 5). It is similar to what we have done earlier of this lecture when we tried to detect faces of multiple scales. -->
* **모델 입력으로 사용됨**: 거리 정규화 이미지의 스케일 불변 피라미드를 구축하는 것은 중요 전처리 과정에 포함된다 (그림 5). 이는 이번 강의 초반에 우리가 여러 스케일의 얼굴을 탐지해 내고자 시도한 것과 유사하다. 

<!-- **Model Outputs** (Figure 4, Column 3) -->
**모델 출력** (그림 4, 칼럼 3)

<!-- The model outputs a label for every pixel in the image **up to the horizon**. These are classifier outputs of a multi-scale convolutional network. -->
이 모델은 이미지의 모든 픽셀에 대해 **수평선 까지** 레이블을 출력한다. 이들은 다중 스케일 합성곱 신경망의 분류기 출력이다.

<!-- * **How the Model Becomes Adaptive**: The robots have continuous access to the stereo labels, allowing the network to re-train, adapting to the new environment it's in. Please note that only the last layer of the network would be re-trained. The previous layers are trained in the lab and fixed. -->
* **모델이 어떻게 적응해 나가는가**: 로봇은 스테레오 레이블에 지속적으로 접근할 수 있고, 이는 네트워크가 재학습을 통해 새로운 환경에 적응할 수 있도록 한다. 여기서 알아둬야 할 점은 네트워크그 가장 마지막 레이어만 재학습이 이뤄진다는 것이다. 이전 레이어는 학습이 되어 고정된 상태이다. 

<!-- **System Performance** -->
**시스템 성능**

<!-- When trying to get to a GPS coordinate on the other side of a barrier, the robot "saw" the barrier from far away and planned a route that avoided it. This is thanks to the CNN detecting objects up 50-100m away. -->
장애물의 반대편 GPS 좌표를 얻으려고 할 때, 로봇은 장애물을 멀리에서 "보고" 그 장애물을 피할 경로를 계획했다. 이는 CNN이 50-100m 떨어진 상태에서 물체를 감지해 낸 덕분이다. 

<!-- **Limitation** -->
**한계**

<!-- Back in the 2000s, computation resources were restricted. The robot was able to process around 1 frame per second, which means it would not be able to detect a person that walks in its way for a whole second before being able to react. The solution for this limitation is a **Low-Cost Visual Odometry** model. It is not based on neural networks, has a vision of ~2.5m but reacts quickly. -->
지난 2000년대에는, 컴퓨팅 리소스가 제한적이었다. 로봇은 초당 약 1 프레임을 처리할 수 있었는데, 이는 로봇이 자기의 경로로 진입해 걸어오는 사람에 대해 반응하기 전 1초 동안 이를 전혀 감지해 내지 못한다는 것이다. 이 한계점에 대한 해결책은 **저비용 시각적 주행측정<sup>Low-Cost Visual Odometry</sup>** 모델이다. 이것은 신경망을 기반으로 하지 않고, ~2.5m 의 비전을 가지고 있지만, 신속하게 반응한다. 

<!-- ### Scene Parsing and Labelling -->
### 장면 파싱<sup>Scene Parsing</sup>과 레이블링

<!-- In this task, the model outputs an object category (buildings, cars, sky, etc.) for every pixel. The architecture is also multi-scale (Figure 6). -->
이 작업에서 모델은 모든 픽셀에 대한 객체 범주 (건물, 자동차, 하늘 등.) 를 출력한다. 모델 구조는 역시 멀티 스케일(다중 스케일)이다 (그림 6).

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-1/VpVbkl5.jpg" style="zoom: 30%; background-color:#DCDCDC;"/><br>
<b>Figure 6:</b> Multi-scale CNN for scene parsing
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-1/VpVbkl5.jpg" style="zoom: 30%; background-color:#DCDCDC;"/><br>
<b>그림 6:</b> 장면 파싱을 위한 다중 스케일 CNN 
</center>

<!-- Notice that if we back project one output of the CNN onto the input, it corresponds to an input window of size $46\times46$ on the original image at the bottom of the Laplacian Pyramid. It means we are **using the context of $46\times46$ pixels to decide the category of the central pixel**. -->
CNN 출력 하나를 입력에 다시 투영하면, 이는 $46\times46$ 크기의 라플라시안 피라미드<sup>Laplacian Pyramid</sup>하단의 입력 윈도우에 해당한다. 이는 우리가 It means we are **중앙 픽셀의 범주를 결정하기 위해 $46\times46$ 픽셀의 맥락<sup>context</sup>을 사용하고 있음**을 의미한다.

<!-- However, sometimes this context size is not enough to determine the category for larger objects. -->
그러나, 가끔 이 맥락 사이즈<sup>context size</sup>는 더 큰 개체의 범주를 결정하기에 충분하지 않다.

<!-- **The multiscale approach enables a wider vision by providing extra rescaled images as  inputs.** The steps are as follows:
1. Take the same image, reduce it by the factor of 2 and a factor of 4, separately.
2. These two extra rescaled images are fed to **the same ConvNet** (same weights, same kernels) and we get another two sets of Level 2 Features.
3. **Upsample** these features so that they have the same size as the Level 2 Features of the original image.
4. **Stack** the three sets of (upsampled) features together and feed them to a classifier. -->
**멀티 스케일 방식은 추가적으로 다시 스케일된 이미지를 입력으로 제공하면서 더 넓은 비전을 가능하게 한다** 그 과정은 다음과 같다:
1. 동일한 이미지를 각각 2배, 4배 줄인다.
2. 이 두 개의 추가로 크기 조정된 이미지들은 **동일한 ConvNet** (동일한 무게, 동일한 커널)에 입력되고 우리는 또 다른 레벨 2 특징값<sup>Level 2 Featrues</sup> 두 세트를 얻는다. 
3. 이 특징값을 **업-샘플<sup>Upsample</sup>** 해서 원본 이미지의 레벨 2 특징값과 동일한 사이즈가 되도록 한다. 
4. 이렇게 (업-샘플된) 세 개 세트의 특징값을 **쌓아서** 분류기에 입력한다. 


<!-- Now the largest effective size of content, which is from the 1/4 resized image, is $184\times 184\, (46\times 4=184)$. -->
이제 1/4 크기로 재조정된 이미지에서 나온 가장 큰 유효한 결과물의 크기는 is $184\times 184\, (46\times 4=184)$ 이다.

<!-- **Performance**: With no post-processing and running frame-by-frame, the model runs very fast even on standard hardware. It has a rather small size of training data (2k~3k), but the results are still record-breaking. -->
**성능**: 어떠한 후처리 과정<sup>post-processing</sup>과 프레임별 실행이 없어도, 모델은 표준 하드웨어 상에서도 매우 빠르게 실행된다. 학습하는 데이터의 크기는 다소 작은 편이지만 (2k~3k), 모델의 성과는 여전히 기록적인 수준이다. 
