---
lang-ref: ch.04-1
lecturer: Alfredo Canziani
title: 선형대수와 합성곱
lang: ko
authors: Yuchi Ge, Anshan He, Shuting Gu, and Weiyang Wen
date: 18 Feb 2020
translation-date: 27 Mar 2020
translator: ChoongHee Lee
---


## [선형대수 복습](https://www.youtube.com/watch?v=OrBEon3VlQg&t=68s)

<!--This part is a recap of basic linear algebra in the context of neural networks. We start with a simple hidden layer $\boldsymbol{h}$:-->

이 파트는 신경망 맥락 안에서의 기초 선형대수 개요에 관한 내용입니다. 단순 은닉층 $\boldsymbol{h}$에 대해 먼저 알아보겠습니다.

$$
\boldsymbol{h} = f(\boldsymbol{z})
$$

<!--The output is a non-linear function $f$ applied to a vector $z$. Here $z$ is the output of an affine transformation $\boldsymbol{A} \in\mathbb{R^{m\times n}}$ to the input vector $\boldsymbol{x} \in\mathbb{R^n}$:-->

출력값은 벡터 $z$에 적용된 비선형 함수 $f$입니다. 여기서 $z$는 $\boldsymbol{x} \in\mathbb{R^n}$인 입력 벡터에 대하여 $\boldsymbol{A} \in\mathbb{R^{m\times n}}$인 아핀 변환의 출력값입니다.

$$
\boldsymbol{z} = \boldsymbol{A} \boldsymbol{x}
$$

<!--For simplicity biases are ignored. The linear equation can be expanded as:-->

그러므로 단순 편향값들은 무시됩니다. 이 때, 선형방정식은 다음과 같이 확장할 수 있습니다.

$$
\boldsymbol{A}\boldsymbol{x} =
\begin{pmatrix}
a_{11} & a_{12} & \cdots & a_{1n}\\
a_{21} & a_{22} & \cdots & a_{2n} \\
\vdots & \vdots & \ddots & \vdots \\
a_{m1} & a_{m2} & \cdots & a_{mn} \end{pmatrix} \begin{pmatrix}
x_1 \\ \vdots \\x_n \end{pmatrix} =
\begin{pmatrix}
    \text{---} \; \boldsymbol{a}^{(1)} \; \text{---} \\
    \text{---} \; \boldsymbol{a}^{(2)} \; \text{---} \\
    \vdots \\
    \text{---} \; \boldsymbol{a}^{(m)} \; \text{---} \\
\end{pmatrix}
\begin{matrix}
    \rvert \\ \boldsymbol{x} \\ \rvert
\end{matrix} =
\begin{pmatrix}
    {\boldsymbol{a}}^{(1)} \boldsymbol{x} \\ {\boldsymbol{a}}^{(2)} \boldsymbol{x} \\ \vdots \\ {\boldsymbol{a}}^{(m)} \boldsymbol{x}
\end{pmatrix}_{m \times 1}
$$

<!--where $\boldsymbol{a}^{(i)}$ is the $i$-th row of the matrix $\boldsymbol{A}$.-->

(단, $\boldsymbol{a}^{(i)}$는 행렬 $\boldsymbol{A}$의 $i$번째 행에 위치합니다.)


<!--To understand the meaning of this transformation, let us analyse one component of $\boldsymbol{z}$ such as $a^{(1)}\boldsymbol{x}$. Let  $n=2$, then $\boldsymbol{a} = (a_1,a_2)$ and $\boldsymbol{x}  = (x_1,x_2)$. -->

이 변환의 의미를 이해하기 위해서, $a^{(1)}\boldsymbol{x}$와 같은 $\boldsymbol{z}$의 한 요소를 분석해봅시다. $n=2$일 때, $\boldsymbol{a} = (a_1,a_2)$ 그리고 $\boldsymbol{x}  = (x_1,x_2)$라 하겠습니다.

<!--$\boldsymbol{a}$ and $\boldsymbol{x}$ can be drawn as vectors in the 2D coordinate axis. Now, if the angle between $\boldsymbol{a}$ and $\hat{\boldsymbol{\imath}}$ is $\alpha$ and the angle between $\boldsymbol{x}$ and $\hat{\boldsymbol{\imath}}$ is $\xi$, then with trigonometric formulae $a^\top\boldsymbol{x}$ can be expanded as:-->

$\boldsymbol{a}$ 와 $\boldsymbol{x}$ 는 2차원 축으로 나타낼 수 있습니다. 이제, $\boldsymbol{a}$ 와 $\hat{\boldsymbol{\imath}}$ 사이의 각이 $\alpha$이고 $\boldsymbol{x}$ 와 $\hat{\boldsymbol{\imath}}$ 사이의 각을 $\xi$라 한다면, 삼각공식 $a^\top\boldsymbol{x}$은 아래와 같이 풀어쓸 수 있습니다.

$$
\begin {aligned}
\boldsymbol{a}^\top\boldsymbol{x} &= a_1x_1+a_2x_2\\
&=\lVert \boldsymbol{a} \rVert \cos(\alpha)\lVert \boldsymbol{x} \rVert \cos(\xi) + \lVert \boldsymbol{a} \rVert \sin(\alpha)\lVert \boldsymbol{x} \rVert \sin(\xi)\\
&=\lVert \boldsymbol{a} \rVert \lVert \boldsymbol{x} \rVert \big(\cos(\alpha)\cos(\xi)+\sin(\alpha)\sin(\xi)\big)\\
&=\lVert \boldsymbol{a} \rVert \lVert \boldsymbol{x} \rVert \cos(\xi-\alpha)
\end {aligned}
$$

<!--The output measures the alignment of the input to a specific row of the matrix $\boldsymbol{A}$. This can understoof by observing the angle between the two vectors, $\xi-\alpha$. When $\xi = \alpha$, the two vectors are perfectly aligned and maximum is attained. If $\xi - \alpha = \pi$, then $\boldsymbol{a}^\top\boldsymbol{x}$ attains its minimum and the two vectors are pointing at opposite directions. In essence, the linear transformation allows one to see the projection of an input to various orientations as defined by $A$. This intuition is expandable to higher dimensions as well.-->

출력값은 행렬 $\boldsymbol{A}$의 특정 행에 대한 입력값 정렬을 계산합니다. 우리는 이것을 두 벡터 $\xi-\alpha$ 사이의 각을 관찰함으로써 이해할 수 있습니다. $\xi = \alpha$일 때, 두 벡터는 완벽하게 정렬되고 최대값 또한 정해집니다. 만약 $\xi - \alpha = \pi$이면, $\boldsymbol{a}^\top\boldsymbol{x}$는 그것의 최소값을 가지게 되고 두 벡터는 반대 방향을 가리키게 됩니다. 본질적으로, 선형 변환은 $A$에 의해 정의된 다양한 방향에 대한 입력값의 정사영을 볼 수 있게 합니다. 이 직관은 마찬가지로 더 높은 차원으로 확장할 수 있습니다.


<!--Another way to understand the linear transformation is by understanding that $\boldsymbol{z}$ can also be expanded as:-->

선형변환을 이해하기 위한 또 다른 방법은 바로 $\boldsymbol{z}$가 아래와 같이 확장가능하다는 것을 이해하는 것입니다.


$$
\boldsymbol{A}\boldsymbol{x} =
\begin{pmatrix}
    \vert            & \vert            &        & \vert             \\
    \boldsymbol{a}_1 & \boldsymbol{a}_2 & \cdots & \boldsymbol{a}_n  \\
    \vert            & \vert            &        & \vert             \\
\end{pmatrix}
\begin{matrix}
    \rvert \\ \boldsymbol{x} \\ \rvert
\end{matrix} =
x_1 \begin{matrix} \rvert \\ \boldsymbol{a}_1 \\ \rvert \end{matrix} +
x_2 \begin{matrix} \rvert \\ \boldsymbol{a}_2 \\ \rvert \end{matrix} +
    \cdots +
x_n \begin{matrix} \rvert \\ \boldsymbol{a}_n \\ \rvert \end{matrix}
$$

<!--The output is the weighted sum of the columns of matrix $\boldsymbol{A}$. Therefore, the signal is nothing but a composition of the input.-->

출력값은 행렬 $\boldsymbol{A}$의 열의 가중합입니다. 그러므로 이는 아무것도 아니지만, 입력값의 구성요소입니다.


## [선형대수, 합성곱으로의 확장](https://www.youtube.com/watch?v=OrBEon3VlQg&t=1030s)

<!--Now we extend linear algebra to convolutions, by using the example of audio data analysis. We start with representing a fully connected layer as a form of matrix multiplication: --->

이제 우리는 선형대수를 오디오 데이터 분석 예시를 통해 합성곱으로 넓혀볼 것입니다. 행렬곱 형태의 완전 연결 계층을 표현하는 것으로 시작합니다.

$$
\begin{bmatrix}
w_{11} & w_{12} & w_{13}\\
w_{21} & w_{22} & w_{23}\\
w_{31} & w_{32} & w_{33}\\
w_{41} & w_{42} & w_{43}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$

<!--In this example, the weight matrix has a size of $4 \times 3$, the input vector has a size of $3 \times 1$ and the output vector has a of size $4 \times 1$. -->

이번 예제에서는 가중 행렬은 $4 \times 3$, 입력 벡터는 $3 \times 1$ 그리고 출력 벡터는 $4 \times 1$임을 보여주고 있습니다.

<!--However, for audio data, the data is much longer (not 3-sample long). The number of samples in the audio data is equal to the duration of the audio (e.g. 3 seconds) times the sampling rate (e.g. 22.05 kHz). As shown below, the input vector $\boldsymbol{x}$ will be quite long. Correspondingly, the weight matrix will become "fat".-->

그러나 오디오 데이터는 훨씬 더 긴 편입니다. (3-샘플 길이가 아님) 오디오 데이터에서 샘플 수는 오디오 길이(예, 3초)와 샘플레이트(예, 22.05kHz)의 곱과 같습니다. 아래에서 보여주고 있듯이,입력 벡터 $\boldsymbol{x}$는 꽤 길 것입니다. 그만큼, 가중 행렬은 커질 것입니다.

$$
\begin{bmatrix}
w_{11} & w_{12} & w_{13} & w_{14} & \cdots &w_{1k}& \cdots &w_{1n}\\
w_{21} & w_{22} & w_{23}& w_{24} & \cdots & w_{2k}&\cdots &w_{2n}\\
w_{31} & w_{32} & w_{33}& w_{34} & \cdots & w_{3k}&\cdots &w_{3n}\\
w_{41} & w_{42} & w_{43}& w_{44} & \cdots & w_{4k}&\cdots &w_{4n}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$

<!--The above formulation will be difficult to train. Fortunately there are ways to simplify the same.-->

위 공식은 학습하기 어려울 것입니다. 하지만 다행히도 단순하게 만들 방법이 있습니다.

### 특성: 국소성

<!--Due to locality (i.e. we do not care for data points that are far away) of data, $w_{1k}$ from the weight matrix above, can be filled with 0 when $k$ is relatively large. Therefore, the first row of the matrix becomes a kernel of size 3. Let's denote this size-3 kernel as $\boldsymbol{a}^{(1)} = \begin{bmatrix} a_1^{(1)}  & a_2^{(1)}  & a_3^{(1)} \end{bmatrix}$.-->

데이터의 국소성으로 인하여 (관계 없는 데이터는 신경쓰지 않기로 합니다.) 위 가중 행렬의 $w_{1k}$은 $k$가 상대적으로 클 때 0으로 채워질 수 있습니다. 그러므로 행렬의 첫 번째 행은 사이즈가 3인 커널이 됩니다. 이 3-사이즈 커널을 $\boldsymbol{a}^{(1)} = \begin{bmatrix} a_1^{(1)}  & a_2^{(1)}  & a_3^{(1)} \end{bmatrix}$로 나타내봅시다.

$$
\begin{bmatrix}
a_1^{(1)}  & a_2^{(1)}  & a_3^{(1)}  & 0 & \cdots &0& \cdots &0\\
w_{21} & w_{22} & w_{23}& w_{24} & \cdots & w_{2k}&\cdots &w_{2n}\\
w_{31} & w_{32} & w_{33}& w_{34} & \cdots & w_{3k}&\cdots &w_{3n}\\
w_{41} & w_{42} & w_{43}& w_{44} & \cdots & w_{4k}&\cdots &w_{4n}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$


### 특성: 정상성

<!--Natural data signals have the property of stationarity (i.e. certain patterns/motifs will repeat). This helps us reuse kernel $\mathbf{a}^{(1)}$ that we defined previously. We use this kernel by placing it one step further each time (i.e. stride is 1), resulting in the following:-->

자연적인 데이터 신호는 정상성을 가집니다.(즉, 확실한 패턴/모티프는 반복합니다.) 이는 우리가 이전에 정의했던 $\mathbf{a}^{(1)}$ 커널을 다시 쓸 수 있게 도와줍니다. 우리는 매번 각 단계마다(즉, stride는 1) 그것을 둠으로써 이 커널을 사용하고, 동시에 다음과 같은 결과를 얻게 됩니다.:

$$
\begin{bmatrix}
a_1^{(1)} & a_2^{(1)}  & a_3^{(1)}  & 0 & 0 & 0 & 0&\cdots  &0\\
0 & a_1^{(1)}  & a_2^{(1)} & a_3^{(1)}  & 0&0&0&\cdots &0\\
0 & 0 & a_1^{(1)} & a_2^{(1)}  & a_3^{(1)}  & 0&0&\cdots &0\\
0 & 0 & 0& a_1^{(1)}  & a_2^{(1)}  &a_3^{(1)} &0&\cdots &0\\
0 & 0 & 0& 0 & a_1^{(1)}  &a_2^{(1)} &a_3^{(1)} &\cdots &0\\
\vdots&&\vdots&&\vdots&&\vdots&&\vdots
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix}
$$

<!--Both the upper right part and lower left part of the matrix are filled with $0$s thanks to locality, leading to sparsity. The reuse of a certain kernel again and again is called weight sharing.-->

행렬의 오른쪽 윗 부분과 아랫쪽 왼쪽 부분 모두 국소성 덕분에 0으로 채워지고, 희소성이 생겼습니다. 확실한 커널을 반복해서 재사용하는 것을 가중치 공유라 부릅니다.

### Multiple layers of Toeplitz matrix  토플리츠 행렬의 다중 층위

<!--After these changes, the number of parameters we are left with is 3 (i.e. $a_1,a_2,a_3$). In comparison to the previous weight matrix, which had 12 parameters (i.e. $w_{11},w_{12},\cdots,w_{43}$), the current number of parameters is too restrictive and we would like to expand the same.-->

이러한 변화 이후, 남은 매개 변수 수는 3($a_1,a_2,a_3$)입니다. 앞서 매개 변수 값이 12($w_{11},w_{12},\cdots,w_{43}$)였던 가중 행렬과 비교했을 때, 현재 매개 변수 수는 매우 제한적이며 우리는 이것을 확장하고자 합니다.

<!--The previous matrix can be considered to be a layer (i.e. a convolutional layer) with the kernel $\boldsymbol{a}^{(1)}$. Then we can construct multiple layers with different kernels $\boldsymbol{a}^{(2)}$, $\boldsymbol{a}^{(3)}$, etc, thereby increasing the parameters.-->

이전 행렬은 $\boldsymbol{a}^{(1)}$ 커널을 동반한 층위(합성곱 층위)로 여겨질 수 있습니다. 그러면 우리는 매개 변수를 늘림으로써 $\boldsymbol{a}^{(2)}$, $\boldsymbol{a}^{(3)}$와 같은 다른 커널을 이용하여 다중 층위를 만들 수 있습니다.

<!--Each layer has a matrix containing just one kernel that is replicated multiple times. This type of matrix is called a Toeplitz matrix. In every Toeplitz matrix, each descending diagonal from left to right is constant. The Toeplitz matrices that we use here are sparse matrices as well.-->

각 층위는 여러번 복제된 단 하나의 커널을 포함하는 행렬을 가집니다. 이 유형을 토플리츠 행렬<sup>Toeplitz matrix</sup> 이라 부릅니다. 모든 토플리츠 행렬에서, 왼쪽에서 오른쪽으로 내려가는 대각선(주대각선)은 상수입니다. 또한, 우리가 여기서 사용하는 토플리츠 행렬들은 희소 행렬들입니다.

<!--Given the first kernel $\boldsymbol{a}^{(1)}$ and the input vector $\boldsymbol{x}$, the first entry in the output given by this layer is, $a_1^{(1)} x_1 + a_2^{(1)} x_2 + a_3^{(1)}x_3$. Therefore, the whole output vector is looks like the following: --->

첫번째 커널 $\boldsymbol{a}^{(1)}$와 입력 벡터 $\boldsymbol{x}$가 주어졌을 때, 이 층위에 의해 주어진 출력값에서의 첫번째 입력은 $a_1^{(1)} x_1 + a_2^{(1)} x_2 + a_3^{(1)}x_3$입니다. 그러므로 모든 출력 벡터는 다음과 같습니다.

$$
\begin{bmatrix}
\mathbf{a}^{(1)}x[1:3]\\
\mathbf{a}^{(1)}x[2:4]\\
\mathbf{a}^{(1)}x[3:5]\\
\vdots
\end{bmatrix}
$$

<!--The same matrix multiplication method can be applied on following convolutional layers with other kernels (e.g. $\boldsymbol{a}^{(2)}$ and $\boldsymbol{a}^{(3)}$) to get similar results.-->

비슷한 결과를 얻기 위해 동일 행렬을 복제하는 방법은 이어지는 $\boldsymbol{a}^{(2)}$, $\boldsymbol{a}^{(3)}$와 같은 다른 커널을 동반한 합성곱 층위에 적용될 수 있습니다.

## [합성곱 듣기 - 주피터 노트북](https://www.youtube.com/watch?v=OrBEon3VlQg&t=1709s)

<!--The Jupyter Notebook can be found [here]-->(https://github.com/Atcold/pytorch-Deep-Learning/blob/master/07-listening_to_kernels.ipynb).

주피터 노트북에서 작성된 내용은 [여기서](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/07-listening_to_kernels.ipynb) 확인할 수 있습니다.

<!--In this notebook, we are going to explore Convolution as a 'running scalar product'.-->

이 노트북에서 우리는 '스칼라 곱 실행'으로서의 합성곱에 대해 알아볼 것입니다.

<!--The library `librosa` enables us to load the audio clip $\boldsymbol{x}$ and it's sampling rate. In this case, there are 70641 samples, sampling rate is 22.05kHz and total length of the clip is 3.2s. The imported audio signal is wavy (refer to Fig 1) and we can guess what it sounds like from the amplitude of $y$ axis. The audio signal $x(t)$ is actually the sound played when turning off the Windows system (refer to Fig 2).-->

librosa 라이브러리는 오디오 클립 $\boldsymbol{x}$를 불러올 수 있게 해주며, 샘플링 속도입니다. 이 때, 70641개의 샘플이 있으며, 샘플링 속도는 22.05kHz이고 클립의 총 길이는 3.2초입니다. 불러온 오디오 신호는 웨이브 형태를 띄며(그림1 참조), 우리는 마치 $y$축 진폭으로부터 들리는 것 같은 소리가 무엇인지 알아낼 수 있습니다. 사실, 오디오 신호 $x(t)$는 윈도우 종료 시 재생되는 소리입니다.(그림2 참조)


<center>
<img src="{{site.baseurl}}/images/week04/04-1/audioSignal.png" width="500px" /><br>
<b>그림 1</b>: 오디오 신호 시각화 <br>
</center>

<center>
<img src="{{site.baseurl}}/images/week04/04-1/notes.png" width="500px" /><br>
<b>그림 2</b>: 위 오디오 신호에 대한 음표.<br>
</center>


<!--We need to seperate the notes from the waveform. To achieve this, if we use Fourier transform (FT) all the notes would come out together and it will be hard to figure out the exact time and location of each pitch. Therefore, a localized FT is needed (also known as spectrogram). As is observed in the spectrogram (refer to Fig 3), different pitches peak at different frequencies (e.g. first pitch peaks at 1600). Concatenating the four pitches at their frequencies gives us a pitched version of the original signal.-->

우리는 파동형태로부터 음표들을 분리해야 합니다. 이를 위하여, 우리가 푸리에 변환(FT)을 사용한다면 모든 음표들이 한꺼번에 나올 것이고, 정확한 시간과 각 피치의 위치를 알아내기 어려울 것입니다. 그러므로, 스펙트로그램이라 알려진 국지적 푸리에 변환(스펙트로그램)이 필요합니다. 스펙트로그램에서 관찰됨으로써(그림 3 참조), 다른 피치들은 다른 주파수(예, 첫 번째 피치는 1600에서 정점을 찍습니다.)에서 정점을 찍습니다. 그들 주파수에서 네 개의 피치를 연결하는 것은 원래 신호의 피치된 버전을 우리에게 주게 됩니다.

<center>
<img src="{{site.baseurl}}/images/week04/04-1/spectrogram.png" width="500px" /><br>
<b>그림 3</b>: 오디오 신호와 스펙트로그램.<br>
</center>

<!--Convolution of the input signal with all the pitches (all the keys of the piano for example) can help extract all notes the in the input piece (i.e. the hits when the audio matches the specific kernels). The spectrograms of the original signal and the signal of the concatenated pitches is shown in Fig 4 while the frequencies of the original signal and the four pitches is shown in Fig 5. The plot of the convolution of the four kernels with the input signal (original signal) is shown in Fig 6. Fig 6 along with the audio clips of the the convolutions prove the effectiveness of the convolutions in extracting the the notes.-->

모든 피치(예를 들면 피아노의 모든 키)를 동반한 입력 신호의 합성곱은 입력 조각에 있는 모든 노트(오디오가 특정 커널과 맞을 때 히트)를 추출할 수 있도록 도와줍니다. 본래 신호의 스펙트로그램과 연결된 피치의 신호는 그림4와 같이 나타나는 반면, 본래 신호의 주파수와 네 피치는 그림 5와 같이 나타납니다. 입력 신호(본래 신호)를 동반한 네 커널의 합성곱 플롯은 그림 6에서 볼 수 있습니다. 합성곱의 오디오 클립과 마찬가지로 그림 6은 노트 추출에서 합성곱의 효율성을 보여주고 있습니다.

<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig4.png" width="500px" /><br>
<b>그림 4</b>: 원래 신호 스펙트로그램(왼쪽)과 피치 연결 스펙트로그램(오른쪽).<br>
</center>

<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig5.png" width="500px" /><br>
<b>그림 5</b>: 첫번째 멜로디 음표.<br>
</center>

<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig6.png" width="500px" /><br>
<b>그림 6</b>: 네 커널의 합성곱.<br>
</center>


## 다른 데이터셋의 차원수

<!--The last part is a short digression on the different representations of dimensionality and examples for the same. Here we consider input set $X$ is made of  functions mapping from domains $\Omega$ to channels $c$.-->

마지막 파트는 차원수의 다른 표현에 대한 여담과 동일한 부분을 다룬 예제에 관한 내용입니다. 여기서 우리가 고려할 입력 세트 $X$는 $\Omega$ 도메인부터 채널 $c$까지 맵핑하는 함수로 만들어져 있습니다.

### 예제

<!--* Audio data: domain is 1-D, discrete signal indexed by time; number of channels $c$ can range from 1 (mono), 2 (stereo), 5+1 (Dolby 5.1), etc.
* Image data: domain is 2-D (pixels); $c$ can range from 1(greyscale), 3(colour), 20(hyperspectral), *etc.*
* Special relativity: domain is $\mathbb{R^4} \times \mathbb{R^4}$ (space-time $\times$ four-momentum); when $c = 1$ it si called Hamiltonian.-->

* 오디오 데이터: 1-D 도메인, 시간에 따라 구분된 신호; 채널수 범위는 1(모노), 2(스테레오), 5+1(돌비 5.1) 등입니다.
* 이미지 데이터: 2-D 도메인(픽셀); $c$의 범위는 1(회색톤), 3(컬러), 20(초분광) 등입니다.
* 특수 상대성: 도메인은 $\mathbb{R^4} \times \mathbb{R^4}$ (시공간 $\times\$ 사차원 운동량); $c=1$일 때, 해밀턴이라 부릅니다.

<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig7.png" width="600px" /><br>
<b>그림 7</b>: 다른 타입을 가지는 신호의 다른 차원<!--Different dimensions of different types of signals.--><br>
</center>
