---
lang-ref: ch.03-2
lecturer: Yann LeCun
title: 합성곱 신경망의 진화, 구조, 적용 방법과 강점들.
authors: Chris Ick, Soham Tamba, Ziyu Lei, Hengyu Tang
date: 10 Feb 2020
lang: ko
translate-date: 27 Mar 2020
translator: Wonseon
---


<!-- ## [Proto-CNNs and evolution to modern CNNs](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=2949s) -->
## [Proto-CNN과 현대 CNN으로의 진화](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=2949s)

<!-- ### Proto-convolutional neural nets on small data sets -->
### Proto-convolutional 적은 양의 데이터셋을 이용한 신경망

<!-- Inspired by Fukushima's work on visual cortex modelling, using the simple/complex cell hierarchy combined with supervised training and backpropagation lead to the development of the first CNN at University of Toronto in '88-'89 by Prof. Yann LeCun. The experiments used a small dataset of 320 'mouser-written' digits. Performances of the following architectures were compared:-->

얀 르쿤은 88년, 89년에 걸쳐 토론토 대학에서 첫 CNN 개발을 이뤄냈다. 이 연구는 쿠니히코 후쿠시마의 시각 피질 모델링에 영감을 얻어 단순/복잡 세포 위계를 지도 학습<sup>supervised training</sup>과 역전파<sup>backpropagation</sup>에 적용함으로써 가능했던 결과였다. 해당 연구는 320개의 mouser-written 숫자들을 사용했고, 아래 신경망 구조들의 퍼포먼스가 비교되었다:


<!-- 1. Single FC(fully connected) Layer
2. Two FC Layers
3. Locally Connected Layers w/o shared weights
4. Constrained network w/ shared weights and local connections
5. Constrained network w/ shared weights and local connections 2 (more feature maps) -->

1. 단일 완전 연결 계층
2. 다중 완전 연결 계층
3. 공유 가중치<sup>shared weights</sup>가 없는 불완전 연결 계층<sup>Locally Connected Layers</sup>
4. 불완전 연결과 공유 가중치가 있는 제한 신경망<sup>Constrained network</sup>
5. 불완전 연결과 공유 가중치가 있는 제한 신경망 2 (특징지도<sup>feature map</sup>가 더 많음)

<!-- The most successful networks (constrained network with shared weights) had the strongest generalizability, and form the basis for modern CNNs. Meanwhile, singler FC layer tends to overfit. -->

가장 성공적인 신경망(공유 가중치가 있는 제한 신경망)이 가장 강한 일반화<sup>generalizability</sup> 가능성을 보였고,이 신경망이 현대적인 CNN들의 기초가 되었다. 반대로 단일 완전 연결 계층은 과적합<sup>overfit</sup>하는 경향을 보였다.


<!-- ### First "real" ConvNets at Bell Labs -->
### Bell Labs의 첫 '진짜' 합성곱 신경망

<!-- After moving to Bell Labs, LeCunn's research shifted to using handwritten zipcodes from the US Postal service to train a larger CNN: -->
Bell Labs로 옮겨간 이후 르쿤의 연구는 더 큰 CNN을 학습시키기 위해 미국 우편국에서 얻은 수기 우편번호 데이터를 활용하기 시작했다.

<!-- * 256 (16$\times$16) input layer
* 12 5$\times$5 kernels with stride 2 (stepped 2 pixels): next layer has lower resolution
* **NO** separate pooling -->

* 256 (16$\times$16) 입력 계층
* 12 5$\times$5 의 stride 2 (2픽셀씩 옮겨감)를 가지는 커널 : 뒤에 오는 계층은 더 낮은 해상도를 가진다.
* 개별적 풀링은 **하지 않음**

<!-- ### Convolutional network architecture with pooling -->
### 풀링을 사용한 합성곱 신경망 구조

<!-- The next year, some changes were made: separate pooling was introduced. Separate pooling is done by averaging input values, adding a bias, and passing to a nonlinear function (hyperbolic tangent function). The 2$\times$2 pooling was performed with a stride of 2, hence reducing resolutions by half. -->

그 다음해, 몇개의 변경사항이 있었다: 개별적 풀링을 사용하게 되었다. 개별적 풀링은 입력 값들의 평균을 구하고, 편향치를 더하고, 이를 비선형함수에(하이퍼볼릭 탄젠트 함수<sup>hyperbolic tangent function</sup>)에 넣음으로써 이루어진다. 2$\times$2 풀링은 stride 2에 의해 해상도를 반으로 줄임으로써 구현되었다.

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/detailed_convNet.png" width="600px" /><br>
    <!-- <b>Fig. 1</b> ConvNet Architecture -->
    <b>Fig. 1</b> 합성곱 신경망 구조
</center>

<!-- An example of a single convolutional layer would be as follows:
1. Take an input with size *32$\times$32*
2. The convolution layer passes a 5$\times$5 kernel with stride 1 over the image, resulting feature map size *28$\times$28*
3. Pass the feature map to a nonlinear function: size *28$\times$28*
4. Pass to the pooling layer that averages over a 2$\times$2 window with stride 2: size *14$\times$14*
5. Repeat 1-4 for 4 kernels -->

아래에 단일 합성곱 계층의 예시를 나열했다.
1. *32$\times$32* 의 입력값을 준비한다.
2. 합성곱 계층이 stride 1과 5$\times$5의 커널을 이미지에 적용하여, *28$\times$28* 크기의 특징지도<sup>feature map</sup>를 만들어낸다.
3. 비선형 함수에 특징지도를 넣는다: 크기 *28$\times$28*
4. 2$\times$2 틀에 stride 2를 가지는 풀링 계층에 통과시킨다: 크기 *14$\times$14*
5. 4개의 커널에 대해 1-4단계를 반복한다.

<!-- The first-layer, simple convolution/pool combinations usually detect simple features, such as oriented edge detections. After the first convolution/pool layer, the objective is to detect combinations of features from previous layers. To do this, steps 2 to 4 are repeated with multiple kernels over previous-layer feature maps, and are summed in a new feature map: -->

보통 간단한 합성곱/풀로 이루어진 첫번째 계층은 윤곽과 같은 간단한 특징을 감지한다. 그 다음 계층의 목표는 이전 계층에서 넘어온 특징들의 조합을 감지하는 것이다. 이런 감지를 해내기위해 여러개의 커널을 이용해, 바로 이전 계층이 만들어낸 특징지도를 대상으로 위에서 서술한 2 ~ 4단계를 반복하여 새로운 특징지도로 재조합된다.

<!-- 1. A new 5$\times$5 kernel is slid over all feature maps from previous layers, with results summed up. (Note: In Prof. LeCun's experiment in 1989 the connection is not full for computation purpose. Modern settings usually enforce full connections): size *10$\times$10*
2. Pass the output of the convolution to a nonlinear function: size *10$\times$10*
3. Repeat 1/2 for 16 kernels.
4. Pass the result to the pooling layer that averages over 2$\times$2 window with stride 2: size *5$\times$5* each feature map -->

1. 새로운 5$\times$5 커널이 이전 계층의 모든 특징 지도들을 처리하면서 결과를 모두 더한다. (참고: 1989년도에 진행된 르쿤의 실험에서는 계산 목적으로 모든 계층을 완전히 연결하지 않았다. 그러나 현대의 환경은 보통 완전히 연결되도록 강제한다.) : 크기 *10$\times$10*
2. 합성곱의 결과값을 비선형 함수에 집어 넣는다: 크기 *10$\times$10*
3. 1,2 단계를 16개의 커널에 대해 반복한다.
4. 결과값을 stride 2값을 가지는 2$\times$2 틀로 평균값을 내는 풀링 계층에 전달한다: 각 특징 지도의 크기 *5$\times$5*

<!-- To generate an output, the last layer of convolution is conducted, which seems like a full connections but indeed is convolutional. -->
결과값을 만들어내기 위해 합성곱 신경망의 가장 마지막 계층이 적용된다. 이 계층은 완전히 연결된 모양으로 보이겠지만, 실제로는 합성곱이다.

<!-- 1. The final convolution layer slides a 5$\times$5 kernel over all feature maps, with results summed up: size *1$\times$1*
2. Pass through nonlinear function: size *1$\times$1*
3. Generate the single output for one category.
4. Repeat all pervious steps for each of the 10 categories(in parallel) -->
1. 최후의 합성곱 계층이 5$\times$5 크기의 커널을 이용해 결과값들을 더하며 모든 특징지도를 훑는다: 크기 *1$\times$1*
2. 비선형 함수에 넣는다: 크기 *1$\times$1*
3. 하나의 분류에 해당하는 단일 결과를 만들어낸다.
4. 10개의 분류에 대해서 이전의 모든 단계를 반복한다(동시에).

<!-- See [this animation](http://cs231n.github.io/convolutional-networks/) on Andrej Karpathy's website on how convolutions change the shape of the next layer's feature maps. Full paper can be found [here](https://papers.nips.cc/paper/293-handwritten-digit-recognition-with-a-back-propagation-network.pdf). -->

Andrej Karpathy의 웹사이트에 있는 [애니메이션](http://cs231n.github.io/convolutional-networks/)에서 어떻게 합성곱이 다음 계층의 모양을 바꾸는지 볼 수 있다. 완전한 논문은 [여기](https://papers.nips.cc/paper/293-handwritten-digit-recognition-with-a-back-propagation-network.pdf)에서 볼 수 있다.

<!-- ### Shift equivariance -->
### 전이 등가성질

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/shift_invariance.gif" width="600px" /><br>
    <!-- <b>Fig. 2</b> Shift Equivariance -->
    <b>Fig. 2</b> 전이 등가성질
</center>

<!-- As demonstrated by the animation on the slides(here's another example), translating the input image results in same translation of the feature maps. However, the changes in feature maps are scaled by convolution/pooling operations. E.g. the 2$\times$2 pooling with stride 2 will reduce the 1-pixel shift in input layer to 0.5-pixel shift in the following feature maps. Spatial resolution is then exchanged for increased number of feature types, i.e. making the representation more abstract and less sensitive to shifts and distortions. -->
슬라이드에 있는 애니메이션에서 볼 수 있듯이 입력 이미지를 변형시키는 것은 특징지도에도 같은 변형을 일으키게 된다. 그러나, 특징지도의 변화는 합성곱/풀의 작동에 의해 조절되게 된다. 예를 들어 stride 2값을 가지는 2$\times$2의 풀링은 입력 계층의 1-픽셀 전이를 특징 지도의 0.5픽셀 전이로 줄여 계산한다. 공간 해상도<sup>spatial resolution</sup>는 특징 종류에 따라 증가된 숫자에 교환된다. 이런 방식으로 정보는 더 추상적이고, 변형과 뒤틀림에 영향을 덜 받게 된다.


<!-- ### Overall architecture breakdown -->
### 전체적인 구조 들여다보기

<!-- Generic CNN architecture can be broken down into several basic layer archetypes: -->
CNN 구조는 여러가지 기본적인 기본 계층 구조로 나눠볼수 있다.

<!-- * **Normalisation**
  * Adjusting whitening (optional)
  * Subtractive methods e.g. average removal, high pass filtering
  * Divisive: local contrast normalisation, variance normalisation -->
* **정규화**
    * 백색화 조정하기 (선택적)
    * 감쇠 방법 예) 평균값 조정, high pass filtering
    * 분할: 로컬 대비 평준화, 분산 정규화

<!-- * **Filter Banks**
  * Increase dimensionality
  * Projection on overcomplete basis
  * Edge detections -->
* **필터 뱅크**
    * 차원 더하기
    * 과도한 기저 투영
    * 윤곽 감지

<!-- * **Non-linearities**
  * Sparsification
  * Typically Rectified Linear Unit (ReLU): $\text{ReLU}(x) = \max(x, 0)$ -->
* **비선형**
    * 희소화
    * 전형적인 ReLU : $\text{ReLU}(x) = \max(x, 0)$

<!-- * **Pooling**
  * Aggregating over a feature map
  * Max Pooling: $\text{MAX}= \text{Max}_i(X_i)$

  * LP-Norm Pooling:  $$\text{L}p= \left(\sum_{i=1}^n \|X_i\|^p \right)^{\frac{1}{p}}$$

  * Log-Prob Pooling:  $\text{Prob}= \frac{1}{b} \left(\sum_{i=1}^n e^{b X_i} \right)$ -->

* **풀링**
    * 특징지도 집계하기
    * 맥스 풀링: $\text{MAX}= \text{Max}_i(X_i)$
    
    * LP-Norm 풀링: $$\text{L}p= \left(\sum_{i=1}^n \|X_i\|^p \right)^{\frac{1}{p}}$$

    * Log-Prob 풀링:  $\text{Prob}= \frac{1}{b} \left(\sum_{i=1}^n e^{b X_i} \right)$


<!-- ## [LeNet5 and digit recognition](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=3830s) -->
## [LeNet5과 숫자 인식](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=3830s)

<!-- ### Implementation of LeNet5 in PyTorch -->
### PyTorch에 LeNet5 이식하기

<!-- LeNet5 consists of the following layers (1 being the top-most layer): -->
LeNet5에는 다음과 같은 계층들이 포함된다. (1이 가장 윗 계층이 된다):

<!-- 1. Log-softmax
2. Fully connected layer of dimensions 500$\times$10
3. ReLu
4. Fully connected layer of dimensions (4$\times$4$\times$50)$\times$500
5. Max Pooling of dimensions 2$\times$2, stride of 2.
6. ReLu
7. Convolution with 20 output channels, 5$\times$5 kernel, stride of 1.
8. Max Pooling of dimensions 2$\times$2, stride of 2.
9. ReLu
10. Convolution with 20 output channels, 5$\times$5 kernel, stride of 1. -->

1. 로그-소프트맥스
2. 500$\times$10 차원의 완전 연결 계층
3. ReLu
4. (4$\times$4$\times$50)$\times$500 차원의 완전 연결 계층
5. 2$\times$2 차원, stride 2 의 맥스 풀링.
6. ReLu
7. 합성곱을 이용한 5$\times$5 커널, stride 1를 통한 20개의 결과 채널
8. 2$\times$2 차원, stride 2 의 맥스 풀링.
9. ReLu
10. 합성곱을 이용한 5$\times$5 커널, stride 1을 통한 20개의 결과 채널.


<!-- The input is a 32$\times$32 grey scale image (1 input channel). -->
입력은 32$\times$32 흑백1도의 이미지다. (1개의 인풋 채널)

<!-- LeNet5 can be implemented in PyTorch with the following code: -->
LeNet5 는 아래 코드를 통해 PyTorch에 구현할 수 있다.

```python
class LeNet5(nn.Module):
    def __init__(self):
        super().__init__()
        self.conv1 = nn.Conv2d(1, 20, 5, 1)
        self.conv2 = nn.Conv2d(20, 20, 5, 1)
        self.fc1 = nn.Linear(4*4*50, 500)
        self.fc2 = nn.Linear(500, 10)

    def forward(self, x):
    x = F.relu(self.conv1(x))
    x = F.max_pool2d(x, 2, 2)
    x = F.relu(self.conv2(x))
    x = F.max_pool2d(x, 2, 2)
    x = x.view(-1, 4*4*50)
    x = F.relu(self.fc1)
    x = self.fc2(x)
    return F.logsoftmax(x, dim=1)
```

<!-- Although `fc1` and `fc2` are fully connected layers, they can be thought of as convolutional layers whose kernels cover the entire input. Fully connected layers are used for efficiency purposes. -->
`fc1`와 `fc2`는 완전 연결 계층이지만, 커널아 입력 전체를 다 덮을 수 있는 합성곱으로 빗대어 생각해볼 수도 있다.
완전 연결 계층은 효율성을 위해 사용된다.

<!-- The same code can be expressed using `nn.Sequential`, but it is outdated. -->
위와 같은 코드는 `nn.Sequential`를 이용해서도 구현할 수 있지만, 이는 오래된 방법이다.

<!-- ## Advantages of CNN -->
## CNN의 장점

<!-- In a fully convolutional network, there is no need to specify the size of the input. However, changing the size of the input changes the size of the output. -->
완전 연결된 합성곱 신경망에서 입력 사이즈를 정의할 필요는 없다. 그렇지만, 입력 사이즈를 바꾸면 출력 사이즈도 변하게 된다.

<!-- Consider a cursive hand-writing recognition system. We do not have to break the input image into segments. We can apply the CNN over the entire image: the kernels will cover all locations in the entire image and record the same output regardless of where the pattern is located. Applying the CNN over an entire image is much cheaper than applying it at multiple locations separately. No prior segmentation is required, which is a relief because the task of segmenting an image is similar to recognizing an image. -->
가상의 필기체 인식 시스템이 있다고 상상해보자. 입력 이미지를 작은 단위로 나눌 필요는 없이 전체 이미지에 CNN을 적용하면 된다: 커널이 이미지 전체, 모든 부분을 감싸게 되고, 패턴이 어디에 있든 같은 출력값이 나온다. CNN을 이미지 전체에 적용하는 방법은 여러 부분에 각각 적용하는 것 보다 훨씬 경제적이다. 다행히도 이미지를 인식하는 것과 거의 비슷한 일인 이미지를 분할하는 일은 굳이 하지 않아도 된다.   


<!-- ### Example: MNIST -->
### 예시: MNIST

<!-- LeNet5 is trained on MNIST images of size 32$\times$32 to classify individual digits in the centre of the image. Data augmentation was applied by shifting the digit around, changing the size of the digit, inserting digits to the side. It was also trained with an 11-th category which represented none of the above. Images labelled by this category were generated either by producing blank images, or placing digits at the side but not the centre. -->
LeNet5는 가운데 위치한 각각의 숫자를 인식할 수 있도록 32$\times$32 크기의 MNIST 이미지를 학습했다. 숫자를 이리저리 옮기고, 사이즈를 변화시키거나, 귀퉁이에 숫자를 끼워넣음으로써 데이터를 확장한다. '아무것에도 해당하지 않음'을 표시하는 11번째 카테고리를 포함하여 학습하기도 했다. 이 카테고리로 라벨링이 된 이미지는 검은 이미지를 생성하거나 귀퉁이에만 숫자를 배치함으로써 생성되었다. 

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/various_input.gif" width="600px" /><br>
    <!-- <b>Fig. 3</b> Sliding Window ConvNet -->
    <b>Fig. 3</b> 합성곱 신경망의 틀을 움직이기
</center>


<!-- The above image demonstrates that a LeNet5 network trained on 32$\times$32 can be applied on a 32$\times$64 input image to recognise the digit at multiple locations. -->
위의 이미지는 32$\times$32에 LeNet5으로 학습한 신경망이 32$\times$64 입력 이미지에 있는 다양한 숫자를 인식할 수 있음을 보여준다.

<!-- ## [Feature binding problem](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=4827s) -->
## [특징 바인딩 문제](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=4827s)

<!-- ### What is the feature binding problem? -->
### 특징 바인딩 문제란?

<!-- Visual neural scientists and computer vision people have the problem of defining the object as an object. An object is a collection of features, but how to bind all of the features to form this object? -->
시각 신경학자와 컴퓨터 비전 연구자들은 물체를 물체로 정의하는 법에 대한 문제를 겪고 있다. 물체는 특징의 총체지만, 어떻게 특징들을 하나로 묶어 하나의 물체가 되도록 만들 수 있을까?


<!-- ### How to solve it? -->
### 어떻게 해결할 것인가

<!-- We can solve this feature binding problem by using a very simple CNN: only two layers of convolutions with poolings plus another two fully connected layers without any specific mechanism for it, given that we have enough non-linearities and data to train our CNN. -->
이 특징 바인딩 문제는 아주 간단한 CNN을 통해 해결할 수 있다: 충분한 비선형성과 CNN을 학습시킬 데이터가 충분하다는 전제하에, 별다른 특정한 작동원리 없이 단 두개의 풀링과 합성곱 계층과 풀링, 그리고 또 다른 두개의 완전 연결 계층만 있으면 된다.

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/feature_binding.gif" width="600px" /><br>
    <!-- <b>Fig. 4</b> ConvNet Addressing Feature Binding -->
    <b>Fig. 4</b> 합성곱 신경망에서 특징 바인딩 다루기
</center>

<!-- The above animation showcases the ability of CNN to recognize different digits by moving a single stroke around, demonstrating its ability to address feature binding problems, i.e. recognizing features in a hierarchical, compositional way. -->
위의 애니메이션은 CNN이 단 하나의 선을 움직이며 다양한 숫자를 인식하는 모습을 보여주며, 어떻게 특징 바인딩 문제를 해결할 수 있는지 보여준다. 위계적으로, 조합적으로 특징을 인식하는 방법을 보여준다.


<!-- ### Example: dynamic input length -->
### 예: 다양한 입력 길이

<!-- We can build a CNN with 2 convolution layers with stride 1 and 2 pooling layers with stride 2 such that the overall stride is 4. Thus, if we want to get a new output, we need to shift our input window by 4. To be more explicit, we can see the figure below (green units). First, we have an input of size 10, and we perform convolution of size 3 to get 8 units. After that, we perform pooling of size 2 to get 4 units. Similarly, we repeat the convolution and pooling again and eventually we get 1 output. -->
stride 1을 가지는 2개의 합성곱 신경망 계층과 stride 2를 가지는 2개의 풀링 계층으로 이루어진 CNN을 만들어 전체 stride가 4가 되도록 할 수 있다. 그러므로 새로운 출력값을 얻고싶다면, 입력 틀을 4만큼씩 움직여야한다. 더 자세하게 보자면, 아래 사진의 초록 뉴런을 참고해볼 수 있다. 처음에 입력값의 크기는 10이다. 여기에 크기 3의 합성곱을 수행해 8개의 뉴런를 얻는다. 그리고선 크기 2의 풀링을 실행해 4개의 뉴런을 얻는다. 이렇게 합성곱과 풀링을 반복하여 최종적으로 단 하나의 출력값을 얻을때 까지 계속한다. 

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/example.jpg" width="600px" /><br>
    <!-- <b>Fig. 5</b> ConvNet Architecture On Variant Input Size Binding -->
    <b>Fig. 5</b> 다양한 입력 크기 바인딩에 대한 합성곱 신경망 구조
</center>

<!-- Let’s assume we add 4 units at the input layer (pink units above), so that we can get 4 more units after the first convolution layer, 2 more units after the first pooling layer, 2 more units after the second convolution layer, and 1 more output. Therefore, window size to generate a new output is 4 (2 stride $\times$2)the overall subsampling we have shown from input to output is 4 (2x2). Moreover, this is a demonstration of the fact that if we increase the size of the input, we will increase the size of every layer, proving CNNs' capability in handling dynamic length inputs. -->
4개의 입력 계층이 있다고 가정해보자. 첫 합성곱 계층 이후에 4개의 뉴런을 더 가지고 (위에 보이는 핑크색 뉴런), 첫 풀링 계층 이후에 2개의 뉴런을 더 두번째 합성곱 계층에 2개더, 출력 계층에 1개 더 뉴런을 가질 수 있다. 새로운 출력을 만들기 위한 틀의 크기는 4 ((2 stride $\times$2))가 된다. 여기에 더해 이것은 우리가 입력값의 크기를 키우면, 모든 계층의 사이즈를 키우게 되고, CNN이 다양한 길이의 입력값을 감당할 수 있다는 것을 증명할 수 있게 된다. 



<!-- ## What are CNN good for -->
## CNN은 어디에 써야할까

<!-- CNN are good for signals that come to you in the form of multidimensional arrays. These signals have three major characters. -->
CNN은 다차원 행렬로 정보를 받을때 유용하다. 이런 정보들은 3가지 주요 특성을 가진다.

<!-- 1. **Locality**: The first one is that there is a strong local correlation between values. If we take two nearby pixels of a natural image, those pixels are very likely to have the same colour. As two pixels become further apart, the similarity between them will decrease. The local correlations can help us detect local features, which is what the CNNs are doing. If we feed the CNN with permuted pixels, it will not perform well at recognizing the input images, while FC will not be affected. The local correlation justifies local connections. -->
1. **지역성**: 첫번째 특성은 각 값들 사이에 강한 지역적 연관성이 있다는 것이다. 만약 우리가 원본 이미지에서 서로 인접한 두개의 픽셀을 선택한다면, 이 두개의 픽셀은 같은 컬러값을 가질 확률이 매우 높다. 이 두개 픽셀의 거리가 점점 먼것일 수록, 두개 사이의 연관성은 줄어들게 된다. 이런 지역적 연관성은 우리가 지역적 특징을 찾는데 도움을 준다. 이것이 바로 CNN이 하는 일이다. 만약 우리가 CNN에 순열 이미지를 사용한다면, 완전 연결 계층은 별로 영향을 받지 않을 것이고, 입력 이미지를 인식하는 일을 잘 하지 못하게 될 것이다. 지역적 연관성이 있기에 지역적 연결이 있을 수 있다.

<!-- 2. **Stationarity**: Second character is that the features are essential and can appear anywhere on the image, justifying the shared weights and pooling. Moreover, statistical signals are uniformly distributed, which means we need to repeat the feature detection for every location on the input image. -->
2. **고정성** : 두번째 특성은 특징은 필수적이고 이미지 어디에나 나타남으로써 공유 가중치와 풀링을 정당화한다. 더 나아가 정적인 정보들은 균일하게 배포되기 때문에, 우리는 모든 특징 감지를 입력 이미지 모든 곳에서 수행해야한다.


<!-- 3. **Compositionality**: Third character is that the natural images are compositional, meaning the features compose an image in a hierarhical manner. This justifies the use of multiple layers of neurons, which also corresponds closely with Hubel and Weisel's research on simple and complex cells. -->
3.  **구성성**: 세번째 특성은 특징들이 각각 위계를 이루는 형태고 모여 이미지를 구성하고 있다는 점이다. 이런 특성이 여러개의 신경을 가진 다층 계층을 사용하는 이유를 설명해주며, 이것은 허벨과 와이젤의 단순/복잡 세포에 대한 연구와도 대응되는 부분이다.

<!-- Furthermore, people make good use of CNNs on videos, images, texts, and speech recognition. -->
여기에 더해 사람들은 비디오, 이미지, 텍스트, 발화 이해에 CNN을 잘 이용하고 있다.