---
lang-ref: ch.03-1
lecturer: Yann LeCun
title: 신경망의 매개변수 변환에 대한 시각화와 합성곱의 기본 개념
authors: Jiuhong Xiao, Trieu Trinh, Elliot Silva, Calliea Pan
date: 10 Feb 2020
lang: ko
translator: Jinwoo Oh
translate-date: 03 April 2020
---

## [신경망 시각화](https://youtu.be/FW5gFiJb-ig)

<!--
In this section we will visualise the inner workings of a neural network.
-->
이 절에서는 아래 그림 1과 같이 신경망 내부가 어떻게 동작하는지 구조를 알아보겠다. 

<center><img src="{{site.baseurl}}/images/week03/03-1/Network.png" alt="Network" style="zoom:35%;" /><br>
그림. 1 신경망 구조</center><br>  
  
  
<!--Figure 1 depicts the structure of the neural network we would like to visualise. Typically, when we draw the structure of a neural network, the input appears on the bottom or on the left, and the output appears on the top side or on the right. In Figure 1, the pink neurons represent the inputs, and the blue neurons represent the outputs. In this network, we have 4 hidden layers (in green), which means we have 6 layers in total (4 hidden layers + 1 input layer + 1 output layer). In this case, we have 2 neurons per hidden layer, and hence the dimension of the weight matrix ($W$) for each layer is 2-by-2. This is because we want to transform our input plane into another plane that we can visualize.
-->
일반적으로 신경망의 구조를 그릴 때, 입력은 아래나 왼쪽에 나타내고 출력은 위나 오른쪽에 나타낸다. 그림 1을 보면, 분홍색 뉴런은 입력을 나타내고 파란색 뉴런은 출력을 나타내며, 4개의 초록색 은닉층<sup>Hidden Layers</sup>을 가지고 있다. 즉, 총 6개 층으로, 4개의 은닉층과 1개의 입력 층, 1개의 출력 층을 가지고 있다. 이 예시에서 보여주는 신경망은 각 은닉층마다 2개의 뉴런을 가지고 있으므로, 각 층별 가중치 행렬 ($W$)의 차원은 2X2가 된다. 이는 입력 평면을 시각화가 가능한 다른 평면으로 변환하고자 하기 때문이다.  
  
<center><img src="{{site.baseurl}}/images/week03/03-1/Visual1.png" alt="Network" style="zoom:35%;" /><br>
그림. 2 접힘 평면<sup>Folding space</sup></center><br>  
  
<!-- The transformation of each layer is like folding our plane in some specific regions as shown in Figure 2. This folding is very abrupt, this is because all the transformations are performed in the 2D layer. In the experiment, we find that if we have only 2 neurons in each hidden layer, the optimization will take longer; the optimization is easier if we have more neurons in the hidden layers. This leaves us with an important question to consider: Why is it harder to train the network with fewer neurons in the hidden layers? You should consider this question yourself and we will return to it after the visualization of $\texttt{ReLU}$.
-->
각 층의 변환은 그림 2에서 보여지는 것처럼 특정 지역에서 평면을 접는 것과 같다. 2차원 계층에서 모든 변환이 이루어지기 때문에, 매우 갑작스럽게 접히게 된다. 각 은닉층에 2개의 뉴런만 있다면 최적화가 더 오래 걸리고, 은닉층에 많은 뉴런이 있을수록 최적화가 더 쉬워진다는 것을 실험을 통해서 발견하였다. 여기서 "왜 더 적은 뉴런으로 신경망을 학습시키는 것이 더 어려울까?"라는 의문점을 남기게 될 것이고, 우리는 이러한 질문에 스스로 생각해 보아야 한다. $\texttt{ReLU}$를 시각화 해본 뒤에 다시 돌아와 생각해 보자.
  
| <img src="{{site.baseurl}}/images/week03/03-1/Visual2a.png" alt="Network" style="zoom:45%;" /> | <img src="{{site.baseurl}}/images/week03/03-1/Visual2b.png" alt="Network" style="zoom:45%;" /> |
|(a)|(b)|

<center>그림. 3 ReLU 연산</center>
   
   
<!--
When we step through the network one hidden layer at a time, we see that with each layer we perform some affine transformation followed by applying the non-linear ReLU operation, which eliminates any negative values. In Figures 3(a) and (b), we can see the visualisation of ReLU operator. The ReLU operator helps us to do non-linear transformations. After mutliple steps of performing an affine transformation followed by the ReLU operator, we are eventually able to linearly separate the data as can be seen in Figure 4.
-->
신경망의 은닉층을 하나씩 살펴보면, 각 계층마다 아핀 변환<sup>Affine Transformation</sup>을 일부 수행한 다음, 비선형 ReLU 연산을 하여 음수 값을 모두 제거하는 것을 볼 수 있다. ReLU 연산은 **비선형 변환**하는 데에 쓰이며, 그림 3(a)와 (b)는 이 ReLU 연산을 시각화한 것이다. ReLU 연산 후 아핀 변환을 수행하는 과정을 여러번 거치면, 그림 4에서 볼 수 있듯이 데이터를 선형적으로 분리할 수 있다.  
  
<br><center><img src="{{site.baseurl}}/images/week03/03-1/Visual3.png" alt="Network" style="zoom:30%;" /><br>
그림. 4 출력 시각화</center><br>  
  
  
<!--
This provides us with some insight into why the 2-neuron hidden layers are harder to train. Our 6-layer network has one bias in each hidden layers. Therefore if one of these biases moves points out of top-right quadrant, then applying the ReLU operator will eliminate these points to zero. After that, no matter how later layers transform the data, the values will remain zero. We can make a neural network easier to train by making the network "fatter" - i.e. adding more neurons in hidden layers - or we can add more hidden layers, or a combination of the two methods. Throughout this course we will explore how to determine the best network architecture for a given problem, stay tuned.
-->
 왜 2개 뉴런으로만 이루어진 은닉층이 학습하기 어려운 지에 대해 감이 올 것이다. 6-계층 신경망에는 각 은닉층마다 하나의 편향<sup>Bias</sup>이 있다. 이러한 편향 중 하나가 점을 우상단 사분면 밖으로 이동시키게 되고 ReLU 연산을 취하면, 그 점은 0으로 제거되버려서 그 이후 각 층에서 데이터를 어떻게 변환하든지 값은 0으로 유지된다. 우리는 은닉층에 뉴런을 추가하는 등 네트워크를 "더 무겁게" 만들어 신경망을 보다 더 쉽게 학습시킬 수 있다. 또는 은닉층을 더 추가하거나 앞의 두 방법을 조합하는 방법도 있다. 이러한 과정을 통해 우리는 주어진 문제에 가장 적합한 신경망 아키텍처를 결정하는 방법을 계속 탐구할 것이다.  
   
   
## [매개변수 변환 (Parameter Transformations)](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=477s)

<!--
General parameter transformation means that our parameter vector $w$ is the output of a function. By this transformation, we can map original parameter space into another space. In Figure 5, $w$ is actually the output of $H$ with the parameter $u$. $G(x,w)$ is a network and $C(y,\bar y)$ is a cost function. The backpropagation formula is also adapted as follows,
-->

일반적으로 매개변수를 변환한다는 것은 매개변수 벡터 $w$를 어떤 함수의 출력으로 본다는 것을 의미한다. 이 변환을 통해 원래 매개변수 공간을 다른 공간에 맵핑할 수 있다. 그림 5를 보면, $w$는 실제로 매개변수 $u$를 가진 $H$의 출력이다. $G(x,w)$는 신경망이며 $C(y,\bar y)$는 비용 함수<sup>Cost Function</sup>이다. 역전파<sup>Backpropagation</sup> 공식도 다음과 같이 조정된다.  

$$u \leftarrow u - \eta\frac{\partial H}{\partial u}^\top\frac{\partial C}{\partial w}^\top$$

$$w \leftarrow w - \eta\frac{\partial H}{\partial u}\frac{\partial H}{\partial u}^\top\frac{\partial C}{\partial w}^\top$$

<!--
These formulas are applied in a matrix form. Note that the dimensions of the terms should be consistent. The dimension of $u$,$w$,$\frac{\partial H}{\partial u}^\top$,$\frac{\partial C}{\partial w}^\top$ are $[N_u \times 1]$,$[N_w \times 1]$,$[N_u \times N_w]$,$[N_w \times 1]$, respectively. Therefore, the dimension of our backpropagation formula is consistent.
-->
이 공식들은 행렬 형태로 적용된다. Terms의 차원은 일정해야 한다는 것을 꼭 명심해야 한다. $u$,$w$,$\frac{\partial H}{\partial u}^\top$,$\frac{\partial C}{\partial w}^\top$의 차원은 각각 $[N_u \times 1]$,$[N_w \times 1]$,$[N_u \times N_w]$,$[N_w \times 1]$이다. 따라서 역전파 공식의 차원은 일정하다.  
  
  
<center><img src="{{site.baseurl}}/images/week03/03-1/PT.png" alt="Network" style="zoom:35%;" /><br>
그림. 5 일반적인 매개변수 변환 형태</center><br>


### 간단한 매개변수 변환법: 가중치 공유 (Weight Sharing)
---

<!--
A Weight Sharing Transformation means $H(u)$ just replicates one component of $u$ into multiple components of $w$. $H(u)$ is like a **Y** branch to copy $u_1$ to $w_1$, $w_2$. This can be expressed as,
-->
가중치 공유 변환법은 $H(u)$가 $u$의 한 구성 요소를 여러 개의 $w$ 구성 요소로 복제하는 것을 의미한다. $H(u)$는 $u_1$를 $w_1$, $w_2$에 복사하는 **Y** branch와 같다. 이는 다음과 같이 표현 될 수 있다.

$$
w_1 = w_2 = u_1, w_3 = w_4 = u_2
$$

<!--
We force shared parameters to be equal, so the gradient w.r.t. to shared parameters will be summed in the backprop. For example the gradient of the cost function $C(y, \bar y)$ with respect to $u_1$ will be the sum of the gradient of the cost function $C(y, \bar y)$ with respect to $w_1$ and the gradient of the cost function $C(y, \bar y)$ with respect to $w_2$.
-->

공유 매개 변수를 동일하게 해주면, 공유 매개 변수에 대한 기울기는 역전파되면서 합산된다. 예를 들어,  $u_1$에 대한 비용 함수 $C(y, \bar y)$의 기울기는 $w_1$에 대한 비용 함수 $C(y, \bar y)$의 기울기와 $w_2$에 대한 비용 함수 $C (y, \bar y)$의 기울기의 합이다.
<br>

### 하이퍼넷 (Hypernetwork)
---

<!--
A hypernetwork is a network where the weights of one network is the output of another network. Figure 6 shows the computation graph of a "hypernetwork". Here the function $H$ is a network with parameter vector $u$ and input $x$. As a result, the weights of $G(x,w)$ are dynamically configured by the network $H(x,u)$. Although this is an old idea, it remains very powerful.
-->
하이퍼넷은 한 네트워크의 가중치가 다른 네트워크의 출력으로 구성된 네트워크를 말한다. 그림 6은 하이퍼넷의 계산 그래프를 보여준다. 함수 $H$는 매개변수 벡터 $u$와 입력 $x$로 구성된 신경망이다. 결과적으로, $G(x,w)$의 가중치는 $H(x,u)$의 출력에 의해 동적으로 구성하게 된다. 이 아이디어는 오래전에 나왔지만 여전히 강력하다.

<br><center><img src="{{site.baseurl}}/images/week03/03-1/HyperNetwork.png" alt="Network" style="zoom:35%;" /><br>
그림. 6 "하이퍼넷"</center><br>


### 순차 데이터에서의 모티프 검출
---

<!--
Weight sharing transformation can be applied to motif detection. Motif detection means to find some motifs in sequential data like keywords in speech or text. One way to achieve this, as shown in Figure 7, is to use a sliding window on data, which moves the weight-sharing function to detect a particular motif (i.e. a particular sound in speech signal), and the outputs (i.e. a score) goes into a maximum function.
-->
우리는 모티프 검출<sup>Motif detection</sup>에 가중치 공유 변환을 응용할 수 있다. 모티프 검출이란 음성이나 글에 있는 "키워드"처럼 순차 데이터에 있는 모티프를 찾는 것을 말한다. 그림 7과 같이, 모티프 검출을 하기 위한 방법 중의 하나로 데이터에 슬라이딩 윈도우를 사용하는 것을 들 수 있다. 여기서, 특정 모티프(예를 들어, 음성 신호에서 특정 소리)를 검출하기 위해 가중치 공유 함수를 이동하고 출력(i.e. 점수<sup>Score</sup>)을 Maximum 함수로 넣어준다.


<br><center><img src="{{site.baseurl}}/images/week03/03-1/Motif.png" alt="Network" style="zoom:30%;" /><br>
Fig. 7 순차 데이터에서 모티프 검출</center><br>

<!--
In this example we have 5 of those functions. As a result of this solution, we sum up five gradients and backpropagate the error to update the parameter $w$. When implementing this in PyTorch, we want to prevent the implicit accumulation of these gradients, so we need to use `zero_grad()` to initialize the gradient.
-->
이 예제에는 5개의 함수가 있다. 결과적으로 보면, 기울기 5개를 더하고 오류<sup>Error</sup>를 역전파하여 $w$ 매개변수를 업데이트 한다. PyTorch에서 구현할 때에는, 이 기울기들이 안쪽에서 축적되는 것을 막아야 하는데, 기울기를 초기화하기 위해 `zero_grad ()`를 사용해야 한다.


### 이미지에서의 모티프 검출
---
<!--
The other useful application is motif detection in images. We usually swipe our "templates" over images to detect the shapes independent of position and distortion of the shapes. A simple example is to distinguish between "C" and "D", as Figure 8 shows. The difference between "C" and "D" is that "C" has two endpoints and "D" has two corners. So we can design "endpoint templates" and "corner templates". If the shape is similar to the "templates", it will have thresholded outputs. Then we can distinguish letters from these outputs by summing them up. In Figure 8, the network detects two endpoints and zero corners, so it activates "C".
-->
모티프 검출은 이미지에서도 유용하게 쓰인다. 일반적으로 이미지 위에 "템플릿"을 움직여가며 형상의 위치나 왜곡과 무관하게 검출한다. 간단히 예를 들자면, 그림 8과 같이 "C"와 "D"를 구별하는 것이다. "C"에는 두 개의 끝점<sup>End point</sup>이 있고 "D"에 두 개의 모서리<sup>Corner</sup>가 있다는 것이 "C"와 "D"의 차이점이다. 따라서 "끝점 템플릿"과 "모서리 템플릿"을 설계한다. 형상이 이 "템플릿"과 유사하면 출력이 임계 값<sup>Threshold</sup>을 가지고, 이들을 합산하여 출력의 글자를 구별 할 수 있다. 그림 8에서 네트워크는 두 개의 끝점과 모서리를 감지하여 "C"를 활성화한다.


<br><center><img src="{{site.baseurl}}/images/week03/03-1/MotifImage.png" alt="Network" style="zoom:35%;" /><br>
Fig. 8 이미지에서의 모티프 검출</center><br>

<!--
It is also important that our "template matching" should be shift-invariant - when we shift the input, the output (i.e. the letter detected) shouldn't change. This can be solved with weight sharing transformation. As Figure 9 shows, when we change the location of "D", we can still detect the corner motifs even though they are shifted. When we sum up the motifs, it will activate the "D" detection.
-->
**템플릿 일치**<sup>Template matching</sup>는 입력의 위치가 바뀌었을 때에도 출력(i.e. 문자 검출)은 바뀌지 않는 이동 불변한<sup>Shift-invariant</sup> 특성이 있는데, 이 또한 중요하다. 가중치 공유 변환으로 이를 해결할 수 있다. 그림 9에서, "D"의 위치가 바뀌어도 여전히 모서리 모티프를 검출한 것을 볼 수 있다. 이러한 모티프들을 종합하면 "D" 검출이 활성화 된다.

<br><center><img src="{{site.baseurl}}/images/week03/03-1/ShiftInvariance.png" alt="Network" style="zoom:35%;" /><br>
그림. 9 이동 불변성</center><br>

<!--
This hand-crafted method of using local detectors and summation to for digit-recognition was used for many years. But it presents us with the following problem: How can we design these "templates" automatically? Can we use neural networks to learn these "templates"? Next, We will introduce the concept of **convolutions** , that is, the operation we use to match images with "templates".
-->
이처럼 국부 검출기<sup>Local detector</sup>를 사용하여 합산하는 고지식한 방법은 수 년간 숫자를 인식하는 데에 많이 사용되어 왔다. 하지만 이러한 방법을 통해 우리는 "어떻게 이 **템플릿**을 자동적으로 설계할 수 있을까?", "신경망을 **템플릿**을 학습하는 용도로 사용할 수 있을까?" 하는 생각하게 되었다. 다음으로, 이미지를 **템플릿**과 일치시키기 위해 사용하는 연산인 **합성곱**<sup>Convolutions</sup>의 개념을 소개할 것이다.



## 이산 합성곱 (Discrete convolution)


### 합성곱(Convolution)
---
<!--
The precise mathematical definition of a convolution in the 1-dimensional case between input $x$ and $w$ is:
-->
입력 $x$와 $w$의 1차원 합성곱에 대한 정확한 수학적 정의는 다음과 같다.

$$y_i = \sum_j w_j x_{i-j}$$

<!--
In words, the $i$-th output is computed as the dot product between the **reversed** $w$ and a window of the same size in $x$. To compute the full output, start the window at the beginning, shift this window by one entry each time and repeat until $x$ is exhausted.
-->
즉, $i$번째 출력은 **수정된** $w$와 같은 사이즈의 $x$ 윈도우 간에 내적<sup>Dot product</sup>를 계산한 것이다. 전체 출력을 계산하기 위해서는, $x$를 처음부터 시작하여 끝까지 윈도우를 이동시켜가며 이 과정을 반복하는 것이다.


### 교차 상관관계 (Cross-correlation)
---
<!--
In practice, the convention adopted in deep learning frameworks such as PyTorch is slightly different. Convolution in PyTorch is implemented where $w$ is **not reversed**:
-->
실제로는 PyTorch에서의 합성곱은 **반전되지 않은** $w$로 구현되어 조금 다른 관례<sup>Convention</sup>를 따랐다.

$$y_i = \sum_j w_j x_{i+j}$$
<!--
Mathematicians call this formulation "cross-correlation". In our context, this difference is just a difference in convention. Practically, cross-correlation and convolution can be interchangeable if one reads the weights stored in memory forward or backward.
-->
수학자들은 이 공식을 "교차 상관관계"라고 부른다. 합성곱과의 차이점은 단지 "관례"의 차이만 있을 뿐이다. 실제로 메모리에 저장된 가중치를 앞으로 읽는지 뒤로 읽는지에 따라 교차상관과 합성곱을 서로 바꿔 쓸 수 있다.

<!--
Being aware of this difference is important, for example, when one want to make use of certain mathematical properties of convolution/correlation from mathematical texts.
-->
예를 들어, 합성곱과 교차상관의 수학적 성질을 사용하고자 할 때 이러한 차이점을 인식하는 것이 중요하다.


### 고차원 합성곱
---
<!--
For two dimensional inputs such as images, we make use of the two dimensional version of convolution:
-->
이미지와 같이 2차원 입력의 경우에는 2차원 버전의 합성곱을 사용한다.

$$y_{ij} = \sum_{kl} w_{kl} x_{i+k, j+l}$$

<!--
This definition can easily be extended beyond two dimensions to three or four dimensions. Here $w$ is called the *convolution kernel*
-->
위 정의는 2차원을 넘어 3차원 또는 4차원으로 쉽게 확장할 수 있다. 여기서 $w$는 *합성곱 커널*<sup>Convolution Kernel</sup>이다.


### DCNN에서 합성곱 연산과 함께 쓰는 Regular twists
---

| 스트라이드 | 1 | 2 |
|: ------------ :|: -------------------------- :|: -------------------------- :|
| 출력 크기: | $\frac{100 - (5-1)}{1}=96$ | $\frac{100 - (5-1)}{2}=48$ |

<!--
1. **Striding**: instead of shifting the window in $x$ one entry at a time, one can do so with a larger step (for example two or three entries at a time). Example: Suppose the input $x$ is one dimensional and has size of 100 and $w$ has size 5. The output size with a stride of 1 or 2 is shown in the table below:
2. **Padding**: Very often in designing Deep Neural Networks architectures, we want the output of convolution to be of the same size as the input. This can be achieved by padding the input ends with a number of (typically) zero entries, usually on both sides. Padding is done mostly for convenience. It can sometimes impact performance and result in strange border effects, that said, when using a ReLU non-linearity, zero padding is not unreasonable.
-->

1. **스트라이드**<sup>Striding</sup>: $x$에서 윈도우를 한 번만 이동시키는 것 대신에, 한 번에 두 세번씩 더 큰 스텝을 진행할 수 있다.
예시: 입력 $x$가 1차원이고 크기가 100이며, $w$의 크기가 5라고 가정하자. 위 표는 스텝이 1 또는 2인 출력 크기를 보여주고 있다.

2. **패딩**<sup></sup>: 보통 심층 신경망<sup>Deep Neural Networks</sup> 아키텍처를 설계할 때, 입력의 양 끝단에 0으로 채워주는(일반적으로 0, 0이 아닐 수도 있음) 패딩을 해줌으로써 합성곱의 출력을 입력과 같은 크기로 만들어준다. 주로 패딩은 우리의 편의를 위해 사용하는 것이며, 때로는 성능에 영향을 주고, 이상한 Border Effect를 가져올 수 있다. 즉, ReLU 비선형성을 사용할 때에는 제로 패딩<sup>Zero padding</sup>을 사용하는 것은 괜찮은 방법이다.

  
## 심층 합성곱 신경망 (DCNNs: Deep Convolution Neural Networks)

<!--
As previously described, deep neural networks are typically organized as repeated alternation between linear operators and point-wise nonlinearity layers. In convolutional neural networks, the linear operator will be the convolution operator described above. There is also an optional third type of layer called the pooling layer.
-->
 앞서 기술한 바와 같이, 일반적으로 심층 신경망은 선형 연산자와 점별수렴 비선형 계층 사이에 반복 교대로 구성된다. 합성곱 신경망에서 선형 연산자는 앞서 말한 합성곱 연산자가 될 것이다. 풀링<sup>Pooling</sup> 계층라고 불리는 세 번째 옵션도 있다.  
  
<!--
The reason for stacking multiple such layers is that we want to build a hierarchical representation of the data. CNNs do not have to be limited to processing images, they have also been successfully applied to speech and language. Technically they can be applied to any type of data that comes in the form of arrays, although we also these arrays to satisfy certain properties.
-->
 이렇게 계층을 여러 겹 쌓는 이유는 데이터의 계층적 표현을 만들고자 하기 때문이다. 기술적으로 CNN은 배열의 형태를 가진 어떠한 유형의 데이터에도 적용될 수 있다. 즉, CNN은 이미지 및 영상 처리에만 국한되지 않고, 음성와 언어 처리에도 성공적으로 응용되고 있다.
  
  
<!--
Why would we want to capture the hierarchical representation of the world? Because the world we live in is compositional. This point is alluded to in previous sections. Such hierarchical nature can be observed from the fact that local pixels assemble to form simple motifs such as oriented edges. These edges in turn are assembled to form local features such as corners, T-junctions, etc. These edges are assembled to form motifs that are even more abstract. We can keep building on these hierarchical representation to eventually form the objects we observe in the real world.
--> 
 왜 우리는 이 세상을 위계적, 계층적으로 표현<sup>Hierarchical representation</sup>하려 하는가? 그 이유는 우리가 살고 있는 세상이 구성적<sup>Compositional</sup>이기 때문이라는 것을 이전 절에서 언급한 바가 있다. 국소 픽셀이 모여 지향적인 윤곽선<sup>Edge, 또는 경계선</sup> 같은 단순한 모티브를 만들어 낸다는 점에서 이러한 계층적 성질을 관찰할 수 있다. 이 윤곽선들은 훨씬 추상적인 모티브를 형성하기 위해 차례로 모여, 모서리나 T-교차점 등과 같은 국부적 특징을 형성한다. 이러한 계층적 표현을 계속해서 구축하며, 실제 우리가 현실 세계에서 관찰하는 대상을 만들어 낼 수 있다.  
  
  
<center><img src="{{site.baseurl}}/images/week03/03-1/cnn_features.png" alt="CNN Features" style="zoom:35%;" /><br>
그림 10. ImageNet에 학습된 합성곱 신경망의 특징<sup>Feature</sup> [Zeiler & Fergus 2013]</center><br>
  
<!--
This compositional, hierarchical nature we observe in the natural world is therefore not just the result of our visual perception, but also true at the physical level.
At the lowest level of description, we have elementary particles, which assembled to form atoms, atoms together form molecules, we continue to build on this process to form materials, parts of objects and eventually full objects in the physical world.
-->
자연 세계에서 관찰할 수 있는 이러한 구성적이고 계층적인 성질은, 시각적인 인식의 결과 뿐만 아니라 물리적 수준에서도 마찬가지로 적용된다. 가장 저수준으로 보면, 소입자가 모여 원자를 형성하고, 원자는 분자를 형성한다. 또한, 물리적으로 물질 및 물체의 일부, 완전한 물체를 형성하기 위해서는 이러한 과정을 계속 수행해야 한다.

<!--
The compositional nature of the world might be the answer to Einstein's rhetorical question on how humans understand the world they live in:
-->
이 세상의 구성적인 성질은 인간이 살고 있는 세계를 어떻게 이해하고 있는 지에 대한 아래의 아인슈타인의 수사적인 질문에 대한 답이 될 수 있을 것이다.

> The most incomprehensible thing about the universe is that it is comprehensible.  
> "우주에 관해서 가장 이해할 수 없는 것은 그것이 이해 가능하다는 사실이다."  
> 아인슈타인 (A. Einstein)  
  
<!--
The fact that humans understand the world thanks to this compositional nature still seems like a conspiracy to Yann. It is, however, argued that without compositionality, it will take even more magic for humans to comprehend the world they live in. Quoting the great mathematician Stuart Geman:
-->
얀 르쿤 교수님에게는 인간이 구성적인 성질로써 이 세상을 이해한다는 건 여전히 일종의 음모처럼 보인다. 그러나 얀 교수님은 저명한 미국의 수학자 Stuart Geman의 말을 인용하면서 구성성이 없다면 인간이 이 세계를 이해하는 데 어마어마한 마술이 필요할 것이라고 주장한다. 
  
> The world is compositional or God exists.  
> 이 세상은 구성적이거나, 신이 존재한다.  
> 미국의 수학자 스튜어트 게먼 (Stuart Geman)  


## [생물학에서의 영감](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=2254s)
<!--
So why should Deep Learning be rooted in the idea that our world is comprehensible and has a compositional nature? Research conducted by Simon Thorpe helped motivate this further. He showed that the way we recognize everyday objects is extremely fast. His experiments involved flashing a set of images every 100ms, and then asking users to identify these images, which they were able to do successfully. This demonstrated that it takes about 100ms for humans to detect objects. Furthermore, consider the diagram below, illustrating parts of the brain annotated with the time it takes for neurons to propagate from one area to the next:
-->
그렇다면 왜 딥러닝을 연구함에 있어서 '이 세상은 이해할 수 있고, **구성적인** 성질을 가지고 있다.'는 아이디어에 기반을 두어야 하는가? Simon Thorpe이 수행했던 연구로부터 이런 아이디어가 나왔다. 매 100ms마다 이미지 한 세트에 불빛을 비추고 피실험자들에게 이 이미지가 무엇인지 식별하라고 하였더니 알아 맞춘 실험으로, 우리가 일상에서 사물을 매우 빠르게 인식한다는 것을 보였다. 이 말은 즉슨, 사람이 물체를 감지하는 데 약 100ms 정도가 걸린다는 것이다. 아래 표는 뉴런이 한 영역에서 다음 영역으로 전파되는 데 걸리는 시간을 뇌 그림에 표기한 것이다.

<center><img src="{{site.baseurl}}/images/week03/03-1/Simon_Thorpe.png" alt="Simon_Thorpe" style="zoom:55%;" /></center>

<div align="center">그림 11. Simon Thorpe의 모델: 두뇌에서의 시각적 정보의 흐름 </div><br>

<!--
Signals pass from the retina to the LGN (helps with contrast enhancement, gate control, etc.), then to the V1 primary visual cortex, V2, V4, then to the inferotemporal cortex (PIT), which is the part of the brain where categories are defined. Observations from open-brain surgery showed that if you show a human a film, neurons in the PIT will fire only when they detect certain images -- such as Jennifer Aniston or a person's grandmother -- and nothing else. The neural firings are invariant to things such as position, size, illumination, your grandmother's orientation, what she's wearing, etc.
-->
신호는 망막에서부터 대비향상<sup>Contrast Enhancement</sup>과 관문 조절<sup>Gate Control</sup>을 돕는 외측슬상핵(LGN)<sup>Lateral Geniculate Nucleus</sup>까지 전달되며, 그다음 일차시각피질<sup>V1 primary visual cortex</sup>, V2, V4, 그리고 뇌의 일부인 하측두 피질(PIT)<sup>Inferotemporal cortex</sup>로 전달된다. Open-brain 수술에서 관찰한 바에 따르면, 영화에서 어떤 배우를 보았을 때 하측두 피질에 있는 뉴런은 배우의 같이 특정 이미지를 감지할 때만 활동한다고 한다. 뉴런 활동은 위치, 크기, 조명, 배우가 서 있는 방향, 입고 있는 옷 등의 요소에 영향을 받지 않는다.

<!--
Furthermore, the fast reaction times with which humans were able to categorize these items -- barely enough time for a few spikes to get through -- demonstrates that it's possible to do this without additional time spent on complex recurrent computations. Rather, this is a single feed-forward process.
-->
그러므로 인간이 사물을 인지하는 데에 걸리는 시간은 복잡하고 반복적인 계산에 시간을 쏟지 않고도 가능할 정도로 빠른 시간이라는 뜻이다. 정확히 말하자면, 이것은 하나의 피드포워드<sup>Feed-forward</sup> 과정이다.

<!--
These insights suggested that we could develop a neural network architecture which is completely feed-forward, yet still able to solve the problem of recognition, in a way that is invariant to irrelevant transformations of the input.
-->
이러한 발상은 입력의 변화에 무관하게 인지하지는 못하지만, 완전히 피드포워드로 구성되어 있는 신경망 아키텍처를 개발해 낼 수 있다는 것을 말해주었다.


<!--
One further insight from the human brain comes from Gallant & Van Essen, whose model of the human brain illustrates two distinct pathways:
-->
Gallant와 Van Essen은 다음과 그림과 같이 사람의 두뇌는 두 가지 경로가 있다는 또 다른 발상을 해내었다.

<center><img src="{{site.baseurl}}/images/week03/03-1/Gallant_and_Van_Essen.png" alt="Gallant_and_Van_Essen" style="zoom:55%;" /></center>

<div align="center">그림 12. Gallant와 Van Essen의 모델 : 등쪽경로, 배쪽경로</div><br>

<!--
The right side shows the ventral pathway, which tells you what you're looking at, while the left side shows the dorsal pathway, which identifies locations, geometry, and motion. They seem fairly separate in the human (and primate) visual cortex (with a few interactions between them of course).
-->
오른쪽은 배쪽경로<sup>Vental pathway</sup>로, 우리가 무엇을 보고 있는 지를 알려주고, 왼쪽은 등쪽경로<sup>Dorsal pathway</sup>로, 위치와 기하적인 구조, 동작을 식별한다. 이는 인간의 시각 피질<sup>Visual cortex </sup>에서 완전히 분리되는 것처럼 보이지만 약간의 상호작용이 있긴 하다.


### Hubel과 Weisel의 공헌 (1962)
---

<center><img src="{{site.baseurl}}/images/week03/03-1/Hubel_and_Weisel.png" alt="Hubel_and_Weisel" style="zoom:55%;" /></center>

<div align="center">그림 13. Hubel과 Weisel의 시각적 자극을 통한 고양이 두뇌 실험</div><br>

<!--
Hubel and Weisel experiments used electrodes to measure neural firings in cat brains in response to visual stimuli. They discovered that neurons in the V1 region are only sensitive to certain areas of a visual field (called "receptive fields"), and detect oriented edges in that area. For example, they demonstrated that if you showed the cat a vertical bar and start rotating it, at a particular angle the neuron will fire. Similarly, as the bar moves away from that angle, the activation of the neuron diminishes. These activation-selective neurons Hubel & Weisel named "simple cells", for their ability to detect local features.
-->
Hubel과 Weisel은 전극을 사용하여 시각적 자극에 대한 반응으로 고양이 두뇌에서의 뉴런 활동을 측정하는 실험을 하였다. 이 실험에서 V1 영역의 뉴런이 수용영역<sup>Receptive fields</sup>이라고 불리는 시야에서 특정 지역에서 민감하다는 것을 발견했다. 예를 들어, 고양이에게 세로 막대기를 보여주고 그 막대기를 회전시키면, 특정 각도에서 뉴런이 활동한다는 것을 증명했다. 비슷하게, 막대기가 그 각도에서 멀어질 수록 뉴런의 활성화 수치가 줄어들었다.

<!--
They also discovered that if you move the bar out of the receptive field, that particular neuron doesn't fire any more, but another neuron will. There are local feature detectors corresponding to all areas of the visual field, hence the idea that the human brain processes visual information as a collection of "convolutions".
-->
또한 만약 그 막대기를 시야 바깥으로 움직였을 때, 특정 뉴런이 활동을 멈추고 다른 뉴런이 활동하는 것을 발견하였다. 모든 시야에 상응하는 국부 피쳐 검출기<sup>Local feature detector</sup>가 존재하고, 인간의 두뇌가 여러 **"합성곱"** 으로 시각정 정보를 처리한다는 생각을 하게 되었다.

<!--
Another type of neuron, which they named "complex cells", aggregate the output of multiple simple cells within a certain area. We can think of these as computing an aggregate of the activations using a function such as maximum, sum, sum of squares, or any other function not depending on the order. These complex cells detect edges and orientations in a region, regardless of where those stimuli lie specifically within the region. In other words, they are shift-invariant with respect to small variations in positions of the input.
-->
"복합 세포"<sup>Complex cells</sup>라고 불리는 또 다른 타입의 뉴런은 특정 영역 내에 여러 단순한 세포들의 출력을 종합하는 역할을 한다. 우리는 이러한 복합세포들이 최대값<sup>Maximum</sup>, 합산<sup>Sum</sup>, 제곱합<sup>Sum of squares</sup>과 같은 순서에 구애받지 않는 함수들을 사용하여 값을 집계하고 활성화 해주는 역할을 해낸다고 생각할 수 있다. 이런 복합 세포들은 자극이 영역 내에 어디에 위치하는 지에 상관 없이 그 영역의 엣지와 방향을 검출해낸다. 다시 말해, 입력의 위치가 조그만 변화에 대해서 이동불변<sup>Shift-invariant</sup>하다고 한다.

### 후쿠시마 박사의 공헌 (1982)
---

<center><img src="{{site.baseurl}}/images/week03/03-1/Fukushima.png" alt="Fukushima" style="zoom:55%;" /></center>

<div align="center">그림 14. 후쿠시마 박사의 CNN 모델 </div><br>
<!--
Fukushima was the first to implement the idea of multiple layers of simple cells and complex cells with computer models, using a dataset of handwritten digits. Some of these feature detectors were hand-crafted or learned, though the learning used unsupervised clustering algorithms, trained separately for each layer, as backpropagation was not yet in use.
-->
후쿠시마 박사는 수기로 작성한 숫자 데이터 셋으로 여러 레이어의 단일 세포와 복합 세포 모델을 컴퓨터로 처음 구현한 사람이다. 몇몇 피쳐 검출기들은 수작업으로 만들어지거나, 비지도 군집화<sup>Unsupervised clustering</sup> 알고리즘을 사용하여 학습되었다. 물론 역전파는 아직 사용되지 않았기 때문에 각 레이어마다 따로 학습되었다.

<!--
Yann LeCun came in a few years later (1989, 1998) and implemented the same architecture, but this time trained them in a supervised setting using backpropagation. This is widely regarded as the genesis of modern convolutional neural networks. (Note: Riesenhuber at MIT in 1999 also re-discovered this architecture, though he didn't use backpropagation.)
-->
얀 르쿤 교수님은 몇 년 뒤에(1989, 1998) 같은 아키텍쳐를 구현하였지만 역전파를 이용한 지도학습으로 학습시켰고, 이 방식이 현대 합성곱 신경망의 기원으로 널리 알려지게 되었다. (MIT의 Riesenhuber 역시도 1999년에 이 아키텍쳐를 다시 고안해내었지만, 역전파를 사용하지는 않았다.)

