---
lang-ref: ch.02-3
title: 인공신경망<sup>Artificial neural networks (ANNs)</sup>
lecturer: Alfredo Canziani
authors:
date: 4 Feb 2020
lang: ko
translation-date: 4 Apr 2020
translator: Yujin
typora-root-url: 02-3
---

<!-- ## [Supervised learning for classification](https://www.youtube.com/watch?v=WAn6lip5oWk&t=150s) -->
## [분류를 위한 지도 학습](https://www.youtube.com/watch?v=WAn6lip5oWk&t=150s)

<!-- * Consider **Fig. 1(a)** below. The points in this graph lie on the branches of the spiral, and live in $\R^2$. Each colour represents a class label. The number of unique classes is $K = 3$. This is represented mathematically by **Eqn. 1(a)**. -->
* 아래의 그림 **Fig. 1(a)** 을 참고하자. 이 그래프의 점은 나선형의 가지에 있으며, $\R^2$ 에 위치한다. 각각의 색상은 클래스의 레이블을 나타낸다. 각기 다른 클래스의 갯수는 $K = 3$ 이다. 이는 수식으로 **Eqn. 1(a)** 와 같이 표현된다.

<!-- * **Fig. 1(b)** shows a similar spiral, with an added Gaussian noise term. This is represented mathematically by **Eqn. 1(b)**. -->
* **Fig. 1(b)** 은 가우시안 노이즈<sup>noise</sup> 항이 추가된 비슷한 나선형을 보여준다. 이는 수식으로 **Eqn. 1(b)** 와 같이 표현된다.

  <!-- In both cases, these points are not linearly separable. -->
  이 두 경우 모두, 나선을 이루는 점들은 선형 분류가 어렵다.

  <!-- <center>
  <table border="0">
    <td>
      <center>
    <img src="{{site.baseurl}}/images/week02/02-3/clean-spiral.png" width="350px" /><br>
       <b>Fig. 1(a)</b> "Clean" 2D spiral
       </center>
      </td>
      <td>
      <center>
      <img src="{{site.baseurl}}/images/week02/02-3/noisy-spiral.png" width="350px" /><br>
       <b>Fig. 1(b)</b> "Noisy" 2D spiral
       </center>
      </td>
  </table>
  </center> -->

  <center>
  <table border="0">
    <td>
      <center>
    <img src="{{site.baseurl}}/images/week02/02-3/clean-spiral.png" width="350px" /><br>
       <b>Fig. 1(a)</b> "노이즈가 없는" 2D 나선형
       </center>
      </td>
      <td>
      <center>
      <img src="{{site.baseurl}}/images/week02/02-3/noisy-spiral.png" width="350px" /><br>
       <b>Fig. 1(b)</b> "노이즈가 있는" 2D 나선형
       </center>
      </td>
  </table>
  </center>


$$
X_{k}(t)=t\left(\begin{array}{c}{\sin \left[\frac{2 \pi}{K}(2 t+k-1)\right]} \\ {\cos \left[\frac{2 \pi}{K}(2 t+k-1)\right]}\end{array}\right) \\
0 \leq t \leq 1, \quad k=1, ..., K
$$

  <center><b>Eqn. 1(a)</b> </center>

$$
  X_{k}(t)=t\left(\begin{array}{c}{\sin \left[\frac{2 \pi}{K}(2 t+k-1 +\mathcal{N}\left(0, \sigma^{2}\right))\right]} \\ {\cos \left[\frac{2 \pi}{K}(2 t+k-1 +\mathcal{N}\left(0, \sigma^{2}\right))\right]}\end{array}\right)\\0 \leq t \leq 1, \quad k=1, ..., K
$$

<center><b>Eqn. 1(b)</b></center>

<!-- What does it mean to perform **classification**? Consider the case of **logistic regression**. If logistic regression for classification is applied to this data, it will create a set of **linear planes** (decision boundaries) in an attempt to separate the data into its classes. The issue with this solution is that in each region, there are points belonging to multiple classes. The branches of the spiral cross the linear decision boundaries. This is **not** a great solution! -->
 **분류** 를 한다는 것은 무슨뜻일까? **로지스틱 회귀** 의 경우를 살펴보자. 만일 분류를 위한 로지스틱 회귀를 이 데이터에 적용한다면, 이는 **선형 평면** (결정 경계) 의 집합을 만들어서 데이터를 각각의 클래스에 맞게 분류해 내려고 할 것이다. 하지만 이 해결법의 문제점은 각 지역에 대해, 여러 클래스에 동시에 속하는 점들이 존재한다는 것이다. 나선형의 가지는 결정 경계인 선형 평면을 가로지른다. 이는 훌륭한 해결책이 **아니다** !

<!-- **How do we fix this?** We transform the input space such that the data are forced to be linearly separable. Over the course of training a neural network to do this, the decision boundaries that it learns will try to adapt to the distribution of the training data. -->
**이 문제를 어떻게 해결해야 할까?** 우리는 데이터가 선형으로 분류될 수 있도록 입력 값들을 변환한다. 이를 위한 신경망을 훈련시키는 동안, 이 신경망이 학습하는 결정 경계는 학습 데이터의 분포에 따라 조정될 것이다.

<!-- **Note:** A neural network is always represented from the **bottom up**. The first layer is at the bottom, and the last at the top. This is because conceptually, the input data are low-level features for whatever task the neural network is attempting. As the data traverse **upward** through the network, each subsequent layer extracts features at a higher level. -->
**주의할 점:** 신경망은 항상  **아래** 에서 부터 표현된다. 첫번째 층<sup>layer</sup>은 맨 아래에, 그리고 마지막 층은 최 상단에 존재한다. 왜냐하면, 개념적으로 입력 데이터는 신경망이 달성하고자 하는 목표 작업에 대해 낮은 수준의 특징값으로 간주되기 때문이다. 데이터가 신경망을 통해 **위** 로 통과 해 나갈 때, 각 후속 층에서는 더 높은 수준의 데이터 특징을 추출한다.


<!-- ## Training data -->
## 학습 데이터

<!-- Last week, we saw that a newly initialised neural network transforms its input in an arbitrary way. This transformation, however, isn't **(initially)** instrumental in performing the task at hand. We explore how, using data, we can force this transformation to have some meaning that is relevant to the task at hand. The following are data used as training input for a network. -->
지난주, 우리는 새로이 초기화된 신경망이 입력 데이터를 임의의 방식으로 변환하는 것을 확인했다. 그러나, 이 변환은 당면한 작업을 수행하는데 있어 **(초기에)** 유용한 것은 아니다. 우리는 데이터를 이용해서 어떻게 이 변환이 현재의 작업과 관련해 의미가 있도록 할 수 있는지 살펴본다. 다음은 신경망의 학습에 이용되는 입력 데이터이다.

<!-- * $\vect{X}$ represents the input data, a matrix of dimensions $m$ (number of training data points) x $n$ (dimensionality of each input point). In case of the data shown in Figures **1(a)** and **1(b)**, $n = 2$. -->
* $\vect{X}$ 는 입력 데이터로써, $m$ (학습할 데이터 포인트의 갯수) x $n$ (각 입력 포인트의 차원) 차원의 행렬이다. 그림 **1(a)** 과 **1(b)** 에 보여지는 데이터의 경우 $n = 2$ 이다.

<!-- <center>
<img src="{{site.baseurl}}/images/week02/02-3/training-data.png" width="600px" /><br>
<b>Fig. 2</b> Training data
</center> -->

<center>
<img src="{{site.baseurl}}/images/week02/02-3/training-data.png" width="600px" /><br>
<b>Fig. 2</b> 학습 데이터
</center>

<!-- * Vector $\vect{c}$  and matrix $\boldsymbol{Y}$ both represent class labels for each of the $m$ data points. In the example above, there are $3$ distinct classes.

  * $c_i \in \lbrace 1, 2, \cdots, K \rbrace$, and $\vect{c} \in \R^m$. However, we may not use $\vect{c}$ as training data. If we use distinct numeric class labels  $c_i \in \lbrace 1, 2, \cdots, K \rbrace$, the network may infer an order within the classes that isn't representative of the data distribution.
  * To bypass this issue, we use a **one-hot encoding**. For each label $c_i$, a $K$ dimensional zero-vector $\vect{y}^{(i)}$ is created, which has the $c_i$-th element set to $1$ (see **Fig. 3** below). -->

* 벡터 $\vect{c}$  와 행렬 $\boldsymbol{Y}$ 은 모두 각 $m$ 개의 데이터 포인트에 대한 클래스 레이블을 나타낸다. 위의 예시에는 $3$ 개의 고유한 클래스가 있다.

  * $c_i \in \lbrace 1, 2, \cdots, K \rbrace$, and $\vect{c} \in \R^m$. 그러나, 우리는 $\vect{c}$ 을 학습 데이터로 활용하지는 않을 것이다. 만일 우리가 고유한 클래스 레이블 $c_i \in \lbrace 1, 2, \cdots, K \rbrace$ 을 그대로 사용한다면, 신경망은 데이터 분포와는 연관이 없는 개별 클래스 사이의 순서를 유추해낸다.
  * 이러한 문제점에 대응하기 위해, 우리는 **원-핫 인코딩** 을 사용한다. 각각의 클래스 레이블 $c_i$ 에 대하여,  $c_i$ 번 째 원소가 $1$ 인 $K$ 차원의 영백터<sup>zero vector</sup> $\vect{y}^{(i)}$ 가 만들어진다 ( 아래의 **Fig. 3** 에서 확인할 수 있다).

<!-- <center>
<img src="{{site.baseurl}}/images/week02/02-3/one-hot.png" width="250px" /><br>
<b>Fig. 3</b> One hot encoding
</center> -->

<center>
<img src="{{site.baseurl}}/images/week02/02-3/one-hot.png" width="250px" /><br>
<b>Fig. 3</b> 원-핫 인코딩
</center>

  <!-- * Therefore, $\boldsymbol Y \in \R^{m \times K}$. This matrix can also be thought of as having some probabilistic mass, which is fully concentrated on one of the $K$ spots. -->
  * 따라서, $\boldsymbol Y \in \R^{m \times K}$ 와 같다. 또한 이 행렬은 $K$ 지점 중 하나에 집중된 확률적 질량<sup>probabilistic mass</sup>을 가진 것으로도 여겨질 수 있다.


<!-- ## Fully (FC) connected layers -->
## 완전 연결<sup>Fully Connected, FC</sup> 계층<sup>layers</sup>

<!-- We will now take a look at what a fully connected (FC) network is, and how it works. -->
이제 우리는 완결 연결 네트워크<sup>fully connected (FC) network</sup> 가 무엇이고, 이것이 어떻게 작동하는지 살펴본다.

<!-- <center>
<img src="{{site.baseurl}}/images/week02/02-3/FC-net.png" height="250px" /><br>
<b>Fig. 4</b> Fully connected neural network
</center> -->

<center>
<img src="{{site.baseurl}}/images/week02/02-3/FC-net.png" height="250px" /><br>
<b>Fig. 4</b> 완전 연결 신경망
</center>

<!-- Consider the network shown above in **Fig. 4**. The input data, $\boldsymbol x$, is subject to an affine transformation defined by $ \boldsymbol W_h$, followed by a non-linear transformation. The result of this non-linear transformation is denoted as $\boldsymbol h$, representing a **hidden** output, i.e. one that is not **seen** from outside the network. This is followed by another affine transformation ($\boldsymbol W_y$), followed by another non-linear transformation. This produces the final output, $\boldsymbol{\hat{y}} $. This network can be represented mathematically by the equations in **Eqn. 2** below. $$f$$ and $$g$$ are both non-linearities. -->

위의 **Fig. 4** 의 신경망을 살펴보자. 입력 데이터, $\boldsymbol x$, 는 $ \boldsymbol W_h$ 로 정의된 아핀 변환에 이어 비선형 변환이 적용되게 된다. 이 비선형 변환의 결과는 $\boldsymbol h$ 로 표현되고, 이는 **은닉<sup>hidden</sup>** 출력값을 나타내는데, 즉 신경망의 외부에서는 **보이지** 않는다. 뒤이어 또다른 아핀 변환 ($\boldsymbol W_y$) 과 또다른 비선형 변환이 이어진다. 이는 최종 출력인  $\boldsymbol{\hat{y}} $ 을 만든다. 이 신경망은 아래의 수식 **Eqn. 2** 을 통해서도 표현될 수 있다. $$f$$ 와 $$g$$ 는 모두 비선형이다.  

$$
\begin{aligned}
&\boldsymbol h=f\left(\boldsymbol{W}_{h} \boldsymbol x+ \boldsymbol b_{h}\right)\\
&\boldsymbol{\hat{y}}=g\left(\boldsymbol{W}_{y} \boldsymbol h+ \boldsymbol b_{y}\right)
\end{aligned}
$$

<!-- <center><b>Eqn. 2</b> Mathematics behind a FC network</center> -->
<center><b>Eqn. 2</b> 완전 연결 신경망의 바탕이 되는 수학</center>

<!-- A basic neural network such as the one shown above is merely a set of successive pairs, with each pair being an affine transformation followed by a non-linear operation (squashing). Frequently used non-linear functions include ReLU, sigmoid, hyperbolic tangent, and softmax. -->.
위에서 보여진 것과 같은 기본 신경망은 단지 아핀 변환과 그 뒤에 이어지는 비선형 연산(스쿼싱<sup>squashing</sup>)으로 짝을 이룬 연속적인 쌍의 의 모임에 불과하다. 빈번하게 사용되는 비선형 함수에는 ReLU, 시그모이드<sup>sigmoid</sup>, 쌍곡 탄젠트<sup>hyperbolic tangent</sup>, 그리고 소프트맥스<sup>softmax</sup> 등이 있다.  

<!-- The network shown above is a 3-layer network:

 1. input neuron
 2. hidden neuron
 3. output neuron -->

상단에 보여진 것은 3층 신경망이다:

  1. 입력 뉴런<sup>neuron</sup>
  2. 은닉 뉴런
  3. 출력 뉴런

<!-- Therefore, a $3$-layer neural network has $2$ affine transformations. This can be extrapolated to a $n$-layer network. -->
따라서, $3$-층 신경망은 $2$ 개의 아핀 변환을 가진다. 이러한 내용은 $n$-층 신경망으로 확장될 수 있다.

<!-- Now let's move to a more complicated case. -->
그럼 이제, 조금 더 복잡한 사례로 넘어가보자.

<!-- Let's do a case of 3 hidden layers, fully connected in each layer. An illustration can be found in **Fig. 5** -->
 3개의 은닉층이 서로 완전히 연결된 경우를 살펴보자. 이에 대한 그림은 **Fig. 5** 에서 확인할 수 있다.

<!-- <center>
<img src="{{site.baseurl}}/images/week02/02-3/pre-inference4layers.png" /><br>
<b>Fig. 5</b> Neural net with 3 hidden layers
</center> -->

<center>
<img src="{{site.baseurl}}/images/week02/02-3/pre-inference4layers.png" /><br>
<b>Fig. 5</b> 3개의 은닉층으로 구성된 신경망
</center>

<!-- Let's consider a neuron $j$ in the second layer. It's activation is: -->
두 번째 층의 $j$ 번 째 뉴런을 살펴보자. 이것의 활성화는 다음과 같다.:

$$
a^{(2)}_j = f(\boldsymbol w^{(j)} \boldsymbol x + b_j) = f\Big( \big(\sum_{i=1}^n w_i^{(j)} x_i\big) +b_j ) \Big)
$$

<!-- where $\vect{w}^{(j)}$ is the $j$-th row of $\vect{W}^{(1)}$. -->
여기에서 $\vect{w}^{(j)}$ 은 $\vect{W}^{(1)}$ 의 $j$-번 째 행이다.

<!-- Notice that the activation of the input layer in this case is just the identity. The hidden layers can have activations like ReLU, hyperbolic tangent, sigmoid, soft (arg)max, etc. -->
여기서 입력층의 활성화는 단지 항등<sup>identity</sup>임을 알 수 있다. 은닉층은 ReLU, 쌍곡탄젠트, 시그모이드, 소프트맥스<sup>soft (arg)max</sup> 등을 활성화로 가질 수 있다.

<!-- The activation of the last layer in general would depend on your use case, as explained in [this](https://piazza.com/class/k5spqaanqk51ks?cid=36) Piazza post. -->
일반적으로 마지막 층의 활성화는 [여기](https://piazza.com/class/k5spqaanqk51ks?cid=36)의 Piazza 글에서 확인할 수 있듯 구체적인 상황 및 목적에 따라 달라진다.


<!-- ## Neural network (inference) -->
## 신경망 (추론)

<!-- Let's think about the three-layer (input, hidden, output) neural network again, as seen in **Fig. 6** -->
3층(입력, 은닉, 출력) 신경망에 대해 다시 한 번 생각해보자. 이는 **Fig. 6** 에서 확인할 수 있다.

<!-- <center>
<img src="{{site.baseurl}}/images/week02/02-3/2-layer-inference.png" height="250px"/><br>
<b>Fig. 6</b> Three-layer neural network
</center> -->

<center>
<img src="{{site.baseurl}}/images/week02/02-3/2-layer-inference.png" height="250px"/><br>
<b>Fig. 6</b> 3층 신경망
</center>

<!-- What kind of functions are we looking at? -->
지금 우리가 보고 있는 이 함수들은 어떤 기능을 할까?

$$
\boldsymbol {\hat{y}} = \boldsymbol{\hat{y}(x)}, \boldsymbol{\hat{y}}: \mathbb{R}^n \rightarrow \mathbb{R}^K, \boldsymbol{x} \mapsto \boldsymbol{\hat{y}}
$$

<!-- However, it is helpful to visualize the fact that there is a hidden layer, and the mapping can be expanded as: -->
그러나, 은닉층이 있다는 사실을 보여주는 것은 도움이 되며, 이 매핑<sup>mapping</sup>은 다음과 같이 전개된다.:

$$
\boldsymbol{\hat{y}}: \mathbb{R}^{n} \rightarrow \mathbb{R}^d \rightarrow \mathbb{R}^K, d \gg n, K
$$

<!-- What might an example configuration for the case above look like? In this case, one has input of dimension two ($n=2$), the single hidden layer could have dimensionality of 1000 ($d = 1000$), and we have 3 classes ($C=3$). There are good practical reasons to not have so many neurons in one hidden layer, so it could make sense to split that single hidden layer into 3 with 10 neurons each ($1000 \rightarrow 10 \times 10 \times 10$). -->
위의 사례와 같은 구성 예시는 어떤 것이 있을까? 이 경우, 2차원($n=2$)의 입력을 가지고, 단일한 은닉층은 1000 ($d = 1000$) 개의 차원을 가지며, 3개의 클래스 ($C=3$) 를 가진다. 그런데 하나의 은닉층이 지나치게 많은 뉴런을 가져서는 안되는 실질적인 이유가 있기 때문에, 단일 은닉층을 10개의 뉴런을 가진 3개의 층으로 나누는 것이 좋다 ($1000 \rightarrow 10 \times 10 \times 10$).


<!-- ## [Neural network (training I)](https://www.youtube.com/watch?v=WAn6lip5oWk&t=822s) -->
## [신경망 (학습 I)](https://www.youtube.com/watch?v=WAn6lip5oWk&t=822s)

<!-- So what does typical training look like? It is helpful to formulate this into the standard terminology of losses. -->
그렇다면, 일반적인 훈련은 어떤 모습일까? 이를 손실에 대한 표준적인 용어로 공식화 하는 것은 도움이 된다.

<!-- First, let us re-introduce the soft (arg)max and explicitly state that it is a common activation function for the last layer, when using negative log-likelihood loss, in cases for multi-class prediction. As stated by Professor LeCun in lecture, this is because you get nicer gradients than if you were to use sigmoids and square loss. In addition, your last layer will already be normalized (the sum of all the neurons in the last layer come out to 1), in a way that is nicer for gradient methods than explicit normalization (dividing by the norm). -->
먼저, 소프트맥스<sup>soft (arg)max</sup>을 다시 소개하고, 다중 클래스<sup>multi-class</sup> 예측 상황에서 로그 우도<sup>log-likelihood</sup> 손실을 사용할 때 이것이 마지막 출력층에서 가장 널리 쓰이는 활성화임을 명확하게 밝히자. 이에 대한 이유는 지난 강의에서 르쿤<sup>LeCun</sup> 교수가 말했듯, 이 활성화가 시그모이드<sup>sigmoid</sup>와 제곱 손실<sup>square loss</sup>을 사용할 때 보다 더 유용한 경사<sup>gradients</sup> 값을 제공하기 때문이다. 뿐만 아니라, 여기에서 마지막 출력층은 명시적 정규화 (놈<sup>norm</sup> 으로 나누는 것) 보다 경사 하강법에 더 좋은 방식으로 이미 정규화가 되어 출력된다 (마지막 층의 모든 뉴런의 합계는 1이 됨).

<!-- The soft (arg)max will give you logits in the last layer that look like this: -->
소프트맥스는 다음과 같이 마지막 층에서 로짓<sup>logit</sup> 값을 제공한다.:

$$
\text{soft{(arg)}max}(\boldsymbol{l})[c] = \frac{ \exp(\boldsymbol{l}[c])}   {\sum^K_{k=1} \exp(\boldsymbol{l}[k])}  \in (0, 1)
$$

<!-- It is important to note that the set is not closed because of the strictly positive nature of the exponential function. -->
여기에서 지수 함수가 엄격한 양수의 특성<sup>strictly positive nature</sup>을 지니기 때문에 이 집합이 닫히지 않은 것을 알아둘 필요가 있다.


<!-- Given the set of the predictions $\matr{\hat{Y}}$, the loss will be: -->
$\matr{\hat{Y}}$ 의 예측 집합이 주어졌을 때, 손실은 다음과 같다.:

$$
\mathcal{L}(\boldsymbol{\hat{Y}}, \boldsymbol{c}) = \frac{1}{m} \sum_{i=1}^m \ell(\boldsymbol{\hat{y}_i}, c_i), \quad
\ell(\boldsymbol{\hat{y}}, c) = -\log(\boldsymbol{\hat{y}}[c])
$$

<!-- Here c denotes the integer label, not the one hot encoding representation. -->
여기에서 c 는 원-핫 인코딩 표현이 아니라, 정수 레이블<sup>label</sup>을 나타낸다.

<!-- So let's do two examples, one where an example is correctly classified, and one where it is not. -->
한 예시는 잘 분류가 됐으나, 나머지 하나는 그렇지 않은 두 개의 예시를 살펴보자.

<!-- Let's say

$$
\boldsymbol{x}, c = 1 \Rightarrow \boldsymbol{y} =
{\footnotesize\begin{pmatrix}
1 \\
0 \\
0
\end{pmatrix}}
$$

What is the instance wise loss? -->

만일 다음과 같다면,

$$
\boldsymbol{x}, c = 1 \Rightarrow \boldsymbol{y} =
{\footnotesize\begin{pmatrix}
1 \\
0 \\
0
\end{pmatrix}}
$$

각 인스턴스<sup>instance</sup>의 손실은 어떻게 될까?

<!-- For the case of *nearly perfect prediction* ($\sim$ means *circa*): -->
*거의 완벽한 예측* 예시 ($\sim$ 는 *거의<sup>circa</sup>* 를 의미한다):

$$
\hat{\boldsymbol{y}}(\boldsymbol{x}) =
{\footnotesize\begin{pmatrix} \sim 1 \\ \sim 0 \\ \sim 0 \end{pmatrix}}
 \Rightarrow \ell \left(
{\footnotesize\begin{pmatrix} \sim 1 \\ \sim 0 \\ \sim 0 \end{pmatrix}}
, 1\right) \rightarrow 0^{+}
$$

*거의 절대적으로 옳지 않은* 예시:

$$ \hat{\boldsymbol{y}}(\boldsymbol{x}) =
{\footnotesize\begin{pmatrix} \sim 0 \\ \sim 1 \\ \sim 0 \end{pmatrix}}
\Rightarrow \ell \left(
{\footnotesize\begin{pmatrix} \sim 0 \\ \sim 1 \\ \sim 0 \end{pmatrix}}
, 1\right) \rightarrow +\infty  $$

<!-- Note in the above examples, $\sim 0 \rightarrow 0^{+}$ and $\sim 1 \rightarrow 1^{-}$. Why is this so? Take a minute to think. -->
위의 예시에서, $\sim 0 \rightarrow 0^{+}$ 이고, $\sim 1 \rightarrow 1^{-}$ 이다. 왜 그럴까? 잠시 시간을 갖고 생각해 보기 바란다.

<!-- **Note**: It is important to know that if you use `CrossEntropyLoss`, you will get `LogSoftMax` and negative loglikelihood `NLLLoss` bundled together, so don't do it twice! -->
**주의할 점**: 만일 `크로스엔트로피 손실<sup>CrossEntropyLoss</sup>`을 사용하면, `로그소프트맥스<sup>LogSoftMax</sup>` 와 음의 로그 우도<sup>negative loglikelihood</sup> `NLLLoss` 가 함께 도출된다는 점을 알아둘 필요가 있다. 그러니 두 번 하지 마라!  


<!-- ## [Neural network (training II)](https://www.youtube.com/watch?v=WAn6lip5oWk&t=2188s) -->
## [신경망 (학습 II)](https://www.youtube.com/watch?v=WAn6lip5oWk&t=2188s)

<!-- For training, we aggregate all trainable parameters -- weight matrices and biases -- into a collection we call $\mathbf{\Theta} = \lbrace\boldsymbol{W_h, b_h, W_y, b_y} \rbrace$. This allows us to write the objective function or loss as: -->
학습을 시키기 위해 우리는 학습이 가능한 모든 매개 변수 -- 가중치 행렬과 오차 -- 를 다음과 같은 집합 $\mathbf{\Theta} = \lbrace\boldsymbol{W_h, b_h, W_y, b_y} \rbrace$ 에 집계한다.
이를 바탕으로 목적 함수 또는 손실을 다음과 같이 작성할 수 있다.:

$$
J \left( \mathbf{\Theta} \right) = \mathcal{L} \left( \boldsymbol{\hat{Y}} \left( \mathbf{\Theta} \right), \boldsymbol c \right) \in \mathbb{R}^{+}
$$

<!-- This makes the loss depend on the output of the network  $\boldsymbol {\hat{Y}} \left( \mathbf{\Theta} \right)$, so we can turn this into an optimization problem. -->
이는 신경망의 출력 $\boldsymbol {\hat{Y}} \left( \mathbf{\Theta} \right)$ 에 손실이 의존하도록 하고, 따라서 이를 최적화 문제로 바꿀 수 있다.

<!-- A simple illustration of how this works can be seen in **Fig. 7**, where $J(\vartheta)$, the function we need to minimise, has only a scalar parameter $\vartheta$. -->
이것이 어떻게 작동하는지에 대한 간단한 설명은 최소화해야 하는 함수 $J(\vartheta)$ 가 오직 하나의 스칼라 매개변수 $\vartheta$ 만을 가지는 **Fig. 7** 에서 확인할 수 있다.

<!-- <center>
<img src="{{site.baseurl}}/images/week02/02-3/1-GD.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Fig. 7</b> Optimizing a loss function through gradient descent.
</center> -->

<center>
<img src="{{site.baseurl}}/images/week02/02-3/1-GD.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Fig. 7</b> 경사하강법을 통한 손실 함수 최적화.
</center>

<!-- We pick a random initialization point $\vartheta_0$ -- with associated loss $J(\vartheta_0)$. We can compute the derivative evaluated at that point $J'(\vartheta_0) = \frac{\text{d} J(\vartheta)}{\text{d} \vartheta} (\vartheta_0)$. In this case, the slope of the derivative is positive. So we need to take a step in the direction of steepest descent. In this case, that is $-\frac{\text{d} J(\vartheta)}{\text{d} \vartheta}(\vartheta_0)$. -->
우리는 임의의 초기화 점 $\vartheta_0$ 을 선택한다 -- 여기서의 손실은 $J(\vartheta_0)$ 이다. 이 점에서 계산되는 미분값은 $J'(\vartheta_0) = \frac{\text{d} J(\vartheta)}{\text{d} \vartheta} (\vartheta_0)$ 과 같다. 이 경우, 계산된 미분값의 기울기는 양수이다. 따라서 우리는 가장 가파른 방향으로 나아가야 하고, 이는 $-\frac{\text{d} J(\vartheta)}{\text{d} \vartheta}(\vartheta_0)$ 과 같다.

<!-- The iterative repetition of this process is known as gradient descent. Gradient methods are the primary tools to train a neural network. -->
이를 반복하는 과정을 경사 하강법 <sup>gradient descent</sup> 이라고 한다. 경사 하강법은 신경망을 학습시키는 가장 기본적인 도구이다.

<!-- In order to compute the necessary gradients, we have to use back-propagation -->
필요한 경사를 계산해 내기 위해 우리는 역전파<sup>back-propagation</sup>를 사용한다.

$$ \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{W_y}} = \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{\hat{y}}} \; \frac{\partial \, \boldsymbol{\hat{y}}}{\partial \, \boldsymbol{W_y}} \quad \quad \quad  \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{W_h}} = \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{\hat{y}}} \; \frac{\partial \, \boldsymbol{\hat{y}}}{\partial \, \boldsymbol h} \;\frac{\partial \, \boldsymbol h}{\partial \, \boldsymbol{W_h}} $$


<!-- ## Spiral classification - Jupyter notebook -->
## 나선형 분류 - 주피터 노트북

<!-- The Jupyter notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/04-spiral_classification.ipynb). In order to run the notebook, make sure you have `the dl-minicourse` environment installed as specified in [README.md](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/README.md). -->
이 실습과 관련된 주피터 노트북은 [여기](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/04-spiral_classification.ipynb)에서 확인할 수 있다. 이 주피터 노트북을 실행하기 위해서, [README.md](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/README.md) 에서 설명된 것과 같이 `the dl-minicourse` 이 작업 환경에 설치가 됐는지 확인해야 한다.


<!-- An explanation of how to use `torch.device()` can be found in [last week's notes](https://atcold.github.io/pytorch-Deep-Learning-Minicourse/en/week01/01-3/). -->
`torch.device()` 의 사용 방법에 대한 설명은 [지난 주 강의 노트](https://atcold.github.io/pytorch-Deep-Learning-Minicourse/en/week01/01-3/) 에서 확인할 수 있다.

<!-- Like before, we are going to be working with points in $\mathbb{R}^2$ with three different categorical labels - in red, yellow and blue - as can be seen in **Fig. 8**. -->
이전과 동일하게, 우리는 세 가지 범주형<sup>categorical</sup> 레이블 - 빨강, 노랑, 파랑 - 을 가지는 $\mathbb{R}^2$ 위의 점들을 다룬다. 이는 **Fig. 8** 에서 확인할 수 있다.  

<!-- <center>
<img src="{{site.baseurl}}/images/week02/02-3/2-data.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>Fig. 8</b> Spiral classification data.
</center> -->

<center>
<img src="{{site.baseurl}}/images/week02/02-3/2-data.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>Fig. 8</b> 나선형 분류 데이터.
</center>

<!-- `nn.Sequential()` is a container, which passes modules to the constructor in the order that they are added; `nn.linear()` is miss-named as it applies an **affine** transformation to the incoming data: $\boldsymbol y = \boldsymbol W \boldsymbol x + \boldsymbol b$. For more information, refer to the [PyTorch documentation](https://pytorch.org/docs/stable/nn.html). -->
`nn.Sequential()` 은 컨테이너<sup>container</sup>로써, 컨테이너에 모듈이 추가된 순서로 생성자에게 모듈을 전달한다;  `nn.linear()` 는 사실 이름이 잘못 지어졌는데, 이 함수는 입력된 데이터에 대해 **affine** 변환을 수행한다 : $\boldsymbol y = \boldsymbol W \boldsymbol x + \boldsymbol b$. 자세한 내용은 [파이토치 문서](https://pytorch.org/docs/stable/nn.html) 를 참조하기 바란다.

<!-- Remember, an affine transformation is five things: rotation, reflection, translation, scaling and shearing. -->
아핀 변환은 회전<sup>rotation<sup>, 반사<sup>reflection</sup>, 변환<sup>translation</sup>, 스케일링<sup>scaling</sup>, 절단<sup>shearing</sup>의 다섯 가지임을 기억하자.

<!-- As it can be seen in **Fig. 9**, when trying to separate the spiral data with linear decision boundaries - only using `nn.linear()` modules, without a non-linearity between them - the best we can achieve is an accuracy of $50\%$. -->
그림 **Fig. 9** 에서 볼 수 있듯, 나선 데이터를 선형 결정 경계 - 비선형성 없이 오직 `nn.linear()` 모듈만을 사용 - 로 분류해 내고자 하면, 우리가 이룰 수 있는 가장 높은 정확도는 50% 이다.

<!-- <center>
<img src="{{site.baseurl}}/images/week02/02-3/3-linear.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Fig. 9</b> Linear decision boundaries.
</center> -->

<center>
<img src="{{site.baseurl}}/images/week02/02-3/3-linear.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Fig. 9</b> 선형 결정 경계.
</center>

<!-- When we go from a linear model to one with two `nn.linear()` modules and a `nn.ReLU()` between them, the accuracy goes up to $95\%$. This is because the boundaries become non-linear and adapt much better to the spiral form of the data, as it can be seen in **Fig. 10**. -->
이 선형 모델을, 두 개의 `nn.linear()` 모듈 사이에 `nn.ReLU()` 을 끼운 모델로 바꾸면, 모델의 정확도는 95%로 상승한다. 그림 **Fig. 10** 에서 볼 수 있듯, 결정 경계가 비선형으로 바뀌어 나선형 데이터 형식에 더 적합해지기 때문이다.

<!-- <center>
<img src="{{site.baseurl}}/images/week02/02-3/4-non-linear.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
    <b>Fig. 10</b> Non-linear decision boundaries.
</center> -->

<center>
<img src="{{site.baseurl}}/images/week02/02-3/4-non-linear.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
    <b>Fig. 10</b> 비선형 결정 경계.
</center>

<!-- An example of a regression problem which can't be solved correctly with a linear regression, but is easily solved with the same neural network structure can be seen in [this notebook](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/05-regression.ipynb) and **Fig. 11**, which shows 10 different networks, where 5 have a `nn.ReLU()` link function and 5 have a `nn.Tanh()`. The former is a piecewise linear function, whereas the latter is a continuous and smooth regression. -->
선형 회귀로는 올바르게 해결할 수 없지만, 동일한 신경망 구조로 쉽게 해결되는 회귀 문제의 예는 [이 노트북](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/05-regression.ipynb)에서 확인할 수 있고, 그림 **Fig. 11** 을 통해 절반은 `nn.ReLU()`을 연결 함수로, 그리고 나머지 절반은 `nn.Tanh()` 을 이용한 10개의 신경망을 확인할 수 있다. 전자<sup>nn.ReLU()</sup>는 부분 선형 함수인 반면, 후자<sup>nn.Tanh()</sup>는 연속적이고 부드러운 회귀이다.


<!-- <center>
<img src="{{site.baseurl}}/images/week02/02-3/5-nn-reg.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
<b>Fig. 11</b>: 10 Neural networks, along with their variance and standard deviation.<br>
Left: Five <code>ReLU</code> networks.  Right: Five <code>tanh</code> networks.
</center> -->

<center>
<img src="{{site.baseurl}}/images/week02/02-3/5-nn-reg.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
<b>Fig. 11</b>: 분산 및 표준편차와 함께 제시된 10개의 신경망.<br>
왼쪽: 다섯개 <code>ReLU</code> 구조<sup>network</sup>.  오른쪽: 다섯개 <code>tanh</code> 구조.
</center>

<!-- The yellow and green lines show the standard deviation and variance for the networks. Using these is useful for something similar to a "confidence interval" - since the functions give a single prediction per output. Using ensemble variance prediction allows us to estimate the uncertainty with which the prediction is being made. The importance of this can be seen in **Fig. 12**, where we extend the decision functions outside the training interval and these tend towards $+\infty, -\infty$. -->
노란색과 초록색 선은 신경망의 표준 편차와 분산을 나타낸다. 이것들을 사용하는 것은 "신뢰 구간" 과 비슷하게 유용한데, 함수들이 각 출력 당 하나의 예측을 내놓기 때문이다. 앙상블<sup>ensemble</sup> 분산 예측을 사용하면 결과로 나온 예측과 관련된 불확실성을 추정할 수 있다. 이것의 중요성은 **Fig. 12** 을 통해 확인할 수 있는데, 여기서 우리는 결정 경계를 데이터 범위 바깥으로 확장시키고, 이 경계들은 $+\infty, -\infty$ 로 향하는 경향이 있다.  

<!-- <center>
<img src="{{site.baseurl}}/images/week02/02-3/6-nn-confidence.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
<b>Fig. 12</b> Neural networks, with variance and standard deviation, outside training interval.<br>
Left: Five <code>ReLU</code> networks.  Right: Five <code>tanh</code> networks.
</center> -->

<center>
<img src="{{site.baseurl}}/images/week02/02-3/6-nn-confidence.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
<b>Fig. 12</b> 훈련 범위를 바깥의 분산 및 표준편차가 있는 신경망.<br>
왼쪽: 다섯개 <code>ReLU</code> 구조.  오른쪽: 다섯개 <code>tanh</code> 구조.
</center>

<!-- To train any Neural Network using PyTorch, you need 5 fundamental steps in the training loop: -->
파이토치를 이용해 신경망을 학습시키기 위해서, 학습 루프<sup>loop</sup> 안에서 5개의 기본 단계를 거쳐야 한다:

<!-- 1. `output = model(input)` is the model's forward pass, which takes the input and generates the output.
2. `J = loss(output, target <or> label)` takes the model's output and calculates the training loss with respect to the true target or label.
3. `model.zero_grad()` cleans up the gradient calculations, so that they are not accumulated for the next pass.
4. `J.backward()` does back-propagation and accumulation: It computes $\nabla_\texttt{x} J$ for every variable $\texttt{x}$ for which we have specified `requires_grad=True`. These are accumulated into the gradient of each variable: $\texttt{x.grad} \gets \texttt{x.grad} +  \nabla_\texttt{x} J$.
5. `optimiser.step()` takes a step in gradient descent: $\vartheta \gets \vartheta - \eta\, \nabla_\vartheta J$. -->

1. `output = model(input)` 은 모델의 전달 경로로써, 입력을 받아 출력을 생성한다.
2. `J = loss(output, target <or> label)` 는 모델의 출력이 실제 목표 또는 레이블에 대해 얼만큼의 훈련 손실을 보이는지 계산한다.
3. `model.zero_grad()` 는 이전에 계산된 경사값들을 0으로 정리해서 다음 전달 경로에 과거의 계산값들이 축적되지 않도록 한다.  
4. `J.backward()` 는 역전파 및 축적을 수행한다: 우리가 `requires_grad=True` 로 지정한 모든 변수  $\texttt{x}$에 대해서 $\nabla_\texttt{x} J$ 을 계산한다. 이 계산 값들은 각 변수의 경사값에 누적된다: $\texttt{x.grad} \gets \texttt{x.grad} +  \nabla_\texttt{x} J$.
5. `optimiser.step()` 는 경사 하강법을 한 단계 수행한다: $\vartheta \gets \vartheta - \eta\, \nabla_\vartheta J$.

<!-- When training a NN, it is very likely that you need these 5 steps in the order they were presented. -->
신경망을 학습시킬 때에는, 위에서 5개 단계가 제시된 순서에 따라 학습을 진행하는 것이 권장된다.
