---
lang-ref: ch.01-3
title: 선형대수학 및 데이터 시각화
lecturer: Alfredo Canziani
authors: Yunya Wang, SunJoo Park, Mark Estudillo, Justin Mae
date: 28 Jan 2020
lang: ko
translation-date: 3 Apr 2020
translator: Seungjae Ryan Lee
---


<!--
## Resources

Please follow Alfredo Canziani [on Twitter @alfcnz](https://twitter.com/alfcnz). Videos and textbooks with relevant details on linear algebra and singular value decomposition (SVD) can be found by searching Alfredo's Twitter, for example type `linear algebra (from:alfcnz)` in the search box.
-->

## 자료

트위터에서 알프레도 칸지아니 ([@alfcnz](https://twitter.com/alfcnz)) 를 팔로우하세요. 선형대수학과 특이값 분해<sup>Singular Value Decomposition (SVD)</sup>를 다룬 영상들과 교과서는 트위터에서 검색할 수 있습니다. (예시: `linear algebra (from:alfcnz)`)

<!--
## [Transformations and motivation](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=233s)

As a motivating example, let us consider image classification. Suppose we take a picture with a 1 megapixel camera. This image will have about 1,000 pixels vertically and 1,000 pixels horizontally, and each pixel will have three colour dimensions for red, green, and blue (RGB). Each particular image can then be considered as one point in a 3 million-dimensional space. With such massive dimensionality, many interesting images we might want to classify -- such as a dog *vs.* a cat -- will essentially be in the same region of the space.

In order to effectively separate these images, we consider ways of transforming the data in order to move the points. Recall that in 2-D space, a linear transformation is the same as matrix multiplication. For example, the following are linear transformations:

-   Rotation (when the matrix is orthonormal).
-   Scaling (when the matrix is diagonal).
-   Reflection (when the determinant is negative).
-   Shearing.

Note that translation alone is not linear since 0 will not always be mapped to 0, but it is an affine transformation. Returning to our image example, we can transform the data points by translating such that the points are clustered around 0 and scaling with a diagonal matrix such that we "zoom in" to that region. Finally, we can do classification by finding lines across the space which separate the different points into their respective classes. In other words, the idea is to use linear and nonlinear transformations to map the points into a space such that they are linearly separable. This idea will be made more concrete in the following sections.
-->

## [변환](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=233s)

동기부여를 위해 이미지 분류 예시로 시작하자. 우리가 1 메가픽셀 카메라로 사진을 찍었다고 가정하자. 이 이미지는 약 1,000 화소의 높이와 1,000 화소의 너비를 가지고, 각 화소는 빨간색, 녹색, 파란색(RGB)의 세 가지 색 치수를 갖게 된다. 그렇다면 각각의 사진은 300만차원 공간에서 하나의 점으로 간주될 수 있다. 이렇게 거대한 차원수를 지닌 공간에서, 우리가 분류하고 싶은 많은 흥미로운 이미지들 - (예를 들어 개와 고양이)은 공간 안에서 거의 같은 영역에 있을 것이다.

이러한 이미지를 효과적으로 분리하기 위해, 우리는 이러한 점들을 이동시키기 위해 데이터를 변환하는 방법을 고려한다. 기억할 점은, 2차원 공간에서 선형 변환은 행렬 곱셈과 동일하다는 것이다. 예를 들어, 다음은 선형 변환이다.

-   회전 (행렬이 직교행렬일 시).
-   크기 조정 (행렬이 대각행렬일 시).
-   박사 (행렬식이 음수일 때).
-   깎기.

주목해야 할 것은, 강체 변환을 하면 0이 항상 0으로 매핑되지 않기 때문에, 이는 선형 변환이 아니고 아핀 변환이다. 다시 우리 예제로 돌아가서, 우리는 데이터 포인트를 변환하여 점들이 0 주위에 군집되도록 바꾸고, 대각선 행렬로 크기 조정을 함으로써 우리가 그 지역을 "확대"해서 볼 수 있도록 할 수 있다. 마지막으로, 우리는 종류가 다른 점들을 나누는 선을 발견함으로써 분류를 할 수 있다. 즉, 선형 변환과 비선형 변환을 사용하여 점을 선형적으로 분리할 수 있는 공간으로 매핑하는 것이다. 이 아이디어는 다음 섹션에서 더 자세히 다룰 것이다.

<!--
## [Data visualization - separating points by colour using a network](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=798s)

In our visualization, we have five branches of a spiral, with each branch corresponding to a different colour. The points live in a two dimensional plane and can be represented as a tuple; the colour represents a third dimension which can be thought of as the different classes for each of the points. We then use the network to separate each of the points by colour.

| <center><img src="{{site.baseurl}}/images/week01/01-3/Spiral1.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week01/01-3/Spiral2.png" width="200px"/></center> |
|             (a) Input points, pre-network             |            (b) Output points, post-network             |

<center> Figure 1: Five colour spiral </center>
The network \"stretches\" the space fabric in order to separate each of the points into different subspaces. At convergence, the network separates each of the colours into different subspaces of the final manifold. In other words, each of the colours in this new space will be linearly separable using a one vs all regression. The vectors in the diagram can be represented by a five by two matrix; this matrix can be multiplied to each point to return scores for each of the five colours. Each of the points can then be classified by colour using their respective scores. Here, the output dimension is five, one for each of the colours, and the input dimension is two, one for the x and y coordinates of each of the points. To recap, this network basically takes the space fabric and performs a space transformation parametrised by several matrices and then by non-linearities.
-->

## [데이터 시각화 - 네트워크를 사용하여 색상별로 점 구분하기](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=798s)

아래의 데이터 시각화에는 각기 다른 색을 가진 다섯 부분으로 나누어진 나선이 있다. 점들은 2차원 평면에 존재하며, 투플<sup>tuple</sup>로 나타낼 수 있고, 점들의 색은 각 점들의 종류를 나타내는 세 번째 차원을 나타낸다. 그 후 우리는 신경망을 사용하여 각각의 점들을 색상별로 구분한다.

| <center><img src="{{site.baseurl}}/images/week01/01-3/Spiral1.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week01/01-3/Spiral2.png" width="200px"/></center> |
|             (a) 입력되는 점들, 신경망 통과 전             |            (b) 출력된 점들, 신경망 통과 후             |

<center> 그림 1: 다섯 색의 나선 </center>

신경망은 각각의 점을 서로 다른 부분 공간으로 분리하기 위해 공간을 \"잡아당긴다\". 수렴 시에, 신경망은 각각의 색을 최종 다양체의 각기 다른 부분 공간으로 분리한다. 다시 말해서, 이 새로운 공간에 있는 각각의 색은 회귀 분석을 사용하여 다른 모든 색들로부터 선형적으로 분리될 수 있을 것이다. 그림에 보이는 벡터들은 5x2 행렬로 나타낼 수 있고, 각 점들에 이 행렬을 곱함으로써 각 색에 대한 점수를 얻을 수 있다. 그 후 각각의 점들을 그들의 색상 점수를 사용하여 색상별로 분류할 수 있다. 여기서 출력 차원수는 색상별로 하나씩 해서 5이며, 입력 차원수는 x와 y 좌표 하나씩 해서 2이다. 요약하자면, 이 신경망은 여러 행렬과 비선형성을 통해 공간을 변환한다.

<!--
### Network architecture

<center>
<img src="{{site.baseurl}}/images/week01/01-3/Network.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
Figure 2: Network Architecture
</center>

The first matrix maps the two dimensional input to a 100 dimensional intermediate hidden layer. We then have a non-linear layer, `ReLU` or Rectified Linear Unit, which is simply *positive part* $(\cdot)^+$ function. Next, to display our image in a graphical representation, we include an embedding layer that maps the 100 dimensional hidden layer input to a two-dimensional output. Lastly, the embedding layer is projected to the final, five-dimensional layer of the network, representing a score for each colour.
-->

### 신경망 구조

<center>
<img src="{{site.baseurl}}/images/week01/01-3/Network.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
그림 2: 신경망 구조
</center>

첫 번째 행렬은 2차원의 벡터를 입력받아 100차원의 은닉층에 매핑한다. 그런 다음 양수 부분만을 가져오는 $(\cdot)^+$ ReLU 또는 Rectified Linear Unit 이라는 비선형 함수를 통과한다. 다음으로, 우리의 이미지를 시각화하기 위해, 100차원의 은닉층 입력을 2차원 출력에 매핑하는 임베딩 계층을 포함한다. 마지막으로 임베딩 계층은 각 색상별 점수를 나타내는 신경망의 마지막에 있는 5차원 계층에 투영된다.

<!--
## [Random projections - Jupyter Notebook](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=1693s)

The Jupyter Notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/02-space_stretching.ipynb). In order to run the notebook, make sure you have the `pDL` environment installed as specified in [`README.md`](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/README.md).
-->

## [무작위 투영 - 주피터 노트북](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=1693s)

주피터 노트북은 [여기서](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/02-space_stretching.ipynb) 찾을 수 있다. 노트북을 실행하려면 [`README.md`](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/docs/ko/README-KO.md)에 지정된 대로 `pDL` 환경이 설치되어 있어야 한다.

<!--
### PyTorch `device`

PyTorch can run on both the CPU and GPU of a computer. The CPU is useful for sequential tasks, while the GPU is useful for parallel tasks. Before executing on our desired device, we first have to make sure our tensors and models are transferred to the device's memory. This can be done with the following two lines of code:

```python
device = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")
X = torch.randn(n_points, 2).to(device)
```

The first line creates a variable, called `device`, that is assigned to the GPU if one is available; otherwise, it defaults to the CPU. In the next line, a tensor is created and sent to the device's memory by calling `.to(device)`.
-->

### 파이토치 `device`

파이토치는 컴퓨터의 CPU와 GPU 모두에서 실행될 수 있다. CPU는 순차적인 작업에 유용하고, GPU는 병렬적인 작업에 유용하다. 원하는 장치에서 실행하기 전에 먼저 텐서와 모델이 해당 장치의 메모리로 전송되었는지 확인해야 한다. 이는 다음 두 줄의 코드로 할 수 있다.

```python
device = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")
X = torch.randn(n_points, 2).to(device)
```

첫 줄은 `device`라는 변수를 만드는데, 사용가능한 GPU가 있다면 GPU 장치가 되고, 그렇지 않으면 CPU로 기본 설정된다. 다음 줄에서는 텐서를 생성한 후 `.to(device)` 를 통해 해당 텐서를 장치의 메모리에 보낸다.

<!--
### Jupyter Notebook tip

To see the documentation for a function in a notebook cell, use `Shift + Tab.`
-->

### 주피터 노트북 팁

노트북 셀의 기능에 대한 설명서를 보려면 'Shift + Tab' 단축키를 사용하시오.

<!--
### Visualizing linear transformations

Recall that a linear transformation can be represented as a matrix. Using singular value decomposition, we can decompose this matrix into three component matrices, each representing a different linear transformation.

$$
W = U\begin{bmatrix}s_1 & 0 \\ 0 & s_2 \end{bmatrix} V^\top
$$

In eq. (1), matrices $U$ and $V^\top$ are orthogonal and represent rotation and reflection transformations. The middle matrix is diagonal and represents a scaling transformation.

We visualize the linear transformations of several random matrices in Fig. 3. Note the effect of the singular values on the resulting transformations.

The matrices used were generated with Numpy; however, we can also use PyTorch's `nn.Linear` class with `bias = False` to create linear transformations.

| ![]({{site.baseurl}}/images/week01/01-3/initial_scatter_lab1.png) | ![]({{site.baseurl}}/images/week01/01-3/matrix_multiplication_lab1.png) | ![]({{site.baseurl}}/images/week01/01-3/matrix_multiplication_lab1_2.png) |
|     (a) Original points       |   (b) $s_1$ = 1.540, $s_2$ = 0.304  |   (c) $s_1$ = 0.464, $s_2$ = 0.017    |

<center> Figure 3:  Linear transformations from random matrices </center>
-->

### 선형 변환 시각화

선형 변환을 행렬로 나타낼 수 있다는 점을 기억하자. 특이값 분해를 사용하여 이 행렬을 각각 다른 선형 변환을 나타내는 세 개의 행렬로 분해할 수 있다.

$$
W = U\begin{bmatrix}s_1 & 0 \\ 0 & s_2 \end{bmatrix} V^\top
$$

수식 1 의 행렬 $U$ 와 $V^\top$ 은 직교 행렬이며 and 각각 회전 변환과 반사 변환을 가르킨다. 중간에 있는 행렬은 대각선 행렬이며, 크기 조정을 담당한다.

그림 3에는 여러 무작위 행렬들의 선형 변환을 시각화되어 있다. 특이값들이 변환의 최종 결과에 주는 영향을 확인해보자.

이 시각화에 사용된 행렬들은 넘파이로 생성되었다. 그러나, 파이토치로도 'nn.Linear' 에 'bias = False` 옵션을 성정해서 선형 변환을 만들 수 있다.

| ![]({{site.baseurl}}/images/week01/01-3/initial_scatter_lab1.png) | ![]({{site.baseurl}}/images/week01/01-3/matrix_multiplication_lab1.png) | ![]({{site.baseurl}}/images/week01/01-3/matrix_multiplication_lab1_2.png) |
|     (a) 원본       |   (b) $s_1$ = 1.540, $s_2$ = 0.304  |   (c) $s_1$ = 0.464, $s_2$ = 0.017    |

<center> 그림 3: 무작위 행렬의 선형 변환 </center>

<!--
### Non-linear transformations

Next, we visualize the following transformation:

$$
f(\vx) = \tanh\bigg(\begin{bmatrix} s & 0 \\ 0 & s \end{bmatrix} \vx \bigg)
$$

Recall, the graph of $\tanh(\cdot)$ in Fig. 4.

<center>
<img src="{{site.baseurl}}/images/week01/01-3/tanh_lab1.png" width="250px" /><br>
Figure 4: hyperbolic tangent non-linearity
</center>

The effect of this non-linearity is to bound points between $-1$ and $+1$, creating a square. As the value of $s$ in eq. (2) increases, more and more points are pushed to the edge of the square. This is shown in Fig. 5. By forcing more points to the edge, we spread them out more and can then attempt to classify them.

| <img src="{{site.baseurl}}/images/week01/01-3/matrix_multiplication_with_nonlinearity_s=1_lab1.png" width="200px" /> | <img src="{{site.baseurl}}/images/week01/01-3/matrix_multiplication_with_nonlinearity_s=5_lab1.png" width="200px" /> |
|                 (a) Non-linearity with $s=1$                 |                 (b) Nonlinearity with $s=5$                  |

<center> Figure 5:   Non-linear Transformations </center>
-->

### 비선형 변환

다음과 같은 변환을 시각화해보자.

$$
f(\vx) = \tanh\bigg(\begin{bmatrix} s & 0 \\ 0 & s \end{bmatrix} \vx \bigg)
$$

그림 4에 있는 $\tanh(\cdot)$ 그래프를 기억하자.

<center>
<img src="{{site.baseurl}}/images/week01/01-3/tanh_lab1.png" width="250px" /><br>
그림 4: 쌍곡탄젠트 비선형변환
</center>

이 비선형 변환의 효과는 점들을 $-1$과 $+1$ 사이로 가두어 정사각형을 만드는 것이다. 수식 2에서 $s$가 증가함에 따라, 점점 더 많은 점들이 이 정사각형의 가장자리로 밀리게 된다. 이것은 그림 5에 나타나 있다. 가장자리에 더 많은 점을 보내면서, 우리는 이 점들을 더 넓게 펼치고 이들을 분류하려고 시도할 수 있다.

| <img src="{{site.baseurl}}/images/week01/01-3/matrix_multiplication_with_nonlinearity_s=1_lab1.png" width="200px" /> | <img src="{{site.baseurl}}/images/week01/01-3/matrix_multiplication_with_nonlinearity_s=5_lab1.png" width="200px" /> |
|                 (a) $s=1$ 일 때 비선형변환                 |                 (b) $s=5$ 일 때 비선형변환                  |

<center> 그림 5:  비선형변환들 </center>

<!--
### Random neural net

Lastly, we visualize the transformation performed by a simple, untrained neural network. The network consists of a linear layer, which performs an affine transformation, followed by a hyperbolic tangent non-linearity, and finally another linear layer. Examining the transformation in Fig. 6, we see that it is unlike the linear and non-linear transformations seen earlier. Going forward, we will see how to make these transformations performed by neural networks useful for our end goal of classification.

<center>
<img src="{{site.baseurl}}/images/week01/01-3/untrained_nn_transformation_lab1.png" width="200px" /><br>
Figure 6:  Transformation from an untrained neural network
</center>
-->

### 무작위 신경망

마지막으로, 학습되지 않은 간단한 신경망의 변환을 시각화해보자. 신경망은 아핀 변환을 수행하는 선형 레이어, 쌍곡탄젠트 비선형 변환, 그리고 다시 선형 레이어로 이루어져 있다. 그림 6에서 변환 결과를 살펴보면 앞에서 본 선형 및 비선형 변환과는 다르다는 것을 알 수 있다. 앞으로, 우리는 신경망에 의한 변환들을 분류라는 최종 목표에 유용하게 만드는 방법을 볼 것이다.


<center>
<img src="{{site.baseurl}}/images/week01/01-3/untrained_nn_transformation_lab1.png" width="200px" /><br>
그림 6:  학습되지 않은 신경망의 변환
</center>
