---
lang-ref: ch.01-2
lecturer: Yann LeCun
title: CNN의 발전과 활용, 왜 딥러닝인가?
authors: Marina Zavalina, Peeyush Jain, Adrian Pearl, Davida Kollmar
date: 27 Jan 2020
lang: ko
translation-date: 25 Mar 2020
translator: Gio
---


## [CNN의 발전](https://www.youtube.com/watch?v=0bMe_vCZo30&t=2965s)

<!-- In animal brains, neurons react to edges that are at particular orientations. Groups of neurons that react to the same orientations are replicated over all of the visual field.
-->
동물의 시각 피질에서 뉴런은 시야 내의 특정 영역에 존재하는 특정 윤곽선 표현에 대해 반응한다. 특정한 영역의 특정한 표현을 감지하는 특정한 뉴런들이 존재한다.

<!--Fukushima (1982) built a neural net (NN) that worked the same way as the brain, based on two concepts. First, neurons are replicated across the visual field. Second, there are complex cells that pool the information from simple cells (orientation-selective units). As a result, the shift of the picture will change the activation of simple cells, but will not influence the integrated activation of the complex cell (convolutional pooling).
-->
Fukushima (1982)는 두 가지 이론에 입각해 이러한 뇌와 똑같이 동작하는 신경망<sup>neural net(NN)</sup>을 만들었다. 하나는 시야 전체에 대응하는 뉴런들이 있다는 것이고, 또 하나는 시야 내의 표현을 감지하는 간단한 세포들로부터 정보를 가져오는 복잡한 세포가 있다는 것이다. 그 결과, 사물이 움직여도 간단한 세포들의 활성화 여부들만 변화하고 복잡한 세포의 활성화에는 변화가 없을 거라는 이론이다. (합성곱 풀링<sup>Convolutional Pooling</sup>)

<!--LeCun (1990) used backprop to train a CNN to recognize handwritten digits. There is a demo from 1992 where the algorithm recognizes the digits of any style. Doing character/pattern recognition using a model that is trained end-to-end was new at that time. Previously, people had used feature extractors with a supervised model on top.
-->
얀 르쿤 (1990)은 손으로 쓴 숫자를 인식할 합성곱 신경망<sup>Convolutional Neural Network(CNN)</sup>을 학습시키는데 역전파를 활용하였다. 유튜브에서 1992년 촬영된 다양한 스타일로 작성된 숫자를 인식하는 이 알고리즘의 시연 영상을 찾아볼 수 있다. 당시 문자/패턴 인식 분야에서, 앤드 투 앤드로 학습된 모델을 활용하는 것은 새로운 사례였다. 종래에는, 지도 학습된 모델과 특징 추출기를 함께 사용하는 것이 일반적이었기 때문이다.

<!--These new CNN systems could recognize multiple characters in the image at the same time. To do it, people used a small input window for a CNN and swiped it over the whole image. If it activated, it meant there was a particular character present.
-->
이 새로운 CNN 시스템은 한 이미지 안에 여러 숫자가 적혀있는 것도 인식할 수 있었다. 이를 위해, 사람들은 CNN 시스템에 입력을 위한 작은 창을 만들고, 이 창이 전체 이미지를 훑고 지나가게 했다. CNN 시스템이 작동하면, 특정 숫자가 이미지 안에 있음을 알 수 있었다.

<!--Later, this idea was applied to faces/people detection and semantic segmentation (pixel-wise classification). Examples include Hadsell (2009) and Farabet (2012). This eventually became popular in industry, used in autonomous driving applications such as lane tracking.
-->
얀 르쿤의 시도 이후, 이러한 기술은 안면/인물 감지와 시맨틱 분할<sup>semantic segmentation</sup>(픽셀 단위의 인식)에도 적용되었다. Hadsell (2009)와 Farabet (2012)과 같은 사례가 있다. 이는 결국 업계에서 굉장히 유명해졌고, 점차 자율주행의 차선 추적에도 적용되었다.

<!--Special types of hardware to train CNN were a hot topic in the 1980s, then the interest dropped, and now it has become popular again.
-->
1980년대엔 CNN을 학습시키기 위한 특별한 하드웨어가 논의되었지만, 점차 관심이 식었었다. 그러나 최근, 이는 다시 논의되기 시작했다.

<!--The deep learning (though the term was not used at that time) revolution started in 2010-2013. Researchers focused on inventing algorithms that could help train large CNNs faster. Krizhevsky (2012) came up with AlexNet, which was a much larger CNN than those used before, and trained it on ImageNet (1.3 million samples) using GPUs. After running for a couple of weeks AlexNet beat the performance of the best competing systems by a large margin -- a 25.8% vs 16.4% top-5 error rate.
-->
(비록 당시에 이 단어가 사용되진 않았지만) 딥러닝 혁명은 2010년에서 2013년 사이에 일어났다. 학자들은 대규모의 CNN을 빠르게 학습시킬 수 있는 알고리즘을 연구했다. Krizhevsky (2012)는 AlexNet을 개발했다. 원래 사용되던 CNN 보다 훨씬 거대한 모델이었다. 이 모델은 ImageNet(130만 개의 샘플) 데이터에서 GPU를 통해 학습되었다. 고작 몇 주만에 AlexNet은 당시 최고의 성능을 내던 모델을 큰 성능 차이로 압도했다. -- top-5 error rate에서 25.8% vs 16.4%의 성능차를 냈다.

<!--After seeing AlexNet's success, the computer vision (CV) community was convinced that CNNs work. While all papers from 2011-2012 that mentioned CNNs had been rejected, since 2016 most accepted CV papers use CNNs.
-->
AlexNet의 성공을 목도한 컴퓨터 비전(CV) 학계는 CNN에 매료됐다. 2011~2012년 사이에 CNN을 언급한 논문들은 모두 거부된 반면, 2016년 이후 대부분의 CV 논문들은 CNN을 활용한다.

<!--Over the years, the number of layers used has been increasing: LeNet -- 7, AlexNet -- 12, VGG -- 19, ResNet -- 50. However, there is a trade-off between the number of operations needed to compute the output, the size of the model, and its accuracy. Thus, a popular topic now is how to compress the networks to make the computations faster.
-->
수년 간, CNN 모델의 계층은 점점 깊어졌다: LeNet -- 7, AlexNet -- 12, VGG -- 19, ResNet -- 50. 그러나 그만큼 신경망은 출력과 모델의 크기, 정확도를 측정하는데 더 많은 연산 성능을 요구하게 되었다. 그러나, 최근 이슈가 되는 것은 이러한 신경망을 어떻게 압축하여 연산 속도를 빠르게 하느냐는 것이다.


## [딥러닝과 특징 추출](https://www.youtube.com/watch?v=0bMe_vCZo30&t=3955s)

<!--Multilayer networks are successful because they exploit the compositional structure of natural data. In compositional hierarchy,  combinations of objects at one layer in the hierarchy form the objects at the next layer. If we mimic this hierarchy as multiple layers and let the network learn the appropriate combination of features, we get what is called Deep Learning architecture. Thus, Deep Learning networks are hierarchical in nature.
-->
다계층 신경망은 데이터의 구성적 특징을 잘 활용하기에 강력하다. 한 계층에서 객체들의 조합은 다음 계층에서 하나의 객체를 구성한다. 우리는 이러한 계층을 여럿 쌓아서 신경망이 적절한 특징의 조합을 학습하도록 하여, 딥러닝 아키텍처라고 부르는 것을 만든다. 즉, 딥러닝 신경망은 본질적으로 계층적이다.
(역주. 나뭇잎과 줄기, 꽃이 합쳐저 나무라는 하나의 객체가 되는 것을 생각하면 좋다.)

<!--Deep learning architectures have led to an incredible progress in computer vision tasks ranging from identifying and generating accurate masks around the objects to identifying spatial properties of an object. Mask-RCNN and RetinaNet architectures mainly led to this improvement.
-->
딥러닝은 컴퓨터 비전 분야에 폭발적인 발전을 야기했고, 이제 컴퓨터 비전은 객체를 분류하는 것을 넘어 영역을 정확히 감지하고, 객체의 공간적 특성을 감지하는 수준까지 발전했다. Mask-RCNN과 RetinaNet 구조가 이 분야의 발전을 주도하고 있다.

<!--Mask RCNNs have found their use in segmenting individual objects, i.e. creating masks for each object in an image. The input and output are both images. The architecture can also be used to do instance segmentation, i.e. identifying different objects of the same type in an image. Detectron, a Facebook AI Research (FAIR) software system, implements all these state-of-the-art object detection algorithms and is open source.
-->
Mask RCNN은 이미지 내의 각 객체들의 영역을 분할하기 위해 등장헀다. 신경망의 입력과 출력은 모두 이미지이다. 이 구조는 또한 같은 이미지에서 동일한 유형의 서로 다른 객체를 식별하는 인스턴스 분할<sup>instance segmentation</sup>에도 사용할 수 있다. Facebook AI Research (FAIR)의 Detectron 시스템은 이러한 모든 SOTA<sup>state of the art</sup>급 객체 탐지 알고리즘을 적용하였으며, 오픈 소스이다.

<!--Some of the practical applications of CNNs are powering autonomous driving and analysing medical images.
-->
CNN의 대표적인 활용사례는 자율주행 자동차와 의료 영상 분석 분야이다.

<!--Although the science and mathematics behind deep learning is fairly understood, there are still some interesting questions that require more research. These questions include: Why do architectures with multiple layers perform better, given that we can approximate any function with two layers? Why do CNNs work well with natural data such as speech, images, and text? How are we able to optimize non-convex functions so well? Why do over-parametrised architectures work?
-->
딥러닝의 과학적/수학적 기반에 대한 연구가 꽤 진행되었음에도, 여전히 탐구할만한 흥미로운 주제들이 남아있다. 두 계층만으로도 모든 경우에 딥러닝 적용이 가능한데도 더 많은 계층을 쌓으면 성능이 좋아지는 것일까? 왜 CNN은 음성, 이미지, 텍스트 등의 데이터에서 잘 동작할까? 딥러닝이 볼록하지 않은 형태의 함수를 갖는 문제에서도 잘 작동하는 이유는 무엇일까? 필요 이상으로 큰 모델도 잘 작동하는 이유가 뭘까?

<!-- Feature extraction consists of expanding the representational dimension such that the expanded features are more likely to be linearly separable; data points in higher dimensional space are more likely to be linearly separable due to the increase in the number of possible separating planes.
-->
특징 추출은 표현의 차원을 확장하는 것으로 볼 수 있다. 이는 확장된 특징이 선형 분리 가능한 경향이 있기 때문인데, 고차원 공간의 데이터 포인트는 분리 가능한 축의 수가 많아서, 선형 분리 가능할 확률이 높기 때문이다.

<!--Earlier machine learning practitioners relied on high quality, hand crafted, and task specific features to build artificial intelligence models, but with the advent of Deep Learning, the models are able to extract the generic features automatically. Some common approaches used in feature extraction algorithms are highlighted below:
-->
초기 머신 러닝 전문가들은 고성능의 수작업으로 만들어진, 각 과업에 특화된 특징을 가진 인공지능 모델을 만들었다. 그러나 딥러닝의 발전으로, 모델들은 포괄적인 특징들을 자동으로 추출할 수 있게 되었다. 아래는 특징 추출에 일반적으로 사용되는 알고리즘 들이다.

- Space tiling
- Random Projections
- Polynomial Classifier (feature cross-products)
- Radial basis functions
- Kernel Machines

<!--Because of the compositional nature of data, learned features have a hierarchy of representations with increasing level of abstractions. For example:
-->
데이터의 구성적 특징 덕분에, 학습된 특징들은 계층이 쌓일수록 추상적 개념을 표현할 수 있는 특성을 갖는다.

<!--
-  Images - At the most granular level, images can be thought of as pixels. Combination of pixels constitute edges which when combined forms textons (multi-edge shapes). Textons form motifs and motifs form parts of the image. By combining these parts together we get the final image.
-  Text - Similarly, there is an inherent hierarchy in textual data. Characters form words, when we combine words together we get word-groups, then clauses, then by combining clauses we get sentences. Sentences finally tell us what story is being conveyed.
-  Speech - In speech, samples compose bands, which compose sounds, which compose phones, then phonemes, then whole words, then sentences, thus showing a clear hierarchy in representation.
- -->
-  이미지 - 가장 작게 보면, 이미지는 픽셀들의 집합으로 볼 수 있다. 픽셀들의 집합은 물체의 윤곽선을 구성하며, 윤곽선의 집합은 texton(여러 윤곽선을 갖는 도형)을 구성한다. 마침내 texton이 모여 사물을 구성하고, 이러한 사물이 모여 이미지가 된다.
-  텍스트 - 비슷하게, 문자 데이터에도 고유한 계층이 존재한다. 문자들은 단어를, 단어는 문장을, 문장은 글을 구성한다. 마침내 전하고자 하는 이야기를 담은 글이 탄생하는 것이다.
-  음성 - 음성 데이터에서도 샘플이 모여 주파수와 소리를 구성하고, 소리가 모여 음절, 음절이 모여 단어와 말이 된다.


## [표현을 학습하기](https://www.youtube.com/watch?v=0bMe_vCZo30&t=4767s)

<!--There are those who dismiss Deep Learning: if we can approximate any function with 2 layers, why have more?
-->
딥러닝을 단순히 생각하는 사람들은 이렇게 말한다. "모든 함수를 2개의 계층으로 구현할 수 있다면, 왜 굳이 더 깊은 층을 쌓아?"

<!-- For example: SVMs find a separating hyperplane "in the span of the data," meaning predictions are based on comparisons to training examples. SVMs are essentially a very simplistic 2 layer neural net, where the first layer defines "templates" and the second layer is a linear classifier. The problem with 2 layer fallacy is that the complexity and size of the middle layer is exponential in N (to do well with a difficult task, need LOTS of templates). But if you expand the number of layers to log(N), the layers become linear in N. There is a trade-off between time and space.
-->
예를들어, SVM<sup>support vector machine</sup>은 데이터의 범위<sup>span of data</sup>에서 선형 분류를 위한 초평면<sup>hyperplane</sup>을 찾는다. 즉, 추론이 학습 데이터의 범위 내에서 동작하는 것이다. SVM은 기본적으로 첫 번째 층이 "템플릿", 두 번쨰 층이 선형 분리기인 아주 단순한 2 계층 신경망이다. 2 계층의 문제는 중간 계층의 복잡성과 크기가 입력 값의 크기 N에 대해 기하급수적으로 증가한다는 것이다. (어려운 문제를 해결하려면, 굉장히 많은 양의 템플릿이 필요하다.) 그러나 계층의 크기를 log(N)으로 확장하면 계층은 N에 대해 선형이 된다. 즉 시간과 공간 사이에 트레이드 오프가 발생하는 것이다.

<!-- An analogy is designing a circuit to compute a boolean function with no more than two layers of gates - we can compute **any boolean function** this way! But, the complexity and resources of the first layer (number of gates) quickly becomes infeasible for complex functions.
-->
비유하자면, 이는 게이트가 두 개 이하인 boolean 함수를 계산하는 회로를 설계하는 것과 같다. - 이렇게 해도 **모든 boolean 함수**를 구현할 수는 있다! 다만 복잡한 함수에서는 첫 계층의 시간 및 공간 복잡도(게이트의 수)가 순식간에 무한대로 수렴할 것이다.

<!--What is "deep"?

- An SVM isn't deep because it only has two layers
- A classification tree isn't deep because every layer analyses the same (raw) features
- A deep network has several layers and uses them to build a **hierarchy of features of increasing complexity**
- -->
심층적<sup>deep</sup>이 뭘까?

- SVM은 계층이 두 개 밖에 없어 심층적이지 않다.
- 결정 트리<sup>classification tree</sup> 모든 계층이 동일한 (원형)특징을 분석하기에 심층적이지 않다.
- 심층<sup>deep</sup> 신경망은 여러 계층을 갖고, 이를 쌓아서 점차 추상적인(고차원적인) 특징을 다룬다.

<!--How can models learn representations (good features)?
-->
어떻게 모델이 표현(좋은 특징)<sup>representation</sup>을 배울까?

<!--Manifold hypothesis: natural data lives in a low-dimensional manifold. Set of possible images is essentially infinite, set of "natural" images is a tiny subset. For example: for an image of a person, the set of possible images is on the order of magnitude of the number of face muscles they can move (degrees of freedom) ~ 50. An ideal (and unrealistic) feature extractor represents all the factors of variation (each of the muscles, lighting, *etc.*).
-->
매니폴드 가설: 데이터는 저차원 매니폴드에 존재한다. 존재 가능한 이미지의 집합은 당연히도 무한하다. 이 중에, "자연스러운" 이미지의 부분 집합이 속해있다.
예를 들어서, 사람의 사진은 사람이 움직일 수 있는 얼굴 근육들의 자유도와 그 갯수의 크기 정도<sup>order of magnitude</sup>에 따라 무한히 많이 존재한다. 이상적인(그리고 비현실적인) 특징 추출기는 사진에 영향을 줄 수 있는 모든 표현을 학습한다.(각 근육들, 조명, 각도 **등**)

<!--Q&A from the end of lecture:
-->
수업 후 Q&A:

<!--
- For the face example, could some other dimensionality reduction technique (*i.e.* PCA) extract these features?
  - Answer: would only work if the manifold surface is a hyperplane, which it is not
-->
- 얼굴 예시에서, 특징을 추출할 때 차원 축소 기술(예를들어, PCA)을 활용할 수 있나요?
- 답: 매니폴드의 표면이 초평면일 때만 작동할 겁니다. 즉, 아니요.
