---
lang-ref: ch.01-1
lecturer: Yann LeCun
title: 딥러닝의 배경과 역사, 영감
authors: Yunya Wang, SunJoo Park, Mark Estudillo, Justin Mae
date: 27 Jan 2020
lang: ko
translation-date: 23 Mar 2020
translator: Gio
---

## [강의 계획]([https://www.youtube.com/watch?v=0bMe_vCZo30&t=217s](https://www.youtube.com/watch?v=0bMe_vCZo30&t=217s))

- 지도 학습, 신경망, 딥러닝 기초
- 역전파와 딥러닝의 구성요소
- 합성곱 신경망의 이론과 적용
- 다양한 딥러닝 아키텍처
- 딥러닝 최적화 기법과 딥러닝의 동작 원리
- 에너지 기반 모델
- 준지도 학습

## 딥러닝의 등장과 역사

딥러닝의 기본 개념인 인공 신경망은 생물의 뇌에서 영감을 받았지만, 세부적인 부분까지 완전히 동일한 것은 아니다. 예를 들어, 비행기는 하늘을 나는 새들에게서 영감을 받았지만, 새들과는 비행을 한다는 사실만 동일할 뿐, 세부적인 것은 완전히 다른 것과 같다.

딥러닝은 지금은 인공두뇌학<sup>cybernetics</sup>이라 부르는 학문에서 시작되었다. McCulloch와 Pitts가 1940년대에 진행한 연구에서 시작되었는데, 그들은 뉴런이 활성화 혹은 비활성화의 두 가지 상태를 갖는 임계점 모델이라고 보았다. 이는 뉴런들을 상호 연결하여 Boolean 회로를 만들고, 이를 통해 논리적 추론을 실행할 수 있다는 것이다. 뇌는 기본적으로 이진적 값을 갖는 뉴런으로 구성된 논리적 추론 기계이다. 뉴런들은 입력의 가중합을 계산하고 이를 각 뉴런의 임계점과 비교한다. 이 때, 가중합이 뉴런의 임계점보다 크면 뉴런은 활성화되고, 임계점보다 작으면 비활성화된다. 신경망은 이러한 뉴런들의 계층적 연결을 통해 작동한다.

1947년, Doanld Hebb은 우리의 두뇌가 뉴런들간의 연결의 강도를 조절하며 학습한다는 가설을 세웠다. 이는 hyper learning이라고 하는데, 두 뉴런이 동시에 발화하면 해당 뉴런들 사이의 연결이 강해지고, 두 뉴런이 따로 발화하면 두 뉴런 사이의 연결이 약해진다는 이론이다.

1948년 후반, Norbert Wiener에 의해 인공두뇌학이 제안되었다. 인공두뇌학은 센서와 액추에이터를 통해 피드백 루프와 자기-규제 시스템<sup>self-regulatory system</sup>을 갖춘 계를 만들 수 있다는 이론이다. 자동차의 피드백 메커니즘 규칙은 모두 이에서 비롯된 것이다.

1957년, Frank Rosenblatt은 마침내 아주 단순한 신경망의 가중치를 조절하는 학습 알고리즘인 퍼셉트론<sup>perceptron</sup>을 제시했다.

정리하면, 대량의 뉴런들을 시뮬레이션해서 지적인 기계를 만들고자 하는 시도는 1940년대에 시작되었고, 1950년대를 지나 1960년대 이후로는 완전히 잊혀졌다. 1960년대에 연구 의지가 완전히 꺾인 이유는:

- 학자들은 이진수를 다루는 뉴런을 사용했다. 그러나 역전파<sup>backpropagation</sup>가 작동하려면 연속적인 값을 갖는 활성화 함수가 필요했다. 그러나 당시 학자들은 연속적인 뉴런을 사용할 생각을 하지 못 했고, 이진수 값을 갖는 뉴런은 미분할 수 없기에 신경망을 경사<sup>gradient</sup>로 학습시킬 생각도 하지 못 하였다.
- 연속적인 뉴런에서 뉴런의 값을 가중합에 적용하려면 뉴런의 값에 가중치를 곱해야하는데, 1980년대 이전에는 두 수의 곱, 특히 부동 소수점 연산은 굉장히 느렸다. 이는 학자들이 연속적인 뉴런을 고려하는 것을 기피하게 만들었다.

딥러닝은 1985년, 역전파의 등장과 함께 다시금 부상하였다가, 1995년, 기계 학습 학계가 신경망 이론을 버림으로써 다시금 침체기를 맞았다. 그러던 2010년 초반, 사람들은 음성 인식 분야에서 신경망을 적용하여 큰 폭의 성능 향상을 이뤄내고, 이후 이 기술은 상업 분야에 널리 보급되었다. 2013년에는 컴퓨터 비전 분야의 대새가 신경망으로 옮겨갔으며, 2016년에는 자연어 처리 분야에서도 같은 일이 일어났다. 곧, 이러한 혁신은 로보틱스, 제어를 비롯한 다양한 분야에서 일어날 것이다.


### 지도 학습

딥러닝 적용 사례의 $90\%$는 지도 학습을 사용한다. 지도 학습은 대량의 입력과 출력 데이터 쌍을 준비하여, 주어진 입력에 대해 올바른 출력을 하도록 기계를 학습시키는 과정이다. 출력이 올바르다면, 개발자는 아무런 조치를 취하지 않는다. 만약 출력이 틀렸다면, 개발자는 기계가 올바른 출력을 내도록 기계의 매개 변수<sup>parameter</sup>를 조정한다. 이때 중요한 것은 매개 변수를 어떤 방향으로 얼만큼 많이 조정할지 결정하는 과정인데, 이때 사용되는 것이 경사 계산과 역전파이다.

지도 학습은 퍼셉트론과 아달라인<sup>Adaline</sup>에서 비롯된다.  아달라인은 McCulloch와 Pitts의 모델과 같은 모델에 기반하는데, 값이 임계값 이상이면 활성화되고, 미만이면 비활성화된다. 퍼셉트론은 2계층 신경망으로, 두 번째 계층이 학습 가능하고 첫 레이어는 고정된 구조이다. 대부분의 경우에, 첫 계층의 값은 무작위로 정해지며, 이러한 특성 탓에 퍼셉트론은 연관 모델<sup>associative model</sup>이라 불린다.

## [패턴 인식의 역사와 경사 하강법 소개](https://www.youtube.com/watch?v=0bMe_vCZo30&t=1461s)

지금부터 배울 것은 딥러닝 이전의 패턴 인식 분야의 기본 개념이다. 패턴 인식 모델은 기본적으로 특징 추출기<sup>feature extractor</sup>와 학습 가능한 분류기로 구성된다. 특징 추출기는 입력으로부터 유용한 특징을 추출한다. 예를 들어, 얼굴을 인식하는 모델이라면 눈을 인식하는 것과 같다. 그 다음, 추출된 특징 벡터<sup>vector of features</sup>는 학습 가능한 분류기로 입력되어 가중합을 계산하는데 사용되고, 이는 임계값과 비교된다. 이때, 학습 가능한 분류기는 퍼셉트론 혹은 단일 계층 신경망이 될 수 있다. 이때 문제는 특징 추출기를 사람이 직접 만들어야 한다는 것이다. 이는 패턴 인식/컴퓨터 비전 전문가들은 학습 가능한 분류기를 만드는 것보다 특정 상황에만 적합한 특징 추출기를 개발하는데 시간을 쏟아야 한다는 것이다.

딥러닝의 발전과 부상 이후, 이 두 단계의 과정은 여러 모듈을 쌓아놓은 모델로 변했다. 각 모듈은 조정 가능한 매개 변수와 비선형성<sup>nonlinearity</sup>을 갖는다. 이러한 모듈을 여러 계층 쌓으면, 이는 비로소 딥러닝이 된다. 비선형성을 가져야만 하는 이유는, 선형 모듈을 여러 계층 쌓더라도, 선형 함수 두 개의 조합이 선형 함수이기에, 결국 이는 하나의 선형 계층으로 변환될 수 있기 때문이다.

조정 가능한 매개 변수와 비선형성을 갖는 가장 단순한 다계층 구조는 이렇게 표현할 수 있다: 입력은 이미지나 오디오와 같은 벡터로 표현된다. 이 입력값은 계수가 조정 가능한 매개 변수인 가중치 행렬로 곱해진다. 그 다음, 그 결과 산출된 벡터의 모든 값이 ReLU 함수와 같은 비선형 함수를 통과한다. 이 과정을 반복하면, 이는 기본적인 신경망이 된다. 이를 신경망이라 할 수 있는 이유는 이 모델이 행렬의 각 행을 통해 입력에 대한 올바른 가중합을 구하기 때문이다.

지도 학습으로 돌아와서, 우리는 모델의 결과값과 우리가 원했던 결과값을 비교하고, 두 값 사이의 손실(거리/유효성/격차)을 계산하는 목표 함수<sup>objective function</sup>를 조정한다. 그 다음, 학습 데이터셋<sup>training set</sup> 전체에 대해 이 비용 함수<sup>cost function</sup>의 값 평균을 구한다. 이제, 이 비용 함수의 평균값이 우리가 최소화해야할 목표가 되는 것이다. 다르게 표현하자면, 우리는 이 비용 함수의 값을 최소화하는 적절한 매개 변수 값을 찾아야 한다.
(역주. 비용 함수, 손실 함수<sup>loss function</sup>, 오류<sup>error</sup> 등 다양한 용어가 혼용되지만 결론적으로 우리는 이 목표 함수의 값을 0에 가깝게 최소화 하여야 한다.)

그 방법은 경사를 계산하는 것이다. 예를 들어, 우리가 경사가 완만한 산에서 안개낀 밤에 길을 잃어서, 협곡 아래에 있는 마을을 찾아간다고 생각해보자. 좋은 방법 중 하나는, 주변을 둘러보며 경사가 가파른 곳을 찾아 조심스럽게 한 발자국씩 내려가 보는 것이다. 방향은 (음의 방향으로) 경사를 따라서이다. 협곡이 볼록하다는 가정하에, 우리는 마침내 협곡의 아래에 도달할 수 있을 것이다.

더욱 효율적인 방법은 확률적 경사 하강법<sup>Stochastic Gradient Descent (SGD)</sup>이라 불리는 방법이다. 학습 데이터셋에서의 평균 손실 값을 최소화하기 위해, 먼저 트레이닝 셋에서 하나 혹은 소량의 샘플을 때어내어 이들만을 대상으로 오류를 측정하고, 경사 하강법을 실시한다. 그 다음, 새로운 샘플을 때어내어 다시 오류를 측정하고 경사 하강법을 실시하면 이는 지난 번 샘플과는 다른 방향으로 진행할 것이다. SGD를 사용하는 두 가지 주된 이유는 SGD를 사용하면 방대한 트레이닝 데이터 셋에서 모델이 대체로 빠르게 수렴하며,  SGD가 더 나은 일반화를 제공하기 때문이다. 이는 모델이 다양한 종류의 데이터에서 비슷한 성능을 보여줌을 의미한다.


### [역전파로 경사 계산하기](https://www.youtube.com/watch?v=0bMe_vCZo30&t=2336s)

역전파를 통해 경사를 계산하는 것은 연쇄 법칙의 실용적인 예시 중 하나이다. state gradients에 대한 역전파는 다음과 같다:

$$
\begin{aligned}
\frac{\partial C}{\partial \boldsymbol{x}_{i - 1}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial \boldsymbol{x}_i}{\partial \boldsymbol{x}_{i - 1}} \\
\frac{\partial C}{\partial \boldsymbol{x}_{i - 1}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial f_i(\boldsymbol{x}_{i - 1}, \boldsymbol{w}_i)}{\partial \boldsymbol{x}_{i - 1}}
\end{aligned}
$$

가중치 경사에 대한 역전파는 다음과 같다:

$$
\begin{aligned}
\frac{\partial C}{\partial \boldsymbol{w}_{i}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial \boldsymbol{x}_i}{\partial \boldsymbol{w}_{i}} \\
\frac{\partial C}{\partial \boldsymbol{w}_{i}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial f_i(\boldsymbol{x}_{i - 1}, \boldsymbol{w}_i)}{\partial \boldsymbol{w}_{i}}
\end{aligned}
$$

입력값으로는 스칼라 값이 아닌 벡터 값이 입력됨을 기억하자. 보통 딥러닝에서 입력값은 이보다 더 고차원 값이다. 역전파는  모델 내부의 값에 의해 발생하는 출력값과 당신이 원하는 출력값 사이의 차이(즉, 손실 함수의 출력값)를 미분할 수 있게 해준다. 특히, 역전파는 여러 계층을 가진 모델에도 적용할 수 있기에 필수적이다.

입력을 해석하는 방법을 고려하는 것이 매우 중요하다. 예를 들어, 256$$\times$$256 의 크기를 갖는 이미지는 대략 200,000 개의 값을 갖는 행렬이다. 이는 신경망의 계층이 다루기에 너무 큰 행렬일 수 있다. 이러한 행렬을 이용하는 것은 실용적이지 않다. 따라서, 행렬의 구조에 대한 가설을 세울 필요가 있다.


## 시각 피질의 계층적 표현

Fukushima의 연구는 우리의 뇌가 눈으로부터의 입력을 어떻게 해석하는지 규명했다. 요약하자면, 그는 우리의 망막 앞에 있는 뉴런들이 입력을 압축하는 것(대비 평준화라고 한다.)과, 뇌로 전송된 이미지의 처리 과정에서 특정 뉴런들이 이미지 속 특정 대상들에 대해 반응하는 것을 발견했다. 즉, 시각 피질이 여러 계층에 걸쳐 패턴 인식을 수행하는 것을 알아낸 것이다.

학자들은 실험을 통해 시각 피질의 특정 영역, 특히 V1 영역에서 특정 뉴런이 시야 상의 아주 작은 영역에 나타나는 특정 패턴에 반응하고, 시야 내에 인접한 영역은 시각 피질 내에서도 인접한 뉴런들에 의해 처리됨을 발견했다. 추가로, 시야의 같은 영역에 반응하는 뉴런들은 각자 다른 패턴에 반응함을 알아냈다.(수평선 혹은 수직선 등) 또한, 학자들은 이로부터 시각 처리가 기본적으로 정방향<sup>feed forward</sup> 과정이기에 순환적인 신경망 연결 없이 빠른 인식이 가능하다는 아이디어를 얻을 수 있었다.
