---
lang-ref: ch.14-3
title: Overfitting and regularization
lecturer: Alfredo Canziani
authors: Karl Otness, Xiaoyi Zhang, Shreyas Chandrakaladharan, Chady Raach
date: 5 May 2020
lang: ja
translation-date: 6 Dec 2020
translator: Shiro Takagi
---


<!-- ## Overfitting -->

## 過学習

<!-- Consider a regression problem. A model could underfit, right-fit, or overfit.

If the model is insufficiently expressive for the data it will underfit. If the model is more expressive than the data (as is the case with deep neural networks), it runs the risk of overfitting.

In this case, the model is powerful enough to fit both the original data *and* the noise, producing a poor solution for the task at hand.

Ideally we would like our model to fit the underlying data and not the noise, producing a good fit for our data. We would especially like to do this without needing to reduce the power of our models. Deep learning models are very powerful, often much more than is strictly necessary in order to learn the data. We would like to keep that power (to make training easier), but still fight overfitting. -->

回帰問題を考えてみましょう。モデルは、学習不足、適切な学習、過学習のいずれかになります。

モデルの表現力がデータに対して不十分な場合、過少適合となります。モデルがデータよりも表現力が高い場合（ディープニューラルネットワークの場合のように）、過剰適合（オーバーフィッティング）のリスクがあります。

この場合、モデルは元のデータとノイズの両方を適合させるのに十分な力を持っているので、手元のタスクに対する貧弱な解を生み出します。

理想的には、モデルがノイズではなく基礎となるデータにフィットして、データに良好なフィットをもたらすことが望まれます。特に、モデルのパワーを下げることなく、これを実現したいと考えています。ディープラーニングモデルは非常に強力で、多くの場合、データを学習するために厳密に必要とされる以上のパワーを持っています。そのパワーを維持しつつ（訓練を容易にするために）、過学習と戦いたいと考えています。




<!-- ### Overfitting for debugging

Overfitting can be useful in some cases, such as during debugging. One can test a network on a small subset of training data (even a single batch or a set of random noise tensors) and make sure that the network is able to overfit to this data. If it fails to learn, it is a sign that there may be a bug. -->

### デバッグのための過学習

過学習は、デバッグ中など、いくつかのケースで有用です。学習データの小さな部分集合（単一のバッチやランダムなノイズテンソルのセットでさえも）でネットワークをテストして、ネットワークがこのデータにオーバーフィットできることを確認することができます。学習に失敗した場合は、バグがある可能性があることを示しています。


<!-- ## Regularization

We can try to fight overfitting by introducing regularization. The amount of regularization will affect the model's validation performance. Too little regularization will fail to resolve the overfitting problem. Too much regularization will make the model much less effective.

*Regularization* adds prior knowledge to a model; a prior distribution is specified for the parameters. It acts as a restriction on the set of possible learnable functions.

Another definition of regularization from Ian Goodfellow:
> Regularization is any modification we make to a learning algorithm that is intended to reduce its generalization error but not its training error. -->

## 正則化

正則化を導入することで過学習に対抗しようとすることができます。正則化の量はモデルの検証性能に影響を与えます。正則化が弱すぎると、過学習問題の解決に失敗します。正則化が強すぎると、モデルははるかに効果的ではなくなります。

*正則化*は、モデルに事前知識を追加します。すなわち、パラメータに事前分布が指定されます。これは、学習可能な関数の集合に対する制限として機能します。

Ian Goodfellowによる正則化のもう一つの定義は次のようなものです。
> 正則化とは、学習アルゴリズムの汎化誤差を減らすことを意図するが、訓練誤差を減らすことは意図していないような、学習アルゴリズムに行う修正のことです。



<!-- ### Initialization techniques

We can select a prior for our network parameters by initializing the weights according to a particular distribution. One option: [Xavier initialization](https://pytorch.org/docs/stable/nn.init.html#torch.nn.init.xavier_normal_). -->

### 初期化テクニック

特定の分布に従って重みを初期化することで、ネットワークパラメータの優先順位を選択することができます。[Xavierの初期化](https://pytorch.org/docs/stable/nn.init.html#torch.nn.init.xavier_normal_)は、この選択肢の一つです。


<!-- ### Weight decay regularisation

Weight decay is our first regularisation technique. Weight decay is in widespread use in machine learning, but less so with neural networks.  In PyTorch, weight decay is provided as a parameter to the optimizer (see for example the `weight_decay` parameter for [SGD](https://pytorch.org/docs/stable/optim.html#torch.optim.SGD)).

This is also called:

- L2
- Ridge
- Gaussian prior

We can consider an objective which acts on the parameters: -->

### 重み減衰による正則化

重み減衰は我々の最初の正則化手法です。重み減衰は機械学習では広く使われていますが、ニューラルネットワークではあまり使われていません。 PyTorchでは、オプティマイザのパラメータとして重み減衰が提供されています（例えば、 [SGD](https://pytorch.org/docs/stable/optim.html#torch.optim.SGD)の`weight_decay`パラメータを参照してください）。

これは以下のようにも呼ばれています。

- L2
- リッジ
- ガウス事前分布

パラメータに作用する目的関数を考えることができます。

$$J_{\text{train}}(\theta) = J^{\text{old}}_{\text{train}}(\theta)$$

<!-- then we have updates: -->
すると、次の更新式が得られます

$$\theta \gets \theta - \eta \nabla_{\theta} J^{\text{old}}_{\text{train}}(\theta)$$

<!-- For weight decay we add a penalty -->
重み減衰では、ペナルティ項を導入します。

$$J_{\text{train}}(\theta) = J^{\text{old}}_{\text{train}}(\theta) + \underbrace{\frac\lambda2 {\lVert\theta\rVert}_2^2}_{\text{penalty}}$$

<!-- which produces an update -->
これから、次の更新式が得られます

$$\theta \gets \theta - \eta \nabla_{\theta} J^{\text{old}}_{\text{train}}(\theta) - \underbrace{\eta\lambda\theta}_{\text{decay}}$$

<!-- This new term in the update drives the parameters $\theta$ slightly toward zero, adding some "decay" in the weights with each update. -->
この更新式の新しい項は、パラメータ $\theta$ をわずかにゼロに向けて動かし、更新のたびに重みにいくつかの「減衰」を追加します。


<!-- ### L1 regularisation -->
### L1正則化

<!-- Available as an option for PyTorch [optimizers](https://pytorch.org/docs/stable/optim.html). -->
PyTorchの[optimizers](https://pytorch.org/docs/stable/optim.html)にも選択肢として用意されています .
<!-- 
Also called:

- LASSO: Least Absolute Shrinkage Selector Operator
- Laplacian prior
- Sparsity prior

Viewing this as a Laplace distribution prior, this regularization puts more probability mass near zero than does a Gaussian distribution.

Starting with the same update as above we can view this as adding another penalty: -->

これは次のようにも呼ばれています。

- LASSO: Least Absolute Shrinkage Selector Operator
- ラプラシアン事前分布
- スパース事前分布

これをラプラス分布を事前分布として用いたものとして見ると、この正則化は、ガウス分布よりも多くの確率質量をゼロに近づけます。

上と同じ更新から始めて、これを別のペナルティを追加したと見ることができます。

$$J_{\text{train}}(\theta) = J^{\text{old}}_{\text{train}}(\theta) + \underbrace{\lambda{\lVert\theta\rVert}_1}_{\text{penalty}}$$

<!-- which produces an update -->
これは次の更新式を生み出します。

$$\theta \gets \theta - \eta \nabla_{\theta} J^{\text{old}}_{\text{train}}(\theta) - \underbrace{\eta\lambda\cdot\mathrm{sign}(\theta)}_{\text{penalty}}$$

<!-- Unlike $L_2$ weight decay, the $L_1$ regularization will "kill" components that are close to an axis in the parameter space, rather than evenly reducing the length of the parameter vector. -->
$L_2$ 重み減衰とは異なり、$L_1$ 正則化はパラメータ空間の軸に近い成分を「殺す」のであって、パラメータベクトルの長さを均等に減らすのではありません。



<!-- ### Dropout

Dropout involves setting a certain number of neurons to zero randomly during training. This prevents the network from learning a singular path from input to output. Similarly, due to the large parametrisation of neural networks, it is possible for the neural network to effectively memorize the input. However, with dropout, this is a lot more difficult since the input is being put into a different network each time since dropout effectively trains a infinite number of networks that are different each time. Hence, dropout can be a powerful way of controlling overfitting and being more robust against small variations in the input. -->

### ドロップアウト

ドロップアウトでは、訓練中に特定の数のニューロンをランダムにゼロに設定します。これにより、ネットワークは入力から出力への特異な経路を学習することができなくなります。同様に、ニューラルネットワークのパラメトリゼーションが大きいため、ニューラルネットワークが入力を効果的に記憶することが可能です。しかし、ドロップアウトの場合、ドロップアウトは毎回異なる無限個のネットワークを効果的に訓練するので入力は毎回異なるネットワークに投入されることになり、これははるかに困難となります。したがって、ドロップアウトは、過学習を制御する強力な方法となり、入力の小さな変動に対してより強固なものとなります。

<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-3/network_without_dropout.JPG" style="background-color:#DCDCDC;" /><br>
Figure 1: Network without dropout
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/network_with_dropout.JPG" style="background-color:#DCDCDC;" /><br>
Figure 2: Network with dropout
</center> -->

<center>
<img src="{{site.baseurl}}/images/week14/14-3/network_without_dropout.JPG" style="background-color:#DCDCDC;" /><br>
図1: ドロップアウトのあるネットワーク
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/network_with_dropout.JPG" style="background-color:#DCDCDC;" /><br>
図2: ドロップアウトのあるネットワーク
</center>

<!-- In PyTorch, we can set a random dropout rate of neuron. -->
PyTorchでは、ニューロンのランダムなドロップアウト率を設定することができます。

<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-3/code.JPG" style="background-color:#DCDCDC;" /><br>
Figure 3: Dropout code
</center> -->
<center>
<img src="{{site.baseurl}}/images/week14/14-3/code.JPG" style="background-color:#DCDCDC;" /><br>
図3: ドロップアウトのコード
</center>

<!-- After training, during inference, dropout is not used any more. In order to create the final network for inference, we average over all of the individual networks created during dropout and use that for inference. We can similarly multiply all of the weights by $1/1-p$ where $p$ is the dropout rate. -->
訓練後、推論中には、ドロップアウトはもう使いません。推論のための最終的なネットワークを作成するために、ドロップアウト中に作成された個々のネットワークをすべて平均化し、推論に使用します。同様に、すべての重みに $1/1-p$ をかけます。ただし$p$ はドロップアウト率です。


<!-- ### Early-stopping -->
### 早期打ち切り

<!-- During training, if the validation loss starts increasing, we can stop training and use the best weights found so far. This prevents the weights from growing too much which will start hurting validation performance at some point. In practise, it is common to calculate the validation performance at certain intervals and stop after a certain number of validation error calculations stop decreasing. -->
訓練中に、検証誤差が増加し始めたら、訓練を中止して、これまでに見つかった最も良い重みを使用します。これにより、重みが大きくなりすぎて、ある時点で検証性能に支障をきたし始めるのを防ぐことができます。実際には、一定の間隔で検証性能を計算し、検証誤差が減少しなくなったら停止するのが一般的です。
<!-- 
<center>
<img src="{{site.baseurl}}/images/week14/14-3/early_stop.JPG" style="background-color:#DCDCDC;" /><br>
Figure 4: Early stopping
</center> -->
<center>
<img src="{{site.baseurl}}/images/week14/14-3/early_stop.JPG" style="background-color:#DCDCDC;" /><br>
図 4: 早期打ち切り
</center>


<!-- # Fighting overfitting indirectly

There are techniques that have the side-effect of regularizing parameters but are not regularisers themselves.


## Batch-norm

Q. How does batch norm make training more efficient?
A. We can use higher learning rate when applying batch norm.

Batch normalization is used to prevent the internal covariate shift of a neural network but there is a lot debate if it actually does this and what the true benefit actually is. -->

# 間接的に過学習と戦う

それ自体は正則化ではないけれど、パラメータを正則化する副作用を持つテクニックがあります。


## バッチ正規化

質問：バッチ正規化はどのようにして訓練を効率化するのですか？

答え：バッチ正規化を適用すると、より大きな学習率を使うことができます。

バッチ正規化はニューラルネットワークの内部共変量シフトを防ぐために使われますが、実際にこれを行うのかどうか、本当の効果は何なのかについては多くの議論があります。


<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-3/BN.JPG" style="background-color:#DCDCDC;" /><br>
Figure 5: Batch normalization
</center> -->
<center>
<img src="{{site.baseurl}}/images/week14/14-3/BN.JPG" style="background-color:#DCDCDC;" /><br>
図5: バッチ正規化
</center>

<!-- Batch normalisation essentially extends the logic of normalizing the input of the neural network to normalizing the input of each hidden layer in the network. The basic idea is to have a fixed distribution feed each subsequent layer of a neural network since learning occurs best when we have a fixed distribution. To do this, we compute the mean and variance of each batch before each hidden layer and normalize the incoming values by these batch specific statistics, which reduces the amount by which the values will ultimately shift around during training.

Regarding the regularizing effect, due to each batch being different, each sample will be normalized by slightly different statistics based upon the batch it is in.  Hence, the network will see various slightly altered versions of a single input which helps the network learn to be more robust against slight variations in the input and prevent overfitting.

Another benefit of batch normalisation is that training is a lot faster. -->

バッチ正規化は、基本的にニューラルネットワークの入力を正規化するロジックを、ネットワーク内の各隠れ層の入力を正規化することに拡張したものです。基本的な考え方は、ニューラルネットワークの後続の各層に固定された分布を与えることです。というのも、固定された分布を持っているときに学習が最もうまくいくからです。これを行うために、各隠れ層の前に各バッチの平均と分散を計算し、これらのバッチ固有の統計量で入力値を正規化します。

各バッチが異なるため、正規化効果に関しては、各サンプルはそのバッチに基づいてわずかに異なる統計量で正規化されます。 そのため、ネットワークは1つの入力の様々なわずかに変化したバージョンを見ることになり、入力のわずかな変化に対してよりロバストな学習を行い、過学習を防ぐことができます。

バッチ正規化のもう一つの利点は、訓練が非常に速くなることです。
<!-- 
### More data

Gathering more data is a easy way to prevent overfitting but can be expensive or not feasible.


### Data-augmentation

Transformations using Torchvision can have a regularizing effect by teaching the network to learn how to be insensitive to perturbations. -->

### より多くのデータ

より多くのデータを収集することは、過学習を防ぐための簡単な方法ですが、コストがかかる場合もありますし、実現不可能な場合もあります。


### データを増やすことで、過学習を防ぐことができます。

Torchvisionを使用した変換は、摂動に鈍感になる方法をネットワークに教えることで、正規化の効果を得ることができます。


<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-3/augmentation.JPG" style="background-color:#DCDCDC;" /><br>
Figure 6: Data augmentation with Torchvision.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week14/14-3/augmentation.JPG" style="background-color:#DCDCDC;" /><br>
図6: Torchvisionによるデータ拡張
</center>


<!-- ### Transfer leaning (TF) fine-tuning (FT) -->

<!-- Transfer learning (TF) refers to just training a final classifier on top of a pre-trained network (used in cases of little data generally).

Fine tuning (FT) refers to training partial/full portions of the pre-trained netowrk as well (used in cases where we have a lot of data generally).

Q. Generally, when should we freeze the layers of a pre-trained model?
A. If we have little training data.

4 general cases:
1) If we have little data with similar distributions, we can just do transfer learning.
2) If we have a lot of data with similar distributions we can do fine-tuning in order to improve the performance of the feature extractor as well.
3) If we have a little data and a different distribution we should remove a few of the final trained layers in the feature extractor since they are too specialized.
4) If we have a lot of data and they are from different distributions, we can just train all portions.

Note, we can also use different learning rates for different layers in order to improve performance.

To further our discussion about overfitting and regularisation, let us look at the visualisations below. These visualisations were generated with the code from [Notebook](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/12-regularization.ipynb). -->

### 転移学習 (TF) fine-tuning (FT)

転移学習 (TF) は，事前に学習されたネットワークの上に最終的な分類器を学習することを意味します（一般的にデータが少ない場合に使用されます）。

Fine-tuning (FT) は，事前に学習されたネットワークの一部または全部を学習することを指します（一般的にデータが多い場合に用いられます）。

質問： 一般的に、どういう時に事前学習したモデルの層を学習しないようにさせるのですか？

答え：学習データが少ない場合です。

4つの一般的なケース。
1) 似たような分布に従うデータが少ない場合は、単に転移学習を行うことができます。
2) 似たような分布に従う多くのデータがあれば，特徴抽出器の性能を向上させるためにfine-tuningを行うことができます。
3) データが少なく、分布が異なる場合は、特徴抽出器の最終的な学習層の一部を削除すべきです。
4) 多くのデータがあり、それらが異なる分布からのものであれば、すべての部分を学習することができます。

注意：パフォーマンスを向上させるために、異なる層に対して異なる学習率を使用することもできます。


過学習と正則化についての議論をさらに深めるために、以下の可視化を見てみましょう。これらの可視化は、[Notebook](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/12-regularization.ipynb)のコードを使用して生成されました。



<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-3/loss_wo_dropout.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 7:</b> Loss curves without dropout
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/loss_w_dropout.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 8:</b> Loss curves with dropout
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/regularization_weights.png"  style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 9:</b> Effect of regularization on weights
</center> -->

<center>
<img src="{{site.baseurl}}/images/week14/14-3/loss_wo_dropout.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>図7:</b> ドロップアウトがない場合の誤差曲線
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/loss_w_dropout.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>図8:</b> ドロップアウトがある場合の誤差曲線
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/regularization_weights.png"  style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>図9:</b> 重みに対する正則化の効果
</center>

<!-- From Figure 7 and Figure 8, we can understand the dramatic effect that dropout has on generalisation error i.e the difference between the training loss and validation loss. In Figure 7, without dropout there is clear overfitting as the training loss is much lower than the validation loss. However, in Figure 8, with dropout the training loss and validation loss almost continuously overlap indicating that the model is generalising well to the validation set, which serves as our proxy for out-of-sample set. Of course, we can measure the actual out-of-sample performance using a separate holdout test set.

In Figure 9, we observe the effect that regularisation (L1 & L2) have on the weights of the network.

- When we apply L1 regularisation, from the red peak at zero, we can understand that most of the weights are zero. Small red dots closer to zero are the non-zero weights of the model.

- Contrastingly, in L2 regularisation, from the blue peak near zero we can see that most of the weights are close to zero but non-zero.

- When there is no regularisation (lavender) the weights are much more flexible and spread out around zero resembling a normal distribution. -->

図7と図8から、ドロップアウトが汎化誤差、すなわち訓練損失と検証損失の差に与える劇的な効果を理解することができます。図7では、ドロップアウトがない場合、訓練誤差は検証誤差よりもはるかに低いため、明らかに過学習が見られます。しかし、図8では、ドロップアウトがある場合、訓練誤差と検証誤差はほぼ連続的に重なっており、モデルがサンプル外集合の代理である検証集合にうまく汎化していることを示しています。もちろん、別のホールドアウトテスト集合を使用して、実際のサンプル外集合に対する性能を測定することができます。

図9では、正則化（L1とL2）がネットワークの重みに与える効果を観察しています。

- L1正則化を適用すると、ゼロの赤いピークから、ほとんどの重みがゼロであることがわかります。ゼロに近い小さな赤い点は、モデルの非ゼロの重みです。

- 対照的に、L2正則化では、ゼロに近い青いピークから、重みのほとんどがゼロに近いがゼロではないことがわかります。

- 正則化がない場合（ラベンダー）、重みは、はるかに柔軟で、正規分布に似た形でゼロの周りに広がっています。


<!-- ## Bayesian Neural Networks: estimating uncertainty around predictions

We care about uncertainty in neural networks because a network needs to know how certain/confident on its prediction.

Ex: If you build a neural networks to predict steering control, you need to know how confident the network's predictions.

We can use a neural network with dropout to get a confidence interval around our predictions. Let us train a network with dropout, $r$ being the dropout ratio.

Usually during inference, we set the network to validation mode and use all neurons to get the final prediction. While doing the prediction, we scale the weights $\delta$ by $\dfrac{1}{1-r}$ to account for dropping neurons during training.

This method gives us a single prediction for each input. However, to get a confidence interval around our prediction, we need multiple predictions for the same input. So instead of setting the network to validation mode during inference, we retain it in training mode i.e. still drop neurons randomly and get a prediction. When we predict multiple times using this dropout network, for the same input we will get different predictions depending on the neurons being dropped. We use these predictions to estimate the average final prediction and a confidence interval around it.

In the below images, we have estimated confidence intervals around the predictions of networks. These visualisations were generated with the code from [Bayesian Neural Networks Notebook](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/13-bayesian_nn.ipynb). The red line represents the predictions. The purple shaded region around the predictions represent the uncertainty i.e. variance of predictions. -->

## ベイズニューラルネットワーク：予測の不確実性の推定

ニューラルネットワークの不確実性に注目しているのは、ネットワークがどの程度の確信度を持って予測しているかを知る必要があるからです。

例：車の操縦を予測するためにニューラルネットワークを構築する場合、ネットワークの予測がどれだけ確信度が高いかを知る必要があります。

ドロップアウトを持つニューラルネットワークを使って、予測値の信頼区間を求めることができます。ここでは、ドロップアウトのあるネットワークを訓練してみましょう。

通常、推論の際には、ネットワークを検証モードに設定し、すべてのニューロンを使って最終的な予測を行います。予測を行う際には、訓練中にニューロンが落ちてしまうことを考慮して、重み $\delta$ を $\dfrac{1}{1-r}$ でスケーリングします。

この方法では、各入力に対して1つの予測が得られます。しかし、予測の信頼区間を得るためには、同じ入力に対して複数の予測が必要です。そこで、推論中にネットワークを検証モードに設定する代わりに、訓練モードのままにします。このドロップアウトネットワークを使って複数回予測を行うと、同じ入力に対して、ドロップされるニューロンに応じて異なる予測が得られます。これらの予測を使用して、最終的な予測の平均値とその周りの信頼区間を推定します。

以下の画像では、ネットワークの予測値の信頼区間を推定しています。これらの可視化は、[Bayesian Neural Networks Notebook](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/13-bayesian_nn.ipynb)のコードを使用して生成されました。赤い線が予測値を表しています。予測値の周りの紫色の網掛け領域は、不確実性、すなわち予測値の分散を表しています。


<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-3/relu_bayesian_nn.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 10:</b> Uncertainty Estimation using ReLU activation
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/tanh_bayesian_nn.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 11:</b> Uncertainty Estimation using Tanh activation
</center> -->

<center>
<img src="{{site.baseurl}}/images/week14/14-3/relu_bayesian_nn.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>図10:</b> ReLU活性化関数を使った不確実性の推定
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/tanh_bayesian_nn.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>図11:</b> Tanh活性化関数を使った不確実性の推定
</center>

<!-- As you can observe in the above images, these uncertainty estimations are not calibrated. They are different for different activation functions. Noticeably in the images, uncertainty around data points is low. Furthermore, the variance that we can observe is a differentiable function. So we can run gradient descent to minimise this variance. Thereby we can get more confident predictions. -->
上の画像で観察できるように、これらの不確かさの推定は較正されていません。活性化関数の違いによって異なります。画像の中で注目すべきは、データ点の周りの不確かさが低いことです。さらに、観察できる分散は微分可能な関数です。そのため、この分散を最小化するために勾配降下法を実行することができます。そうすることで、より信頼性の高い予測が可能になります。



<!-- #### If we have multiple terms contributing to total loss in our EBM model, how do they interact?

In EBM models, we can simply and conveniently sum the different terms to estimate the total loss.

**Digression**: A term that penalises the length of the latent variable can act as one of many loss terms in a model. The length of a vector is roughly proportional to the number  of dimensions it has. So if you decrease the number of dimensions, then the length of the vector decreases and as a result it encodes less information. In an auto-encoder setting, this makes sure that the model is retaining the most important information. So, one way to bottleneck information in latent spaces is to reduce the dimensionality of the latent space.


#### How can we determine the hyper-parameter for regularisation?

In practice, to determine the optimal hyper-parameter for regularisation i.e regularisation strength we can use

- Bayesian hyper-parameter Optimization
- Grid Search
- Random Search

While doing these searches, the first few epochs are usually enough to give us a sense of how the regularization is working. So we need train the model extensively. -->

#### EBMモデルにおいて、総損失に寄与する複数の項がある場合、それらはどのように相互作用するのでしょうか？

EBMモデルでは、総損失を推定するために、異なる項を単純かつ便利に合計することができます。

**余談**：潜在変数の長さを罰する項は、モデル内の多くの損失項の1つとして機能します。ベクトルの長さは、それが持つ次元の数にほぼ比例します。したがって、次元の数を減らすと，ベクトルの長さは減少し、その結果、より少ない情報を符号化します。オートエンコーダーの設定では、これによりモデルが最も重要な情報を保持していることが確認されます。したがって、潜在空間の情報をボトルネックにする1つの方法は、潜在空間の次元数を減らすことです。


#### 正則化のためのハイパーパラメータはどのようにして決定すればよいのでしょうか？

実際には、正則化に最適なハイパーパラメータ、すなわち正則化の強さを決定するには、以下の方法を用いることができます。

- ベイズハイパーパラメータ最適化
- グリッドサーチ
- ランダムサーチ

これらの探索を行っている間、通常、最初の数エポックあれば正則化がどのように機能しているかの感覚を得るのに十分です。ですから、モデルを網羅的に訓練する必要があります。
