---
lang-ref: ch.14-2
lecturer: Yann LeCun
title: Graphical Energy-based Methods
authors: Yada Pruksachatkun, Ananya Harsh Jha, Joseph Morag, Dan Jefferys-White, and Brian Kelly
date: 4 May 2020
lang: ja
translation-date: 6 Dec 2020
translator: Shiro Takagi
---

<!-- ## Comparing Losses -->
## 誤差を比較する

<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-2/GT.png" style="background-color:#DCDCDC;" /><br>
Figure 1: Network Architecture
</center> -->
<center>
<img src="{{site.baseurl}}/images/week14/14-2/GT.png" style="background-color:#DCDCDC;" /><br>
図1: ネットワークアーキテクチャ
</center>

<!-- In the figure above, incorrect paths have -1.

Professor LeCun starts with perceptron loss, which is used in the example of Graph Transformer Model in the figure above. The goal is to make energy of wrong answers large, and correct ones small.

In terms of implementation, you would represent the arcs in the visualization with a vector. Rather than a separate arc for each category, one vector contains both the categories and the score for each category.

Q: How is the segmentor implemented in the model above?

A: The segment is handcrafted heuristics. The model uses a handcrafted segment although there is a way to make it trainable end-to-end. This handcrafted approach was superseded by the sliding window approach for character recognition. -->

上の図では、正しくないパスには-1がつきます。

LeCun教授は、上の図のグラフtransformerモデルの例で使われているパーセプトロン損失から始めます。目的は、間違った答えのエネルギーを大きくし、正しい答えのエネルギーを小さくすることです。

実装の面では、円弧の可視化をベクトルで表現します。各カテゴリごとに別々の弧を描くのではなく、1つのベクトルにカテゴリと各カテゴリのスコアの両方が含まれています。

Q: 上記のモデルでは、セグメンテーションはどのように実装されていますか？

A: セグメンテーションは手作りのヒューリスティックで行われます。エンドツーエンドで学習可能にする方法もありますが、このモデルでは手動で作られたセグメントを使用しています。この手動のアプローチは、文字識別のためのスライディングウィンドウアプローチに取って代わられました。


<!-- ## Overview of Losses -->
## 損失のおさらい

<!-- <center>
Table 1: Various Loss Equations
</center> -->
<center>
テーブル 1: 様々な損失の式
</center>

<!-- | Loss Equation | Formula  | Margin | -->
| 名前 | 式  | マージン |
| :---- | :----: | ---:|
| Energy Loss | $\text{E}(\text{W}, \text{Y}^i, \text{X}^i)$ | None |
| Perceptron | $\text{E}(\text{W}, \text{Y}^i, \text{X}^i)-\min\limits_{\text{Y}\in\mathcal{Y}}\text{E}(\text{W}, \text{Y}, \text{X}^i)$ | 0  |
| Hinge  | $\max\big(0, m + \text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)$  | $m$ |
| Log  | $\log\bigg(1+\exp\big(\text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)$ | >0 |
| LVQ2  | $\min\bigg(M, \max\big(0, \text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)$ | 0 |
| MCE | $\bigg(1+\exp\Big(-\big(\text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\Big)\bigg)^{-1}$| >0 |
| Square-Square | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i)^2-\bigg(\max\big(0, m - \text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)^2$ | $m$ |
| Square-Exp | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i)^2 + \beta\exp\big(-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)$ | >0 |
| NNL/MMI | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i) + \frac{1}{\beta}\log\int_{y\in\mathcal{Y}}\exp\big(-\beta\text{E}(\text{W}, y,\text{X}^i)\big)$ | >0 |
| MEE |$1-\frac{\exp\big(-\beta E(W,Y^i,X^i)\big)}{\int_{y\in\mathcal{Y}}\exp\big(-\beta E(W,y,X^i)\big)}$ | >0 |


<!-- The perceptron loss seen in the table above does not have a margin, and thus the loss has a risk of collapsing.

* Hinge loss is taking the energy of the most offending answer, and the correct answer, and computing their difference. Intuitively, with a margin m, the hinge will only have loss of 0 when the correct energy is lower than the most offending energy by _at least_ m.
* MCE loss is used in speech recognition, and looks similar to a sigmoid.
* NLL loss aims to make the energy of the correct answer small, and make the log component of the equation large.

Q: How may hinge be better than NLL loss?

A: Hinge is better than NLL becuase hinge will try to push the difference between the correct answer and other answers to infinity, whereas hinge only wants to make it larger than some value (the margin m).  -->

上の表のパーセプトロン損失にはマージンがないため、損失が破綻する危険性があります。

* ヒンジ損失は最も問題のある答えと正しい答えのエネルギーを取り、その差を計算します。直感的には、マージンがmの場合、ヒンジは、正解のエネルギーが最も問題のあるエネルギーよりも少なくともm以上低い場合にのみ、損失が0になります。
* MCE損失は音声認識に使用され、シグモイドに似ています。
* NLL損失は、正解のエネルギーを小さくし、方程式の対数成分を大きくすることを目的としています。

Q: ヒンジ損失はどうにしてNLL損失よりも優れているのでしょうか？

A: NLL損失は正解と他の解答の差を無限大にしようとするのに対し、ヒンジ損失はそれをある値(マージンm)よりも大きくしようとするだけなので、NLLよりも優れています。

<!-- ### DEFINITION:

A decoder inputs a sequence of vectors that indicate the scores or energy of individual sounds or images, and picks out the best possible output.

Q: What are some examples of problems that can use decoders? 
A: Language modelling, machine translation, and sequence tagging. 

## Forward algorithm in Graph Transformer Networks

### Graph Composition

Graph composition allows us to combine two graphs. In this example we can see a language model lexicon being represented as a $trie$ (a graph) and a recognition graph which is produced by a neural network. -->

### 定義：

デコーダは、個々の音や画像のスコアやエネルギーを示す一連のベクトルを入力として受け、可能な限り最適な出力を選び出します。

Q: デコーダを利用できる問題の例を教えてください。

A: 言語モデリング、機械翻訳、系列へのタグ付けなどです。

## グラフtransformerネットワークにおける順伝播アルゴリズム

### グラフの合成

グラフの合成では、2つのグラフを組み合わせることができます。この例では、$trie$（グラフ）として表現された言語モデルの辞書と、ニューラルネットワークによって生成された識別グラフを見ることができます。

<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-2/graph_composition.png" height="50%" width="50%" /><br>
<b>Figure 2</b>: Graph Composition
</center> -->
<center>
<img src="{{site.baseurl}}/images/week14/14-2/graph_composition.png" height="50%" width="50%" /><br>
<b>図2</b>: グラフの合成
</center>

<!-- The recognition graph specifies with different energy values (associated with each arc) how likely a character is at a particular step.

Now, for this example, the question we answer with a graph composition operation is, what is the best path in this recognition graph that also agrees with our lexicon?

The common hop from step 1 to step 2 between the recognition graph and the grammar is the character $c$, associated with energy 0.4. Hence, our interpretation graph contains just 1 arc between step 1 and 2 corresponding to $c$. Similarly, possible characters between step 2 and 3 are $x$, $u$ and $a$ in the recognition graph. Branches following $c$ in the grammar graph contain $u$ and $a$. So, the graph composition operation picks out arcs $u$ and $a$ to be present in the interpretation graph. It also associates the arc it copies from the recognition graph with their energy values. 

If the grammar also contained energy values associated with arcs, the graph composition would have added the energy values or combined them using some other operator.

In a similar fasion, graph composition also allows us to combine two knowledge bases that are represented by neural networks. In the example discused above, the grammar can essentially be represented as a neural network predicting the next character. The softmax output of the NN provides us with the transition probabilities to the next character from a given node.

As a side note, if the language model shown in this example is a neural network, we can backpropagate through the entire structure. This becomes an example of a differentiable program where we backpropagate through a program containing loops, if-conditions, recursions etc. -->

識別グラフは、（各円弧に関連付けられた）異なるエネルギー値で、ある文字が特定のステップでどの程度の可能性があるかを指定します。

さて、この例では、グラフの合成操作で答える質問は、この識別グラフの中で、私たちの辞書と一致する最良のパスは何か、ということです。

識別グラフと文法の間のステップ1からステップ2への共通ホップは、エネルギー0.4の文字$c$です。したがって、我々の解釈グラフには、ステップ 1 とステップ 2 の間に $c$ に対応する円弧が 1 つだけ含まれています。同様に、ステップ2とステップ3の間にあり得る文字は、識別グラフでは、$x$, $u$, $a$です。文法グラフの$c$に続く枝には、$u$と$a$が含まれています。そこで、グラフ合成演算は、解釈グラフに存在する円弧 $u$ と $a$ を選び出します。また、識別グラフからコピーした円弧を、それらのエネルギー値に関連付けます。

もし文法にも円弧に関連するエネルギー値が含まれていたとしたら、グラフの合成はエネルギー値を追加するか、他の演算子を使ってそれらを結合していたでしょう。

同様の流れで、グラフの合成はまた、ニューラルネットワークによって表現される２つの知識ベースを結合することを可能にします。上で説明した例では、文法は本質的に次の文字を予測するニューラルネットワークとして表現することができます。NNのsoftmax出力は、与えられたノードから次の文字への遷移確率を提供してくれます。

余談ですが、この例で示されている言語モデルがニューラルネットワークであれば、構造全体を誤差逆伝播することができます。これは、ループ、if条件、再帰などを含むプログラムを逆伝播する微分可能なプログラムの例になります。

<!-- ### A check reader from mid-90s -->
### 90年代半ばのチェックリーダー

<!-- The entire architecture of a check reader from the mid-90s is quite complex, but what we are primarily interested in, is the part starting from the character recogniser, which produces the recognition graph. -->
90年代半ばのチェックリーダーの全体のアーキテクチャは非常に複雑ですが、私たちが主に興味を持っているのは、識別グラフを生成する文字識別器から始まる部分です。

<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png"/><br>
<b>Figure 3</b>: Check reader
</center> -->
<center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png"/><br>
<b>図3</b>: チェックリーダー
</center>
<!-- 
This recongnition graph undergoes two separate composition operations, one with the correct interpretation (or the ground truth) and second with the grammar which creates a graph of all possible interpretations.

<!-- The entire system is trained via the Negative Log-Likelihood loss function. The negative log-likelihood says that each path in the interpretation graph is a possible interpretation and sum of energies along that path is the energy of that interpretation.

Now, instead of using the Viterbi algorithm, we use the forward algorithm. The following sub-sections discuss the differences between the two approaches. -->

この識別グラフは、2つの別々の合成操作を受けます。1つは正しい解釈（または真の値）で、2つ目は文法で、これによってすべての可能な解釈のグラフを作成します。

システム全体は負の対数尤度損失関数を使って学習されます。負の対数尤度を用いるとはつまり、解釈グラフの各パスが可能な解釈であり、そのパスに沿ったエネルギーの総和がその解釈のエネルギーであるということです。

ここで、ビタビアルゴリズムの代わりに、フォワードアルゴリズムを使用します。以下のサブセクションでは、2つのアプローチの違いを議論します。

<!-- #### Viterbi algorithm

Viterbi algorithm is a dynamic programming algorithm that is used to find the most likely path (or the path with the minimum energy) in a given graph. It minimises the energy with respect to a latent variable z, where z represents the path we are taking in the graph. -->

#### ビタビアルゴリズム

<!-- Viterbi algorithm is a dynamic programming algorithm that is used to find the most likely path (or the path with the minimum energy) in a given graph. It minimises the energy with respect to a latent variable z, where z represents the path we are taking in the graph. -->
ビタビアルゴリズムは、与えられたグラフの中で最も可能性の高いパス（またはエネルギーが最小となるパス）を見つけるために使用される動的計画法です。これは、潜在変数 $z$ に関するエネルギーを最小化します。

$$F (x, y) = \min_{z} \; E(x, y, z)$$

<!-- #### The forward algorithm -->
#### フォワードアルゴリズム

<!-- The forward algorithm, on the other hand, computes the log of sum of exponentials of the negative value of energies of all paths. This mouthful can be easily seen as a formula below: -->
一方、フォワードアルゴリズムは、すべてのパスの負のエネルギーの指数の和の対数を計算します。これは、以下の式で簡単にわかります。

$$F_{\beta} (x, y) = -\frac{1}{\beta} \; \log \; \sum_{z \, \in \, \text{paths}} \; \exp \, (- \beta \; E(x, y, z))$$

<!-- This is marginalising over the latent variable z, which defines the paths in an interpretation graph. This approach computes this log sum exponential value over all possible paths to a particular node. This is like combning the cost of all possible paths in a soft-minimum way.

The forward algorithm is cheap to implement and does not cost more than Viterbi algorithm. Also, we can backpropagate through the forward algorithm node in the graph.

The working of the forward algorithm can be shown using the following example defined on an interpretation graph. -->

これは、解釈グラフのパスを定義する潜在変数$z$を周辺化しています。このアプローチでは，特定のノードへのすべての可能なパスについて，この対数和指数値を計算します。これは、ソフトミニマムな方法で、すべての可能なパスのコストを計算するようなものです。

フォワードアルゴリズムは実装が安価で、ビタビアルゴリズムよりもコストがかかりません。また、グラフ上のノードを経由して誤差逆伝播することも可能です。

フォワードアルゴリズムの動作は、解釈グラフ上に定義された以下の例を用いて示すことができます。

<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-2/interpretation_graph.png" height="50%" width="50%" /><br>
<b>Figure 4</b>: Interpretation graph
</center> -->
<center>
<img src="{{site.baseurl}}/images/week14/14-2/interpretation_graph.png" height="50%" width="50%" /><br>
<b>図4</b>: 解釈グラフ
</center>


<!-- The cost from the input node to the red shaded node is computed by marginalising over all possible paths reaching the red node. The arrows entering the red node define these possible paths in our example.

For the red node, the value of energy at the node is given by: -->

入力ノードから赤い網掛けのノードまでのコストは、赤いノードに到達する可能性のあるすべてのパスを周辺化することによって計算されます。赤いノードに入る矢印は、この例ではこれらの可能なパスを定義しています。

赤色のノードでは、ノードでのエネルギーの値は次のように与えられます。

$$-\frac{1}{\beta} \; \log \; [ \, \exp \, (- \, \beta (e_1 \, + \, e_3)) \; + \; \exp \, (- \, \beta (e_2 \, + \, e_4)) \, ]$$

<!-- #### Neural network analogy of forward algorithm -->
#### フォワードアルゴリズムのアナロジーとしてのニューラルネットワーク

<!-- The forward algorithm is a special case of the belief-propagation algorithm, when the underlying graph is a chain graph. This entire algorithm can be viewed as a feed-forward neural network where the function at each node is a log sum of exponentials and an addition term. 

For each node in the interpretation graph, we maintain a variable $\alpha$. -->

フォワードアルゴリズムは、基礎となるグラフが鎖グラフである場合の信念伝播アルゴリズムの特殊なケースです。このアルゴリズム全体は、各ノードでの関数が指数と加算項の対数和であるフィードフォワードニューラルネットワークとして見ることができます。

解釈グラフの各ノードについて、変数$\alpha$を維持します。

$$ \alpha_{i} = - \; \log \; \biggl[ \sum_{k \, \in \, \text{parent} \, (i)} \; \exp \, (- \, \beta \; (\alpha_k \, + \, e_{ki})) \biggl]$$

<!-- where $e_{ki}$ is the energy of the link from node $k$ to node $i$.  -->
ここで、$e_{ki}$は、ノード$k$からノード$i$へのリンクのエネルギーです。

<!-- $\alpha_i$ forms the activation of a node $i$ in this neural network and $e_{ki}$ is the weight between nodes $k$ and node $i$. This formulation is algebraically equivalent to the weighted sum operations of a regular neural network in the log domain.

We can backpropagate through the dynamic interpretation graph (since it changes from example to example) on which we apply the forward algorithm. We can compute the gradients of $F(x, y)$ computed at the last node of the graph w.r.t the $e_{ki}$ weights defining the edges of the interpretation graph. -->

このニューラルネットワークにおいて、$\alpha_i$はノード$i$の活性を形成し、$e_{ki}$はノード$k$とノード$i$の間の重みです。この定式化は、対数領域における通常のニューラルネットワークの重み付き和と代数的に等価です。

フォワードアルゴリズムを適用した動的解釈グラフ（例から例へと変化するので）を誤差逆伝播することができます。解釈グラフのエッジを定義する $e_{ki}$ の重みを用いて、グラフの最後のノードで計算された $F(x, y)$ の勾配を計算することができます。

<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png" /><br>
<b>Figure 5</b>: Check reader
</center> -->
<center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png" /><br>
<b>図5</b>: チェックリーダー
</center>
<!-- 
Returning back to the check reader example, we apply the forward algorithm on the two graph compositions and obtain the energy value at the last node using the log sum exponential forumla. The difference between these energy values is the negative log-likelihood loss.

<!-- The value obtained from applying the forward algorithm on the graph composition between correct answer and recognition graph is the log sum exponential value of the correct answer. In contrast, log sum exponential value at the last node of the graph composition between recognition graph and grammar is the marginalised value over all possible valid interpretations. -->

チェックリーダーの例に戻り、2つのグラフ合成にフォワードアルゴリズムを適用し、対数和指数を使用して最後のノードでのエネルギー値を求めます。これらのエネルギー値の差が負の対数尤度損失です。

正解グラフと識別グラフの間のグラフ構成にフォワードアルゴリズムを適用して得られる値は、正解の対数和指数値です。対照的に、識別グラフと文法の間のグラフ構成の最後のノードでの対数和指数値は、すべての可能性のある有効な解釈にわたって周辺化された値です。

<!-- # Lagrangian formulation of Backpropagation
For an input $x$ and target output $y$, we can formulate a network as a collection of functions, $f_k$ and weights, $w_k$ such that successive steps in the network output $z_k$ with $z_{k+1} = f_k(z_k, w_k)$. In a supervised setting, the goal of the network is to minimize $C(z_n, y)$, the cost of the $n^\mathrm{th}$ output of the network, with respect to the ground truth. This is equivalent to the problem of minimizing $C(z_n, y)$ with respect to the constraints $z_{k+1} = f_k(z_k, w_k)$ and $z_0 = x$. -->

# 誤差逆伝播のラグランジアンによる定式化
入力 $x$ と目標出力 $y$ に対して、ネットワークを関数 $f_k$ と重み $w_k$ の集合として定式化すると、ネットワークの連続するステップが $z_{k+1} = f_k(z_k, w_k)$ で $z_k$ を出力するようになります。教師あり学習の場合では、ネットワークの目標は、ネットワークの $n$番目の出力のコストである $C(z_n, y)$ を、真の値に対して最小化することです。これは、制約 $z_{k+1} = f_k(z_k, w_k)$ と $z_0 = x$ に対して $C(z_n, y)$ を最小化する問題と等価です。

<!-- The Lagrangian can be written: -->
ラグランジアンは次のように書くことができます：
<!-- $$ \mathcal{L}(x, y, \lambda_i, z_i, w_i) = C(z_n, y) + \sum\limits_{k=0}^{n-1} \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) $$ -->
$$ \mathcal{L}(x, y, \lambda_i, z_i, w_i) = C(z_n, y) + \sum\limits_{k=0}^{n-1} \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) $$
<!-- where the $ \lambda $ terms denote Lagrange multipliers (see [Paul's online notes](http://tutorial.math.lamar.edu/Classes/CalcIII/LagrangeMultipliers.aspx) for a refresher if Calc 3 was a while ago). -->
ここで $\lambda$ の項はラグランジュの未定乗数を表します（Calc 3 を受けたのが少し前であれば、[Paul's online notes](http://tutorial.math.lamar.edu/Classes/CalcIII/LagrangeMultipliers.aspx)を参照してください）。

$\mathcal{L}$を最小化するためには、$\mathcal{L}$の偏微分を、それぞれの引数についてゼロにして解く必要があります。
<!-- To minimize $\mathcal{L}$, we need to set the partial derivatives of $\mathcal{L}$ with respect to each of its arguments to zero and solve. -->

<!-- - For $\lambda$, we simply recover the constraint: $\frac{\partial{\mathcal{L}}}{\partial \lambda_{k+1}} = 0 \rightarrow z_{k+1} = f_k(z_k, w_k)$.
- For $z_k$, $\frac{\partial \mathcal{L}}{\partial z_k} = 0 \rightarrow \lambda^T_k - \lambda^T_{k+1} \frac{\partial f_k(z_k, w)}{\partial z_k} \rightarrow \lambda_k = \frac{\partial f_k(z_k, w_k)^T}{\partial z_k}\lambda_{k+1}$, which is just the standard backpropagation formula. -->
- $\lambda$について、単に制約: $\frac{\partial{\mathcal{L}}}{\partial \lambda_{k+1}} = 0 \rightarrow z_{k+1} = f_k(z_k, w_k)$を復元します。
- $z_k$について、$\frac{\partial \mathcal{L}}{\partial z_k} = 0 \rightarrow \lambda^T_k - \lambda^T_{k+1} \frac{\partial f_k(z_k, w)}{\partial z_k} \rightarrow \lambda_k = \frac{\partial f_k(z_k, w_k)^T}{\partial z_k}\lambda_{k+1}$。これは、単なる普通の誤差逆伝播の式です。

<!-- This approach originated with Lagrange and Hamilton in the context of Classical Mechanics, where the minimization is over the energy of the system and the $\lambda$ terms denote physical constraints of the system, such as two balls being forced to stay at a fixed distance from each other by virtue of being attached by a metal bar, for example. -->
このアプローチは、古典力学の文脈でラグランジュとハミルトンに由来します。そこでは最小化はシステムのエネルギーについて行っており、$\lambda$項は、システムの物理的な制約を示しています。例えば二つの球を金属の棒でくっつけることで、二つの球が固定した距離を保っているように強制するようなものです。

<!-- In a situation where we need to minimize the cost $C$ at every time step, $k$, the Lagrangian becomes
$$ \mathcal{L} = \sum_k \left(C_k(z_k, y_k) + \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) \right) $$. -->
時間ステップごとに $k$ のコスト $C$ を最小化する必要がある状況では、ラグランジアンは次のようになります
$$\mathcal{L} = \sum_k \left(C_k(z_k, y_k) + \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) \right)$$

# Neural Ordinary Differential Equation
<!-- Using this formulation of backprop, we can now talk about a new class of models, Neural ODEs. These are basically recurrent networks where the state, $z$, at time $t$ is given by
$ z_{t+\text{d}t} = z_t + f(z_t, W) dt  $, where $ W$ represents some set of fixed parameters. This can also be expressed as an ordinary differential equation (no partial derivatives): $\frac{\text{d}z}{\text{d}t} = f(z_t, W)$.

Training such a network using the Lagrangian formulation is very straightforward. If we have a target, $y$, and want the state of the system to reach $y$ by time $T$, we simply establish the cost function as the distance between $z_T$ and $y$. Another goal of the network could be to find a stable state of the system, i.e. one that ceases to change after a certain point. Mathematically, this is equivalent to setting $\frac{\text{d}z}{\text{d}t} = f(y, W) = 0$. In general, finding a solution, $y$ to this equation is much easier than back propagation through time, because the network need not remember the gradient with respect to the whole sequence, and only has to minimize $f$ or $\lvert f \rvert^2$. For more information about training neural ODE's to reach fixed points, see [(Lecun88)](http://yann.lecun.com/exdb/publis/pdf/lecun-88.pdf). -->

この誤差逆伝播の式を使って、ニューラルODEという新しいクラスのモデルについて話すことができます。これらは、基本的にはリカレントネットワークであり、 $t$ における状態 $z$ は次のように与えられます：
$z_{t+\text{d}t} = z_t + f(z_t, W) dt$。ここで、$W$ は固定パラメータの集合を表します。これは，常微分方程式（偏微分なし）で表現することもできます： $\frac{\text{d}z}{\text{d}t} = f(z_t, W)$。

このようなラグランジュ方程式を用いたネットワークの学習は非常に簡単です。目標$y$があり、システムの状態が時間$T$までに$y$に到達するようにしたい場合、コスト関数を$z_T$と$y$の間の距離として設定するだけです。ネットワークのもう一つの目的は、システムの安定した状態、つまり、ある点を境に変化しなくなる状態を見つけることかもしれません。数学的には、これは $\frac{\text{d}z}{\text{d}t} = f(y, W) = 0$ とするのと同じです。一般的に、この方程式の解 $y$ を見つけることは、時間の逆伝播よりもはるかに簡単です。なぜなら、ネットワークは、全シーケンスに関する勾配を記憶する必要がなく、 $f$ または  $\lvert f \rvert^2$ を最小化すればよいからです。固定点に到達するためのニューラルODEの訓練については、 [(Lecun88)](http://yann.lecun.com/exdb/publis/pdf/lecun-88.pdf)を参照してください。

<!-- # Variational Inference in terms of Energy -->
# エネルギーの意味における変分推論

<!-- ## Introduction -->
## 導入
<!-- For an elementary energy function $E(x,y,z)$, if we wish to marginalize over a variable, z, to obtain a loss in terms of only $x$ and $y$,  $L(x,y)$, we must compute -->
ある初等的なエネルギー関数 $E(x,y,z)$ を、変数 $z$ に対して周辺化して、 $x$ と $y$ と $L(x,y)$ だけの損失を得るには、次の計算をしなければなりません。

$$L(x,y) = -\frac{1}{\beta}\int_z \exp(-\beta E(x,y,z))$$

<!-- If we then multiply by $\frac{q(z)}{q(z)}$, we get
$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$ -->
$\frac{q(z)}{q(z)}$をかけると、 次の式を得ます
$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$

<!-- If we assume that $q(z)$ is a probability distribution over $z$, we can interpret our rewritten loss function integral as an expected value, with respect to the distribution of $\frac{\exp({-\beta E(x,y,z)})}{q(z)}$. -->
$q(z)$を$z$上の確率変数とすると、書き直した損失関数の積分を、 分布$\frac{\exp({-\beta E(x,y,z)})}{q(z)}$に関する期待値として解釈することができます。
 <!-- we can interpret our rewritten loss function integral as an expected value, with respect to the distribution of $\frac{\exp({-\beta E(x,y,z)})}{q(z)}$. -->

<!-- We use this interpretation, Jensen's Inequality, and sampling-based approximations, to indirectly optimize our loss function. -->
この解釈、イェンセンの不等式、サンプリングに基づく近似を用いて、間接的に損失関数を最適化します。

<!-- ## Jensen's Inequality -->
## イェンセンの不等式

<!-- Jensen's Inequality is a geometrical observation that states: if we have a convex function, then the *expectation* of that function, over a range, is less than the average of the function evaluated at the beginning and end of the range. Geometrically illustrated this is very intuitive: -->
イェンセンの不等式は、次のようなことを述べる幾何学的な観察です：凸関数がある場合、その関数の*期待値*は、ある範囲にわたって、範囲の最初と最後に評価された関数の平均値よりも小さくなります。幾何学的に説明すると、これは非常に直感的です。


<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-2/wikipedia_jensens_inequality.png" height="50%" width="50%" style="background-color:#DCDCDC;" /><br>
<b>Figure 6:</b> Jensen's Inequality (taken from [Wikipedia](https://en.wikipedia.org/wiki/Jensen%27s_inequality))
</center> -->
<center>
<img src="{{site.baseurl}}/images/week14/14-2/wikipedia_jensens_inequality.png" height="50%" width="50%" style="background-color:#DCDCDC;" /><br>
<b>図6:</b> イェンセンの不等式([Wikipedia](https://en.wikipedia.org/wiki/Jensen%27s_inequality)から)
</center>

<!-- 
Likewise, if $F$ is convex, for a fixed probability distribution $q$, we can infer from  Jensen's Inequality that over the range $z$, -->
同様に、$F$が凸である場合、固定された確率分布 $q$ に対して、イェンセンの不等式から、 $z$ の範囲にわたって、 $f$ が凸であることが推論できます。

$$F\Bigg(\int_z q(z)h(z)\Bigg) \leq \int_z q(z)F(h(z)) \tag{1}$$

<!-- Now, recall that our marginalized $L(x,y)$ after multiplication with $\frac{q(z)}{q(z)}$ is,  
$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$ -->
今、$\frac{q(z)}{q(z)}$がかけられた後の、周辺化された$L(x,y)$は、次のようになることを思い出してください
$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$

<!-- If we make $h(z) = -\frac{1}{\beta} \frac{\exp({-\beta E(x,y,z)})}{q(z)}$, we know from Jensen's Inequality $(1)$ that -->
$h(z) = -\frac{1}{\beta} \frac{\exp({-\beta E(x,y,z)})}{q(z)}$とすると、イェンセンの不等式$(1)$から、次のことがわかります

$$F\Bigg(\int_z q(z)\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg) \leq \int_z q(z)F\Bigg(\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg)$$

<!-- Let's continue to work this, with a concrete convex loss function, $F(x) = -\log(x)$ -->
引き続き、具体的な凸な損失関数として $F(x) = -\log(x)$ を使ってみましょう。

$$-\log\Bigg(-\frac{1}{\beta}\int_z q(z)\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg) \leq \int_z q(z) * \frac{-1}{\beta}\log\Bigg(\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg)$$

$$\leq \int_z q(z)[E(x,y,z) + \frac{1}{\beta}\log(q(z))]$$

$$\leq \int_z q(z)E(x,y,z) + \frac{1}{\beta}\int_z q(z)\log(q(z))$$

<!-- Great! Now we have an upper bound to our loss function $L(x,y)$, composed of two terms we understand. The first term $\int_z q(z)E(x,y,z)$ is the *average* energy. And the second term $\frac{1}{\beta}\int_z\log(q(z))$ is just some factor ($-\frac{1}{\beta}$) times the *entropy* of the distribution $q$. -->
すばらしい！これで損失関数 $L(x,y)$の上限がわかりました。 上限は私たちが知っている2つの項で構成されています 最初の項 $\int_z q(z)E(x,y,z)$ は *平均* エネルギーです。 そして、２番目の項 $\frac{1}{\beta}\int_z\log(q(z))$ は、いくつかの因子($-\frac{1}{\beta}$)に、分布$q$の*エントロピー*をかけたものです。

<!-- ## What's the point?

We now have formulated an upper bound in such a way that we can avoid complicated integrations, and instead simply approximate these values by sampling from a surrogate distribution ($q(z)$), of our choice!

To get the value of the first term of our upper bound function, we just sample from that distribution, and compute the average value of $L$ that we obtain from applying our sampled $z$'s.

The second term (a factor of entropy) is just a property of the distribution family, and can likewise be approximated with random sampling of $q$.

Finally, we can minimize $L$ with respect to its parameters (say, weights of a network $W$), by minimizing this function that bounds $L$ above. We conduct this minimization by updating our two variables: (1) the entropy of $q$, and (2) our model parameters $W$. -->

# 要点は何でしょうか？

これで、複雑な積分を避けることができるように上界を定式化することができました。複雑な積分をする代わりに、我々の選択した代理分布($q(z)$)からサンプリングすることで、これらの値を単純に近似することができます!

上界の関数の最初の項の値を得るために、その分布からサンプリングし、サンプリングした $z$ を適用して得られる $L$ の平均値を計算します。

2番目の項（エントロピーの因子）は、分布族の性質であり、同様に $q$ のランダムサンプリングで近似することができます。

最後に、パラメータ（例えば、ネットワーク $W$ の重み）に関して $L$ を最小化することで、 $L$ を最小化することができます。この最小化は、2つの変数を更新することで行います。(1) $q$のエントロピー、(2)モデルのパラメータ$W$です。

<!-- ## Summary
This is the "energy view" of variational inference. If you need to compute the log of a sum of exponentials, replace it with the average of your function plus an entropy term. This gives us an upper bound. We then minimze this upper bound, and in doing so minimize the function we actually care about. -->
## まとめ
これは「エネルギーの視点から見た」変分推論です。指数の和の対数を計算する必要がある場合、関数の平均にエントロピー項を加えたものに置き換えます。これにより、上界が得られます。そして、この上界を最小化することで、実際に関心のある関数を最小化することができます。

