---
lang-ref: ch.14-1
lecturer: Yann LeCun
title: 構造化予測のための深層学習
authors: Junrong Zha, Muge Chen, Rishabh Yadav, Zhuocheng Xu
date: 4 May 2020
translation-date: 14 Aug 2020
translator: Shiro Takagi
lang: ja
---


<!-- ## Structured Prediction -->
## 構造化予測

<!-- It is the problem of predicting variable y for a given input x which is mutually dependent and constrained rather than scalar discrete or real values. The output variable does not belong to a single category but can have exponential or infinite possible values.
For eg: In case of speech/handwriting recognition or natural language translation, the output needs to be grammatically correct and it is not possible to limit the number of output possibilities. The task of the model is to capture the sequential, spatial, or combinatorial structure in the problem domain. -->
構造化予測という問題は、スカラーの離散値や実数値ではなく、相互に依存し、相互に制約をしあってる入力xに対して、変数yを予測するという問題です。出力変数は単一のカテゴリに属するものではなく、指数関数的な値を持つこともあれば、無限に多くの種類の値をとりうることもあります。
例：音声/手書き文字の認識や自然言語翻訳の場合、出力は文法的に正しくなければならず、とりうる出力の数を制限することはできません。モデルが解くタスクは、問題の領域における逐次構造、空間構造、または組み合わせ構造を捉えることです。


<!-- ### Early works on structured prediction -->
### 構造化予測の初期の研究

<!-- This vector is fed to a TDNN which gives a feature vector which in case of model systems can bee compared to softmax that represents a category. One problem that arises in the case of recognizing the word that was pronounced is different people can pronounce the same word in different ways and speed. To solve this Dynamic Time Warping is used. -->
モデルシステムの場合カテゴリを表すsoftmaxと比較することができる特徴ベクトルを与えるTDNNに、ベクトルが入力されます。発音された単語を認識する場合に問題となるのは、同じ単語でも人によって発音の仕方や速さが異なることです。これを解決するために、動的時間伸縮法（Dynamic Time Warping）が使用されます。


<!-- The idea is to provide the system with a set of pre-recorded templates that correspond to sequence or feature vectors that were recorded by someone. The neural network is trained at the same time as the template so that the system learns to recognize the word for different pronunciations. The latent variable allows us to timewarp the feature vector so as to match the length of the templates. -->
これは、誰かによって記録されたシーケンスまたは特徴ベクトルに対応する事前に記録されたテンプレートをシステムに提供するという考え方です。ニューラルネットワークはテンプレートと同時に訓練され、システムは異なる発音の単語を認識するように学習します。潜在変数により、テンプレートの長さに一致するように特徴ベクトルをタイムワープ（時系列の別の時刻に、該当する特徴ベクトルに対応するものを考えることができることを意味していると思われる）させることができます。
<!-- TODO: Might not be the correct translation of timeworp -->

<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig1.png" style="background-color:#DCDCDC;" /><br>
Figure 1.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig1.png" style="background-color:#DCDCDC;" /><br>
図1
</center>

<!-- This can be visualized as a matrix by arrranging the feature vectors from TDNN horizontally and the word templates vertically. Each entry in the matrix corresponds to the distance between the feature vector. This can be visualized as a graph problem where the aim is to start from the bottom left-hand corner and reach the top right corner by traversing the path that minimizes the distance. -->
これはTDNNの特徴ベクトルを水平方向に、単語テンプレートを垂直方向に並べることで、行列として可視化することができます。行列の各エントリーは特徴ベクトル間の距離に対応しています。これは、左下からスタートし、距離を最小にするパスを通って右上に到達することを目的としたグラフ問題として可視化することができます。

<!-- To train this latent variable model we need to make the energy for the correct answers as small as possible and larger for every correct answer. To do this we use an objective function that takes in templates for wrong words and pushes them away from the current sequence of features and backpropagates the gradients. -->
この潜在変数モデルを訓練するために、正解のエネルギーを可能な限り小さくしながら誤ったものに対してはエネルギーをより大きくする必要があります。これを行うために、入力された間違った単語のテンプレートを現在の特徴量の列から押しのける目的関数を用いて、勾配を逆伝播させます。

<!-- ## Energy based factor graphs -->
## エネルギーベース因子グラフ

<!-- The idea behind energy-based factor graphs is to build an energy-based model in which the energy is sum of partial energy terms or when the probability is a product of factors. The benefit of these models is that efficient inference algorithms can be employed. -->
エネルギーベース因子グラフの背後にある考え方は、エネルギーが部分的なエネルギー項の和であったり、確率が因子の積である場合に、エネルギーベースモデルを構築することです。これらのモデルの利点は、効率的な推論アルゴリズムを採用できることです。

<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig2.png" style="background-color:#DCDCDC;" /><br>
Figure 2.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig2.png" style="background-color:#DCDCDC;" /><br>
図2
</center>


<!-- ### Sequence Labeling -->
### シーケンスのラベル付け
<!-- 
The model takes an input speech signal X and output the labels Y such that the output labels minimize the total energy term. -->
このモデルは、入力音声信号Xを受けて、総エネルギー項を最小化するようなラベルYを出力します。
<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig3.png" style="background-color:#DCDCDC;" /><br>
Figure 3.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig3.png" style="background-color:#DCDCDC;" /><br>
図3
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig4.png" style="background-color:#DCDCDC;" /><br>
Figure 4.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig4.png" style="background-color:#DCDCDC;" /><br>
図4
</center>

<!-- In this case, the energy is a sum of three terms represented by blue squares which are neural networks that produce feature vectors for the input variables. In the case of speech recognition X can be thought of as a speech signal and the squares implement the grammatical constraints and Y represent the generated output labels. -->
この場合、エネルギーは、入力変数の特徴ベクトルを生成するニューラルネットワークである青い四角で表される３つの項の和です。音声認識の場合、Xは音声信号と考えることができ、四角は文法的制約を実装し、Yは生成された出力ラベルを表します。

<!-- ## Efficient Inference for Energy-Based Factor Graphs -->
## エネルギーベース因子グラフの効率的な推論

<!-- A Tutorial on Energy-Based Learning (Yann LeCun, Sumit Chopra, Raia Hadsell, Marc’Aurelio Ranzato, and Fu Jie Huang 2006): -->
A Tutorial on Energy-Based Learning (Yann LeCun, Sumit Chopra, Raia Hadsell, Marc’Aurelio Ranzato, and Fu Jie Huang 2006):

<!-- Learning and inference with Energy-Based Models involves a minimization of the energy over the set of answers $\mathcal{Y}$ and latent variables $\mathcal{Z}$. When the cardinality of $\mathcal{Y}\times \mathcal{Z}$ is large, this minimization can become intractable. One approach to the problem is to exploit the structure of the energy function in order to perform the minimization efficiently. One case where the structure can be exploited occurs when the energy can be expressed as a sum of individual functions (called factors) that each depend on different subsets of the variables in Y and Z. These dependencies are best expressed in the form of a factor graph. Factor graphs are a general form of graphical models, or belief networks. -->
エネルギーベースモデルを用いた学習と推論においては、答えの集合 $\mathcal{Y}$ と潜在変数 $\mathcal{Z}$ の上のエネルギーを最小化します。この最小化は、$\mathcal{Y}\times \mathcal{Z}$の濃度が大きい場合には、難解な問題となります。エネルギー関数の構造を利用して効率的に最小化を行うのがこれに対処する一つの方法です。この構造を利用できる1つのケースは、エネルギーがYとZの変数の異なる部分集合にそれぞれ依存する個々の関数（因子と呼ばれる）の和として表現できる場合です。これらの依存関係は因子グラフの形で最もよく表現することができます。因子グラフは、グラフィカルモデルまたは信念ネットワークの一般的な形式です。

<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig5.png" style="background-color:#DCDCDC;" /><br>
Figure 5.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig5.png" style="background-color:#DCDCDC;" /><br>
図5
</center>

<!-- A simple example of a factor graph is shown in Figure 19 (top). The energy function is the sum of four factors: -->
因子グラフの簡単な例を図19（上）に示します。エネルギー関数は4つの因子の和です。

$$E(Y, Z, X) = E_a(X, Z_1) + E_b(X, Z_1, Z_2) + E_c(Z_2, Y_1) + E_d(Y_1, Y_2)$$

<!-- where $Y = [Y_1, Y_2]$ are the output variables and $Z = [Z_1, Z_2]$ are the latent variables. Each factor can be seen as representing soft constraints between the values of its input variables. The inference problem consists in finding: -->
ここで、 $Y = [Y_1, Y_2]$ は出力変数であり、 $Z = [Z_1, Z_2]$ は潜在変数です。各因子は、入力変数の値の間のソフトな制約を表していると見ることができます。推論は、以下を見つけることで行われます。

$$(\bar{Y}, \bar{Z})=\operatorname{argmin}_{y \in \mathcal{Y}, z \in \mathcal{Z}}\left(E_{a}\left(X, z_{1}\right)+E_{b}\left(X, z_{1}, z_{2}\right)+E_{c}\left(z_{2}, y_{1}\right)+E_{d}\left(y_{1}, y_{2}\right)\right)$$

<!-- Let’s assume that $Z_1$, $Z_2$, and $Y_1$ are discrete binary variables, and $Y_2$ is a ternary variable. The cardinality of the domain of $X$ is immaterial since X is always observed. The number of possible configurations of $Z$ and $Y$ given X is $2 \times 2 \times 2 \times 3 = 24$. A naive minimization algorithm through exhaustive search would evaluate the entire energy function 24 times (96 single factor evaluations). -->
ここで、 $Z_1$, $Z_2$, $Y_1$ が離散的な二項変数であり、 $Y_2$ が三値変数であるとします。X は常に観測されるので、 $X$ のドメインの濃度は重要ではありません。Xが与えられたときの $Z$ と $Y$ の可能な構成の数は、 $2 \times 2 \times 2 \times 3 = 24$ です。全状態探索による愚直な最小化アルゴリズムでは、エネルギー関数全体を24回評価することになります(96回の因子の評価)。


<!-- However, we notice that for a given $X$, $E_a$ only has two possible input configurations: $Z_1 = 0$ and $Z_1 = 1$. Similarly, $E_b$ and $E_c$ only have 4 possible input configurations, and $E_d$ has 6. Hence,
there is no need for more than $2 + 4 + 4 + 6 = 16$ single factor evaluations. -->
しかし、与えられた $X$ に対して、 $E_a$ は、 $Z_1 = 0$ と $Z_1 = 1$ の2つの入力の構成しかありえないことに気づきます。同様に、 $E_b$ と $E_c$ は4つの入力の構成しかなく、 $E_d$ は6つの入力の構成しかないことがわかります。したがって、$2 + 4 + 4 + 6 = 16$以上の単一の因子の評価は必要ありません。

<!-- Hence, we can precompute the 16 factor values, and put them on the arcs in a trellis as shown in Figure 19 (bottom). -->
したがって、図19(下)に示すように、16個の因子の値を事前に計算して格子の円弧上に置くことができます。

<!-- The nodes in each column represent the possible values of a single variable. Each edge is weighted by the output energy of the factor for the corresponding values of its input variables. With this representation, a single path from the start node to the end node represents one possible configuration of all the variables. The sum of the weights along a path is equal to the total energy for the corresponding configuration. Therefore, the inference problem can be reduced to searching for the **shortest path** in this graph. This can be performed using a dynamic programming method such as the Viterbi algorithm, or the A* algorithm. The cost is proportional to the number of edges (16), which is exponentially smaller than the number of paths in general. -->
各列のノードは、1つの変数の可能な値を表します。各エッジは、その入力変数の対応する値に対する因子の出力エネルギーによって重み付けされます。この表現では、開始ノードから終了ノードまでの1本のパスが、すべての変数の1つの可能な構成を表します。パスに沿った重みの合計は、対応する構成の総エネルギーに等しくなります。したがって、推論問題は、このグラフ内の**最短パス**を探す問題に落とし込む事ができます。これは、ビタビアルゴリズムやA*アルゴリズムのような動的計画法を用いて行うことができます。コストは辺の数(16)に比例しますが，これは一般にパスの数よりも指数関数的に小さくなります。

<!-- To compute $E(Y, X) = \min_{z\in Z} E(Y, z, X)$, we follow the same procedure, but we restrict the graph to the subset of arcs that are compatible with the prescribed value of $Y$. -->
$E(Y, X) = \min_{z\in Z} E(Y, z, X)$を計算するには、同じ手順に従いますが、グラフを、$Y$の所定の値と互換性のある円弧の部分集合に制限します。


<!-- The above procedure is sometimes called the min-sum algorithm, and it is the log domain version of the traditional max-product for graphical models. The procedure can easily be generalized to factor graphs where the factors take more than two variables as inputs, and to factor graphs that have a tree structure instead of a chain structure. -->
上記の手順は、最小和アルゴリズムと呼ばれることもありますが、これは従来のグラフィカルモデルの最大積アルゴリズムの対数領域版です。この手順は、因子が2つ以上の変数を入力とする因子グラフや、連鎖構造ではなく木構造を持つ因子グラフに簡単に一般化できます。

<!-- However, it only applies to factor graphs that are bipartite trees (with no loops). When loops are present in the graph, the min-sum algorithm may give an approximate solution when iterated, or may not converge at all. In this case, a descent algorithm such as simulated annealing could be used. -->
しかし、これは、（ループのない）二部木の因子グラフにのみ適用されます。グラフにループが存在する場合、最小和アルゴリズムは、繰り返し適用する事で近似解を与えるかもしれないし、全く収束しないかもしれません。この場合、焼きなまし法のような降下アルゴリズムが使用されます。


<!-- ## Simple Energy-Based Factor Graphs with “Shallow” Factors -->
## 「浅い」因子を持つ単純なエネルギベース因子グラフ

<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig6.png" style="background-color:#DCDCDC;" /><br>
Figure 6.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig6.png" style="background-color:#DCDCDC;" /><br>
図6
</center>

<!-- The factor graph shown in Figure 20 is a log domain factor graph for linear structured models ("simple energy-based factor graphs" we are talking about) -->
図20に示す因子グラフは、線形構造化モデル（我々が話している「単純なエネルギーベース因子グラフ」）の対数領域の因子グラフです。

<!-- Each factor is a linear function of the trainable parameters. It depends on the input $$ and on a pair of individual labels $(Y_m, Y_n)$. In general, each factor could depend on more than two individual labels, but we will limit the discussion to pairwise factors to simplify the notation: -->
各因子は、訓練可能なパラメータの線形関数です。それは、入力とラベルのペア $(Y_m, Y_n)$ に依存します。一般的に、各因子は2つ以上のラベルに依存し得ますが、表記を簡単にするために2つで1組の因子に限定します。

$$E(W, Y, X)=\sum_{(m, n) \in \mathcal{F}} W_{m n}^{T} f_{m n}\left(X, Y_{m}, Y_{n}\right)$$

<!-- Here $\mathcal{F}$ denotes the set of factors (the set of pairs of individual labels that have a direct inter-dependency), $W_{m n}$ is the parameter vector for factor $(m, n),$ and $f_{m n}\left(X, Y_{m}, Y_{n}\right)$ is a (fixed) feature vector. The global parameter vector $W$ is the concatenation of all the $W_{m n}.$ -->
ここで、$\mathcal{F}$は因子の集合（直接的な相互の依存性を持つ個々のラベルの組の集合）を表し、$W_{m n}$は因子$(m, n),$のパラメータベクトルであり、$f_{m n} \left(X, Y_{m}, Y_{n}\right)$は（固定された）特徴ベクトルです。グローバルパラメータベクトル $W$ は、すべての $W_{m n}$ を連結したものです。

<!-- And then we can think about like what type of loss function. Here comes several different models. -->
そして、どのようなタイプの損失関数があるかを考えます。ここで、いくつかのモデルが出てきます。

<!-- ### Conditional Random Field -->
### 条件付きランダム場

<!-- We can use the negative log-likelihood loss function to train a linear structured model. -->
線形構造化モデルを訓練するために負の対数尤度損失関数を使うことができます。

<!-- This is the Conditional Random Field -->
これが、条件付きランダム場です。

<!-- The intuition is we want the energy of the correct answer to below and want the log of exponential for all the answers, including the good one, to be large. -->
直感的には、正解のエネルギーを以下のようにして、正解を含むすべての解の指数の対数を大きくしたいということです。

<!-- Below is the formal definition for the negative log-likelihood loss function: -->
以下に負の対数尤度損失関数の正式な定義を示します。

$$\mathcal{L}_{\mathrm{nll}}(W)=\frac{1}{P} \sum_{i=1}^{P} E\left(W, Y^{i}, X^{i}\right)+\frac{1}{\beta} \log \sum_{y \in \mathcal{Y}} e^{-\beta E\left(W, y, X^{i}\right)}$$


<!-- ### Max Margin Markov Nets and Latent SVM -->
### 最大マージンマルコフネットと潜在SVM

<!-- We can also using the Hinge loss function for optimization. -->
また、最適化のためにヒンジ損失関数を使用することもできます。

<!-- The intuition behind is that we want the energy of the correct answer to be low, and then among all possible configurations of incorrect answers, we are going to look for the one that has the lowest energy among all the wrong or the bad ones. And then we are going to push up the energy of this one. We don't need to push up the energy for the other bad answers because they are larger anyway. -->
その背後にある直感は、正解のエネルギーを低くして、そして全ての間違った答えやよくない答えの構成の中で、最もエネルギーが低いものを探すというものです。そして、答えのエネルギーを押し上げていきます。他の悪い解答のエネルギーを押し上げる必要はありません。

<!-- This is the idea behind Max Margin Markov Nets and Latent SVM. -->
これが最大マージンマルコフネットと潜在SVMです。


<!-- ### Structured Perceptron model -->
### 構造化パーセプトロンモデル

<!-- We can train the linear structured model byy using perceptron loss. -->
線形構造化モデルはパーセプトロン損失を用いて学習することができます。

<!-- Collins [Collins, 2000, Collins, 2002] has advocated its use for linear structured models in the context of NLP: -->
Collins [Collins, 2000, Collins, 2002]は、NLPの文脈で線形構造化モデルに使用することを提唱しています。

$$
\mathcal{L}_{\text {perceptron }}(W)=\frac{1}{P} \sum_{i=1}^{P} E\left(W, Y^{i}, X^{i}\right)-E\left(W, Y^{* i}, X^{i}\right)
$$

ただし $Y^{* i}=\operatorname{argmin}_{y \in \mathcal{Y}}$で、$E\left(W, y, X^{i}\right)$ はシステムの出力した答えです。


<!-- #### Early trails on discrimitive training for speech/handwritten recognition. -->
#### 音声・手書き文字識別のための訓練の初期段階の軌跡

<!-- Minimum Empirical Error Loss (Ljolje, and Rabiner 1990): -->
最小経験誤差関数 (Ljolje, and Rabiner 1990):

<!-- By training at sequence level, they do not tell the system this sound or that location. They give the system input sentence and transcription of it in term of words, and ask the system to figure it out by doing time warping. They did not use nerual networks, and have other ways in turing speech signals into sound categories. -->
シーケンスレベルで学習することで、この音やあの場所をシステムに教えるのではなく、入力文と単語の書き起こしを与え、タイムワープをしてシステムに理解するように求めます。彼らは二ューラルネットを使用しておらず、別の方法で音声信号を音声のカテゴリに変換しています。

<!-- ## Graph Transformer Net -->
## Graph Transformer Net

<!-- Here the problem is that we have a sequence of digits at the input and we do not know how to do segmentation. What we can do is build a graph in which each path is a way of breaking up the sequence of characters, and we are going to find out the path with lowest energy, basically is to find the shortest path. Here is a concrete example of how it works. -->
ここでの問題は、入力に数字の列があるがセグメンテーションの方法がわからないということです。そこでできることは、各パスが文字列を分割する方法となるようなグラフを構築することです。これがどのように機能するのか、具体的な例を示します。

<!-- We have input image 34. Run this through segmenter, and get multiple alternative segmentations. These segmentation are ways to group these blobs of thing together. Each path in the segmentation graph corresponds to one particular way of grouping the blobs of ink. -->
入力画像34があるとします。これをセグメンテーションツールでセグメント分けすると、複数の代替的なセグメンテーションが得られます。これらのセグメンテーションは、これらをグループ化する方法です。セグメンテーショングラフの各パスは、インクの塊をグループ化する特定の方法に対応しています。
<!-- TODO: Could not translate well -->

<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig7.png" style="background-color:#DCDCDC;" /><br>
Figure 7.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig7.png" style="background-color:#DCDCDC;" /><br>
図7
</center>

<!-- We run each through the same charecter recognition ConvNet, and get a list of 10 scores (Two here but essentially should be 10, representing 10 categories). For example, 1 [0.1] means the energy is 0.1 for category 1. So I get a graph here, and you can think of it as a weird from of tensor. It is a sparse tensor really. It is a tensor that says for each possible configuration of this variable, tell me the cost of the variable. It's more like a distribution over tensors, or log distribution because we are talking about energies. -->
それぞれを同じ文字識別畳み込みニューラルネットで実行し、10 点のスコアのリストを得ます（ここでは 2 点ですが、本質的には 10 のカテゴリを表す 10 点でなければなりません）。例えば、1 [0.1]はカテゴリ1のエネルギーが0.1であることを意味します。このようにしてグラフが得られますが、これは少し変わったテンソルだと考えることができます。これは実際には疎なテンソルです。これはこの変数の可能な各構成について、その変数のコストが何かを教えるように要求するテンソルです。エネルギーの話をしているので、テンソルの分布というよりも、対数分布のようなものです。

<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig8.png" style="background-color:#DCDCDC;" /><br>
Figure 8.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig8.png" style="background-color:#DCDCDC;" /><br>
図8
</center>

<!-- Take this graph and then I want to compute the energy of the correct answer. I am telling you the correct answer is 34. Select within those paths and find out ones that say 34.  There are two of them, one the energy 3.4 + 2.4 = 5.8, and the other 0.1 + 0.6 = 0.7. Pick the path with the lowest energy. Here we get the path with energy 0.7. -->
このグラフを見て 正解のエネルギーを計算してみましょう 正解は34です。それらのパスの中から選んで、34と書いてあるものを見つけてください。 それら2つのうち1つはエネルギーが3.4 + 2.4 = 5.8で、もう一つは、0.1 + 0.6 = 0.7です。エネルギーが最も低いものを選びます。ここでは、エネルギーが0.7のパスが出てきます。
<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig9.png" style="background-color:#DCDCDC;" /><br>
Figure 9.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig9.png" style="background-color:#DCDCDC;" /><br>
図9
</center>

<!-- So finding the path is like minimizing over the latent variable where latent variable is which path you pick. Conceptually, it is an energy model with latent variable as a path. -->
したがって、パスを見つけることは、どのパスを選ぶかを表す潜在変数について最小化するようなものです。概念的には、潜在変数をパスとするエネルギーモデルです。


<!-- Now we have the energy of the correct path, 0.7. What we need to do now is backpropagate gradient through this entire structure, so that we can change the weight in ConvNet in such a way that final energy goes down. It looks daunting, but is entirely possible. Because this entire system is built out of element we already know about, nerual net is regular and the Path Selector and Viterbi Transformer are basically swtiches that pick a particular edge or not. -->
これで、正しいパスのエネルギーは0.7になりました。ここで必要なのは、最終的なエネルギーが下がるように畳み込みニューラルネットの重みを変えることができるようにこの構造全体を通して勾配を逆伝播することです。難しそうに見えますが、完全に可能です。このシステム全体は既に知っている要素で構築されているので、二ューラルネットは通常通りで、パス選択器とビタビ変換器は基本的に特定のエッジを選ぶかどうかのスイッチです。
<!-- TODO: Might have failed to translate "regular" -->

<!-- So how do we backpropagate. Well, the point 0.7 is the sum of 0.1 and 0.6. So both point 0.1 and 0.6 will have gradient +1, which are indicated in the brackets. Then Viterbi Transformer just select one path among two. So just copy the gradient for the corresponding edge in the input graph and set  the gradeint for other paths that are not selected as zero. It's exactly what's happening in Max-Pooling or Mean-Pooling. The Path Selector is the same, it is just a system that selects the correct answer. Note that 3 [0.1] (0) in the graph should be 3 [0.1] (1) at this stage, and wil come back to this later. Then you can backpropagate gradient through the nerual net. That will make the energy of the correct answer small. -->
では、どうやって逆伝播するのでしょうか。点0.7は0.1と0.6の和です。つまり、点0.1と0.6の両方が勾配+1を持っています。これはブラケットで表現します。すると、ビタビ変換器は2つのパスのうち1つのパスを選択します。なので、入力グラフの対応する辺の勾配をコピーして、選択されていない他のパスの勾配を0に設定するだけです。これはMax-PoolingやMean-Poolingで行っていることと全く同じです。パスを選択するものも同じで、正解を選択するシステムになっているだけです。グラフの3 [0.1] (0)はこの段階では3 [0.1] (1)であるべきで、あとで後者に戻ってくることに注意してください。これで正解のエネルギーが小さくなります。

<!-- What's important here is that this structure is dynamic in the scence that if I give you a new input, the number of instances of nerual net will change with the number of segmentations, and graphs derived will also change. We need to backpropagate through this dynamical structure. This is the suitation where things like PyTorch are really important. -->
ここで重要なのは、新しい入力を入れると二ューラルネットのインスタンスの数がセグメンテーションの数と一緒に変化して、導出されたグラフも同様に変化するという意味で、この構造が動的であるということです。この動的な構造で誤差逆伝播をする必要があります。これがPyTorchのようなものが非常に重要になるところです。

<!-- This phrase of backpropagation make the energy of correct answer small. And there's going to be a second phrase where we are going to make the energy of incorrect answer large. In this case, we just let the system pick whatever answer it wants. This is going to be a simplified form of discrimitive training for structure prediction that use perceptual loss. -->
この誤差逆伝播の段階は、正解のエネルギーを小さくしてくれます。そして、不正解のエネルギーを大きくするという段階もあります。この場合、システムに好きな答えを選ばせます。これは、知覚損失を利用した構造予測のための識別訓練の簡略化された形になりそうです。
<!-- TODO: Phrase? Not phase? -->

<!-- The first stages of phrase two are exactly the same with the first phrase. The Viterbi Transformer here just pick the best path with the lowest energy, we do not care whether is path is a correct path or not here. The energy you get here is going to be smaller or equal to the one you get from phrase one, since the energy get here is the smallest among all possible paths. -->
二つ目の段階のはじめは、最初の段階と全く同じです。ここでのビタビ変換器は、エネルギーが最も低い最良のパスを選ぶだけで、そのパスが正しいパスかどうかは気にしません。ここで得られるエネルギーは、可能なすべてのパスの中で最も小さいので、第一段階から得られるエネルギーと同じか、それより小さくなるでしょう。

<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig10.png" style="background-color:#DCDCDC;" /><br>
Figure 10.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig10.png" style="background-color:#DCDCDC;" /><br>
図10
</center>

<!-- Putting phrase one and two together. The loss function should be energy1 - energy2. Before, we introduced how to backpropagate through the left part, and now we actually need to backpropagate through the entire structure. Whatever path on the left side will get +1, and whatever path in right hand side will get -1. So 3 [0.1] appeared in both path, thus should get gradient 0. If we do this, the system will eventually minimize the difference between the energy of the correct answer and the energy of the best answer whatever it is. The Loss function here is the perception loss. -->
段階1と2を一緒にします。損失関数は energy1 - energy2 とします。 前回は左の部分を逆伝播する方法を紹介しましたが、今回は構造全体を逆伝播する必要があります。左側のパスは+1、右側のパスは-1となり、両方のパスに3 [0.1]が出現するので、勾配は0となります。 このようにすれば、システムは最終的に、正解のエネルギーと最良解のエネルギーの差を最小化することになります。ここでの損失関数は知覚損失です。

<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig11.png" style="background-color:#DCDCDC;" /><br>
Figure 11.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig11.png" style="background-color:#DCDCDC;" /><br>
図11
</center>


<!-- ## Comprehension Questions and Answers -->
## 質問と回答


<!-- #### Question1: Why is inference easy in the case of energy-based factor graphs? -->
#### 質問1: なぜエネルギーベース因子グラフにおいて推論が簡単になるのですか？

<!-- Inference in the case of the energy-based model with latent variable involves the usage of exhaustive techniques such as gradient descent to minimize the energy however since the energy, in this case, is the sum of factors and techniques such as dynamic programming can be used instead. -->
潜在変数を持つエネルギーベースのモデルの場合の推論では、エネルギーを最小化するために勾配降下法のような全探索的な手法を使用しますが、この場合のエネルギーは因子の総和であるため、動的計画法のような手法を代わりに使用することができます。


<!-- #### Question2: What if the latent variables in factor graphs are continuous variables? Can we still using min-sum algorithm? -->
#### 質問2: 因子グラフの潜在変数が連続変数だったらどうなるのですか？まだ和を最小化するアルゴリズムを使えるのですか？

<!-- We can't since we can't search for all possible combination for all factor values now. However, in this case, energies also gives us an advantage, because we can do independent optimizations. Like the combination of $Z_1$ and $Z_2$ only affects $E_b$ in Figure 19. We can do independent optimization and dynamic programming to do the inference. -->
できません。すべての因子値に対して可能なすべての組み合わせを検索することができないからです。しかし、この場合でも、独立した最適化を行うことができるという利点があります。図19の$Z_1$と$Z_2$の組み合わせは、$E_b$にしか影響しないようなものです。独立した最適化と動的計画法で推論を行うことができます。

<!-- #### Question3: Are the NN boxes refering to seperate ConvNets? -->
#### 質問3: 図中のNNの箱は別々の畳み込みニューラルネットを表しているのですか?

<!-- They are shared. They are multiple copies of the same ConvNet. It's just a character recognition network. -->
共有されています。同じ畳み込みニューラルネットの複数のコピーです。ただの文字識別ネットワークです。
