---
lang-ref: ch.13-2
title: Graph Convolutional Networks (GCNs) - An Insight
lecturer: Xavier Bresson
authors: Neil Menghani, Tejaishwarya Gagadam, Joshua Meisel and Jatin Khilnani
date: 27 Apr 2020
lang: ja
translation-date: 6 Dec 2020
translator: Shiro Takagi
---

<!-- ## Spectral Graph ConvNets (GCNs) -->
## スペクトルグラフ畳み込みニューラルネット (GCNs)

<!-- In the previous section we discussed Graph Spectral Theory, one of the two ways to define convolution for graphs, which we can now use to define Spectral GCNs. -->
前のセクションでは、グラフの畳み込みを定義する2つの方法のうちの1つであるグラフスペクトル理論について説明しました。

<!-- ### Vanilla Spectral GCN -->
### 通常のスペクトルGCN

<!-- We define a graph spectral convolutional layer such that given layer $h^l$, the activation of the next layer is: -->
グラフスペクトル畳み込み層を定義し、 $h^l$ が与えられた層の活性が次のようになるようにします：

$$
h^{l+1}=\eta(w^l*h^l),
$$

<!-- where $\eta$ represents a nonlinear activation and $w^l$ is a spatial filter. The RHS of the equation is equivalent to $\eta(\hat{w}^l(\Delta)h^l)$ where $\hat{w}^l$ represents a spectral filter and $\Delta$ is the Laplacian. We can further decompose the RHS of the equation into $\eta(\boldsymbol{\phi} \hat{w}^l(\Lambda)\boldsymbol{\phi^\top} h^l)$, where $\boldsymbol{\phi}$ is the Fourier matrix and $\Lambda$ is the eigenvalues. This yields the final activation equation as below. -->
ここで、$\eta$は非線形活性化関数、$w^l$は空間フィルタです。方程式の右辺は、$\eta(\hat{w}^l(\Delta)h^l)$と等しく、$\hat{w}^l$はスペクトルフィルタ、$\Delta$ はラプラシアンです。方程式の右辺をさらに分解すると、$\eta(\boldsymbol{\phi} \hat{w}^l(\Lambda)\boldsymbol{\phi^\top} h^l)$となります。ここで、$\boldsymbol{\phi}$ はフーリエ行列、$\Lambda$ は固有値です。これで、最終的な活性方程式は以下のようになります。

$$
h^{l+1}=\eta\Big(\boldsymbol{\phi} \hat{w}^l(\Lambda)\boldsymbol{\phi^\top} h^l\Big)
$$

<!-- The objective is to learn the spectral filter $\hat{w}^l(\lambda)$ using backpropagation instead of hand crafting.

This technique was the first spectral technique used for ConvNets, but it has a few limitations:
* No guarantee of spatial localization of filters
* Need to learn $O(n)$ parameters per layer ($\hat{w}(\lambda_1)$ to $\hat{w}(\lambda_n)$)
* Learning rate is $O(n^2$) because $\boldsymbol{\phi}$ is a dense matrix -->

目的は、フィルタを作り込む代わりに誤差逆伝播を使ってスペクトルフィルタ$\hat{w}^l(\lambda)$を学習することです。

この手法は畳み込みニューラルネットで使われた最初のスペクトル手法ですが、いくつかの限界があります。
* フィルタの空間的な位置を保証するものではありません。
* 各層$O(n)$個のパラメータを学習する必要があります(($\hat{w}(\lambda_1)$ to $\hat{w}(\lambda_n)$)。
* $\boldsymbol{\phi}$ は密な行列なので、 学習率は$O(n^2)$です。


<!-- ### SplineGCNs -->
### スプラインGCN

<!-- SplineGCNs involve computing smooth spectral filters to get localized spatial filters. The connection between smoothness in frequency domain and localization in space is based on Parseval's Identity (also Heisenberg uncertainty principle): smaller derivative of spectral filter (smoother function) $\Leftrightarrow$ smaller variance of spatial filter (localization).

How do we get a smooth spectral filter? We decompose the spectral filter to be a linear combination of $K$ smooth kernels $\boldsymbol{B}$ (splines) so that $\hat{w}^l(\Lambda)=diag(\boldsymbol{B}w^l)$. The activation equation the is as the following. -->

スプラインGCNは、局所的な空間フィルタを得るために、滑らかなスペクトルフィルタを計算します。周波数領域の滑らかさと空間位置の関係は、パーセバルの等式（ハイゼンベルグの不確かさの原理）に基づいています：スペクトルフィルタの微分が小さいほど（より滑らかな関数ほど）、空間フィルタの分散が小さくなります（位置の揺らぎが小さくなる）。

滑らかなスペクトルフィルタを得るにはどうしたらいいでしょうか？スペクトルフィルタを、$K$個の滑らかなカーネル$\boldsymbol{B}$ (スプライン)の線形結合に分解して、$\hat{w}^l(\Lambda)=diag(\boldsymbol{B}w^l)$となるようにします。活性方程式は次のようになります。

$$
h^{l+1}=\eta\bigg(\boldsymbol{\phi} \Big(\text{diag}(\boldsymbol{B}w^l)\Big)\boldsymbol{\phi^\top} h^l\bigg)
$$

<!-- Now, we only have $O(1)$ parameters (constant $K$) per layer to be learned through backpropagation. However, the learning complexity is still $O(n^2)$. -->
バックプロパゲーションで学習するパラメータは、層ごとに $O(1)$（定数 $K$）しかありません。しかし、計算量はやはり $O(n^2)$ です

### LapGCNs

<!-- How do we learn in linear time $O(n)$ (w.r.t. graph size $n$)? The $O(n^2)$  complexity is a direct result of using Laplacian eigenvectors. We need to avoid eigen-decomposition, which can be achieved by directly learning a function of the Laplacian. The spectral function will be a monomial of the Laplacian as shown here. -->
線形時間 $O(n)$ (グラフサイズ $n$) で学習するにはどうすればよいのでしょうか？$O(n^2)$の計算は、ラプラシアンの固有ベクトルを使うことによる直接的な結果です。固有分解を避ける必要がありますが、これはラプラシアンの関数を直接学習することで実現できます。スペクトル関数は、ここに示すように、ラプラシアンの単項式になります。

$$
w*h=\hat{w}(\Delta)h=\bigg(\sum^{K-1}_{k=0}w_k\Delta^k\bigg)h
$$

<!-- One nice feature is that filters are localized in exactly k-hop supports. -->
1つの良い特徴は、フィルターがまさにkごとのサポートに局在していることです。

<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure1.png" style="background-color:#DCDCDC;" /><br>
<b>Figure 1:</b> Demonstrates 1-hop and 2-hop neighbourhoods
</center> -->
<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure1.png" style="background-color:#DCDCDC;" /><br>
<b>図1:</b> 1-hop と 2-hop の近傍の表示
</center>

<!-- We replace the expression $\Delta^kh$ with $X_k$, a recursive equation defined as, -->
式 $\Delta^kh$ を $X_k$ に置き換えます。再帰的式は次のように定義されます

$$
X_k=\Delta X_{k-1} \text{ and } X_0=h
$$

<!-- Complexity is now $O(E.K)=O(n)$ for sparse (real-world) graphs. We can reshape $X_k$ into $\bar{X}$ to form a linear operation. We now have the following activation equation. -->
計算量は、スパースな(実世界の)グラフの場合、 $O(E.K)=O(n)$になりました。$X_k$ を $\bar{X}$ に再整形して、線形演算にすることができます。これで、次のような活性方程式ができました。

$$
h^{l+1}=\eta\bigg(\sum^{K-1}_{k=0}w_kX_k\bigg)=\eta\Big((w^l)^\top \bar{X}\Big)
$$

<!-- Note: Since no Laplacian eigen-decomposition is used, all operations are in the  spatial (not spectral) domain, so calling them Spectral GCNs may be misguided. Further, another drawback of LapGCNs is that convolutional layers involve sparse linear operations, which GPU's are not fully optimized for.

We now have resolved the 3 limitations of Vanilla GCNs through localized filters (in $K$-hop support), $O(1)$ parameters per layer and $O(n)$ learning complexity. However, the limitation of LapGCNs is that monomial basis ($\Delta^0,\Delta^1,\ldots$) used is unstable for optimization because it is not orthogonal (changing one coefficient changes the function approximation). -->

注：ラプラシアン固有分解が使用されていないため、すべての演算は空間領域（スペクトル領域ではない）にあるので、Spectral GCNと呼ぶのは間違っているかもしれません。さらに、LapGCNのもう一つの欠点は、畳み込み層にはスパースな線形演算が含まれており、GPUが完全に最適化されていないことです。

我々は、局所化されたフィルタ（$K$ホップサポート）、層ごとの$O(1)$個のパラメータ、$O(n)$だけの計算量の学習によって、通常のGCNの3つの限界を解決しました。しかし、LapGCNの限界は、単項基底($\Delta^0,\Delta^1,\ldots$)を使うことで、直交しなくなる(1つの係数を変えると関数の近似が変わる)ため、最適化が不安定になることです。


### ChebNets

<!-- To resolve the issue of unstable basis we can use any orthonormal basis, but it must have a recursive equation to ensure linear complexity. For ChebNets we use Chebyshev polynomials, and as in a LapGCN we represent the expression $T_k(\Delta)h$ (Chebyshev function applied to $h$) by $X_k$, a recursive equation defined as, -->
不安定な基底の問題を解決するために、我々は、任意の正規直交基底を使用することができますが、それは計算量が線形であることを保証するために再帰的な方程式を持っている必要があります。ChebNetsでは、チェビシェフ多項式を使用し、LapGCNのように$T_k(\Delta)h$ ($h$に適用されるチェビシェフ関数)を$X_k$で表現し、再帰方程式を定義します。


$$
X_k=2\tilde{\Delta} X_{k-1} - X_{k-2}, X_0=h, X_1=\tilde{\Delta}h  \text{ and } \tilde{\Delta} = 2\lambda_n^{-1}\Delta - \boldsymbol{I}
$$

<!-- Now we have stability under coefficient perturbation.

ChebNets are GCNs that can be used for any arbitrary graph domain, but the limitation is that they are isotropic. Standard ConvNets produce *anisotropic* filters because Euclidean grids have direction, while Spectral GCNs compute *isotropic* filters since graphs have no notion of direction (up, down, left, right).

We can extend ChebNets to multiple graphs using a 2D spectral filter. This may be useful, for example, in recommender systems where we have movie graphs and user graphs. Multi-graph ChebNets have the activation equation as below. -->

これで、係数に摂動が与えられた下での安定性が得られました。

ChebNetsは、任意のグラフ領域に使用できるGCNですが、等方的であるという制限があります。ユークリッドグリッドには方向があるので、標準的な畳み込みニューラルネットは、*異方性*のフィルタを生成しますが、スペクトルGCNは、グラフには方向（上下、左、右）の概念がないので、*等方性*のフィルタを計算します。

ChebNetsを2次元スペクトルフィルタを使って複数のグラフに拡張することができます。これは、例えば、映画のグラフやユーザーのグラフがある推薦システムなどで有用です。複数グラフのChebNetsは、以下のような活性式を持ちます。


$$
h^{l+1}=\eta(\hat{w}(\Delta_1,\Delta_2)*h^l)
$$


### CayleyNets

<!-- ChebNets are unstable to produce filters (localize) with frequency bands of interest (graph communities). In CayleyNets, we instead use as our orthonormal basis Cayley rationals. -->
ChebNetsは、関心のある周波数帯（グラフコミュニティ）を持つフィルタを生成する（局所化する）ためには不安定です。CayleyNetsでは、代わりに、正規直交基底を用いたケイリー変換を用いています。
<!-- TODO: Dont know what Cayley rationals is. I guess its a type of Cayley transform. -->

$$
\hat{w}(\Delta)=w_0+2\Re\left\{\sum^{K-1}_{k=0}w_k\frac{(z\Delta-i)^k}{(z\Delta+i)^k}\right\}
$$

<!-- CayleyNets have the same properties as ChebNets (are isotropic), but they are localized in frequency (with spectral zoom) and provide a richer class of filters (for the same order $K$). -->
CayleyNetsは、ChebNetsと同じ性質を持っています（等方性です）が、周波数が局在しており（スペクトルズームがあります）、より豊富なクラスのフィルタを提供します（同じ次数$K$に対して）。


<!-- ## Spatial Graph ConvNets -->
## 空間的グラフ畳み込みニューラルネットワーク

<!-- ### Template Matching -->
### テンプレートマッチング

<!-- To understand Spatial Graph ConvNets, we go back to the Template Matching definition of ConvNets.

The main issue when we perform Template Matching for graphs is the lack of node ordering or positioning for the template. All we have are the indices of nodes, which isn't enough to match information between them. How do we design template matching to be invariant to node re-parametrisation? That is, if we have a graph and one of the nodes had an arbitrary index, say 6, this index could've been 122 as well. So it's essential to be able to perform template matching independent to the index of the node.

The simplest way to do this is by having only one template vector $w^l$, instead of having $w_{j1}$,$w_{j2}$, $w_{j3}$ or so on. So we match this vector $w^l$ with all other features on our graph. Most Graph Neural Networks today use this property. -->

空間的グラフ畳み込みニューラルネットを理解するために、畳み込みニューラルネットのテンプレートマッチングの定義に戻ります。

グラフのテンプレートマッチングを行う際に問題となるのは、テンプレートにノードの順序や位置がないことです。ノードのインデックスしかなく、ノード間の情報をマッチングさせるには十分ではありません。どのようにしてテンプレートマッチングを設計すれば、ノードのリパラメトライゼーションに対して不変になるのでしょうか？つまり、あるグラフがあってそのノードの1つが任意のインデックス（例えば6）を持っていた場合、このインデックスは122となっていた可能性もあります。ですから、ノードのインデックスに依存しないテンプレートマッチングを実行できることが不可欠です。

これを行う最も簡単な方法は、 $w_{j1}$,$w_{j2}$, $w_{j3}$ などのテンプレートベクトルを持つのではなく、 $w^l$ だけを持つことです。そして、このベクトル $w^l$ を、グラフ上の他のすべての特徴と一致させます。今日のほとんどのグラフニューラルネットワークは、この性質を利用しています。

<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure2.png" /><br>
<b>Figure 2:</b> Template Matching using a template vector
</center> -->
<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure2.png" /><br>
<b>図2:</b> テンプレートベクトルを用いたテンプレートマッチング
</center>

<!-- Mathematically, for one feature we have, -->
数学的には、一つの特徴に対して、以下を得ることになります。

$$h_{i}^{l+1}=\eta\bigg(\sum_{j \in N_{i}} \langle w^l,h_{ij}^l \rangle \bigg)$$

<!-- where, $w^l$ is the template vector at layer $l$ of dimensions $d \times 1$ and $h_{ij}^l$ is the vector at node j with $d \times 1$ which will result in a scalr quantity $h_{i}^{l+1}$ at node $i$. -->
ただし$w^l$は$l$層目の$d \times 1$次元のテンプレートベクトルで、$h_{ij}^l$はノード$j$の$d \times 1$次元ベクトルで、これは$i$番目のノードについてスカラー値$h_{i}^{l+1}$を返します。

<!-- for more($d$) features, -->
より多くの($d$の)特徴量については、以下のようになります。

$$h_{i}^{l+1}=\eta\bigg(\sum_{j \in N_{i}} \boldsymbol{W}^l,h_{ij}^l\bigg)$$
<!-- 
where, $\boldsymbol{W}^l$ is of the dimensionality $d \times d$ and $h_{i}^{l+1}$ is $d \times 1$

for a vectoral representation,

$$h^{l+1}=\eta(\boldsymbol{A} h^l \boldsymbol{W}^l)$$

where, $\boldsymbol{A}$ is the adjacency matrix of dimensions $n \times n$, $h^l$ is the activation function at the layer $l$ with dimensions $n \times d$.

Based on this definition of Template Matching we can define two types of Spatial GSNs -- Isotropic GCNs and Anisotropic GCNs. -->

ここで、$\boldsymbol{W}^l$ は、次元数 $d \times d$ であり、$h_{i}^{l+1}$ は、あるベクトル表現

$$h^{l+1}=\eta(\boldsymbol{A} h^l \boldsymbol{W}^l)$$

に対して、次元数$d \times 1$ です。ここで、$\boldsymbol{A}$は次元数$n \times n$の隣接行列であり、$h^l$は次元数$n \times d$の$l$層目の活性化関数です。

このテンプレートマッチングの定義に基づいて、等方的グラフ畳み込みニューラルネットと異方的グラフ畳み込みニューラルネットの２種類の空間的グラフ畳み込みニューラルネットが定義できます。



<!-- ## Isotropic GCNs -->
## 等方的グラフ畳み込みニューラルネット


<!-- ### Vanilla Spatial GCNs -->
### 通常の空間的グラフ畳み込みニューラルネット

<!-- It has the same definition as before, but we add the Diagonal matrix in the equation, in such a way that we find the mean value of the neighbourhood.

Matrix representation being, -->

これは前と同じ定義ですが、式の中に対角行列を加えて、近傍の平均値を求めるようにしています。

すると、行列表現は次のようになります

$$h^{l+1} = \eta(\boldsymbol{D}^{-1}\boldsymbol{A}h^{l}\boldsymbol{W}^{l})$$

<!-- where, \boldsymbol{A} has the dimensions $n \times n$, $h^{l}$ has dimensions $n \times d$ and $W^{l}$ has $d \times d$, which results in a $n \times d$ $h^{l+1}$ matrix.

And the vectorial representation being, -->

ここで、$\boldsymbol{A}$の次元は、$n \times n$、$h^{l}$の次元は、$n \times d$ 、$W^{l}$の次元は、$d \times d$となり、$n \times d$次元の行列$h^{l+1}$となります。

そして、ベクトル表現は次のようになります

$$h_{i}^{l+1} = \eta\bigg(\frac{1}{d_{i}}\sum_{j \in N_{i}}\boldsymbol{A}_{ij}\boldsymbol{W}^{l}h_{j}^{l}\bigg)$$

<!-- where, $h_{i}^{l+1}$ has the dimensions of $d \times 1$ -->

ここで、$h_{i}^{l+1}$は、$d \times 1$次元です。

<!-- The vectorial representation is responsible for handling the absence of node ordering, which is invariant of node re-parametrisation. That is, adding on the previous example, if the node has an in 6 and is changed to 122, this won't change anything in the computation of the activation function of the next layer $h^{l+1}$. -->

ベクトル表現は、ノードのリパラメトライゼーションの際に不変である、ノードの順序がない場合の処理を担当しています。つまり、前の例に加えて、もしノードが6であり、これが122 に変更された場合、次の層の$h^{l+1}$ での活性化関数の計算では何も変わりません。

<!-- We can also deal with neighbourhood of different sizes. That is we can have a neighbourhood of 4 nodes or 10 nodes, it wouldn't change anything. -->
異なる大きさの近傍を扱うこともできます。つまり、4ノードでも10ノードでも何も変わらないということです。

<!-- We are given the local reception field by design, that is, with Graph Neural Networks we only have to consider the neighbours. -->
その構成からして局所的受容野が与えられているということになります。つまり、グラフニューラルネットワークでは、近傍を考慮するだけでよいのです。

<!-- We have weight sharing, that is, we the same $\boldsymbol{W}^{l}$ matrix for all features no matter the position of the graph, which is a Convolution property. -->
重みを共有しているので、グラフの位置に関係なく、すべての特徴表現に対して同じ行列$\boldsymbol{W}^{l}$が得られます。これは畳み込み演算の性質です。

<!-- This formulation is also independent of the graph size, since all operations are done locally. -->
すべての演算が局所的に行われるので、この定式化はグラフの大きさにも依存しません。

<!-- Since it is an isotropic model, the neighbours will have the same $\boldsymbol{W}^{l}$ matrix. -->
これは等方的なモデルなので、隣り合う行列は同じ 行列$\boldsymbol{W}^{l}$を持つことになります。

<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure4.png" /><br>
<b>Figure 3:</b> Isotropic model
</center> -->
<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure4.png" /><br>
<b>図3:</b> 等方的なモデル
</center>

$$h_{i}^{l+1} = f_\text{GCN}(h_{i}^{l}, \{h_{j}^l: j \rightarrow i\})$$

<!-- So, the activation of the next layer $h_{i}^{l+1}$ is a function of the activation of the previous layer $h_{i}^{l}$ at node $i$ and the neighbourhood of $i$. When we change the function, we get an entire family of graphs. -->
つまり、ノード $i$ と その近傍においては、次の層の活性 $h_{i}^{l+1}$ は、前の層の活性 $h_{i}^{l}$ を引数にとる関数となります。この関数を変えると、グラフの族全体ができあがります。


<!-- ### ChebNets and Vanilla Spatial GCNs -->
### ChebNetsと通常の空間的グラフ畳み込みニューラルネット

<!-- The above defined Vanilla Spatial GCN is a simplification of ChebNets. We can truncate the expansion of ChebNet by using the first two Chebyshev functions to end up with, -->
上で定義した通常の空間的グラフ畳み込みニューラルネットは、ChebNetsの単純化です。最初の2つのチェビシェフ関数を使ってChebNetの展開された部分を切り捨てることで、次のようになります

$$h_{i}^{l+1} = \eta\bigg(\frac{1}{\hat{d_{i}}}\sum_{j \in N_{i}}\hat{\boldsymbol{A}_{ij}}\boldsymbol{W}^{l}h_{j}^{l}\bigg)$$


### GraphSage

<!-- If the Adjacency matrix $\boldsymbol{A}_{ij} = 1$ for the edges in Vanilla Spatial GCNs, we get, -->
通常の空間的グラフ畳み込みニューラルネットのエッジに対して隣接行列を$\boldsymbol{A}_{ij} = 1$とすると、次のようになります

$$h_{i}^{l+1} = \eta\bigg(\frac{1}{d_{i}}\sum_{j \in N_{i}}\boldsymbol{W}^{l}h_{j}^{l}\bigg)$$

<!-- For this equation, we give the central/core vertex $i$ and it's neighbourhood the same template weight $\boldsymbol{W}^{l}$. We can differentiate this by giving the central node $\boldsymbol{W}\_{1}^{l}$, and having a different template node $\boldsymbol{W}_{2}^{l}$ for the one-hot neighbourhood. This will improve the performance of the GNNs by a substantial amount. This model is still considered to be Isotropic in nature, since the neighbours have the same weight. -->
この方程式では、中心の頂点 $i$ とその近傍に同じテンプレートウェイト $\boldsymbol{W}^{l}$ を与えます。中心点を$\boldsymbol{W}_{1}^{l}$とし、one-hot近傍には別のテンプレートノード$\boldsymbol{W}_{2}^{l}$を与えることで、これを区別することができます。これにより、GNNの性能はかなり改善されます。このモデルは、近傍が同じ重みを持っているため、本質的にはまだ等方的であると考えられます。

$$h_{i}^{l+1} = \eta\bigg(\boldsymbol{W}_{1}^{l} h_{i}^{l} + \frac{1}{d_{i}} \sum_{j \in N_{i}} \boldsymbol{W}_{2}^{l} h_{j}^{l}\bigg)$$

<!-- where, $\boldsymbol{W}\_{1}^{l}$ and $\boldsymbol{W}\_{2}^{l}$ are of dimension $d \times d$; $h_{i}^{l}$ and $h_{j}^{l}$ are of the dimension $d \times 1$. -->
ここで、$\boldsymbol{W}_{1}^{l}$と$\boldsymbol{W}_{2}^{l}$ は$d \times d$次元です。そして、$h_{i}^{l}$と$h_{j}^{l}$は$d \times 1$次元です。

<!-- In this equation, we can find the summation or maximum of $\boldsymbol{W}\_{2}^{l} h_{j}^{l}$ or the Long-Short Term Memory of $h_{j}^{l}$, instead of the mean. -->
この方程式では、$\boldsymbol{W}_{2}^{l} h_{j}^{l}$や$h_{j}^{l}$の長期短期記憶の平均ではなく、その和や最大値をとる操作を行っています

<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure3.png" /><br>
<b>Figure 4:</b> GraphSage
</center> -->
<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure3.png" /><br>
<b>図4:</b> GraphSage
</center>


<!-- ### Graph Isomorphism Networks (GIN) -->
### Graph Isomorphism Network (GIN)

<!-- An architecture that can differentiate graphs that are not isomorphic. *Isomorphism* is the measure of equivalence between graphs. In the figure below, the two graphs are considered isomorphic to each other. Isomorphic graphs will be treated in a similar way and non-isomorphic graphs will be treated differently.

GIN is an isotropic GCN. -->

Graph Isomorphism Networkは、同型ではないグラフを区別できるアーキテクチャです。*同型性*とは、グラフ間の等価性を表す尺度です。下の図では、2つのグラフが互いに同型であると考えられています。同型なグラフは同じように扱われ、同型でないグラフは異なるように扱われます。

GINは等方的なグラフ畳み込みニューラルネットです。

$$h_{i}^{l+1} = \texttt{ReLU}(\boldsymbol{W}_{2}^{l}\space \texttt{ReLU}(\texttt{BN}(\boldsymbol{W}_{1}^{l} \hat(h_{j}^{l+1})))$$

<!-- where, $\texttt{BN}$ stands for Batch Normalization. -->
ここで、$\texttt{BN}$はバッチ正規化を表しています。

$$h_{i}^{l+1} = (1 + \epsilon)h_{i}^{l} + \sum_{j \in N_{i}} h_{j}^{l}$$

<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure5.png" /><br>
<b>Figure 5:</b> Examples of two isomorphic graphs
</center> -->
<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure5.png" /><br>
<b>図5:</b> 二つの同型グラフの例
</center>


<!-- ## Anisotropic GCNs -->
## 等方的でないグラフ畳み込みニューラルネット

<!-- Standard CNNs have the ability to produce anisotropic filters — ones that favour certain directions. This is because the directional structure is based on up, down, left, and right. However, the GCNs described above have no notion of direction, and thus can only produce isotropic filters. Anisotropy can be introduced naturally, with edge features. For instance, molecules can have single, double, and triple bonds. Graphically, it is introduced weighting different neighbours differently. -->
標準的な畳み込みニューラルネットは、異方性フィルター、すなわち、特定の方向を好むフィルターを生成する能力を持っています。これは、方向の構造が上下左右に基づいているからです。しかし、上述のグラフ畳み込みニューラルネットは方向の概念を持たないため、等方性フィルタしか生成できません。異方性は、エッジの特徴を利用して自然に導入することができます。例えば、分子は一重結合、二重結合、三重結合を持つことができます。グラフ的には、異なる近傍ごとに異なる重み付けを導入します。


<!-- ### MoNets -->
### MoNet

<!-- MoNets use the degree of the graph to learn the parameters of a Gaussian Mixture Model (GMM). -->
MoNetは、混合ガウスモデル（GMM）のパラメータを学習するためにグラフの次数を使用します。

<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure6.png" /><br>
<b>Figure 6:</b> MoNet
</center> -->
<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure6.png" /><br>
<b>図6:</b> MoNet
</center>


<!-- ### Graph Attention Networks (GAT) -->
### Graph Attention Network (GAT)

<!-- GAT uses the attention mechanism to introduce anisotropy in the neighbourhood aggregation function. -->
GATはattention機構を使用することで、近傍を集約する関数に異方性を導入します。

<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure7.png" /><br>
<b>Figure 7:</b> GAT
</center> -->
<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure7.png" /><br>
<b>図7:</b> GAT
</center>


<!-- ### Gated Graph ConvNets -->
### Gated Graph ConvNet

<!-- These use a simple edge gating mechanism, which can be seen as a softer attention process as the sparse attention mechanism used in GATs. -->
これは単純なエッジのゲーティング機構を使用しており、GATで使用されているスパースなattention機構のように、よりソフトなattention機構と見ることができます。

<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure8.png" /><br>
<b>Figure 8:</b> Gated Graph ConvNet
</center> -->
<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure8.png" /><br>
<b>図8:</b> Gated Graph ConvNet
</center>


<!-- ### Graph Transformers -->
### Graph Transformer

<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure9.png" /><br>
<b>Figure 9:</b> Graph Transformer
</center> -->
<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure9.png" /><br>
<b>図9:</b> Graph Transformer
</center>

<!-- This is the graph version of the standard transformer, commonly used in NLP. If the graph is fully connected (every two nodes share an edge), we recover the definition of a standard transformer.

Graphs obtain their structure from sparsity, so the fully connected graph has trivial structure and is essentially a set. Transformers then can be viewed as **Set** Neural Networks, and are in fact the best technique currently to analyse sets/bags of features. -->

これはNLPでよく使われる標準的なtransformerのグラフ版です。グラフが全結合している（2つのノードがすべて1つの辺を共有している）場合、標準的なtransformerと同じになります。

グラフは、スパース性によってその構造が決まるので、全結合しているグラフの持つ構造は些細なものであり、本質的には単なる集合と変わりません。Transformerは、**集合**ニューラルネットワークとして見ることができ、実際には、現在のところ、特徴の集合を分析するのに最適な技術です。



<!-- ## Benchmarking GNNs -->
## GNNのベンチマーク

<!-- Benchmarks are an essential part of progress in any field. The recently released benchmark [Benchmarking Graph Neural Networks](https://arxiv.org/pdf/2003.00982.pdf/) has six medium-scale datasets that can be used for four fundamental graph problems - graph classification, graph regression, node classification and edge classification. Though these datasets are mediumly sized, they are enough to statiscally separate trends in various GNNs.

As an example of a **Graph Regression task**, we would want to predict the molecular solubility. -->

ベンチマークは、どのような分野でも進歩に欠かせないものです。最近リリースされたベンチマーク[Benchmarking Graph Neural Networks](https://arxiv.org/pdf/2003.00982.pdf/)では、グラフ分類、グラフ回帰、ノード分類、エッジ分類という4つの基本的なグラフ問題に使用できる6つの中規模データセットが提案されています。これらのデータセットは中規模ではありますが、様々なGNNの傾向を統計的に分離するには十分な大きさです。

**グラフ回帰**の例として、分子の溶解度を予測したいとします。

<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure10.png" /><br>
<b>Figure 10:</b> Graph Regression task - Quantum Chemistry
</center>

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure11.png" /><br>
<b>Figure 11:</b> Performance of various GCNs on the regression task
</center> -->

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure10.png" /><br>
<b>図10:</b> グラフ回帰タスク：量子化学
</center>

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure11.png" /><br>
<b>図11:</b> 回帰タスクに対する様々なGCNの性能
</center>

<!-- We notice that in most cases anisotropic GCNs perform better compared to isotropic GCNs because we use directional properties.

For a **Graph Classification task**, a Computer Vision problem was chosen where we have super nodes of images and we want to classify the image. -->

ほとんどの場合、異方的なGCNの方が等方的なGCNよりも性能が良いことがわかります。

**グラフ分類タスク**としては、画像のスーパーノードがあり、その画像を分類することを目的としたコンピュータビジョンの問題が選ばれました．


<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure12.png" /><br>
<b>Figure 12:</b> Graph Classification task
</center>

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure13.png" /><br>
<b>Figure 13:</b> Performance of various GCNs on Graph Classification task
</center> -->

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure12.png" /><br>
<b>図12:</b> グラフ分類タスク
</center>

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure13.png" /><br>
<b>図13:</b> 様々なGCNの、グラフ分類タスクに対する性能
</center>

<!-- For an **Edge Classification task**, we have considered the Combinatorial Optimization problem of the Travelling Salesman Problem (TSP) - where we want to know if a particular edge belongs to the optimal solution. If it belongs to the solution it falls in class 1, else class 0. Here we need explicit edge features, and the only model that does a good job of this is GatedGCN. -->
**エッジの分類タスク**としては、巡回セールスマン問題(TSP)の組合せ最適化問題について考えました。ここでは、特定のエッジが最適解に属しているかどうかを知りたい場合、そのエッジが最適解に属していればクラス1、そうでなければクラス0になります。 ここでは、明示的なエッジ特徴が必要であり、これに適したモデルはGated GCNだけです。

<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure14.png" /><br>
<b>Figure 14:</b> Edge Classification task.
</center>

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure15.png" /><br>
<b>Figure 15:</b> Performance of various GCNs on Edge Classification task
</center> -->

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure14.png" /><br>
<b>図14:</b> エッジ分類タスク
</center>

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure15.png" /><br>
<b>図15:</b> エッジ分類タスクに対する、様々なGCNの性能
</center>

<!-- We can use GCNs for self-supervised tasks as well, they are not limited to supervised learning models. According to Dr. Yann LeCun, almost all self-supervised learning tasks exploit some sort of graph structure. When we do a self-supervised learning task in text, where we take a sequence of words and we learn to predict missing words or new sentences. There is a graphs structure here, which is how many times a word appears some distance away from another word. Text would be a linear graph, and the neighbours chosen would be used to train a Transformer. In the case of contrastive training, where we have two samples that are similar, and two which are dissimilar - it is essentially a similarity graph, where two samples are linked when they are similar and if they are not linked they are considere dissimilar. -->
GCNは、教師あり学習モデルに限定されるものではなく、自己教師あり学習タスクにも利用できます。Yann LeCun博士によると、ほとんどすべての自己教師あり学習タスクは、何らかのグラフ構造を利用しているといいます。テキストで自己教師あり学習タスクを行う場合、単語の列を取り、不足している単語や新しい文を予測することを学習します。ここにはグラフ構造があり、ある単語が他の単語から何回離れて出現するかを表しています。テキストは線形グラフになり、選択された近傍はTransformerを訓練するために使用されます。対照学習の場合、似ている2つのサンプルと似ていない2つのサンプルがある場合、これは本質的には類似性グラフであり、2つのサンプルが似ているときはリンクされ、リンクされていないときには似ていないとみなされます。

<!-- ## Conclusion -->
## 結論

<!-- GCNs generalize CNNs to data on graphs. The convolution operator needed to be redesigned on graphs. Doing this for template matching gave rise to Spatial GCNs, and for spectral convolution lead to Spectral GCNs.

There is linear complexity for sparse graphs, and GPU implementation, although the latter is not yet optimized for sparse matrix multiplication. The applications are abound as shown below. -->

GCNはCNNをグラフ上のデータに一般化します。そのためには畳み込み演算子をグラフ上のデータを扱うように再設計する必要がありました。これをテンプレートマッチングについて行うことで空間的GCNが、スペクトル畳み込みに対して行うことでスペクトルGCNが生まれました。

スパースなグラフとGPUでの実装に対しては（GPUでの実装はスパースな行列の乗算に対しては最適化されていませんが）計算量が線形オーダーです。応用例は以下のように豊富です。

<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure16.png" /><br>
<b>Figure 16:</b> Applications
</center> -->
<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure16.png" /><br>
<b>図16:</b> 応用例
</center>
