---
lang-ref: ch.13-1
title: Graph Convolution Networks I
lecturer: Xavier Bresson
authors: Bilal Munawar, Alexander Bienstock, Can Cui, Shaoling Chen
date: 27 Apr 2020
lang: ja
translation-date: 6 Dec 2020
translator: Shiro Takagi
---


<!-- ## Traditional ConvNets -->
## 伝統的な畳み込みニューラルネット

<!-- ConvNets are powerful architectures to solve high-dimensional learning problems. -->
畳み込みニューラルネットは、高次元の学習問題を解決するための強力なアーキテクチャです。

<!-- ### What is the Curse of Dimensionality?

Consider an image of 1024 x 1024 pixels. This image can be seen as a point in the space for 1,000,000 dimensions. Using 10 samples per dimension generates ${10}^{1,000,000}$ images, which is extremely high. ConvNets are extremely powerful to extract best representation of high-dimensional image data, such as the one given in the example. -->

### 次元の呪いとは何か？

1024×1024ピクセルの画像を考えてみましょう。この画像は1,000,000次元の空間の点として見ることができます。1次元あたり10個のサンプルを使うと、${10}^{1,000,000}$の画像が生成されますが、これは非常に大きい値になります。畳み込みニューラルネットは，例に挙げたような高次元の画像データを最適な表現で抽出するために非常に強力です。

- dim(image) = **1024 x 1024** = ${10}^{6}$
- **N = 10** サンプル・次元 --> **${10}^{1,000,000}$ 点**
<!-- 
<center>
<img src="{{site.baseurl}}/images/week13/13-1/ConvNets.png" height="100%" width="100%"/><br>
<b>Fig. 1</b>: ConvNets extract representation of high-dimensional image data.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week13/13-1/ConvNets.png" height="100%" width="100%"/><br>
<b>図1</b>: 畳み込みニューラルネットは高次元な画像のデータの表現を抽出します。
</center>

<!-- ### Main assumptions about ConvNets: -->
### 畳み込みニューラルネットに関する主な前提条件：

 <!-- **1. Data (images, videos, speech) is compositional.** -->
 **1. データ（画像、ビデオ、音声）の構成的性質**

<!-- It is formed of patterns that are: -->
データは、以下のようなパターンで構成されます：

<!-- * **Local**  A neuron in the neural network is only connected to the adjacent layers, but not to all layers in the network. We call this the local reception field assumption.
* **Stationary**  We have some patterns that are similar and are shared across our image domain. For example, the yellow bedsheet in the middle image of figure 2.
* **Hierarchical**  Low level features will be combined to form medium level features. Subsequently, these medium level features will combined to progressively form higher and higher level features. For example, a visual representation. -->

* **局所性**：ニューラルネットワークのニューロンは、隣接する層にしか接続されておらず、ネットワーク内のすべての層に接続されているわけではありません。これを局所的受容野の仮定と呼びます。
* **定常性**：画像領域全体で共有されている類似したパターンがいくつかあります。例えば、図2の中央の画像にある黄色のベッドシートです。
* **階層性**：低レベルの特徴を組み合わせて、中レベルの特徴を形成します。その後、これらの中レベルの特徴が組み合わされて、徐々に高レベルの特徴が形成されていきます。例えば、視覚的な表現はこのような階層性を持っています。

<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-1/Pattern.png" height="100%" width="100%"/><br>
<b>Fig. 2</b>: Data is compositional.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week13/13-1/Pattern.png" height="100%" width="100%"/><br>
<b>図2</b>: データは構成的です。
</center>

<!-- **2. ConvNets leverage the compositionality structure.** -->
**2. 畳み込みニューラルネットによる構成的な構造の活用**

<!-- They extract compositional features and feed them to classifier, recommender, etc. -->
畳み込みニューラルネットは構成的な特徴を抽出して、分類器やレコメンダーなどに供給します。

<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-1/compositionality.png" height="75%" width="100%"/><br>
<b>Fig. 3</b>: ConvNets leverage the compositionality structure.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week13/13-1/compositionality.png" height="75%" width="100%"/><br>
<b>図3</b>: 畳み込みニューラルネットは構成的な構造を活用します。
</center>

<!-- ## Graph Domain -->
## グラフ領域

<!-- ### Data Domain -->
### データ領域

<!-- * Images, volumes, videos lie on 2D, 3D, 2D+1 Euclidean domains (grids). Each pixel is represented by a vector of red, green, and blue values. -->
* 画像、物体、ビデオは2次元、3次元、2+1次元ユークリッド領域（グリッド）上にあります。各ピクセルは赤、緑、青の値のベクトルで表されます。


<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-1/Image.png" height="80%" width="80%"/><br>
<b>Fig. 4</b>: Images have multiple dimensions.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week13/13-1/Image.png" height="80%" width="80%"/><br>
<b>図4</b>: 画像は多次元です。
</center>


<!-- * Sentences, words, speech lie on 1D Euclidean domain. For example, each character can be represented by an integer. -->
* 文、単語、音声は1次元ユークリッド空間にあります。例えば、各文字は整数で表すことができます。

  <!-- <center>
  <img src="{{site.baseurl}}/images/week13/13-1/Sequence.png" height="80%" width="80%"/><br>
  <b>Fig. 5</b>: Sequences have single dimension.
  </center> -->
  <center>
  <img src="{{site.baseurl}}/images/week13/13-1/Sequence.png" height="80%" width="80%"/><br>
  <b>図5</b>: 系列データは一次元です。
  </center>


<!-- * These domains have strong regular spatial structures, which allows all ConvNets operations to be fast and mathematically well defined. -->
* これらのドメインは強力な規則的な空間構造を持っているため、畳み込みニューラルネットのすべての操作は高速でwell-definedです。

  <!-- <center>
  <img src="{{site.baseurl}}/images/week13/13-1/Speech.png" height="80%" width="80%"/><br>
  <b>Fig. 6</b>: Speech data has 1D grid.
  </center> -->
  <center>
  <img src="{{site.baseurl}}/images/week13/13-1/Speech.png" height="80%" width="80%"/><br>
  <b>図6</b>: 発話データは1次元のグリッドデータです。
  </center>


<!-- ### Graph Domain -->
### グラフ領域

<!-- #### Motivational Examples of graph domains

Let's consider a social network. The social network is best captured by a graph representation since pair-wise connection between two users do not form a grid. Nodes of the graph represents users, whereas the edges between two nodes represent connection between two nodes (users). Each user has a three-dimensional feature matrix containing such as messages, images, and videos. -->

#### グラフ領域を考える動機を与えるような例

ソーシャルネットワークを考えてみましょう。ソーシャルネットワークは、2人のユーザ間のペア間の接続がグリッドを形成しないため、グラフ表現で表現するのが最も適しています。グラフのノードはユーザを表し、2つのノード間の辺は2つのノード（ユーザ）間のつながりを表します。各ユーザは、メッセージ、画像、動画などを含む三次元の特徴行列を持っています。

<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-1/socialnetworks.png" height="70%" width="80%"/><br>
<b>Fig. 7</b>: Social networks by graph representation.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week13/13-1/socialnetworks.png" height="70%" width="80%"/><br>
<b>図7</b>: ソーシャルネットワークのグラフ表現。
</center>

<!-- The connection between the structure and function of the brain to predict neural genetic diseases offers a motivational example to consider. As can be seen below, the brain is composed of several Region of Interest(s) (ROI). These ROIs is only locally connected to some surrounding regions of interests. Adjacency matrix represents the degree of strengths between different regions of interest. -->
神経遺伝病を予測するための脳の構造と機能の関係は、グラフを考えるべき動機を与える例です。以下に見られるように、脳はいくつかの関心領域（ROI）で構成されています。これらのROIは、局所的にしか周囲の関心領域に接続されていません。隣接行列は、異なる関心領域間の接続の強さの度合いを表しています。

<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-1/brainconnectivity.png" height="80%" width="80%"/><br>
<b>Fig. 8</b>: Brain connectivity by graph representation.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week13/13-1/brainconnectivity.png" height="80%" width="80%"/><br>
<b>図8</b>: 脳のなかの結合のグラフ表現。
</center>


<!-- Quantum Chemistry also offers an interesting representation of graphical domain. Each atom is represented by a node in graph and is connected to other atoms through bonds using edges. Each of these molecules/atoms have different features, such as the associated charge, bond type etc. -->
量子化学はまた、グラフで表現できるデータの興味深い例を提供しています。各原子はグラフのノードで表され、辺を使って結合を介して他の原子と接続されています。これらの分子/原子のそれぞれは、関連する電荷、結合タイプなどの異なる特徴を持っています。

<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-1/quantumchemistry.png" height="80%" width="80%"/><br>
<b>Fig. 9</b>: Quantum chemistry by graph representation.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week13/13-1/quantumchemistry.png" height="80%" width="80%"/><br>
<b>Fig. 9</b>: 量子化学のグラフ表現。
</center>


<!-- ### Graph Definition and Characteristics -->
### グラフの定義と特徴

<!-- * Graph G is defined by:
    * **Vertices V**
    * **Edges E**
    * **Adjacency matrix A** -->

* グラフ G は次のように定義されます：
    * **頂点 V**
    * **辺 E**
    * **隣接行列**

<!-- * Graph features:
    * **Node features: $h_{i}$, $h_{j}$** (atom type)
    * **Edge features: $e_{ij}$** (bond type)
    * **Graph features:** g (molecule energy) -->

* グラフの特徴量：
    * **ノードの特徴量：$h_{i}$, $h_{j}$** (原子型)
    * **辺の特徴量：$e_{ij}$** (ボンドタイプ)
    * **グラフの特徴量：** g (分子エネルギー)

<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-1/graph.png" height="50%" width="80%"/><br>
<b>Fig. 10</b>: Graph.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week13/13-1/graph.png" height="50%" width="80%"/><br>
<b>図10</b>: グラフ。
</center>




<!-- ## Convolution of Traditional ConvNets -->
## 通常の畳み込みニューラルネットの畳み込み

<!-- ### Convolution -->
### 畳み込み

<!-- We abstractly define convolution as:

$$h^{\ell+l} = w^\ell * h^\ell,$$
where $h^{\ell+1}$ is $n_1\times n_2\times d$-dimensional, $w^\ell$ is $3\times 3\times d$-dimensional, and $h^\ell$ is $n_1\times n_2\times d$-dimensional.
For example, $n_1$ and $n_2$ could be the number of pixels in the $x$ and $y$ directions of an image, respectively, and $d$ is the dimensionality of each pixel (e.g., 3 for a colored image).\\
So, $h^{\ell+1}$ is a feature at the $(\ell+1)$-th hidden layer obtained by applying the convolution $w^\ell$ to a feature at the $\ell$-th layer.\\
Usually the kernel is small to represent a local reception field -- $3\times 3$ in this case, or $5\times 5$, for example.\\
Note: we use padding to ensure the dimensions of $h^{\ell+1}$ are the same as those of $h^\ell$.\\

For example, in this image, the kernel may be used to recognize lines. -->

畳み込みを抽象的に定義すると

$$h^{\ell+l} = w^\ell * h^\ell,$$
となります。ここで、$h^{\ell+1}$は、$n_1\times n_2\times d$次元で、 $w^\ell$は、$3\times 3\times d$次元で、 $h^\ell$は、$n_1\times n_2\times d$次元です。
例えば、$n_1$と$n_2$は、それぞれ画像の$x$方向と$y$方向の画素数、$d$は各画素の次元数(例えば、色のついた画像の場合は3)です。
つまり、$h^{\ell+1}$は、$(\ell+1)$番目の 隠れ層の特徴表現に畳み込み $w^\ell$を適用して得られた、$(\ell+1)$層目の隠れ層の特徴表現です。
通常、カーネルは、局所的な受信野を表現するために小さくなっています。この場合は、$3 \times 3$や、$5 \times 5$などです。
$h^{\ell+1}$層目の次元が$h^{\ell}$層目の次元と一致するように、パディングを用いていることに注意してください。

例えば、この画像では、カーネルを使うことで線を認識しているのかもしれません。

<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-1/linekernel.png" height="90%" width="80%"/><br>
<b>Fig. 11</b>: Kernel can be used to recognize lines in images.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week13/13-1/linekernel.png" height="90%" width="80%"/><br>
<b>図11</b>: 線の認識のためにカーネルが使われているかもしれない。
</center>

<!-- ### How do we define convolution?

More exactly, convolution is defined as follows: -->

### 畳み込みはどのように定義されているのでしょうか？

より正確には、畳み込みは以下のように定義されています。

$$h_i^{\ell_1} = w^\ell * h_i^\ell$$

$$ = \sum_{j\in\Omega}\langle w_j^\ell, h_{i-j}^\ell\rangle$$

$$ = \sum_{j\in\mathcal{N}_i} \langle w_j^\ell, h_{ij}^\ell\rangle$$

$$=\sum_{j\in\mathcal{N}_i} \langle \Bigg[w_j^\ell\Bigg], \Bigg[h_{ij}\Bigg]\rangle$$

<!-- The above defines convolution as *template matching*.\\
We usually use $h_{i+j}$ instead of $h_{i-j}$, because the former is actually correlation, which is more like template matching. -->

上記では、畳み込みを *テンプレートマッチング*として定義しています。
通常は $h_{i-j}$ の代わりに $h_{i+j}$ を使います。なぜなら前者は実際には相関で、テンプレートマッチング以上のものだからです。

<!-- However, it does not really matter if you use the first or second, because your kernel is just flipped, and this does not impact learning. -->

<!-- In the third line, we just write $h_{i+j}^\ell$ as $h_{ij}^\ell$. -->

<!-- The kernel is very small, so instead of summing over the whole image $\Omega$, as in the second line, we actually just sum over the neighborhood of cell $i$, $\mathcal{N}_i$, as denoted in the third line. -->

<!-- This makes it so that the complexity of convolution is $O(n)$, where $n$ is the number of pixels in the input image. -->

<!-- Convolution is exactly for each of the $n$ pixels, summing over inner products of vectors of dimension $d$ over $3\times 3$ grids. -->

<!-- The complexity is thus $n\cdot 3\cdot 3\cdot d$, which is $O(n)$; and moreover the computational can be done in parallel with GPUs at each of the $n$ pixels. -->

しかし、1行目を使っても2行目を使っても、カーネルが反転しているだけなので、学習には影響しません。

3行目では、$h_{i+j}^\ell$を$h_{ij}^\ell$と書くだけです。

カーネルは非常に小さいので、２行目のように画像全体$\Omega$で合計するのではなく、３行目のように、セル$i$の近傍$\mathcal{N}_i$で合計します。

これにより、畳み込みの計算量は $O(n)$ となります。ここで $n$ は入力画像のピクセル数です。

畳み込みは、$n$の各画素に対して、$d$次元のベクトルの内積を$3 \times 3$の格子上で足し合わせます。

よって、計算量は$n\cdot 3\cdot 3\cdot d$、つまり$O(n)$です。さらに、GPUを用いて$n$の各画素で並列計算が可能です。

<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-1/orderednodes.png" height="80%" width="80%"/><br>
<b>Fig. 12</b>: Nodes are ordered in the same way.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week13/13-1/orderednodes.png" height="80%" width="80%"/><br>
<b>図12</b>: ノードは同じように並んでいる
</center>

<!-- If the graph you are convolving over is a grid, as in standard convolution over images in computer vision, then the nodes are ordered as in the above image.
Therefore, $j_3$ will always be in the top right corner of the pattern.

So for all nodes $i$ in the image below, such as $i$ and $i'$, the node ordering of the kernel is always the same.
For example, you always compare $j_3$ at the top right corner of the pattern with the top right corner of the image patch (what we convolve over for pixel $i$), as shown below.
Mathematically speaking: -->

コンピュータビジョンの標準的な画像に対する畳み込みのように、畳み込みをかけているグラフがグリッドである場合、ノードは上の画像のように順序付けられます。
したがって、 $j_3$ は常にそのパターンの右上にあります。

ですから、下の画像のすべてのノード $i$ に対して、 $i$ と $i'$ のように、カーネルのノードの順序は常に同じになります。
例えば、以下に示すように、パターンの右上隅にある $j_3$ と画像パッチの右上隅にある $j_3$ を常に比較します (ピクセル $i$ に対して畳み込むもの)。
数学的に言えば

$$
\langle\Bigg[w_{j_3}^\ell\Bigg], \Bigg[h_{ij_3}^\ell \Bigg]\rangle
$$

と

$$
\langle\Bigg[w_{j_3}^\ell\Bigg], \Bigg[h_{i'j_3}^\ell \Bigg]\rangle
$$

<!-- are always for the top right corner between the template and the image patches. -->
は、常にテンプレートと画像パッチの間の右上隅にあります。

<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-1/templatesmatch.png" height="70%" width="80%"/><br>
<b>Fig. 13</b>: Image patches match the templates.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week13/13-1/templatesmatch.png" height="70%" width="80%"/><br>
<b>図13</b>: 画像パッチがテンプレートと合う。
</center>


<!-- ### Can we extend template matching for graphs? -->
### テンプレートマッチングをグラフに拡張することはできるでしょうか？

<!-- We have a couple of issues:
1. First, in a graph, there is no ordering of the nodes.

So in the template shown below in the image, node $j_3$ has no specific position, but just an (arbitrary) index.
So, when we try to match against nodes $i$ and $i'$ in the graph below, we do not know if $j_3$ is matching against the same nodes in both convolutions.\\
This is because there is no notion of the *top right corner* of the graph.\\
There is no notion of up, down, left right.\\
Thus, the template matchings actually have no meaning and we cannot use the definition of template matching directly, as above. -->

いくつかの問題があります。
1. まず、グラフでは、ノードには順序がありません。

そのため、下の画像のテンプレートでは、ノード $j_3$ には特定の位置はなく、（任意の）インデックスがあるだけです。
だから、下のグラフのノード$i$と$i'$にマッチしようとしても、$j_3$が両方の畳み込みで同じノードにマッチしているかどうかはわかりません。
これは、グラフには右上隅と言うものがないからです。
上下左右という概念がないのです。
このように、テンプレートマッチングには意味がないので、上記のように、テンプレートマッチングの定義をそのまま使うことはできません。

<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-1/nonodeordering.png" height="70%" width="80%"/><br>
<b>Fig. 14</b>: No node ordering in a graph.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week13/13-1/nonodeordering.png" height="70%" width="80%"/><br>
<b>図14</b>: グラフではノードに順序がない。
</center>

<!-- 2. The second issue is that neighborhood sizes may be different.

So the template $w^\ell$ shown below has 4 nodes, but node $i$ has 7 nodes in its neighborhood.
How can we compare these two? -->

2. 2つ目の問題は、近傍のサイズが異なる場合があるということです。

例えば、下に示すテンプレート $w^\ell$には4つのノードがありますが、ノード $i$ の近傍には7つのノードがあります。
この２つを比較するにはどうすればよいのでしょうか？

<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-1/diffneigh.png" height="70%" width="80%"/><br>
<b>Fig. 15</b>: Different neighborhood sizes in a graph.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week13/13-1/diffneigh.png" height="70%" width="80%"/><br>
<b>図15</b>: グラフの中での異なる近傍の大きさ。
</center>

<!-- ## Graph Convolution

We now use the **Convolution Theorem** to define convolution for graphs.

The **Convolution Theorem** states that the Fourier transform of the convolution of two functions is the pointwise product of their Fourier transforms: -->

## グラフ畳み込み

ここでは、**畳み込み定理**を用いて、グラフの畳み込みを定義します。

**畳み込み定理**は、2つの関数の畳み込みのフーリエ変換は、それらのフーリエ変換の各要素ごとの積であるといっています。

$$\mathcal{F}(w*h) = \mathcal{F}(w) \odot \mathcal{F}(h) \implies w * h = \mathcal{F}^{-1}(\mathcal{F}(w)\odot\mathcal{F}(h))$$

<!-- In general, the Fourier transform has $O(n^2)$ complexity, but if the domain is a grid, then the complexity can be reduced to $O(n\log n)$ with FFT. -->
一般にフーリエ変換は$O(n^2)$の計算量ですが、ドメインがグリッドであれば、FFTで$O(n\log n)$の計算量にすることができます。

<!-- ### Can we extend the Convolution theorem to graphs?

This raises two questions:
1. How to define Fourier transforms for graphs?
2. How to compute fast spectral convolutions in $O(n)$ time for compact kernels (as in template matching)? -->

### 畳み込み定理をグラフに拡張できるか？

これは二つの疑問を投げかけています。
1. グラフのフーリエ変換はどうやって定義するのか？
2. コンパクトなカーネル（テンプレートマッチングのように）のための高速なスペクトル畳み込みを $O(n)$ 時間で計算するにはどうすればよいか？

$$w *_{\mathcal{G}} h \stackrel{?}{=} \mathcal{F}^{-1}_{\mathcal{G}}(\mathcal{F}_{\mathcal{G}}(w)\odot\mathcal{F}_{\mathcal{G}}(h))$$

<!-- We are going to use these two design for graph neural networks:
Template matching will be for spacial graph ConvNets and the Convolution theorem will be used for the spectral ConvNets. -->
グラフニューラルネットワークに対して、これらの2つのデザインを使用します。
テンプレートマッチングは空間的グラフ畳み込みニューラルネットに、畳み込み定理はスペクトル畳み込みニューラルネットに使用されます。


<!-- ## Spectral Graph ConvNets

How to perform spectral convolution?

### Step 1 : Graph Laplacian

This is the core operator in spectral graph theory.

Define -->

## スペクトルグラフ畳み込みニューラルネット

スペクトル畳み込みを行うにはどうすれば良いのでしょうか？

### ステップ 1 : グラフラプラシアン

スペクトルグラフ理論の中心的な演算子です。

以下を定義します

$$
\begin{aligned} \mathcal{G}=(V, E, A) & \rightarrow \underset{n \times n}{\Delta}=\mathrm{I}-D^{-1 / 2} A D^{-1 / 2} \\ & \quad \text { ただし } \underset{n \times n} D=\operatorname{diag}\left(\sum_{j \neq i} A_{i j}\right) \end{aligned}
$$


<!-- Note Matrix $A$ is the adjacency matrix, and the $\Delta$ is the Laplacian, which equals to the identity minus the adjacency matrix normalized by Matrix $D$. $D$ is a diagonal matrix, and each element on the diagonal is the degree of the node. This is called the normalized Laplacian, or Laplacian by default in this context.


The Laplacian is interpreted as the measurement of smoothness of graph, in other words, the difference between the local value $h_i$ and its neighborhood average value of $h_j$'s. $d_i$ on the formula below is the degree of node $i$, and $\mathcal{N}_{i}$ is the all the neighbors of node $i$. -->

行列 $A$ は隣接行列であり、$\Delta$ はラプラシアンであり、これは単位行列から行列 $D$ で正規化された隣接行列を引いたものに等しいことに注意してください。これは正規化ラプラシアンと呼ばれ、この文脈では通常ラプラシアンと呼ばれています。

ラプラシアンは、グラフの滑らかさの測定値、言い換えれば、局所的な値 $h_i$ とその近傍 $h_j$ たちの平均値との間の差と解釈されます。下式の$d_i$はノード$i$の滑らかさであり、$\mathcal{N}_{i}$はノード$i$の近傍全ての滑らかさです。

$$
(\Delta h)_{i}=h_{i}-\frac{1}{d_{i}} \sum_{j \in \mathcal{N}_{i}} A_{i j} h_{j}
$$

<!-- The formula above is to apply Laplacian to a function $h$ on the node $i$, which is the value of $h_i$ minus the mean value over its neighboring nodes $h_j$'s. Basically, if the signal is very smooth, the Laplacian value is small, and vice versa. -->
上の式は、ノード$i$上の関数$h$にラプラシアンを適用するもので、$h_i$の値から隣接ノード$h_j$の平均値を差し引いたものです。基本的に、信号が非常に滑らかであればラプラシアンの値は小さく、その逆もまた然りです。

<!-- ### Step 2 : Fourier Functions -->
### ステップ２：フーリエ関数

<!-- The following is the eigen-decomposition of graph Laplacian, -->
グラフラプラシアンの固有分解は以下のようになります。

$$
\underset{n \times n}{\Delta}=\Phi^{T} \Lambda \Phi
$$


<!-- The Laplacian is factorized into three matrices, $\Phi ^ T$, $\Lambda$, $\Phi$.

$\Phi$ is defined below, it contains column vectors, or Lap eigenvectors $\phi_1$ to $\phi_n$, each of size $n \times 1$, and those are also called Fourier functions. And Fourier functions form an orthonormal basis. -->

ラプラシアンは、$\Phi ^ T$, $\Lambda$, $\Phi$の３つの行列に分解されます。

$\Phi$ は、以下のように定義されていて、それぞれの大きさが $n \times 1$ である列ベクトル、つまりラップ固有ベクトルを含んでいます。そして、これらはフーリエ関数と呼ばれており、正規直交基底を成します。

$$
\begin{array}{l}\underset{n \times n}{\Delta}\Phi=\left[\phi_{1}, \ldots, \phi_{n}\right]=\text { and } \Phi^{T} \Phi=\mathrm{I},\left\langle\phi_{k}, \phi_{k^{\prime}}\right\rangle=\delta_{k k^{\prime}} \\\end{array}
$$

<!-- $\Lambda$ is a diagonal matrix with Laplacian eigenvalues, and on the diagonal are $\lambda_1$ to $\lambda_n$. And from the normalized applications, these values are typically among the range from $0$ to $2$. Those are also known as the Spectrum of a graph. See the formula below. -->
$\Lambda$ はラプラシアンの固有値を持つ対角行列で、対角線上には $\lambda_1$ から $\lambda_n$ までの値があります。これらの値は、正規化された場合では、典型的には $0$ から $2$ の範囲になります。これらの値は、グラフスペクトルとも呼ばれています。下の式を見てください。

$$
\begin{array}{c} \underset{n \times n}\Lambda=\operatorname{diag}\left(\lambda_{1}, \ldots, \lambda_{n}\right) \text { and } 0 \leq \lambda_{1} \leq \ldots \leq \lambda_{n}=\lambda_{\max } \leq 2\end{array}
$$


<!-- Below is an example of checking the eigenvalue decomposition. The Laplacian matrix $\Lambda$ is multiplied by an eigenvector $\phi_k$, the shape of the result is $n \times 1$, and the result is $\lambda_k \phi_k$. -->
以下に示すのは、固有値分解を確認する例です。ラプラシアン行列$\Lambda$に固有ベクトル$\phi_k$を掛け、結果のシェイプを$n \times 1$とし、結果を$\lambda_k \phi_k$とします。

$$
\begin{array}{ll} \underset{n \times 1}{\Delta \phi_{k}}=\lambda_{k} \phi_{k}, & k=1, \ldots, n \\ & \end{array}
$$

<!-- The image below is the visualization of eigenvectors of 1D Euclidean Laplacian. -->
下の画像は、1次元ユークリッドラプラシアンの固有ベクトルを可視化したものです。

<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-1/grid.png" height="90%" width="100%"/><br>
<b>Fig. 16</b>: Grid/Euclidean Domain: eigenvectors of 1D Euclidean Laplacian.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week13/13-1/grid.png" height="90%" width="100%"/><br>
<b>図16</b>: グリッド・ユークリッド領域：一次元ユークリッドラプラシアンの固有ベクトル。
</center>

<!-- For graph domain, from the left to right, is the first, second, third, .. Fourier functions of a graph. For example, $\phi_1$ has oscillations of positive (red) and negative (blue) values, same for $\phi2$, $\phi3$. Those oscillations depend on the topology of a graph, which related to the geometry of graphs such as communities, hubs, etc, and it's helpful for graph clustering. See below. -->
グラフの領域で、左から順に、１番目、２番目、３番目、...のフーリエ関数です。例えば、$\phi_1$では、正（赤）と負（青）の振動があり、$\phi_2$, $\phi_3$でも同じです。これらの振動は、コミュニティやハブなどのグラフの幾何学的な形状に関係するなど、グラフのトポロジーに依存しており、グラフのクラスタリングに役立ちます。以下をみてください。

<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-1/graphdomain.png" height="90%" width="100%"/><br>
<b>Fig. 17</b>: Graph Domain: Fourier functions of a graph.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week13/13-1/graphdomain.png" height="90%" width="100%"/><br>
<b>図17</b>: グラフ領域：グラフのフーリエ関数。
</center>

<!-- ### Step 3 : Fourier Transform -->
### ステップ３ : フーリエ変換

$$
\begin{aligned} \underset{n \times 1} h &=\sum_{k=1}^{n} \underbrace{\left\langle\phi_{k}, h\right\rangle}_{\mathcal{F}(h)_{k}=\hat{h}_{k}=\phi_{k}^{T} h}\underset{n \times 1}{\phi_{k}} \\ &=\sum_{k=1}^{n} \hat{h}_{k} \phi_{k} \\ &=\underbrace{\Phi \hat{h}}_{
\mathcal{F}^{-1}(\hat{h})
} \end{aligned}
$$

<!-- **Fourier series: Decompose function $h$ with Fourier functions.**

Take the function $h$ and projected on each Fourier function $\phi_k$, resulting in the coefficient of Fourier series of $k$, a scaler, and then multiplied by the function $\phi_k$. -->

**フーリエ級数：フーリエ関数による関数 $h$ の分解**

関数$h$を取り、各フーリエ関数$\phi_k$に射影し、結果としてスケーリング定数である$k$のフーリエ級数の係数を得て、関数$\phi_k$を掛け合わせます。

<!-- The Fourier transform is basically projecting a function $h$ on the Fourier functions, and the result are the coefficients of the Fourier series. -->

フーリエ変換は、基本的には、フーリエ関数に関数 $h$ を射影する操作で、その結果がフーリエ級数の係数となります。

<!-- **Fourier Transform/ coefficients of Fourier Series** -->
**フーリエ変換／フーリエ級数の係数**

$$
\begin{aligned} \underset{n \times 1}{\mathcal{F}(h)} &=\Phi^{T} h \\
&=\hat{h} \end{aligned}
$$


<!-- **Inverse Fourier Transform** -->
**逆フーリエ変換**

$$
\begin{aligned} \underset{n \times 1}{\mathcal{F}^{-1}(\hat{h})} &=\Phi \hat{h} \\ &=\Phi \Phi^{T} h=h \quad \text { as } \mathcal{F}^{-1} \circ \mathcal{F}=\Phi \Phi^{T}=\mathrm{I} \end{aligned}
$$


<!-- Fourier transforms are linear operations, multiplying a matrix $\Phi^{T}$ with a vector $h$. -->
フーリエ変換は、行列 $\Phi^{T}$ にベクトル $h$ をかける線形演算です。



<!-- ### Step 4 : Convolution Theorem -->
### ステップ４： 畳み込み定理

<!-- Fourier transform of the convolution of two functions is the pointwise product of their Fourier transforms. -->
2つの関数の畳み込みのフーリエ変換は、それらのフーリエ変換の要素毎の積です。

$$
\begin{aligned}
\underset{n \times 1} {w * h} &=\underbrace{\mathcal{F}^{-1}}_{\Phi}(\underbrace{\mathcal{F}(w)}_{\Phi^{T} w=\hat{w}} \odot \underbrace{\mathcal{F}(h)}_{\Phi^{T} h}) \\ &=\underset{n \times n}{\Phi}\left( \underset{n \times 1}{\hat{w}}\odot \underset{n \times 1}{\Phi^{T} h}\right) \\ &=\Phi\left(\underset{n \times n}{\hat{w}(\Lambda)} \underset{n \times 1}{\Phi^{T} h}\right) \\ &=\Phi \hat{w}(\Lambda) \Phi^{T} h \\ &=\hat{w}(\underbrace{\Phi \Lambda \Phi^{T}}_{\Delta}) h \\ &=\underset{n \times n}{\hat{w}(\Delta)} \underset{n \times1}h \\  &
\end{aligned}
$$

<!-- The example above is the convolution of $w$ and $h$, both of shape $n \times 1$, it equals the inverse of Fourier transform of pointwise product between Fourier transform of $w$ and of $h$. The formula above shows that it also equals to the matrix multiplication of $\hat{w}(\Delta)$ and $h$.

The convolution of two functions on the graph $h$ and $w$ is to take the spectrum function of $w$ and apply it to Laplacian and multiply it by $h$, and this is the definition of spectrum convolution. However, the computation complexity is $\mathrm{O}\left(n^{2}\right)$, while $n$ is the number of nodes in the graph. -->

上の例は、$w$と$h$の畳み込みで、どちらもシェイプが$n \times 1$のものですが、$w$のフーリエ変換と$h$のフーリエ変換の間の要素毎の積の逆数に等しくなります。上の式から、$\hat{w}(\Delta)$と$h$の行列積にも等しいことがわかります。

グラフ$h$と$w$上の2つの関数の畳み込みは、$w$のスペクトル関数を取ってラプラシアンに当てはめて$h$とかけることであり、これがスペクトル畳み込みの定義です。しかし、グラフのノード数$n$ に対して計算量は $\mathrm{O}\left(n^{2}\right)$ です。

<!-- ## Limitation

The spectral convolution against the graph domain is not shifting invariance, which means that if shifted, the shape of the function might also be changed, while in grid/euclidean domain does not.


## Recommended book

Spectral graph theory, Fan Chung, (harmonic analysis, graph theory, combinatorial problems, optimization) -->

## 限界

平行移動されると関数の形状も変化する可能性がありますが、グラフ領域に対するスペクトル畳み込みは並行移動不変ではないので、グリッド/ユークリッド領域では変化しません。


## おすすめの参考書

Spectral graph theory, Fan Chung, (harmonic analysis, graph theory, combinatorial problems, optimization)
