---
lang-ref: ch.12-2
title: Decoding Language Models
lecturer: Mike Lewis
authors: Trevor Mitchell, Andrii Dobroshynskyi, Shreyas Chandrakaladharan, Ben Wolfson
date: 20 Apr 2020
lang: ja
translation-date: 6 Dec 2020
translator: Shiro Takagi
---


<!-- ## [Beam Search](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=2732s) -->
## [ビームサーチ](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=2732s)

<!-- Beam search is another technique for decoding a language model and producing text. At every step, the algorithm keeps track of the $k$ most probable (best) partial translations (hypotheses). The score of each hypothesis is equal to its log probability.

The algorithm selects the best scoring hypothesis. -->

ビームサーチは、言語モデルを解読してテキストを生成するためのもう一つのデコーディング技術です。ビームサーチでは、各ステップで$k$ 個の最も確率の高い（最良の）部分翻訳（仮説）を追跡し続けます。各仮説のスコアは、その確率の対数と同じです。

ビームサーチは、最もスコアの高い仮説を選択します。

<!-- <center>
<img src="{{site.baseurl}}/images/week12/12-2/Beam_Decoding.png" width="60%"/><br>
<b>Fig. 1</b>: Beam Decoding
</center> -->
<center>
<img src="{{site.baseurl}}/images/week12/12-2/Beam_Decoding.png" width="60%"/><br>
<b>図1</b>: ビームによるデコーディング
</center>

<!-- How deep does the beam tree branch out ? -->

<!-- The beam tree continues until it reaches the end of sentence token. Upon outputting the end of sentence token, the hypothesis is finished. -->

<!-- Why (in NMT) do very large beam sizes often results in empty translations? -->

<!-- At training time, the algorithm often does not use a beam, because it is very expensive. Instead it uses auto-regressive factorization (given previous correct outputs, predict the $n+1$ first words). The model is not exposed to its own mistakes during training, so it is possible for “nonsense” to show up in the beam.

Summary: Continue beam search until all $k$ hypotheses produce end token or until the maximum decoding limit T is reached. -->

ビーム木はどのくらいの深さまで続いているのでしょうか？

ビーム木は文末トークンに到達するまで続きます。文末トークンを出力した時点で仮説は終了です。

なぜ（ニューラル機械翻訳では）ビームサイズが非常に大きいと空の翻訳（中身がない翻訳）になることが多いのでしょうか？

学習時には、計算量が多いため、アルゴリズムはビームを使用しないことが多いです。その代わりに、自己回帰的な確率の分解（以前の正しい出力が与えられ、$n+1$の最初の単語を予測する）を使用します。モデルは学習中にそれ自身のミスにさらされることがないので、ビームに「nonsense」が現れる可能性があります。

まとめ：すべての$k$個の仮説がエンドトークンを生成するまで、または最大解読限界Tに達するまでビーム探索を続けます。


<!-- ### Sampling

We may not want the most likely sequence. Instead we can sample from the model distribution.

However, sampling from the model distribution poses its own problem. Once a "bad" choice is sampled, the model is in a state it never faced during training, increasing the likelihood of continued "bad" evaluation. The algorithm can therefore get stuck in horrible feedback loops. -->

### サンプリング

最も可能性の高い文までは必要ないかもしれません。その代わりに、モデル分布からサンプリングすることができます。

しかし、モデル分布からサンプリングすることは、それ自体に問題があります。一度「悪い」選択がサンプリングされると、モデルは学習中には決して直面しなかった状態になり、「悪い」評価が続く可能性が高くなります。そのため、恐ろしい負のフィードバックループに陥ってしまう可能性があります。


<!-- ### Top-K Sampling

A pure sampling technique where you truncate the distribution to the $k$ best and then renormalise and sample from the distribution. -->

### Top-Kサンプリング

この手法は、上位$k$個 のベストな値だけを含むように、$k-1$個以下を切り捨て、残ったものを再び正規化することで確率分布を構成し、そこからサンプリングをするという、純粋なサンプリング手法です。


<!-- <center>
<img src="{{site.baseurl}}/images/week12/12-2/Top_K_Sampling.png" width="60%"/><br>
<b>Fig. 2</b>: Top K Sampling
</center> -->
<center>
<img src="{{site.baseurl}}/images/week12/12-2/Top_K_Sampling.png" width="60%"/><br>
<b>図2</b>: Top-Kサンプリング
</center>

<!-- #### Question: Why does Top-K sampling work so well?

This technique works well because it essentially tries to prevent falling off of the manifold of good language when we sample something bad by only using the head of the distribution and chopping off the tail. -->

#### 質問：Top-Kサンプリングはなぜそんなにうまくいくのですか？

この手法がうまくいくのは、悪いものをサンプリングするときに、分布の裾を切り落とすことで、良い言語がなす多様体から脱落しないようにするからです。

<!-- ## Evaluating Text Generation

Evaluating the language model requires simply log likelihood of the held-out data. However, it is difficult to evaluate text. Commonly word overlap metrics with a reference (BLEU, ROUGE etc.) are used, but they have their own issues. -->

## テキスト生成を評価する

言語モデルを評価するには、単にホールドアウトされたデータの対数尤度を評価する必要があります。しかし、テキストの評価は困難です。一般的には参照を伴う単語オーバーラップ評価指標(BLEU, ROUGEなど)が使われていますが、それぞれに問題があります。


<!-- ## Sequence-To-Sequence Models -->
## Sequence-To-Sequence モデル


<!-- ### Conditional Language Models

Conditional Language Models are not useful for generating random samples of English, but they are useful for generating a text given an input.

Examples:

- Given a French sentence, generate the English translation
- Given a document, generate a summary
- Given a dialogue, generate the next response
- Given a question, generate the answer -->

### 条件付き言語モデル

条件付き言語モデルは、テキストのランダムなサンプルを生成するのには役に立ちませんが、入力が与えられた下でテキストを生成するのには便利です。

例を挙げてみましょう。

- フランス語の文が与えられると、英語の翻訳を生成する
- 文書が与えられた場合、要約を生成する。
- 発話が与えられた場合、次の応答を生成する
- 質問が与えられたら、答えを生成する。



### Sequence-To-Sequence モデル

<!-- Generally, the input text is encoded. This resulting embedding is known as a "thought vector", which is then passed to the decoder to generate tokens word by word. -->
一般的に、入力テキストはエンコードされます。この結果として得られる埋め込みは「思考ベクトル」として知られており、これをデコーダに渡して単語ごとにトークンを生成します。

<!-- <center>
<img src="{{site.baseurl}}/images/week12/12-2/s2s_Models.png" width="60%"/><br>
<b>Fig. 3</b>: Thought Vector
</center> -->
<center>
<img src="{{site.baseurl}}/images/week12/12-2/s2s_Models.png" width="60%"/><br>
<b>図3</b>: 思考ベクトル
</center>


<!-- ### Sequence-To-Sequence Transformer

The sequence-to-sequence variation of transformers has 2 stacks:

1. Encoder Stack – Self-attention isn't masked so every token in the input can look at every other token in the input

2. Decoder Stack – Apart from using attention over itself, it also uses attention over the complete inputs -->

Transformerのsequence-to-sequenceモジュールには、2つのスタックがあります。

1. エンコーダースタック：Self-attentionはマスクされていないので、入力中のすべてのトークンが入力中の他のすべてのトークンを見ることができます。

2. デコーダースタック：自身のに対してattentionを使用する他に、完全な入力に対してもattentionを使用します。


<!-- <center>
<img src="{{site.baseurl}}/images/week12/12-2/s2s_transformers.png" width="60%"/><br>
<b>Fig. 4</b>: Sequence to Sequence Transformer
</center> -->
<center>
<img src="{{site.baseurl}}/images/week12/12-2/s2s_transformers.png" width="60%"/><br>
<b>図4</b>: Sequence to Sequence Transformer
</center>

<!-- Every token in the output has direct connection to every previous token in the output, and also to every word in the input. The connections make the models very expressive and powerful. These transformers have made improvements in translation score over previous recurrent and convolutional models. -->

出力内のすべてのトークンは、出力内のそれ以前のトークンと直接接続し、入力内のすべての単語とも接続します。この接続により、このモデルは非常に表現力が高く、強力なものになります。これらの変換器は、以前のリカレントモデルや畳み込みモデルに比べて、翻訳スコアを向上させました。


## [Back-translation](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=3811s)
## [逆翻訳](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=3811s)
<!-- 
When training these models, we typically rely on large amounts of labelled text. A good source of data is from European Parliament proceedings - the text is manually translated into different languages which we then can use as inputs and outputs of the model. -->
これらのモデルを学習する際には、通常、ラベル付けされた大量のテキストに頼ります。欧州議会の議事録から得たデータが良いソースとなります。このデータではテキストは手動で異なる言語に翻訳されており、モデルの入出力として使用することができます。

<!-- ### Issues -->
### 問題

<!-- - Not all languages are represented in the European parliament, meaning that we will not get translation pair for all languages we might be interested in. How do we find text for training in a language we can't necessarily get the data for?
- Since models like transformers do much better with more data, how do we use monolingual text efficiently, i.e. no input / output pairs?

Assume we want to train a model to translate German into English. The idea of back-translation is to first train a reverse model of English to German

- Using some limited bi-text we can acquire same sentences in 2 different languages
- Once we have an English to German model, translate a lot of monolingual words from English to German.

Finally, train the German to English model using the German words that have been 'back-translated' in the previous step. We note that:

- It doesn't matter how good the reverse model is - we might have noisy German translations but end up translating to clean English.
- We need to learn to understand English well beyond the data of English / German pairs (already translated) - use large amounts of monolingual English -->

- 欧州議会ではすべての言語が代表されているわけではないので、興味のあるすべての言語の翻訳ペアが得られるわけではありません。データが必ずしも得られない言語の学習用テキストをどうやって見つけるのか？という問題があります。
- Transformerのようなモデルは、より多くのデータがあればより良い結果が得られるので、どのようにして単言語のテキストを効率的に使うか、という問題が生じます。例えば入力と出力のペアがない場合にどうするか、などです？

ドイツ語を英語に翻訳するモデルを訓練したいとします。逆翻訳のアイデアは、最初に英語からドイツ語への逆モデルを訓練することです。

- 数は限られているものの、対になっているテキストを使用することで、同じ意味を表す2つの言語の文章を手に入れることができます。
- 英語からドイツ語へのモデルができたら、たくさんの単言語の単語を英語からドイツ語に翻訳します。

最後に、前のステップで「逆翻訳」されたドイツ語の単語を使って、ドイツ語から英語へのモデルを訓練します。ここで注意したいことがあります。

- 逆翻訳モデルがどれだけ優れているかは問題ではありません：ノイズの多いドイツ語の翻訳があっても、最終的にはきれいな英語に翻訳されるかもしれません。
- 英語とドイツ語のペア（すでに翻訳されている）のデータを超えて、英語を理解することを学ぶ必要があります。

<!-- ### Iterated Back-translation -->
### 反復逆翻訳

<!-- - We can iterate the procedure of back-translation in order to generate even more bi-text data and reach much better performance - just keep training using monolingual data.
- Helps a lot when not a lot of parallel data -->
- 逆翻訳の手順を反復することで、より多くの対になるテキストデータを生成し、より良いパフォーマンスを得ることができます。やることは、単言語データを使って訓練を続けるだけです。
- 並列データが少ない場合に非常に役立ちます。

<!-- ## Massive multilingual MT -->
## 大規模多言語機械翻訳

<!-- <center>
<img src="{{site.baseurl}}/images/week12/12-2/multi-language-mt.png" width="60%"/><br>
<b>Fig. 5</b>: Multilingual MT
</center> -->
<center>
<img src="{{site.baseurl}}/images/week12/12-2/multi-language-mt.png" width="60%"/><br>
<b>Fig. 5</b>: 多言語機械翻訳
</center>

<!-- - Instead of trying to learn a translation from one language to another, try to build a neural net to learn multiple language translations.
- Model is learning some general language-independent information. -->

- ある言語から別の言語への翻訳を学習しようとするのではなく、複数の言語の翻訳を学習するためのニューラルネットを構築してみてください。
- そのようなモデルは、言語に依存しないなんらかの一般的な情報を学習します。

<!-- <center>
<img src="{{site.baseurl}}/images/week12/12-2/multi-mt-results.gif" width="60%"/><br>
<b>Fig. 6</b>: Multilingual NN Results
</center> -->
<center>
<img src="{{site.baseurl}}/images/week12/12-2/multi-mt-results.gif" width="60%"/><br>
<b>図6</b>: 多言語 NN の結果
</center>

<!-- Great results especially if we want to train a model to translate to a language that does not have a lot of available data for us (low resource language). -->
特に、利用可能なデータが多くない言語を翻訳するためのモデルを訓練したい場合には、素晴らしい結果が得られます（リソースの少ない言語）。


<!-- ## Unsupervised Learning for NLP

There are huge amounts of text without any labels and little of supervised data. How much can we learn about the language by just reading unlabelled text? -->

## NLPのための教師なし学習

ラベルのない膨大な量のテキストがあり、教師ありデータがほとんどないとします。ラベルのついていないテキストを読むだけで、その言語についてどれだけのことがわかるのでしょうか？


### `word2vec`

<!-- Intuition - if words appear close together in the text, they are likely to be related, so we hope that by just looking at unlabelled English text, we can learn what they mean.

- Goal is to learn vector space representations for words (learn embeddings)

Pretraining task - mask some word and use neighbouring words to fill in the blanks. -->

直感的説明：テキスト中に単語が近くに出てくると関連性がありそうです。ですので、この情報を使ってラベルのついていない英文を見ただけで意味がわかるようになることを期待します。

- 目標は、単語のベクトル空間表現を学習することです。

事前学習タスク：いくつかの単語をマスクして、隣り合う単語を使って空白を埋めます。

<!-- <center>
<img src="{{site.baseurl}}/images/week12/12-2/word2vec-masking.gif" width="60%"/><br>
<b>Fig. 7</b>: word2vec masking visual
</center> -->
<center>
<img src="{{site.baseurl}}/images/week12/12-2/word2vec-masking.gif" width="60%"/><br>
<b>図7</b>: word2vec マスキングの可視化
</center>

<!-- For instance, here, the idea is that "horned" and "silver-haired" are more likely to appear in the context of "unicorn" than some other animal.

Take the words and apply a linear projection -->

例えば、「角がある」「銀髪」は、他の何かの動物よりも「ユニコーン」という文脈で出てくる可能性が高いという考え方です。

単語に、線形射影を適用します。

<!-- <center>
<img src="{{site.baseurl}}/images/week12/12-2/word2vec-embeddings.png" width="60%"/><br>
<b>Fig. 8</b>:  word2vec embeddings
</center> -->

<center>
<img src="{{site.baseurl}}/images/week12/12-2/word2vec-embeddings.png" width="60%"/><br>
<b>図8</b>:  word2vec 埋め込み
</center>

<!-- Want to know -->
知りたいもの

$$
p(\texttt{unicorn} \mid \texttt{These silver-haired ??? were previously unknown})
$$

$$
p(x_n \mid x_{-n}) = \text{softmax}(\text{E}f(x_{-n})))
$$

<!-- Word embeddings hold some structure -->
単語埋め込みはなんらかの構造を持っています。

<!-- <center>
<img src="{{site.baseurl}}/images/week12/12-2/embeddings-structure.png" width="60%"/><br>
<b>Fig. 9</b>: Embedding structure example
</center> -->
<center>
<img src="{{site.baseurl}}/images/week12/12-2/embeddings-structure.png" width="60%"/><br>
<b>Fig. 9</b>: 埋め込み構造の例
</center>

<!-- - The idea is if we take the embedding for "king" after training and add the embedding for "female" we will get an embedding very close to that of "queen"
- Shows some meaningful differences between vectors -->
- 学習後に、「王様」の埋め込みに「女性」の埋め込みを加えれば、「女王様」の埋め込みに非常に近い埋め込みが得られるという考えかたです。
- これはベクトル間の意味のある違いを示しています。


<!-- #### Question: Are the word representation dependent or independent of context?

Independent and have no idea how they relate to other words -->

#### 質問：単語の表現は文脈に依存しているのですか、独立しているのですか？

独立していて、他の単語とどのように関係しているかはわかりません。


<!-- 
#### Question: What would be an example of a situation that this model would struggle in?

Interpretation of words depends strongly on context. So in the instance of ambiguous words - words that may have multiple meanings - the model will struggle since the embeddings vectors won't capture the context needed to correctly understand the word. -->

#### 質問：このモデルが苦戦するであろう状況の例は何でしょうか？

言葉の解釈は文脈に強く依存します。したがって、曖昧な単語や複数の意味を持つかもしれない単語の例では、埋め込みベクトルがその単語を正しく理解するのに必要な文脈を捉えられないので、モデルは苦戦するでしょう。


### GPT

<!-- To add context, we can train a conditional language model. Then given this language model, which predicts a word at every time step, replace each output of model with some other feature.

- Pretraining - predict next word
- Fine-tuning - change to a specific task. Examples:
  - Predict whether noun or adjective
  - Given some text comprising an Amazon review, predict the sentiment score for the review

This approach is good because we can reuse the model. We pretrain one large model and can fine tune to other tasks. -->

文脈を追加するために、条件付き言語モデルを訓練することができます。そして、各時間ステップで単語を予測するこの言語モデルが与えられ、モデルの各出力を他の特徴量に置き換えます。

- 事前学習：次の単語を予測する
- fine-tuning：特定のタスクに合わせて学習済みモデルを調整します。

  例：
  - 名詞か形容詞かを予測する
  - いくつかのアマゾンのレビュー、レビューの感情スコアを予測する

このアプローチは、モデルを再利用できる点で優れています。1つの大きなモデルを事前に学習しておき、他のタスクに合わせて微調整することができます。


<!-- ### ELMo

GPT only considers leftward context, which means the model can't depend on any future words - this limits what the model can do quite a lot.

Here the approach is to train _two_ language models

- One on the text left to right
- One on the text right to left
- Concatenate the output of the two models in order to get the word representation. Now can condition on both the rightward and leftward context. -->

<!-- This is still a "shallow" combination, and we want some more complex interaction between the left and right context. -->

### ELMo

GPTは左方向の文脈しか考慮しないので、モデルは将来の単語に依存することができません。これはモデルができることをかなり制限します。

ここでは、2つの言語モデルを学習します。

- テキストの左から右に1つのモデルを用意します。
- テキストの右から左に1つのモデルを用意します。
- 単語表現を得るために、2つのモデルの出力を連結します。これで、右方向と左方向の文脈の両方に条件をつけることができるようになりました。

これはまだ 「浅い」組み合わせでなので、左右の文脈の間にもう少し複雑な相互作用が欲しいところです。


<!-- ### BERT

BERT is similar to word2vec in the sense that we also have a fill-in-a-blank task. However, in word2vec we had linear projections, while in BERT there is a large transformer that is able to look at more context. To train, we mask 15% of the tokens and try to predict the blank.

Can scale up BERT (RoBERTa):

- Simplify BERT pre-training objective
- Scale up the batch size
- Train on large amounts of GPUs
- Train on even more text

Even larger improvements on top of BERT performance - on question answering task performance is superhuman now. -->


## BERT

BERT は、文書穴埋めタスクもあるという意味で word2vec に似ています。しかし、word2vecでは線形射影を行っていましたが、BERTでは、より多くの文脈を見ることができる大規模なtransformerがあります。訓練のために、トークンの15%をマスクし、空白を予測しようとします。

BERT（RoBERTa）をスケールアップすることができます。

- BERTの事前学習のための目的関数の単純化
- バッチサイズのスケールアップ
- 大量のGPUでの学習
- さらに多くのテキストで学習

BERTのパフォーマンスのさらに大きな改善：質問応答タスクのパフォーマンスは、今では人間を超えています。


<!-- ## [Pre-training for NLP](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=4963s) -->
## [NLPのための事前学習](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=4963s)
<!-- 
Let us take a quick look at different self-supervised pre training approaches that have been researched for NLP.

- XLNet:

  Instead of predicting all the masked tokens conditionally independently, XLNet predicts masked tokens auto-regressively in random order

- SpanBERT

   Mask spans (sequence of consecutive words) instead of tokens

- ELECTRA:

  Rather than masking words we substitute tokens with similar ones.  Then we solve a binary classification problem by trying to predict whether the tokens have been substituted or not.

- ALBERT:

  A Lite Bert: We modify BERT and make it lighter by tying the weights across layers. This reduces the parameters of the model and the computations involved. Interestingly, the authors of ALBERT did not have to compromise much on accuracy.

- XLM:

  Multilingual BERT: Instead of feeding such English text, we feed in text from multiple languages. As expected, it learned cross lingual connections better.

The key takeaways from the different models mentioned above are

- Lot of different pre-training objectives work well!

- Crucial to model deep, bidirectional interactions between words

- Large gains from scaling up pre-training, with no clear limits yet


Most of the models discussed above are engineered towards solving the text classification problem. However, in order to solve text generation problem, where we generate output sequentially much like the `seq2seq` model, we need a slightly different approach to pre training. -->

NLPのために研究されてきた様々な自己教師あり事前学習アプローチを簡単に見てみましょう。

- XLNet：

  XLNetは、すべてのマスクされたトークンを条件付き独立に予測するのではなく、ランダムな順序で自己回帰的に予測します。

- SpanBERT：

   トークンの代わりにマスクスパンを用います。

- ELECTRA：

  単語をマスキングするのではなく、トークンを類似したもので置換します。 そして、そのトークンが置換されたかどうかを予測する二値分類問題を解きます。

- ALBERT：

  A Lite Bertの略です。BERTを修正し、レイヤー間で重みを共有することで軽量化する。これにより、モデルのパラメータとそれに伴う計算が削減されます。興味深いことに、これらの軽量化にも関わらずALBERTの精度はそこまで低下することはありませんでした。

- XLM：

  多言語BERT：英語のテキストを与える代わりに、複数の言語からのテキストを与えます。予想通り、言語間のつながりをより良く学習しました。

上記の様々なモデルから得られた主なポイントは以下の通りです。

- 多くの異なる事前学習の目的関数が効果的に働く

- 単語間の深い双方向の相互作用をモデル化することが重要

- まだ明確な限界がない事前学習のスケールアップからの大きな利益

上で議論したモデルのほとんどは、テキストの分類問題を解決するために設計されています。しかし、`seq2seq`モデルのように逐次的に出力を生成するテキスト生成問題を解決するためには、事前学習に少し異なるアプローチが必要です。



<!-- #### Pre-training for Conditional Generation: BART and T5

BART: pre-training `seq2seq` models by de-noising text

In BART, for pretraining we take a sentence and corrupt it by masking tokens randomly. Instead of predicting the masking tokens (like in the BERT objective), we feed the entire corrupted sequence and try to predict the entire correct sequence.

This `seq2seq` pretraining approach give us flexibility in designing our corruption schemes. We can shuffle the sentences, remove phrases, introduce new phrases, etc.

BART was able to match RoBERTa on SQUAD and GLUE tasks. However, it was the new SOTA on summarization, dialogue and abstractive QA datasets. These results reinforce our motivation for BART, being better at text generation tasks than BERT/RoBERTa. -->


#### 条件付き生成のための事前学習：BARTとT5

BART：テキストのノイズ除去による `seq2seq` モデルの事前学習

BARTでは、事前学習のために、文を受け取り、ランダムにマスキングトークンによってそれを破損させます。BERTの目的関数のようにマスキングトークンを予測するのではなく、破損した文全体を与え、正しい文全体を予測させます。

この `seq2seq` 事前学習アプローチは、破損のさせ方の設計に柔軟性を与えてくれます。文章をシャッフルしたり、フレーズを削除したり、新しいフレーズを導入したりすることができます。

BARTはSQUADタスクとGLUEタスクでRoBERTaに匹敵する性能を示しました。しかし、要約、対話、抽象的なQAデータセット上では新しいSOTAを叩き出しました。これらの結果は、BARTがBERT/RoBERTaよりもテキスト生成タスクで優れていることを示しており、BARTを用いる理由となります。


<!-- ### Some open questions in NLP

- How should we integrate world knowledge
- How do we model long documents?  (BERT-based models typically use 512 tokens)
- How do we best do multi-task learning?
- Can we fine-tune with less data?
- Are these models really understanding language? -->

### NLPにおけるいくつかの未解決問題

- 世界の知識をどのように統合すべきか？
- 長い文書をどのようにモデル化するか？ (BERT ベースのモデルは通常 512 トークンを使用します)
- マルチタスク学習の最善の方法は何か？
- 少ないデータでfine-tuningできるのか？
- これらのモデルは本当に言語を理解しているのか？


<!-- ### Summary
- Training models on lots of data beats explicitly modelling linguistic structure.

From a bias variance perspective, Transformers are low bias (very expressive) models. Feeding these models lots of text is better than explicitly modelling linguistic structure (high bias). Architectures should be compressing sequences through bottlenecks

- Models can learn a lot about language by predicting words in unlabelled text. This turns out to be a great unsupervised learning objective. Fine tuning for specific tasks is then easy

- Bidirectional context is crucial -->

### まとめ

- 多くのデータでモデルを訓練することは、言語構造を明示的にモデル化することに勝ります。

バイアスバリアンスの観点から見ると、トランスフォーマーはバイアスの低い（非常に表現力の高い）モデルです。これらのモデルに多くのテキストを与えることは、明示的に言語構造をモデル化するよりも優れています（高バイアス）。アーキテクチャはボトルネックを介してシーケンスを圧縮する必要があります。

- モデルはラベルの付いていないテキストの単語を予測することで、言語について多くのことを学ぶことができます。これは、教師なし学習の優れた目的関数であることがわかります。特定のタスクのためのfine-tuningも簡単です。

- 双方向のコンテキストが重要です。


<!-- ### Additional Insights from questions after class:

What are some ways to quantify 'understanding language’? How do we know that these models are really understanding language?

"The trophy did not fit into the suitcase because it was too big”: Resolving the reference of ‘it’ in this sentence is tricky for machines. Humans are good at this task. There is a dataset consisting of such difficult examples and humans achieved 95% performance on that dataset. Computer programs were able to achieve only around 60% before the revolution brought about by Transformers. The modern Transformer models are able to achieve more than 90% on that dataset. This suggests that these models are not just memorizing / exploiting the data but learning concepts and objects through the statistical patterns in the data.

Moreover, BERT and RoBERTa achieve superhuman performance on SQUAD and Glue. The textual summaries generated by BART look very real to humans (high BLEU scores). These facts are evidence that the models do understand language in some way. -->

### 授業後の質問からの追加の気づき

「言語を理解する」ことを数値化する方法にはどのようなものがあるのでしょうか？これらのモデルが本当に言語を理解していることをどのようにして知ることができるのでしょうか？

「The trophy did not fit into the suitcase because it was too big」という文章を考えます。
この文では、「it」の参照を解決するのは難しいです。この文の「it」の参照を解決するのは、機械にとっては難しいことです。人間はこの作業が得意です。このような難しい例で構成されたデータセットがあり、人間はそのデータセットで95%のパフォーマンスを達成しました。Transformerがもたらした革命の前は、コンピュータプログラムは60%程度の性能しか達成できませんでした。現代のtransformerのモデルは、そのデータセットで90％以上の性能を達成することができます。このことは、これらのモデルが単にデータを記憶／活用するのではなく、データの統計的パターンを通して概念や対象を学習していることを示唆しています。

さらに、BERTとRoBERTaは、SQUADとGlueで超人的な性能を達成しています。BARTによって生成された文書要約は、人間には非常にリアルに見えます（BLEUスコアが高い）。これらの事実は、モデルが何らかの形で言語を理解している証拠です。

<!-- #### Grounded Language

Interestingly, the lecturer (Mike Lewis, Research Scientist, FAIR) is working on a concept called ‘Grounded Language’. The aim of that field of research is to build conversational agents that are able to chit-chat or negotiate. Chit-chatting and negotiating are abstract tasks with unclear objectives as compared to text classification or text summarization. -->

#### Grounded Language

興味深いことに、講師のMike Lewis氏（FAIRの研究員）は「Grounded Language」という概念を研究しています。その研究分野は、雑談や交渉ができる会話エージェントを作ることを目的としています。雑談やネゴシエーションは、テキストの分類や要約に比べて、目的が不明確な抽象的な作業です。


<!-- #### Can we evaluate whether the model already has world knowledge?

‘World Knowledge’ is an abstract concept. We can test models, at the very basic level, for their world knowledge by asking them simple questions about the concepts we are interested in.  Models like BERT, RoBERTa and T5 have billions of parameters. Considering these models are trained on a huge corpus of informational text like Wikipedia, they would have memorized facts using their parameters and would be able to answer our questions. Additionally, we can also think of conducting the same knowledge test before and after fine-tuning a model on some task. This would give us a sense of how much information the model has ‘forgotten’. -->

#### モデルがすでに世界の知識を持っているかどうかを評価することはできるのでしょうか？

世界の知識は抽象的な概念です。我々は、非常に基本的なレベルで、我々が興味を持っている概念について簡単な質問をすることによって、モデルが世界の知識を持っているかどうかをテストすることができます。 BERT、RoBERTa、T5のようなモデルは、何十億ものパラメータを持っています。これらのモデルはウィキペディアのような膨大な情報テキストのコーパスで訓練されていることを考えると、パラメータを使って事実を記憶しており、我々の質問に答えることができるでしょう。さらに、あるタスクでモデルをfine-tuningする前と後に同じ知識テストを行うことも考えられます。これは、モデルがどれだけの情報を「忘れてしまった」かの感覚を与えてくれるでしょう。
