---
lang-ref: ch.12-1
title: Deep Learning for NLP
lecturer: Mike Lewis
authors: Jiayu Qiu, Yuhong Zhu, Lyuang Fu, Ian Leefmans
date: 20 Apr 2020
lang: ja
translation-date: 6 Dec 2020
translator: Shiro Takagi
---


<!-- ## [Overview](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=44s) -->
## [概要](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=44s)

<!-- * Amazing progress in recent years:
  - Humans prefer machine translation to human translators for some languages
  - Super-human performance on many question answering datasets
  - Language models generate fluent paragraphs (e.g Radford et al. 2019)
*  Minimal specialist techniques needed per task, can achieve these things with fairly generic models -->

* 自然言語モデルの、近年の驚くべき進歩
  - 一部の言語では、人間の翻訳者よりも機械翻訳が好まれるようになっています。
  - 多くの質問応答タスクのデータセットで、超人的なパフォーマンスを発揮しています。
  - 言語モデルは人間が書いたような自然な段落を生成することができます。（例：Radford et al.）
* タスクごとに必要とされる専門技術は最小限で、かなり汎用的なモデルでこれらのことを達成することができます。


<!-- ## Language Models -->
## 言語モデル
<!-- 
* Language models assign a probability to a text:
  $p(x_0, \cdots, x_n)$
* Many possible sentences so we can’t just train a classifier
* Most popular method is to factorize distribution using chain rule:

$$p(x_0,...x_n) = p(x_0)p(x_1 \mid x_0) \cdots p(x_n \mid x_{n-1})$$ -->

* 言語モデルは、テキストに確率を割り当てます：
  $p(x_0, \cdots, x_n)$
* 候補となりうる文が多いので、分類器の訓練はできません
* 最もポピュラーな方法は、連鎖律を用いて分布を分解する方法です。

$$p(x_0,...x_n) = p(x_0)p(x_1 \mid x_0) \cdots p(x_n \mid x_{n-1})$$


<!-- ## Neural Language Models -->
## ニューラル言語モデル

<!-- Basically we input the text into a neural network, the neural network will map all this context onto a vector. This vector represents the next word and we have some big word embedding matrix. The word embedding matrix contains a vector for every possible word the model can output. We then compute similarity by dot product of the context vector and each of the word vectors. We'll get a likelihood of predicting the next word, then train this model by maximum likelihood. The key detail here is that we don't deal with words directly, but we deal with things called sub-words or characters. -->
基本的には、ニューラルネットワークにテキストを入力すると、ニューラルネットワークはすべてのコンテキストをベクトルに写像します。このベクトルは次の単語を表現し、これによって大きな単語埋め込み行列を得ます。単語埋め込み行列には、モデルが出力する可能性のあるすべての単語のベクトルが含まれています。そして、文脈ベクトルと各単語ベクトルのドット積によって類似度を計算します。次の単語を予測する尤度を得て、最尤推定によってこのモデルを訓練します。ここで重要なのは、単語を直接扱うのではなく、部分語と呼ばれるものや文字を扱うということです。

$$p(x_0 \mid x_{0, \cdots, n-1}) = \text{softmax}(E f(x_{0, \cdots, n-1}))$$

<!-- <figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig1.jpg">
  <center>  Fig.1: Neural language model</center>
</figure> -->
<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig1.jpg">
  <center>  図1: ニューラル言語モデル</center>
</figure>


<!-- ### Convolutional Language Models -->
### 畳み込み言語モデル

<!-- * The first neural language model
* Embed each word as a vector, which is a lookup table to the embedding matrix, so the word will get the same vector no matter what context it appears in
* Apply same feed forward network at each time step
* Unfortunately, fixed length history means it can only condition on bounded context
* These models do have the upside of being very fast -->

* 最初のニューラル言語モデルです。
* 各単語をベクトルとして埋め込みます。これは埋め込み行列のルックアップテーブルです。したがって、どのような文脈で出てきても同じベクトルを得ることになります。
* 各タイムステップで同じフィードフォワードネットワークを適用します。
* 残念ながら、固定長の系列しか扱えないということは、制限された文脈でしか条件付けられないことを意味します。
* これらのモデルは、非常に高速であるという利点があります。

<!-- <figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig2.jpg">
  <center>  Fig.2: Convolutional language model</center>
</figure> -->
<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig2.jpg">
  <center>  図2: 畳み込み言語モデル</center>
</figure>


<!-- ### Recurrent Language Models -->
### 再帰的言語モデル

<!-- * The most popular approach until a couple years ago.
* Conceptually straightforward: every time step we maintain some state (received from the previous time step, which represents what we've read so far. This is combined with current word being read and used at later state. Then we repeat this process for as many time steps as we need.
* Uses unbounded context: in principle the title of a book would affect the hidden states of last word of the book.
* Disadvantages:
  - The whole history of the document reading is compressed into fixed-size vector at each time step, which is the bottleneck of this model
  - Gradients tend to vanish with long contexts
  - Not possible to parallelize over time-steps, so slow training -->

* 数年前までは最もポピュラーなアプローチでした。
* 概念的には簡単です。各時間ステップで、ある状態を持ちます。これは、現在の単語が読まれ、後の状態で使用されているものと組み合わされます（昔の時間ステップからの入力を受け取りますが、これはこれまで読んだ内容を表現しています）。そして、必要な数だけこのプロセスを繰り返します。
* 制限のない文脈を用いる：原理的には、本のタイトルは、本の最後の単語の隠れ状態に影響を与えます。
* 欠点：
  - 読み取った文書の全履歴は、各タイムステップで固定サイズのベクトルに圧縮されていますが、これはこのモデルのボトルネックとなっています。
  - 長いコンテキストでは、勾配消失が生じる傾向があります。
  - 時間ステップ間で並列化できないので、訓練が遅くなります。

<!-- <figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig3.jpg">
  <center>  Fig.3: Recurrent language model</center>
</figure> -->
<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig3.jpg">
  <center>  図3: 再帰的言語モデル</center>
</figure>


<!-- ### [Transformer Language Models](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=828s) -->
### [Transformer言語モデル](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=828s)

<!-- * Most recent model used in NLP
* Revolutionized penalty
* Three main stages
    * Input stage
    * $n$ times transformer blocks (encoding layers) with different parameters
    * Output stage
* Example with 6 transformer modules (encoding layers) in the original transformer paper: -->

* NLPで使用されている最新のモデル
* 革命的なペナルティ
* 3つの主要段階
    * 入力段階
    * $n$ 個の異なるパラメータを持つtransformerブロック（エンコーディング層）の繰り返し
    * 出力段階
* Transformerの原論文で用いられた、transformerモジュール（エンコード層）を6個積んだ例

<!-- <figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig4.jpg">
  <center>  Fig.4:Transformer language model </center>
</figure> -->
<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig4.jpg">
  <center>  図4:Transformer言語モデル </center>
</figure>

<!-- Sub-layers are connected by the boxes labelled "Add&Norm". The "Add" part means it is a residual connection, which helps in stopping the gradient from vanishing. The norm here denotes layer normalization. -->
サブレイヤーは 「Add&Norm」と書かれたボックスで接続されています。「Add」の部分はresidual connectionを意味し、勾配消失を防ぐのに役立ちます。ここでの「norm」はlayer normalizationを表しています。

<!-- <figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig5.jpg">
  <center>  Fig.5: Encoder Layer </center>
</figure> -->
<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig5.jpg">
  <center>  図5: エンコーダー層 </center>
</figure>

<!-- It should be noted that transformers share weights across time-steps. -->
Transformerは、時間ステップ間で重みを共有することに注意してください。


<!-- # Multi-headed attention -->
# Multi-headed attention

<!-- <figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig6.png">
<center>  Fig.6: Multi-headed Attention </center>
</figure> -->
<figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig6.png">
<center>  図6: Multi-headed Attention </center>
</figure>

<!-- For the words we are trying to predict, we compute values called **query(q)**. For all the previous words use to predict we call them **keys(k)**. Query is something that tells about the context, such as previous adjectives. Key is like a label containing information about the current word such as whether it's an adjective or not. Once q is computed, we can derive the distribution of previous words ($p_i$): -->

我々が予測しようとしている単語については、**クエリ(q)** と呼ばれる値を計算します。予測に用いる、予測する単語の前にある全ての単語については、**キー(k)** と呼ばれる値を計算します。クエリは、「予測する単語の前の形容詞」といったような文脈を伝えるものです。キーは、「現在の単語が形容詞であるかどうか」などの情報を含むラベルのようなものです。qが計算されると、前の単語の分布($p_i$)を導出することができます。

$$p_i = \text{softmax}(q,k_i)$$

<!-- Then we also compute quantities called **values(v)** for the previous words. Values represent the content of the words.

Once we have the values, we compute the hidden states by maximizing the attention distribution: -->

次に、前の単語について **バリュー(v)** と呼ばれる量も計算します。バリューは単語の内容を表します。

バリューが得られたら，attention分布を最大化することで隠れ状態を計算します。

 $$h_i = \sum_{i}{p_i v_i}$$

<!-- We compute the same thing with different queries, values, and keys multiple times in parallel. The reason for this is that we want to predict the next word using different things. For example, when we predict the word "unicorns" using three previous words "These" "horned" and "silver-white". We know it is a unicorn by "horned" "silver-white". However, we can know it is plural "unicorns" by "These". Therefore, we probably want to use all these three words to know what the next word should be. Multi-headed attention is a way of letting each word look at multiple previous words. -->
同じものを異なるクエリ、バリュー、キーで複数回並列に計算します。これは、異なるものを使って次の単語を予測したいからです。例えば、前の3つの単語「These」「horned」「silver-white」を使って「unicorns」という単語を予測する場合を考えます。私たちは、「horned」と「silver-white」によって、それがユニコーンであることがわかります。しかし、「These」によって複数のユニコーン、つまり、「unicorns」であることがわかります。したがって、次の単語が何であるかを知るために、この3つの単語をすべて使いたいと考えるでしょう。Multi-headed attentionは、それぞれの単語に、その単語の以前の複数の単語を見させる方法です。

<!-- One big advantage about the multi-headed attention is that it is very parallelisable. Unlike RNNs, it computes all heads of the multi-head attention modules and all the time-steps at once. One problem of computing all time-steps at once is that it could look at futures words too, while we only want to condition on previous words. One solution to that is what is called **self-attention masking**. The mask is an upper triangular matrix that have zeros in the lower triangle and negative infinity in the upper triangle. The effect of adding this mask to the output of the attention module is that every word  to the left has a much higher attention score than words to the right, so the model in practice only focuses on previous words. The application of the mask is crucial in language model because it makes it mathematically correct, however, in text encoders, bidirectional context can be helpful. -->
Multi-headed attentionの大きな利点は、かなりの並列処理が可能であることです。RNNとは異なり、Multi-headed attentionでは、Multi-headed attentionモジュールのすべてのヘッドとすべての時間ステップを一度に計算します。すべての時間ステップを一度に計算することの問題点は、我々が前の単語だけを条件としたいのに対し、未来の単語も見てしまうことです。これを解決する一つの方法として、**self-attentionマスキング**と呼ばれるものがあります。このマスクは、下の三角形にゼロを、上の三角形に負の無限大を持つ上三角行列です。注意モジュールの出力にこのマスクを追加する効果として、左のすべての単語は右の単語よりもはるかに高い注意スコアを持っているので、実際にはモデルは前の単語だけに焦点を当てることができます。マスクの適用は言語モデルを数学的に正しくするために重要ですが、テキストエンコーダーでは双方向のコンテキストが役立ちます。

<!-- One detail to make the transformer language model work is to add the positional embedding to the input. In language, some properties like the order are important to interpret. The technique used here is learning separate embeddings at different time-steps and adding these to the input, so the input now is the summation of word vector and the positional vector. This gives the order information. -->
トランスフォーマー言語モデルを機能させるための一つの細かいテクニックは、入力にpositional embeddingを追加することです。順序のようないくつかの特徴は言語を解釈する上で重要です。ここで使用されている技術は、異なる時間ステップで別々の埋め込みを学習し、それらを入力に追加することです。これが順番の情報を与えます。

<!-- <figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig7.png">
<center>  Fig.7: Transformer Architecture </center>
</figure> -->
<figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig7.png">
<center>  図7: Transformerのアーキテクチャ </center>
</figure>

<!-- **Why the model is so good:**

1. It gives direct connections between each pair of words. Each word can directly access the hidden states of the previous words, mitigating vanishing gradients. It learns very expensive function very easily
2. All time-steps are computed in parallel
3. Self-attention is quadratic (all time-steps can attend to all others), limiting maximum sequence length -->

**このモデルが優れている理由:**

1. このモデルは、各単語のペア同士を直接的につなげます。各単語は前の単語の隠れ状態に直接アクセスでき、勾配消失を緩和します。それは非常に難しい関数を非常に簡単に学習します。
2. すべての時間ステップは並列に計算されます。
3. self-attentionの計算量は二乗オーダーです（すべての時間ステップは他のすべての時間ステップに注意を向けることができる）ので、最大シーケンスの長さが制限されます。


<!-- ## [Some tricks (especially for multi-head attention and positional encoding) and decoding Language Models](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=1975s) -->
## [いくつかのコツ (特に multi-head attention と positional encodingについて) と デコーディング言語モデル](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=1975s)


<!-- ### Trick 1: Extensive use of layer normalization to stabilize training is really helpful -->
### コツ1: Layer normalizationを多用した訓練の安定化（これは本当に役に立ちます）


<!-- - Really important for transformers -->
- Transformerにとってはとても大事なことです


<!-- ### Trick 2: Warm-up + Inverse-square root training schedule -->
### コツ2：Warm-upとルート分の１の訓練スケジューリング

<!-- - Make use of learning rate schedule: in order to make the transformers work well, you have to make your learning rate decay linearly from zero to thousandth steps. -->
- 学習率スケジューリングを利用する：transformerをうまく動作させるためには、学習率をゼロから数千ステップまで線形に減衰させる必要があります。



<!-- ### Trick 3: Careful initialization -->
### コツ3：慎重な初期化

<!-- - Really helpful for a task like machine translation -->
- 機械翻訳のようなタスクに本当に役立ちます。


<!-- ### Trick 4: Label smoothing -->
### コツ4：ラベルの平滑化

<!-- - Really helpful for a task like machine translation -->
- これも機械翻訳のようなタスクに本当に役立ちます。

<!-- The following are the results from some methods mentioned above. In these tests, the metric on the right called `ppl` was perplexity (the lower the `ppl` the better). -->
上述したいくつかの方法で行った結果を以下に示します。これらのテストでは、右の `ppl` と呼ばれている指標は perplexity です（`ppl` が低いほど良い）。

<!-- <figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig8.png">
<center>  Fig.8: Model Performance Comparison </center>
</figure> -->
<figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig8.png">
<center>  図8: モデル性能の比較 </center>
</figure>

<!-- You could see that when transformers were introduced, the performance was greatly improved. -->
Transformerが導入されると、性能が大幅に向上していることがわかります。


<!-- ## Some important facts of Transformer Language Models -->
## Transformer言語モデルについてのいくつかの重要な事実

 <!-- - Minimal inductive bias
 - All words directly connected, which will mitigate vanishing gradients.
 - All time-steps computed in parallel. -->
 - 帰納的バイアスが最小限です。
 - すべての単語が直接接続されているため、勾配消失が緩和されます。
 - すべての時間ステップは並列に計算されます。


<!-- Self attention is quadratic (all time-steps can attend to all others), limiting maximum sequence length. -->
Self-attentionの計算量は二乗オーダーである（すべての時間ステップは他のすべての時間ステップに注意を払うことができる）ため、最大シーケンス長が制限されます。


<!-- - As self attention is quadratic, its expense grows linearly in practice, which could cause a problem. -->
- Self-attentionの計算量は二乗オーダーなので、そのコストは実際には線形に増加してしまい、問題を引き起こす可能性があります。

<!-- <figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig9.png">
<center>  Fig.9: Transformers vs. RNNs </center>
</figure> -->
<figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig9.png">
<center>  図9: Transformers vs RNN </center>
</figure>


<!-- ### Transformers scale up very well -->
### Transformersはとてもよくスケールする

<!-- 1. Unlimited training data, even far more than you need
2. GPT 2 used 2 billion parameters in 2019
3. Recent models use up to 17B parameters and in 2020 -->
1. 必要とするより遥に膨大な無制限の訓練データを使います。
2. GPT 2は2019年に20億個のパラメータを使用しました。
3. 2020年の最近のモデルでは17Bまでのパラメータを使用しました。
<!-- TODO: typo -->


<!-- ## Decoding Language Models

We can now train a probability distribution over text - now essentially we could get exponentially many possible outputs, so we can’t compute the maximum. Whatever choice you make for your first word could affect all the other decisions.
Thus, given that, the greedy decoding was introduced as follows. -->

## デコーディング言語モデル

テキストに対する確率分布を学習することができます。本質的には指数関数的に多くの可能性のある出力を得ることができるので、最大値を計算することはできません。最初の単語にどのような選択をしても、他のすべての決定に影響を与える可能性があります。
これを受けて、以下のような貪欲デコーディングが導入されました。


<!-- ### Greedy Decoding does not work

We take most likely word at each time step. However, no guarantee this gives most likely sequence because if you have to make that step at some point, then you get no way of back-tracking your search to undo any previous sessions. -->

### 貪欲なデコーディングはうまくいかない

私たちは、各時間ステップで最も可能性の高い単語を選びます。しかし、この方法で最も可能性の高い単語の順番がわかるという保証はありません。なぜなら，もしある点でそのようなステップを選択しなければならないときに，以前のセッションをやり直すことができないからです。


<!-- ### Exhaustive search also not possible

It requires computing all possible sequences and because of the complexity of $O(V^T)$, it will be too expensive -->

### 網羅的な検索はできない

これは、すべての可能なシーケンスを計算する必要があり、$O(V^T)$の計算量がかかるため、あまりにも計算コストが高くなります。

<!-- 
## Comprehension Questions and Answers

1. What is the benefit of multi-headed attention as opposed to a single-headed attention model?

    * To predict the next word you need to observe multiple separate things, in other words attention can be placed on multiple previous words in trying to understand the context necessary to predict the next word.

2. How do transformers solve the informational bottlenecks of CNNs and RNNs?

    * Attention models allow for direct connection between all words allowing for each word to be conditioned on all previous words, effectively removing this bottleneck.

3. How do transformers differ from RNNs in the way they exploit GPU parallelization?

    * The multi-headed attention modules in transformers are highly parallelisable whereas RNNs are not and therefore cannot take advantage of GPU technology. In fact transformers compute all time steps at once in single forward pass. -->


## 質問と解答

1. Single-headのattentionモデルと比べたときの、multi-headのattentionモデルの利点は何ですか?

    * 次の単語を予測するためには、複数の別々のものを観察する必要があります。Multi-headのattentionモデルは、次の単語を予測するために必要な文脈を理解するために、複数の前の単語に注意を向けることができます。

2. TransformerはCNNやRNNのinformational bottlenecksをどのように解決するのですか？

    * Attentionモデルはすべての単語間の直接的な接続を可能にし、各単語は前のすべての単語に条件付けされるので、このボトルネックを効果的に解決することができます。

3. TransformerはGPUによる並列化を利用する点でRNNとどのように違うのでしょうか？

    * Transformerのmulti-head attentionモジュールは高度な並列化が可能であるのに対し、RNNはそうではないため、GPU技術を利用することができません。実際、Transformerは単一の順伝播ですべての時間ステップを一度に計算します。
