---
lang-ref: ch.11-3
title: Prediction and Policy learning Under Uncertainty (PPUU)
lecturer: Alfredo Canziani
authors: Anuj Menta, Dipika Rajesh, Vikas Patidar, Mohith Damarapati
date: 14 April 2020
lang: ja
translation-date: 6 Dec 2020
translator: Shiro Takagi
---

<!-- ## [Introduction and problem setup](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=63s) -->
## [導入と問題設定](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=63s)

<!-- Let us say we want to learn how to drive in a model-free Reinforcement learning way. We train models in RL by letting the model make mistakes and learn from them. But this is not the best way since mistakes might take us to heaven/hell where there is no point in learning.

So, let us talk about a more 'human' way to learn how to drive a car. Consider an example of lane switching. Assuming the car is moving at 100 km/h, which roughly translates to 30 m/s, if we look 30 m in front of us, we are roughly looking 1 s into the future. -->

モデルフリー強化学習で運転の仕方を学びたいとしましょう。RLでは、モデルにミスをさせてそこから学習させることでモデルを訓練します。しかし、これは最善の方法ではありません。

そこで、もっと「人間的」な方法で車の運転を学ぶ方法を考えてみましょう。車線変更の例を考えてみましょう。車が時速100km
、つまり大体30m/sの速度で動いていると仮定すると、30m先を見た場合、大体1s先を見ていることになります。

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure1.png" style="zoom: 20%; background-color:#DCDCDC;" /><br>
<b>Figure 1:</b> Looking into future while driving
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure1.png" style="zoom: 20%; background-color:#DCDCDC;" /><br>
<b>図1:</b> 少し先を予測して運転をする
</center>

<!-- If we were turning, we need to make a decision based on the near future. To take a turn in a few meters, we take an action now, which in this context is turning the steering wheel. Making a decision not only depends on your driving but also the surrounding vehicles in the traffic. Since everyone around us is not so deterministic, it is very hard to take every possibility into account.

Let us now break down what is happening in this scenario. We have an agent(represented here by a brain) that takes the input $s_t$ (position, velocity and context images) and produces an action $a_t$(steering control, acceleration and braking).  The environment takes us to a new state and returns a cost $c_t$. -->

カーブを切る時には、近い将来のことを考えて判断する必要があります。数メートル先で曲がるためには、今すぐに行動を起こす、ここではハンドルを切る、ことになります。決断をするかどうかは、自分の運転だけでなく、交通の中の周囲の車にも左右されます。私たちの周りの誰もが決定論的ではないので、すべての可能性を考慮に入れることは非常に困難です。

このシナリオで何が起こっているかを分解してみましょう。我々は、入力$s_t$(位置、速度、文脈画像)を受け取り、アクション$a_t$(操舵制御、加速、制動)を生成するエージェント(ここでは頭脳で表現)を持っています。 環境は私たちを新しい状態に連れて行き、コスト$c_t$を返します。

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure2.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<b>Figure 2:</b> Illustration of an agent in the real world
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure2.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<b>図2:</b> 実世界でのエージェントのイラスト
</center>

<!-- This is like a simple network where you take actions given a specific state and the world gives us the next state and the next consequence. This is model-free because with every action we are interacting with the real world. But can we train an agent without actually interacting with the real world?

Yes, we can! Let us find out in the "Learning world model" section. -->

これは、特定の状態の下で行動を取ると、世界が次の状態と次の結果を与えてくれる単純なネットワークのようなものです。これはモデルフリーで、すべての行動が現実世界と相互作用するからです。しかし、実際に現実世界と対話せずにエージェントを訓練することはできるのでしょうか？

はい、できます。「世界モデルを学習する」のセクションでそれを見てみましょう。

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure3.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<b>Figure 3:</b> Illustration of an agent in the world model
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure3.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<b>図3:</b> 実世界でのエージェントのイラスト
</center>


<!-- ## Data set -->
## データセット

<!-- Before discussing how to learn the world model, let us explore the dataset we have. We have 7 cameras mounted on top of a 30 story building facing the interstate. We adjust the cameras to get the top-down view and then extract bounding boxes for each vehicle. At a time $t$, we can determine $p_t$ representing the position, $v_t$
representing the velocity and $i_t$ representing the current traffic state around the vehicle.

Since we know the kinematics of the driving, we can invert them to figure out what are the actions that the driver is taking. For example, if the car is moving in a rectilinear uniform motion, we know that the acceleration is zero(meaning there is no action) -->

世界モデルの学習方法を説明する前に、我々が持っているデータセットを調べてみましょう。高速道路に面した30階建ての建物の上に7台のカメラを設置します。カメラを調整してトップダウンビューを取得し、各車両のバウンディングボックスを抽出します。ある時間$t$で、位置を表す$p_t$を求め、速度を表す$v_t$、車両周辺の現在の交通状態を表す$i_t$を求めます。

運転のキネマティクスがわかっているので、これらを逆算して、運転者が何をしているのかを知ることができます。例えば、車が直線的な一様運動をしている場合、加速度はゼロ（何もしていないことを意味する）であることがわかります。

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure4.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 4:</b> Machine representation of a single frame
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure4.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>図4:</b> 単一フレームの機械による表現
</center>

<!-- The illustration in blue is the feed and the illustration in green is what we can call the machine representation. To understand this better, we have isolated a few vehicles(marked in the illustration). The views we see below are the bounding boxes of the field-of-view of these vehicles. -->
青色のイラストはフィードで、緑色のイラストは我々が機械表現と呼ぶものです。これをよりよく理解するために、いくつかの車両を分離しました（図中のマーク）。下の図は、これらの車両の視野のバウンディングボックスです。


<!-- ## Cost -->
## コスト

<!-- There are two different types of costs here: lane cost and proximity cost. Lane cost tells us how well we are within a lane and proximity cost tells us how close we are to the other cars. -->
ここでは2種類のコストがあります：車線コストと近接コストです。車線コストは車線内の状態を示し、近接コストは他の車との距離を示します。

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure5.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 5:</b> Lane cost
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure5.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>図5:</b> 車線コスト
</center>

<!-- In the above figure, dotted lines represent actual lanes and red lines help us figure out the lane cost given the current position of our car.  Red lines move as our car moves. The height of the intersection of the red lines with the potential curve (in cyan) gives us the cost. If the car is in the centre of the lane, both the red lines overlap with the actual lanes resulting in zero cost. On the other hand, as the car moves away from the centre, the red lines also move to result in a non-zero cost. -->
上の図では、点線は実際の車線を表し、赤線は現在の車の位置から車線のコストを計算するのに役立ちます。 赤線は車の移動に合わせて移動します。赤い線と潜在的なカーブの交点の高さ（シアン色）がコストを示しています。車が車線の中心にいる場合は、赤線の両方が実際の車線と重なり、コストはゼロになります。一方、車が中心から離れると、赤線も移動し、コストはゼロではありません。
<!-- 
<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure6.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 6:</b> Proximity cost
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure6.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>図6:</b> 近接コスト
</center>

<!-- Proximity cost has two components ($\mathcal{L}_x$ and $\mathcal{L}_y$). $\mathcal{L}_y$ is similar to the lane cost and $\mathcal{L}_x$ depends on the speed of our car. The Orange curve in Figure 6 tells us about the safety distance. As the speed of the car increases, the orange curve widens. So faster the car is travelling, the more you will need to look ahead and behind. The height of the intersection of a car with the orange curve determines $\mathcal{L}_x$.

The product of these two components gives us the proximity cost. -->

近接コストには２つの要素があります（$\mathcal{L}_x$と$\mathcal{L}_y$）。この２つの成分は、車線コストと同様に、車の速度に依存します。図６のオレンジ色の曲線が安全距離を示しています。車の速度が速くなると、オレンジ色のカーブが広がります。つまり、車の速度が速くなればなるほど、前方と後方に目を向ける必要が出てくるということです。オレンジ色のカーブと車の交差するところの高さが $\mathcal{L}_x$ を決定します。

これら２つの成分の積が 近接コストを与えてくれます。


<!-- ## Learning world model -->
## 世界モデルを学習する

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure7.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<b>図7:</b> 世界モデルのイラスト
</center>

<!-- The world model is fed with an action $a_t$ (steering, brake, and acceleration) and $s_{1:t}$ (sequence of states where each state is represented by position, velocity and context images at that time) and it predicts the next state $\hat s_{t+1}$.  On the other hand, we have the real world which tells us what actually happened ($s_{t+1}$). We optimize MSE (Mean Squared Error) between prediction ($\hat s_{t+1}$) and target ($s_{t+1}$) to train our model. -->
世界モデルは、アクション$a_t$(操縦、ブレーキ、加速)と$s_{1:t}$(各状態をその時の位置、速度、文脈画像で表現した状態の列)を与えられ、次の状態$\hat s_{t+1}$を予測します。 一方、実世界を通して実際に何が起こったかを知ることができます($s_{t+1}$)。予測値($\hat s_{t+1}$)と目標値($s_{t+1}$)の間のMSE(平均二乗誤差)を最適化してモデルを学習します。


<!-- ## Deterministic predictor-decoder -->
## 決定論的な予測器-デコーダ

<!-- One way to train our world model is by using a predictor-decoder model explained below. -->
世界モデルを学習する方法の一つは、以下に説明する予測器-デコーダモデルを使用することです。

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure8.png" style="zoom: 20%; background-color:#DCDCDC;" /><br>
<b>Figure 8:</b> Deterministic predictor-decoder to learn the world model
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure8.png" style="zoom: 20%; background-color:#DCDCDC;" /><br>
<b>図8:</b> 世界モデルを学習するための決定論的な予測器-デコーダ

<!-- As depicted in Figure 8, we have a sequence of states($s_{1:t}$) and action ($a_t$) which are provided to the predictor module. The predictor outputs a hidden representation of the future which is passed on to the decoder. The decoder is decoding the hidden representation of the future and outputs a prediction($\hat s_{t+1}$). We then train our model by minimising MSE between prediction $\hat s_{t+1}$ and target $s_{t+1}$. -->
図8に示されているように、状態($s_{1:t}$)と行動($a_t$)のシーケンスが予測器モジュールに提供されています。予測器は、デコーダに渡す将来の潜在表現を出力します。デコーダは、将来の潜在表現をデコードし、予測値($\hat s_{t+1}$)を出力します。そして、予測 $\hat s_{t+1}$ とターゲット $s_{t+1}$ の間のMSEを最小化することでモデルを学習します。

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure9.png" style="zoom: 20%; background-color:#DCDCDC;" /><br>
<b>Figure 9:</b> Actual future vs. Deterministic future
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure9.png" style="zoom: 20%; background-color:#DCDCDC;" /><br>
<b>図9:</b> 実際の未来と決定論的な未来
</center>

<!-- Unfortunately, this does not work!

We see that the deterministic output becomes very hazy. This is because our model is averaging over all the future possibilities. This can be compared to the future's multimodality discussed a couple of classes earlier, where a pen placed at origin is dropped randomly. If we take the average across all locations, it gives us a belief that pen never moved which is incorrect.

We can address this problem by introducing latent variables in our model. -->

残念ながら、これはうまくいきません!

決定論的な出力は非常に曖昧になることがわかります。なぜなら、我々のモデルがすべての未来の可能性を平均化しているからです。これは、以前にいくつか前のクラスで議論された、未来のマルチモダリティと比較することができます。そこでは原点に置かれたペンがランダムに落とされる例を用いて説明していました。すべての場所の平均を取ると、ペンは決して動かなかったという誤った信念を与えてしまいます。

我々のモデルに潜在変数を導入することで、この問題に対処できます。


<!-- ## [Variational predictive network](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=1779s) -->
## [変分予測ネットワーク](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=1779s)

<!-- To solve the problem stated in the previous section, we add a low dimensional latent variable $z_t$ to the original network which goes through an expansion module $f_{exp}$ to match the dimensionality. -->
前節で述べた問題を解決するために、元のネットワークに低次元の潜在変数 $z_t$ を追加し、これを拡張モジュール $f_{exp}$ に通して次元数を一致させます。

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure10.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 10:</b> Variational predictive network - train
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure10.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>図10:</b> 変分予測ネットワーク：訓練
</center>

<!-- The $z_t$ is chosen such that the MSE is minimized for a specific prediction. By tuning the latent variable, you can still get MSE to zero by doing gradient descent into latent space. But this is very expensive. So, we can actually predict that latent variable using an encoder. Encoder takes the future state to give us a distribution with a mean and variance from which we can sample $z_t$.

During training, we can find out what is happening by looking into the future and getting information from it and use that information to predict the latent variable. However, we don't have access to the future during testing time. We fix this by enforcing the encoder to give us a posterior distribution as close as possible to the prior by optimizing KL divergence. -->

$z_t$は、特定の予測に対してMSEが最小化されるように選択されます。潜在変数をチューニングすることで、潜在空間での勾配法を行うことで、MSEをゼロにすることができます。しかし、これは非常にコストがかかります。実際には、エンコーダを使って潜在変数を予測することができます。エンコーダは将来の状態を取得して、平均と分散を持つ分布を与え、そこから $z_t$ をサンプリングすることができます。

訓練の間、未来を見てそこから情報を得て、その情報を使って潜在変数を予測することで、何が起こっているかを見つけることができます。しかし、テスト時には未来にアクセスできません。我々は、KLダイバージェンスを最適化することによって、エンコーダが可能な限り事前分布に近い事後分布を与えるように強制することによって、これを修正します。

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure11.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 11:</b> Variational predictive network - train (with prior distribution)
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure11.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>図11:</b> 変分予測ネットワーク：訓練（事前分布つき）
</center>

<!-- Now, let us look at the inference - How do we drive? -->
では、推論を見てみましょう。私たちはどのように運転するのでしょうか？

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure12.png" style="zoom: 32%; background-color:#DCDCDC;" /><br>
<b>Figure 12:</b> Variational predictive network - inference
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure12.png" style="zoom: 32%; background-color:#DCDCDC;" /><br>
<b>図12:</b> 変分予測ネットワーク：推論
</center>

<!-- We sample the low-dimensional latent variable $z_t$ from the prior by enforcing the encoder to shoot it towards this distribution. After getting the prediction $\hat s_{t+1}$, we put it back (in an auto-regressive step) and get the next prediction $\hat s_{t+2}$ and keep feeding the network this way. -->

エンコーダが事前分布に向かうように強制して、低次元の潜在変数 $z_t$ を、事前分布からサンプリングします。予測 $\hat s_{t+1}$ が得られたら、それを元に戻して(自己回帰的なステップで)、次の予測 $\hat s_{t+2}$ を得て、このようにネットワークに送り続けます。

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure13.png" style="zoom: 22%; background-color:#DCDCDC;" /><br>
<b>Figure 13:</b> Actual future vs Deterministic
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure13.png" style="zoom: 22%; background-color:#DCDCDC;" /><br>
<b>図13:</b> 実際の未来 vs 決定論的な場合
</center>

<!-- On the right hand side in the above figure, we can see four different draws from the normal distribution. We start with same initial state and provide different 200 values to the latent variable. -->
上図の右側では、正規分布からの4つの異なるサンプルが見られます。同じ初期状態から始めて、潜在変数に異なる200の値を与えています。

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure14.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<b>Figure 14:</b> Actual future vs Deterministic - after movement
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure14.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<b>図14:</b> 実際の未来 vs 決定論的な場合：動いた後
</center>

<!-- We can notice that providing different latent variables generates different sequences of states with different behaviours. Which means we have a network that generates the future. Quite fascinating!

What's next?

We can now use this huge amount of data to train our policy by optimizing the lane and proximity costs described above.

These multiple futures come from the sequence of latent variables that you feed to the network. If you perform gradient ascent - in the latent space, you try to increase the proximity cost so you get the sequence of latent variables such that the other cars are going to be driving into you. -->

異なる潜在変数を提供することで、異なる行動を持つ異なる状態のシーケンスが生成されることがわかります。つまり、我々は未来を生成するネットワークを持っているということです。非常に魅力的です!

次は何をするのでしょうか？

この膨大な量のデータを使用して、上で説明した車線コストと近接コストを最適化することで、方策を訓練することができます。

これらの複数の未来は、ネットワークに供給する潜在変数のシーケンスから得られます。勾配上昇法を実行すると、潜在空間で近接コストを増加させようとして、他の車があなたに突っ込んでくるような潜在変数のシーケンスを得ることができます。

<!-- ## Action insensitivity & latent dropout -->
## 行動に対する感度の低さと潜在空間でのドロップアウト

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure15.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 15:</b> Issues - Action Insensitivity
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure15.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>図15:</b> 問題：行動に対する感度の低さ
</center>


<!-- Given that you actually have access to the future, if you turn to the left even slightly, everything is going to be turning to the right and that will contribute in a huge way to the MSE. The MSE loss can be minimized if the latent variable can inform the bottom part of the network that everything is going to turn to the right - which is not what we want! We can tell when everything turns to the right since that is a deterministic task.

The big arrow in Figure 15 signifies a leak of information and therefore it was not any more sensitive to the current action being provided to the predictor. -->

あなたが実際に未来にアクセスできるとすると、もしあなたが少しでも左に回れば、外界はすべてが右に回ろうとすることになり、それはMSEに大きな貢献をするでしょう。潜在変数が、ネットワークの下部に、すべてのものが右に向くことを知らせることができれば、MSEの損失は最小限に抑えることができます。しかしこれは私たちが望んでいるものではありません! それは決定論的なタスクなので、すべてのものがいつ右に向くかを知ることができます。

図15の大きな矢印は情報の漏洩を意味し、したがって、予測器に提供されている現在の行動に対しては、もはや敏感ではありませんでした。

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure16.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 16:</b> Issue - Action Insensitivity
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure16.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>図16:</b> 問題：行動に対する感度の低さ
</center>

<!-- In figure 16, in the rightmost diagram we have the real sequence of latent variables (the latent variables that allow us to get the most precise future) and we have the real sequence of actions taken by the expert. The two figures to the left of this one have randomly sampled latent variables but the real sequence of actions so we expect to see the steering. The last one on the left-hand side has the real sequence of latent variable but arbitrary actions and we can clearly see that the turning came mostly from the latent rather than the action, which encodes the rotation and the action (which are sampled from other episodes).

How to fix this problem? -->

16の図では、一番右の図では、本当の潜在変数（最も正確な未来を得ることができる潜在変数）の列があり、エキスパートがとった実際にとった行動の列があります。この図の左側の2つの図は、ランダムにサンプリングされた潜在変数を持っていますが、本当の行動列を持っていますので、操縦という行動もあることが期待されます。左側の最後の図は、潜在変数ですが任意の行動の列を持っており、回転とアクション（他のエピソードからサンプリングされている）を符号化している行動よりも、回転のほとんどが潜在変数から来ていることがはっきりとわかります。

この問題を解決するにはどうしたら良いでしょう？

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure17.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 17:</b> Fix - Latent Dropout
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure17.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>図17:</b> 解決策：潜在変数のドロップアウト
</center>

<!-- The problem is not a memory leak but an information leak. We fix this problem by simply dropping out this latent and sampling it from the prior distribution at random. We don't always rely on the output of the encoder ($f_{enc}$) but pick from the prior. In this way, you cannot encode the rotation in the latent variable any more. In this way, information gets encoded in the action rather than the latent variable. -->

問題は記憶の漏洩ではなく情報の漏洩です。私たちは、この潜在変数を単に削除して、事前分布からランダムにサンプリングすることで、この問題を解決します。常にエンコーダの出力($f_{enc}$)に頼るのではなく、事前分布からサンプリングします。このようにすることで、もはや潜在変数に回転操作を符号化することはできなくなります。こうして、情報は潜在変数ではなく行動の中に符号化されます。

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure18.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 18:</b> Performance with latent dropout
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure18.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>図18:</b> 潜在変数のドロップアウトによる性能
</center>

<!-- In the last two images on the right-hand side, we see two different sets of latent variables having a real sequence of actions and these networks have been trained with the latent dropout trick. We can now see that the rotation is now encoded by the action and no longer by the latent variables. -->
右辺では、実際の一連のアクションを持つ2つの異なる潜在変数のセットが見られますが、これらのネットワークは潜在変数をドロップアウトするトリックを用いて訓練されています。これによって、回転が行動によって符号化され、もはや潜在変数に符号化されていないことがわかります。


<!-- ## [Training the agent](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=3232s) -->
## [エージェントの訓練](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=3232s)

<!-- In the previous sections, we saw how we can obtain a world model by simulating real world experiences.  In this section, we will use this world model to train our agent.  Our goal is to learn the policy to take an action given the history of previous states.  Given a state $s_t$ (velocity, position & context images), the agent takes an action $a_t$ (acceleration, brake & steering), the world model outputs a next state and cost associated with that $(s_t, a_t)$ pair which is a combination of proximity cost and lane cost. -->

前節では、実世界での経験をシミュレートして世界モデルを得る方法を見ました。 この節では、この世界モデルを用いてエージェントを訓練します。 我々の目的は、過去の状態の履歴から、ある行動をとるための方策を学習することです。 ある状態$s_t$(速度、位置、コンテキスト画像)が与えられると、エージェントはアクション$a_t$(加速、ブレーキ、ステアリング)を取り、世界モデルは次の状態と、その$(s_t, a_t)$のペアに関連付けられたコストを出力します。

$$
c_\text{task} = c_\text{proximity} + \lambda_l c_\text{lane}
$$

<!-- As discussed in the previous section, to avoid hazy predictions, we need to sample latent variable $z_t$ from the encoder module of the future state $s_{t+1}$ or from prior distribution $P(z)$.  The world model gets previous states $s_{1:t}$, action taken by our agent and latent variable $z_t$ to predict the next state $\hat s_{t+1}$ and the cost.  This constitutes one module that is replicated multiple times (Figure 19) to give us final prediction and loss to optimize. -->
前節で議論したように、曖昧な予測を避けるために、将来の状態$s_{t+1}$のエンコーダモジュールから、または事前分布$P(z)$から潜在変数$z_t$をサンプリングする必要があります。 世界モデルは、前の状態$s_{1:t}$と、エージェントがとった行動と、次の状態を予測するための潜在変数$z_t$を取得します。 これは、最終的な予測と最適化のための損失を与えるために、複数回複製される1つのモジュールを構成しています（図19）。


<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure19.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 19:</b> Task specific model architecture
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure19.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>図19:</b> タスク固有のモデルアーキテクチャ
</center>

<!-- So, we have our model ready.  Let’s see how it looks !! -->
モデルの準備が整いました。 どんな風に見えるか見てみましょう

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure20.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 20:</b> Learned policy: Agent either collides or moves away from the road
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure20.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>図20:</b> 学習された方策：エージェントはぶつかりあったり、道から離れていきます。
</center>

<!-- Unfortunately, this does not work.  Policy trained this way is not useful as it learns to predict all black since it results in zero cost.

How can we address this issue? Can we try imitating other vehicles to improve our predictions? -->

残念ながら、これはうまくいきません。 このように訓練された方策は、コストがゼロになるので、すべての黒を予測することを学習してしまうので、役に立たないのです。

どうすればこの問題に対処できるのでしょうか？予測を改善するために他の車両を真似してみることはできないでしょうか？


<!-- ## Imitating the expert -->
## エキスパートの真似をする

<!-- How do we imitate the experts here? We want the prediction of our model after taking a particular action from a state to be as close as possible to the actual future. This acts as an expert regulariser for our training. Our cost function now includes both the task specific cost(proximity cost and lane cost) and this expert regulariser term. Now as we are also calculating the loss with respect to the actual future, we have to remove the latent variable from the model because the latent variable gives us a specific prediction, but this setting works better if we just work with the average prediction. -->
エキスパートの真似をするにはどうすればいいのでしょうか？ある状態から特定の行動をとった後のモデルの予測が、実際の未来にできるだけ近いものになるようにしたいのです。これは、学習のためのエキスパートによる正則化として機能します。我々のコスト関数には、タスク固有のコスト（近接コストと車線コスト）とこのエキスパートによる正則化の項の両方が含まれています。実際の未来に関する損失も計算しているので、モデルから潜在変数を削除しなければなりません。なぜなら、潜在変数は特定の予測を与えてしまうからです。しかし、この設定では平均予測だけでやる方がうまくいきます。


$$
\mathcal{L} = c_\text{task} + \lambda u_\text{expert}
$$

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure21.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 21:</b>  Expert regularization based model architecture
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure21.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>図21:</b>  エキスパートによる正則化に基づくモデルアーキテクチャ
</center>

<!-- So how does this model perform? -->
このモデルはどう振る舞うでしょうか？

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure22.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 22:</b> Learned policy by imitating the experts
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure22.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>図22:</b> エキスパートを真似することで学習された方策
</center>

<!-- As we can see in the above figure, the model actually does incredibly well and learns to make very good predictions. This was model based imitation learning, we tried to model our agent to try to imitate others.

But can we do better?
Did we just train the Variational Autoencoder to remove it in the end?

It turns out we can still improve if we look to minimize the uncertainty of the forward model predictions. -->

上の図でわかるように、このモデルは実際には信じられないほどうまく動き、非常に良い予測をするように学習します。これはモデルベースの模倣学習で、私たちはエージェントをモデル化して他の人の真似をしようとしました。

しかし、もっとうまくできないでしょうか？
変分オートエンコーダーを訓練して、最終的にそれを除去しただけなのでしょうか？

フォワードモデルの予測の不確実性を最小化することに目を向ければ、まだ改善できることがわかりました。


<!-- ## Minimizing the Forward Model Uncertainty -->
## フォワードモデルの不確実性を最小化する

<!-- What do we mean by minimizing forward model uncertainty and how would we do it? Before we answer that, let’s recap something we saw in the third week’s practicum.

If we train multiple models on the same data, all those models agree on the points in the training region (shown in red) resulting in zero variance in the training region. But as we move further away from the training region, the trajectories of loss functions of these models start diverging and variance increases. This is depicted in the figure 23.  But as the variance is differentiable, we can run gradient descent over the variance in order to minimize it. -->

フォワードおモデルの不確実性を最小化するとはどういうことでしょうか、また、どのようにしてそれを行うのでしょうか。それに答える前に、3週目の実習で見たことを思い出してみましょう。

同じデータで複数のモデルを訓練すると、それらのモデルはすべて訓練領域（赤で示されている）の点で一致し、結果として訓練領域の分散はゼロになります。しかし、訓練領域から遠ざかるにつれて、これらのモデルの損失関数の軌道は発散し始め、分散は増加します。これは図23に描かれています。 しかし、分散は微分可能なので、分散を最小化するために、分散の上で勾配降下を実行することができます。


<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure23.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>Figure 23:</b> Cost visualization across the entire input space
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure23.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>図23:</b> 全入力空間にわたるコストの可視化
</center>

<!-- Coming back to our discussion, we observe that learning a policy using only observational data is challenging because the distribution of states it produces at execution time may differ from what was  observed during the training phase. The world model may make arbitrary predictions outside the domain it was trained on, which may wrongly result in low cost. The policy network may then exploit these errors in the dynamics model and produce actions which lead to wrongly optimistic states.

To address this, we propose an additional cost which measures the uncertainty of the dynamics model about its own predictions. This can be calculated by passing the same input and action through several different dropout masks, and computing the variance across the different outputs.  This encourages the policy network to only produce actions for which the forward model is confident. -->

議論に戻りますが、観測データのみを用いて方策を学習することは、実行時に生成される状態の分布が訓練段階で観測されたものと異なる可能性があるため、困難であることがわかります。世界モデルは、訓練された領域の外で任意の予測をすることがあり、それが間違って低コストになることがあります。その結果、ポリシーネットワークはダイナミクスモデルのこれらの誤差を利用して、誤って楽観的な状態になるような行動を生成する可能性があります。

これに対処するために、我々はダイナミクスモデルの予測の不確実性を測定する追加のコストを提案します。これは、同じ入力と行動を複数の異なるドロップアウトマスクに通して異なる出力間の分散を計算することで計算できます。これにより、ポリシーネットワークは、フォワードモデルが自信を持っている行動のみを生成するようになります。

$$
\mathcal{L} = c_\text{task} + \lambda c_\text{uncertainty}
$$

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure24.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 24:</b> Uncertainty regulariser based model architecture
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure24.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>図24:</b> 不確実性に対する正則化を加えたモデルアーキテクチャ
</center>

<!-- So, does uncertainty regulariser help us in learning better policy?

Yes, it does. The policy learned this way is better than the previous models. -->

では、不確実性に対する正則化は、より良い方策を学ぶのに役立つのでしょうか？

はい、そうです。このようにして学習された方策は、以前のモデルよりも優れています。

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure25.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 25:</b> Learned policy based on uncertainty regulariser
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure25.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>図25:</b> 不確実性の正則化に基づいて学習された方策
</center>


<!-- ## Evaluation -->
## 評価

<!-- Figure 26 shows how well our agent learned to drive in dense traffic.  Yellow car is the original driver, blue car is our learned agent and all green cars are blind to us (cannot be controlled). -->
図26は、我々のエージェントが渋滞している道路でどれだけ運転を学習したかを示しています。 黄色の車が元の運転手で、青の車が学習したエージェントで、緑の車はすべて我々には見えません（よって制御できません）。

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure26.gif" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 26:</b> Performance of model with uncertainty regulariser
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure26.gif" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>図26:</b> 不確実性の正則化つきモデルの性能
</center>
