---
lang-ref: ch.11-2
lecturer: Yann LeCun
title: Loss Functions (cont.) and Loss Functions for Energy Based Models
authors: Charles Brillo-Sonnino, Shizhan Gong, Natalie Frank, Yunan Hu
date: 13 April 2020
lang: ja
translation-date: 6 Dec 2020
translator: Shiro Takagi
---


### [Binary Cross Entropy (BCE) Loss - `nn.BCELoss()`](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=3207s)

$$
\ell(x,y) = L = \{l_1,...,l_N\}^T, \qquad l_n = -w_n[y_n\log x_n+(1-y_n)\log(1-x_n)]
$$

<!-- This loss is a special case of cross entropy for when you have only two classes so it can be reduced to a simpler function. This is used for measuring the error of a reconstruction in, for example, an auto-encoder. This formula assume $x$ and $y$ are probabilities, so they are strictly between 0 and 1. -->
この損失は、2つのクラスしかない場合のためのクロスエントロピーの特殊なケースであり、より単純な関数として表現できます。これは、例えばオートエンコーダーの再構成誤差を測定するために使われます。この式は、$x$ と $y$ が確率であると仮定しているので、厳密には0と1の間にあります。

### Kullback-Leibler Divergence Loss - `nn.KLDivLoss()`

$$
\ell(x,y) = L = \{l_1,...,l_N\}^T, \qquad l_n = y_n(\log y_n-x_n)
$$

<!-- This is simple loss function for when your target is a one-hot distribution (*i.e.* $y$ is a category). Again it assumes $x$ and $y$ are probabilities. It has the disadvantage that it is not merged with a softmax or log-softmax so it may have numerical stability issues. -->
これは、ターゲットがワンホット分布(*i.e.* $y$がカテゴリ)の場合の単純な損失関数です。ここでも、$x$ と $y$ が確率であると仮定しています。これは、softmaxやlog-softmaxとマージされないという欠点があり、数値的な安定性に問題が生じるかもしれません。


### BCE Loss with Logits - `nn.BCEWithLogitsLoss()`

$$
\ell(x,y) = L = \{l_1,...,l_N\}^T, \qquad l_n = -w_n[y_n\log \sigma(x_n)+(1-y_n)\log(1-\sigma(x_n))]
$$

<!-- This version of binary cross entropy loss takes scores that haven't gone though softmax so it does not assume x is between 0 and 1. It is then passed though a sigmoid to ensure it is in that range. The loss function is more likely to be numerically stable when combined like this. -->
このバージョンのバイナリクロスエントロピー損失は、softmaxを通過していないスコアを入力に取るため、$x$が0から1の間であると仮定していません。 そして、その範囲内であることを確認するためにシグモイドに渡されます。損失関数は、このように組み合わせると数値的に安定する可能性が高くなります。


### Margin Ranking Loss - `nn.MarginRankingLoss()`

$$
L(x,y) = \max(0, -y*(x_1-x_2)+\text{margin})
$$

<!-- Margin losses are an important category of losses. If you have two inputs, this loss function says you want one input to be larger than the other one by at least a margin. In this case $y$ is a binary variable $\in \{ -1, 1\}$. Imagine the two inputs are scores of two categories. You want the score for the correct category larger than the score for the incorrect categories by at least some margin.  Like hinge loss, if $y*(x_1-x_2)$ is larger than margin, the cost is 0. If it is smaller, the cost increases linearly. If you were to use this for classification, you would have $x_1$ be the score of the correct answer and $x_2$ be the score of the highest scoring incorrect answer in the mini-batch. If used in energy based models (discussed later), this loss function pushes down on the correct answer $x_1$ and up on the incorrect answer $x_2$. -->
マージン損失は損失の重要なカテゴリーです。2つの入力がある場合、この損失関数は、片方の入力がもう片方の入力よりも少なくともあるマージンの分大きくなるようにしたいということを表しています。この場合、$y$は二値変数 $y \in \{ -1, 1\}$です。2つの入力が2つのカテゴリのスコアだとします。正しいカテゴリのスコアを、正しくないカテゴリのスコアよりも、少なくともいくつかのマージンで大きくしたいとします。 ヒンジ損失のように、$y*(x_1-x_2)$がマージンよりも大きければ、コストは0になります。 それよりも小さければ、コストは直線的に増加します。これを分類に使う場合、$x_1$ は正解のスコア、$x_2$ はミニバッチの中で最もスコアの高い不正解のスコアとなります。エネルギーベースモデル(後述)で使用する場合、この損失関数は正解 $x_1$ を押し下げ、不正解 $x_2$ を押し上げます。


### Triplet Margin Loss - `nn.TripletMarginLoss()`

$$
L(a,p,n) = \max\{d(a_i,p_i)-d(a_i,n_i)+\text{margin}, 0\}
$$

<!-- This loss is used for measuring a relative similarity between samples.  For example, you put two images with the same category through a CNN and get two vectors. You want the distance between those two vectors to be as small as possible. If you put two images with different categories through a CNN, you want the distance between those vectors to be as large as possible. This loss function tries to send the first distance toward 0 and the second distance larger than some margin.  However, the only thing that matter is that the distance between the good pair is smaller than the distance between the bad pair. -->
この損失は、サンプル間の相対的な類似度を測定するために用いられます。例えば、同じカテゴリの2つの画像をCNNに通し、2つのベクトルを得たとします。この2つのベクトル間の距離をできるだけ小さくしたいとします。異なるカテゴリを持つ2つの画像をCNNに通すと、それらのベクトル間の距離は可能な限り大きくなります。この損失関数は、最初の距離を0に、2番目の距離をあるマージンよりも大きくしようとします。 しかし、重要なのは、良いペアの間の距離が悪いペアの間の距離よりも小さいということだけです。

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-2/tml.png" width="100%"/><br>
<b>Fig. 1</b>: Triplet Margin Loss
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-2/tml.png" width="100%"/><br>
<b>図1</b>: Triplet Margin Loss
</center>

<!-- This was originally used to train an image search system for Google. At that time, you would type a query into Google and it would encode that query into a vector. It would then compare that vector to a bunch of vectors from images that were previously indexed. Google would then retrieve the images that were the closest to your vector. -->
これは元々、Googleの画像検索システムの訓練に使われていたものです。当時は、Googleにクエリを入力すると、そのクエリをベクトルにエンコードしていました。そして、そのベクトルを、事前にインデックス化された画像のベクトルの束と比較します。そのようにして、Googleはあなたが投げたクエリベクトルに最も近い画像を検索していました。


### Soft Margin Loss - `nn.SoftMarginLoss()`

$$
L(x,y) = \sum_i\frac{\log(1+\exp(-y[i]*x[i]))}{x.\text{nelement()}}
$$

<!-- Creates a criterion that optimizes a two-class classification logistic loss between input tensor $x$  and target tensor $y$  (containing 1 or -1).

* This softmax version of a margin loss. You have a bunch of positives and a bunch of negatives you want to pass through a softmax. This loss function then tries to make $\text{exp}(-y[i]*x[i])$ for the correct $x[i]$ smaller than for any other.
* This loss function wants to pull the positive values of $y[i]*x[i]$ closer together and push the negative values far apart but, as opposed to a hard margin, with some continuous, exponentially decaying effect on the loss . -->

入力テンソル$x$とターゲットテンソル$y$（1または-1を含む）の間の2クラス分類ロジスティック損失を最適化する基準を作成します。

* これは、マージン損失のソフトマックス版です。正の値の束と負の値の束があり、ソフトマックスを通過させたいとします。この関数は、正しい$x[i]$の$\text{exp}(-y[i]*x[i])$を、他のものよりも小さくしようとします。
* この損失関数は、$y[i]*x[i]$の正の値をより近くに引き寄せ、負の値をより遠くに引き離そうとしますが、ハードマージンとは対照的に、連続的で指数関数的に減衰する効果を持った損失が得られます。


### Multi-Class Hinge Loss - `nn.MultiLabelMarginLoss()`

$$
L(x,y)=\sum_{ij}\frac{max(0,1-(x[y[j]]-x[i]))}{x.\text{size}(0)}
$$

<!-- This margin-base loss allows for different inputs to have variable amounts of targets. In this case you have several categories for which you want high scores and it sums the  hinge loss over all categories. For EBMs, this loss function pushes down on desired categories and pushes up on non-desired categories. -->
このマージンベースの損失は、異なる入力が様々なターゲットを持つことを可能にします。この場合、高いスコアを出したいカテゴリがいくつかあり、すべてのカテゴリのヒンジ損失を合計します。EBMの場合、この損失関数は、希望するカテゴリを押し下げ、希望しないカテゴリを押し上げます。

### Hinge Embedding Loss - `nn.HingeEmbeddingLoss()`

$$
l_n =
\left\{
     \begin{array}{lr}
     x_n, &\quad y_n=1,  \\
     \max\{0,\Delta-x_n\}, &\quad y_n=-1  \\
     \end{array}
\right.
$$

<!-- Hinge embedding loss used for semi-supervised learning by measuring whether two inputs are similar or dissimilar. It pulls together things that are similar and pushes away things are dissimilar. The $y$ variable indicates whether the pair of scores need to go in a certain direction. Using a hinge loss, the score is positive if $y$ is 1 and some margin $\Delta$ if $y$ is -1. -->
これは2つの入力が似ているか似ていないかを測定するヒンジ埋め込み損失で、半教師あり学習に使用されます。似ているものをまとめて、似ていないものを押しのけます。変数$y$は、スコアのペアがある方向に進む必要があるかどうかを示します。ヒンジ損失を使うと、$y$が1であればスコアは正となり、$y$が-1であればあるマージン$\Delta$が得られます。


### Cosine Embedding Loss - `nn.CosineEmbeddingLoss()`

$$
l_n =
\left\{
     \begin{array}{lr}
     1-\cos(x_1,x_2), & \quad y=1,  \\
     \max(0,\cos(x_1,x_2)-\text{margin}), & \quad y=-1
     \end{array}
\right.
$$

<!-- This loss is used for measuring whether two inputs are similar or dissimilar, using the cosine distance, and is typically used for learning nonlinear embeddings or semi-supervised learning.

* Thought of another way, 1 minus the cosine of the angle between the two vectors is basically the normalised Euclidean distance.
* The advantage of this is that whenever you have two vectors and you want to make their distance as large as possible, it is very easy to make the network achieve this by make the vectors very long. Of course this is not optimal. You don't want the system to make the vectors big but rotate vectors in the right direction so you normalise the vectors and calculate the normalised Euclidean distance.
* For positive cases, this loss tries to make the vectors as aligned as possible. For negative pairs, this loss tries to make the cosine smaller than a particular margin. The margin here should be some small positive value.
* In a high dimensional space, there is a lot of area near the equator of the sphere. After normalisation, all your points are now normalised on the sphere. What you want is samples that are semantically similar to you to be close. The samples that are dissimilar should be orthogonal. You don't want them to be opposite each other because there is only one point at the opposite pole. Rather, on the equator, there is a very large amount of space so you want to make the margin some small positive value so you can take advantage of all this area. -->

この損失は、コサイン距離を用いて2つの入力が似ているか似ていないかを測定するために用いられ、非線形埋め込み学習や半教師あり学習などに用いられます。

* 別の言い方をすれば、１から2つのベクトル間の角度のコサインを引いた値が、基本的には正規化されたユークリッド距離となります。
* これを用いる利点は、2つのベクトルの距離をできるだけ大きくしたいときに、ベクトルを非常に長くすることで、ネットワークがこれを達成することが非常に簡単にできてしまうという事実に起因しています。もちろんこれは最適ではありません。ベクトルを大きくするのではなく、ベクトルを正しい方向に回転させたいので、ベクトルを正規化し、正規化されたユークリッド距離を計算します。
* 正の場合、この損失は可能な限りベクトルを揃えようとします。負のペアでは、コサインを特定のマージンよりも小さくしようとします。ここでのマージンは小さな正の値である必要があります。
* 高次元空間では、球の赤道付近に多くの領域があります。正規化後、すべての点は球上で正規化されます。意味的に似ているサンプルが近くにあることが望ましいです。似ていないサンプルは直交していなければなりません。反対の極には1つの点しかないので、それらが互いに反対になって欲しくはありません。むしろ、赤道上には非常に大きなスペースがあるので、この面積を利用できるように、マージンを小さな正の値にしたいのです。


### [Connectionist Temporal Classification (CTC) Loss - `nn.CTCLoss()`](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=4103s)

<!-- Calculates loss between a continuous (unsegmented) time series and a target sequence.
*  CTC loss sums over the probability of possible alignments of input to target, producing a loss value which is differentiable with respect to each input node.
* The alignment of input to target is assumed to be "many-to-one", which limits the length of the target sequence such that it must less than or equal to the input length.
* Useful when your output is a sequence of vectors, which is correspond to scores of categories. -->

連続な（分割されていない）時系列とターゲット系列の間の損失を計算します。
* CTC損失は，入力からターゲットへの可能性のあるアラインメントの確率を合計し、各入力ノードに対して微分可能な損失値を生成します。
* 入力からターゲットへのアラインメントは、多対一であると仮定され、ターゲット系列の長さが入力の長さ以下になるように制限されます。
* 出力がカテゴリのスコアに対応するベクトルの系列である場合に便利です。

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-2/Fig1.png" width="85%"/><br>
<b>Fig. 2</b>: CTC Loss for speech recognition
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-2/Fig1.png" width="85%"/><br>
<b>図2</b>: 音声認識のためのCTC損失
</center>

<!-- Application Example: Speech recognition system
* Goal: Predict what word is being pronounced every 10 milliseconds.
* Each word is represented by a sequence of sounds.
* Depends on the person's speaking speed, different length of the sounds might be mapped to the same word.
* Find the best mapping from the input sequence to the output sequence. A good method for this is using dynamic programming to find the minimum cost path. -->
応用例：音声認識システム
* 目標：10ミリ秒ごとにどの単語が発音されているかを予測します。
* 各単語は音の系列で表されます。
* 人の話すスピードに応じて、異なる長さの音が同じ単語にマッピングされることがあります。
* 入力音列から出力音列への最適なマッピングを見つけます。このための良い方法は、動的プログラミングを使用して、最小コストのパスを見つけることです。

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-2/Fig2.png" width="85%" style="background-color:white;"/><br>
<b>Fig. 3</b>: Many-to-one mapping setup
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-2/Fig2.png" width="85%" style="background-color:white;"/><br>
<b>図3</b>: 多対一マッピングのセットアップ
</center>


<!-- # Energy-Based Models (Part IV) - Loss Function -->
# エネルギーベースモデル (Part IV) - 損失関数


<!-- ## Architecture and Loss Functional -->
## アークテクチャと損失汎関数

<!-- Family of energy functions: $\mathcal{E} = \{E(W,Y, X) : W \in \mathcal{W}\}$. -->
エネルギー関数の族: $\mathcal{E} = \{E(W,Y, X) : W \in \mathcal{W}\}$.

<!-- Training set: $S = \{(X^i, Y^i): i = 1 \cdots P\}$ -->
訓練集合: $S = \{(X^i, Y^i): i = 1 \cdots P\}$

<!-- Loss functional: $\mathcal{L} (E, S)$
* Functional means a function of another function. In our case, the functional $\mathcal{L} (E, S)$ is a function of the energy function $E$.
* Because $E$ is parametrised by $W$, we can turn the functional to a loss function of $W$: $\mathcal{L} (W, S)$
* Measures the quality of an energy function on training set
* Invariant under permutations and repetitions of the samples. -->
損失汎関数: $\mathcal{L} (E, S)$
* 汎関数とは、他の関数の関数を意味します。この場合は、汎関数 $\mathcal{L} (E, S)$は、エネルギー関数$E$の関数です。
* $E$ は $W$ でパラメトライズされているので、汎関数を $W$ の損失関数に変えることができます: $\mathcal{L} (W, S)$
* 訓練集合でエネルギー関数の質を測定します。
* サンプルの並べ替えと反復に対して不変です。

<!-- Training: $W^* = \min_{W\in \mathcal{W}} \mathcal{L}(W, S)$. -->
訓練: $W^* = \min_{W\in \mathcal{W}} \mathcal{L}(W, S)$.

<!-- Form of the loss functional:
* $L(Y^i, E(W, \mathcal{Y}, X^i))$ is per-sample loss
* $Y^i$ is desired answer, can be category or a whole image, etc.
* $E(W, \mathcal{Y}, X^i)$ is energy surface for a given $X_i$ as $Y$ varies
* $R(W)$ is regulariser -->

損失汎関数の形式：
* $L(Y^i, E(W, \mathcal{Y}, X^i))$ はサンプルごとの損失
* $Y^i$ は理想の答えで、 カテゴリーか画像全体など
* $E(W, \mathcal{Y}, X^i)$ は与えられた $X_i$ に対して $Y$ の変化に対するエネルギー関数
* $R(W)$ は正則化項

$$
\mathcal{L}(E, S) = \frac{1}{P} \sum_{i=1}^P L(Y^i, E(W,\mathcal{Y}, 	X^i)) + R(W)
$$


<!-- ## Designing a Good Loss Function

**Push down** on the energy of the correct answer.

**Push up** on the energies of the incorrect answers, particularly if they are smaller than the correct one. -->

## 良い損失関数の設計

**正解のエネルギーを押し下げる**。

**不正解のエネルギーを押し上げる**。特に正解よりも小さい場合。


<!-- ## Examples of Loss Functions -->
## 損失関数の例

### Energy Loss

$$
L_{energy} (Y^i, E(W, \mathcal{Y}, X^i)) = E(W, Y^i, X^i)
$$

<!-- This loss function simply pushes down on the energy of the correct answer. If the network is not designed properly, it might end up with a mostly flat energy function as you only trying to make the energy of the correct answer small but not pushing up the energy elsewhere. Thus, the system might collapses. -->
この損失関数は、単に正解のエネルギーを押し下げます。ネットワークが正しく設計されていない場合、正解のエネルギーを小さくしようとするだけで他の場所でエネルギーを押し上げないので、それはほとんど平坦なエネルギー関数になるかもしれません。したがって、システムが崩壊する可能性があります。


### Negative Log-Likelihood Loss

$$
L_{nll}(W, S) = \frac{1}{P} \sum_{i=1}^P (E(W, Y^i, X^i) + \frac{1}{\beta} \log \int_{y \in \mathcal{Y}} e^{\beta E(W, y, X^i)})
$$

<!-- This loss function pushes down on the energy of the correct answer while pushing up on the energies of all answers in proportion to their probabilities. This reduces to the perceptron loss when $\beta \rightarrow \infty$. It has been used for a long time in many communities for discriminative training with structured outputs.

A probabilistic model is an EBM in which:

* The energy can be integrated over Y (the variable to be predicted)
* The loss function is the negative log-likelihood -->

この損失関数は正解のエネルギーを押し下げ、確率に比例して全ての答えのエネルギーを押し上げます。これは、$\beta \rightarrow \infty$のとき、パーセプトロンの損失に帰着されます。構造化された出力を用いた識別訓練のために多くのコミュニティで長い間使われてきました。

確率モデルとは、以下を満たすEBMのことです

* エネルギーが、Y(予測される変数)の上で積分できる。
* 損失関数が負の対数尤度


### [Perceptron Loss](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=4998s)

$$
L_{perceptron}(Y^i,E(W,\mathcal Y, X^*))=E(W,Y^i,X^i)-\min_{Y\in \mathcal Y} E(W,Y,X^i)
$$
<!-- 
Very similar to the perceptron loss from 60+ years ago, and it's always positive because the minimum is also taken over $Y^i$, so $E(W,Y^i,X^i)-\min_{Y\in\mathcal Y} E(W,Y,X^i)\geq E(W,Y^i,X^i)-E(W,Y^i,X^i)=0$. The same computation shows that it give exactly zero only when $Y^i$ is the correct answer.

This loss makes the energy of the correct answer small, and at the same time, makes the energy for all other answers as large as possible. However, this loss does not prevent the function from giving the same value to every incorrect answer $Y^i$, so in this sense, it is a bad loss function for non-linear systems. To improve this loss, we define the *most offending incorrect answer*. -->

60年以上前のパーセプトロンの損失と非常によく似ていて、最小値も $Y^i$ の上に取られるので、それは常に正です：$E(W,Y^i,X^i)-\min_{Y\in\mathcal Y} E(W,Y,X^i)\geq E(W,Y^i,X^i)-E(W,Y^i,X^i)=0$。同じ計算をすると、$Y^i$が正解のときだけ正確に0を与えることがわかります。

この損失は、正解のエネルギーを小さくすると同時に、他のすべての答えのエネルギーをできるだけ大きくします。しかし、この損失は、すべての不正解 $y^i$ に対して同じ値を与えることを妨げるものではないので、この意味では、非線形系にとっては悪い損失関数と言えます。この損失を改善するために、*最も問題となる不正解*という概念を定義します。


## Generalized Margin Loss

<!-- **Most offending incorrect answer**: discrete case
Let $Y$ be a discrete variable. Then for a training sample $(X^i,Y^i)$, the *most offending incorrect answer* $\bar Y^i$ is the answer that has the lowest energy among all possible answers that are incorrect: -->

**最も問題となる不正解**：離散的な場合

$y$ を離散変数とします。すると、ある訓練サンプル $(X^i,Y^i)$ に対して、*最も問題となる不正解* $\bar Y^i$ は、不正解となる可能性のあるすべての答えの中で、最も低いエネルギーを持つ答えです。すなわち、

$$
\bar Y^i=\text{argmin}_{y\in \mathcal Y\text{ and }Y\neq Y^i} E(W, Y,X^i)
$$

<!-- **Most offending incorrect answer**: continuous case
Let $Y$ be a continuous variable. Then for a training sample $(X^i,Y^i)$, the *most offending incorrect answer* $\bar Y^i$ is the answer that has the lowest energy among all answers that are at least $\epsilon$ away from the correct answer: -->

**最も問題となる不正解**：連続的な場合

$y$を連続変数とします。すると、ある訓練サンプル$(X^i,Y^i)$に対して、*最も問題となる不正解* $\bar Y^i$は、正解から少なくとも$\epsilon$離れているすべての答えの中で、最も低いエネルギーを持っている答えです。つまり

$$
\bar Y^i=\text{argmin}_{Y\in \mathcal Y\text{ and }\|Y-Y^i\|>\epsilon} E(W,Y,X^i)
$$

<!-- In the discrete case, the *most offending incorrect answer* is the one with smallest energy that isn't the correct answer. In the continuous case, the energy for $Y$ extremely close to $Y^i$ should be close to $E(W,Y^i,X^i)$. Furthermore, the $\text{argmin}$ evaluated over $Y$ not equal to $Y^i$ would be 0. As a result, we pick a distance $\epsilon$ and decide that only $Y$'s at least $\epsilon$ from $Y_i$ should be considered the "incorrect answer". This is why the optimization is only over $Y$'s of distance at least $\epsilon$ from $Y^i$.

If the energy function is able to ensure that the energy of the *most offending incorrect answer* is higher than the energy of the correct answer by some margin, then this energy function should work well. -->

離散的なケースでは、*最も問題となる不正解*は、正解ではないエネルギーが最も小さいものです。連続の場合、 $Y$ が $Y^i$ に極端に近い場合のエネルギーは、 $E(W,Y^i,X^i)$ に近いはずです。さらに、$Y^i$と等しくない$Y$の$\text{argmin}$は0になります。 その結果、ある距離$\epsilon$に対して、$Y^i$から少なくとも$\epsilon$だけ離れた$Y$を「不正解」とすることにします。そのため、最適化は $Y^i$ から少なくとも$\epsilon$離れた $Y$についてだけ行われます。

もし、*最も問題となる不正解*のエネルギーが正解のエネルギーよりも高いことを、エネルギー関数が保証できるならば、このエネルギー関数はうまく機能するはずです。


<!-- ## Examples of Generalized Margin Loss Functions -->
## Generalized Margin Loss Functionsの例


<!-- ### Hinge Loss -->
### ヒンジ損失

$$
L_{\text{hinge}}(W,Y^i,X^i)=( m + E(W,Y^i,X^i) - E(W,\bar Y^i,X^i) )^+
$$
<!--
Where $\bar Y^i$ is the *most offending incorrect answer*. This loss enforces that the difference between the correct answer and the most offending incorrect answer be at least $m$. -->
ここで、$\bar Y^i$は、*最も問題のある不正解*です。この損失は、正解と最も問題のある不正解の差が少なくとも$m$であることを要請します。

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-2/hinge.png" width="60%"/><br>
<b>Fig. 4</b>: Hinge Loss
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-2/hinge.png" width="60%"/><br>
<b>図4</b>: ヒンジ損失
</center>

<!-- Q: How do you pick $m$?

A: It's arbitrary, but it affects the weights of the last layer. -->

Ｑ：どのようにして $m$ を選ぶのですか？

A: 任意ですが、最後の層の重みに影響します。


### Log Loss

$$
L_{\log}(W,Y^i,X^i)=\log(1+e^{E(W,Y^i,X^i)-E(W,\bar Y^i,X^i)})
$$

<!-- This can be thought of as a "soft" hinge loss. Instead of composing the difference of the correct answer and the most offending incorrect answer with a hinge, it's now composed with a soft hinge. This loss tries to enforce an "infinite margin", but because of the exponential decay of the slope it doesn't happen. -->
これは、「ソフト」ヒンジ損失と考えることができます。正解と最も問題のある不正解の差をヒンジで構成するのではなく、ソフトヒンジで構成するようになっています。この損失は「無限のマージン」を強制しようとしますが、傾きが指数関数的に減衰するため、それは起こりません。

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-2/log.png" width="60%"/><br>
<b>Fig. 5</b>: Log Loss
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-2/log.png" width="60%"/><br>
<b>図5</b>: 対数損失
</center>


### Square-Square Loss

$$
L_{sq-sq}(W,Y^i,X^i)=E(W,Y^i,X^i)^2+(\max(0,m-E(W,\bar Y^i,X^i)))^2
$$

<!-- This loss combines the square of the energy with a square hinge. The combination tries to minimize the energy and but enforce margin at least $m$ on the most offending incorrect answer. This is very similar to the loss used in Siamese nets. -->
この損失は、ヒンジの二乗とエネルギーの二乗を組み合わせたものです。この組み合わされたものは、エネルギーを最小化しようとしますが、最も問題のある不正解に対しては、少なくとも$m$のマージンを強制します。これは、Siamese netで使用される損失に非常に似ています。


## Other Losses

<!-- There are a whole bunch. Here is a summary of good and bad loss functions. -->
全体をまとめたものです。良い損失関数と悪い損失関数をまとめてみました。

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-2/other.png" width="100%" style="background-color:white;"/><br>
<b>Fig. 6</b>: Selection of EBM loss functions
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-2/other.png" width="100%" style="background-color:white;"/><br>
<b>図6</b>: EBM損失関数の選択
</center>

<!-- The right-hand column indicates if the energy function enforces a margin. The plain old energy loss does not push up anywhere, so it doesn't have a margin. The energy loss doesn't work for every problem. The perceptron loss works if you have a linear parametrisation of your energy but not in general. Some of them have a finite margin like the hinge loss, and some have an infinite margin like the soft hinge.

Q: How is the most offending incorrect answer found $\bar Y_i$ found in the continuous case?

A: You want to push up on a point that is sufficiently far from $Y^i$, because if it's too close, the parameters may not move much since the function defined by a neural net is "stiff". But in general, this is hard and this is the problem that methods selecting contrastive samples try to solve. There's no single correct way to do it.

A slightly more general form for hinge type contrastive losses is: -->


右辺は、エネルギー関数がマージンを強制するかどうかを示しています。昔ながらのエネルギー損失は、どこも押し上げないので、マージンがありません。エネルギー損失はすべての問題に適用できるわけではありません。パーセプトロン損失はエネルギーの線形なパラメトリゼーションの部分がある場合には有効ですが、一般的には有効ではありません。ヒンジ損失のように有限のマージンを持つものもあれば、ソフトヒンジのように無限のマージンを持つものもあります。

Q: 連続の場合に最も問題となる不正解 $\bar Y_i$ はどのようにして見つかるのでしょうか？

A: 近すぎるとニューラルネットで定義された関数が動きづらいので、パラメータがあまり動かないかもしれないため、$Y^i$から十分に離れた点を押し上げたいと考えます。しかし、一般的には、これは難しい問題であり、対照的なサンプルを選択する方法が解決しようとする問題です。これには一つの正しい方法はありません。

$$
L(W,X^i,Y^i)=\sum_y H(E(W, Y^i,X^i)-E(W,y,X^i)+C(Y^i,y))
$$

<!-- We assume that $Y$ is discrete, but if it were continuous, the sum would be replaced by an integral. Here, $E(W, Y^i,X^i)-E(W,y,X^i)$ is the difference of $E$ evaluated at the correct answer and some other answer. $C(Y^i,y)$ is the margin, and is generally a distance measure between $Y^i$ and $y$. The motivation is that the amount we want to push up on a incorrect sample $y$ should depend on the distance between $y$ and the correct sample $Y_i$. This can be a more difficult loss to optimize. -->

ここでは、 $y$ が離散的であると仮定しますが、もし連続的であれば、和は積分に置き換えられます。ここで、 $E(W, Y^i,X^i)-E(W,y,X^i)$は、正解と他の答えで評価された$E$の差です。$C(Y^i,y)$はマージンで、一般的には$y^i$と$y$の間の距離の尺度です。モチベーションは、不正解サンプル $y$ で押し上げたい量は、 $y$ と正解サンプル $y_i$ の間の距離に依存しているはずだということです。これは、最適化するのがより困難な損失になる可能性があります。
