---
lang-ref: ch.11-1
lecturer: Yann LeCun
title: Activation and loss functions (part 1)
authors: Haochen Wang, Eunkyung An, Ying Jin, Ningyuan Huang
date: 13 April 2020
lang: ja
translation-date: 6 Dec 2020
translator: Shiro Takagi
---


<!-- ## [Activation functions](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=15s) -->
## [活性化関数](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=15s)

<!-- In today's lecture, we will review some important activation functions and their implementations in PyTorch. They came from various papers claiming these functions work better for specific problems. -->
本日の講義では、重要な活性化関数とそのPyTorchでの実装を見ていきます。これらの活性化関数は、特定の問題に対してより良い働きをすると主張する様々な論文から提案されているものです。


### ReLU - `nn.ReLU()`

$$
\text{ReLU}(x) = (x)^{+} = \max(0,x)
$$

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/ReLU.png" height="400px" /><br>
<b>Fig. 1</b>: ReLU
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-1/ReLU.png" height="400px" /><br>
<b>図1</b>: ReLU
</center>


### RReLU - `nn.RReLU()`

<!-- There are variations in ReLU. The Random ReLU (RReLU) is defined as follows. -->
ReLUには様々亜種があります。Random ReLU (RReLU) は以下のように定義されます。

$$
\text{RReLU}(x) = \begin{cases}
      x, & \text{if $x \geq 0$}\\
      ax, & \text{otherwise}
    \end{cases}
$$

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/RRelU.png" width="700" /><br>
<b>Fig. 2</b>: ReLU, Leaky ReLU/PReLU, RReLU
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-1/RRelU.png" width="700" /><br>
<b>図2</b>: ReLU, Leaky ReLU/PReLU, RReLU
</center>

<!-- Note that for RReLU, $a$ is a random variable that keeps samplings in a given range during training, and remains fixed during testing. For PReLU , $a$ is also learned. For Leaky ReLU, $a$ is fixed. -->
RReLUでは、$a$は、学習中にサンプリングを所定の範囲に保つランダム変数であること、そしてテスト中は固定されたままにされることに注意してください。PReLUでは、$a$も学習されます。Leaky ReLUでは、$a$は固定されています。


### LeakyReLU - `nn.LeakyReLU()`

$$
\text{LeakyReLU}(x) = \begin{cases}
      x, & \text{if $x \geq 0$}\\
      a_\text{negative slope}x, & \text{otherwise}
    \end{cases}
$$

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/LeakyReLU.png" height="400px" /><br>
<b>Fig. 3</b>: LeakyReLU
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-1/LeakyReLU.png" height="400px" /><br>
<b>図3</b>: LeakyReLU
</center>

<!-- Here $a$ is a fixed parameter. The bottom part of the equation prevents the problem of dying ReLU which refers to the problem when ReLU neurons become inactive and only output 0 for any input. Therefore, its gradient is 0. By using a negative slope, it allows the network to propagate back and learn something useful. -->
ここで、$a$は固定パラメータです。この方程式の一番下の部分は、ReLUニューロンが不活性化することでどのような入力に対しても0しか出力しなくなる問題である、ReLUの死滅の問題を防ぎます。負の傾きを使用することで、ネットワークが勾配を伝搬できるようになり、有用なものを学習することができます。


<!-- LeakyReLU is necessary for skinny network, which is almost impossible to get gradients flowing back with vanilla ReLU. With LeakyReLU, the network can still have gradients even we are in the region where everything is zero out. -->
LeakyReLUは、通常のReLUでは勾配を伝播することがほとんど不可能な狭いニューラルネットに必要です。LeakyReLUを使えば、すべてがゼロになってしまっている領域にいても、ネットワークは勾配を保持することができます。

### PReLU - `nn.PReLU()`

$$
\text{PReLU}(x) = \begin{cases}
      x, & \text{if $x \geq 0$}\\
      ax, & \text{otherwise}
    \end{cases}
$$

<!-- Here $a$ is a learnable parameter. -->
ここで $a$ は学習可能なパラメータです。

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/PReLU.png" height="400px" /><br>
<b>Fig. 4</b>: ReLU
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-1/PReLU.png" height="400px" /><br>
<b>図4</b>: ReLU
</center>

<!-- The above activation functions (i.e. ReLU, LeakyReLU, PReLU) are scale-invariant. -->
上記の活性化関数（すなわち、ReLU、LeakyReLU、PReLU）は、スケール不変です。


### Softplus - `Softplus()`

$$
\text{Softplus}(x) = \frac{1}{\beta} * \log(1 + \exp(\beta * x))
$$

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/Softplus.png" height="400px" /><br>
<b>Fig. 5</b>: Softplus
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-1/Softplus.png" height="400px" /><br>
<b>図5</b>: Softplus
</center>

<!-- Softplus is a smooth approximation to the ReLU function and can be used to constrain the output of a machine to always be positive. -->
SoftplusはReLU関数の滑らかな近似であって、出力が常に正であるように制約を加えるために使うことができます。

<!-- The function will become more like ReLU, if the $\beta$ gets larger and larger. -->
この関数は、$\beta$がどんどん大きくなっていくと、ReLUに近づいていきます。


### ELU - `nn.ELU()`

$$
\text{ELU}(x) = \max(0, x) + \min(0, \alpha * (\exp(x) - 1)
$$

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/ELU.png" height="400px" /><br>
<b>Fig. 6</b>: ELU
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-1/ELU.png" height="400px" /><br>
<b>図6</b>: ELU
</center>

<!-- Unlike ReLU, it can go below 0 which allows the system to have average output to be zero. Therefore, the model may converge faster. And its variations (CELU, SELU) are just different parametrizations. -->
ReLUとは異なり、0より小さな値を出力できるので、平均出力をゼロにすることを可能になります。したがって、モデルはより速く収束するかもしれません。そして、そのバリエーション(CELU, SELU)は、単にパラメトリゼーションが異なるだけです。


### CELU - `nn.CELU()`

$$
\text{CELU}(x) = \max(0, x) + \min(0, \alpha * (\exp(x/\alpha) - 1)
$$

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/CELU.png" height="400px" /><br>
<b>Fig. 7</b>: CELU
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-1/CELU.png" height="400px" /><br>
<b>図7</b>: CELU
</center>


### SELU - `nn.SELU()`

$$
\text{SELU}(x) = \text{scale} * (\max(0, x) + \min(0, \alpha * (\exp(x) - 1))
$$

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/SELU.png" height="400px" /><br>
<b>Fig. 8</b>: SELU
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-1/SELU.png" height="400px" /><br>
<b>図8</b>: SELU
</center>


### GELU - `nn.GELU()`

$$
\text{GELU(x)} = x * \Phi(x)
$$

<!-- where $\Phi(x)$ is the Cumulative Distribution Function for Gaussian Distribution. -->
ただし$\Phi(x)$ はガウス分布の累積分布関数です。

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/GELU.png" height="400px" /><br>
<b>Fig. 9</b>: GELU
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-1/GELU.png" height="400px" /><br>
<b>図9</b>: GELU
</center>


### ReLU6 - `nn.ReLU6()`

$$
\text{ReLU6}(x) = \min(\max(0,x),6)
$$

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/ReLU6.png" height="400px" /><br>
<b>Fig. 10</b>: ReLU6
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-1/ReLU6.png" height="400px" /><br>
<b>図10</b>: ReLU6
</center>

<!-- This is ReLU saturating at 6. But there is no particular reason why picking 6 as saturation, so we can do better by using Sigmoid function below. -->
これはReLUが6で飽和していることを示していますが、6を飽和とする理由は特にありませんので、以下のSigmoid関数を利用することで、より良い結果が得られます。

### Sigmoid - `nn.Sigmoid()`

$$
\text{Sigmoid}(x) = \sigma(x) = \frac{1}{1 + \exp(-x)}
$$

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/Sigmoid.png" height="400px" /><br>
<b>Fig. 11</b>: Sigmoid
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-1/Sigmoid.png" height="400px" /><br>
<b>図11</b>: Sigmoid
</center>
<!-- 
If we stack sigmoids in many layers, it may be inefficient for the system to learn and requires careful initialization. This is because if the input is very large or small, the gradient of the sigmoid function is close to 0. In this case, there is no gradient flowing back to update the parameters, known as saturating gradient problem. Therefore, for deep neural networks, a single kink function (such as ReLU) is preferred. -->
シグモイドを何層にも重ねると、学習効率が悪くなることがあり、慎重な初期化が必要になります。これは、入力が非常に大きかったり小さかったりすると、シグモイド関数の勾配が0に近くなるからで、この場合、パラメータを更新するための勾配が流れません。これは勾配の飽和として知られています。したがって、ディープニューラルネットワークでは、単一のキンク関数（ReLUなど）が好ましいです。


### Tanh - `nn.Tanh()`

$$
\text{Tanh}(x) = \tanh(x) = \frac{\exp(x) - \exp(-x)}{\exp(x) + \exp(-x)}
$$

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/Tanh.png" height="400px" /><br>
<b>Fig. 12</b>: Tanh
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-1/Tanh.png" height="400px" /><br>
<b>図12</b>: Tanh
</center>

<!-- Tanh is basically identical to Sigmoid except it is centred, ranging from -1 to 1. The output of the function will have roughly zero mean. Therefore, the model will converge faster.  Note that convergence is usually faster if the average of each input variable is close to zero. One example is Batch Normalization. -->
Tanhは、-1から1までの範囲で、中心化されていることを除いて、Sigmoidと基本的に同じです。 関数の出力は、ほぼ平均ゼロです。したがって、モデルはより速く収束します。 各入力変数の平均がゼロに近い場合、収束は通常より速くなることに注意してください。例えば、バッチ正規化は同様の理由で学習を高速化します。

### Softsign - `nn.Softsign()`

$$
\text{SoftSign}(x) = \frac{x}{1 + |x|}
$$

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/Softsign.png" height="400px" /><br>
<b>Fig. 13</b>: Softsign
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-1/Softsign.png" height="400px" /><br>
<b>図13</b>: Softsign
</center>

<!-- It is similar to the Sigmoid function but gets to the asymptote slowly and alleviate the gradient vanishing problem (to some extent). -->
これはSigmoid関数に似ていますが、漸近点への到達が遅く、勾配消失問題を緩和します(ある程度)。


### Hardtanh - `nn.Hardtanh()`

$$
\text{HardTanh}(x) = \begin{cases}
      1, & \text{if $x > 1$}\\
      -1, & \text{if $x < -1$}\\
      x, & \text{otherwise}
\end{cases}
$$

<!-- The range of the linear region [-1, 1] can be adjusted using `min_val` and `max_val`. -->
線形の範囲である [-1, 1] は `min_val` と `max_val`で調節できます。

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/Hardtanh.png" height="400px" /><br>
<b>Fig. 14</b>: Hardtanh
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-1/Hardtanh.png" height="400px" /><br>
<b>図14</b>: Hardtanh
</center>

<!-- It works surprisingly well especially when weights are kept within the small value range. -->
重みが小さな値の範囲に収まっている時に、驚くほどうまくいきます。


### Threshold - `nn.Threshold()`

$$
  y = \begin{cases}
      x, & \text{if $x > \text{threshold}$}\\
      v, & \text{otherwise}
    \end{cases}
$$

<!-- It is rarely used because we cannot propagate the gradient back. And it is also the reason preventing people from using back-propagation in 60s and 70s when they were using binary neurons. -->
勾配を逆伝播できないので、ほとんど用いられません。 そしてこれは、60年代、70年代にバイナリーニューロンを使っていた時代に誤差逆伝播法を使うことを妨げていた理由でもあります。


### Tanhshrink - `nn.Tanhshrink()`

$$
\text{Tanhshrink}(x) = x - \tanh(x)
$$

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/Tanhshrink.png" height="400px" /><br>
<b>Fig. 15</b>: Tanhshrink
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-1/Tanhshrink.png" height="400px" /><br>
<b>図15</b>: Tanhshrink
</center>

<!-- It is rarely used except for sparse coding to compute the value of the latent variable. -->
潜在変数の値を計算するためのスパース符号化以外では、ほとんど使用されません。


### Softshrink - `nn.Softshrink()`

$$
  \text{SoftShrinkage}(x) = \begin{cases}
      x - \lambda, & \text{if $x > \lambda$}\\
      x + \lambda, & \text{if $x < -\lambda$}\\
      0, & \text{otherwise}
    \end{cases}
$$

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/Softshrink.png" height="400px" /><br>
<b>Fig. 16</b>: Softshrink
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-1/Softshrink.png" height="400px" /><br>
<b>図16</b>: Softshrink
</center>

<!-- This basically shrinks the variable by a constant towards 0, and forces to 0 if the variable is close to 0. You can think of it as a step of gradient for the $\ell_1$ criteria. It is also one of the step of the Iterative Shrinkage-Thresholding Algorithm (ISTA). But it is not commonly used in standard neural network as activations. -->
基本的に変数を0に向かって一定数だけ収縮させ、変数が0に近い場合は0にします。 これは、$\ell_1$基準の勾配のステップと考えることができます。またこれは、反復的収縮-閾値調整アルゴリズム(ISTA)のステップの一つでもあります。しかし、標準的なニューラルネットワークでは活性化関数としてはあまり使われていません。


### Hardshrink - `nn.Hardshrink()`

$$
  \text{HardShrinkage}(x) = \begin{cases}
      x, & \text{if $x > \lambda$}\\
      x, & \text{if $x < -\lambda$}\\
      0, & \text{otherwise}
    \end{cases}
$$

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/Hardshrink.png" height="400px" /><br>
<b>Fig. 17</b>: Hardshrink
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-1/Hardshrink.png" height="400px" /><br>
<b>図17</b>: Hardshrink
</center>

<!-- It is rarely used except for sparse coding. -->
スパース符号化以外では、ほとんど使用されません。


### LogSigmoid - `nn.LogSigmoid()`

$$
\text{LogSigmoid}(x) = \log\left(\frac{1}{1 + \exp(-x)}\right)
$$

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/LogSigmoid.png" height="400px" /><br>
<b>Fig. 18</b>: LogSigmoid
</center> -->
<center>
<img src="{{site.baseurl}}/images/week11/11-1/LogSigmoid.png" height="400px" /><br>
<b>図18</b>: LogSigmoid
</center>

<!-- It is mostly used in the loss function but not common for activations. -->
ほとんどの場合損失関数で用いられますが、活性化関数としては一般的ではありません。

### Softmin - `nn.Softmin()`

$$
\text{Softmin}(x_i) = \frac{\exp(-x_i)}{\sum_j \exp(-x_j)}
$$

<!-- It turns numbers into a probability distribution. -->
数を確率分布に変えてくれます。


### Soft(arg)max - `nn.Softmax()`

$$
\text{Softmax}(x_i) = \frac{\exp(x_i)}{\sum_j \exp(x_j)}
$$


### LogSoft(arg)max - `nn.LogSoftmax()`

$$
\text{LogSoftmax}(x_i) = \log\left(\frac{\exp(x_i)}{\sum_j \exp(x_j)}\right)
$$

<!-- It is mostly used in the loss function but not common for activations. -->
損失関数ではほとんど使われていますが、活性化関数として使うのは一般的ではありません。


## [Q&A activation functions](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=861s)


### `nn.PReLU()` related questions

<!-- - Why would we want the same value of $a$ for all channels?

  > Different channels could have different $a$. You could use $a$ as a parameter of every unit. It could be shared as a feature map as well. -->

- なぜ、すべてのチャンネルで同じ値の $a$ が必要なのでしょうか?

  > チャンネルによって 異なる$a$ の値を持たせることもできます。各ユニットのパラメータとして $a$ を使用することができます。それを特徴マップとして共有することもできます。

<!-- - Do we learn $a$? Is learning $a$ advantageous?

  > You can learn $a$ or fix it.
  > The reason for fixing is to ensure that nonlinearity gives you a non-zero gradient even if it's in a negative region.
  > Making $a$ learnable allows the system to turn nonlinearity into either linear mapping or full rectification. It could be useful for some applications like implementing an edge detector regardless of the edge polarity. -->

- $a$は学習するんですか？ $a$を学習することのメリットはなんなのでしょうか？

  > $a$は学習するか、固定するかのどちらかです。
  > 固定する理由は、非線形性が負の領域にあっても、非線形性がゼロではない勾配を与えるようにするためです。
  > 学習可能な$a$にすることで、非線形性を線形写像か完全に修正可能かのどちらかに変えることができるようになります。これは、エッジの極に関係なくエッジ検出器を実装するようないくつかの応用に有用かもしれません。

<!-- - How complex do you want your non-linearity to be?

  > Theoretically, we can parametrise an entire nonlinear function in very complicated way, such as with spring parameters, Chebyshev polynomial, etc. Parametrising could be a part of learning process. -->

- 非線形性はどのくらい複雑にするのが望ましいのですか？

  > 理論的には、非線形関数全体を非常に複雑な方法でパラメトライズすることができます。例えば、spring parameterやチェビシェフ多項式などです。パラメトリゼーションは学習過程の一部になるかもしれません。
<!-- TODO: Dont know what spring parameter is-->

<!-- - What is an advantage of parametrising over having more units in your system?

  > It really depends on what you want to do. For example, when doing regression in a low dimensional space, parametrisation might help. However, if your task is in under a high dimensional space such as image recognition, just "a" nonlinearity is necessary and monotonic nonlinearity will work better.
  > In short, you can parametrize any functions you want but it doesn't bring a huge advantage. -->

- パラメトライズすることは、ユニットを増やすよりも何かメリットはありますか？

  > それは実際あなたが何をしたいかに依存します。例えば、低次元空間で回帰を行う場合、パラメトライゼーションは役立つかもしれません。しかし、あなたのタスクが画像認識のように高次元空間で行うものである場合は、ただ単に「ある」非線形性が必要なだけであって、単調な非線形性の方がうまくいくでしょう。
  > 要するに、好きな関数をパラメトライズすることはできますが、大きな利点はありません。


<!-- ### Kink related questions -->
### Kinkに関する質問

<!-- - One kink versus double kink

  > Double kink is a built-in scale in it. This means that if the input layer is multiplied by two (or the signal amplitude is multiplied by two), then outputs will be completely different. The signal will be more in nonlinearity, thus you will get a completely different behaviour of the output. Whereas, if you have a function with only one kink, if you multiply the input by two, then your output will be also multiplied by two. -->

- 一つのkinkと二つのkink

  > ダブルキンクは、その中にスケールが組み込まれています。これは、入力層が2倍（または信号の振幅が2倍）になると、出力が全く異なるものになることを意味します。信号は非線形性が高くなりますので、出力は全く異なる挙動になります。一方、キンクが1つだけの関数を持っている場合、入力を2倍にすると、出力も2倍になります。

<!-- - Differences between a nonlinear activation having kinks and a smooth nonlinear activation. Why/when one of them is preferred?

  > It is a matter of scale equivariance. If kink is hard, you multiply the input by two and the output is multiplied by two. If you have a smooth transition, for example, if you multiply the input by 100, the output looks like you have a hard kink because the smooth part is shrunk by a factor of 100. If you divide the input by 100, the kink becomes a very smooth convex function. Thus, by changing the scale of the input, you change the behaviour of the activation unit.

  > Sometimes this could be a problem. For example, when you train a multi-layer neural net and you have two layers that are one after the other. You do not have a good control for how big the weights of one layer is relative to the other layer's weights. If you have nonlinearity that cares about scales, your network doesn't have a choice of what size of weight matrix can be used in the first layer because this will completely change the behaviour.

  > One way to fix this problem is setting a hard scale on the weights of every layer so you can normalise the weights of layers, such as batch normalisation. Thus, the variance that goes into a unit becomes always constant. If you fix the scale, then the system doesn't have any way of choosing which part of the nonlinearity will be using in two kink function systems. This could be a problem if this 'fixed' part becomes too 'linear'. For example, Sigmoid becomes almost linear near zero, and thus batch normalisation outputs (close to 0) could not be activated 'non-linearly'.
  >
  > It is not entirely clear why deep networks work better with single kink functions. It's probably due to the scale equivariance property. -->


- キンクを持つ非線形活性化と平滑な非線形活性化の違いについてです。なぜ、あるいはいつ、どちらか一方が好ましくなりますか？

  > それはスケール等価性の問題です。キンクが鋭い場合は、入力に2を掛けて、出力に2を掛けます。例えば、滑らかな遷移がある場合、入力を100倍にすると、滑らかな部分が100倍に縮小されているので、出力は鋭いキンクがあるように見えます。入力を100で割ると、キンクは非常に滑らかな凸関数になります。このように、入力のスケールを変えることで、活性化ユニットの振る舞いを変えることができます。

  > 時々、これが問題になることがあります。例えば、2つ続きの層がある多層ニューラルネットを訓練する場合です。一方の層の重みが他方の層の重みに対してどのくらい大きいかをうまく制御できません。スケールを気にする非線形関数を使っている場合、あなたのネットワークは、最初の層で使用できる重み行列の大きさを選択することができません。なぜなら、スケールの変化が挙動を大きく変えてしまうからです。

  > この問題を解決する一つの方法は、各層の重みに厳密にスケールを設定することです。これによってバッチ正規化のように層の重みを正規化することができます。そうすれば、ユニットに入る分散は常に一定になります。スケールを固定すると、2つのキンク関数で非線形性のどの部分を使用するかを選択する手段を持ちません。この「固定」された部分があまりにも「線形」になってしまうと問題になる可能性があります。例えば、シグモイドはゼロ付近でほぼ線形になり、そのためバッチ正規化の出力（0に近い）は「非線形に」活性化することができないかもしれません。
  >
  > なぜディープネットワークが単一のキンク関数でよりよく機能するのかは、完全には明らかではありません。これは、スケール等価性に起因すると思われます。


<!-- ### Temperature coefficient in a soft(arg)max function -->
### soft(arg)max関数の温度係数

<!-- - When do we use the temperature coefficient and why do we use it?

  > To some extent, the temperature is redundant with incoming weights. If you have weighted sums coming into your softmax, the $\beta$ parameter is redundant with the size of weights.

  > Temperature controls how hard the distribution of output will be. When $\beta$ is very large, it becomes very close to either one or zero. When $\beta$ is small, it is softer. When the limit of $\beta$ equals to zero, it is like an average. When $\beta$ goes infinity, it behaves like argmax. It's no longer its soft version. Thus, if you have some sort of normalisation before the softmax then, tuning this parameter allows you to control the hardness.
  > Sometimes, you can start with a small $\beta$ so that you can have well-behaved gradient descents and then, as running proceeds, if you want a harder decision in your attention mechanism, you increase $\beta$. Thus, you can sharpen the decisions. This trick is called as annealing. It can be useful for a mixture of experts like a self attention mechanism. -->

- 温度係数はいつ、なぜ使うのでしょうか？

  > ある程度、温度は入ってくる重みと重複しています。softmaxに重み付けされた和が入ってくる場合、パラメータ$\beta$は重みの大きさと重複しています。

  > 温度は、出力の分布がどれだけ鋭くなるかを制御します。もし $\beta$ がとても大きいと、ゼロか１に近づきます。小さくなると、滑らかになります。$\beta$の極限が０になると、平均値のようになります。もし $\beta$ が無限大になると、argmax関数のように振る舞います。これはもはやsoftmaxではありません。したがって、softmaxの前にある種の正規化があるならば、このパラメータを調整することで、どれだけargmaxに近づくかをコントロールすることができます。
  > 時には、小さな$\beta$から始めることができます。そうすれば、うまく勾配降下法を行うことができます。もしattention機構においてはっきりと決定をしたい場合には、温度をあげます。そうすることで、判断を鋭くすることができます。このトリックは、アニーリングと呼ばれています。self-attention機構のようなmixture of expertsシステムでは有効です。


<!-- ## [Loss functions](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=1990s) -->
## [損失関数](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=1990s)

<!-- PyTorch also has a lot of loss functions implemented. Here we will go through some of them. -->
PyTorchには多くの損失関数も実装されています。ここではそのうちのいくつかを見ていきましょう。


### `nn.MSELoss()`

<!-- This function gives the mean squared error (squared L2 norm) between each element in the input $x$ and target $y$. It is also called L2 loss.

If we are using a minibatch of $n$ samples, then there are $n$ losses, one for each sample in the batch. We can tell the loss function to keep that loss as a vector or to reduce it.

If unreduced (i.e. set `reduction='none'`), the loss is -->

この関数は、入力$x$とターゲット$y$の各要素間の平均二乗誤差(L2ノルムの二乗)を与えます。これはL2損失とも呼ばれます。

サンプル数が $n$ のミニバッチを使用している場合、バッチ内の各サンプルに対して $n$ の損失があります。損失関数には、この損失をベクトルとして保持させるか、あるいは次元を削減するようにして保持させることができます。

次元が削減されていない場合（つまり、`reduction='none'`を設定している場合）、損失は

$$l(x,y) = L = \{l_1, \dots, l_N\}^\top, l_n = (x_n - y_n)^2$$

<!-- where $N$ is the batch size, $x$ and $y$ are tensors of arbitrary shapes with a total of n elements each. -->
となります。ここで、$n$はバッチサイズ、$x$と$y$は、それぞれ合計n個の要素を持つ任意のシェイプのテンソルです。

<!-- The reduction options are below (note that the default value is `reduction='mean'`). -->
次元削減オプションは以下の通りです（デフォルト値は `reduction='mean'` であることに注意してください）。

$$l(x,y) = \begin{cases}\text{mean}(L), \quad &\text{if reduction='mean'}\\
\text{sum}(L), \quad &\text{if reduction='sum'}
\end{cases}$$

<!-- The sum operation still operates over all the elements, and divides by $n$.

The division by $n$ can be avoided if one sets ``reduction = 'sum'``. -->
和はすべての要素を対象とし、$n$で割ります。

$n$による割り算は、 ``reduction = 'sum'``を設定すれば回避できます。


### `nn.L1Loss()`

<!-- This measures the mean absolute error (MAE) between each element in the input $x$ and target $y$ (or the actual output and desired output).

If unreduced (i.e. set `reduction='none'`), the loss is

$$l(x,y) = L = \{l_1, \dots, l_N\}^\top, l_n = \vert x_n - y_n\vert$$

, where $N$ is the batch size, $x$ and $y$ are tensors of arbitrary shapes with a total of n elements each.

It also has `reduction` option of `'mean'` and `'sum'` similar to what `nn.MSELoss()` have. -->

これは、入力 $x$ とターゲット $y$ (または実際の出力と希望する出力) の各要素間の平均絶対誤差 (MAE) を測定します。

次元削減されていない場合 (つまり、`reduction='none'`を設定している場合)、損失は次のようになります。

$$l(x,y) = L = \{l_1, \dots, l_N\}^\top, l_n = \vert x_n - y_n\vert$$

ここで、 $N$ はバッチサイズ、$x$ と $y$ はそれぞれ n 個の要素を持つ任意の形状のテンソルです。

また、`nn.MSELoss()` と同様に `'mean'` と `'sum'` の `reduction` オプションを持ちます。
<!-- 
**Use Case:** L1 loss is more robust against outliers and noise compared to L2 loss. In L2 the errors of those outlier/noisy points are squared, so the cost function gets very sensitive to outliers.

**Problem:** The L1 loss is not differentiable at the bottom (0). We need to be careful when handling its gradients (namely Softshrink). This motivates the following SmoothL1Loss. -->

**使用例：** L1損失は、L2損失に比べて、外れ値やノイズに対してよりロバストです。L2では、外れ値やノイズのある点の誤差が2乗されるため、コスト関数は外れ値に対して非常に敏感になります。

**問題点:**　L1損失は底辺（0）のところでは微分できません。したがって、勾配を扱う際には注意が必要です（すなわち、Softshrink）。これが次のSmoothL1Lossを考える動機となっています。


### `nn.SmoothL1Loss()`

<!-- This function uses L2 loss if the absolute element-wise error falls below 1 and L1 loss otherwise.

$$\text{loss}(x, y) = \frac{1}{n} \sum_i z_i$$
, where $z_i$ is given by

$$z_i = \begin{cases}0.5(x_i-y_i)^2, \quad &\text{if } |x_i - y_i| < 1\\
|x_i - y_i| - 0.5, \quad &\text{otherwise}
\end{cases}$$

It also has `reduction` options.

This is advertised by Ross Girshick ([Fast R-CNN](https://arxiv.org/abs/1504.08083)). The Smooth L1 Loss is also known as the Huber Loss or  the Elastic Network when used as an objective function,.

**Use Case:** It is less sensitive to outliers than the `MSELoss` and is smooth at the bottom. This function is often used in computer vision for protecting against outliers.

**Problem:** This function has a scale ($0.5$ in the function above). -->

この関数は、要素間の絶対誤差が１以下の場合はＬ２損失、それ以外の場合はＬ1損失を使用します。

$$\text{loss}(x, y) = \frac{1}{n} \sum_i z_i$$
ここで、 $z_i$ は次式で与えられます。

$$z_i = \begin{cases}0.5(x_i-y_i)^2, \quad &\text{if } |x_i - y_i| < 1\\
|x_i - y_i| - 0.5, \quad &\text{otherwise}
\end{cases}$$

また、`reduction`のオプションもあります。

これは、Ross Girshick ([Fast R-CNN](https://arxiv.org/abs/1504.08083))によって宣伝されています。 Smooth L1 Lossは、Huber LossやElastic Networkとしても知られています。

**使用例:**　MSELossよりも外れ値の影響を受けにくく、底辺が滑らかです。コンピュータビジョンなどでは、外れ値からの保護のためによく使われています。

**問題点:**　この関数はスケール（上の関数では$0.5$）を持っています。


<!-- ### L1 vs. L2 for Computer Vision

In making predictions when we have a lot of different $y$'s:

* If we use MSE (L2 Loss), it results in an average of all $y$, which in CV it means we will have a blurry image.
* If we use L1 loss, the value $y$ that minimize the L1 distance is the medium, which is not blurry, but note that medium is difficult to define in multiple dimensions.

Using L1 results in sharper image for prediction. -->

### コンピュータビジョンのためのL1とL2の比較

多くの異なる $y$ がある場合の予測を行う際には

* MSE (L2損失) を用いた場合、すべての $y$ の平均値が得られ、CVではぼやけた画像が得られることを意味します。
* L1損失を利用する場合、L1距離を最小化する値 $y$ は、ぼやけていない中程度の値ですが、中程度は多次元で定義するのが難しいことに注意してください。

L1を使うと、予測のための画像がよりシャープになります。


### `nn.NLLLoss()`

<!-- It is the negative log likelihood loss used when training a classification problem with C classes.

Note that, mathematically, the input of `NLLLoss` should be (log) likelihoods, but PyTorch doesn't enforce that. So the effect is to make the desired component as large as possible.

The unreduced (i.e. with :attr:`reduction` set to ``'none'``) loss can be described as: -->

これはCクラスの分類問題を学習するときに使われる負の対数尤度損失です。

数学的には、`NLLLoss`の入力は(対数)尤度でなければなりませんが、PyTorchはそれを強制しません。そのため、望ましい成分を可能な限り大きくすることが効果的です。

次元削減されていない（つまり :attr:`reduction` が ``'none'`` に設定されている）損失は次のように記述できます。

$$\ell(x, y) = L = \{l_1,\dots,l_N\}^\top, \quad
        l_n = - w_{y_n} x_{n,y_n}, \quad
        w_{c} = \text{weight}[c] \cdot \mathbb{1}\{c \not= \text{ignore\_index}\}$$

<!-- ,where $N$ is the batch size. -->
ただし$N$はバッチサイズです。

<!-- If `reduction` is not ``'none'`` (default ``'mean'``), then -->
もし `reduction` が ``'none'`` でないばあい　(デフォルトでは ``'mean'`` です)　には、

$$\ell(x, y) = \begin{cases}
            \sum_{n=1}^N \frac{1}{\sum_{n=1}^N w_{y_n}} l_n, &
            \text{if reduction} = \text{'mean';}\\
            \sum_{n=1}^N l_n,  &
            \text{if reduction} = \text{'sum'.}
        \end{cases}$$

<!-- This loss function has an optional argument `weight` that can be passed in using a 1D Tensor assigning weight to each of the classes. This is useful when dealing with imbalanced training set. -->
この損失関数にはオプション引数の `weight` があり、各クラスに重みを割り当てる1次元テンソルとして渡すことができます。これは、不均衡な訓練データを扱う場合に便利です。


<!-- #### Weights & Imbalanced Classes: -->
#### 重みと不均衡クラス:

<!-- Weight vector is useful if the frequency is different for each category/class. For example, the frequency of the common flu is much higher than the lung cancer. We can simply increase the weight for categories that has small number of samples.

However, instead of setting the weight, it's better to equalize the frequency in training so that we can exploits stochastic gradients better.

To equalize the classes in training, we put samples of each class in a different buffer. Then generate each minibatch by picking the same number samples from each buffer. When the smaller buffer runs out of samples to use, we iterate through the smaller buffer from the beginning again until every sample of the larger class is used. This way gives us equal frequency for all categories by going through those circular buffers. We should never go the easy way to equalize frequency by **not** using all samples in the majority class. Don't leave data on the floor!

An obvious problem of the above method is that our NN model wouldn't know the relative frequency of the actual samples. To solve that, we fine-tune the system by running a few epochs at the end with the actual class frequency, so that the system adapts to the biases at the output layer to favour things that are more frequent.

To get an intuition of this scheme, let's go back to the medical school example: students spend just as much time on rare disease as they do on frequent diseases (or maybe even more time, since the rare diseases are often the more complex ones). They learn to adapt to the features of all of them, then correct it to know which are rare. -->

カテゴリー/クラスごとにデータの出現頻度が異なる場合は、重みベクトルが便利です。例えば、一般的なインフルエンザの頻度は肺がんよりもはるかに高いです。サンプル数が少ないカテゴリについては、単純に重みを増やすことができます。

しかし、確率的勾配をうまく利用するためには、重みを設定するよりも、訓練における出現頻度を均等化した方がよいでしょう．

学習中のクラスを均等化するには、各クラスのサンプルを別のバッファに入れます。そして、それぞれのバッファから同じ数のサンプルを選んでミニバッチを生成します。小さい方のバッファが使用するサンプルを使い切ったら、小さい方のバッファを最初から繰り返し、大きい方のクラスのサンプルがすべて使用されるまで繰り返します。このようにしてバッファのデータを用いることで、すべてのカテゴリで同じ頻度を得ることができます。大多数のクラスのすべてのサンプルを使用しないという安易な方法で出現頻度を均等化してはいけません。使わないデータを出さないようにしましょう！

上記の方法の明らかな問題は、NNモデルが実際のサンプルの相対的な出現頻度を知らないことです。これを解決するために、実際のクラスの出現頻度で最後に数回エポックを実行することで、システムを微調整します。

このスキームの直観を得るために、医学部の例に戻ってみましょう：学生は頻繁に起こる病気と同じくらい多くの時間を稀な病気に費やします（稀な病気の方が複雑な病気であることが多いので、もっと多くの時間を費やすかもしれません）。彼らは、それらのすべての特徴に適応することを学び、それを修正して、どれが稀な病気かを知ることを学びます。


### `nn.CrossEntropyLoss()`

<!-- This function combines `nn.LogSoftmax` and `nn.NLLLoss` in one single class. The combination of the two makes the score of the correct class as large as possible. -->

<!-- The reason why the two functions are merged here is for numerical stability of gradient computation. When the value after softmax is close to 1 or 0, the log of that can get close to 0 or $-\infty$. Slope of log close to 0 is close to $\infty$, causing the intermediate step in backpropagation to have numerical issues. When the two functions are combined, the gradients is saturated so we get a reasonable number at the end.

The input is expected to be unnormalised score for each class.

The loss can be described as: -->

この関数は `nn.LogSoftmax` と `nn.NLLLoss` を一つのクラスにまとめた物です。この2つを組み合わせることで、正しいクラスのスコアをできるだけ大きくすることができます。

ここで2つの関数を統合した理由は、勾配計算の数値的安定性を高めるためです。softmax以降の値が1や0に近づくと、その対数が0に近づくか、$-\infty$になることがあります。0に近い log の傾きは $\infty$ に近いので、バックプロパゲーションの途中で数値計算上の問題が発生してしまいます。2つの関数を組み合わせると、勾配が飽和するので、最後にはそれなりの数値が得られます。

入力は各クラスの正規化されていないスコアであることが想定されています。

損失は次のように記述することができます。

$$\text{loss}(x, c) = -\log\left(\frac{\exp(x[c])}{\sum_j \exp(x[j])}\right)
= -x[c] + \log\left(\sum_j \exp(x[j])\right)$$

<!-- or in the case of the `weight` argument being specified: -->
あるいは `weight` という引数が指定された場合には、

$$\text{loss}(x, c) = w[c] \left(-x[c] + \log\left(\sum_j\exp(x[j])\right)\right)$$

<!-- The losses are averaged across observations for each minibatch. -->
となります。この損失は各ミニバッチについての平均をとったものになっています。

<!-- A physical interpretation of the Cross Entropy Loss is related to the Kullback–Leibler divergence (KL divergence), where we are measuring the divergence between two distributions. Here, the (quasi) distributions are represented by the x vector (predictions) and the target distribution (a one-hot vector with 0 on the wrong classes and 1 on the right class). -->
クロスエントロピー損失の物理的な解釈は、2つの分布間のダイバージェンスを測るKullback-Leiblerダイバージェンス(KLダイバージェンス)に関連しています。ここでは、(準)分布はxベクトル(予測値)と目標分布(間違ったクラスに0、正しいクラスに1を持つワンホットベクトル)で表されます。

<!-- Mathematically, -->
数学的には、

$$H(p,q) = H(p) + \mathcal{D}_{KL} (p \mid\mid q)$$

<!-- where $$H(p,q) = - \sum_i p(x_i) \log (q(x_i))$$ is the cross-entropy (between two distributions), $$H(p) = - \sum_i p(x_i) \log (p(x_i))$$ is the entropy, and $$\mathcal{D}_{KL} (p \mid\mid q) = \sum_i p(x_i) \log \frac{p(x_i)}{q(x_i)}$$ is the KL divergence. -->
ただし$$H(p,q) = - \sum_i p(x_i) \log (q(x_i))$$ は(二つの分布の間の)クロスエントロピーで、 $$H(p) = - \sum_i p(x_i) \log (p(x_i))$$はエントロピーで、$$\mathcal{D}_{KL} (p \mid\mid q) = \sum_i p(x_i) \log \frac{p(x_i)}{q(x_i)}$$ は KLダイバージェンスです。

### `nn.AdaptiveLogSoftmaxWithLoss()`

<!-- This is an efficient softmax approximation of softmax for large number of classes (for example, millions of classes). It implements tricks to improve the speed of the computation. -->
これは大規模なクラス数（例えば数百万クラス）に対して効率的なソフトマックスの近似計算を行います。計算速度を向上させるためのトリックを実装しています。

<!-- Details of the method is described in [Efficient softmax approximation for GPUs](https://arxiv.org/abs/1609.04309) by Edouard Grave, Armand Joulin, Moustapha Cissé, David Grangier, Hervé Jégou. -->
手法の詳細は、Edouard Grave, Armand Joulin, Moustapha Cissé, David Grangier, Hervé Jégouによる[Efficient softmax approximation for GPUs](https://arxiv.org/abs/1609.04309)に記載されています。
