---
lang-ref: ch.10-3
title: The Truck Backer-Upper
lecturer: Alfredo Canziani
authors: Muyang Jin, Jianzhi Li, Jing Qian, Zeming Lin
date: 7 Apr 2020
translation-date: 14 Aug 2020
translator: Shiro Takagi
lang: ja
---

<div hidden>
    $$\gdef \tcab {\Theta_{\mathrm{cab}}}$$
    $$\gdef \xcab {x_{\mathrm{cab}}}$$
    $$\gdef \ycab {y_{\mathrm{cab}}}$$
    $$\gdef \ttrailer {\Theta_{\mathrm{trailer}}}$$
    $$\gdef \xtrailer {x_{\mathrm{trailer}}}$$
    $$\gdef \ytrailer {y_{\mathrm{trailer}}}$$
</div>


<!-- ## [Setup](https://www.youtube.com/watch?v=A3klBqEWR-I&t=59s) -->
## [セットアップ](https://www.youtube.com/watch?v=A3klBqEWR-I&t=59s)

<!-- The goal of this task is to build a **self-learning controller** which controls the steering of the truck while it backs up to the loading dock from any arbitrary initial position. -->
このタスクの目的は、任意の初期位置から積荷を積み下ろしする場所へトラックをバックさせる際のハンドルを制御するような、**自己学習する制御システム**を作ることです。 

<!-- Note that **only backing up is allowed,** as shown below in Figure 1. -->
図１に示されているように、**バックしかできない** ことに注意してください。

<!-- |![]({{site.baseurl}}/images/week10/10-3/fig1.png)|
|<center><b>Fig. 1</b>: The Truck, Trailer and Loading Dock</center>| -->
|![]({{site.baseurl}}/images/week10/10-3/fig1.png)|
|<center><b>図1</b>:：トラックとトレーラーと積荷を積み下ろしする場所</center>|

<!-- The **state** of the truck is represented by six parameters: -->
トラックの**状態**は6つのパラメータで表現されます:

 <!-- - $\tcab$: Angle of the truck
 - $\xcab, \ycab$: The cartesian of the yoke (or front of the trailer).
 - $\ttrailer$: Angle of the trailer
 - $\xtrailer, \ytrailer$: The cartesian of the (back of the) trailer. -->
  - $\tcab$: トラックの角度
 - $\xcab, \ycab$: トレーラーの正面の座標
 - $\ttrailer$: トレーラーの角度
 - $\xtrailer, \ytrailer$: トレーラーの後ろ側の座標

<!-- The **goal** of the controller is to select an appropriate angle $\phi$ at each time $k$, where after the truck will back up in a fixed small distance. Success depends on two criteria:
1. The back of the trailer is parallel to the wall loading dock, e.g. $\ttrailer = 0$.
2. The back of the trailer ($\xtrailer, \ytrailer$) is as close as possible to the point ($x_{dock}, y_{dock}$) as shown above. -->
制御システムの**目的**は、各時刻$k$ごとにトラックがある固定した小さな距離をバックした後に、適切な角度$\phi$を選択することです。成否は2つの基準に依存します。
1. トレーラーの後部が、壁の積み込みドックと平行であること。例えば、 $\ttrailer = 0$。
2. トレーラーの後部　($\xtrailer, \ytrailer$) が、上記で示されているような点($x_{dock}, y_{dock}$) にできるだけ近いこと。


<!-- ## More Parameters and Visualization -->
## より多くのパラメータと可視化

<!-- |![]({{site.baseurl}}/images/week10/10-3/fig2.png)|
|<center><b>Fig. 2</b>: Parameters for visualization</center>| -->
![]({{site.baseurl}}/images/week10/10-3/fig2.png)|
|<center><b>図2</b>: 可視化のためのパラメータ</center>|

<!-- In this section, we also consider a few more parameters shown in Figure 2.
Given car length $L$, $d_1$ the distance between car and trailer and $d_2$ the length of the trailer, etc, we can calculate the change of angle and positions: -->
ここでは、図2に示したようなあといくつかのパラメータについて考えてみます。
車の長さ$L$、車とトレーラーの距離$d_1$、トレーラーの長さ$d_2$などが与えられると、角度や位置の変化を計算することができます：

$$
\begin{aligned}
\dot{\theta_0} &= \frac{s}{L}\tan(\phi)\\
\dot{\theta_1} &= \frac{s}{d_1}\sin(\theta_1 - \theta_0)\\
\dot{x}        &= s\cos(\theta_0)\\
\dot{y}        &= s\sin(\theta_0)
\end{aligned}
$$

<!-- Here, $s$ denotes the signed speed and $\phi$ the negative steering angle.
Now we can represent the state by only four parameters: $\xcab$, $\ycab$, $\theta_0$ and $\theta_1$.
This is because Length parameters are known and $\xtrailer, \ytrailer$ is determined by $\xcab, \ycab, d_1, \theta_1$. -->
ここで、$s$は符号付き速度を、$\phi$はハンドルの負の舵角を表しています。
これで、$\xcab$, $\ycab$, $\theta_0$, $\theta_1$ の４つのパラメータだけで状態を表現できるようになりました。
これは、長さのパラメータがわかっていて、$\xtrailer, \ytrailer$が$\xcab, \ycab, d_1, \theta_1$で決まるからです。

<!-- In the Jupyter Notebook from the Deep Learning repository, we have some sample environments shown in Figures 3.(1-4): -->
Deep LearningリポジトリのJupyter Notebook から、 いくつかの環境の例を図３(1-4)に示します:

<!-- | <img src="{{site.baseurl}}/images/week10/10-3/fig3.png" height="150" width="300"/> |<img src="{{site.baseurl}}/images/week10/10-3/fig4.png" height="150" width="300"/>|
| **Fig. 3.1**: Sample plot of the environment | **Fig. 3.2**: Driving into itself (jackknifing) |
| <img src="{{site.baseurl}}/images/week10/10-3/fig5.png" height="150" width="300"/> |<img src="{{site.baseurl}}/images/week10/10-3/fig6.png" height="150" width="300"/>|
| **Fig. 3.3**: Going out of boundary |**Fig. 3.4**: Reaching the dock| -->
| <img src="{{site.baseurl}}/images/week10/10-3/fig3.png" height="150" width="300"/> |<img src="{{site.baseurl}}/images/week10/10-3/fig4.png" height="150" width="300"/>|
| **図3.1**: 環境のプロットのサンプル | **図3.2**: 自分自身に突っ込んでいる　(ジャックナイフ) |
| <img src="{{site.baseurl}}/images/week10/10-3/fig5.png" height="150" width="300"/> |<img src="{{site.baseurl}}/images/week10/10-3/fig6.png" height="150" width="300"/>|
<!-- TODO: May not be the correct translation of "Driving into itself" -->

<!-- | **Fig. 3.3**: Going out of boundary |**Fig. 3.4**: Reaching the dock|
At each time step $k$, a steering signal which ranges from $-\frac{\pi}{4}$ to $\frac{\pi}{4}$ will be fed in and the truck will take back up using the corresponding angle. -->
| **図3.3**: 境界線の外に出る |**図3.4**: ドックに到着する|

各時刻$k$で、$-\frac{\pi}{4}$から$\frac{\pi}{4}$までのハンドル操作の信号が入力され、トラックはそれに対応した角度で後退します。

<!-- There are several situations where the sequence can end:
 - If the truck drives into itself (jackknifes, as in Figure 3.2)
 - If the truck goes out of boundary (shown in Figure 3.3)
 - If the truck reaches the dock (shown in Figure 3.4) -->
トラックの運転が終了する状況はいくつかあります。
 - トラックが自分自身に突っ込んだ場合（図 3.2 のようなジャックナイフ）。
 - トラックが境界線の外に出た場合（図 3.3 に示す）。
 - トラックがドックに到達した場合（図 3.4 に示す）。

<!-- ## [Training](https://www.youtube.com/watch?v=A3klBqEWR-I&t=1184s) -->
## [訓練](https://www.youtube.com/watch?v=A3klBqEWR-I&t=1184s)

<!-- The training process involves two stages: (1)  training of a neural network to be an emulator of the truck and trailer kinematics and (2) training of a neural network controller to control the truck. -->
訓練は2段階で行われます。(1)トラックやトレーラーの運動のエミュレータとなるニューラルネットワークの訓練と、(2)トラックを制御するための制御システムとなるニューラルネットワークの訓練である。

<!-- | ![]({{site.baseurl}}/images/week10/10-3/fig7.png) |
| <center><b>Fig. 4</b>: Overview Diagram </center> | -->
| ![]({{site.baseurl}}/images/week10/10-3/fig7.png) |
| <center><b>図4</b>: 概要図 </center> |

<!-- As shown above, in the abstract diagram, the two blocks are the two networks that will be trained. At each time step $k$, the "Trailer Truck Kinematics", or what we have been calling the emulator, takes in the 6-dimension state vector and the steering signal generated from the controller and generate a new 6-dimension state at time $k + 1$. -->
上で示されているように、概念図に描かれている2つのブロックは訓練される予定の2つのネットワークです。各時間ステップ$k$では、「Trailer Truck Kinematics」、つまり今までエミュレータと呼んでいたものが、6次元の状態ベクトルと制御システムから生成されたハンドル操作信号を入力され、時間$k + 1$で新たな6次元の状態を生成します。


<!-- ### Emulator -->
### エミュレータ

<!-- The emulator takes the current location ($\tcab^t$,$\xcab^t, \ycab^t$, $\ttrailer^t$, $\xtrailer^t$, $\ytrailer^t$) plus the steering direction $\phi^t$ as input and outputs the state at next timestep ($\tcab^{t+1}$,$\xcab^{t+1}, \ycab^{t+1}$, $\ttrailer^{t+1}$, $\xtrailer^{t+1}$, $\ytrailer^{t+1}$). It consists of a linear hidden layer, with ReLu activation function, and an linear output layer. We use MSE as the loss function and train the emulator via stochastic gradient descent. -->
エミュレータは、現在の位置($\tcab^t$,$\xcab^t, \ycab^t$, $\ttrailer^t$, $\xtrailer^t$, $\ytrailer^t$)と操舵方向 $\phi^t$ を入力として受け取り、次の時間テップの状態を出力します。これは、線形の隠れ層とReLU活性化関数と線形出力層から構成されます。損失関数としてMSE損失を用い、確率的勾配降下法を用いてエミュレータを学習します。

<!-- |![]({{site.baseurl}}/images/week10/10-3/fig8.png)|
|  <center><b>Fig. 5</b>: Training the Neural-net Emulator</center>| -->
|![]({{site.baseurl}}/images/week10/10-3/fig8.png)|
|  <center><b>図5</b>: ニューラルネットエミュレータを学習する</center>|

<!-- In this setup, the the simulator can tell us the location of next step given the current location and steering angle. Therefore, we don’t really need a neural-net that emulates the simulator. However, in a more complex system, we may not have access to the underlying equations of the system, i.e. we do not have the laws of the universe in a nice computable form. We may only observe data that records sequences of steering signals and their corresponding paths. In this case, we want to train a neural-net to emulate the dynamic of this complex system. -->
この設定では、現在地とハンドルの角度が与えられていれば、次のステップの位置をシミュレーターが教えてくれます。したがって、シミュレータをエミュレートするニューラルネットは必要ありません。しかし、より複雑なシステムでは、システムの背後にある方程式にアクセスできないかもしれません。例えば、良い計算可能なこの宇宙の法則を私たちは知りません。ハンドル操作の信号とそれに対応するパスを記録したデータを観測できるだけかもしれません。この場合、この複雑なシステムの動きをエミュレートするためにニューラルネットを訓練したいと考えています。

<!-- In order to train enumlator, there are two important function in `Class truck` we need to look into when we train the emulator. -->
`Class truck`に、エミュレータを訓練するために考慮しなければならない重要な2つの関数があります。

<!-- First is the `step` function which gives the output state of the truck after computation. -->
1つ目は、計算後のトラックの出力状態を与える`step`という関数です。

```python
def step(self, ϕ=0, dt=1):

    # Check for illegal conditions
    if self.is_jackknifed():
        print('The truck is jackknifed!')
        return

    if self.is_offscreen():
        print('The car or trailer is off screen')
        return

    self.ϕ = ϕ
    x, y, W, L, d, s, θ0, θ1, ϕ = self._get_atributes()

    # Perform state update
    self.x += s * cos(θ0) * dt
    self.y += s * sin(θ0) * dt
    self.θ0 += s / L * tan(ϕ) * dt
    self.θ1 += s / d * sin(θ0 - θ1) * dt
```

<!-- Second is the `state` function which gives the current state of the truck. -->
2つ目は、トラックの現在の位置を返す`state`という関数です。

```python
def state(self):
        return (self.x, self.y, self.θ0, *self._traler_xy(), self.θ1)
```

<!-- We generate two lists first. We generate an input list by appending the randomly generated steering angle `ϕ` and the initial state which coming from the truck by running `truck.state()`. And we generate an output list that is appended by the output state of the truck which can be computed by `truck.step(ϕ)`. -->
まず二つのリストを生成します。ランダムに生成されたハンドルの角度`φ`とトラックからの初期状態を付け加えた入力リストを生成します。そして、`truck.step(ϕ)` で計算可能なトラックの出力状態を追加した出力リストを生成します。

<!-- We now can train the emulator: -->
これでエミュレーターを訓練できるようになりました。

```python
cnt = 0
for i in torch.randperm(len(train_inputs)):
    ϕ_state = train_inputs[i]
    next_state_prediction = emulator(ϕ_state)

    next_state = train_outputs[i]
    loss = criterion(next_state_prediction, next_state)

    optimiser_e.zero_grad()
    loss.backward()
    optimiser_e.step()

    if cnt == 0 or (cnt + 1) % 1000 == 0:
        print(f'{cnt + 1:4d} / {len(train_inputs)}, {loss.item():.10f}')
    cnt += 1
```

<!-- Notice that `torch.randperm(len(train_inputs))` gives us a random permutation of the indices within the range $0$ to length of training inputs minus $1$. After the permutation of indices, each time `ϕ_state` is chosen from the input list at the index `i`. We input `ϕ_state` through the emulator function that has a linear output layer and we get `next_state_prediction`. Notice that the emulator is a neural netork defined as below: -->
`torch.randperm(len(train_inputs))` は、 $0$ から入力の長さから $1$ を引いた範囲内のインデックスのランダムな並べ替えを与えていることに注意してください。インデックスの並べ替えの後、毎回 `φ_state` が入力リストからインデックス `i` で選択されます。線形出力層を持つエミュレータ関数を通して `φ_state` を入力すると、 `next_state_prediction` が得られます。エミュレータは以下のように定義されたニューラルネットワークであることに注意してください。

```python
emulator = nn.Sequential(
    nn.Linear(steering_size + state_size, hidden_units_e),
    nn.ReLU(),
    nn.Linear(hidden_units_e, state_size)
)
```

<!-- Here we use MSE to calculate the loss between the true next state and the next state prediction, where the true next state is coming from the output list with index `i` that corresponding to the index of the `ϕ_state` from input list. -->
ここでは MSE 損失を使用して真の次の状態と次の状態の予測の間の誤差を計算します。ただし、真の次の状態は入力リストからの`ϕ_state` のインデックスに対応するインデックス `i` を持つ出力リストから来ています。

<!-- ### Controller -->
### 制御システム

<!-- Refer to Figure 5. Block $\matr{C}$ represents the controller. It takes in the current state and ouputs a steering angle. Then block $\matr{T}$ (emulator) takes both the state and angle to produce the next state. -->
図 5 を参照してください。ブロック$\matr{C}$は制御システムを表しています。現在の状態を入力として受けて、ハンドルの角度を出力します。そして、ブロック$\matr{T}$(エミュレータ)は、状態とハンドルの角度の両方を入力として受けて、次の状態を生成します。

|![]({{site.baseurl}}/images/week10/10-3/fig13.png)|
<!-- | <center><b>Fig. 5</b>: State Transition flow diagram</center>| -->
|![]({{site.baseurl}}/images/week10/10-3/fig13.png)|
| <center><b>図5</b>: 状態遷移図</center>|

<!-- To train the controller, we start from a random initial state and repeat the procedure($\matr{C}$ and $\matr{T}$) until the trailer is parallel to the dock. The error is calculated by comparing the trailer location and dock location.
We then find the gradients using backpropagation and update parameters of the controller via SGD. -->
制御システムの学習では、ランダムな初期状態から開始し、トレーラがドックと平行になるまで、$\matr{C}$と$\matr{T}$の手順を繰り返します。誤差はトレーラの位置とドックの位置を比較して計算します。
その後、誤差逆伝播を用いて勾配を求め、SGDによって制御システムのパラメータを更新します。

<!-- ### [Detailed Model Structure](https://www.youtube.com/watch?v=A3klBqEWR-I&t=2328s) -->
### [モデルの構造の詳細](https://www.youtube.com/watch?v=A3klBqEWR-I&t=2328s)

<!-- This is a detailed graph of ($\matr{C}$, $\matr{T}$) process. We start with a state (6 dimension vector), multiply it with a tunable weights matrix and get 25 hidden units. Then we pass it through another tunable weights vector to get the output (steering signal). Similarly, we input the state and angle $\phi$ (7 dimension vector) through two layers to produce the state of next step. -->
これは($m\matr{C}$, $\matr{T}$)の処理の詳細を表したグラフです。まず、状態(6次元ベクトル)が入力され、それに学習可能な重み行列をかけて25個の隠れユニットを得ます。そして、それを別の学習可能な重み行列に通し、出力を得ます。同様に、状態と角度$\phi$ (7次元ベクトル)を2層に分けて入力し、次のステップの状態を生成します。

![]({{site.baseurl}}/images/week10/10-3/fig14.png)

<!-- To see this more clearly, we show the exact implementation of the emulator: -->
これをより明確に見るために、エミュレータの正確な実装を示します。

```python
state_size = 6
steering_size = 1
hidden_units_e = 45

emulator = nn.Sequential(
    nn.Linear(steering_size + state_size, hidden_units_e),
    nn.ReLU(),
    nn.Linear(hidden_units_e, state_size)
)

optimiser_e = SGD(emulator.parameters(), lr=0.005)
criterion = nn.MSELoss()
```


<!-- ### Examples of Movement -->
### 動きの例

<!-- Following are four examples of movement for different initial state. Notice that the number of time steps in each episode varies. -->
次の4つは異なる初期状態から始めた時の例です。各エピソードの時間ステップがばらついていることに注意してください。

|![]({{site.baseurl}}/images/week10/10-3/fig16.png) | ![]({{site.baseurl}}/images/week10/10-3/fig17.png) |
|![]({{site.baseurl}}/images/week10/10-3/fig18.png) | ![]({{site.baseurl}}/images/week10/10-3/fig19.png) |
<!-- | <center><b>Fig. 7</b>: Examples of movement for four different initial states </center>| -->
| <center><b>図7</b>: 4つの異なる初期状態から始めた時の例</center>|

<!-- ### Additional Resources: -->
### 追加の情報源:

<!-- A full working demo can be found at: [https://tifu.github.io/truck_backer_upper/](https://tifu.github.io/truck_backer_upper/).
Please check out the code as well, which can be found at [https://github.com/Tifu/truck_backer_upper](https://github.com/Tifu/truck_backer_upper). -->
動かせる完全なデモは次のサイトで見ることができます：[https://tifu.github.io/truck_backer_upper/](https://tifu.github.io/truck_backer_upper/)。

次のリンクにあるコードもチェックしてみてください：[https://github.com/Tifu/truck_backer_upper](https://github.com/Tifu/truck_backer_upper)。
