---
lang-ref: ch.10-2
title: 自己教師あり学習 - ClusterFit と PIRL
lecturer: Ishan Misra
authors: Zhonghui Hu, Yuqing Wang, Alfred Ajay Aureate Rajakumar, Param Shah
date: 6 Apr 2020
translation-date: 13 Aug 2020
translator: Shiro Takagi
lang: ja
---


<!-- ### [What is missing from "pretext" tasks? The hope of generalization](https://www.youtube.com/watch?v=0KeR6i1_56g&t=3710s) -->
### [「pretext」tasksに欠けているものは何か？ 汎化への希望](https://www.youtube.com/watch?v=0KeR6i1_56g&t=3710s)

<!-- Pretext task generally comprises of pretraining steps which is self-supervised and then we have our transfer tasks which are often classification or detection. We *hope* that the pretraining task and the transfer tasks are "aligned", meaning, solving the pretext task will help solve the transfer tasks very well. So, a lot of research goes into designing a pretext task and implementing them really well. -->
Pretext taskは一般的に、自己教師あり学習下で行われる事前学習のステップと、分類や検出などの転移先のタスクから構成されています。私たちは、事前学習のタスクが転移先のタスクに「沿っている」ことを*期待*しています。ですので、pretext taskを設計し、それを本当にうまく実装するための、多くの研究が行われています。

<!-- However, it is very unclear why performing a non-semantic task should produce good features?. For example, why should we expect to learn about “semantics” while solving something like Jigsaw puzzle? Or why should “predicting hashtags” from images be expected to help in learning a classifier on transfer tasks? Therefore, the question remains. How should we design good pre-training tasks which are well aligned with the transfer tasks? -->
しかし、なぜそれ自体では意味がないタスクを実行すると良い特徴が得られるのかはとても非自明です。例えば、ジグゾーパズルのようなものを解きながら、なぜ「意味」を学ぶことを期待できるのか、画像からハッシュタグを予測することが、転移先のタスクの分類器の学習に役立つと期待されるのはなぜか、といった疑問が残ります。どのようにして転移先のタスクに沿った良い事前学習のタスクを設計すればよいのでしょうか？

<!-- One way to evaluate this problem is by looking at representations at each layer (refer Fig. 1). If the representations from the last layer are not well aligned with the transfer task, then the pretraining task may not be the right task to solve. -->
この問題を評価する一つの方法は、各層の表現を見ることです（図1参照）。もし、最後の層の表現が転移先のタスクとうまく一致していなければ、事前学習のタスクは正しいタスクではないのかもしれません。

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-2/fig01.png" height="75%" width="75%"/><br>
<b>Fig. 1</b>: Feature representations at each layer
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig01.png" height="75%" width="75%"/><br>
<b>図1</b>: 各層の特徴表現
</center>

<!-- Fig. 2 plots the Mean Average Precision at each layer for Linear Classifiers on VOC07 using Jigsaw Pretraining. It is clear that the last layer is very specialized for the Jigsaw problem. -->
図2は、VOC07データに対する分類を行う線形分類器について、ジグソータスクで事前学習を用いて各層でのmAPをプロットしたものです。最後の層がジグソー問題に非常に特化していることがわかります。

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-2/fig02.png" height="70%" width="80%"/><br>
<b>Fig. 2</b>: Performance of Jigsaw based on each layer
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig02.png" height="70%" width="80%"/><br>
<b>図2</b>: 各層に基づくジグソータスクの性能
</center>


<!-- ### What we want from pre-trained features? -->
### 事前学習された特徴から何を得たいのか？

<!-- * Represent how images relate to one another -->
* 画像が互いにどのように関係しているのかの表現

  <!-- * ClusterFit: Improving Generalization of Visual Representations -->
  <!-- * ClusterFit: Improving Generalization of Visual Representations -->
  * ClusterFit：視覚表現についての汎化能力の向上

<!-- * Be robust to "nuisance factors" -- Invariance -->
* 「nuisance factor」（厄介な要素）（関心がないが結果に影響を及ぼしてしまうような要因のこと）に対して頑健であること ：不変性

  <!-- E.g. exact location of objects, lighting, exact colour -->
  例： オブジェクトの正確な位置、光源の正確な位置、正確な色

  <!-- * PIRL: Self-supervised learning of Pre-text Invariant Representations -->
  * PIRL: Pre-textに対して不変な表現の自己教師あり学習

<!-- Two ways to achieve the above properties are **Clustering** and **Contrastive Learning**. They have started performing much better than whatever pretext tasks that were designed so far.  One method that belongs to clustering is **ClusterFit** and another falling into invariance is **PIRL**. -->
上記の特性を達成するための2つの方法は、**クラスタリング**と**コントラスティブ学習**です。これらの方法は、これまでに設計されたどのようなpretext taskよりもはるかに良い性能を発揮するようになってきました。 クラスタリングに属する方法の一つは **ClusterFit** であり、もう一つの不変性に属する方法は **PIRL** です。


<!-- ## ClusterFit: Improving Generalization of Visual Representations -->
## ClusterFit: Improving Generalization of Visual Representations

<!-- Clustering the feature space is a way to see what images relate to one another. -->
特徴空間のクラスタリングは、画像が互いにどのような関連性を持っているかを見る一つの方法です。


<!-- ### Method -->
### 方法

<!-- ClusterFit follows two steps.  One is the cluster step, and the other is the predict step. -->
ClusterFitは2つのステップからなります。 1つはクラスターステップ、もう1つは予測ステップです。

<!-- #### Cluster: Feature Clustering -->
#### クラスター：特徴量クラスタリング

<!-- We take a pretrained network and use it to extract a bunch of features from a set of images. The network can be any kind of pretrained network. K-means clustering is then performed on these features, so each image belongs to a cluster, which becomes its label. -->
事前学習されたネットワークを用いて、画像の集合から特徴抽出をします。ネットワークはどのような種類の学習済みネットワークであっても構いません。そして、これらの特徴量に対してK平均クラスタリングを実行し、各画像が属したクラスターがその画像のラベルとなります。

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-2/fig03.png"
height="75%" width="75%" /><br>
<b>Fig. 3</b>: Cluster step
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig03.png"
height="75%" width="75%" /><br>
<b>図3</b>: クラスターステップ
</center>


<!-- #### Fit: Predict Cluster Assignment -->
#### フィット: クラスターの割り当てを予測する

<!-- For this step, we train a network from scratch to predict the pseudo labels of images. These pseudo labels are what we obtained in the first step through clustering. -->
このステップでは、画像の疑似ラベルを予測するためのネットワークを一から訓練します。これらの疑似ラベルは、最初のステップでクラスタリングによって得られたものです。

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-2/fig04.png"
height="75%" width="75%"/><br>
<b>Fig. 4</b>: Predict step
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig04.png"
height="75%" width="75%"/><br>
<b>図4</b>: 予測ステップ
</center>

<!-- A standard pretrain and transfer task first pretrains a network and then evaluates it in downstream tasks, as it is shown in the first row of Fig. 5. ClusterFit performs the pretraining on a dataset $D_{cf}$ to get the pretrained network $N_{pre}$. The pretrained network $N_{pre}$ are performed on dataset $D_{cf}$ to generate clusters. We then learn a new network $N_{cf}$from scratch on this data. Finally, use $N_{cf}$ for all downstream tasks. -->
図5の最初の行に示すように、標準的な事前学習と転移先タスクでは、最初にネットワークを事前学習してから、下流のタスクで評価をします。ClusterFitは、データセット $D_{cf}$ に対して事前学習を行うことで、学習済みネットワーク $N_{pre}$ を得ます。事前学習したネットワーク $N_{pre}$ を用いて、データセット $D_{cf}$ からクラスタを生成します。そして、このデータに対して新しいネットワーク $N_{cf}$ をゼロから学習します。最後に、下流のすべてのタスクに $N_{cf}$ を使用します。
<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-2/fig05.png"
height="75%" width="75%"/><br>
<b>Fig. 5</b>: "Standard" pretrain + transfer vs. "Standard" pretrain + ClusterFit
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig05.png"
height="75%" width="75%"/><br>
<b>図5</b>: 「標準的な」 事前学習 + 転移学習 vs「標準的な」 事前学習 + ClusterFit
</center>


<!-- ### Why ClusterFit Works -->
### なぜClusterFitがうまくいくのか

<!-- The reason why ClusterFit works is that in the clustering step only the essential information is captured, and artefacts are thrown away making the second network learn something slightly more generic. -->
なぜClusterFitが機能するかというと、クラスタリングのステップで本質的な情報だけが捉えれることでアーティファクトが捨てられ、第二のネットワークがより一般的なものを学習するようになるからです。

<!-- To understand this point, a fairly simple experiment is performed.  We add label noise to ImageNet-1K, and train a network based on this dataset. Then, we evaluate the feature representation from this network on a downstream task on ImageNet-9K. As it is shown in Fig. 6, we add different amounts of label noise to the ImageNet-1K, and evaluate the transfer performance of different methods on ImageNet-9K. -->
この点を理解するために、かなり簡単な実験を行います。 ImageNet-1Kにラベルノイズを追加し、このデータセットに基づいてネットワークを学習させます。そして、このネットワークの特徴表現を ImageNet-9Kを用いた下流のタスクで評価します。図 6 に示すように、ImageNet-1K にラベルノイズを付加し、転移先である ImageNet-9K 分類タスクで性能を評価しています。

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-2/fig06.png"
height="50%" width="50%"/>
<br><b>Fig. 6</b>: Control Experiment
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig06.png"
height="50%" width="50%"/>
<br><b>図6</b>: 対照実験
</center>

<!-- The pink line shows the performance of pretrained network, which decreases as the amount of label noise increases. The blue line represents model distillation where we take the initial network and use it to generate labels. Distillation generally performs better than pretrained network.  The green line, ClusterFit, is consistently better than either of these methods. This result validates our hypothesis. -->
ピンクの線は事前学習されたネットワークの性能を示していますが、ラベルノイズの量が増えると性能が低下していることがわかります。青色の線はモデル蒸留を表していて、これは初期ネットワークを使用してラベルを生成しています。蒸留は概して、事前学習済みネットワークよりも優れた性能を発揮しています。 緑の線、ClusterFitは、これらの方法のいずれよりも一貫して優れています。この結果は、私たちの仮説を検証しています。

<!-- * Question: Why use distillation method to compare. What's the difference between distillation and ClusterFit? -->
* 質問: なぜ蒸留法と比較するのですか。蒸留法とClusterFitの違いは何ですか？
<!-- 
In model distillation we take the pre-trained network and use the labels the network predicted in a softer fashion to generate labels for our images. For example, we get a distribution over all the classes and use this distribution to train the second network. The softer distribution helps enhance the initial classes that we have. In ClusterFit we don't care about the label space. -->
モデル蒸留では、事前に学習したネットワークを用いて、よりソフトな方法でネットワークが予測したラベルを使うことで、画像のラベルを生成します。例えば、すべてのクラスの分布を使って2番目のネットワークを学習します。ソフトな分布は、最初に得たクラスをの確率に大きな重み付けをするのに役立ちます。ClusterFitでは、ラベル空間は気にしません。


<!-- ### Performance -->
### 性能

<!-- We apply this method to self-supervised learning. Here Jigsaw is applied to obtain the pretrained network $N_{pre}$ in ClusterFit. From Fig. 7 we see that the transfer performance on different datasets shows a surprising amount of gains, compared to other self-supervised methods. -->
この手法を自己教師あり学習に適用します。ここでは、事前学習タスクとしてJigsawを用いることで、ClusterFitで用いる学習済みネットワーク $N_{pre}$ を得ます。図7から、他の自己教師あり学習法と比較して、様々なデータセットにおいて転移先での性能が驚くほど向上していることがわかります。

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-2/fig07.png"
height="70%" width="70%"/><br><b>Fig. 7</b>: Transfer performance on different datasets
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig07.png"
height="70%" width="70%"/><br><b>図7</b>: 異なるデータセットに対する転移先での性能
</center>

<!-- ClusterFit works for any pre-trained network. Gains without extra data, labels or changes in architecture can be seen in Fig. 8. So in some way, we can think of the ClusterFit as a self-supervised fine-tuning step, which improves the quality of representation. -->
ClusterFitは、事前学習済みのネットワークであれば、どのようなものにも使えます。ClusterFitを用いることで追加のデータやラベル、アーキテクチャの変更なしに得られる改善は、図8に見ることができます。このように、ある意味では、ClusterFitは自己教師ありのfine-tuningのステップであり、表現の質を向上させると考えることができます。

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-2/fig08.png"
height="70%" width="70%"/><br><b>Fig. 8</b>: Gains without extra data, labels or changes in architecture
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig08.png"
height="70%" width="70%"/><br><b>図8</b>: 追加のデータ、ラベル、アーキテクチャの変更なしに得られる改善
</center>

<!-- ## [Self-supervised Learning of Pretext Invariant Representations (PIRL)](https://www.youtube.com/watch?v=0KeR6i1_56g&t=4748s) -->
## [Self-supervised Learning of Pretext Invariant Representations (PIRL)](https://www.youtube.com/watch?v=0KeR6i1_56g&t=4748s)


<!-- ### Contrastive Learning -->
### コントラスティブ学習

<!-- Contrastive learning is basically a general framework that tries to learn a feature space that can combine together or put together points that are related and push apart points that are not related. -->
コントラスティブ学習は、基本的には、関連性のある点を組み合わせたり、まとめたりして、関連性のない点を押し除けるような特徴空間を学習しようとする一般的なフレームワークです。

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-2/fig09.png"
height="20%" width="20%"/><br><b>Fig. 9</b>: Groups of Related and Unrelated Images
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig09.png"
height="20%" width="20%"/><br><b>図9</b>: 関連した画像と関連していない画像のグループ
</center>

<!-- In this case, imagine like the blue boxes are the related points, the greens are related, and the purples are related points. -->
この場合、青い箱、緑の箱、紫の箱は、それぞれが、互いに関連している点のまとまりだと考えてください。

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-2/fig10.png"
height="100%" width="100%"/><br><b>Fig. 10</b>: Contrastive Learning and Loss Function
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig10.png"
height="100%" width="100%"/><br><b>図10</b>: コントラスティブ学習と損失関数
</center>

<!-- Features for each of these data points would be extracted through a shared network, which is called Siamese Network to get a bunch of image features for each of these data points. Then a contrastive loss function is applied to try to minimize the distance between the blue points as opposed to, say, the distance between the blue point and the green point. Or the distance basically between the blue point should be less than the distance between the blue point and green point or the blue point and the purple point. So, embedding space from the related samples should be much closer than embedding space from the unrelated samples. So that's the general idea of what contrastive learning is and of course Yann was one of the first teachers to propose this method. So contrastive learning is now making a resurgence in self-supervised learning pretty much a lot of the self-supervised state of the art methods are really based on contrastive learning. -->
これらのデータ点のそれぞれの特徴は、Siameseネットワークと呼ばれる共有ネットワークを介して抽出され、これらのデータ点のそれぞれについての画像特徴量が得られます。次に、例えば青い点と緑の点の間の距離とは対照的に、青い点の間の距離を最小にするためにコントラスト損失関数を用います。あるいは、基本的には、青い点の間の距離は、青い点と緑の点との間の距離、あるいは青い点と紫の点との間の距離よりも小さくなければなりません。つまり、関連するサンプルからの埋め込み空間は、関連しないサンプルからの埋め込み空間よりもはるかに近くなければならないということです。これがコントラスティブ学習の一般的な考え方で、ご存知の通りYannはこの方法を最初に提案した先生の一人です。現在、コントラスティブ学習は自己教師あり学習で再度注目され初めています。実際に自己教師あり学習の最先端の手法の多くは、このコントラスティブ学習に基づいています。

<!-- ### How to define related or unrelated? -->
### どのようにして関連しているかいないかを決めるのか？

<!-- And the main question is how to define what is related and unrelated. In the case of supervised learning that's fairly clear all of the dog images are related images, and any image that is not a dog is basically an unrelated image. But it's not so clear how to define the relatedness and unrelatedness in this case of self-supervised learning. The other main difference from something like a pretext task is that contrastive learning really reasons a lot of data at once.  If you look at the loss function, it always involves multiple images. In the first row it involves basically the blue images and the green images and in the second row it involves the blue images and the purple images. But as if you look at a task like say Jigsaw or a task like rotation, you're always reasoning about a single image independently. So that's another difference with contrastive learning: contrastive learning reasons about multiple data points at once. -->
何が関連していて何が関連していないかをどのように定義するかというのが主な問題です。教師あり学習の場合、犬の画像はすべて関連性のある画像であり、犬ではない画像は基本的に関連性のない画像です。しかし、この自己教師あり学習の場合、関連性のあるなしをどのように定義するかはあまり明確ではありません。もう一つ、pretext taskのようなものとの大きな違いは、コントラスティブ学習では実際に一度にたくさんのデータを推論するということです。 損失関数を見ると、それは常に複数の画像を含んでいます。1列目は基本的に青と緑の画像を含み、2列目は青と紫の画像を含みます。しかし、ジグソーや回転予測のようなタスクでは、常に1つの画像を独立して推論していることになります。これがコントラスティブ学習とのもう一つの違いで、コントラスティブ学習は一度に複数のデータ点について推論します。

<!-- Similar techniques to what was discussed earlier could be used: frames of video or sequential nature of data. Frames that are nearby in a video are related and frames, say, from a different video or which are further away in time are unrelated. And that has formed the basis of a lot of self- supervised learning methods in this area. This method is called CPC, which is contrastive predictive coding, which relies on the sequential nature of a signal and it basically says that samples that are close by, like in the time-space, are related and samples that are further apart in the time-space are unrelated. A fairly large amount of work basically exploiting this: it can either be in the speech domain, video, text, or particular images. And recently, we've also been working on video and audio so basically saying a video and its corresponding audio are related samples and video and audio from a different video are basically unrelated samples. -->
このように、コントラスティブ学習では、複数のデータ点について一度に推論を行うことができます。動画の中で近くにあるフレームは関連性があり、別の動画からのフレームや時間的に離れたフレームは関連性がありません。これがこの分野の多くの自己教師あり学習法の基礎となっています。この方法はコントラスト予測符号化（CPC）と呼ばれるものですが、これは信号が逐次的であるという性質に依存しています。これを利用して、基本的にはかなり多くの作業が行われています：音声領域、動画、テキスト、特定の画像などです。最近では、私たちは動画と音声の問題にも取り組んでいます。基本的には、動画とそれに対応する音声は関連するサンプルであり、別の動画の動画と音声は基本的に無関係なサンプルです。


<!-- ### Tracking Objects -->
### オブジェクトの追跡

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-2/fig11.png"
height="80%" width="80%"/><br><b>Fig. 11</b>: Tracking the Objects
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig11.png"
height="80%" width="80%"/><br><b>図11</b>: オブジェクトの追跡
</center>

<!-- Some of the early work, like self-supervised learning, also uses this contrastive learning method and they really defined related examples fairly interestingly. You run a tracked object tracker over a video and that gives you a moving patch and what you say is that any patch that was tracked by the tracker is related to the original patch. Whereas, any patch from a different video is not a related patch. So that basically gives out these bunch of related and unrelated samples. In figure 11(c), you have this like distance notation. What this network tries to learn is basically that patches that are coming from the same video are related and patches that are coming from different videos are not related. In some way, it automatically learns about different poses of an object. It tries to group together a cycle, viewed from different viewing angles or different poses of a dog. -->
自己教師あり学習のような初期の研究のいくつかは、このコントラスティブ学習法を使っていて、関連するデータを非常に興味深く定義しています。トラッカーに追跡されたオブジェクトを動画上で動かすと、移動するパッチが得られますが、この時、トラッカーに追跡されたパッチは元のパッチに関連すると言います。一方、別の動画からのパッチは関連性のあるパッチではありません。つまり、基本的には関連するサンプルと関連しないサンプルが出てきます。図11(c)では、この距離のようなものの表記があります。このネットワークが学習しようとしているのは、基本的には、同じ動画から来たパッチは関連していて、異なる動画から来たパッチは関連していないということです。何らかの方法で、オブジェクトの異なる姿勢を自動的に学習します。これは、様々な角度から見たサイクルや、犬の様々な姿勢をグループ分けしようとします。


<!-- ### Nearby patches *vs.* distant patches of an Image -->
### 一つの画像における、近くのパッチと離れているパッチ

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-2/fig12.png"
height="50%" width="50%"/><br><b>Fig. 12</b>: Nearby patches *vs.* distant patches of an Image
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig12.png"
height="50%" width="50%"/><br><b>図12</b>: 一つの画像の近くのパッチと離れているパッチ
</center>

<!-- In general, talking about images, a lot of work is done on looking at nearby image patches versus distant patches, so most of the CPC v1 and CPC v2 methods are really exploiting this property of images. So image patches that are close are called as positives and image patches that are further apart are translated as negatives, and the goal is to minimize the contrastive loss using this definition of positives and negatives. -->
一般的に、画像について言えば、近くの画像パッチと遠くの画像パッチを比較することが多く、CPC v1やCPC v2のほとんどの手法は、画像のこの特性を利用しています。つまり、近い画像パッチはポジティブ（正例）と呼ばれ、離れた画像パッチはネガティブ（負例）と呼ばれ、このポジティブとネガティブの定義を使ってコントラスト損失を最小化することが目的となります。


<!-- ### Patches of an image *vs.* patches of other images -->
### ある画像のパッチと別の画像のパッチ

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig13.png"
height="60%" width="60%"/><br><b>図13</b>: ある画像のパッチと別の画像のパッチ
</center>

<!-- The more popular or performant way of doing this is to look at patches coming from an image and contrast them with patches coming from a different image. This forms the basis of a lot of popular methods like instance discrimination, MoCo, PIRL, SimCLR. The idea is basically what's shown in the image. To go into more details, what these methods do is to extract completely random patches from an image. These patches can be overlapping, they can actually become contained within one another or they can be completely falling apart and then apply some data augmentation. In this case, say, a colour chattering or removing the colour or so on. And then these two patches are defined to be positive examples. Another patch is extracted from a different image. And this is again a random patch and that basically becomes your negatives. And a lot of these methods will extract a lot of negative patches and then they will basically perform contrastive learning. So there are relating two positive samples, but there are a lot of negative samples to do contrastive learning against. -->
これを行うより一般的な、または実行可能な方法は、ある画像から来るパッチを見て、別の画像から来るパッチとそれらを対比させることです。これは、インスタンス識別、MoCo、PIRL、SimCLRのような多くの一般的な方法の基礎を成しています。基本的には、画像に示されているような考え方です。もっと詳しく説明すると、これらの手法では、画像から完全にランダムなパッチを抽出します。これらのパッチは重なり合っていたり、実際にはお互いの中に含まれていたり、完全にバラバラになっていたりします。この場合、例えば、色をごちゃ混ぜにしたり色を除去したりすることが考えられます。そして、この2つのパッチを正例として定義して、別のパッチを別の画像から抽出します。これもランダムなパッチで、基本的にはこれが負例になります。これらの手法の多くは、多くのネガティブパッチを抽出し、基本的にはコントラスト学習を行います。つまり、互いに関係のある2つの正例がありますが、コントラスト学習を行うための負例はたくさんあるような状況です。
<!-- TODO: Could not translate "chattering" properly -->

<!-- ### Underlying Principle for Pretext Tasks -->
### Pretext Taskの基本原理

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-2/fig14.png"
height="50%" width="50%"/><br><b>Fig. 14</b>: Pretext Image Transform and Standard Pretext Learning
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig14.png"
height="50%" width="50%"/><br><b>図14</b>: 画像変換のPretext Taskと標準的な Pretext学習
</center>

<!-- Now moving to PIRL a little bit, and that's trying to understand what the main difference of pretext tasks is and how contrastive learning is very different from the pretext tasks. Again, pretext tasks always reason about a single image at once.  So the idea is that given an image your and prior transform to that image, in this case a Jigsaw transform, and then inputting this transformed image into a ConvNet and trying to predict the property of the transform that you applied to, the permutation that you applied or the rotation that you applied or the kind of colour that you removed and so on. So the pretext tasks always reason about a single image. And the second thing is that the task that you're performing in this case really has to capture some property of the transform. So it really needs to capture the exact permutation that are applied or the kind of rotation that are applied, which means that the last layer representations are actually going to go PIRL very a lot as the transform the changes and that is by design, because you're really trying to solve that pretext tasks. But unfortunately, what this means is that the last layer representations capture a very low-level property of the signal. They capture things like rotation or so on. Whereas what is designed or what is expected of these representations is that they are invariant to these things that it should be able to recognize a cat, no matter whether the cat is upright or that the cat is say,  bent towards like by 90 degrees. Whereas when you're solving that particular pretext task you're imposing the exact opposite thing. We're saying that we should be able to recognize whether this picture is upright or whether this picture is basically turning it sideways. There are many exceptions in which you really want these low-level representations to be covariant and a lot of it really has to do with the tasks that you're performing and quite a few tasks in 3D really want to be predictive. So you want to predict what camera transforms you have: you're looking at two views of the same object or so on. But unless you have that kind of a specific application for a lot of semantic tasks, you really want to be invariant to the transforms that are used to use that input. -->

それでは、少しPIRLの説明に移ります。これは、pretext taskの主な違いを理解しようとするもので、コントラスティブ学習がpretext taskとどう違うのかを理解しようとするものです。繰り返しになりますが、pretext taskでは、常に一度に一つの画像について推論します。 つまり、ある画像が与えられたときに、その画像に対して事前の変換（この場合はジグソー変換）を行い、その変換された画像をConvNetに入力して、適用した変換の特性、適用した並び替え、適用した回転、削除した色などを予測しようとするという考え方です。つまり、（また繰り返しですが）pretext taskは常に1つの画像について推論しています。もう一つは、この場合に実行しているタスクは、変換の性質を捉えなければならない、つまり、適用される正確な並び順の変換や回転の種類を捉えなければならないということです。
<!-- TODO: Could not understand -->
<!-- which means that the last layer representations are actually going to go PIRL very a lot as the transform the changes and that is by design, because you're really trying to solve that pretext tasks -->
しかし、残念ながら、これが意味するのは、最後の層の表現は信号の非常に低次の性質を捉えているということです。回転などの性質を確かに捉えてはいます。しかし、私たちが欲しいのは、例えば猫を認識するために不変な表現であって、それは例えば猫が直立していても、猫が90度の方向に曲がっていても、猫を認識できるような表現です。一方で、特定のpretext taskを解いているときには、全く逆のことを課していることになります。pretext taskでは、この絵が直立しているか、この絵が基本的に横に曲がっているかを認識できるようになるべきだと言っているのです。このような低レベルの表現を共変量にしたいと思う例外はたくさんあります。その多くは実行しているタスクに関係しており、かなり多くの３次元のタスクは予測ができて欲しいのです。例えば、どのようなカメラ変換をしているかを予測したい場合などがあります（同じオブジェクトの2つの側面を見ている場合など）。しかし、そのような特定の用途でもない限り、意味を解釈したいような多くのタスクでは、入力を使用するためには、用いられた変換に対しては不変であって欲しいと考えるのです。

<!-- ### How important has invariance been? -->
### 不変性がどれだけ重要なのか？

<!-- Invariance has been the word course for feature learning. Something like SIFT, which is a fairly popular handcrafted feature where we inserted here is transferred invariant. And supervise networks, for example, supervised Alex nets, they're trained to be invariant data augmentation. You want this network to classify different crops or different rotations of this image as a tree, rather than ask it to predict what exactly was the transformation applied for the input. -->
不変性は特徴量学習にとってのword courseになっています。ここに挿入してある、かなり人気な手作りの特徴量であるSIFTのようなものは、不変になります。そして教師ありネットワーク、例えば教師ありAlex netは、Data Augmentation（データ拡張）に対して不変になるように訓練されています。このネットワークには、入力に適用された変換が正確に何であったかを予測するように求めるのではなく、画像の異なるクロップ（トリミングのようなもの）や異なる回転を一つの木として分類して欲しいと考えます。
<!-- TODO: word course? -->
<!-- TODO: Could not understand "as a tree"-->


<!-- ### PIRL -->
### PIRL

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-2/fig15.png"
height="70%" width="70%"/><br><b>Fig. 15</b>: PIRL
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig15.png"
height="70%" width="70%"/><br><b>図15</b>: PIRL
</center>

<!-- This is what inspired PIRL. So PIRL stands for pretext invariant representation learning, where the idea is that you want the representation to be invariant or capture as little information as possible of the input transform. So you have the image, you have the transformed version of the image, you feed-forward both of these images through a ConvNet, you get a representation and then you basically encourage these representations to be similar. In terms of the notation referred earlier, the image $I$ and any pretext transformed version of this image $I^t$ are related samples and any other image is underrated samples. So in this way when you frame this network, representation hopefully contains very little information about this transform $t$. And assume you are using contrastive learning. So the contrastive learning part is basically you have the saved feature $v_I$ coming from the original image $I$ and you have the feature $v_{I^t}$ coming from the transform version and you want both of these representations to be the same. And the book paper we looked at is two different states of the art of the pretext transforms, which is the jigsaw and the rotation method discussed earlier. In some way, this is like multitask learning, but just not really trying to predict both designed rotation. You're trying to be invariant of Jigsaw rotation. -->
これが PIRL の発想の源です。PIRL は pretext invariant representation learning の略で、表現が不変であること、あるいは入力の変換の情報をできるだけ少なくすることを目指すという考え方です。ある画像とそれになんらかの変換を施した画像があるとします。これらの画像を畳み込みニューラルネットで順伝播すると、特徴表現が得られますが、基本的にはこれら2つの画像に対するそれぞれの表現が類似しているようにします。先ほどの表記法では、画像 $I$ とその変換後の画像 $I^t$ は関連するサンプルであり、他の画像は関連しないサンプルです。このようにして、このネットワークを定式化するとき、獲得された表現にはこの変換 $t$ についての情報がほとんど含まれていないことが望まれます。ここでコントラスティブ学習を使っていると仮定します。コントラスティブ学習では、基本的には元の画像 $I$ から保存された特徴量 $v_I$ と、変換後の画像から得られた特徴量 $v_{I^t}$ があり、これらの表現は両方とも同じになるようにします。そして、私たちが見た例は、最先端な2つのpretext変換、つまりジグソーパズルと先ほど議論した回転法です。ある意味では、これはマルチタスク学習のようなものですが、ただ本当に両方の回転を予測しようとしているわけではありません。ジグソーの回転に対しては不変であろうとします。
<!-- TODO: Could not understand "And the book paper we looked at..."-->


<!-- ###  Using a Large Number of Negatives -->
###  たくさんの負例を用いる

<!-- The key thing that has made contrastive learning work well in the past, taking successful attempts is using a large number of negatives. One of the good paper that introduced this was this instance discrimination paper from 2018, which introduced this concept of a memory bank. This is powered, most of the research methods which are state of the art techniques hinge on this idea for a memory bank. The memory bank is a nice way to get a large number of negatives without really increasing the sort of computing requirement. What you do is you store a feature vector per image in memory, and then you use that feature vector in your contrastive learning. -->
うまくいった試みを見てみると、過去にコントラスティブ学習をうまく機能させた場合に鍵となっていたのは、大量の負例を使うことでした。これを紹介した良い論文の1つが、2018年に発表されたこのインスタンス識別に関する論文です。ここでは、メモリバンクという概念を紹介しています。最先端の研究で提案される方法のほとんどは、このメモリバンクというアイデアに依拠しています。メモリバンクは、計算量を増加させることなく、多数の負例を得るための素晴らしい方法です。何をするかというと、画像ごとの特徴ベクトルをメモリに保存しておき、その特徴ベクトルをコントラスティブ学習に使用するということをします。
<!-- TODO: Could not translate "This is powered"-->

<!-- ### How it works -->
### どのように機能するか

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-2/fig16.png"
height="75%" width="75%"/><br><b>Fig. 16</b>: How does the Memory Bank Work
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig16.png"
height="75%" width="75%"/><br><b>図16</b>: メモリバンクがどのように機能するか
</center>

<!-- Let's first talk about how you would do this entire PIRL setup without using a memory bank. So you have an image $I$ and you have an image $I^t$, and you feed-forward both of these images, you get a feature vector $f(v_I)$ from the original image $I$, you get a feature $g(v_{I^t})$ from the transform versions, the patches, in this case. What you want is the features $f$ and $g$ to be similar. And you want features from any other unrelated image to basically be dissimilar. In this case, what we can do now is if you want a lot of negatives, we would really want a lot of these negative images to be feed-forward at the same time, which really means that you need a very large batch size to be able to do this. Of course, a large batch size is not really good, if not possible, on a limited amount of GPU memory. The way to do that is to use something called a memory bank. So what this memory bank does is that it stores a feature vector for each of the images in your data set, and when you're doing contrastive learning rather than using feature vectors, say, from a different from a negative image or a different image in your batch, you can just retrieve these features from memory. You can just retrieve features of any other unrelated image from the memory and you can just substitute that to perform contrastive learning. Simply dividing the objective into two parts, there was a contrasting term to bring the feature vector from the transformed image $g(v_I)$, similar to the representation that we have in the memory so $m_I$. And similarly, we have a second contrastive ConvNet that tries to bring the feature $f(v_I)$ close to the feature representation that we have in memory. Essentially $g$ is being pulled close to $m_I$ and $f$ is being pulled close to $m_I$. By transitive, $f$ and $g$ are being pulled close to one another. And the reason for separating this outwards. It's stabilized training and we were not able to train without doing this. Basically, the training would not really converge. By separating this out into two forms, rather than doing direct contrastive learning between $f$ and $g$, we were able to stabilize training and actually get it working. -->
最初に、メモリバンクを使わずにPIRLのセットアップを行う方法について説明します。画像 $I$ と画像 $I^t$ があり、これらの画像を順伝播すると、元の画像 $I$ から特徴ベクトル $f(v_I)$ が得られ、変換されたパッチから特徴量 $g(v_{I^t})$ が得られます。ここでは、特徴 $f$ と $g$ が似ていて欲しいと考えます。そして、他の無関係な画像の特徴は、基本的には似ていないものにしようとします。この場合、大量の負例画像が必要な場合は、これらの負例画像を同時に順伝播する必要があり、これを実現するには非常に大きなバッチサイズが必要になります。もちろん、限られた量のGPUメモリ上では、大きなバッチサイズは望ましくありません。そこで、メモリバンクと呼ばれるものを使用する方法があります。このメモリバンクが何をするかというと、データセット内の各画像の特徴ベクトルを保存しておくことで、コントラスティブ学習を行う際に特徴ベクトルを使用するのではなく、例えば、負例画像とは異なる画像やバッチ内の異なる画像から特徴ベクトルを取得することができるようにします。他の無関係な画像の特徴をメモリから取得して、それを代用してコントラスティブ学習を行うことができます。単に目的関数を2つの部分に分けると、まず、変換された画像$g(v_I)$からなる特徴ベクトルをメモリにある特徴表現 $m_I$に近づけるためのコントラスティブな項がありました。そして、同様に、特徴量 $f(v_I)$ をメモリ上の特徴表現に近づけようとする第二のコントラスティブな項である畳み込みニューラルネットがありました。本質的には、$g$ は $m_I$ に近づこうとしており、 $f$ も $m_I$ に近づこうとしています。推移律から、 $f$ と $g$ が互いに近くに引っ張られていることになります。これを2つに分ける理由は、安定した訓練のためであり、こうしないと訓練ができなかったからです。基本的に訓練が実際に収束することはありません。$f$と$g$の間で直接コントラスティブ学習をするのではなく、これを2つの形に分けて、訓練を安定化させることで、実際にうまくいくようにしたのです。

<!-- ### PIRL Pre-training -->
### PIRL 事前学習

<!-- The way to evaluate this is basically by standard pre-training evaluation set-up. For transfer learning, we can pretrain on images without labels. The standard way of doing this is to take an image net, throw away the labels and pretend as unsupervised. -->
これを評価する方法は、基本的には標準的な事前学習の評価の仕組みによります。転移学習では、ラベルのない画像に対して事前学習を行うことができます。標準的な方法は、ImageNetを用意してラベルを捨て、教師なしのように用いることです。

<!-- ### [Evaluation](https://www.youtube.com/watch?v=0KeR6i1_56g&t=5889s) -->
### [評価](https://www.youtube.com/watch?v=0KeR6i1_56g&t=5889s)

<!-- And then evaluating using, say, Full fine-tuning or using our training a linear classifier. The second thing we did was also our test PIRL and it's robustness to image distribution by training it on in-the-wild images. So we just took 1 million images randomly from Flickr, which is the YFCC data set. And then we basically performed pre-training on these images and then performed transplanting on different data sets. -->
そして、ネットワーク全体を学習するfine-tuningをしたり、線形分類器を最終層にくっつけて訓練をする方法を使って評価しています。2番目に行ったことは、PIRLを手を加えていないそのままの画像で訓練して、PIRLのテストと画像分布に対する頑健性を検証することです。YFCCのデータセットであるFlickrから100万枚の画像をランダムに取得しました。そして、基本的にはこれらの画像に対して事前学習を行い、そのあとで異なるデータセットに対して転移を行いました。
<!-- TODO: May be wrong translation of in-the-wild -->


<!-- #### Evaluating on Object Detection task -->
#### 物体検出タスクでの評価

<!-- PIRL was first evaluated on object detection task (a standard task in vision) and it was able to outperform ImageNet supervised pre-trained networks on both **VOC07+12** and **VOC07** data sets. In fact, PIRL outperformed even in the stricter evaluation criteria, $AP^{all}$ and that's a good positive sign. -->
PIRLは、まず物体検出タスク（視覚系の
タスクにおける標準的なタスク）で評価され、**VOC07+12**と**VOC07**の両方のデータセットについて、ImageNetで事前学習したネットワークの性能を上回ることができました。実際、PIRLは、より厳しい評価基準である$AP^{all}$でも優れた性能を示しています。これはとても良い兆しです。

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-2/fig17.png"
height="70%" width="70%"/><br><b>Fig. 17</b>: Object detection performance on different datasets
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig17.png"
height="70%" width="70%"/><br><b>図17</b>: 異なるデータセットに対する物体検出タスクの性能
</center>


<!-- #### Evaluating on Semi-supervised Learning -->
#### 半教師あり学習での評価

<!-- PIRL was then evaluated on semi-supervised learning task. Again, PIRL performed fairly well. In fact, PIRL was better than even the pre-text task of Jigsaw. The only difference between the first row and the last row is that, PIRL is an invariant version, whereas Jigsaw is a covariant version. -->
次にPIRLを半教師あり学習タスクで評価しました。ここでもPIRLはかなり良い結果が得られました。実際、ジグソーpretext taskよりもPIRLの方が良い結果が得られました。最初の行と最後の行の違いは、ジグソーが共変量版であるのに対し、PIRLは不変量版であるという違いだけです。

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-2/fig18.png"
height="70%" width="70%"/><br><b>Fig. 18</b>: Semi-supervised learning on ImageNet
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig18.png"
height="70%" width="70%"/><br><b>図18</b>: ImageNetにでの半教師あり学習
</center>


<!-- #### Evaluating on Linear Classification -->
#### 線形分類器での評価

<!-- Now when evaluating on Linear Classifiers, PIRL was actually on par with the CPCv2, when it came out. It also worked well on a bunch of parameter settings and a bunch of different architectures. And of course, now you can have fairly good performance by methods like SimCLR or so. In fact, the Top-1 Accuracy for SimCLR would be around 69-70, whereas for PIRL, that'd be around 63. -->
線形分類器の評価に関しては、それが登場したときには、実際にPIRLはCPCv2と同等の性能を持っていました。また、多くのパラメータの設定や多くの異なるアーキテクチャでも問題なく動作しました。そしてもちろん、今ではSimCLRなどの方法でかなり良い性能を発揮することができます。実際、SimCLRの一番良い精度は69-70くらいですが、PIRLの場合は63くらいになります。


<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-2/fig19.png"
height="75%" width="75%"/><br><b>Fig. 19</b>: ImageNet classification with linear models
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig19.png"
height="75%" width="75%"/><br><b>図19</b>: 線形分類器でのImageNetの分類
</center>


<!-- #### Evaluating on YFCC images -->
#### YFCC画像での評価

<!-- PIRL was evaluated on *"In-the-wild" Flickr* images from the YFCC data set. It was able to perform better than Jigsaw, even with $100$ times smaller data set. This shows the power of taking invariance into consideration for the representation in the pre-text tasks, rather than just predicting pre-text tasks. -->
PIRLは、YFCCのデータセットの中の*加工していないそのままのFlickrの*画像を用いて評価しました。PIRLは、$100$倍少ないデータセットでも、ジグソータスクよりも優れた性能を発揮することができました。このことは、単にpretext taskを予測するだけでなく、pretext taskの表現に不変性を考慮することの有効性を示しています。
<!-- TODO: May be incorrect translation of *"In-the-wild" Flickr* -->

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-2/fig20.png"
height="70%" width="70%"/><br><b>Fig. 20</b>: Pre-training on uncurated YFCC images
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig20.png"
height="70%" width="70%"/><br><b>図20</b>: 綺麗に加工されていないYFCC画像
</center>


<!-- ### Semantic Features -->
### 意味的な特徴

<!-- Now, going back to verifying the semantic features, we look at the Top-1 accuracy for PIRL and Jigsaw for different layers of representation from `conv1` to `res5`. It's interesting to note that the accuracy keeps increasing for different layers for both PIRL and Jigsaw, but drops in the 5th layer for Jigsaw. Whereas, the accuracy keeps improving for PIRL, i.e. more and more semantic. -->
次に、意味的な特徴の検証に戻って、PIRL と ジグソー の `conv1` から `res5` までの異なる表現の層における最も高い精度を見てみます。興味深いことに、PIRLとジグソーでは、それぞれの層で精度が向上していますが、ジグソーでは5層目で精度が低下していることがわかります。一方、PIRLでは精度が向上しています（層を経るごとにより意味的な特徴になっています）。

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-2/fig21.png"
height="70%" width="70%"/><br><b>Fig. 21</b>: Quality of PIRL representations per layer
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig21.png"
height="70%" width="70%"/><br><b>図21</b>: 層ごとのPIRLの表現の質
</center>


<!-- ### Scalability -->
### スケーラビリティ

<!-- PIRL is very good at handling problem complexity because you're never predicting the number of permutations, you're just using them as input. So, PIRL can easily scale to all 362,880 possible permutations in the 9 patches. Whereas in Jigsaw, since you're predicting that, you're limited by the size of your output space. -->
並べ替え方の数を予測する必要がなく、それをただ入力として使うだけなので、PIRLは問題の複雑な部分を扱うのに非常に優れています。つまり、PIRLは、9つのパッチの362880のすべての可能な順列へと簡単にスケーリングすることができます。一方、ジグソーでは、並べ替え自体を予測しているので、出力空間のサイズによって制限されてしまいます。

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-2/fig22.png"
height="70%" width="70%"/><br><b>Fig. 22</b>: Effect of varying the number of patch permutations
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig22.png"
height="70%" width="70%"/><br><b>図22</b>: パッチの並べ替え数を変化させた影響
</center>

<!-- The paper "*Misra & van der Maaten, 2019, PIRL*" also shows how PIRL could be easily extended to other tasks like Jigsaw, Rotations  and so on. Further, it could even be extended to combinations of those tasks like Jigsaw+Rotation. -->
また、「*Misra & van der Maaten, 2019, PIRL*」という論文では、PIRLをジグソーや回転予測などの他のタスクに簡単に拡張できることが示されています。さらに、ジグソーと回転予測の組み合わせのように、それらのタスクの組み合わせにも拡張することができます。

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-2/fig23.png"
height="70%" width="70%"/><br><b>Fig. 23</b>: Using PIRL with (combinations of) different pretext tasks
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig23.png"
height="70%" width="70%"/><br><b>図23</b>: 異なるpretext taskの組み合わせと共にPIRLを使う
</center>


<!-- ### Invariance vs performance -->
### 不変性 vs 性能

<!-- In terms of invariance property, one could, in general, assert that the invariance of PIRL is more than that of the Clustering, which in turn has more invariance than that of the pretext tasks. And similarly, the performance to is higher for PIRL than Clustering, which in turn has higher performance than pretext tasks. This suggests that taking more invariance in your method could improve performance. -->
不変性という点では、一般的に PIRL の不変性はクラスタリングの不変性よりも高いと断言できます。また、同様に、PIRL の方がクラスタリングよりも性能が良いです。その結果、pretext taskよりも高い性能を発揮することになります。このことから、より不変性を持たせることで性能が向上する可能性があることが示唆されました。


<!-- ### Shortcomings -->
### 欠点

<!-- 1. It's not very clear as to which set of data transforms matter. Although Jigsaw works, it's not very clear why it works.
2. Saturation with model size and data size.
3. What invariances matter? (One could think about what invariances work for a particular supervised task in general as future work.) -->
1. どのデータ変換が大事なのかがあまり明確ではありません。ジグソーはうまくいきますが、なぜ機能するのかはあまり明確ではありません。
2. モデルサイズとデータサイズによる（性能の？）飽和があります。
3. どのような不変性が重要なのかがわかっていません(特定の教師ありタスクに対してどのような不変性が働くかについては、今後の課題として一般的に考えることができます)。
<!-- TODO: Could not understand what saturation means in this context -->

<!-- So in general, we should try to predict more and more information and try to be as invariant as possible. -->
したがって、一般的には、より多くの情報を予測しようとする一方で、可能な限り不変であるようにするべきです。

<!-- ## Some important questions asked as doubts -->
## 疑問として聞かれたいくつかの重要な質問


<!-- ### Contrastive learning and batch norms -->
### コントラスティブ学習とバッチ正規化

<!-- 1. Wouldn't the network learn only a very trivial way of separating the negatives from the positives if the contrasting network uses the batch norm layer (as the information would then pass from one sample to the other)? -->
1. コントラスティブ学習を行うネットワークがバッチ正規化を使用している場合、ネットワークは正例と負例を分離するための極めて自明な方法しか学習しないのではないでしょうか？

<!-- **Ans**: *In PIRL, no such phenomenon was observed, so just the usual batch norm was used* -->
**回答**: *PIRLでは、そのような現象はみられませんでした。ですので通常のバッチ正規化を使っています。*

<!-- 2. So is it fine to use batch norms for any contrasting networks? -->
2. それではコントラスティブ学習を行う任意のネットワークに対してバッチ正規化を使っても良いのでしょうか?

<!-- **Ans**: *In general, yeah. In SimCLR, a variant of the usual batch norm is used to emulate a large batch size. So, batch norm with maybe some tweaking could be used to make the training easier* -->
**回答**: *一般にはそうです。SimCLRでは、大きなバッチサイズを使った場合を真似するために少し変わったバッチ正規化を使っています。ですので、微調整が加えられたバッチ正規化を使用することで訓練が簡単になっている可能性はあります。*

<!-- 3. Does the batch norm work in the PIRL paper only because it's implemented as a memory bank - as all the representations aren't taken at the same time? (As batch norms aren't specifically used in the MoCo paper for instance) -->
3. すべての表現が同時に取得されるわけではないと思うのですが、PIRLの論文ではバッチ正規化が機能するのはバッチ正規化がメモリバンクとして実装されているからという理由だけでしょうか？(例えば MoCo の論文ではバッチ正規化は特に使われていないので)

<!-- **Ans**: *Yeah. In PIRL, the same batch doesn't have all the representations and possibly why batch norm works here, which might not be the case for other tasks where the representations are all correlated within the batch* -->
**回答**: *そうですね。PIRLでは、同じバッチがすべての表現を持っているわけではないので、バッチ正規化が機能するのかもしれません。これは一つのバッチの中で全ての表現が相関しているような別のタスクについては必ずしも成り立つとは限りませんが。*

<!-- 4. So, other than memory bank, are there any other suggestions how to go about for n-pair loss? Should we use AlexNet or others that don't use batch norm? Or is there a way to turn off the batch norm layer? (This is for a video learning task) -->
4. ではメモリバンク以外に、n個のペアの損失をどうすればいいかについて、何か提案はありますか？AlexNetやバッチ正規化を使わない別の何かを使うべきでしょうか？それともバッチ正規化の層が働かないようにする方法があるのでしょうか？(これは動画学習タスクのためのものです。)

<!-- **Ans**: *Generally frames are correlated in videos, and the performance of the batch norm degrades when there are correlations. Also, even the simplest implementation of AlexNet actually uses batch norm. Because, it's much more stable when trained with a batch norm. You could even use a higher learning rate and you could also use for other downstream tasks. You could use a variant of batch norm for example, group norm for video learning task, as it doesn't depend on the batch size* -->
**回答**: *一般的に動画ではフレーム間に相関がありますが、相関があるとバッチ正規化の性能が低下します。また、AlexNetの最も単純な実装でも、実際にはバッチ正規化を使用しています。なぜなら、バッチ正規化を用いて学習した方が学習がはるかに安定するからです。より大きな学習率を使用することもできますし、他の下流のタスクにも使用することができます。バッチ正規化の亜種であるグループ正規化は、バッチサイズに依存しないので、例えば動画学習タスクに使うことができます。*


<!-- ### Loss functions in PIRL -->
### PIRLの損失関数

<!-- 1. In PIRL, why is NCE (Noise Contrastive Estimator) used for minimizing loss and not just the negative probability of the data distribution: $h(v_{I},v_{I^{t}})$? -->
1. PIRLでは、データ分布の負の確率だけではなく、損失を最小化するためにNCE(Noise Contrastive Estimator)が使われているのはなぜですか:$h(v_{I},v_{I^{t}})$?

<!-- **Ans**: *Actually, both could be used. The reason for using NCE has more to do with how the memory bank paper was set up. So, with $k+1$ negatives, it's equivalent to solving $k+1$ binary problem. Another way of doing it is using a softmax, where you apply a softmax and minimize the negative log-likelihood* -->
**回答**: *実はどちらも使えます。NCEを使う理由は、メモリバンクを提案した論文のセットアップが関係しています。つまり、$k+1$の負例があれば、$k+1$の二値問題を解くのと同じことになります。別の方法として、ソフトマックスを適用する方法もあります。この方法では、ソフトマックスを適用して、負の対数尤度を最小化します。*


<!-- ### Self-supervised learning project related tips -->
### 自己教師あり学習のプロジェクトに関するコツ

<!-- How do we get a simple self-supervised model working? How do we begin the implementation? -->
簡単な自己教師あり学習を機能させるためには？どのように実装し始めれば良いのか？

<!-- **Ans**: *There are a certain class of techniques that are useful for the initial stages. For instance, you could look at the pretext tasks. Rotation is a very easy task to implement. The number of moving pieces are in general good indicator. If you're planning to implement an existing method, then you might have to take a closer look at the details mentioned by the authors, like - the exact learning rate used, the way batch norms were used, etc. The more number of these things, the harder the implementation. Next very critical thing to consider is data augmentation. If you get something working, then add more data augmentation to it.* -->
**回答**: *初期の段階で役立ついくつかのテクニックがあります。例えば、pretext taskを見てみるといいでしょう。回転予測は非常に簡単に実装できるタスクです。動かす断片の数は一般的に良い指標になります。既存の手法を実装しようとしているのであれば、著者が言及している詳細をよく見てみる必要があるかもしれません。使用した正確な学習率、バッチ正規化の使用方法などです。このようなものが多くなればなるほど、実装が難しくなります。次に考慮すべき非常に重要なことは、データ拡張です。とりあえず動くものが作れたら、そこにデータ拡張を追加してください。*


<!-- ### Generative models -->
### 生成モデル

<!-- Have you thought of combining generative models with contrasting networks? -->
生成モデルとコントラスティブ学習を組み合わせることを考えたことはありますか？

<!-- **Ans**: *Generally, it's good idea. But, it hasn't been implemented partly because it is tricky and non-trivial to train such models. Integrative approaches are harder to implement, but perhaps the way to go in the future.* -->
**答え**: *一般に良いアイデアだと思います。しかし、そのようなモデルを訓練するのはトリッキーでどのように行うか非自明非なこともあって、まだ実装されていません。統合的なアプローチは単独のものより実装するのが難しいですが、おそらく進むべき方向性です。*


<!-- ### Distillation -->
### 蒸留

<!-- Wouldn't the uncertainty of the model increase when richer targets are given by softer distributions? Also, why is it called distillation? -->
ソフトな分布（ソフトラベルも考慮したデータ分布のこと）によってより豊富なターゲットが与えられると、モデルの不確かさが増すのではないでしょうか？また、なぜ蒸留と呼ばれているのでしょうか？


<!-- **Ans**: *If you train on one hot labels, your models tend to be very overconfident. Tricks like label smoothing are being used in some methods. Label smoothing is just a simple version of distillation where you are trying to predict a one hot vector. Now, rather than trying to predict the entire one-hot vector, you take some probability mass out of that, where instead of predicting a one and a bunch of zeros, you predict say $0.97$ and then you add $0.01$, $0.01$ and $0.01$ to the remaining vector (uniformly). Distillation is just a more informed way of doing this. Instead of randomly increasing the probability of an unrelated task, you have a pre-trained network to do that. In general softer distributions are very useful in pre-training methods. Models tend to be over-confident and so softer distributions are easier to train. They converge faster too. These benefits are present in distillation* -->
**回答**: *one-hotラベルで訓練すると、モデルは出力結果に対して非常に自信過剰になりがちです。そのため、ラベル平滑化のようなトリックがいくつかの手法で使われています。ラベル平滑化は、one-hotベクトルを予測しようとするような蒸留の単純な場合にすぎません。ここでは、one-hotベクトル全体を予測しようとするのではなく、その中から確率の値を取り出し、1か0かを予測する代わりに、$0.97$を予測し、残りのベクトルに$0.01$, $0.01$, $0.01$, $0.01$を一様に加えます。蒸留は、この方法をより多くの情報に基づいて行う方法にすぎません。無関係なタスクの確率をランダムに増加させる代わりに、事前学習済みのモデルを使います。一般的に、ソフトな分布は事前学習の方法では非常に有用です。モデルは出力結果を過信しがちなので、ソフトな分布の方が訓練しやすいからです。また、収束の速度も速くなります。蒸留にはこのような利点がみられます。*
