---
lang-ref: ch.10-1
title: 自己教師あり学習 - Pretext Tasks
lecturer: Ishan Misra
authors: Aniket Bhatnagar, Dhruv Goyal, Cole Smith, Nikhil Supekar
date: 6 Apr 2020
translation-date: 1 Aug 2020
translator: Shiro Takagi
lang: ja
---
<!-- TODO: Though "Pretext Task" is an important concept in SSL, I do not know the Japanese counterpart of it. So I'll use it as it is. -->

<!-- ## [Success story of supervision: Pre-training](https://www.youtube.com/watch?v=0KeR6i1_56g&t=75s) -->
## [教師あり学習のサクセスストーリー: 事前学習](https://www.youtube.com/watch?v=0KeR6i1_56g&t=75s)

<!-- In the past decade, one of the major success recipes for many different Computer Vision problems has been learning visual representations by performing supervised learning for ImageNet classification. And, using these learned representations, or learned model weights as initialization for other computer vision tasks, where a large quantum of labelled data might not be available. -->
過去10年間、様々なコンピュータビジョンの問題の中でも大きな成功の秘訣の一つは、ImageNet分類の教師あり学習による視覚的表現の学習であり、また、これらの学習で得られた表現や学習されたモデルの重みを、ラベル付けされた大量のデータが利用できない他のコンピュータビジョンのタスクの初期値として利用することです。

<!-- However, getting annotations for a dataset of the magnitude of ImageNet is immensely time-consuming and expensive. Example: ImageNet labelling with 14M images took roughly 22 human years. -->
しかし、ImageNetのような大規模なデータセットのアノテーションには、膨大な時間と費用がかかります。例えば、1400万枚の画像を用いたImageNetのラベル付けには、およそ22年の歳月がかかっています。

<!-- Because of this, the community started to look for alternate labelling processes, such as hashtags for social media images, GPS locations, or self-supervised approaches where the label is a property of the data sample itself. -->
このため、研究コミュニティは、ソーシャルメディア画像のハッシュタグ、GPS位置情報、データサンプルからラベルを作る自己教師ありのアプローチなど、ラベル付けの代替的な方法を探し始めました。

<!-- But an important question that arises before looking for alternate labelling processes is: -->
しかし、ラベリングの代替手段を探す前に生じる重要な疑問があります。

<!-- **How much labelled data can we get after all?** -->
**結局どれだけのラベル付きデータが手に入るのでしょうか？**

<!-- - If we search for all images with object-level category and bounding box annotations then there are roughly 1 million images.
- Now, if the constraint for bounding box coordinates is relaxed, the number of images available jumps to 14 million (approximately).
- However, if we consider all images available on the internet, there is a jump of 5 orders in the quantity of data available.
- And, then there is data apart from images, which requires other sensory input to capture or understand. -->
- オブジェクトレベルのカテゴリとバウンディングボックスのアノテーションを持つすべての画像を検索すると、約100万枚の画像があります。
- ここで、バウンディングボックス座標の制約を緩和すると、利用可能な画像の数は約1400万枚に跳ね上がります。
- しかし、インターネット上にある全ての画像を対象にすると、データ量は5桁も増えてしまいます。
- また、画像以外のデータもありますが、これを理解するためには他の感覚入力を必要とします。

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-1/img01.jpg" width="80%"/><br>
<b>Figure 1:</b> Variation in available data quantum basis complexity of annotation
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-1/img01.jpg" width="80%"/><br>
<b>図1:</b> アノテーションの利用可能なデータ量子基盤の複雑さのばらつき
<!-- Variation in available data quantum basis complexity of annotation -->
</center>
<!-- TODO: Could not understand what data quantum basis means. -->

<!-- Hence, drawing from the fact that ImageNet specific annotation alone took 22 human years worth of time, scaling labelling to all internet photos or beyond is completely infeasible. -->
したがって、ImageNetのアノテーションだけで22年分の時間がかかったという事実から、インターネット上のすべての写真やそれ以上の写真に対しても同じようにラベリングをすることは不可能です。

<!-- **Problem of Rare Concepts** (*Long Tail Problem*) -->
**珍しい概念の存在の問題** (*ロングテール問題（分布の裾が広がっているという問題）*)

<!-- Generally, the plot presenting distribution of the labels for internet images looks like a long tail. That is, most of the images correspond to very few labels, while there exist a large number of labels for which not many images are present. Thus, getting annotated samples for categories towards the end of the tail requires huge quantities of data to be labelled [commenting out this redundant phrase]: <> (because of the nature of the distribution of categories). -->
一般的に、インターネット上の画像のラベルの分布を示すプロットは、ロングテール（分布の裾が広がっていること）のように見えます。つまり、ほとんどの画像が非常に少ないラベルに対応している一方で、対応する画像があまり存在しないラベルが多数存在しています。したがって、分布の裾のほうのカテゴリーについてのラベル付きサンプルを取得するには、膨大な量のデータをラベル付けする必要があります。
<!-- [この冗長なフレーズをコメントアウトします]。<> (カテゴリの分布の性質上)。 -->


<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-1/img02.png" width="80%"/><br>
<b>Figure 2:</b> Variation in distribution of available images with labels
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-1/img02.png" width="80%"/><br>
<b>図2:</b> 利用可能なラベル付き画像の分布のばらつき
</center>

<!-- **Problem of Different Domains** -->
**異なるドメインという問題**

<!-- This method of ImageNet pre-training and fine-tuning on downstream task gets even murkier when the downstream task images belong to a completely different domain, such as medical imaging. And, obtaining a dataset of the quantum of ImageNet for pre-training for different domains is not possible. -->
このような、ImageNetで事前学習をして下流のタスク対してfine-tuningする方法は、下流タスクの画像が医用画像のように全く異なるドメインの画像である場合には、さらにうまくいかなくなってしまいます。また、ImageNetに相当する量のデータセットを異なるドメインの事前学習のために得ることは不可能です。
<!-- TODO: Using "downstream" and "murkier" in one sentence is neat, but I could not think of any good translation of "murkier" that respects lecturer's intention. -->


<!-- ## What is self-supervised Learning? -->
## 自己教師あり学習とは？

<!-- **Two ways to define self-supervised learning** -->
**自己教師あり学習を定義する2つの方法**

<!-- - **Basis supervised learning definition**, i.e. the network follows supervised learning where labels are obtained in a semi-automated manner, without human input.
- **Prediction problem**, where a part of the data is hidden, and rest visible. Hence, the aim is to either predict the hidden data or to predict some property of the hidden data. -->
- **教師あり学習に基づく定義**：例えば、ラベルが人間の入力なしに半自動的に手に入る状況でネットワークを教師あり学習すること。
- **予測問題**：データの一部が隠れていて、残りが観測可能であるような状況。したがって、目的は、隠されたデータを予測するか、隠されたデータの特性を予測すること。

<!-- **How self-supervised learning differs from supervised learning and unsupervised learning?** -->
自己教師あり学習は教師あり学習と教師なし学習とどのような点で異なるのか？

<!-- - Supervised learning tasks have pre-defined (and generally human-provided) labels,
- Unsupervised learning has just the data samples without any supervision, label or correct output.
- Self-supervised learning derives its labels from a co-occurring modality for the given data sample or from a co-occurring part of the data sample itself. -->
- 教師あり学習タスクには、あらかじめ定義された（一般的には人間が提供する）ラベルがあります。
- 教師なし学習では、教師信号、ラベル、正しい出力は無く、データサンプルのみがあります。
- 自己教師あり学習は、与えられたデータサンプルと共起するモダリティ、またはデータサンプル自体の共起する部分からラベルを導き出します。


<!-- ### Self-Supervised Learning in Natural Language Processing -->
### 自然言語処理における自己教師あり学習

<!-- #### Word2Vec -->
#### Word2Vec

<!-- - Given an input sentence, the task involves predicting a missing word from that sentence, which is specifically omitted for the purpose of building a pretext task.
- Hence, the set of labels becomes all possible words in the vocabulary, and, the correct label is the word that was omitted from the sentence.
- Thus, the network can then be trained using regular gradient-based methods to learn word-level representations. -->
- このタスク（Word2Vec）では、入力文が与えられると、pretext task を構築する目的でその文から意図的に省略された単語を予測しなければなりません。
- したがって、ラベルの集合は語彙の中のすべての可能な単語になり、正しいラベルは文から省略された単語になります。
- このようにして、通常の勾配に基づく方法を用いて、ネットワークに単語レベルの表現を学習させることができます。


<!-- ### Why self-supervised learning? -->
### なぜ自己教師あり学習なのか？

<!-- - Self-supervised learning enables learning representations of data by just observations of how different parts of the data interact.
- Thereby drops the requirement of huge amount of annotated data.
- Additionally, enables to leverage multiple modalities that might be associated with a single data sample. -->
- 自己教師あり学習では、データの異なる部分がどのように相互作用するかを観測するだけで、データの表現を学習することができます。
- これにより、膨大な量のラベル付きデータが必要なくなります。
- さらに、一つのデータサンプルに関連した複数のモダリティを活用することができます。


<!-- ### Self-Supervised Learning in Computer Vision -->
## コンピュータービジョンにおける自己教師あり学習

<!-- Generally, computer vision pipelines that employ self-supervised learning involve performing two tasks, a pretext task and a real (downstream) task. -->
一般的に、自己教師あり学習を採用したコンピュータビジョンの工程では、pretext taskと実際の（下流の）タスクの2つのタスクを実行します。

<!-- - The real (downstream) task can be anything like classification or detection task, with insufficient annotated data samples.
- The pretext task is the self-supervised learning task solved to learn visual representations, with the aim of using the learned representations or model weights obtained in the process, for the downstream task. -->
- 実際の（下流の）タスクは、分類タスクや検出タスクのように、アノテーションされたデータサンプルが不十分なものであれば何でも構いません。
- Pretext taskは、視覚的表現を学習するために解いた自己教師あり学習タスクであり、学習した表現やその過程で得られたモデルの重みを下流のタスクに利用することを目的としています。


<!-- #### Developing pretext tasks -->
#### Pretext task を開発する

- コンピュータビジョンの問題のためのpretext taskは、画像、動画、または動画と音声のどちらも、のいずれかを使用して開発することができます。
- それぞれのpretext taskには、観測可能なデータと不可能なデータがあり、観測されていないデータそのものもしくはその性質のいずれかを予測することがタスクとなります。


<!-- #### [Example pretext tasks: Predicting relative position of image patches](https://www.youtube.com/watch?v=0KeR6i1_56g&t=759s) -->
#### [Pretext taskの例: 画像のパッチの相対的な位置を予測する](https://www.youtube.com/watch?v=0KeR6i1_56g&t=759s)

<!-- - Input: 2 image patches, one is the anchor image patch while the other is the query image patch.
- Given the 2 image patches, the network needs to predict the relative position of the query image patch with respect to the anchor image patch.
- Thus, this problem can be modelled as an 8-way classification problem, since there are 8 possible locations for a query image, given an anchor.
- And, the label for this task can be automatically generated by feeding the relative position of query patch with respect to the anchor. -->
- 入力: アンカー画像パッチ（相対位置の起点となる画像パッチ）とクエリ画像パッチ（相対位置を知りたい画像パッチ）からなる2つの画像パッチ。
- 2つの画像パッチが与えられると、ネットワークはアンカー画像パッチに対するクエリ画像パッチの相対的な位置を予測しなければいけません。
- したがって、この問題は8-way分類問題としてモデル化することができます。
- また、アンカーに対するクエリー画像の相対位置を与えることで、この問題のラベルを自動的に生成することができます。

注：~way分類問題とは，~値分類だと思って差し支えないと思います。CV、few-shot学習の文脈とかでこのような使われ方を見かけます。クエリ画像などの用語も同様です。（by translator）

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-1/img03.jpg" width="70%"/><br>
<b>Figure 3:</b> Relative Position task
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-1/img03.jpg" width="70%"/><br>
<b>図3:</b> 相対位置予測タスク
</center>



<!-- #### Visual representations learned by relative position prediction task -->
#### 相対位置予測タスクで学習した視覚表現

<!-- We can evaluate the effectiveness of the learned visual representations by checking nearest neighbours for a given image patch basis feature representations provided by the network. For computing nearest neighbours of a given image patch, -->
学習した視覚表現の有効性を評価するために、ネットワークから提供された画像パッチベースの特徴表現に対する最近傍を調べることができます。与えられた画像パッチの最近傍を計算するために、

<!-- - Compute the CNN features for all images in the dataset, that will act as the sample pool for retrieval.
- Compute CNN features for the required image patch.
- Identify nearest neighbours for the feature vector of the required image, from the pool of feature vectors of images available. -->
- データセット内のすべての画像について、CNNの出力を用いた特徴量（CNN特徴量）を計算します。これは、検索されるサンプルプールとして機能します。
- 要求された画像パッチのCNN特徴量を計算します。
- 利用可能な画像の特徴ベクトルのプールから、要求された画像の特徴ベクトルの最近傍を識別する。

<!-- Relative position task finds out image patches that are very similar to the input image patch, while maintains invariance to factors such as object colour. Thus, the relative position task is able to learn visual representations, where representations for image patches with similar visual appearance are closer in the representation space as well. -->
相対位置予測タスクは、物体の色などの要素に対する不変性を保ちながら、入力画像パッチと非常に類似した画像パッチを見つけ出します。このようにして、相対位置予測タスクは、視覚的に類似した外観を持つ画像パッチの表現が表現空間においてもより近くなるような視覚表現を学習することができます。

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-1/img04.jpg" width="100%"/><br>
<b>Figure 4:</b> Relative Position: Nearest Neighbours
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-1/img04.jpg" width="100%"/><br>
<b>図4:</b> 相対位置: 最近傍
</center>


<!-- #### Predicting Rotation of Images -->
#### 画像の回転の予測

<!-- - Predicting rotations is one of the most popular pretext task which has a simple and straightforward architecture and requires minimal sampling.
- We apply rotations of 0, 90, 180, 270 degrees to the image and send these rotated images to the network to predict what sort of rotation was applied to the image and the network simply performs a 4-way classification to predict the rotation.
- Predicting rotations does not make any semantic sense, we are just using this pretext task as a proxy to learn some features and representations to be used in a downstream task. -->
- 回転の予測は、単純で簡単な構成で最小限のサンプリングで済む最もよく使われるpretext taskの一つです。
- 画像に0, 90, 180, 270度の回転を適用し、画像にどのような回転が適用されたかを予測するためにこれらの回転した画像をネットワークに入力します。ネットワークは単に回転を予測するために4つの回転方向の分類を行います。
- 回転を予測すること自体に意味はありません。私たちは、下流のタスクで使用するための特徴や表現を学習するための代わりとして、このpretext taskを使用しているだけです。

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-1/img05.png" width="80%"/><br>
<b>Figure 5:</b> Rotations of Image
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-1/img05.png" width="80%"/><br>
<b>図5:</b> 画像の回転
</center>


<!-- #### Why rotation helps or why it works? -->
#### なぜ回転が役に立つのか、なぜうまくいくのか？

<!-- It has been proven that it works empirically. The intuition behind it is that in order to predict the rotations, model needs to understand the rough boundaries and representation of an image. For example, it will have to segregate the sky from water or sand from the water or will understand that trees grow upwards and so on. -->
これは経験的にうまくいくことが示めされています。その背後にある直感は、回転を予測するためには、モデルが画像の大まかな境界や表現を理解する必要があるということです。例えば、水から空を分離したり、水から砂を分離したり、木が上向きに成長することを理解する必要があります。


<!-- #### Colourisation -->
#### 色付け

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-1/img06.png" width="65%"/><br>
<b>Figure 6:</b> Colourisation
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-1/img06.png" width="65%"/><br>
<b>図6:</b> 色付け
</center>

<!-- In this pretext task, we predict the colours of a grey image. It can be formulated for any image, we just remove the colour and feed this greyscale image to the network to predict its colour. This task is useful in some respects like for colourising the old greyscale films [//]: <> (we can apply this pretext task). The intuition behind this task is that the network needs to understand some meaningful information like that the trees are green, the sky is blue and so on. -->
このpretext taskでは、グレースケール画像の色を予測します。これはどのような画像に対しても定式化することができます。画像の色を除去して、その色を予測するためにこのグレースケール画像をネットワークに与えるだけです。このタスクは、例えば古いグレースケールのフィルムの色付けに使えるように、いくつかの点で有用です[//]: <> (このpretext taskを適用することができます)。このタスクの背後にある直感は、このタスクを解くためには、木が緑であること、空が青であることなどの意味のある情報を、ネットワークが理解しなければならないということです。

<!-- It is important to note that colour mapping is not deterministic, and several possible true solutions exist. So, for an object if there are several possible colours then the network will colour it as grey which is the mean of all possible solutions. There have been recent works using Variational Auto Encoders and latent variables for diverse colourisation. -->
カラーマッピングは決定論的ではなく、いくつかの真の解が存在することに注意することが重要です。つまり、ある物体の色にいくつかの可能性がある場合、ネットワークはそれをすべての可能な解の平均値である灰色に着色します。最近では、多様な色付けのために変分オートエンコーダーと潜在変数を使用したものがあります。


#### 空白を埋める
<!-- #### Fill in the blanks -->

<!-- We hide a part of an image and predict the hidden part from the remaining surrounding part of the image. This works because the network will learn the implicit structure of the data like to represent that cars run on roads, buildings are composed of windows & doors and so on. -->
画像の一部を隠して、残りの周囲の部分から隠された部分を予測します。これがうまくいくのは、車は道路を走っている、建物は窓とドアで構成されているなど、データの暗黙の構造をネットワークが学習するためです。


<!-- ### Pretext Tasks for videos -->
### 動画のPretext Task

<!-- Videos are composed of sequences of frames and this notion is the idea behind self-supervision, which can be leveraged for some pretext tasks like predicting the order of frames, fill in the blanks and object tracking. -->
動画は連続したフレームで構成されており、フレームの順番を予測したり、空白を埋めたり、オブジェクトを追跡したりするような、いくつかのpretext taskに活用することができます。
<!-- TODO: Could not get what the orignial text means. So I ignored some part of the sentence. -->


<!-- #### Shuffle & Learn -->
#### シャッフルして学習する（Shuffle & Learn）

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-1/img07.png" width="70%"/><br>
<b>Figure 7:</b> Interpolation
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-1/img07.png" width="70%"/><br>
<b>図7:</b> 補完
</center>

<!-- Given a bunch of frames, we extract three frames and if they are extracted in the right order we label it as positive, else if they are shuffled, label it as negative. This now becomes a binary classification problem to predict if the frames are in the right order or not. So, given a start and end point, we check if the middle is a valid interpolation of the two. -->
いくつかの動画フレームが与えられたとして、その中の3つのフレームを抽出して、それらが正しい順序で抽出されていれば正のラベルを付け、そうでなくてシャッフルされていれば負のラベルを付けます。これは、フレームが正しい順番にあるかどうかを予測する二値分類問題になります。そこで、開始点と終了点が与えられている場合、中間点が有効な補間であるかどうかを確かめます。

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-1/img08.png" width="70%"/><br>
<b>Figure 8:</b> Shuffle & Learn architecture
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-1/img08.png" width="70%"/><br>
<b>図8:</b> シャッフルして学習（Shuffle & Learn）、の概念図
</center>

<!-- We can use a triplet Siamese network, where the three frames are independently fed forward and then we concatenate the generated features and perform the binary classification to predict if the frames are shuffled or not. -->
3つのフレームを独立に順伝播させ、生成された特徴量を連結して2値分類を行い、フレームがシャッフルされているかどうかを予測するtriplet Siameseネットワークを使用することができます。

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-1/img09.png" width="100%"/><br>
<b>Figure 9:</b> Nearest Neighbours Representation
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-1/img09.png" width="100%"/><br>
<b>図9:</b> 最近傍表現
</center>

<!-- Again, we can use the Nearest Neighbours algorithm to visualize what our networks are learning. In fig. 9 above, first we have a query frame which we feed-forward to get a feature representation and then look at the nearest neighbours in the representation space. While comparing, we can observe a stark difference between neighbours obtained from ImageNet, Shuffle & Learn and Random. -->
ここでも、最近傍アルゴリズムを使用して、ネットワークが何を学習しているかを可視化することができます。上の図9では、まずクエリフレームを順伝播して特徴表現を取得し、その表現空間内の最近傍を見ています。比較してみると、ImageNetの学習、Shuffle & Learn、ランダムで得られた近傍の間には大きな違いがあることがわかります。

<!-- ImageNet is good at collapsing the entire semantic as it could figure out that it is a gym scene for the first input. Similarly, it could figure out that it is an outdoor scene with grass etc. for the second query. Whereas, when we observe Random we can see that it gives high importance to the background colour. -->
ImageNetを学習したモデルは、最初の入力からジムの写真であることが分かるように、意味的な情報全体を取り出すことを得意としています。同様に、2番目のクエリでは、草などが生えている屋外の写真であることがわかります。一方、ランダムを観察すると、背景色を重視していることがわかります。
<!-- TODO: Not good translation. -->

<!-- On observing Shuffle & Learn, it is not immediately clear whether it is focusing on the colour or on the semantic concept. After further inspection and observing various examples, it was observed that it is looking at the pose of the person. For example, in the first image the person is upside down and in second the feet are in a particular position similar to query frame, ignoring the scene or background colour. The reasoning behind this is that our pretext task was predicting whether the frames are in the right order or not, and to do this the network needs to focus on what is moving in the scene, in this case, the person. -->
Shuffle & Learnを観察しても、色を重視しているのか、意味的な概念を重視しているのかはすぐにはわかりません。さらに調べてみると、様々な例を観察した結果、人のポーズを見ていることがわかりました。例えば、最初の画像では人物が逆さまになっており、2番目の画像ではシーンや背景色を無視して、足の位置がクエリフレームと同じような特定の位置にあることがわかります。これは、私たちののpretext taskがフレームの順番が正しいかどうかを予測していたためで、そのためには動画内で動いているもの、この場合は人物に焦点を当てる必要があったからです。

<!-- It was verified quantitatively by fine-tuning this representation to the task of human key-point estimation, where given a human image we predict where certain key points like nose, left shoulder, right shoulder, left elbow, right elbow, etc. are. This method is useful for tracking and pose estimation. -->
この表現を、人間のキーポイント推定のタスクに対してfine-tuningすることで、定量的に検証しました。このタスクでは人間の画像が与えられたときに、鼻、左肩、右肩、左肘，右肘などのキーポイントを予測します。この手法はトラッキングや姿勢推定に有効です。

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-1/img10.png" width="80%"/><br>
<b>Figure 10:</b> Key point Estimation comparison
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-1/img10.png" width="80%"/><br>
<b>図10:</b> キーポイント推定の比較
</center>

<!-- In figure 10, we compare the results for supervised ImageNet and Self-Supervised Shuffle & Learn on FLIC and MPII datasets and we can see that Shuffle and Learn gives good results for key point estimation. -->
図10から、ImageNetを用いた教師あり学習の結果と、FLICとMPIIのデータセットを用いたShuffle & Learnによる自己教師あり学習の結果を比較したところ、Shuffle & Learnがキーポイント推定に対して良い結果を示していることがわかります。


<!-- ### Pretext Tasks for videos and sound -->
### 動画と音声に対するPretext Tasks
<!-- 
Video and Sound are multi-modal where we have two modalities or sensory inputs one for video and one for sound. Where we try to predict whether the given video clip corresponds to the audio clip or not. -->
動画と音声は、それぞれが一つの感覚入力に対応したマルチモーダルな情報です。ここで、与えられた動画クリップが音声クリップに対応しているかどうかを予測することを考えます。

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-1/img11.png" width="100%"/><br>
<b>Figure 11:</b> Video and sound sampling
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-1/img11.png" width="100%"/><br>
<b>図11:</b> 動画と音声のサンプリング
</center>

<!-- Given a video with audio of a drum, sample the video frame with corresponding audio and call it a positive set. Next, take the audio of a drum and the video frame of a guitar and tag it as a negative set. Now we can train a network to solve this as a binary classification problem. -->
ドラムの音が入った動画に対して、それに対応する音が入った動画フレームをサンプリングして、それを正のセットと呼びます。次に、ドラムの音とギターの動画フレームをサンプリングして、それを負の集合としてタグ付けします。これで、動画と音を対応づける問題を二値分類問題として解くためのネットワークを訓練することができるようになりました。

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-1/img12.png" width="70%"/><br>
<b>Figure 12:</b> Architecture
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-1/img12.png" width="70%"/><br>
<b>図12:</b> アーキテクチャ
</center>

<!-- **Architecture:** Pass the video frames to the vision subnetwork and pass the audio to the audio subnetwork, which gives 128-dimensional features and embeddings, we then fuse them together and solve it as a binary classification problem predicting if they correspond with each other or not. -->
**アーキテクチャ:**　動画フレームを視覚タスクを解く部分ネットワークに入力し、音を音声タスクを解くサブネットワークに入力し、128次元の特徴量と埋め込みを得ます。そしてそれらを融合させて互いに対応しているかどうかを予測する二値分類問題として解きます。

<!-- It can be used to predict what in the frame might be making a sound. The intuition is if it is the sound of a guitar, the network roughly needs to understand how the guitar looks and same should be true for drums. -->
これは、フレーム内の何が音を出しているのかを予測するのに使われます。直感的には、ギターの音であれば、ネットワークはギターがどのように見えるかを大まかに理解する必要があり、ドラムについても同じことが言えます。


<!-- ## [Understanding what the "pretext" task learns](https://www.youtube.com/watch?v=0KeR6i1_56g&t=2426s) -->
## [「pretext」task が何を学習するかを理解する](https://www.youtube.com/watch?v=0KeR6i1_56g&t=2426s)

<!-- * Pretext tasks should be **complementary** -->
* Pretext taskは、**補完的**なものでなければなりません。

   * 例えば、*相対位置予測タスク* と *色付けタスク* というpretext taskを例に挙げてみましょう。以下に示すように，両方のpretext taskを学習するモデルを学習することで，パフォーマンスを向上させることができます。

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-1/img13.png" width="80%"/><br>
<b>Figure 13:</b> Comparison of disjoint vs combined training of Relative Position and Colourisation pretext tasks. ResNet101. (Misra)
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-1/img13.png" width="80%"/><br>
<b>図13:</b> 相対位置予測タスクと色付けタスクをそれぞれ解かせた場合と一緒に解かせた場合の比較。ResNet101。(Misra)
</center>

  <!-- * A single pretext task may not be the right answer to learn SS representations -->
  * 自己教師あり学習の表現を学習するためには、ただ一つのpretext taskを解かせることが正解ではないかもしれません。

<!-- * Pretext tasks vary greatly in what they try to predict (difficultly) -->
* Pretext taskは何を予測しようとしているかの点で大きく異なります(難しさ)

  <!-- * Relative position is easy since it's a simple classification -->
  <!-- * Masking and fill-in is far harder -> **better representation** -->
  <!-- * **Contrastive methods** generate even more info than pretext tasks -->
  
  * 相対位置予測タスクは単純な分類問題なので簡単です。
  * マスキングや補完ははるかに難しいです。したがって、**より良い表現**が得られます。
  * **コントラスティブ法** はpretext taskよりもさらに多くの情報を生み出します。

<!-- * **Question:** How do we train multiple pre-training tasks? -->
* **質問:** どのようにして複数の事前学習を行うのですか？

  <!-- * The pretext output will depend on the input. The final fully-connected layer of the network can be **swapped** depending on the batch type. -->
  <!-- * For example: A batch of black-and-white images is fed to the network in which the model is to produce a coloured image. Then, the final layer is switched, and given a batch of patches to predict relative position. -->
  * Pretextの出力は入力に依存します。最後の全結合層はバッチの種類に応じて**取り換える**ことができます。
    * 例えば、白黒画像のバッチデータがネットワークに入力され、モデルがカラー画像を生成するとします。次に、最終レイヤーを切り替え、相対位置を予測するためのパッチのバッチデータを与えます。

<!-- *  **Question:** How much should we train on a pretext task? -->
*  **質問:** Pretext taskでどの程度学習した方が良いですか?

  <!-- * Rule of thumb: Have a very difficult pretext task such that it improves the downstream task.
  * In practice, the pretext task is trained, and may not be re-trained. In development, it is trained as part of the entire pipeline. -->
  * 経験則：下流のタスクを改善するように非常に難しいpretext taskを使用します。
  * 実応用上は、pretext taskは再訓練されることはありません。開発では、全工程の一部として訓練されます。


<!-- ## Scaling Self-Supervised Learning -->
## 自己教師あり学習をスケールさせる


<!-- ### Jigsaw Puzzles -->
### ジグゾーパズル

<!-- * Partition an image into multiple tiles and then shuffle these tiles. The model is then tasked with un-shuffling the tiles back to the original configuration. (Noorozi & Favaro, 2016) -->
* 画像を複数のタイルに分割し、これらのタイルをシャッフルします。モデルはその後、タイルを元の位置に戻すためにシャッフルを解除する作業を行います(Noorozi & Favaro, 2016)。

  <!-- * Predict which permutation was applied to the input
  * This is done by creating batches of tiles such that **each tile of an image is evaluated independently**. The convolution output are then concatenated and the permutation is predicted as in figure below -->
  * 入力にどの並び替えが適用されたかを予測します。
  * これは、**画像の各タイルが独立して評価される**ようなタイルのバッチを作成することで行われます。次に、畳み込みネットワークからの出力が連結され、以下の図のようにタイルの並べ替えの予測が行われます。

<!-- <center>
<img src="{{site.baseurl}}/images/week10/10-1/img14.png" width="80%"/><br>
<b>Figure 14:</b> Siamese network architecture for a Jigsaw pretext task. Each tile is passed through independently, with encodings concatenated to predict a permutation. (Misra)
</center> -->
<center>
<img src="{{site.baseurl}}/images/week10/10-1/img14.png" width="80%"/><br>
<b>図14:</b> ジグゾーpretext taskを解くためのSiameseネットワークアーキテクチャ。各タイルは独立に入力され、並び順を予測するために連結された埋め込みを使用します。(Misra)
</center>

  <!-- * Considerations:
    1. Use a subset of permutations (i.e.: From 9!, use 100)
    2. The n-way ConvNet uses shared parameters
    3. The problem complexity is the size of the subset. The *amount of information you are predicting.* -->
  * 考慮すべきこと
    1. 並び順の部分集合を使用してください（例：9から100を使用してください）。
    2. n-way ConvNetはパラメータ共有をします。
    3. 問題の複雑さは、部分集合の大きさです。これはすなわち*予測している情報の量です。*

<!-- * Sometimes, this method can perform better on downstream tasks than supervised methods, since the network is able to learn some concepts about the geometry of its input. -->
* この方法は、ネットワークが入力の形状に関する概念を学習することができるため、教師ありの手法よりも下流のタスクで優れた性能を発揮することがあります。

<!-- * Shortcomings: Few Shot Learning: Limited number of training examples -->
* 欠点： few-shot学習のような訓練データ数が限られている場合

  <!-- * **Self-supervised representations are not as sample efficient** -->
  * **自己教師あり表現はサンプル効率が悪いです**


<!-- ### Evaluation: Fine-tuning vs Linear Classifier -->
### 評価: Fine-tuning vs 線形分類器

  <!-- This form of evaluation is a kind of **Transfer Learning**. -->
  この形の評価は、ある種の**転移学習**です。

<!-- * **Fine Tuning**: When applying to our downstream task, we use our entire network as an **initialization** for which to train a new one, updating all the weights. -->
* **Fine Tuning**：下流のタスクに適用する場合は、ネットワーク全体を**初期状態**として使用し、そこからすべての重みを更新して新しいネットワークを訓練します。

<!-- * **Linear Classifier**: On top of our pretext network, we train a small linear classifier to perform our downstream task, leaving the rest of the network intact. -->
* **線形分類器**：ネットワークの残りの部分をそのままにして、Pretext task を解かせたネットワークの上に、 下流のタスクを実行するための小さな線形分類器を追加し、これを訓練します。

<!-- > A good representation should transfer with a **little training**. -->

<!-- * It is helpful to evaluate the pretext learning on a **multitude of different tasks**. We can do so by extracting the representation created by different layers in the network as **fixed features** and evaluating their usefulness across these different tasks.
  * Measurement: Mean Average Precision (mAP) --The precision averaged across all the different tasks we are considering.
  * Some examples of these tasks include: Object Detection (using fine-tuning), Surface Normal Estimation (see NYU-v2 dataset)
* What does each layer learn?
  * Generally, as the layers become deeper, the mean average precision on downstream tasks using their representations will increase.
  * However, the **final layer** will see a sharp drop in the mAP due to the layer becoming overly **specialized**.
    * This contrasts with supervised networks, in that the mAP generally always increases with depth of layer.
    * This shows that the pretext task is **not well-aligned** to the downstream task. -->

* Pretextの学習を **様々なタスク** で評価することは有用です。これは、ネットワークの異なる層が生成した表現を**固定特徴**として抽出し、これらの異なるタスクでの有用性を評価することで可能になります。
  * 測定法: Mean Average Precision （mAP）（平均適合率の平均）：考慮しているすべての異なるタスクで平均化された平均適合率。
  * これらのタスクのいくつかの例として次のようなものがあります: 物体検出（fine-tuningを使用）、表面法線推定（Surface Normal Estimation）（NYU-v2 データセットをみてください）
* 各層は何を学習しているのか？
  * 一般に、深い層の表現を用いるほど下流のタスクでのmAPは高くなります。
  * しかし、**最終層**では、層が**専門化しすぎている**ため、mAPが急激に低下します。
    * これは一般的にmAPが層の深さに応じて常に増加する教師ありネットワークとは対照的です。
    * このことは、pretext taskが下流のタスクにうまく**調整されていない**ことを示しています。
