---
lang-ref: ch.09-3
title: Generative Adversarial Networks
lecturer: Alfredo Canziani
authors: William Huang, Kunal Gadkar, Gaomin Wu, Lin Ye
date: 31 Mar 2020
lang: ja
translation-date: 6 Dec 2020
translator: Shiro Takagi
---


<!-- ## [Introduction to generative adversarial networks (GANs)](https://www.youtube.com/watch?v=xYc11zyZ26M&t=57s) -->
## [敵対的生成ネットワーク(GANs)の導入](https://www.youtube.com/watch?v=xYc11zyZ26M&t=57s)

<!-- <center>
<img src="{{site.baseurl}}/images/week09/09-3/GANArchitecture.png" height="400px" /><br>
<b>Fig. 1</b>: GAN Architecture
</center> -->
<center>
<img src="{{site.baseurl}}/images/week09/09-3/GANArchitecture.png" height="400px" /><br>
<b>図1</b>: GANのアーキテクチャ
</center>

<!-- GANs are a type of neural network used for unsupervised machine learning. They are comprised of two adversarial modules: _generator_ and _cost_ networks. These modules compete with each other such that the _cost_ network tries to filter fake examples while the _generator_ tries to trick this filter by creating realistic examples $\vect{\hat{x}}$. Through this competition, the model learns a generator that creates realistic data. They can be used in tasks such as future predictions or for generating images after being trained on a particular dataset. -->
GANは教師なし機械学習に使用されるニューラルネットワークの一種です。GANは2つの敵対的なモジュールで構成されています。_generator_ ネットワークと　_cost_ ネットワークです。_cost_　ネットワークが偽の例をフィルタリングしようとするのに対し、_generator_　は現実的な例を作ることでこのフィルタを騙そうとすることで、これらのモジュールは互いに競合します。この競争を通じて、モデルは現実的なデータを生成する生成器を学習します。将来予測や、特定のデータセットで訓練された後の画像生成などのタスクで使用することができます。

<!-- <center>
<img src="{{site.baseurl}}/images/week09/09-3/GANMapping.png" height="400px" /><br>
<b>Fig. 2</b>: GAN Mapping from Random Variable
</center> -->
<center>
<img src="{{site.baseurl}}/images/week09/09-3/GANMapping.png" height="400px" /><br>
<b>図2</b>: ランダム変数からのGANの写像
</center>

<!-- GANs are examples of energy based models (EBMs). As such, the cost network is trained to produce low costs for inputs closer to the true data distribution denoted by the pink $\vect{x}$ in Fig. 2. Data from other distributions, like the blue $\vect{\hat{x}}$ in Fig. 2, should have high cost. A mean squared error (MSE) loss is typically used to calculate the cost network's performance. It is worth noting that the cost function outputs a positive scalar value within a specified range (i.e. $\text{cost} : \mathbb{R}^n \rightarrow \mathbb{R}^+ \cup \{0\}$). This is unlike a classic discriminator which uses discrete classification for its outputs. -->

GAN はエネルギーベースモデル（EBM）の一例です。したがって、コストネットワークは、図２のピンクの $\vect{x}$ で示される真のデータ分布に近い入力に対して低いコストを出力するように訓練されます。図２の青い $\vect{\hat{x}}$ のような他の分布からのデータは、高いコストを持たなければいけません。コストネットワークの性能を計算するために、一般的に平均二乗誤差（MSE）が使用されます。ここで注目すべきは、コスト関数が、指定された範囲内で正のスカラー値を出力することです（例えば$\text{cost} : \mathbb{R}^n \rightarrow \mathbb{R}^+ \cup \{0\}$）。これは、離散的な分類結果を出力に用いる通常の識別器とは異なります。

<!-- Meanwhile, the generator network ($\text{generator} : \mathcal{Z} \rightarrow \mathbb{R}^n$) is trained to improve its mapping of random variable $\vect{z}$ to realistic generated data $\vect{\hat{x}}$ to trick the cost network. The generator is trained with respect to the cost network's output, trying to minimize the energy of $\vect{\hat{x}}$. We denote this energy as $C(G(\vect{z}))$, where $C(\cdot)$ is the cost network and $G(\cdot)$ is the generator network. -->

一方、生成器（$\text{generator} : \mathcal{Z} \rightarrow \mathbb{R}^n$）は、ランダムな変数$\vect{z}$から、コストネットワークを騙すための本物のようなデータ$\vect{\hat{x}}$への写像を改善するように、訓練されます。生成器は、コストネットワークの出力について、$\vect{\hat{x}}$のエネルギーを最小にするように学習します。このエネルギーを$C(G(\vect{z}))$と呼びますが、ここでは、$C(\cdot)$がコストネットワーク、$G(\cdot)$が生成ネットワークです。

<!-- The training of the cost network is based on minimizing the MSE loss, while the training of the generator network is through minimizing the cost network, using gradients of $C(\vect{\hat{x}})$ with respect to $\vect{\hat{x}}$. -->
コストネットワークの訓練は、MSE損失を最小化することを基本とし、生成ネットワークの訓練は、$\vect{\hat{x}}$についての$C(\vect{\hat{x}})$の勾配を用いて、コストネットワークを最小化することで行います。

<!-- To ensure that high cost is assigned to points outside the data manifold and low cost is assigned to points within it, the loss function for the cost network $\mathcal{L}\{C}$ is $C(x)+[m-C(G(\vect{z}))]^+$ for some positive margin $m$. Minimizing $\mathcal{L}\{C}$ requires that $C(\vect{x}) \rightarrow 0$ and $C(G(\vect{z})) \rightarrow m$. The loss for the generator $\mathcal{L}\{G}$ is simply $C(G(\vect{z}))$, which encourages the generator to ensure that $C(G(\vect{z})) \rightarrow 0$. However, this does create instability as $0 \leftarrow C(G(\vect{z})) \rightarrow m$. -->

データ多様体の外側の点に対してはコストが高く、内側の点に対してはコストが低くなるように、コストネットワークの損失関数 $\mathcal{L}_{C}$ は、ある正のマージン$m$に対して $C(x)+[m-C(G(\vect{z}))]^+$となります。$\mathcal{L}_{C}$を最小化するためには、$C(\vect{x}) \rightarrow 0$であり$C(G(\vect{z})) \rightarrow m$であることが必要です。生成器の損失$\mathcal{L}_{G}$は単純に $C(G(\vect{z}))$ であり、これは生成器が確実に $C(G(\vect{z})) \rightarrow 0$ となるように促します。 しかし、これは $0 \leftarrow C(G(\vect{z})) \rightarrow m$ のように不安定になります。


<!-- ## [Difference between GANs and VAEs](https://www.youtube.com/watch?v=xYc11zyZ26M&t=1844s) -->
## [GANとVAEの違い](https://www.youtube.com/watch?v=xYc11zyZ26M&t=1844s)

<!-- <center>
<img src="{{site.baseurl}}/images/week09/09-3/GANvsVAEArchitecture.png" height="400px" /><br>
<b>Fig. 3</b>: VAE (left) vs. GAN (right) - Architectural design
</center> -->
<center>
<img src="{{site.baseurl}}/images/week09/09-3/GANvsVAEArchitecture.png" height="400px" /><br>
<b>図3</b>: VAE (左) vs. GAN (右) - アーキテクチャのデザイン
</center>

<!-- Compared to Variational Auto-Encoders (VAEs) from week 8, GANs create generators slightly differently. Recall, VAEs map inputs $\vect{x}$ to a latent space $\mathcal{Z}$ with an _encoder_ and then maps from $\mathcal{Z}$ back to the data space with a _decoder_ to get $\vect{\hat{x}}$. It then uses the reconstruction loss to push $\vect{x}$ and $\vect{\hat{x}}$ to be similar. GANs, on the other hand, train through an adversarial setting with the generator and cost networks competing as described above. These networks are successively trained through backpropagation through gradient based methods. Comparison of this architectural difference can be seen in Fig. 3. -->
第８週の変分オートエンコーダー(VAE)と比較して、GANはジェネレーターの作成方法が少し異なります。VAEは、_encoder_　で入力$\vect{x}$を潜在空間$\mathcal{Z}$に写像し、　_decoder_　で$\mathcal{Z}$からデータ空間に写像することで、$\vect{\hat{x}}$を得るのでした。そして、再構成誤差を利用して、$\vect{x}$と$\vect{\hat{x}}$を似たようなものにしていました。一方、GANは、上述したように、生成ネットワークとコストネットワークが競合する敵対的な設定で訓練を行います。これらのネットワークは、勾配に基づいた手法を用いて誤差逆伝播を行いながら学習します。このアーキテクチャの違いを比較すると、図3のようになります。

<!-- <center>
<img src="{{site.baseurl}}/images/week09/09-3/GANvsVAEMapping.jpg" height="250px" /><br>
<b>Fig. 4</b>: VAE (left) vs. GAN (right) - Mapping from Random Sample $\vect{z}$
</center> -->
<center>
<img src="{{site.baseurl}}/images/week09/09-3/GANvsVAEMapping.jpg" height="250px" /><br>
<b>図4</b>: VAE (左) vs GAN (右) - ランダムサンプル $\vect{z}$からの写像
</center>

<!-- GANs also differ from VAEs through how they produce and use $\vect{z}$. GANs start by sampling $\vect{z}$, similar to the latent space in a VAE. They then use a generative network to map $\vect{z}$ to $\vect{\hat{x}}$. This $\vect{\hat{x}}$ is then sent through a discriminator/cost network to evaluate how "real" it is. One of the main differences from VAE and GAN is that **we do not need to measure a direct relationship (*i.e.* reconstruction loss) between the output of the generative network $\vect{\hat{x}}$ and real data $\vect{x}$.** Instead, we force $\vect{\hat{x}}$ to be similar to $\vect{x}$ by training the generator to produce $\vect{\hat{x}}$ such that the discriminator/cost network produces scores that are similar to those of real data $\vect{x}$, or more "real". -->
また、どのように生成を行い、どのように$\vect{z}$を使用するかという点で、GANとVAEは異なります。VAEの潜在空間で行われるのと同様に、GANではまず$\vect{z}$をサンプリングします。次に、生成ネットワークを用いて、$\vect{z}$を$\vect{\hat{x}}$に写像します。この$\vect{\hat{x}}$は、それがどれだけ「本物」であるかを評価するために、識別器/コストネットワークに入力されます。VAEとGANの主な違いの一つは、**GANでは生成ネットワークの出力と実データとの間の直接的な関係（再構成誤差）を測定する必要がないことです。** その代わりに、我々は、識別器/コストネットワークが本物のデータ$\vectct{x}$と似たようなスコアを生成するように生成器を訓練することで、$\vect{\hat{x}}$が$\vect{x}$と似たようなものになるように強制します。


<!-- ## Major pitfalls in GANs -->
## GANの主な落とし穴

<!-- While GANs can be powerful for building generators, they have some major pitfalls. -->
GANは生成器の構築に威力を発揮しますが、いくつかの大きな落とし穴があります。


<!-- ### 1. Unstable convergence

As the generator improves with training, the discriminator performance gets worse because the discriminator can no longer easily tell the difference between real and fake data. If the generator is perfect, then the manifold of the real and fake data will lie on top of each other and the discriminator will create many misclassifications.

This poses a problem for convergence of the GAN: the discriminator feedback gets less meaningful over time. If the GAN continues training past the point when the discriminator is giving completely random feedback, then the generator starts to train on junk feedback and its quality may collapse. [Refer to [training convergence in GANs](https://developers.google.com/machine-learning/gan/training)]

As a result of this adversarial nature between the generator and discriminator there is an unstable equilibrium point rather than an equilibrium. -->

### 1. 不安定な収束性

生成器が訓練によって改善されるにつれて、識別器の性能は悪くなります。生成器が完全であれば、本物のデータと偽物のデータの多様体は互いに重なり合い、識別器は多くの誤分類を生み出すことになります。

識別器のフィードバックは時間の経過とともに意味をなさなくなりますが、これは、GANの収束に問題をもたらします。GANが、識別器が完全にランダムなフィードバックを与えている時点を超えて学習を続けると、生成器は質の悪いフィードバックで学習を開始し、その品質が崩壊する可能性があります。[GANの学習の収束](https://developers.google.com/machine-learning/gan/training)を参照してください。

この生成器と識別器の間の敵対的な性質の結果として、安定ではなく不安定な平衡点が生じます。

<!-- ###  2. Vanishing gradient

Let's consider using the binary cross entropy loss for a GAN:

$$
\mathcal{L} = \mathbb{E}_\boldsymbol{x}[\log(D(\boldsymbol{x}))] + \mathbb{E}_\boldsymbol{\hat{x}}[\log(1-D(\boldsymbol{\hat{x}}))] \text{.}
$$

As the discriminator becomes more confident, $D(\vect{x})$ gets closer to $1$ and $D(\vect{\hat{x}})$ gets closer to $0$. This confidence moves the outputs of the cost network into flatter regions where the gradients become more saturated. These flatter regions provide small, vanishing gradients that hinder the generator network's training. Thus, when training a GAN, you want to make sure that the cost gradually increases as you become more confident. -->

### 2. 勾配消失

GANにバイナリクロスエントロピー損失を使うことを考えてみましょう。

$$
\mathcal{L} = \mathbb{E}_\boldsymbol{x}[\log(D(\boldsymbol{x}))] + \mathbb{E}_\boldsymbol{\hat{x}}[\log(1-D(\boldsymbol{\hat{x}}))] \text{.}
$$

識別器が自信を持つようになると、$D(\vect{x})$は$1$に近づき、$D(\vect{\hat{x}})$は$0$に近づきます。この自身は、コストネットワークの出力を、勾配が飽和するようなより平坦な領域に移動させます。これらの平坦な領域は、生成ネットワークの学習の妨げとなる、勾配消失を引き起こします。したがって、GANを訓練する際には、自信が高まるにつれてコストが徐々に増加するようにしたいという要請が生まれます。



<!-- ### 3. Mode collapse

 If a generator maps all $\vect{z}$'s from the sampler to a **single** $\vect{\hat{x}}$ that can fool the discriminator, then the generator will produce **only** that $\vect{\hat{x}}$. Eventually, the discriminator will learn to detect *specifically* this fake input. As a result, the generator simply finds the next most plausible $\vect{\hat{x}}$ and the cycle continues. As a result, the discriminator gets trapped in local minima while cycling through fake $\vect{\hat{x}}$'s. A possible solution to this issue is to enforce some penalty to the generator for always giving the same output given different inputs. -->

### 3. モード崩壊

 生成器が、サンプラーからのすべての$\vect{z}$を **単一の** 識別器を騙すことができる$\vect{\hat{x}}$に写像することができるならば、生成器はそのような$\vect{\hat{x}}$**だけ**を生成することになります。最終的に、識別器は、この偽の入力の検出に**特化した**学習をしてしまいます。すると、生成器は、次の最も妥当な$\vect{\hat{x}}$を見つけ、そのサイクルを継続してしまいます。その結果、偽の $\vect{\hat{x}}$ を循環させている間に、識別器は局所解に捕らわれてしまいます。この問題の解決策として、異なる入力が与えられたときに、常に同じ値を出力することに何らかのペナルティを課すことが考えられます。


## [Deep Convolutional Generative Adversarial Network (DCGAN) source code](https://www.youtube.com/watch?v=xYc11zyZ26M&t=2911s)

<!-- The source code of the example can be found [here](https://github.com/pytorch/examples/blob/master/dcgan/main.py). -->
この例のソースコードは[ここ](https://github.com/pytorch/examples/blob/master/dcgan/main.py)から見みることができます。

<!-- ### Generator

1. The generator upsamples the input using several `nn.ConvTranspose2d` modules separated with `nn.BatchNorm2d` and `nn.ReLU`.
2. At the end of the sequential, the network uses `nn.Tanh()` to squash outputs to $(-1,1)$.
3. The input random vector has size $nz$. The output has size $nc \times 64 \times 64$, where $nc$ is the number of channels. -->

### 生成器

1. 生成器は、`nn.BatchNorm2d` と `nn.ReLU` で区切られた複数の `nn.ConvTranspose2d` モジュールを用いて入力をアップサンプリングします。
2. 系列の最後に、ネットワークは `nn.Tanh()` を用いて出力を $(-1,1)$ の範囲にします。
3. 入力であるランダムベクトルのサイズは$nz$で、出力のサイズは$nc \times 64 \times 64$です。ここで$nc$はチャンネル数を表しています。

```python
class Generator(nn.Module):
    def __init__(self):
        super().__init__()
        self.main = nn.Sequential(
            # input is Z, going into a convolution
            nn.ConvTranspose2d(     nz, ngf * 8, 4, 1, 0, bias=False),
            nn.BatchNorm2d(ngf * 8),
            nn.ReLU(True),
            # state size. (ngf*8) x 4 x 4
            nn.ConvTranspose2d(ngf * 8, ngf * 4, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ngf * 4),
            nn.ReLU(True),
            # state size. (ngf*4) x 8 x 8
            nn.ConvTranspose2d(ngf * 4, ngf * 2, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ngf * 2),
            nn.ReLU(True),
            # state size. (ngf*2) x 16 x 16
            nn.ConvTranspose2d(ngf * 2,     ngf, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ngf),
            nn.ReLU(True),
            # state size. (ngf) x 32 x 32
            nn.ConvTranspose2d(    ngf,      nc, 4, 2, 1, bias=False),
            nn.Tanh()
            # state size. (nc) x 64 x 64
        )

    def forward(self, input):
        output = self.main(input)
        return output
```


<!-- ### Discriminator

1. It is important to use `nn.LeakyReLU` as the activation function to avoid killing the gradients in negative regions. Without these gradients, the generator will not receive updates.
2. At the end of the sequential, the discriminator uses `nn.Sigmoid()` to classify the input. -->

### 識別器

1. 負の領域の勾配も活用するために、`nn.LeakyReLU`を活性化関数として使用することが重要です。これらの勾配がなければ、生成器は更新できなくなってしまいます。
2. 識別器は、ネットワークの最後に`nn.Sigmoid()` を用いて入力を分類します。

```python
class Discriminator(nn.Module):
    def __init__(self):
        super().__init__()
        self.main = nn.Sequential(
            # input is (nc) x 64 x 64
            nn.Conv2d(nc, ndf, 4, 2, 1, bias=False),
            nn.LeakyReLU(0.2, inplace=True),
            # state size. (ndf) x 32 x 32
            nn.Conv2d(ndf, ndf * 2, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ndf * 2),
            nn.LeakyReLU(0.2, inplace=True),
            # state size. (ndf*2) x 16 x 16
            nn.Conv2d(ndf * 2, ndf * 4, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ndf * 4),
            nn.LeakyReLU(0.2, inplace=True),
            # state size. (ndf*4) x 8 x 8
            nn.Conv2d(ndf * 4, ndf * 8, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ndf * 8),
            nn.LeakyReLU(0.2, inplace=True),
            # state size. (ndf*8) x 4 x 4
            nn.Conv2d(ndf * 8, 1, 4, 1, 0, bias=False),
            nn.Sigmoid()
        )

    def forward(self, input):
        output = self.main(input)
        return output.view(-1, 1).squeeze(1)
```

<!-- These two classes are initialized as `netG` and `netD`. -->
これら2つのクラスは `netG` と `netD` として初期化されます。


<!-- ### Loss function for GAN

We use Binary Cross Entropy (BCE) between target and output. -->

### GANの損失関数

ターゲットと出力の間のバイナリクロスエントロピーを使います。


```python
criterion = nn.BCELoss()
```


<!-- ### Setup -->
### 設定

<!-- We set up `fixed_noise` of size `opt.batchSize` and length of random vector `nz`. We also create labels for real data and generated (fake) data called `real_label` and `fake_label`, respectively. -->
バッチサイズ `opt.batchSize` で長さが `nz` のランダムベクトルを用いて `fixed_noise` を設定します。また、実データ用のラベルと生成データ用のラベルをそれぞれ `real_label` と `fake_label` と呼びます。

```python
fixed_noise = torch.randn(opt.batchSize, nz, 1, 1, device=device)
real_label = 1
fake_label = 0
```

<!-- Then we set up optimizers for discriminator and generator networks. -->
そして、識別器と生成器のオプティマイザーを設定します。

```python
optimizerD = optim.Adam(netD.parameters(), lr=opt.lr, betas=(opt.beta1, 0.999))
optimizerG = optim.Adam(netG.parameters(), lr=opt.lr, betas=(opt.beta1, 0.999))
```


<!-- ### Training -->
### 訓練

<!-- Each epoch of training is divided into two steps. -->
学習の各エポックは2つのステップに分かれています。

<!-- **Step 1** is to update the discriminator network. This is done in two parts. First, we feed the discriminator real data coming from `dataloaders`, compute the loss between the output and `real_label`, and then accumulate gradients with backpropagation. Second, we feed the discriminator data generated by the generator network using the `fixed_noise`, compute the loss between the output and `fake_label`, and then accumulate the gradient. Finally, we use the accumulated gradients to update the parameters for the discriminator network.

Note that we detach the fake data to stop gradients from propagating to the generator while we train the discriminator.

Also note that we only need to call `zero_grad()` once in the beginning to clear the gradients so the gradients from both the real and fake data can be used for the update. The two `.backward()` calls accumulate these gradients. We finally only need one call of `optimizerD.step()` to update the parameters. -->

**ステップ1**では、識別器ネットワークを更新します。これは2つの部分で行われます。まず、`dataloaders` から送られてくる本物のデータを識別器に与え、出力と `real_label` の間の損失を計算し、誤差逆伝播を用いて勾配を蓄積します。次に、`fixed_noise` を用いて生成器で生成されたデータを識別器に入力し、`fake_label` との間の損失を計算し、勾配を蓄積します。最後に、蓄積された勾配を用いて識別ネットワークのパラメータを更新します。

識別器を訓練している間に勾配が生成器に伝搬しないようにするために、偽データを計算グラフから切り離すことに注意してください。

また、最初に一度だけ `zero_grad()` を呼び出すだけで勾配のキャッシュがクリアされるので、実データと偽データの両方からの勾配が更新に利用できることにも注意してください。2回の `.backward()` コールはこれらの勾配を蓄積します。最後に、パラメータを更新するために `optimizerD.step()` を1回呼び出すだけです。

```python
# train with real
netD.zero_grad()
real_cpu = data[0].to(device)
batch_size = real_cpu.size(0)
label = torch.full((batch_size,), real_label, device=device)

output = netD(real_cpu)
errD_real = criterion(output, label)
errD_real.backward()
D_x = output.mean().item()

# train with fake
noise = torch.randn(batch_size, nz, 1, 1, device=device)
fake = netG(noise)
label.fill_(fake_label)
output = netD(fake.detach())
errD_fake = criterion(output, label)
errD_fake.backward()
D_G_z1 = output.mean().item()
errD = errD_real + errD_fake
optimizerD.step()
```

<!-- **Step 2** is to update the Generator network. This time, we feed the discriminator the fake data, but compute the loss with the `real_label`! The purpose of doing this is to train the generator to make realistic $\vect{\hat{x}}$'s. -->
**ステップ2**は生成ネットワークを更新することです。今回は、偽のデータを識別器に与えますが、`real_label`で損失を計算します! ここでの目的は、本物のような$\vect{\hat{x}}$'sを作るように生成器を訓練することです。

```python
netG.zero_grad()
label.fill_(real_label)  # fake labels are real for generator cost
output = netD(fake)
errG = criterion(output, label)
errG.backward()
D_G_z2 = output.mean().item()
optimizerG.step()
```
