---
lang-ref: ch.09-1
lecturer: Yann LeCun
title: Discriminative Recurrent Sparse Auto-Encoder and Group Sparsity
authors: Kelly Sooch, Anthony Tse, Arushi Himatsingka, Eric Kosgey
date: 30 Mar 2020
lang: ja
translation-date: 6 Dec 2020
translator: Shiro Takagi
---


<!-- ## [Discriminative recurrent sparse autoencoder (DrSAE)](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=35s) -->
## [識別リカレントスパースオートエンコーダー (DrSAE)](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=35s)

<!-- The idea of DrSAE consists of combining sparse coding, or the sparse auto-encoder, with discriminative training. -->
DrSAEのアイデアは、スパース符号化（スパースオートエンコーダー）と識別タスクの訓練を組み合わせることです。
 <center><img src="{{site.baseurl}}/images/week09/09-1/q7pSvUJ.png" width="400px"/></center>

<!-- **Fig 1:** Discriminative Recurrent Sparse Auto-Encoder Network -->
**図1:** 識別リカレントスパースオートエンコーダー

<!-- The encoder, $W_e$, is similar to the encoder in the LISTA method. The X variable is run through $W_e$, and then through a non-linearity. This result is then multiplied by another learned matrix, S, and added to $W_e$. Then it is sent through another non-linearity. This process can be repeated a number of times, with each repetition as a layer. -->
エンコーダである $W_e$ は、LISTA 法のエンコーダに似ています。変数$X$は、$W_e$ によって線形変換されたあと、非線形変換を施されます。この結果に別の学習済み行列 $S$ を掛け合わせて $W_e$ に加算します。その後、別の非線形変換が適用されます。このプロセスはその一つ一つを層として、何度も繰り返すことができます。


<!-- We train this neural network with 3 different criteria:
1. $L_1$: Apply $L_1$ criterion on the feature vector Z to make it sparse.
2. Reconstruct X: This is done using a decoding matrix that reproduces the input on the output. This is done by minimizing square error, indicated by $W_d$ in Figure 1.
3. Add a Third Term: This third term, indicated by $W_c$, is a simple linear classifier which attempts to predict a category. -->
このニューラルネットワークを3つの指標に基づいて訓練します。
1. $L_1$: $L_1$ノルムを用いることで、特徴ベクトル$Z$をスパースにします。
2. $X$の再構成: 入力から出力を再現するデコーディング行列を用いることで、$X$の再構成を行います。これは、図1の$W_d$で示されている二乗誤差を最小化することで行われます。
3. 第3項を追加します。$W_c$で示されるこの第3項は、カテゴリを予測しようとする単純な線形分類器です。

<!-- The system is trained to minimize all 3 of these criteria at the same time. -->
これらの3つの指標のすべてを同時に最小化するように訓練を行います。

<!-- The advantage of this is by forcing the system to find representations that can reconstruct the input, then you're basically biasing the system towards extracting features that contain as much information about the input as possible. In other words, it enriches the features. -->
これらの指標を考える利点は、入力を再構成できる表現を見つけるように強制することで、基本的には入力に関する情報をできるだけ多く含む特徴を抽出するようなバイアスを持たせられることです。言い換えれば、これらの指標を考えることで、豊かな特徴を書くとすることができるということです。

<!-- ### Group Sparsity -->
### グループスパース性

<!-- The idea here is to generate sparse features, but not just normal features that are extracted by convolutions, but to basically produce features that are sparse after pooling. -->
ここでのアイデアは、畳み込みで抽出された通常の特徴ではなく、基本的にはプールした後にスパースとなる特徴を作り出すことで、スパースな特徴を生成するというものです。
 <center><img src="{{site.baseurl}}/images/week09/09-1/kpDK8Xu.png" width="400px" height="135px"/></center>

<!-- **Fig 2:** Auto-Encoder with Group Sparsity -->
**図2:** グループスパース性のあるオートエンコーダ

<!-- Figure 2 shows an example of an auto-encoder with group sparsity. Here, instead of the latent variable Z going to an $L_1$, it goes through basically an $L_2$ over groups. So you take the $L_2$ norm for each component in a group of Z, and take the sum of those norms. So now that is what is used as the regulariser, so we can have sparsity on groups of Z. These groups, or pools of features, tend to group together features that are similar to one another. -->
図2は、グループスパース性を持つオートエンコーダーの例を示しています。ここでは、潜在変数$Z$の$L_1$ノルムを計算するのではなく、基本的にはグループ上の$L_2$ノルムを計算します。つまり、$Z$のグループの各成分の $L_2$ ノルムを取り、それらの和を取ります。これが正則化として使用されるので、$Z$のグループをスパースにすることができます。これらのグループ（特徴表現のプール）は、互いに似た特徴をグループ化する傾向があります。


<!-- ## [AE with group sparsity: questions and clarification](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=918s) -->
## [グループスパース性のあるオートエンコーダーについての質問と説明](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=918s)

<!-- Q: Can a similar used in the first slide strategy with classifier and regulariser can be applied for VAE?

A: Adding noise and forcing sparsity in a VAE are two ways of reducing the information that the latent variable/code. Prevent learning of an identity function.

Q: In slide "AE with Group Sparsity", what is $P_j$?

A: p is a pool of features. For a vector z, it would be a subset of the values in z.

Q: *Clarification on feature pooling.*

A: (Yann draws representation of AE with group sparsity) Encoder produces latent variable z, which is regularized using the $L_2$ norm of pooled features. This z is used by the decoder for image reconstruction.

Q: Does group regularization help with grouping similar features.

A: The answer is unclear, work done here was done before computational power/ data was readily available. Techniques have not been brought back to the forefront. -->

Q: 最初のスライドで使用されているような分類器と正則化を用いた方法と類似の方法は、VAEに適用できますか？

A: VAEにおいて、ノイズを付加することと、スパース性を強制することはå、潜在変数/コードが持つ情報を減らす2つの方法となっています。これによって恒等写像を学習してしますことを防ぐことができます。

Q:「グループスパース性を用いたオートエンコーダー」というスライドにある、$P_j$とは何ですか？

A: $P$は特徴表現のプールです。ベクトル $z$ に対しては、これは $z$ の値の部分集合になります。

Q: *特徴プールについての説明。*

A: (Yann はグループスパース性を持つオートエンコーダーの表現を描く) エンコーダは、プールされた特徴の $L_2$ ノルムを用いて正則化された潜在変数 $z$ を生成します。この $z$ は、デコーダによって画像の再構成に利用されます。

Q: グループ正則化は、類似した特徴をグループ化するのに役立ちますか？

A: 不明です。ここで行われた作業は、計算能力がまだ低く、データが容易に入手できなかった時に行われていたものです。今は役立つかどうかはわかりません。

<!-- ## [Image level training, local filters but no weight sharing](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=1834s) -->
## [画像レベルの学習、局所フィルタはあるが重み共有はない場合](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=1834s)

<!-- The answer about whether it helps is not clear. People interested in this are either interested in image restoration or some kind of self-supervised learning. This would work well when dataset was very small. When you have an encoder and decoder that is convolutional and you train with group sparsity on complex cells, after you are done pre-training, the system you get rid of the decoder and only use the encoder as a feature extractor, say the first layer of the convolutional net and you stick a second layer on top of it. -->
役に立つかどうかについての答えは明確ではありません。これに興味がある人は、画像復元に興味があるか、ある種の自己学習に興味があるかのどちらかです。これは、データセットが非常に小さい場合にうまくいくでしょう。畳み込みエンコーダとデコーダを、その複雑型細胞上でグループスパース性を使って学習した場合、事前学習が終わった後に、デコーダを取り除き、エンコーダだけを特徴抽出器として使用します。

<center><img src="{{site.baseurl}}/images/week09/09-1/7akkfhv.png" width="400px"/></center>
<!-- **Fig 3:** Structure of Convolutional RELU with Group Sparsity -->
図3：グループスパース性のある畳み込みReLUネットの構造

<!-- As can be seen above, you are start with an image, you have an encoder which is basically Convolution RELU and some kind of scaling layer after this. You train with group sparsity. You have a linear decoder and a criterion which is group by 1. You take the group sparsity as a regulariser. This is like L2 pooling with an architecture similar to group sparsity.

You can also train another instance of this network. This time, you can add more layers and have a decoder with the L2 pooling and sparsity criterion, train it to reconstruct its input with pooling on top. This will create a pretrained 2-layer convolutional net. This procedure is also called Stacked Autoencoder. The main characteristic here is that it is trained to produce invariant features with group sparsity.

Q : Should we use all possible sub-trees as groups?

A : It’s up to you, you can use multiple trees if you want. We can train the tree with a bigger tree than necessary and then removes branches rarely used. -->

上で見たように、画像を入力として、基本的には畳み込みReLUネットであるエンコーダがあり、ある種のスケーリング層がその後に続きます。グループスパース性を用いて学習するとします。線形デコーダと1、としてグループされている指標を用いて、グループスパース性によって正則化を行います。これは、グループスパース性に似たアーキテクチャを持つ L2 プーリングのようなものです。

このネットワークの別のインスタンスを学習することもできます。今回は、より多くの層を追加して、L2プーリングとスパース性を測る指標を持つデコーダの出力層のプーリングによって、入力を再構成するように訓練します。これにより、事前に訓練された2層の畳み込みネットが作成されます。これはスタックドオートエンコーダーとも呼ばれます。ここでの主な特徴は、グループスパース性を持つ不変な特徴を生成するように訓練されることです。

Q : ありうるすべての部分木をグループとして使うべきですか？

A : それはあなた次第です。必要以上に大きな木で訓練して、滅多に使わない枝を削除することもできます。

<center><img src="{{site.baseurl}}/images/week09/09-1/EuhORxu.jpg" width="400px"/></center>
<!-- **Fig 4:** Image Level Training, local filters but no weight sharing -->
図4: 画像レベルの学習、局所フィルタはあるが重み共有はない

<!-- These are called pin-wheel patterns. This is a kind of organisation of the features. The orientation variously continuously as you go around those red dots. If we take one of those red dots and if do a little circle around the red dots, you notice that the orientation of the extractor kind of varies continuously as you move around. Similar trends are observed in the brain.

Q : Is the group sparsity term trained to have a small value?

It is a regulariser. The term itself is not trained, it's fixed. It's just the L2 norm of the groups and the groups are predetermined. But, because it is a criterion, it determines what the encoder and decoder will do and what sort of features will be extracted. -->

これらはピンホイールパターンと呼ばれています。これは特徴量の整理の仕方の一種です。赤い点の周りを回ると、様々な向きに連続的に変化していきます。私たちがそれらの赤い点の一つを取って、赤い点の周りに少し円を描くと、移動するにつれて抽出器の向きが連続的に変化することに気づくでしょう。脳でも同じような傾向が見られます。

Q : グループスパース性の項は小さな値となるように訓練されるのですか？

グループスパース性の項は正則化項です。ですので項自体は訓練されておらず、固定されています。それは単にグループのL2ノルムなので、グループはあらかじめ決まっていることになります。しかし、それはスパース性の基準ですので、エンコーダとデコーダが何をするか、どのような種類の特徴を抽出するかがこれによって決まります。


<center><img src="{{site.baseurl}}/images/week09/09-1/AS3giSt.jpg" width="400px" height="200px"/></center>
<!-- **Fig 5:** Invariant Features through Lateral Inhibition -->
図5: 側方抑制による不変な特徴

<!-- Here, there is a linear decoder with square reconstruction error. There is a criterion in the energy. The matrix S is either determined by hand or learned so as to maximise this term. If the terms in S are positive and large, it implies that the system does not want $z_i$ and $z_j$ to be on at the same time. Thus, it is sort of a mutual inhibition (called natural inhibition in neuroscience). Thus, you try to find a value for S that is as large as possible. -->
ここで、二乗再構成誤差を持つ線形デコーダを考えます。エネルギーにはスパース性の指標となる項があります。行列$S$は、手動で決定されるか、この項が最大になるように学習されます。$S$の項が正で大きい場合は、 $z_i$ と $z_j$ を同時にオンにしたくないということを意味します。したがって、これは一種の相互抑制です（神経科学では自然抑制と呼ばれています）。したがって、できるだけ大きな$S$の値を見つけようということになります。

<!-- <center><img src="{{site.baseurl}}/images/week09/09-1/sszdGh0.png" width="400px"/></center>
**Fig 6:** Invariant Features through Lateral Inhibition (Tree Form) -->
<center><img src="{{site.baseurl}}/images/week09/09-1/sszdGh0.png" width="400px"/></center>
図6: 側方抑制による不変な特徴 (木構造)

<!-- If you organise S in terms of a tree, the lines represent the zero terms in the S matrix. Whenever you don't have a line, there is a non-zero term. So, every feature inhibits all other features except those which are up the tree or down the tree from it. This is something like the converse of group sparsity.

You see again that systems are organising features in more or less a continuous fashion. Features along the branch of a tree represent the same feature with different levels of selectivity. Features along the periphery vary more or less continuously because there is no inhibition.

To train this system, at each iteration, you give an $x$ and find the $z$ which minimizes this energy function.Then do one step of gradient descent to update $W$. You can also do one step of gradient ascent to make the terms in $S$ larger. -->

$S$を木として整理すると、線は$S$行列のゼロである項を表します。線がないときはいつでも、ゼロではない項があります。つまり、すべての特徴は、木の上にあるものや木の下にあるものを除いて、他のすべての特徴を阻害しているということになります。これは、グループスパース性の逆のようなものです。

システムは多かれ少なかれ連続的に特徴を整理していることがわかります。木の枝に沿った特徴は、選択性のレベルが異なる同じ特徴を表しています。抑制がないので、周辺部に沿った特徴は多かれ少なかれ連続的に変化します。

各イテレーションで $x$ を与え、このエネルギー関数を最小化する $z$ を見つけることでこのシステムを訓練します。勾配降下法を１ステップ行って $W$ を更新し、 $S$ の項を大きくすることもできます。
