---
lang-ref: ch.08-2
lecturer: Yann LeCun
title: Regularized Latent Variable Energy Based Models
authors: Henry Steinitz, Rutvi Malaviya, Aathira Manoj
date: 23 Mar 2020
lang: ja
translation-date: 28 Nov 2020
translator: Jesmer Wong
---


<!-- ## [Regularized latent variable EBMs](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=2233s) -->
## [正則化された潜在変数EBM](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=2233s)

<!-- Models with latent variables are capable of making a distribution of predictions $\overline{y}$ conditioned on an observed input $x$ and an additional *latent variable* $z$. Energy-based models can also contain latent variables: -->

潜在変数を含んだモデルは、観測された入力$x$と追加の*潜在変数* $z$で条件づけられた予測$\overline{y}$の分布を作成できます。エネルギーベースモデル(EBM)には、潜在変数を含めることもできます。

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig1.png" height="50%" width="50%"/><br>
<b>図1</b>: 潜在変数を持つEBMの例
</center>

<!-- See the previous lecture's notes for more details.　 -->
詳細については、前の講義のメモを参照してください。

<!-- Unfortunately, if the latent variable $z$ has too much expressive power in producing the final prediction $\overline{y}$, 
every true output $y$ will be perfectly reconstructed from input $x$ with an appropriately chosen $z$. This means that the energy function will be 0 everywhere, since the energy is optimized over both $y$ and $z$ during inference.

A natural solution is to limit the information capacity of the latent variable $z$. One way to do this is to regularize the latent variable: -->

残念なことに、潜在変数$z$が最終的な予測$\overline{y}$を生成する際に表現力が大きすぎる場合、任意の真の出力$y$は、適切に選択された$z$を使用して入力$x$から完全に再構成されてしまいます。
これは、推論中にエネルギーが$y$と$z$の両方で最適化されるため、エネルギー関数がどこでも0になってしまうということです。

自然な解決策は、潜在変数$z$の情報容量を制限することです。これを行う1つの方法は、潜在変数を正則化することです。


$$E(x,y,z) = C(y, \text{Dec}(\text{Pred}(x), z)) + \lambda R(z)$$

<!-- This method will limit the volume of space of $z$ which takes a small value and the value which will, in turn, controls the space of $y$ that has low energy.
The value of $\lambda$ controls this tradeoff. A useful example of $R$ is the $L_1$ norm, which can be viewed as an almost everywhere differentiable approximation of effective dimension. Adding noise to $z$ while limiting its $L_2$ norm can also limit its information content (VAE). -->

この方法では、$z$の空間のボリュームが小さな値で制限され、その値によって、エネルギーの低い$y$の空間が制御されます。 
$\lambda$の値は、このトレードオフを制御します。$R$の有用な例は、$L_1$ノルムです。これは、ほとんどどこでも微分可能な有効次元の近似計算と見なすことができます。 $L_2$ノルムを制限しながら$z$にノイズを追加すると、情報の内容（VAE）を制限することもできます。

<!-- ### Sparse Coding
Sparse coding is an example of an unconditional regularized latent-variable EBM which essentially attempts to approximate the data with a piecewise linear function.　-->

### スパースコーディング

スパースコーディングは、区分的線形関数でデータを近似しようとする無条件の正則化潜在変数EBMの例です。

$$E(z, y) = \Vert y - Wz\Vert^2 + \lambda \Vert z\Vert_{L^1}$$

<!-- The $n$-dimensional vector $z$ will tend to have a maximum number of non-zero components $m << n$. Then each $Wz$ will be elements in the span of $m$ columns of $W$.
After each optimization step, the matrix $W$ and latent variable $z$ are normalized by the sum of the $L_2$ norms of the columns of $W$. This ensures that $W$ and $z$ do not diverge to infinity and zero.　-->

$n$次元ベクトル$z$は、最大数が$m << n$の非ゼロの要素を持つ傾向があります。よって、各$Wz$は、$W$の$m$列が貼る空間の要素になります。
各最適化ステップの後、行列$W$と潜在変数$z$は、$W$の列の$L_2$ノルムの合計によって正規化されます。これにより、$W$と$z$が無限大やゼロに発散しないことが保証されます。

### FISTA

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig2.png" width="90%"/><br>
<b>図2</b>: FISTAの計算グラフ
</center>

<!-- FISTA (fast ISTA) is an algorithm that optimizes the sparse coding energy function $E(y,z)$ with respect to $z$ by alternately optimizing the two terms $\Vert y - Wz\Vert^2$ and $\lambda \Vert z\Vert_{L^1}$. We initialize $Z(0)$ and iteratively update $Z$ according to the following rule: -->

FISTA（高速ISTA）は、2つの項$\Vert y - Wz\Vert^2$と$\lambda \Vert z\Vert_{L^1}$を交互に最適化することにより、$z$に関してスパースコーディングされたエネルギー関数$E(y, z)$を最適化するアルゴリズムです。  $Z(0)$を初期化し、次のルールに従って$Z$を繰り返し更新します。

$$z(t + 1) = \text{Shrinkage}_\frac{\lambda}{L}(z(t) - \frac{1}{L}W_d^\top(W_dZ(t) - y))$$

<!-- The inner expression $Z(t) - \frac{1}{L}W_d^\top(W_dZ(t) - Y)$ is a gradient step for the $\Vert y - Wz\Vert^2$ term. The $\text{Shrinkage}$ function then shifts values towards 0, which optimizes the $\lambda \Vert z\Vert_{L_1}$ term.　-->

この内側の式 $Z(t) - \frac{1}{L}W_d^\top(W_dZ(t) - Y)$は、$\Vert y - Wz\Vert^2$項についての勾配ステップです。次に、$\text{Shrinkage}$関数は、値を0へずらします。これにより、$\lambda \Vert z\Vert_{L_1}$項が最適化されます。

### LISTA

<!-- FISTA is too expensive to apply to large sets of high-dimensional data (*e.g.* images). One way to make it more efficient is to instead train a network to predict the optimal latent variable $z$:　-->

FISTAは、高次元データの大規模なセット（*例*：画像）に適用するにはコストがかかりすぎます。それをより効率的にする1つの方法は、代わりに最適な潜在変数$z$を予測するようにネットワークを訓練することです。

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig3.png" height="50%" width="50%"/><br>
<b>図3</b>: 潜在変数エンコーダーを備えたEBM
</center>

<!-- The energy of this architecture then includes an additional term that measures the difference between the predicted latent variable $\overline z$ and the optimal latent variable $z$: -->

このアーキテクチャのエネルギーには、予測された潜在変数$\overline z$と最適な潜在変数$z$の差を測る追加の項が含まれます。

$$ C(y, \text{Dec}(z,h)) + D(z, \text{Enc}(y, h)) + \lambda R(z)$$

<!-- We can further define -->
さらに下記のように定義します

$$W_e = \frac{1}{L}W_d$$

$$S = I - \frac{1}{L}W_d^\top W_d$$

<!-- and then write -->
そして

$$z(t+1) = \text{Shrinkage}_{\frac{\lambda}{L}}[W_e^\top y - Sz(t)]$$

<!-- This update rule can be interpreted as a recurrent network, which suggests that we can instead learn the parameters $W_e$ that iteratively determine the latent variable $z$. The network is run for a fixed number of time steps $K$ and the gradients of $W_e$ are computed using standard backpropagation-through-time. The trained network then produces a good $z$ in fewer iterations than the FISTA algorithm. -->

この更新則はリカレントネットワークとして解釈できます。すなわち、潜在変数$z$を繰り返し決定するパラメーター$W_e$を代わりに学習できるということです。ネットワークは一定数のタイムステップ$K$で実行され、$W_e$の勾配は一般的な通時的誤差逆伝播法（backpropagation-through-time）を使用して計算されます。訓練されたネットワークは、FISTAアルゴリズムよりも少ないイテレーションで適切な$z$を生成します。

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig4.png" height="70%" width="80%"/><br>
<b>図4</b>: 時間方向に展開されたリカレントネットとしてのLISTA
</center>


<!-- ### Sparse coding examples

When a sparse coding system with 256 dimensional latent vector is applied to MNIST handwritten digits, the system learns a set of 256 strokes that can be linearly combined to nearly reproduce the entire training set. The sparse regularizer ensures that they can be reproduced from a small number of strokes. -->

### スパースコーディングの例

256次元の潜在ベクトルを持つスパースコーディングシステムがMNISTの手書き数字データセットに適用されると、システムは、その線形結合で訓練集合全体をほぼ再現できるような256の線の集合を学習します。スパース正則化により、少数の線から再現できるように保証されます。

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig5.png" height="70%" width="90%"/><br>
<b>図5</b>: MNISTのスパースコーディング。各画像は学習され$W$の列。
</center>

<!-- When a sparse coding system is trained on natural image patches, the learned features are Gabor filters, which are oriented edges. These features resemble features learned in early parts of animal visual systems.　-->

スパースコーディングシステムが一般な画像をパッチでトレーニングする場合、学習される特徴は、方向付きエッジであるガボールフィルターです。これらの特徴は、動物の視覚系の入力に近い部分で学習された特徴に似ています。


<!-- ### [Convolutional sparse coding](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=4066s) -->
### [畳み込みスパースコーディング](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=4066s)

<!-- Suppose, we have an image and the feature maps ($z_1, z_2, \cdots, z_n$) of the image. Then we can convolve ($*$) each of the feature maps with the kernel $K_i$. Then the reconstruction can be simply calculated as: -->

仮に画像とその画像の特徴マップ($z_1, z_2, \cdots, z_n$)があるとします。すると、各特徴マップをカーネル$K_i$で畳み込む（$*$）ことができます。その結果、再構成されたものは次のように計算できます。


$$Y=\sum_{i}K_i*Z_i$$

<!-- This is different from the original sparse coding where the reconstruction was done as $Y=\sum_{i}W_iZ_i$. In regular sparse coding, we have a weighted sum of columns where the weights are coefficients of $Z_i$. In convolutional sparse coding, it is still a linear operation but the dictionary matrix is now a bunch of feature maps and we convolve each feature map with each kernel and sum up the results.　-->

これは、再構築が$Y = \sum_{i} W_iZ_i$として実行されていた元々のスパースコーディングとは違います。通常のスパースコーディングでは、$Z_i$の係数を重みとした列の重み付き和があります。畳み込みスパースコーディングでは、それは同じく線形演算ですが、辞書行列は特徴マップになり、各特徴マップを各カーネルで畳み込んだ結果を合計することになります。

<!-- #### Convolutional sparse auto-encoder on natural images -->
#### 自然画像に応用した畳み込みスパースオートエンコーダ

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig6.png" height="90%" width="90%"/><br>
<b>図6</b> 得られたフィルターと基底関数。線形畳み込みデコーダー
</center>

<!-- The filters in the encoder and decoder look very similar. Encoder is simply a convolution followed by some non-linearity and then a diagonal layer to change the scale. Then there is sparsity on the constraint of the code. The decoder is just a convolutional linear decoder and the reconstruction here is the square error.　-->

エンコーダーとデコーダーのフィルターは非常によく似ています。エンコーダーは、単純な畳み込みと非線形性マップと対角線レイヤーでスケーリングしたものです。すると、コードの制約にスパース性があります。デコーダーのほうは単純に畳み込み線形デコーダーであり、ここにおける再構成は二乗誤差となっています。

<!-- So, if we impose that there is only one filter then it is just a centre surround type filter. With two filters, we can get some weird shaped filters. With four filters, we get oriented edges (horizontal and vertical); we get 2 polarities for each of the filters. With eight filters we can get oriented edges at 8 different orientations. With 16, we get more orientation along with the centres around. As we go on increasing the filters, we get more diverse filters that is in addition to edge detectors, we also get grating detectors of various orientations, centres around, etc.　-->

もし、フィルターが1つしかない場合は、中心を囲むタイプのフィルターになります。 2つのフィルターを使用すると、変な形のフィルターをいくつか取得できます。4つのフィルターを使用すると、方向付けエッジフィルター（水平および垂直）とフィルターごとに2つの極性が得られます。8つのフィルターを使用すると、8つの異なる方向で方向付けられたエッジを取得できます。16個のフィルターを使用すると、中心に沿ってより多くの方向性が得られます。フィルター数を増やしていくと、エッジ検出器に加えてより多様なフィルターが得られ、またさまざまな方向、中心としたグレーティング検出器なども得られます。

<!-- This phenomenon seems to be interesting since it is similar to what we observe in the visual cortex. So this is an indication that we can learn really good features in a completely unsupervised way.　-->

この現象は、わたしたちの視覚野で観察されていることとよく似ているため、興味深いように思われます。これで、完全に教師なしの方法で本当に優れた特徴を学習できることを示しています。

<!-- As a side use, if we take these features and plug them in a convolutional net and then train them on some task, then we don't necessarily get better results than training an image net from scratch. However, there are some instances where it can help to boost performance. For instance, in cases where the number of samples are not large enough or there are few categories, by training in a purely supervised manner, we get degenerate features.　-->

別の使用法として、これらの特徴を畳み込みネットワークに接続してから何かのトレーニングする場合、とくにイメージネットで最初からトレーニングするよりも必ずしも良い結果が得られないが、パフォーマンスの向上に役立つ場合がすぐできます。たとえば、サンプルの数が十分に多くない場合やラベル・カテゴリが少ない場合、純粋に教師ありの方法でトレーニングすると特徴が完全に解読できなくなります。

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig7.png" height="90%" width="90%"/><br>
<b>図7 </b> カラー画像の畳み込みスパース符号化
</center>

<!-- The figure above is another example on colour images. The decoding kernel (on the right side) is of size 9 by 9. This kernel is applied convolutionally over the entire image. The image on the left is of the sparse codes from the encoder. The $Z$ vector is very sparse space where there are just few components that are white or black (non-grey). -->

上の図は、カラー画像の別の例です。デコードカーネル（右側）のサイズは9 x 9です。このカーネルは、画像ピクセル全体に畳み込みで適用されます。左側の画像は、エンコーダーからのスパースコードです。 $Z$ベクトルは非常に疎な空間であり、白または黒（灰色以外）の要素はほとんどありません。

### [変分オートエンコーダ](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=4371s)

<!-- Variational Autoencoders have an architecture similar to Regularized Latent Variable EBM, with the exception of sparsity. Instead, the information content of the code is limited by making it noisy. -->

変分オートエンコーダは、スパース性を除いて、正則化潜在変数EBMと類似したアーキテクチャを備えています。その違いは、コードの情報内容が、ノイズを多くすることによって制限されることです。

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig8.png" height="50%" width="50%"/><br>
<b>図8</b>: 変分オートエンコーダのアーキテクチャ
</center>

<!-- The latent variable $z$ is not computed by minimizing the energy function with respect to $z$. Instead, the energy function is viewed as sampling $z$ randomly according to a distribution whose logarithm is the cost that links it to ${\overline z}$. The distribution is a Gaussian with mean ${\overline z}$ and this results in Gaussian noise being added to ${\overline z}$.　-->

潜在変数$z$は、$z$に対してエネルギー関数を最小化することで計算されるのではありません。代わりに、エネルギー関数は、その対数が${\overline z}$とリンクしたコスト関数であるような分布からランダムに$z$をサンプリングすることと見なされます。この分布は、平均が${\overline z}$のガウス分布であり、これによってガウスノイズが${\overline z}$に付加されることになります。

<!-- The code vectors with added Gaussian noise can be visualized as fuzzy balls as shown in Fig. 9(a). -->

ガウスノイズが追加されたコードベクトルは、図9（a）に示すようにファジーボールとして可視化できます。

| <center><img src="{{site.baseurl}}/images/week08/08-2/fig9.png" height="75%" width="75%"/><br>(a) 元のファジーボールの集合 </center> | <center><img src="{{site.baseurl}}/images/week08/08-2/fig10.png" height="75%" width="75%"/><br>(b)正則化を加えずエネルギーを最小化することによるファジーボールの移動</center>  |

（b）の動き正則化なしのエネルギー最小化によるファジーボール

<center><b>Fig. 9:</b> Effect of energy minimization on fuzzy balls</center>
ファジーボールに対するエネルギー最小化の効果

<!-- The system tries to make the code vectors ${\overline z}$ as large as possible so that the effect of $z$(noise) is as small as possible. This results in the fuzzy balls floating away from the origin as shown in Fig. 9(b). Another reason why the system tries to make the code vectors large is to prevent overlapping fuzzy balls, which causes the decoder to confuse between different samples during reconstruction. -->

システムは、コードベクトル${\overline z}$をできるだけ大きくして、$z$（ノイズ）の影響をできるだけ小さくしようとします。これにより、図9（b）に示すように、ファジーボールが原点から離れて浮き上がります。システムがコードベクトルを大きくしようとするもう1つの理由は、ファジーボールのオーバーラップを防ぐためです。オーバーラップは、再構成中にデコーダーが異なるサンプル同士を混同する原因になります。

<!-- But we want the fuzzy balls to cluster around a data manifold, if there is one. So, the code vectors are regularized to have a mean and variance close to zero. To do this, we link them to the origin by a spring as shown in Fig. 10. -->

ただし、ファジーボールが存在する場合は、それがデータ多様体の周りにクラスターを形成している必要があります。したがって、コードベクトルは、平均と分散がゼロに近くなるように正則化されます。これを行うには、図10に示すように、ばねによってそれらを原点にリンクします。

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig11.png" height="50%" width="50%"/><br>
<b>図10</b>: バネの正則化の効果の可視化
</center>
<!-- バネの正則化の効果を視覚化でみる -->

<!-- The strength of the spring determines how close the fuzzy balls are to the origin. If the spring is too weak, then the fuzzy balls would fly away from the origin. And if it's too strong, then they would collapse at the origin, resulting in a high energy value. To prevent this, the system lets the spheres overlap only if the corresponding samples are similar. -->

バネの強さによって、ファジーボールが原点にどれほど近づくかが決まるようになります。バネが弱すぎると、ファジーボールが原点から飛び出し、代わりに強すぎると、原点にで崩壊し、エネルギーが高くなります。これを防ぐために、システムでは、対応するサンプルが類似している場合のみ円球を重なり合わせることになっています。

<!-- It is also possible to adapt the size of the fuzzy balls. This is limited by a penalty function (KL Divergence) that tries to make the variance close to 1 so that the size of the ball is neither too big nor too small that it collapses. -->

ファジーボールのサイズを調整することも可能です。これは、ペナルティ関数（KLダイバージェンス）によって分散値を1に近づけるように制限され、ボールのサイズがちょうどいいぐらいになるように調節しています。
