---
lang-ref: ch.08-1
lecturer: Yann LeCun
title: Contrastive Methods in Energy-Based Models
authors: Vishwaesh Rajiv, Wenjun Qu, Xulai Jiang, Shuya Zhao
date: 23 Mar 2020
lang: ja
translation-date: 28 Nov 2020
translator: Jesmer Wong
---


<!-- ## [Recap](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=5s) -->
## [要約](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=5s)

<!-- Dr. LeCun spent the first ~15 min giving a review of energy-based models. Please refer back to last week (Week 7 notes) for this information, especially the concept of contrastive learning methods.　-->

LeCun博士は、最初の約15分間で、エネルギーベースモデル（EBM）の振り返りを行いました。これに関する情報、特に対照学習法の概念については、先週の内容（第7週のメモ）を参照してください。

<!-- As we have learned from the last lecture, there are two main classes of learning methods: -->
前回の講義で学んだように、学習方法には主に2つのクラスがあります。

<!-- 1. Contrastive Methods that push down the energy of training data points,$F(x_i, y_i)$, while pushing up energy on everywhere else,$F(x_i, y’)$.
2. Architectural Methods that build energy function$F$which has minimized/limited low energy regions by applying regularization. -->

1. コントラスト法：訓練データ点のエネルギー$F(x_i, y_i)$を押し下げ、他のすべての点におけるエネルギー$F(x_i、y ’)$を押し上げる。
2. アーキテクチャ法：正則化を適用することによって低エネルギー領域を最小化/制限するエネルギー関数$F$を構築する。

<!-- To distinguish the characteristics of different training methods, Dr. Yann LeCun has further summarized 7 strategies of training from the two classes mention before. One of which is methods that are similar to Maximum Likelihood method, which push down the energy of data points and push up everywhere else. -->

さまざまな訓練法の特徴を区別するために、LeCun博士は、前述の2つのクラスをさらに7つの訓練戦略に分類します。その1つは、データで点のエネルギーを押し下げ、他のすべてのところのエネルギーを押し上げる、つまり最尤法に似た方法です。

<!-- Maximum Likelihood method probabilistically pushes down energies at training data points and pushes everywhere else for every other value of$y’\neq y_i$. Maximum Likelihood doesn't “care” about the absolute values of energies but only “cares” about the difference between energy. Because the probability distribution is always normalized to sum/integrate to 1, comparing the ratio between any two given data points is more useful than simply comparing absolute values.　-->

最尤法は、訓練データ点でエネルギーを確率的に押し下げ、他のすべての$y’ \neq y_i$である点のエネルギーを押し上げます。最尤法は、エネルギーの絶対値を「考慮する」のではなく、エネルギー間の差を「考慮する」だけです。確率分布は常に合計で1になるように正規化されているため、任意の2つのデータ点間の比率を比較する方が、単に絶対値を比較するよりも便利です。

## [Contrastive methods in self-supervised learning](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=613s)
## [自己教師あり学習のコントラスト的な方法](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=613s)

<!-- In contrastive methods, we push down on the energy of observed training data points ($x_i$,$y_i$), while pushing up on the energy of points outside of the training data manifold. -->
コントラスト法では、観測された訓練データ点$(x_i, y_i)$のエネルギーを押し下げ、訓練データ多様体以外の点のエネルギーを押し上げます。

<!-- In self-supervised learning, we use one part of the input to predict the other parts. We hope that our model can produce good features for computer vision that rival those from supervised tasks. -->
自己教師あり学習では、入力の一部を使用して他の部分を予測します。自己教師あり学習によって学習されたモデルは、教師あり学習によって獲得された特徴表現に匹敵するような、コンピュータビジョンのための良い表現を生み出すことが期待されます。

<!-- Researchers have found empirically that applying contrastive _embedding_ methods to self-supervised learning models can indeed have good performances which rival that of supervised models. We will explore some of these methods and their results below.　-->
研究者たちは、コントラスティブな埋め込み方法を自己教師あり学習モデルに適用すると、教師ありモデルに匹敵する優れたパフォーマンスが得られることを実験的に発見しました。これらの方法とその結果を以下で説明します。

<!-- ### Contrastive embedding  -->
### コントラスティブな埋め込み

<!-- Consider a pair ($x$,$y$), such that$x$is an image and$y$is a transformation of$x$that preserves its content (rotation, magnification, cropping, *etc.*). We call this a **positive** pair.　-->
画像$x$と、$x$の内容を保持できるような変換（回転、倍率、トリミング*など*）$y$のペア（$x$、$y$）について考えてみましょう。これは**ポジティブペア**と呼びます。

<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig1.png" width="50%"/><br>
<!-- <b>Fig. 1</b>: Positive Pair -->
<b>図1</b>: ポジティブペア
</center>

<!-- Conceptually, contrastive embedding methods take a convolutional network, and feed$x$and$y$through this network to obtain two feature vectors:$h$and$h'$. Because$x$and$y$have the same content (*i.e.* a positive pair), we want their feature vectors to be as similar as possible.
As a result, we choose a similarity metric (such as cosine similarity) and a loss function that maximizes the similarity between$h$and$h'$. By doing this, we lower the energy for images on the training data manifold.　-->

概念的には、コントラスティブな埋め込み法は畳み込みネットワークを使用し、$x$と$y$を入力してこのネットワークを介して$h$と$h'$の2つの特徴ベクトルを取得します。$x$と$y$の内容は同じであるため（*つまり*ポジティブペア）、それらの特徴ベクトルをできるだけ類似させたいと考えます。
その結果、類似度の指標（コサイン類似度など）と$h$と$h'$の間の類似度を最大化するような損失関数を選択します。これで、訓練データ多様体上の画像のエネルギーを押し下げることができます。

<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig2.png" width="50%"/><br>
<b>図2</b>: ネガティブペア
</center>

<!-- However, we also have to push up on the energy of points outside this manifold. So we also generate **negative** samples ($x_{\text{neg}}$,$y_{\text{neg}}$), images with different content (different class label＝s, for example). We feed these to our network above, obtain feature vectors$h$and$h'$, and now try to minimize the similarity between them.　-->

ただし、この多様体以外の点のエネルギーも押し上げる必要があります。そのため、**ネガティブサンプル** ($x_{\text {neg}}$, $y_{\text{neg}}$)、異なったコンテンツ（異なるクラスラベルなど）の画像も生成します。これらを上記のネットワークに入力し、特徴ベクトル$h$と$h '$を取得して、それらの間の類似性を最小限に抑えようとします。

<!-- This method allows us to push down on the energy of similar pairs while pushing up on the energy of dissimilar pairs. -->

この方法では、類似したペアのエネルギーを押し下げながら、異なるペアのエネルギーを押し上げることができます。

<!-- Recent results (on ImageNet) have shown that this method can produce features that are good for object recognition that can rival the features learned through supervised methods. -->

最近の結果（ImageNetについての結果）は、この方法が、教師ありで学習した特徴に匹敵する、オブジェクト認識に適した特徴を生成できることを示しています。


<!-- ### Self-Supervised Results (MoCo, PIRL, SimCLR) -->
### 自己教師ありの結果（MoCo、PIRL、SimCLR）

<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig3.png" height="75%" width="75%"/><br>
<b>図3</b>: ImageNetに対するPIRLとMoCo
</center>

<!-- As seen in the figure above, MoCo and PIRL achieve SOTA results (especially for lower-capacity models, with a small number of parameters). PIRL is starting to approach the top-1 linear accuracy of supervised baselines (~75%). -->
上の図に示されているように、MoCoとPIRLはSOTAの結果を達成します（特に、パラメーターの数が少ないスケールが小さいモデルで使う場合）。 PIRLは、教師ありで学習したベースラインの上位1の線形精度（〜75％）に近づき始めています。

<!-- We can understand PIRL more by looking at its objective function: NCE (Noise Contrastive Estimator) as follows. -->
PIRLは、その目的関数を見ることで理解することができます。損失関数であるNCE（ノイズコントラスティブ推定量）は次のように定義されます。


$$
h(v_I,v_{I^t})=\frac{\exp\big[\frac{1}{\tau}s(v_I,v_{I^t})\big]}{\exp\big[\frac{1}{\tau}s(v_I,v_{I^t})\big]+\sum_{I'\in D_{N}}\exp\big[\frac{1}{\tau}s(v_{I^t},v_{I'})\big]}
$$

$$
L_{\text{NCE}}(I,I^t)=-\log\Big[h\Big(f(v_I),g(v_{I^t})\Big)\Big]-\sum_{I'\in D_N}\log\Big[1-h\Big(g(v_{I^t}),f(v_{I'})\Big)\Big]
$$

<!-- Here we define the similarity metric between two feature maps/vectors as the cosine similarity.　-->
ここでは、2つの特徴マップ/ベクトル間の類似度の指標を、コサイン類似度で定義しています。



<!-- What PIRL does differently is that it doesn't use the direct output of the convolutional feature extractor. It instead defines different _heads_$f$and$g$, which can be thought of as independent layers on top of the base convolutional feature extractor. -->

PIRLが通常の学習と異なる点は、畳み込み抽出抽出器の出力を直接は使用しないことです。代わりに、異なる _heads_ $f$と$g$を定義します。これらは、畳み込み特徴抽出器の上にある独立な層だと考えることができます。



<!-- Putting everything together, PIRL's NCE objective function works as follows. In a mini-batch, we will have one positive (similar) pair and many negative (dissimilar) pairs. We then compute the similarity between the transformed image's feature vector ($I^t$) and the rest of the feature vectors in the minibatch (one positive, the rest negative). We then compute the score of a softmax-like function on the positive pair. Maximizing a softmax score means minimizing the rest of the scores, which is exactly what we want for an energy-based model. The final loss function, therefore, allows us to build a model that pushes the energy down on similar pairs while pushing it up on dissimilar pairs.　-->

すべてをまとめると、PIRLのNCE目的関数は次のように機能します。ミニバッチでは、1つのポジティブ（類似した）ペアと多くのネガティブ（異なる）ペアがあります。次に、ミニバッチ内の変換された画像の特徴ベクトル（$I^t$）と残りの特徴ベクトル（1つは正、残りは負）の間の類似度を計算します。次に、ポジティブペアのソフトマックスのような関数のスコアを計算します。ソフトマックススコアを最大化することは、残りのスコアを最小化することと同じであり、これはエネルギーベースモデルに必要なことです。したがって、最終的に得られた損失関数によって、類似したペアでエネルギーを押し下げ、異なるペアでエネルギーを押し上げるモデルを構築することができます。

<!-- Dr. LeCun mentions that to make this work, it requires a large number of negative samples. In SGD, it can be difficult to consistently maintain a large number of these negative samples from mini-batches. Therefore, PIRL also uses a cached memory bank. -->

LeCun博士は、これを機能させるには、多数のネガティブサンプルが必要であると述べています。 SGDでは、ミニバッチからこれらのネガティブサンプルを一貫して維持することが難しい場合があります。したがって、PIRLはキャッシュされたメモリバンクも使用します。

<!-- **Question**: Why do we use cosine similarity instead of L2 Norm?
Answer: With an L2 norm, it's very easy to make two vectors similar by making them "short" (close to centre) or make two vectors dissimilar by making them very "long" (away from the centre). This is because the L2 norm is just a sum of squared partial differences between the vectors. Thus, using cosine similarity forces the system to find a good solution without "cheating" by making vectors short or long.　-->

**質問**： なぜL2-ノルムよりコサイン類似度を使用するのですか？
回答：L2ノルムは、ベクトル間の部分差の2乗の合計にすぎないため、2つのベクトルを「短く」（中心に近く）することで類似させることや、2つのベクトルを非常に「長く」（中心から遠く）することで類似させないようにすることが非常に簡単にできてしまいます。したがって、コサイン類似度を使用することで、システム上、ベクトルを短くしたり長くしたりするといった「ずる」をせずに適切な解を見つけることができます。


### SimCLR

<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig5.png" height="75%" width="75%"/><br>
<b>図4</b>: ImageNetについてのSimCLRの結果
</center>

<!-- SimCLR shows better results than previous methods. In fact, it reaches the performance of supervised methods on ImageNet, with top-1 linear accuracy on ImageNet.　The technique uses a sophisticated data augmentation method to generate similar pairs, and they train for a massive amount of time (with very, very large batch sizes) on TPUs.

Dr. LeCun believes that SimCLR, to a certain extend, shows the limit of contrastive methods. There are many, many regions in a high-dimensional space where you need to push up the energy to make sure it's actually higher than on the data manifold. As you increase the dimension of the representation, you need more and more negative samples to make sure the energy is higher in those places not on the manifold. -->

SimCLRは、上記の方法よりも優れた結果が達成できます。これは、ImageNetについて教師あり学習方法を用いた時のパフォーマンスに達し、ImageNetの線形精度はトップ1になります。この手法では、高度なデータ拡張方法を使用して類似したペアを生成し、TPUで長時間（非常に大きなバッチサイズで）訓練を行います。

LeCun博士は、SimCLRがある程度コントラスティブな方法の限界を示している、と信じています。高次元空間には、データ多様体よりも実際に確実にエネルギーが高くなるようにエネルギーを押し上げる必要がある多くの領域があります。また、表現の次元を増やせば増やすほど、多様体上にない場所でエネルギーが高くなるようにするため、多くのネガティブサンプルが必要になります。


<!-- ## [Denoising autoencoder](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=1384s) -->
## [デノイジングオートエンコーダー](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=1384s)

<!-- In [week 7's practicum](https://atcold.github.io/pytorch-Deep-Learning/en/week07/07-3/), we discussed denoising autoencoder. The model tends to learn the representation of the data by reconstructing corrupted input to the original input.
More specifically, we train the system to produce an energy function that grows quadratically as the corrupted data move away from the data manifold. -->

先週の講義で、デノイジングオートエンコーダーについて説明しました。このモデルは、破損した入力から元の入力を再構成することにより、データの表現を学習する傾向があります。特に、破損したデータがデータ多様体から離れるにつれて二次関数的に増加するようなエネルギー関数を生成するようにそのシステムを訓練します。


<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig6.png" height="75%" width="75%"/><br>
<b>図5</b>: デノイジングオートエンコーダーのアーキテクチャ
</center>


<!-- ### Issues
However, there are several problems with denoising autoencoders. One problem is that in a high dimensional continuous space, there are uncountable ways to corrupt a piece of data. So there is no guarantee that we can shape the energy function by simply pushing up on lots of different locations.

Another problem with the model is that it performs poorly when dealing with images due to the lack of latent variables. Since there are many ways to reconstruct the images, the system produces various predictions and doesn't learn particularly good features.

Besides, corrupted points in the middle of the manifold could be reconstructed to both sides. This will create flat spots in the energy function and affect the overall performance. -->

### 問題

ただし、デノイジングオートエンコーダーにはいくつかの問題があります。 1つの問題は、高次元の連続空間では、データの一部を破損する無数の方法があることです。したがって、さまざまな場所を押し上げるだけではエネルギー関数を形成できるという保証はありません。

もう1つの問題は、潜在変数がない画像を処理するときにパフォーマンスが低下することです。画像を再構成する方法はたくさんあるので、システムはさまざまな予測を生成し、特に優れた特徴を学習しません。

さらに、多様体の中央にある破損した点は、両側に再構成できます。これにより、エネルギー関数に平坦な場所が生み出され、全体的なパフォーマンスに影響します。


<!-- ## Other Contrastive Methods

There are other contrastive methods such as contrastive divergence, Ratio Matching, Noise Contrastive Estimation, and Minimum Probability Flow. We will briefly discuss the basic idea of contrastive divergence.　-->

## 他のコントラスティブな方法

コントラスティブダイバージェンス法、比率マッチング、Noise-Contrastive Estimation、minimum probability flow法など、他のコントラスティブ法があります。ここでコントラスティブダイバージェンス法の基本的な考え方について簡単に説明します。

<!-- ### Contrastive Divergence


Contrastive divergence (CD) is another model that learns the representation by smartly corrupting the input sample.　In a continuous space, we first pick a training sample$y$and lower its energy. For that sample, we use some sort of gradient-based process to move down on the energy surface with noise. If the input space is discrete, we can instead perturb the training sample randomly to modify the energy. If the energy we get is lower, we keep it. Otherwise, we discard it with some probability. 

Keep doing so will eventually lower the energy of$y$. We can then update the parameter of our energy function by comparing$y$and the contrasted sample$\bar y$with some loss function.　-->

### コントラスティブダイバージェンス法

コントラスティブダイバージェンス法（CD法）は、入力サンプルをうまく破損することによって表現を学習する別のモデルです。連続空間では、最初に訓練サンプル$y$を選択し、そのエネルギーを下げます。そのサンプルでは、​​ある種の勾配ベースのプロセスを使用して、ノイズとともにエネルギーを押し下げます。入力空間が離散的である場合、代わりに訓練サンプルをランダムに摂動させてエネルギーを変更できます。得るエネルギーが低ければ維持して、そうでなければ、ある程度の確率で破棄します。

これをやり続けると、最終的に$y$のエネルギーを低下することができます。次に、$y$と対照的なサンプル$\bar y$をある損失関数で比較することにより、エネルギー関数のパラメーターを更新することができます。

<!-- ### Persistent Contrastive Divergence

One of the refinements of contrastive divergence is persistent contrastive divergence. The system uses a bunch of "particles" and remembers their positions. These particles are moved down on the energy surface just like what we did in the regular CD.

Eventually, they will find low energy places in our energy surface and will cause them to be pushed up. However, the system does not scale well as the dimensionality increases. -->

### 持続的なコントラスティブダイバージェンス法


コントラスティブダイバージェンス法（CD法）を改良したものの一つとして、持続的なコントラスティブダイバージェンス法があります。システムは一連の「粒子」を使用し、それらの位置を記憶します。これらの粒子は、通常のCD法で行ったのと同じように、エネルギー面を下に移動します。最終的に、この粒子らはエネルギー面で低エネルギーの場所を見つけ、それらを押し上げさせます。ただし、システムは次元の増加に対して適切にスケールしません。

