---
lang-ref: ch.07-3
lang: ja
title: オートエンコーダーの紹介
lecturer: Alfredo Canziani
authors: Xinmeng Li, Atul Gandhi, Li Jiang, Xiao Li
date: 10 March 2020
translation-date: 12 Aug 2020
translator: Shiro Takagi
---


<!-- ## [Application of autoencoders](https://www.youtube.com/watch?v=bggWQ14DD9M&t=55s) -->
## [オートエンコーダーの応用](https://www.youtube.com/watch?v=bggWQ14DD9M&t=55s)


<!-- ### Image generation -->
### 画像の生成

<!-- Can you tell which face is fake in Fig. 1? In fact, both of them are produced by the StyleGan2 generator. Although the facial details are very realistic, the background looks weird (left: blurriness, right: misshapen objects). This is because the neural network is trained on faces samples. The background then has a much higher variability. Here the data manifold has roughly 50 dimensions, equal to the degrees of freedom of a face image. -->
図1でどちらの顔が偽物かわかりますか？実は、どちらもStyleGan2のジェネレーターによって生成されています。顔の細部は非常にリアルですが、背景が不気味に見えます（左：ぼやけている、右：形が崩れている）。これは、ニューラルネットワークが顔のサンプルで訓練されているためです。そのため、背景のばらつきが大きくなります。ここでは、データ多様体は、顔画像の自由度に相当する約50の次元を持っています。

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/1_faces_gen.jpg" height="150px" /><br>
<b>Fig. 1</b>: Faces generated from StyleGan2
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/1_faces_gen.jpg" height="150px" /><br>
<b>図. 1</b>: StyleGan2で生成された顔画像
</center>


<!-- ### Difference of Interpolation in Pixel Space and Latent Space -->
### ピクセル空間と潜在空間における補間の違い

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/2_dog.jpg" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/2_bird.jpg" height="120px"/>
<br>
<b>Fig. 2</b>: A dog and a bird
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/2_dog.jpg" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/2_bird.jpg" height="120px"/>
<br>
<b>図2</b>: 犬と鳥
</center>

<!-- If we linearly interpolate between the dog and bird image (Fig. 2) in pixel space, we will get a fading overlay of two images in Fig. 3. From the top left to the bottom right, the weight of the dog image decreases and the weight of the bird image increases. -->

犬画像（図２）と鳥画像（図２）をピクセル空間で線形補間すると、図３のように２つの画像が半透明になり重なり合ったような画像が得られます。左上から右下に向かって、犬画像の重さが減少し、鳥画像の重さが増加していることがわかります。
<!-- TODO: Could not think of a good translation of fading overlay -->

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/3_dog2bird.jpg" height="200px"/><br>
<b>Fig. 3</b>: Results after interpolation
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/3_dog2bird.jpg" height="200px"/><br>
<b>図3</b>: 補完した結果
</center>

<!-- If we interpolate on two latent space representation and feed them to the decoder, we will get the transformation from dog to bird in Fig. 4. -->
2つの潜在空間での表現を補間してデコーダに与えると、図4のような犬から鳥への変換が得られます。

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/4_model_d2b.jpg" height="200px"/><br>
<b>Fig. 4</b>: Results after feeding into decoder
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/4_model_d2b.jpg" height="200px"/><br>
<b>Fig. 4</b>:デコーダーに入力した結果
</center>

<!-- Obviously, latent space is better at capturing the structure of an image. -->
明らかに、画像の構造を捉えるには、潜在空間の方が優れていることがわかります。


<!-- ### Transformation Examples -->
### 変換の例

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/5_zoom1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/5_zoom2.jpg
" height="120px"/>
<br>
<b>Fig. 5</b>: Zoom
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/5_zoom1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/5_zoom2.jpg
" height="120px"/>
<br>
<b>図5</b>: 拡大
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/6_shift1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/6_shift2.jpg
" height="120px"/>
<br>
<b>Fig. 6</b>: Shift
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/6_shift1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/6_shift2.jpg
" height="120px"/>
<br>
<b>図6</b>: 平行移動
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/7_bright1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/7_bright2.jpg" height="120px"/>
<br>
<b>Fig. 7</b>: Brightness
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/7_bright1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/7_bright2.jpg" height="120px"/>
<br>
<b>図7</b>: 明度
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/8_rotation1.jpg" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/8_rotation2.jpg" height="120px"/>
<br>
<b>Fig. 8</b>: Rotation (Note that the rotation could be 3D)
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/8_rotation1.jpg" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/8_rotation2.jpg" height="120px"/>
<br>
<b>図8</b>: 回転 (回転は3次元になる可能性があることに注意してください。)
</center>


<!-- ### Image Super-resolution -->
### 画像の超解像

<!-- This model aims to upscale images and reconstruct the original faces. From left to right in Fig. 9, the first column is the 16x16 input image, the second one is what you would get from a standard bicubic interpolation, the third is the output generated by the neural net, and on the right is the ground truth. (https://github.com/david-gpu/srez) -->
このモデルは、画像をアップスケールして元の顔を再構成することを目的としています。図9の左から右へ、最初の列は16x16の入力画像、2番目の列は標準的な二重曲線補間から得られるもの、3番目はニューラルネットによって生成された出力、そして右は実際の画像です(https://github.com/david-gpu/srez)。

<!-- <center><img src="{{site.baseurl}}/images/week07/07-3/9_reconstruct.jpg" height="120px"/>
<br>
<b>Fig. 9</b>: Reconstructing original faces
</center> -->
<center><img src="{{site.baseurl}}/images/week07/07-3/9_reconstruct.jpg" height="120px"/>
<br>
<b>図9</b>: 元の顔の再構成
</center>

<!-- From the output images, it is clear that there exist biases in the training data, which makes the reconstructed faces inaccurate. For example, the top left Asian man is made to look European in the output due to the imbalanced training images. The reconstructed face of the bottom left women looks weird due to the lack of images from that odd angle in the training data. -->
出力画像を見ると、学習データに偏りがあり、それが再構成された顔を不正確なものにしていることがわかります。例えば、左上のアジア人男性の顔は、学習画像のバランスが悪いため、出力画像ではヨーロッパ人に見えてしまいます。左下の女性の再構成された顔は、訓練データにこのような変な角度からの画像がないために不気味に見えてしまいます。


<!-- ### Image Inpainting -->
### 画像の修復

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/10_facepatch.jpg" height="120px"/>
<br>
<b>Fig. 10</b>: Putting grey patch on faces
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/10_facepatch.jpg" height="120px"/>
<br>
<b>図10</b>: 灰色のパッチを顔に当てる
</center>

<!-- Putting a grey patch on the face like in Fig. 10 makes the image away from the training manifold. The face reconstruction in Fig. 11 is done by finding the closest sample image on the training manifold via Energy function minimization. -->
図10のように顔に灰色のパッチを当てることで、訓練データの多様体から画像を遠ざけることができます。図11の顔の再構成は、エネルギー関数の最小化を介して、訓練データの多様体上で最も近いサンプル画像を見つけることによって行われます。

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/11_fixfacepatch.jpg" height="120px"/>
<br>
<b>Fig. 11</b>: Reconstructed image of <b>Fig. 10</b>
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/11_fixfacepatch.jpg" height="120px"/>
<br>
<b>図11</b>: 再構成された<b>図10</b>の画像
</center>


<!-- ### Caption to Image -->
### 画像のキャプション

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/12_caption.jpg" height="50px"/><img src="{{site.baseurl}}/images/week07/07-3/12_capimage.jpg" height="150px"/>
<br>
<b>Fig. 12</b>: Caption to Image example
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/12_caption.jpg" height="50px"/><img src="{{site.baseurl}}/images/week07/07-3/12_capimage.jpg" height="150px"/>
<br>
<b>図12</b>: 画像の例へのキャプション
</center>

<!-- The translation from text description to image in Fig. 12 is achieved by extracting text features representations associated with important visual information and then decoding them to images. -->
図12のテキストによる記述から画像への変換は、重要な視覚の情報に関連付けられたテキストの特徴表現を抽出し、それを画像にデコードすることで実現されます。


<!-- ## [What are autoencoders?](https://www.youtube.com/watch?v=bggWQ14DD9M&t=879s) -->
## [オートエンコーダーとは？](https://www.youtube.com/watch?v=bggWQ14DD9M&t=879s)

<!-- Autoencoders are artificial neural networks, trained in an unsupervised manner, that aim to first learn encoded representations of our data and then generate the input data (as closely as possible) from the learned encoded representations. Thus, the output of an autoencoder is its prediction for the input. -->
オートエンコーダーは、教師なしで訓練されるニューラルネットワークであり、最初にデータの符号化された表現を学習し、学習した符号化された表現から入力データを（可能な限り忠実に）生成することを目的としています。したがって、オートエンコーダーの出力は入力に対する予測です。

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/13_ae_structure.png" width="40%"/> <br>
<b>Fig. 13</b>: Architecture of a basic autoencoder<br>
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/13_ae_structure.png" width="40%"/> <br>
<b>図13</b>: 基本的なオートエンコーダーのアーキテクチャ<br>
</center>

<!-- Fig. 13 shows the architecture of a basic autoencoder. As before, we start from the bottom with the input $\boldsymbol{x}$ which is subjected to an encoder (affine transformation defined by $\boldsymbol{W_h}$, followed by squashing). This results in the intermediate hidden layer $\boldsymbol{h}$. This is subjected to the decoder(another affine transformation defined by $\boldsymbol{W_x}$ followed by another squashing). This produces the output $\boldsymbol{\hat{x}}$, which is our model's prediction/reconstruction of the input. As per our convention, we say that this is a 3 layer neural network. -->
図 13 に基本的なオートエンコーダーのアーキテクチャを示します。先ほどと同じように、下層から入力された $\boldsymbol{x}$ をエンコーダ（$\boldsymbol{W_h}$ で定義されたアフィン変換とその後のsquashing関数）にかけます。これにより、中間の隠れ層 $B\boldsymbol{h}$ が得られます。これをデコーダ($\boldsymbol{W_x}$で定義された別のアフィン変換と別のsquashing関数)にかけます。これが出力 $\boldsymbol{\hat{x}}$ であり，これが入力の予測/再構成です。私たちの慣例では、これは３層のニューラルネットワークであると言います。

<!-- We can represent the above network mathematically by using the following equations: -->
このネットワークは数学的には次のように表現されます。

$$
\boldsymbol{h} = f(\boldsymbol{W_h}\boldsymbol{x} + \boldsymbol{b_h}) \\
\boldsymbol{\hat{x}} = g(\boldsymbol{W_x}\boldsymbol{h} + \boldsymbol{b_x})
$$

<!-- We also specify the following dimensionalities: -->
また、以下のように次元を指定します。

$$
\boldsymbol{x},\boldsymbol{\hat{x}} \in \mathbb{R}^n\\
\boldsymbol{h} \in \mathbb{R}^d\\
\boldsymbol{W_h} \in \mathbb{R}^{d \times n}\\
\boldsymbol{W_x} \in \mathbb{R}^{n \times d}\\
$$

<!-- <b>Note:</b> In order to represent PCA, we can have tight weights (or tied weights) defined by $\boldsymbol{W_x}\ \dot{=}\ \boldsymbol{W_h}^\top$ -->
<b>注:</b>  PCAを表現するためには、タイトウエイト（またはタイドウエイト）を $\boldsymbol{W_x}\ \dot{=}\ \boldsymbol{W_h}^\top$で定義します。


<!-- ## Why are we using autoencoders? -->
## なぜオートエンコーダーを使うのか？

<!-- At this point, you may wonder what the point of predicting the input is and what are the applications of autoencoders. -->
この時点で、入力を予測することに何の意味があるのか、オートエンコーダーの用途は何かと疑問に思うかもしれません。

<!-- The primary applications of an autoencoder is for anomaly detection or image denoising. We know that an autoencoder's task is to be able to reconstruct data that lives on the manifold i.e. given a data manifold, we would want our autoencoder to be able to reconstruct only the input that exists in that manifold. Thus we constrain the model to reconstruct things that have been observed during training, and so any variation present in new inputs will be removed because the model would be insensitive to those kinds of perturbations. -->
オートエンコーダーの主な用途は、異常検知や画像のノイズ除去です。オートエンコーダーのタスクは、多様体上に存在するデータを再構成することであることを見てきました。つまり、データ多様体が与えられている場合、オートエンコーダーにはその多様体に存在する入力のみを再構成できるようにしてほしいと考えています。このようにして、モデルは訓練中に観察されたものを再構成するように制約され、それによって新しい入力に存在する摂動に対して頑健になるので、そのような変動は除去されます。


<!-- Another application of an autoencoder is as an image compressor. If we have an intermediate dimensionality $d$ lower than the input dimensionality $n$, then the encoder can be used as a compressor and the hidden representations (coded representations) would address all (or most) of the information in the specific input but take less space. -->
オートエンコーダーのもう1つの用途は、画像圧縮です。入力の次元数 $n$ よりも低い中間次元数 $d$ があれば、エンコーダは圧縮機として使用でき、潜在表現（符号化された表現）は、より少ないスペースで特定の入力に含まれる情報のすべて（または大部分）を扱うことができます。


<!-- ## Reconstruction loss -->
## 再構成誤差

<!-- Let us now look at the reconstruction losses that we generally use. The overall loss for the dataset is given as the average per sample loss i.e. -->
ここで、一般的に使われる再構成損失を見てみましょう。データセットの全体的な損失は、サンプルあたりの損失の平均、で与えられます。すなわち

$$
L = \frac{1}{m} \sum_{j=1}^m \ell(x^{(j)},\hat{x}^{(j)})
$$

<!-- When the input is categorical, we could use the Cross-Entropy loss to calculate the per sample loss which is given by -->
入力がカテゴリカルな場合、クロスエントロピー損失を使用して、次式で与えられるサンプルあたりの損失を計算することができます。

$$
\ell(\boldsymbol{x},\boldsymbol{\hat{x}}) = -\sum_{i=1}^n [x_i \log(\hat{x}_i) + (1-x_i)\log(1-\hat{x}_i)]
$$

<!-- And when the input is real-valued, we may want to use the Mean Squared Error Loss given by -->
また、入力が実数値である場合、次式で与えられる平均二乗誤差損失を使用したい場合があります。

$$
\ell(\boldsymbol{x},\boldsymbol{\hat{x}}) = \frac{1}{2} \lVert \boldsymbol{x} - \boldsymbol{\hat{x}} \rVert^2
$$


<!-- ## Under-/over-complete hidden layer -->
## アンダーコンプリート/オーバーコンプリートな隠れ層
<!-- TODO: Not confident in this translation -->

<!-- When the dimensionality of the hidden layer $d$ is less than the dimensionality of the input $n$ then we say it is under complete hidden layer. And similarly, when $d>n$, we call it an over-complete hidden layer. Fig. 14 shows an under-complete hidden layer on the left and an over-complete hidden layer on the right. -->
隠れ層の次元数 $d$ が入力の次元数 $n$ よりも小さいときは、アンダーコンプリートな隠れ層と呼ぶことにします。また、同様に、 $d>n$ の場合は、オーバーコンプリートな隠れ層と呼ぶことにします。図14は、左がアンダーコンプリートな隠れ層、右がオーバーコンプリートな隠れ層を示しています。

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/14_over_under_complete.png" width="60%"/> <br>
<b>Fig. 14</b>: An under-complete vs an over-complete hidden layer<br>
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/14_over_under_complete.png" width="60%"/> <br>
<b>図14</b>: アンダーコンプリートな隠れ層 vs オーバーコンプリートな隠れ層<br>
</center>

<!-- As discussed above, an under-complete hidden layer can be used for compression as we are encoding the information from input in fewer dimensions. On the other hand, in an over-complete layer, we use an encoding with higher dimensionality than the input. This makes optimization easier. -->
上述したように，アンダーコンプリートな隠れ層は入力からの情報をより少ない次元で符号化しているため、情報の圧縮に用いることができます。一方で、オーバーコンプリートな隠れ層では、入力よりも高い次元での符号化を行います。これにより、最適化が容易になります。

<!-- Since we are trying to reconstruct the input, the model is prone to copying all the input features into the hidden layer and passing it as the output thus essentially behaving as an identity function. This needs to be avoided as this would imply that our model fails to learn anything. Hence, we need to apply some additional constraints by applying an information bottleneck. We do this by constraining the possible configurations that the hidden layer can take to only those configurations seen during training. This allows for a selective reconstruction (limited to a subset of the input space) and makes the model insensitive to everything not in the manifold. -->
入力を再構成しようとしているので、モデルは入力の特徴をすべて隠れ層にコピーして出力として渡す傾向があり、本質的には恒等写像のように振る舞うことになります。これは、モデルが何も学習していないことを意味するので、避ける必要があります。したがって、information bottleneckを適用して、追加の制約を適用する必要があります。これは、隠れ層がとりうる表現を、学習中に見られるものだけに制限することによって行います。これにより、選択的な再構成（入力空間の部分空間に限定されます）が可能になり、モデルは多様体に無いすべての入力に対して反応しづらくなります。

<!-- It is to be noted that an under-complete layer cannot behave as an identity function simply because the hidden layer doesn't have enough dimensions to copy the input. Thus an under-complete hidden layer is less likely to overfit as compared to an over-complete hidden layer but it could still overfit. For example, given a powerful encoder and a decoder, the model could simply associate one number to each data point and learn the mapping. There are several methods to avoid overfitting such as regularization methods, architectural methods, etc. -->
アンダーコンプリートな隠れ層は入力をコピーするのに十分な次元を持たないため、恒等写像として振る舞うことができないことに注意する必要があります。したがって、アンダーコンプリートな隠れ層は、オーバーコンプリートな隠れ層に比べて過学習する可能性が低くはなりますが、それでもまだ過学習する可能性があります。例えば、強力なエンコーダとデコーダが与えられた場合、モデルは各データポイントに1つの数値を単純に関連付け、その写像を学習することができます。過学習を回避する方法は、正則化法、アーキテクチャ法などいくつかあります。


<!-- ## Denoising autoencoder -->
## デノイジングオートエンコーダー

<!-- Fig.15 shows the manifold of the denoising autoencoder and the intuition of how it works. -->
図15は、デノイジングオートエンコーダーの多様体とそれがどのように機能するかを直観的に示した図です。

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/15_denoising_ae.png" width="500px" /><br>
<b>Fig. 15</b>: Denoising autoencoder<br>
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/15_denoising_ae.png" width="500px" /><br>
<b>図15</b>: デノイジングオートエンコーダー<br>
</center>

<!-- In this model, we assume we are injecting the same noisy distribution we are going to observe in reality, so that we can learn how to robustly recover from it.
By comparing the input and output, we can tell that the points that already on the manifold data did not move, and the points that far away from the manifold moved a lot. -->
このモデルでは、現実に観測されるようなノイズの多い分布を入力していると仮定して、そこからロバストにデータを復元する方法を学習します。
入力データと出力データを比較すると、既に多様体上にある点は動かず、多様体から離れた点は大きく動いていることがわかります。

<!-- Fig.16 gives the relationship between the input data and output data. -->
図16は、入力データと出力データの関係を示したものです。

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/16_relation1.png" width="350px" />
<img src="{{site.baseurl}}/images/week07/07-3/16_relation2.png" width="330px" />
<br>
<b>Fig. 16</b>: Input and output of denoising autoencoder<br>
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/16_relation1.png" width="350px" />
<img src="{{site.baseurl}}/images/week07/07-3/16_relation2.png" width="330px" />
<br>
<b>図16</b>: デノイジングオートエンコーダーの入力と出力<br>
</center>

<!-- We can also use different colours to represent the distance of each input point moves, Fig.17 shows the diagram. -->
また、各入力点の移動距離を表すために異なる色を使用することも可能であり、図17はそれを図示したものです。

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/17_distance.png" width="500px" /><br>
<b>Fig. 17</b>: Measuring the traveling distance of the input data<br>
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/17_distance.png" width="500px" /><br>
<b>図17</b>: 入力データが移動した距離を測ったもの<br>
</center>

<!-- The lighter the colour, the longer the distance a point travelled. From the diagram, we can tell that the points at the corners travelled close to 1 unit, whereas the points within the 2 branches didn't move at all since they are attracted by the top and bottom branches during the training process. -->
色が薄いほど移動距離が長いことを示しています。この図から、角にある点大体1単位分の距離を移動しているのに対し、2本の枝の中にある点は上と下の枝に学習中に引き込まれてしまって全く移動していないことがわかります。


<!-- ## Contractive autoencoder -->
## 縮小オートエンコーダー

<!-- Fig.18 shows the loss function of the contractive autoencoder and the manifold. -->
図18は、縮小オートエンコーダーの損失関数とその多様体を示した図です。

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/18_contractive_ae.png" width="500px" /><br>
<b>Fig. 18</b>: Contractive autoencoder <br>
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/18_contractive_ae.png" width="500px" /><br>
<b>図18</b>: 縮小オートエンコーダー <br>
</center>

<!-- The loss function contains the reconstruction term plus squared norm of the gradient of the hidden representation with respect to the input. Therefore, the overall loss will minimize the variation of the hidden layer given variation of the input. The benefit would be to make the model sensitive to reconstruction directions while insensitive to any other possible directions. -->
損失関数は，再構成項に入力に対する潜在表現の勾配のノルムの2乗を加えたものです。したがって、全体の損失は、入力の変動が与えられた場合の隠れ層の変動を最小化します。その利点としては、モデルが再構成に敏感になる一方で、他の可能性のある方向には鈍感になることが挙げられます。

<!-- Fig.19 shows how these autoencoders work in general. -->
図19は、これらのオートエンコーダーが一般的にどのように動作するかを示しています。

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/19_basic_ae.png" width="500px" /><br>
<b>Fig. 19</b>: Basic autoencoder <br>
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/19_basic_ae.png" width="500px" /><br>
<b>図19</b>: 基本的なオートエンコーダー <br>
</center>

<!-- The training manifold is a single-dimensional object going in three dimensions. Where $\boldsymbol{x}\in \boldsymbol{X}\subseteq\mathbb{R}^{n}$, the goal for autoencoder is to stretch down the curly line in one direction, where $\boldsymbol{z}\in \boldsymbol{Z}\subseteq\mathbb{R}^{d}$. As a result, a point from the input layer will be transformed to a point in the latent layer. Now we have the correspondence between points in the input space and the points on the latent space but do not have the correspondence between regions of the input space and regions of the latent space. Afterwards, we will utilize the decoder to transform a point from the latent layer to generate a meaningful output layer. -->
訓練データのなす多様体は、三次元中に伸びる一次元の物体です。$\boldsymbol{x}\in \boldsymbol{X}\subseteq\mathbb{R}^{n}$であるとき、オートエンコーダーの目的は、この巻き上がった線を一方向に引き伸ばすことです。ただし、$\boldsymbol{z}\in \boldsymbol{Z}\subseteq\mathbb{R}^{d}$です。その結果、入力層の点は、隠れ層の点に変換されます。これで、入力空間上の点と潜在空間上の点の対応関係はわかりましたが、入力空間の領域と潜在空間の領域の対応関係はわかりません。その後、デコーダを利用して隠れ層の点を変換することで、意味のある出力層を生成します。


<!-- ## [Implement autoencoder - Notebook](https://www.youtube.com/watch?v=bggWQ14DD9M&t=2491s) -->
## [オートエンコーダーの実装 - Notebook](https://www.youtube.com/watch?v=bggWQ14DD9M&t=2491s)

<!-- The Jupyter Notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/10-autoencoder.ipynb). -->
Jupyter Notebook は[ここ](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/10-autoencoder.ipynb)にあります。

<!-- In this notebook, we are going to implement a standard autoencoder and a denoising autoencoder and then compare the outputs. -->
このnotebookでは、標準的なオートエンコーダーとデノイジングオートエンコーダーを実装して、その出力を比較します。


<!-- ### Define autoencoder model architecture and reconstruction loss -->
### オートエンコーダーのアーキテクチャと再構成誤差の定義

<!-- Using $28 \times 28$ image, and a 30-dimensional hidden layer. The transformation routine would be going from $784\to30\to784$. By applying hyperbolic tangent function to encoder and decoder routine, we are able to limit the output range to $(-1, 1)$. Mean Squared Error (MSE) loss will be used as the loss function of this model. -->
$28 \times 28$の画像と 30次元の隠れ層を使うと 全体の変換は、$784\to30\to784$という変換になります。エンコーダとデコーダにtanh関数を適用することで、出力範囲を$(-1, 1)$に制限することができます。このモデルの損失関数には、平均二乗誤差(MSE)損失を使用します。

```python=
class Autoencoder(nn.Module):
    def __init__(self):
        super().__init__()
        self.encoder = nn.Sequential(
            nn.Linear(n, d),
            nn.Tanh(),
        )
        self.decoder = nn.Sequential(
            nn.Linear(d, n),
            nn.Tanh(),
        )

    def forward(self, x):
        x = self.encoder(x)
        x = self.decoder(x)
        return x

model = Autoencoder().to(device)
criterion = nn.MSELoss()
```


<!-- ### Train standard autoencoder -->
### 標準的なオートエンコーダーの学習

<!-- To train a standard autoencoder using PyTorch, you need put the following 5 methods in the training loop: -->
PyTorchで標準的なオートエンコーダーを学習するためには、次の5つの方法を訓練のループに入れる必要があります。


<!-- #### Going forward: -->
#### フォワード処理:

<!-- 1) Sending the input image through the model by calling `output = model(img)` . <br>
2) Compute the loss using: `criterion(output, img.data)`. -->
1) `output = model(img)`を呼ぶことで、入力画像をモデル内で順伝播させます <br>
2) 次のコードで損失を計算します: `criterion(output, img.data)`


<!-- #### Going backward: -->
#### バックワード処理:

<!-- 3) Clear the gradient to make sure we do not accumulate the value: `optimizer.zero_grad()`. <br>
4) Back propagation: `loss.backward()`<br>
5) Step backwards: `optimizer.step()` -->
3) 勾配の値を溜め込まないように勾配を消去します: `optimizer.zero_grad()` <br>
4) 誤差逆伝播: `loss.backward()`<br>
5) 重みの更新: `optimizer.step()`

<!-- Fig. 20 shows the output of the standard autoencoder. -->
図20は、標準的なオートエンコーダーの出力を示した図です。

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/21_output_stae.png" width="500px" /><br>
<b>Fig. 20</b>: Output of standard autoencoder <br>
</center>
<br/> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/21_output_stae.png" width="500px" /><br>
<b>図20</b>: 標準的なオートエンコーダの出力 <br>
</center>
<br/>


<!-- ### Train denoising autoencoder -->
### デノイジングオートエンコーダーの学習

<!-- For denoising autoencoder, you need to add the following steps:<br>
1) Calling `nn.Dropout()` to randomly turning off neurons. <br>
2) Create noise mask: `do(torch.ones(img.shape))`.<br>
3) Create bad images by multiply good images to the binary masks: `img_bad = (img * noise).to(device)`. -->
デノイジングオートエンコーダーについては，次のステップを加える必要があります:<br>
1) `nn.Dropout()`でランダムにニューロンを落とす。<br>
2) ノイズのマスクを作る: `do(torch.ones(img.shape))`<br>
3) 二値マスクに良い画像を掛け合わせて悪い画像を作成する: `img_bad = (img * noise).to(device)`.

<!-- Fig. 21 shows the output of the denoising autoencoder. -->
図21はデノイジングオートエンコーダーの出力を表しています。

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/22_out_denoising_ae.png" width="500px" /><br>
<b>Fig. 21</b>: Output of denoising autoencoder <br>
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/22_out_denoising_ae.png" width="500px" /><br>
<b>図21</b>: デノイジングオートエンコーダーの出力 <br>
</center>


<!-- ### Kernels comparison -->
### カーネルの比較

<!-- It is important to note that in spite of the fact that the dimension of the input layer is $28 \times 28 = 784$, a hidden layer with a dimension of 500 is still an over-complete layer because of the number of black pixels in the image.
Below are examples of kernels used in the trained under-complete standard autoencoder. Clearly, the pixels in the region where the number exists indicate the detection of some sort of pattern, while the pixels outside of this region are basically random. This indicates that the standard autoencoder does not care about the pixels outside of the region where the number is. -->
入力層の次元が $28 \times 28 = 784$ であるという事実にもかかわらず、次元が 500 の隠れ層は、画像中の黒いピクセルの数のせいで、まだオーバーコンプリートな隠れ層であることに注意することが重要です。
以下に、訓練されたアンダーコンプリートな標準的なオートエンコーダーで使用されたカーネルの例を示します。明らかに、数字が存在する領域のピクセルは何らかのパターンの検出を示しており、この領域外のピクセルは基本的にランダムです。これは、標準的なオートエンコーダーが、数字が存在する領域の外側のピクセルを気にしていないことを示しています。

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/AE_kernels.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 22:</b> Standard AE kernels.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/AE_kernels.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>図22:</b> 標準的な　AE のカーネル.
</center>

<!-- On the other hand, when the same data is fed to a denoising autoencoder where a dropout mask is applied to each image before fitting the model, something different happens. Every kernel that learns a pattern sets the pixels outside of the region where the number exists to some constant value. Because a dropout mask is applied to the images, the model now cares about the pixels outside of the number’s region. -->
一方、同じデータを、モデルを学習する前に各画像にドロップアウトマスクが適用されるデノイジングオートエンコーダーに与えると、何か異なることが起こります。パターンを学習するすべてのカーネルは、数字が存在する領域の外側のピクセルをある一定の値に設定します。ドロップアウトマスクが画像に適用されるので、モデルは数字の領域の外側のピクセルを気にするようになりました。

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/denoiser_kernels.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>Figure 23:</b> Denoising AE kernels.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/denoiser_kernels.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>図23:</b> デノイジングオートエンコーダーのカーネル
</center>

<!-- Compared to the state of the art, our autoencoder actually does better!! You can see the results below. -->
state-of-the-artの結果と比較しても、実際にこのオートエンコーダーの性能は優れています！結果は以下の通りです。


<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/AE_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 24:</b> Input data (MNIST digits).
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/AE_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>図24:</b> 入力データ (MNIST)
</center>


<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/denoiser_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 25:</b> Denoising AE reconstructions.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/denoiser_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>図25:</b> デノイジングオートエンコーダーの再構成結果
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/telea_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 26:</b> Telea inpainting output.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/telea_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>図26:</b> Telea 2004によって提案されたアルゴリズムを用いた画像修復の結果
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/navier-stokes_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 27:</b> Bertalmio et al 2001によって提案されたNavier-Stokes方程式に基づくアルゴリズムを用いた画像修復の結果
</center>
