---
lang-ref: ch.07-2
lang: ja
lecturer: Yann LeCun
title: SSL、EBMの詳細と例
authors: Ravi Choudhary， B V Nithish Addepalli, Syed Rahman，Jiayi Du
date: 9 Mar 2020
translation-date: 12 Aug 2020
translator: Shiro Takagi
---


<!-- ## [Self supervised learning](https://www.youtube.com/watch?v=tVwV14YkbYs&t=2683s) -->
## [自己教師あり学習](https://www.youtube.com/watch?v=tVwV14YkbYs&t=2683s)

<!-- Self Supervised Learning (SSL) encompasses both supervised and unsupervised learning. The objective of the SSL pretext task is to learn a good representation of the input so that it can subsequently be used for supervised tasks. In SSL, the model is trained to predict one part of the data given other parts of the data. For example, BERT was trained using SSL techniques and the Denoising Auto-Encoder (DAE) has particularly shown state-of-the-art results in Natural Language Processing (NLP). -->

自己教師あり学習(SSL)は教師あり学習と教師なし学習の両方を含んでいます。SSLのpretextタスク（本来解きたいタスクの前に解く補助的なタスクのこと）の目的は、入力の良い表現を学習して、その後の教師ありタスクに使用できるようにすることです。SSLでは、データのある部分が与えられた時、モデルはその他の部分を予測するように訓練されます。例えば、BERTはSSLの技術を用いて訓練され、デノイジイングオートエンコーダー(DAE)は特に自然言語処理(NLP)において最先端の（state-of-the-artの、SOTAの）結果を示しています。


<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-2/1_ssl.png"/><br>
<b>Fig. 1</b>: Self Supervised Learning
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-2/1_ssl.png"/><br>
<b>図1</b>: 自己教師あり学習
</center>

<!-- Self Supervised Learning task can be defined as the following:
* Predict the future from the past.
* Predict the masked from the visible.
* Predict any occluded parts from all available parts.
-->
自己教師あり学習タスクは、以下のように定義することができます。
* 過去から未来を予測する。
* 目に見えるものからマスクされたものを予測する。
* すべての利用可能な部分から任意の遮蔽された部分を予測する。

<!-- For example, if a system is trained to predict the next frame when the camera is moved, the system will implicitly learn about the depth and parallax. This will force the system to learn that objects occluded from its vision do not disappear but continue to exist and the distinction between animate, inanimate objects, and the background. It can also end up learning about intuitive physics like gravity. -->
例えば、カメラが移動したときに次のフレームを予測するようにシステムが訓練されている場合、システムは暗黙のうちに奥行きと視差を学習します。これにより、システムは、視界から遮られた物体が消えるのではなく存在し続けることや、生身の物体、無生物、背景の区別を学習することを余儀なくされます。また、重力のような直観物理学を学習してしまうこともあります。

<!-- State-of-the-art NLP systems (BERT) pre-train a giant neural network on an SSL task. You remove some of the words from a sentence and make the system predict the missing words. This has been very successful. Similar ideas were also tried out in computer vision realm. As shown in the image below, you can take an image and remove a portion of the image and train the model to predict the missing portion. -->
最先端のNLPシステム（BERT）は、SSLタスクで巨大なニューラルネットワークを事前に訓練します。文中の単語の一部を削除して、欠けている単語をシステムに予測させるのですが、これは非常にうまくいっています。同様のアイデアは、コンピュータビジョンの分野でも試されました。下の画像のように、画像を撮影して、画像の一部を削除して、欠落している部分を予測するモデルを訓練することができます。

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-2/2_cv_eg.png"/><br>
<b>Fig. 2</b>: Corresponding results in computer vision
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-2/2_cv_eg.png"/><br>
<b>図2</b>: コンピュータビジョンにおける対応する結果
</center>

<!-- Although the models can fill in the missing space they have not shared the same level of success as NLP systems. If you were to take the internal representations generated by these models, as input to a computer vision system, it is unable to beat a model that was pre-trained in a supervised manner on ImageNet. The difference here is that NLP is discrete whereas images are continuous. The difference in success is because in the discrete domain we know how to represent uncertainty, we can use a big softmax over the possible outputs, in the continuous domain we do not. -->
これらのモデルは足りていなかった部分を補うことはできますが、NLPシステムと同じレベルの成功を収めたとはいえません。これらのモデルによって生成された内部表現をコンピュータビジョンシステムに入力しても、ImageNet上で教師ありの方法で事前に訓練されたモデルに勝つことはできません。ここでの違いは、NLPが離散的であるのに対し、画像は連続的であるということです。成否を分けた点は、離散領域では不確実性の表現方法を知っているため、可能な出力に対して大きなソフトマックスを使うことができますが、連続領域ではそうではないという点です。

<!-- An intelligent system (AI agent) needs to be able to predict the results of its own action on the surroundings and itself to make intelligent decisions. Since the world is not completely deterministic and there is not enough compute power in a machine/human brain to account for every possibility, we need to teach AI systems to predict in the presence of uncertainty in high dimensional spaces. Energy-based models (EBMs) can be extremely useful for this. -->
知的システム（AIエージェント）が知的な意思決定を行うためには、周囲や自分自身の行動の結果を予測する能力が必要です。世界は完全に決定論的というわけではなく、機械/人間の脳にはあらゆる可能性を説明するのに十分な計算能力があるわけではないので、不確実性の伴う高次元空間の中で予測することを、AIシステムに教える必要があります。そのためには、エネルギーベースモデル（EBM）が非常に有用です。

<!-- A neural network trained using Least Squares to predict the next frame of a video will result in blurry images because the model cannot exactly predict the future so it learns to average out all possibilities of the next frame from the training data to reduce the loss. -->
ビデオの次のフレームを予測するために最小二乗法を使用して訓練されたニューラルネットワークは、正確に未来を予測することができません。実際、損失を減らすために訓練データから次のフレームのすべての可能性を平均化することを学習するため、画像がぼやけてしまいます（ぼやけた画像を学習してしまいます）。


<!-- ### Latent variable energy-based models as a solution to make predictions for next frame: -->
### 次のフレームの予測を行うための解決策としての潜在変数つきエネルギーベースモデル

<!-- Unlike linear regression, Latent variable energy-based models take what we know about the world as well as a latent variable which gives us information about what happened in reality. A combination of those two pieces of information can be used to make a prediction that will be close to what actually occurs. -->
線形回帰とは異なり、潜在変数つきエネルギーベースモデルは、世界について知っていることと、現実に起こったことについての情報を与えてくれる潜在変数とを、利用します。これら2つの情報を組み合わせて、実際に起こったことに近い予測を行うことができます。

<!-- These models can be thought of as systems that rate compatibility between the input $x$ and actual output $y$ depending on the prediction using the latent variable that minimizes the energy of the system. You observe input $x$ and produce possible predictions $\bar{y}$ for different combinations of input $x$ and latent variables $z$ and choose the one that minimizes the energy, prediction error, of the system. -->
これらのモデルは、システムのエネルギーを最小にする潜在変数を使った予測によって、入力$x$と実際の出力$y$の間の適合性を評価するシステムと考えることができます。入力$x$を観測し、入力$x$と潜在変数$z$の異なる組み合わせに対して可能な予測$\bar{y}$を生成し、システムの予測誤差であるエネルギーを最小化するものを選択するのです。

<!-- Depending upon the latent variable we draw, we can end up with all the possible predictions. The latent variable could be thought of as a piece of important information about the output $y$ that is not present in the input $x$. -->
潜在変数に応じて、私たちはすべてのありうる予測に行き着くことができます。潜在変数は、入力 $x$ には存在しない出力 $y$ に関する重要な情報の一部と考えることができるのです。


<!-- Scalar-valued energy function can take two versions:
1. Conditional $F(x, y)$ - measure the compatibility between $x$ and $y$
2. Unconditional $F(y)$ -  measure the compatibility between the components of $y$ -->
スカラー値のエネルギー関数には2つのバージョンがあります。
1. 条件付き$F(x, y)$：$x$ と $y$ の間の適合度を測る。
2. 条件なし$F(y)$：$y$ の成分間の適合度を測る。


<!-- ## [Training an Energy-Based Model](https://www.youtube.com/watch?v=tVwV14YkbYs&t=3957s) -->
## [エネルギーベースモデルの学習](https://www.youtube.com/watch?v=tVwV14YkbYs&t=3957s)

<!-- There are two classes of learning models to train an Energy-Based Model to parametrize $F(x, y)$.
1. **Contrastive methods:** Push down on $F(x[i], y[i])$, push up on other points $F(x[i], y')$
2. **Architectural Methods:** Build $F(x, y)$ so that the volume of low energy regions is limited or minimized through regularization -->
$F(x, y)$をパラメトライズするようにエネルギーベースモデルを訓練するための学習モデルには、2つのクラスがあります。
1. **コントラスティブ法:** $F(x[i], y[i])$を押し下げ、他の点 $F(x[i], y')$を押し上げます。
2. **アーキテクチャ法：** 正則化によって低エネルギー領域の体積を制限するように、あるいは最小化するように$F(x, y)$を構築します。
<!-- TODO: I don't know how to translate Architectural Methods -->

<!-- There are seven strategies to shape the energy function. The contrastive methods differ in the way they pick the points to push up. While the architectural methods differ in the way they limit the information capacity of the code. -->
エネルギー関数を構成するためには7つの戦略があります。コントラスティブ法は、押し上げるポイントの選び方によって異なる方法が存在します。一方でアーキテクチャ法は、コードの情報容量をどのように制限するかという点で異なる方法が存在します。

<!-- An example of the contrastive method is Maximum Likelihood learning. The energy can be interpreted as an unnormalised negative log density. Gibbs distribution gives us the likelihood of $y$ given $x$. It can be formulated as follows: -->
コントラスティブ法の例としては、最尤法による学習があります。エネルギーは正規化されていない負の対数密度と解釈できることを説明しました。このエネルギーを用いたギブス分布は、 $x$ が与えられたときの $y$ の尤度を与えてくれます。これは次のように定式化できます。

$$
P(Y \mid W) = \frac{e^{-\beta E(Y,W)}}{\int_{y}e^{-\beta E(y,W)}}
$$

<!-- Maximum likelihood tries to make the numerator big and the denominator small to maximize the likelihood. This is equivalent to minimizing $-\log(P(Y \mid W))$ which is given below -->
最尤法は、分子を大きく、分母を小さくして尤度を最大化しようとします。これは、以下の $L(Y, W) = -log(P(Y \mid W))$ を最小化することと等価です。

$$
L(Y, W) = E(Y,W) + \frac{1}{\beta}\int_{y}e^{-\beta E(y,W)}
$$

<!-- Gradient of the negative log likelihood loss for one sample Y is as follows: -->
1つのサンプル$Y$に対する負の対数尤度損失の勾配は次のようになります。

$$
\frac{\partial L(Y, W)}{\partial W} = \frac{\partial E(Y, W)}{\partial W} - \int_{y} P(y\mid W) \frac{\partial E(y,W)}{\partial W}
$$

<!-- In the above gradient, the first term of the gradient at the data point $Y$ and the second term of the gradient gives us the expected value of the gradient of the energy over all $Y$s. Hence, when we perform gradient descent the first term tries to reduce energy given to the data point $Y$ and the second term tries to increase the energy given to all other $Y$s. -->
上記の勾配におけるデータ点 $Y$ での勾配の第一項と、勾配の第二項は、すべての $Y$ に渡るエネルギーの勾配の期待値を与えてくれます。したがって、勾配降下法を実行するときには、最初の項はデータ点 $Y$ に与えられるエネルギーを減らそうとし、2番目の項は他のすべての $Y$ に与えられるエネルギーを増やそうとします。

<!-- The gradient of the energy function is generally very complex and hence computing, estimating or approximating the integral is a very interesting case as it is intractable in most of the cases. -->
エネルギー関数の勾配は一般的に非常に複雑であるため、この積分を推定したり、近似したりすることは、ほとんどの場合で難解であり、非常に興味深いケースです。


<!-- ## [Latent variable energy-based model](https://www.youtube.com/watch?v=tVwV14YkbYs&t=4767s) -->
## [潜在変数つきエネルギーベースモデル](https://www.youtube.com/watch?v=tVwV14YkbYs&t=4767s)

<!-- The main advantage of Latent variable models is that they allow multiple predictions through the latent variable. As $z$ varies over a set, $y$ varies over the manifold of possible predictions. Some examples include:
1. K-means
2. Sparse modelling
3. [GLO](https://arxiv.org/abs/1707.05776) -->
潜在変数モデルの主な利点は、潜在変数を通して複数の予測を可能にすることです。$z$ が集合上で変化するので、$y$ はありうる予測がなす多様体の上で変化します。いくつかの例があります。
1. K平均法
2. スパースモデリング
3. [GLO](https://arxiv.org/abs/1707.05776)

<!-- These can be of two types:
1. Conditional models where $y$ depends on $x$
    1. $$F(x,y) = \text{min}_{z} E(x,y,z)$$
    2. $$F_\beta(x,y) = -\frac{1}{\beta}\log\int_z e^{-\beta E(x,y,z)}$$
2. Unconditional models that have scalar-valued energy function, $F(y)$ that measures the compatibility between the components of $y$
    1. $$F(y) = \text{min}_{z} E(y,z)$$
    2. $$F_\beta(y) = -\frac{1}{\beta}\log\int_z e^{-\beta E(y,z)}$$

<center>
<img src="{{site.baseurl}}/images/week07/07-2/3_lv_ebm.png" width="50%"/><br>
<b>Fig. 3</b>: Latent Variable EBM
</center>-->
これらには2つのタイプがあります：
1. $y$が$x$に依存する条件付きモデル
    1. $$F(x,y) = \text{min}_{z} E(x,y,z)$$
    2. $$F_\beta(x,y) = -\frac{1}{\beta}\log\int_z e^{-\beta E(x,y,z)}$$
2. スカラー値のエネルギー関数 $F(y)$ を持つ条件なしモデル（これは$y$の成分間の適合度を測ります）
    1. $$F(y) = \text{min}_{z} E(y,z)$$
    2. $$F_\beta(y) = -\frac{1}{\beta}\log\int_z e^{-\beta E(y,z)}$$

<center>
<img src="{{site.baseurl}}/images/week07/07-2/3_lv_ebm.png" width="50%"/><br>
<b>図3</b>: 潜在変数つきEBM
</center>


<!-- ## Latent variable EBM example: $K$-means -->
## 潜在変数つきEBMの例: $K$平均法

<!-- K-means is a simple clustering algorithm that can also be considered as an energy-based model where we are trying to model the distribution over $y$. The energy function is $E(y,z) = \Vert y-Wz \Vert^2$ where $z$ is a $1$-hot vector. -->
K平均法は単純なクラスタリングアルゴリズムですが、$y$についての分布を考えることでエネルギーベースモデルとして考えることもできます。エネルギー関数は $E(y,z) = \Vert y-Wz \Vert^2$ で、ここでは$z$はone-hotベクトルです。

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-2/4_kmeans.png" width="50%"/><br>
<b>Fig. 4</b>: K-means example
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-2/4_kmeans.png" width="50%"/><br>
<b>図4</b>: K平均法の例
</center>

<!-- Given a value of $y$ and $k$, we can do inference by figuring out which of the $k$ possible columns of $W$ minimizes the reconstruction error or energy function. To train the algorithm, we can adopt an approach where we can find $z$ to choose the column of $W$ closest to $y$ and then try to get even closer by taking a gradient step and repeat the process. However, coordinate gradient descent actually works better and faster. -->
$y$ と $k$ の値が与えられると、 $k$ 個のありうる $W$ の列のうち、どの列が再構成誤差、またはエネルギー関数を最小化するかを求めることで推論を行うことができます。このアルゴリズムを訓練するには、 $y$ に最も近い $W$ の列を選択するように $z$ を求め、その後、勾配法を行ってさらに近づけようとし、その処理を繰り返すというアプローチを採用することができます。しかし、実際には座標降下法の方がうまくいくいきますし、学習も速くなります。

<!-- In the plot below we can see the data points along the pink spiral. The black blobs surrounding this line corresponds to quadratic wells around each of the prototypes of $W$. -->
下のプロットでは、ピンクの螺旋に沿ったデータ点を見ることができます。この線を囲む黒い塊は、 $W$ の各プロトタイプの周りの二次元の井戸のようなものに対応しています。
<!-- TODO: Not confidence in this translation -->

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-2/5_spiral.png" width="50%"/><br>
<b>Fig. 5</b>: Spiral Plot
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-2/5_spiral.png" width="50%"/><br>
<b>図5</b>: 螺旋のプロット
</center>

<!-- Once we learn the energy function, we can begin to address questions like:
1. Given a point $y_1$, can we predict $y_2$?
2. Given $y$, can we find the closest point on the data manifold? -->
エネルギー関数を学習すると、次のような問いに答えることができるようになります。
1. ある点 $y_1$ が与えられたとき、 $y_2$ を予測できるか？
2. $y$ が与えられたとき、データ多様体上で最も近い点を見つけることができるか？

<!-- K-means belongs to architectural methods (as opposed to contrastive methods). Hence we do not push up the energy anywhere, all we do is push the energy down in certain regions. One disadvantage is that once the value of $k$ has been decided, there can only be $k$ points that have $0$ energy, and every other point will have higher energy that grows quadratically as we move away from them. -->
K平均法は（コントラスティブ法とは対照的に）アーキテクチャ法に属します。したがって、エネルギーをどこかに押し上げるのではなく、特定の領域でエネルギーを押し下げるだけです。欠点としては、いったん $k$ の値が決まると、エネルギーが $0$ の $k$個の点しか存在しなくなり、それ以外の点はすべてエネルギーが高くなり、遠ざかるほどそのエネルギーが二次関数的に大きくなるという点あります。


<!-- ## Contrastive methods -->
## コントラスティブ法

<!-- According to Dr Yann LeCun, everyone will be using architectural methods at some point, but at this moment, it is contrastive methods that work for images. Consider the figure below which shows us some data points and contours of the energy surface. Ideally, we want the energy surface to have the lowest energy on the data manifold. Hence what we would like to do is lower the energy (i.e. the value of $F(x,y)$) around the training example, but this alone may not be enough. Hence we also raise it for the $y$'s in the region that should have high energy but has low energy. -->
Yann LeCun博士によると、誰もがいつかはアーキテクチャ法を使うようになるでしょうが、現時点では、画像に対してはコントラスティブ法が有効だとのことです。エネルギー面の輪郭とデータ点とを示した下の図について考えます。エネルギー面はデータの多様体上で最も低いエネルギーであることが理想です。したがって、訓練データサンプルの周辺のエネルギー（すなわち、$F(x,y)$の値）を低くしたいのですが、これだけでは十分ではないかもしれません。そこで、本来ならエネルギーが高いはずなのにエネルギーが低くなっている領域にある$y$のエネルギーも上げることにします。

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-2/6_contrastive_1.png" width="50%"/><br>
<b>Fig. 6</b>: Contrastive methods
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-2/6_contrastive_1.png" width="50%"/><br>
<b>図6</b>: コントラスティブ法
</center>

<!-- There are several ways to find these candidates $y$'s that we want to raise energy for. Some examples are:
1. Denoising Autoencoder
2. Contrastive Divergence
3. Monte Carlo
4. Markov Chain Monte Carlo
5. Hamiltonian Monte Carlo -->
エネルギーを大きくしたい$y$の候補を見つける方法はいくつかあります。そのうちのいくつかの例として、

1. デノイジング・オートエンコーダー
2. コントラスティブダイバージェンス法
3. モンテカルロ法
4. マルコフ連鎖モンテカルロ法
5. ハミルトニアンモンテカルロ法

があります。

<!-- We will briefly discuss denoising autoencoders and contrastive divergence. -->
ここでは、デノイジング・オートエンコーダーとコントラストダイバージェンス法について簡単に説明します。


<!-- ### Denoising autoencoder (DAE) -->
### デノイジング・オートエンコーダー (DAE)

<!-- One way of finding $y$'s to increase energy for it is by randomly perturbing the training example as shown by the green arrows in the plot below. -->
エネルギーを増やすために$y$を見つける方法の一つは、下のプロットの緑の矢印で示されているように、訓練データサンプルにランダムに摂動を加えることです。

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-2/7_contrastive_2.png" width="50%"/><br>
<b>Fig. 7</b>: Topographic map
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-2/7_contrastive_2.png" width="50%"/><br>
<b>図7</b>: 等エネルギー線図
</center>

<!-- Once we have a corrupted data point, we can push the energy up here. If we do this sufficiently many times for all the data points, the energy sample will curl up around the training examples. The following plot illustrates how training is done. -->
破損したデータ点（摂動が加えられたデータ点）があれば、ここでエネルギーを押し上げることができます。すべてのデータ点についてこれを十分に何度も行うと、エネルギーサンプルは訓練データサンプルの周りで丸くなります。次のプロットは、訓練がどのように行われるかを示しています。

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-2/8_training.png" width="50%"/><br>
<b>Fig. 8</b>: Training
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-2/8_training.png" width="50%"/><br>
<b>図8</b>: 訓練
</center>

<!-- Steps for training:
1. Take a point $y$ and corrupt it
2. Train the Encoder and Decoder to reconstruct the original data point from this corrupted data point -->
訓練のステップ
1. 点 $y$ を取って、それを破損させる
2. エンコーダとデコーダを訓練して、この破損したデータ点から元のデータ点を再構成します。
<!-- TODO: 「破損させる」may not be a good translation. It sounds like destroying or completely breaking up something. I was not able not think up the good translation for the corrupting data by adding noise. -->

<!-- If the DAE is properly trained, the energy grows quadratically as we move away from the data manifold. -->
DAEが適切に訓練されている場合、データ多様性から遠ざかるにつれて、エネルギーは2次関数的に増加します。

<!-- The following plot illustrates how we use the DAE. -->
次のプロットは、どのようにDAEを使うかを示しています。

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-2/9_dae_use.png" width="50%"/><br>
<b>Fig. 9</b>: How DAE is used
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-2/9_dae_use.png" width="50%"/><br>
<b>図9</b>: どのように DAE を使うか
</center>


<!-- ### BERT -->
### BERT

<!-- BERT is trained similarly, except that the space is discrete as we are dealing with text. The corruption technique consists of masking some of the words and the reconstruction step consists of trying to predict these. Hence, this is also called a masked autoencoder. -->
BERT は、テキストを扱っているので空間が離散的ですが、それを除けば同じように訓練されます。いくつかの単語をマスキングすることでデータを破損させ、これらの単語を予測しようとすることで再構成を行います。したがって、これはマスク付きオートエンコーダーとも呼ばれています。

<!-- ### Contrastive divergence -->
### コントラスティブ法

<!-- Contrastive Divergence presents us with a smarter way to find the $y$ point that we want to push up the energy for. We can give a random kick to our training point and then move down the energy function using gradient descent. At the end of the trajectory, we push up the energy for the point we land on. This is illustrated in the plot below using the green line. -->
コントラスティブダイバージェンス法は、エネルギーを押し上げたい$y$の点を見つけるためのより賢い方法を提供してくれます。訓練点にランダムな摂動を与えて、勾配降下法を使ってエネルギー関数の上を下降させることができます。軌道の最後に、着地した点のエネルギーを押し上げます。これを緑の線で示したのが下のプロットです。

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-2/10_contrastive_div.png" width="50%"/><br>
<b>Fig. 10</b>: Contrastive Divergence
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-2/10_contrastive_div.png" width="50%"/><br>
<b>図10</b>: コントラスティブダイバージェンス法
</center>
