---
lang-ref: ch.07-1
lang: ja
lecturer: Yann LeCun
title: エネルギーベースモデル
authors: Karanbir Singh Chahal，Meiyi He, Alexander Gao, Weicheng Zhu
date: 9 Mar 2020
translation-date: 11 Aug 2020
translator: Shiro Takagi
---


<!-- ## [Overview](https://www.youtube.com/watch?v=tVwV14YkbYs&t=64s) -->
## [概要](https://www.youtube.com/watch?v=tVwV14YkbYs&t=64s)

<!-- We will introduce a new framework for defining models. It provides a unifying umbrella that helps define supervised, unsupervised and self-supervised models. Energy-based models observe a set of variables $x$ and output a set of variables $y$. There are 2 major problems with feed-forward nets:

1. What if the inference procedure is a more complex calculation than stacked layers of weighted sums?
2. What if there are multiple possible outputs for a single input? Example: Predicting future frames of video. Essentially in a classification net, we train this net to emit a score for each class. However, this is not possible to do in a continuous high dimensional domain like images. (We cannot have softmax over images!). Even if the output is discrete, it could have a large sample space. For example, the text is compositional leading to a huge number of possible combinations. Energy-based models provide a better framework to model these modalities. -->

モデルを定義するための新しいフレームワークを紹介します。これは、教師あり、教師なし、自己教師ありのモデルを定義するのに役立つ統一的な枠組みを提供するものです。エネルギーベースモデルは、変数の集合 $x$ を観測し、変数の集合 $y$ を出力します。フィードフォワードネットには2つの大きな問題があります。

1. 単に加重和を行う層を積み重ねたもの以上の複雑な計算を伴う推論を行う場合にはどうするのか？
2. 1つの入力に対して複数の出力がありうる場合はどうなるのか？（例えば、動画の未来のフレームを予測する場合。）分類ネットでは、本質的にはクラスごとのスコアを出力するようにこのネットワークを訓練します。しかし、これは画像のような連続的かつ高次元の領域では不可能です（softmaxで確率を考えることは離散的な出力に対する操作なので、画像に対してのsoftmaxを考えることはできません！）。出力が離散的であったとしても、サンプル空間が大きい可能性があります。例えば、文章は構成的なため、膨大な数の組み合わせが考えられます。エネルギーベースモデルは、これらのモダリティをモデル化するためのより良い枠組みを提供するものです。



<!-- ## EBM approach -->
## EBMのアプローチ

<!-- Instead of trying to classify $x$'s to $y$'s, we would like to predict if a certain pair of ($x$, $y$) fit together or not. Or in other words, find a $y$ compatible with $x$. We can also pose the problem as finding a $y$ for which some $F(x,y)$ is low. For example:

- Is $y$ an accurate high-resolution image of $x$ ?
- Is text `A` a good translation of text `B`? -->

$x$を$y$に分類しようとするのではなく、あるペア($x$, $y$)が合うか合わないかを予測する問題、言い換えれば、$x$と相性の良い$y$を見つける問題を考えます。また、この問題は、ある $F(x,y)$ が低くなるようなある$y$ を見つける問題だと考えることもできます。例えば

- $y$ は $x$ の高精度で高解像度な画像であるか？
- テキスト `A` は、テキスト `B` の良い翻訳であるか？

などです。

<!-- This method of inference by minimizing a function and a large class of models work this way. By minimizing $f(x,y)$ or "energy". Hence, we perform inference by minimizing constraints where these constraints are represented by $f(x,y)$. We shall call $f(x,y)$ the "Energy function" from henceforth.
 -->


<!-- ### Definition -->
### 定義

<!-- We define an energy function $F: \mathcal{X} \times \mathcal{Y} \rightarrow \mathcal{R}$ where $F(x,y)$ describes the level of dependency between $(x,y)$ pairs. (**Note** that this energy is used in inference, **not** in learning.) The inference is given by the following equation:

$$
\check{y} = \displaystyle \text{argmin}_y \left \{ F(x,y)\right \}
$$ -->

エネルギー関数を次のように定義します：$F: \mathcal{X} \times \mathcal{Y} \rightarrow \mathcal{R}$。 ただし、$F(x,y)$は、$(x,y)$ペア間の依存の度合いを表しています(**注**：このエネルギーは推論時に使われるものであって、学習に使われるものではありません)。次の式にしたがって推論を行います。

$$
\check{y} = \displaystyle \text{argmin}_y \left \{ F(x,y)\right \}
$$


<!-- ### Solution: gradient-based inference -->
### 解法: 勾配法による推論

<!-- We would like the energy function to be smooth and differentiable so that we can use it to perform the gradient-based method for inference. In order to perform inference, we search this function using gradient descent to find compatible $y$'s.
There are many alternate methods to gradient methods to obtain the minimum.

**Aside**: Graphical models are a special case of Energy-Based models. The energy function decomposes as a sum of energy terms. Each energy terms take into account a subset of variables that we are dealing with. If they organize in a particular form, there are efficient inference algorithms to find the minimum of the sum of the terms with respect to the variable that we are interested in inferring. -->

勾配法を用いた推論に使えるように、エネルギー関数は滑らかで微分可能なものであって欲しいと考えます。推論を行うために、勾配降下法を用いてこの関数上を探索し、互換性のある $y$を見つけます。
最小値を求める方法は、勾配法の他にもたくさんあります。

**余談**：グラフィカルモデルは、エネルギーベースモデルの特殊な場合です。エネルギー関数は、エネルギー項の和に分解することができます。各エネルギー項は、私たちが扱っている変数の部分集合を踏まえたものです。エネルギー項がある特定の形式で構成されると、私たちが推論したい変数に対して、エネルギー項の和の最小値を見つけるための効率的な推論アルゴリズムが存在します。

<!-- There are a type of Energy Based Models that are quite popular. These are
 -->
<!-- ## [EBM with latent variables](https://www.youtube.com/watch?v=tVwV14YkbYs&t=904s) -->
## [潜在変数を持つEBM](https://www.youtube.com/watch?v=tVwV14YkbYs&t=904s)

<!-- The output $y$ depends on $x$ as well as an extra variable $z$ (the latent variable) which we do not know the value of. These latent variables can provide auxiliary information. For example, a latent variable can tell you the positions of word boundaries in a chunk of text. This would be helpful to know when we want to interpret handwriting without spaces. This is also especially useful to know in speech that can have hard-to-decipher gaps. Additionally, some languages have very faint word boundaries (e.g. French). Hence, having this latent variable in our model will be very useful to interpret such an input. -->

出力 $y$ は 、$x$ と、その値がわからない追加の変数 $z$ (潜在変数) に依存します。これらの潜在変数は、補助的な情報を提供することができます。例えば、潜在変数は、テキストのチャンク（単語の一塊の集まりのこと）の中の単語の境界の位置を教えてくれます。これは、単語の間のスペースのない手書きのテキストを解釈したいときに役立つでしょう。また、これは解読が困難な間隙のある音声を理解するのにも特に便利です。さらに、いくつかの言語では、単語の境界が非常に弱いものがあります（例：フランス語）。したがって、モデルがこの潜在変数を持っていることは、そのような入力を解釈するのに非常に有用です。


<!-- ### Inference -->
### 推論

<!-- To do inference with latent variable EBM, we want to simultaneously minimize energy function with respect to y and z.

$$\check{y}, \check{z} = \text{argmin}_{y,z} E(x,y,z)$$

And this is equivalent to redefining the energy function as: $$F_\infty(x,y) = \text{argmin}_{z}E(x,y,z)$$, which equals to: $$F_\beta(x,y) = -\frac{1}{\beta}\log\int_z \exp(-\beta E(x,y,z))$$.
When $\beta \rightarrow \infty$, then $\check{y} = \text{argmin}_{y}F(x,y)$. -->

<!--  ## Latent-Variable EBM -->
<!-- Another big advantage of allowing latent variables, is that by varying the latent variable over a set, we can make the prediction output $y$ vary over the manifold of possible predictions as well (the ribbon is shown in the graph below): $F(x,y) = \text{argmin}_{z} E(x,y,z)$.

This allows a machine to produce multiple outputs, not just one.

<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig1.png"/><br>
<b>Fig. 1</b>: Computation graph for Energy-based models
</center> -->


潜在変数を持つEBMで推論を行うためには、エネルギー関数を$y$と$z$について同時に最小化する必要があります。

$$\check{y}, \check{z} = \text{argmin}_{y,z} E(x,y,z)$$

これは、エネルギー関数を次のように再定義することと等価です：

$$F_\infty(x,y) = \text{argmin}_{z}E(x,y,z)$$

これはすなわち、次と等価です：

$$F_\beta(x,y) = -\frac{1}{\beta}\log\int_z \exp(-\beta E(x,y,z))$$

ただし、$\beta \rightarrow \infty$であるとき，$\check{y} = \text{argmin}_{y}F(x,y)$です。

<!--  ## Latent-Variable EBM -->
潜在変数を導入することのもう一つの大きな利点は、潜在変数をある集合上で変化させることによって、予測出力$y$も、ありうる予測の集まりからなる多様体上で変化させることができる点です（ひもで表された多様体は下の図に示されています）。

これにより、予測器は1つの出力だけでなく、複数の出力を生成することができます。

<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig1.png"/><br>
<b>図1</b>: エネルギーベースモデルの計算グラフ
</center>




<!-- ### Examples -->
### 例

<!-- One example is video prediction. There are many good applications for us to use video prediction, one example is to make a video compression system. Another is to use video taken from a self-driving car and predict what other cars are going to do.

Another example is translation. Language translation has always been a difficult problem because there is no single correct translation for a piece of text from one language to another. Usually, there are a lot of different ways to express the same idea and people find it is hard to reason why they pick one over the other. So it might be nice if we have some way of parametrising all the possible translations that a system could produce to respond to a given text. Let's say if we want to translate German to English, there could be multiple translations in English that are all correct, and by varying some latent variables then you may vary the translation produced. -->

その一例が動画予測です。動画予測を利用した良い応用例はたくさんありますが、その一つが、動画圧縮システムを作ることです。もう一つは、自動運転車から撮影した動画を使って、他の車が何をするかを予測することです。

動画予測とは別の例として、翻訳をあげることができます。言語翻訳は、常に難しい問題です。というのも、ある言語のテキストの一部から別の言語へのテキストの一部に対して、単一の正しい翻訳というものは存在しないためです。通常、同じ考えを表現するには多くの異なる方法があるため、私たちはなぜ他の表現でなくその表現を選ぶのかを説明するのが難しいと感じます。そこで、与えられたテキストに反応するためにシステムが生成できる可能性のあるすべての翻訳をパラメトリックに表現する方法があればいいかもしれません。例えば、ドイツ語を英語に翻訳したい場合、正しい英語の翻訳は複数ありえますが、いくつかの潜在変数を変化させることで、生成される翻訳を変化させることができます。


<!-- ## [Energy-based models *v.s.* probabilistic models](https://www.youtube.com/watch?v=tVwV14YkbYs&t=1703s) -->
## [エネルギーベースモデル *vs* 確率モデル](https://www.youtube.com/watch?v=tVwV14YkbYs&t=1703s)

<!-- We can look at the energies as unnormalised negative log probabilities, and use Gibbs-Boltzmann distribution to convert from energy to probability after normalization is:

$$P(y \mid x) = \frac{\exp (-\beta F(x,y))}{\int_{y'}\exp(-\beta F(x,y'))}$$

where $\beta$ is positive constant and needs to be calibrated to fit your model. Larger $\beta$ gives a more fluctuate model while smaller $\beta$ gives a smoother model. (In physics, $\beta$ is inverse temperature: $\beta \rightarrow \infty$ means temperature goes to zero).

$$P(y,z \mid x) = \frac{\exp(-\beta F(x,y,z))}{\int_{y}\int_{z}\exp(-\beta F(x,y,z))}$$

Now if marginalize over y: $P(y \mid x) = \int_z P(y,z \mid x)$, we have:

$$
\begin{aligned}
P(y \mid x) & = \frac{\int_z \exp(-\beta E(x,y,z))}{\int_y\int_z \exp(-\beta E(x,y,z))} \\
& = \frac{\exp \left [ -\beta \left (-\frac{1}{\beta}\log \int_z \exp(-\beta E(x,y,z))\right ) \right ] }{\int_y \exp\left [ -\beta\left (-\frac{1}{\beta}\log \int_z \exp(-\beta E(x,y,z))\right )\right ]} \\
& = \frac{\exp (-\beta F_{\beta}(x,y))}{\int_y \exp (-\beta F_{\beta} (x,y))}
\end{aligned}
$$

Thus, if we have a latent variable model and want to eliminate the latent variable $z$ in a probabilistically correct way, we just need to redefine the energy function $F_\beta$ (Free Energy) -->

エネルギーは正規化されていない負の対数確率と見ることができます。そして、正規化後にエネルギーを確率に変換するためには、Gibbs-Boltzmann分布を用います。

$$P(y \mid x) = \frac{\exp (-\beta F(x,y))}{\int_{y'}\exp(-\beta F(x,y'))}$$

ただし、$\beta$は正の定数であり、モデルに合うように調整する必要があります。$\beta$を大きくするとゆらぎが大きなモデルになり、小さくすると滑らかなモデルになります(物理学では、$\beta$は逆温度であり、$\beta \rightarrow \infty$ は温度がゼロになることを意味します)。

$$P(y,z \mid x) = \frac{\exp(-\beta F(x,y,z))}{\int_{y}\int_{z}\exp(-\beta F(x,y,z))}$$

これを$z$について周辺化すると: $P(y \mid x) = \int_z P(y,z \mid x)$、次の式を得ます

$$
\begin{aligned}
P(y \mid x) & = \frac{\int_z \exp(-\beta E(x,y,z))}{\int_y\int_z \exp(-\beta E(x,y,z))} \\
& = \frac{\exp \left [ -\beta \left (-\frac{1}{\beta}\log \int_z \exp(-\beta E(x,y,z))\right ) \right ] }{\int_y \exp\left [ -\beta\left (-\frac{1}{\beta}\log \int_z \exp(-\beta E(x,y,z))\right )\right ]} \\
& = \frac{\exp (-\beta F_{\beta}(x,y))}{\int_y \exp (-\beta F_{\beta} (x,y))}
\end{aligned}
$$

したがって、潜在変数モデルの潜在変数 $z$を、確率的に正しい方法で除去したい場合には、エネルギー関数$F_\beta$ (自由エネルギー) を再定義すればよいだけであるということがわかります。


<!-- ### Free Energy -->
### 自由エネルギー

$$
F_{\beta}(x,y) = - \frac{1}{\beta}\log \int_z \exp (-\beta E(x,y,z))
$$

<!-- Computing this can be very hard...  In fact, in most cases, it's probably intractable.  So if you have a latent variable that you want to minimize over inside of your model, or if you have a latent variable that you want to marginalize over (which you do by defining this Energy function $F$), and minimizing corresponds to the infinite $\beta$ limit of this formula, then it can be done. -->
<!-- TODO: "So" sounds wired to me in this context -->
これを計算するのは非常に難しいです...。実際、ほとんどの場合、おそらく手に負えません。 モデルの中で最小化したい潜在変数がある場合、あるいは、周辺化したい潜在変数がある場合（このエネルギー関数$F$を定義することで周辺化を行います）、最小化することがこの式の$\beta$の極限に対応する場合、それは実行可能です。

<!-- Under the definition of $F_\beta(x, y)$ above, $P(y \mid x)$ is just an application of the Gibbs-Boltzmann formula and $z$ has been marginalized implicitly inside of this.  Physicists call this "Free Energy", which is why we call it $F$.   So $e$ is the energy, and $F$ is free energy. -->
上の$F_\beta(x, y)$の定義では、$P(y \mid x)$は単にギブス・ボルツマン式の応用であり、$z$はこの中で暗黙のうちに周辺化されています。 物理学者はこれを「自由エネルギー」と呼んでおり、そのため私たちもこれを$F$と呼んでいます。つまり、$E$がエネルギーで、$F$が自由エネルギーということになります。

<!--***Question: Can you elaborate on the advantage that energy-based models give?  In probability-based models, you can also have latent variables, which can be marginalized over.*** -->
***質問：エネルギーベースモデルが与える利点についてもう少し詳しく教えてくださいませんか？ 確率ベースのモデルでも潜在変数を持つこともできますし、それについて周辺化することもできると思います。***

<!-- The difference is that in probabilistic models, you basically don't have the choice of the objective function you're going to minimize, and you have to stay true to the probabilistic framework in the sense that every object you manipulate has to be a normalized distribution (which you may approximate using variational methods, etc.). Here, we're saying that ultimately what you want to do with these models is make decisions.  If you build a system that drives a car, and the system tells you "I need to turn left with probability 0.8 or turn right with probability 0.2", you're going to turn left.  The fact that the probabilities are 0.2 and 0.8 doesn't matter -- what you want is to make the best decision, because you're forced to make a decision.  So probabilities are useless if you want to make decisions.  If you want to combine the output of an automated system with another one (for example, a human, or some other system), and these systems haven't been trained together, but rather they have been trained separately, then what you want are calibrated scores so that you can combine the scores of the two systems so that you can make a good decision.  There is only one way to calibrate scores, and that is to turn them into probabilities.  All other ways are either inferior or equivalent.  But if you're going to train a system end-to-end to make decisions, then whatever scoring function you use is fine, as long as it gives the best score to the best decision.  Energy-based models give you way more choices in how you handle the model, may more choices of how you train it, and what objective function you use. If you insist your model be probabilistic, you have to use maximum likelihood -- you basically have to train your model in such a way that the probability it gives to the data you observed is maximum.  The problem is that this can only be proven to work in the case where your model is "correct" -- and your model is never "correct".  There's a quote from a famous statistician [Goerge Box] that says ***"All models are wrong, but some are useful."***  So probabilistic models, particularly those in high-dimensional spaces, and in combinatorial spaces such as text, are all approximate models.  They're all wrong in a way, and if you try to normalize them, you make them more wrong.  So you're better off not normalizing them. -->
違いは、確率モデルでは、基本的に最小化する目的関数を選択することはできず、操作するすべてのオブジェクトは正規化された分布でなければならないという意味で、確率論的枠組みに忠実でなければならないということです（変分法などを使って近似することもできます）。ここでは、これらのモデルを使って最終的にしたいことが、意思決定であると言っています。 車を運転するシステムを作って、そのシステムが「確率0.8で左に曲がるか、確率0.2で右に曲がる必要がある」と教えてくれたら、あなたは左に曲がることになるでしょう。 確率が0.2と0.8であるという事実は問題ではありません。なんらかの意思決定をする必要があるのですから、最良の意思決定をする、というのがやりたいことなのです。つまり、意思決定をしたいなら確率は役に立たないのです。 自動化されたシステムの出力を別のシステム（例えば、人間や他のシステム）と組み合わせたい場合、さらにこれらのシステムは一緒に訓練されているのではなく、別々に訓練されている場合、欲しいのは、良い判断をするために2つのシステムのスコアの違いがうまく調整された、それらが組み合わされたスコアです。スコアの違いを調整する唯一の方法は、確率に変換することです。 他の方法はすべて劣っているか、同じくらいの方法です。 しかし、意思決定を行うためにシステムをエンドツーエンドで訓練しようとしているのであれば、それが最良の意思決定に最良のスコアを与える限り、どのようなスコアリング関数を使用しても構いません。 エネルギーベースモデルは、モデルをどのように扱うか、どのように訓練するか、どのような目的関数を使用するかなどについて、より多くの選択肢を与えてくれます。モデルが確率的であることを要求するならば、最尤推定を使用しなければなりません。すなわち、基本的には、観測されたデータに与える確率が最大になるようにモデルを訓練しなければなりません。 問題は、これはあなたのモデルが「正しい」場合にのみうまくいくことが証明できるということです。そして、あなたのモデルは決して「正しい」ものではありえません。 有名な統計学者[Goerge Box]の言葉を引用すると、***「すべてのモデルは間違っているが、いくつかは有用」*** です。ですから、確率モデル、特に高次元空間やテキストのような組み合わせ空間でのモデルは、すべて近似モデルである、ということになります。 それらのモデルはある意味ではすべて間違っていて、正規化しようとすると、より間違ったものになってしまいます。 ですから、正規化しない方がいいと言えます。

<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig3.png" height="75%" width="75%"/><br>
<b>図2</b>: xとyの依存関係を捉えたエネルギー関数を可視化したもの
</center>

<!-- This is an energy function that's meant to capture the dependency between *x* and *y*.  It's like a mountain range if you will.  The valleys are where the black dots are (these are data points), and there are mountains all around.  Now, if you train a probabilistic model with this, imagine that the points are actually on an infinitely thin manifold.  So the data distribution for the black dots is actually just a line, and there are three of them.  They don't actually have any width.  So if you train a probabilistic model on this, your density model should tell you when you are on this manifold.  On this manifold, the density is infinite, and just $\varepsilon$ outside of it should be zero.  That would be the correct model of this distribution.  Not only should the density be infinite, but the integral over [x and y] should be 1.  This is very difficult to implement on the computer!  Not only that, but it's also basically impossible.  Let's say you want to compute this function through some sort of neural net -- your neural net will have to have infinite weights, and they would need to be calibrated in such a way that the integral of the output of that system over the entire domain is 1.  That's basically impossible.  The accurate, correct probabilistic model for this particular data example is impossible.  This is what maximum likelihood will want you to produce, and there's no computer in the world that can compute this.  So in fact, it's not even interesting.  Imagine that you had the perfect density model for this example, which is a thin plate in that (x, y) space -- you couldn't do inference!  If I give you a value of x, and ask you "what's the best value of y?"  You wouldn't be able to find it because all values of y except a set of zero-probability have a probability of zero, and there are just a few values that are possible.  For these values of x for example: -->

これは、*x*と*y*の間の依存関係を捉えるためのエネルギー関数です。 いわば山脈のようなものです。 谷は黒い点（これらはデータ点です）があるところで、周囲には山があります。 さて、これを使って確率モデルを学習する場合、点が実際に無限に薄い多様体上にあると想像してみてください。 つまり黒い点のデータ分布は、実際にはただの線であり、その中の3つの点がある状況です。 実際には線には幅はありません。 ですから、もしあなたがこの上で確率モデルを訓練した場合、密度モデルは、この多様体上にいるときに多様体上にいることを教えてくれるはずです。 この多様体上では、密度は無限大で、その外側に$\varepsilon$離れただけで密度はゼロになるはずです。 それがこの分布の正しいモデルでしょう。 密度が無限大であるだけでなく、[xとy]の上での積分が1でなければなりません。 これをコンピュータ上で実装するのは非常に難しいです。 それだけでなく、基本的に不可能です。例えば、ある種のニューラルネットを使ってこの関数を計算したいとしましょう。そうすると、そのニューラルネットは無限の重みを持たなければならず、全領域にわたるシステムの出力の積分が1になるように調整されなければなりません。 これは基本的に不可能です。 この特定のデータの例を表現するための、正確で正しい確率モデルは不可能です。 これが最尤法が求めるものであり、これを計算できるコンピュータは世界中に存在しません。 ですから、実際には、面白くもなんともありません。 この例についての完全な密度モデルを持っていたと想像してみてください。それはその(x, y)空間内の薄い板であり、推論することはできません。もし私がxの値を与えて、「yの最良の値は何ですか？」と聞いても、それはわからないでしょう。なぜなら，ゼロ確率の集合以外のyの値はすべてゼロの確率を持っていて、とりうる可能な値はわずかしかないからです。例えば、これらのxの値について、

<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig4.png" height="75%" width="75%"/><br>
<b>図3</b>: 陰関数としてEBMの複数の予測の例
</center>

<!-- There are 3 values of y that are possible, and they are infinitely narrow.  So you wouldn't be able to find them.  There's no inference algorithm that will allow you to find them.  The only way you can find them is if you make your contrast function smooth and differentiable, and then you can start from any point and by gradient descent you can find a good value for y for any value of x.  But this is not going to be a good probabilistic model of the distribution if the distribution is of the type I mentioned.  So here is a case where insisting to have a good probabilistic model is actually bad.  Maximum likelihood sucks [in this case]! -->
可能なyの値は3つありますが、それらは無限に狭くなっています。 だから、それらを見つけることはできないでしょう。 それらを見つけることができる推論アルゴリズムはありません。 唯一見つけられる方法は、コントラスト関数を滑らかで微分可能なものにして、任意の点から開始し、勾配降下法によって、どのようなxの値に対してもyの良い値を見つけることができる場合です。 ここでは、良い確率モデルを持つことを要求することが実際には悪い結果を招く場合を示しています。 最尤は最悪です［この場合］!

<!-- So if you are a true Bayesian, you say "oh but you can correct this by having a strong prior where the prior says your density function has to be smooth".  You could think of this as a prior.  But, everything you do in Bayesian terms -- take the logarithm thereof, forget about normalization -- you get energy-based models.  Energy-based models that have a regulariser, which is additive to your energy function, are completely equivalent to Bayesian models where the likelihood is exponential of the energy, and now you get $\exp(\text{energy}) \exp(\text{regulariser})$, and so it's equal to $\exp(\text{energy} + \text{regulariser})$.  And if you remove the exponential you have an energy-based model with an additive regulariser. -->
もしあなたが真のベイジアンであれば、「ああ、でも、密度関数が滑らかでなければならないという強い事前知識を導入することでこれを修正するできますよね」と言うでしょう。 これは事前知識の一つと考えることができます。 しかし，ベイズの言葉で行うことはすべて、（対数を取ったり、正規化をしないことで）、エネルギーベースのモデルで行うことができます。 エネルギー関数に足される形で導入される、正則化項を持つエネルギーベースのモデルは、尤度がエネルギーの指数関数であるベイジアンモデルと完全に等価となり、次の式を得ることができます$\exp(\text{energy}) \exp(\text{regulariser})$。そしてこれは次の式と等価です$\exp(\text{energy} + \text{regulariser})$。指数を取り除けば和の形の正則化項つきのエネルギーベースモデルを得ることができます。

<!-- So there is a correspondence between probabilistic and Bayesian methods there, but insisting that you do maximum likelihood is sometimes bad for you, particularly in high-dimensional spaces or combinatorial spaces where your probabilistic model is very wrong. It's not very wrong in discrete distributions (it's okay) but in continuous cases, it can be really wrong.  And all the models are wrong. -->
そこには確率論的手法とベイズ的手法の対応関係がありますが、最尤法を行うということは、特に確率モデルが非常に間違っているような高次元空間や組み合わせ空間では、悪手であることもあります。離散分布ではあまり間違ってはいませんが（大丈夫です）、連続的な場合には実際に間違っていることがあります。 そして、すべてのモデルが間違っているのです。
