---
lang-ref: ch.06-3
title: Architecture of RNN and LSTM Model
lecturer: Alfredo Canziani
authors: Zhengyuan Ding, Biao Huang, Lin Jiang, Nhung Le
date: 3 Mar 2020
lang: ja
translation-date: 6 Dec 2020
translator: Shiro Takagi
---


<!-- ## [Overview](https://www.youtube.com/watch?v=8cAffg2jaT0&t=21s) -->
## [概要](https://www.youtube.com/watch?v=8cAffg2jaT0&t=21s)

<!-- RNN is one type of architecture that we can use to deal with sequences of data. What is a sequence? From the CNN lesson, we learned that a signal can be either 1D, 2D or 3D depending on the domain. The domain is defined by what you are mapping from and what you are mapping to. Handling sequential data is basically dealing with 1D data since the domain is the temporal axis. Nevertheless, you can also use RNN to deal with 2D data, where you have two directions. -->
RNNは、シーケンスデータを扱うために使用できるアーキテクチャの1つのタイプです。シーケンスとは何でしょうか？CNNのレッスンでは、信号はドメインによって1次元、2次元、3次元のいずれかになることを学びました。ドメインは、何から何にマッピングしているのか、によって定義されます。シーケンシャルデータを扱うのは、ドメインが時間軸なので、基本的には1次元データを扱うことになります。とはいえ、2つの方向がある2次元データを扱う場合もRNNを使うこともできます。


<!-- ### Vanilla vs. Recurrent NN -->
### 通常のニューラルネットワーク vs. リカレントニューラルネットワーク
<!-- 
Figure 1 is a vanilla neural network diagram with three layers. "Vanilla" is an American term meaning plain. The pink bubble is the input vector x, in the center is the hidden layer in green, and the final blue layer is the output. Using an example from digital electronics on the right, this is like a combinational logic, where the current output only depends on the current input. -->
図1は3層のバニラニューラルネットワークの図です。「バニラ」とは、アメリカの言葉で無地を意味します（つまりバニラニューラルネットワークは、通常のニューラルネットワークのことを指します）。ピンクの点が入力ベクトル$x$、中央の緑が隠れ層、最後の青の層が出力です。右のデジタル回路の例は、現在の出力が現在の入力にしか依存しない組合せ論理のようなものです。

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-3/vanilla.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 1:</b> Vanilla Architecture
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/vanilla.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図1:</b> バニラアーキテクチャ
</center>

<!-- In contrast to a vanilla neural network, in recurrent neural networks the current output depends not only on the current input but also on the state of the system, shown in Figure 2. This is like a sequential logic in digital electronics, where the output also depends on a "flip-flop" (a basic memory unit in digital electronics). Therefore the main difference here is that the output of a vanilla neural network only depends on the current input, while the one of RNN depends also on the state of the system. -->
バニラニューラルネットワークとは異なり、リカレントニューラルネットワークでは、図2に示すように、電流出力は現在の入力だけでなく、システムの状態にも依存します。これは、デジタル回路の順序論理のようなもので、出力は「フリップフロップ」（デジタル回路の基本的な記憶装置）にも依存します。したがって、ここでの主な違いは、バニラニューラルネットワークの出力が現在の入力にのみ依存するのに対し、RNNの出力はシステムの状態にも依存するということです。

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 2:</b> RNN Architecture
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/basic_neural_net.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 3:</b> Basic NN Architecture
</center> -->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図2:</b> RNNのアーキテクチャ
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/basic_neural_net.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図3:</b> 基本的なNNのアーキテクチャ
</center>

<!-- Yann's diagram adds these shapes between neurons to represent the mapping between one tensor and another(one vector to another). For example, in Figure 3, the input vector x will map through this additional item to the hidden representations h. This item is actually an affine transformation i.e. rotation plus distortion. Then through another transformation, we get from the hidden layer to the final output. Similarly, in the RNN diagram, you can have the same additional items between neurons. -->
Yannの図は、あるテンソルと別のテンソル(あるベクトルから別のベクトル)との間のマッピングを表すために、ニューロン間にこれらの形状を追加します。例えば、図3では、入力ベクトルxは、この追加項目を介して隠れ表現hにマッピングされます。その後、別の変換を経て、隠れ層から最終的な出力に到達します。同様に、RNNの図では、ニューロン間で同じ追加項目を持つことができます。


<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-3/yann_rnn.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 4:</b> Yann's RNN Architecture
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/yann_rnn.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図4:</b> Yannの RNNのアーキテクチャ
</center>


<!-- ### Four types of RNN Architectures and Examples -->
### ４種類のRNNのアーキテクチャとその例

<!-- The first case is vector to sequence. The input is one bubble and then there will be evolutions of the internal state of the system annotated as these green bubbles. As the state of the system evolves, at every time step there will be one specific output. -->
最初の例はベクトルからシーケンスへの変換です。入力は1つの点であり、緑色の点としてアノテーションされているのはシステムの内部状態の状態更新です。システムの状態が更新されると、各時間ステップで1つの特定の出力が発生します。

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-3/vec_seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 5:</b> Vec to Seq
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/vec_seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図5:</b> Vec to Seq
</center>

<!-- An example of this type of architecture is to have the input as one image while the output will be a sequence of words representing the English descriptions of the input image. To explain using Figure 6, each blue bubble here can be an index in a dictionary of English words. For instance, if the output is the sentence "This is a yellow school bus". You first get the index of the word "This" and then get the index of the word "is" and so on. Some of the results of this network are shown below. For example, in the first column the description regarding the last picture is "A herd of elephants walking across a dry grass field.", which is very well refined. Then in the second column, the first image outputs "Two dogs play in the grass.", while it's actually three dogs. In the last column are the more wrong examples such as "A yellow school bus parked in a parking lot." In general, these results show that this network can fail quite drastically and perform well sometimes. This is the case that is from one input vector, which is the representation of an image, to a sequence of symbols, which are for example characters or words making up the English sentences. This kind of architecture is called an autoregressive network. An autoregressive network is a network which gives an output given that you feed as input the previous output. -->
このタイプのアーキテクチャの例としては、入力が１つの画像であり、出力が入力画像の英語の記述を表す単語のシーケンスとなるようなものが挙げられます。図6を用いて説明すると、ここでは、青い点それぞれが英単語の辞書のインデックスとなっています。例えば、出力が「This is a yellow school bus」という文であるとしましょう。まず、「This」という単語のインデックスを取得し、次に 「is」という単語のインデックスを取得します。このネットワークの結果の一部を以下に示します。例えば、1列目の最後の画像に関する記述は、「A herd of elephants walking across a dry grass field.」となっており、非常に洗練されています。そして2番目の列では、最初の画像は 「Two dogs play in the grass.」と出力されていますが、実際には3匹の犬です。最後の列は、「A yellow school bus parked in a parking lot.」のように、より間違った例です。一般的に、これらの結果は、このネットワークがかなり大幅に失敗することもあれば、うまくいくこともあることを示しています。これは、画像の表現である1つの入力ベクトルから、例えば英語の文章を構成する文字や単語である記号の列へと変化する場合です。このようなアーキテクチャを自己回帰型のネットワークと呼びます。自己回帰型のネットワークとは、前の出力を入力として与えられた下で、出力をするネットワークのことです。

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-3/image_to_text_vec2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 6:</b> vec2seq Example: Image to Text
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/image_to_text_vec2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図6:</b> vec2seqの例: 画像から文章へ
</center>

<!-- The second type is sequence to a final vector. This network keeps feeding a sequence of symbols and only at the end gives a final output. An application of this can be using the network to interpret Python. For example, the input are these lines of Python program. -->
2番目のタイプは、シーケンスから最終的にベクトルを返すものです。このネットワークはシンボルのシーケンスを与え続け、最後にのみ最終的な出力を与えます。これの応用として、Pythonを解釈するためにネットワークを使用することができます。例えば、入力はPythonプログラムの以下の行です。

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2vec.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 7:</b> Seq to Vec
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/second_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 8:</b> Input lines of Python Codes
</center>

Then the network will be able to output the correct solution of this program. Another more complicated program like this:
<center>
<img src="{{site.baseurl}}/images/week06/06-3/second_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 9:</b> Input lines of Python Codes in a more Completed Case
</center> -->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2vec.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図 7:</b> Seq to Vec
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/second_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図 8:</b> Pythonコードの入力列
</center>

<!-- Then the network will be able to output the correct solution of this program. Another more complicated program like this: -->
そうすると、ネットワークはこのプログラムの正解を出力することができるようになります。もう一つ、このようなもっと複雑なプログラムがあります。
<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-3/second_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 9:</b> Input lines of Python Codes in a more Completed Case
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/second_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図9:</b> より複雑な場合のPython Codesの入力列
</center>

<!-- Then the output should be 12184. These two examples display that you can train a neural network to do this kind of operation. We just need to feed a sequence of symbols and enforce the final output to be a specific value.

The third is sequence to vector to sequence, shown in Figure 10. This architecture used to be the standard way of performing language translation. You start with a sequence of symbols here shown in pink. Then everything gets condensed into this final h, which represents a concept. For instance, we can have a sentence as input and squeeze it temporarily into a vector, which is representing the meaning and message that to send across. Then after getting this meaning in whatever representation, the network unrolls it back into a different language. For example "Today I'm very happy" in a sequence of words in English can be translated into Italian or Chinese. In general, the network gets some kind of encoding as inputs and turns them into a compressed representation. Finally, it performs the decoding given the same compressed version. In recent times we have seen networks like Transformers, which we will cover in the next lesson, outperform this method at language translation tasks. This type of architecture used to be the state of the art about two years ago (2018). -->

すると、出力は12184になるはずです。これら2つの例は、この種の操作を行うためにニューラルネットワークを訓練できることを示しています。記号のシーケンスを与えて、最終的な出力が特定の値になるように強制するだけです。

3つ目は、図10に示すように、シーケンスからベクトルへ変換し、そこからまたシーケンスへ変換を行うものです。このアーキテクチャは、かつて言語翻訳を実行するための標準的な方法でした。ここでは、ピンク色で示されている一連のシンボルから始まります。そして、すべてのものがこの最終的な$h$に凝縮されます。これは概念を表しているといえます。例えば、入力として文章を持っていて、それを一時的にベクトルに圧縮することができます。そして、どのような表現であれこの意味を獲得した後、ネットワークはそれを別の言語に展開します。例えば、英語の単語列の中の「Today I'm very happy」は、イタリア語や中国語に翻訳することができます。一般的に、ネットワークは入力として何らかのエンコーディングを取得し、それを圧縮表現に変換します。最後に、この圧縮された表現を与えられた下でデコーディングを行います。最近では、次の講義で紹介するTransformerのようなネットワークが、言語翻訳のタスクでこの方法を上回るパフォーマンスを発揮しています。このタイプのアーキテクチャは、約2年前(2018年)に最先端として使われていました。

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2vec2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 10:</b> Seq to Vec to Seq
</center>

If you do a PCA over the latent space, you will have the words grouped by semantics like shown in this graph.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 11:</b> Words Grouped by Semantics after PCA
</center>

If we zoom in, we will see that the in the same location there are all the months, like January and November.
<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 12:</b> Zooming in Word Groups
</center>

If you focus on a different region, you get phrases like "a few days ago " "the next few months" etc.
<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 13:</b> Word Groups in another Region
</center> -->


<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2vec2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図10:</b> Seq to Vec to Seq
</center>

潜在空間に対してPCAを行うと、このグラフのように意味でグループわけされた単語が得られます。

<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図11:</b> PCAの後に意味でグループわけされた単語
</center>

詳しく見てみると、同じ場所に1月と11月のようにすべての月があることがわかります。
<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図12:</b> 単語グループを拡大する
</center>

別の場所に焦点を当てると、「数日前」「数ヶ月後」などのフレーズが出てきます。
<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図13:</b> 他の場所の単語のグループ
</center>

<!-- From these examples, we see that different locations will have some specific common meanings.

Figure 14 showcases how how by training this kind of network will pick up on some semantics features. For exmaple in this case you can see there is a vector connecting man to woman and another between king and queen, which means woman minus man is going to be equal to queen minus king. You will get the same distance in this embeddings space applied to cases like male-female. Another example will be walking to walked and swimming to swam. You can always apply this kind of specific linear transofmation going from one word to another or from country to capital. -->

これらの例から、異なる場所が特定の共通の意味を持っていることがわかります。

図14は、この種のネットワークを学習することで、どのように意味論的な特徴を拾っていくかを示しています。この例では、男性と女性を結ぶベクトルと、王様と王妃を結ぶベクトルがあることがわかります。この埋め込み空間では、男性と女性のようなケースに適用しても、同じ距離が得られます。もう一つの例は、「歩いている」が「歩いた」になり、「泳いでいる」が「泳いだ」になります。常にこの種の特定の線形変換を、ある単語から別の単語へ、または国から首都へ行うことができます。

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-3/fourth.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 14:</b> Semantics Features Picked during Training
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/fourth.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図4:</b> 学習中に選ばれた意味的な特徴表現
</center>

<!-- The fourth and final case is sequence to sequence. In this network, as you start feeding in input the network starts generating outputs. An example of this type of architecture is T9, if you remember using a Nokia phone, you would get text suggestions as you were typing. Another example is speech to captions. One cool example is this RNN-writer. When you start typing "the rings of Saturn glittered while", it suggests the following "two men looked at each other". This network was trained on some sci-fi novels so that you can just type something and let it make suggestions to help you write a book. One more example is shown in Figure 16. You input the top prompt and then this network will try to complete the rest. -->
最後となる4番目のケースは、シーケンスからシーケンスへの変換です。このネットワークでは、入力を受け取ると、出力を生成し始めます。このタイプのアーキテクチャの例としては、T9が挙げられます。他の例としては、キャプションへの音声変換があります。良い例としては、このRNN-writerがあります。「the rings of Saturn glittered while」と入力し始めると、次のような「two men looked at each other」を提案してくれます。このネットワークはいくつかのSF小説で訓練されたもので、何かを入力するだけで、本を書くのに役立つ提案をしてくれるようになっています。もう一つの例を図16に示します。一番上のプロンプトを入力すると、このネットワークは残りの部分を完成させようとします。


<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 15:</b> Seq to Seq
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2seq_model_completion.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 16:</b> Text Auto-Completion Model of Seq to Seq Model
</center> -->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図5:</b> Seq to Seq
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2seq_model_completion.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図16:</b> Seq to Seq による文書入力自動補完モデル
</center>


## [Back Propagation through time](https://www.youtube.com/watch?v=8cAffg2jaT0&t=855s)


<!-- ### Model architecture -->
### モデルアーキテクチャ

<!-- In order to train an RNN, backpropagation through time (BPTT) must be used. The model architecture of RNN is given in the figure below. The left design uses loop representation while the right figure unfolds the loop into a row over time. -->
RNNを学習するためには、backpropagation through time(BPTT)を用いる必要があります。RNNのモデルアーキテクチャを下図に示します。左の図はループ表現を用いたもので、右の図はループを時間の経過とともに1行に展開したものです。

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-3/bptt.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 17:</b> Back Propagation through time
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/bptt.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図17:</b> Back Propagation through time
</center>

<!-- Hidden representations are stated as -->
隠れ表現は次のように表現されます

$$
\begin{aligned}
\begin{cases}
h[t]&= g(W_{h}\begin{bmatrix}
x[t] \\
h[t-1]
\end{bmatrix}
+b_h)  \\
h[0]&\dot=\ \boldsymbol{0},\ W_h\dot=\left[ W_{hx} W_{hh}\right] \\
\hat{y}[t]&= g(W_yh[t]+b_y)
\end{cases}
\end{aligned}
$$

<!-- The first equation indicates a non-linear function applied on a rotation of a stack version of input where the previous configuration of the hidden layer is appended. At the beginning, $h[0]$ is set 0. To simplify the equation, $W_h$ can be written as two separate matrices, $\left[ W_{hx}\ W_{hh}\right]$, thus sometimes the transformation can be stated as -->
最初の式は、スタックされた入力の回転に非線形関数を適用したもので、隠れ層の前の設定が付加されています。式を簡単にするために、$W_h$は、$\left[ W_{hx}\ W_{hh}\right]$の2つの行列として書くことができるので、以下のように書くことができます。

$$
W_{hx}\cdot x[t]+W_{hh}\cdot h[t-1]
$$

<!-- which corresponds to the stack representation of the input. -->
これは入力のスタックされた表現に一致します。

<!-- $y[t]$ is calculated at the final rotation and then we can use the chain rule to backpropagate the error to the previous time step. -->
$y[t]$は最終的な回転操作のところで計算され、その後、連鎖律を使用して、誤差を前回の時間ステップに逆伝播することができます。

<!-- ### Batch-Ification in Language Modeling -->
### 言語モデリングをバッチ化する

<!-- When dealing with a sequence of symbols, we can batchify the text into different sizes. For example, when dealing with sequences shown in the following figure, batch-ification can be applied first, where the time domain is preserved vertically. In this case, the batch size is set to 4. -->
記号のシーケンスを扱う場合、テキストを異なるサイズにバッチ化して処理することができます。例えば、次の図のようなシーケンスを扱う場合、時間領域が垂直方向に保存されているところでは、最初の部分をバッチ化することができます。この場合、バッチサイズは4に設定されます。

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-3/batchify_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 18:</b> Batch-Ification
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/batchify_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図18:</b> バッチ化
</center>

<!-- If BPTT period $T$ is set to 3, the first input $x[1:T]$ and output $y[1:T]$ for RNN is determined as -->
BPTT期間$T$を3とすると、RNNの最初の入力$x[1:T]$と出力$y[1:T]$は次のように決定されます。

$$
\begin{aligned}
x[1:T] &= \begin{bmatrix}
a & g & m & s \\
b & h & n & t \\
c & i & o & u \\
\end{bmatrix} \\
y[1:T] &= \begin{bmatrix}
b & h & n & t \\
c & i & o & u \\
d & j & p & v
\end{bmatrix}
\end{aligned}
$$

<!-- When performing RNN on the first batch, firstly, we feed $x[1] = [a\ g\ m\ s]$ into RNN and force the output to be $y[1] = [b\ h\ n\ t]$. The hidden representation $h[1]$ will be sent forward into next time step to help the RNN predict $y[2]$ from $x[2]$. After sending $h[T-1]$ to the final set of $x[T]$ and $y[T]$, we cut gradient propagation process for both $h[T]$ and $h[0]$ so that gradients will not propagate infinitely(.detach() in Pytorch). The whole process is shown in figure below. -->
最初のバッチでRNNを用いる場合、まず、$x[1] = [a\ g\ m\ s]$をRNNに与え、$y[1] = [b\ h\ n\ t]$となるように出力を強制します。隠れ表現$h[1]$を次の時間ステップに送り、RNNが$x[2]$から$y[2]$を予測するのを助けます。$x[T]$と$y[T]$の最終集合に$h[T-1]$を送り込んだ後、$h[T]$と$h[0]$の両方の勾配を伝搬する処理をカットして、勾配が無限に伝搬しないようにします(.detach() in Pytorch)。全体の処理を下図に示します。

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-3/batchify_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 19:</b> Batch-Ification
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/batchify_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図19:</b> バッチ化
</center>


<!-- ## Vanishing and Exploding Gradient -->
## 勾配消失と勾配爆発

<!-- ### Problem -->
### 問題

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 20:</b> Vanishing Problem
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図20:</b> 勾配消失
</center>

<!-- The figure above is a typical RNN architecture. In order to perform rotation over previous steps in RNN, we use matrices, which can be regarded as horizontal arrows in the model above. Since the matrices can change the size of outputs, if the determinant we select is larger than 1, the gradient will inflate over time and cause gradient explosion. Relatively speaking, if the eigenvalue we select is small across 0, the propagation process will shrink gradients and leads to the gradient vanishing.

In typical RNNs, gradients will be propagated through all the possible arrows, which provides the gradients a large chance to vanish or explode. For example, the gradient at time 1 is large, which is indicated by the bright color. When it goes through one rotation, the gradient shrinks a lot and at time 3, it gets killed. -->

上の図は典型的なRNNのアーキテクチャです。RNNで前のステップの回転を行うために、上のモデルでは横向きの矢印と見なすことができる行列を使っています。行列は出力の大きさを変えることができるので、選択する行列式が1よりも大きいと、時間の経過とともに勾配が膨らみ、勾配爆発を起こしてしまいます。対照的に、選択する固有値が0を挟んで小さい場合には、伝播過程は勾配を収縮させ、勾配消失につながります。

典型的なRNNでは、勾配はすべての可能な経路を通って伝搬されることで、勾配が消失または爆発する可能性を増加させます。例えば、時刻1の勾配は大きく、明るい色で示されています。それが1回転すると、勾配は大きく縮小し、時刻3では消滅してしまいます。

<!-- ### Solution -->
### 解

<!-- An ideal to prevent gradients from exploding or vanishing is to skip connections. To fulfill this, multiply networks can be used. -->
勾配爆発や消失を防ぐための理想的な方法は、接続をスキップすることです。これを実現するために、乗算ネットワークを使用することができます。

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 21:</b> Skip Connection
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図21:</b> スキップ接続
</center>

<!-- In the case above, we split the original network into 4 networks. Take the first network for instance. It takes in a value from input at time 1 and sends the output to the first intermediate state in the hidden layer. The state has 3 other networks where the $\circ$s allows the gradients to pass while the $-$s blocks propagation. Such a technique is called gated recurrent network.

LSTM is one prevalent gated RNN and is introduced in detail in the following sections. -->

上記の場合、元のネットワークを4つのネットワークに分割します。最初のネットワークを例に考えてみましょう。このネットワークは、時刻１に入力から値を取り込んで、その出力を隠れ層の最初の中間状態に送ります。この状態には、他に3つのネットワークがあります。ここでは、$-$が伝搬を阻止し、$\circ$が勾配を通過させます。このような手法をゲート付きリカレントネットワークと呼びます。

LSTMはゲート付きリカレントネットワークの一つですが、以下の節で詳しく紹介します。


## [Long Short-Term Memory](https://www.youtube.com/watch?v=8cAffg2jaT0&t=1838s)


<!-- ### Model Architecture -->
### モデルアーキテクチャ

<!-- Below are equations expressing an LSTM. The input gate is highlighted by yellow boxes, which will be an affine transformation. This input transformation will be multiplying $c[t]$, which is our candidate gate. -->
以下はLSTMを表す式です。入力ゲートは黄色のボックスで強調されていますが、これはアフィン変換になります。この入力変換は $c[t]$ を乗算したもので、これが候補ゲートとなります。

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 22:</b> LSTM Architecture
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図22:</b> LSTMのアーキテクチャ
</center>

<!-- Don’t forget gate is multiplying the previous value of cell memory $c[t-1]$. Total cell value $c[t]$ is don’t forget gate plus input gate. Final hidden representation is element-wise multiplication between output gate $o[t]$ and hyperbolic tangent version of the cell $c[t]$, such that things are bounded. Finally, candidate gate $\tilde{c}[t]$ is simply a recurrent net. So we have a $o[t]$ to modulate the output, a $f[t]$ to modulate the don’t forget gate, and a $i[t]$ to modulate the input gate. All these interactions between memory and gates are multiplicative interactions. $i[t]$, $f[t]$ and $o[t]$ are all sigmoids, going from zero to one. Hence, when multiplying by zero, you have a closed gate. When multiplying by one, you have an open gate.

How do we turn off the output? Let’s say we have a purple internal representation $th$ and put a zero in the output gate. Then the output will be zero multiplied by something, and we get a zero. If we put a one in the output gate, we will get the same value as the purple representation. -->

忘却ゲートは、セルメモリの前の値$c[t-1]$に乗算されます。セルの合計値 $c[t]$ は、忘却ゲート + 入力ゲートです。最終的な隠れ表現は、出力ゲート$o[t]$とセルのtanhである$c[t]$との間の要素毎の掛け算です。最後に、候補ゲート $\tilde{c}[t]$ は、単純にリカレントネットです。つまり、出力を変調するための $o[t]$、忘れないようにするための $f[t]$、入力ゲートを変調するための $i[t]$があります。これらのメモリとゲートの間の相互作用は、すべて乗算的な相互作用です。$i[t]$, $f[t]$, $o[t]$は、すべてシグモイドですので、0から1の範囲におさまります。したがって、ゼロをかけると、閉じたゲートになりますし、1をかけると開いたゲートになります。

出力をオフにするにはどうすれば良いでしょうか？紫色の内部表現 $th$ を持ち、出力ゲートにゼロを入れたとします。そうすると、出力は何かかけるゼロになります。出力ゲートに1を入れると、紫色の内部表現と同じ値が得られます。

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 23:</b> LSTM Architecture - Output On
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 24:</b> LSTM Architecture - Output Off
</center> -->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図23:</b> LSTMのアーキテクチャ - 出力オン
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図24:</b> LSTMのアーキテクチャ - 出力オフ
</center>
<!-- 
Similarly, we can control the memory. For example, we can reset it by having $f[t]$ and $i[t]$ to be zeros. After multiplication and summation, we have a zero inside the memory. Otherwise, we can keep the memory, by still zeroing out the internal representation $th$ but keep a one in $f[t]$. Hence, the sum gets $c[t-1]$ and keeps sending it out. Finally, we can write such that we can get a one in the input gate, the multiplication gets purple, then set a zero in the don’t forget gate so it actually forget. -->

同様に、メモリを制御することもできます。例えば、$f[t]$と$i[t]$をゼロにすることで、メモリをリセットすることができます。乗算と和の後、メモリの中にゼロが入ります。そうでなければ、内部表現 $th$ をゼロにしたまま、$f[t]$ の中に 1 を入れておくことで、メモリを保持することができます。したがって、和は $c[t-1]$ を得て、それを送り出し続けます。最後に、入力ゲートで1を取得し、乗算が紫色になり、忘却ゲートで0を設定して、実際に忘れてしまうように書くことができます。
<!-- TODO -->

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-3/memory_cell_vis.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 25:</b> Visualization of the Memory Cell
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_4.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 26:</b> LSTM Architecture - Reset Memory
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_keep_memory.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 27:</b> LSTM Architecture - Keep Memory
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_write_memory.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 28:</b> LSTM Architecture - Write Memory
</center> -->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/memory_cell_vis.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図25:</b> メモリセルの可視化
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_4.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図26:</b> LSTMのアーキテクチャ - メモリのリセット
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_keep_memory.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図27:</b> LSTMのアーキテクチャ - メモリの保持
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_write_memory.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図28:</b> LSTMのアーキテクチャ - メモリの書き込み
</center>



<!-- ## Notebook Examples -->
## Notebookの例

<!-- ### Sequence Classification -->
### シーケンスの分類
<!-- 
The goal is to classify sequences. Elements and targets are represented locally (input vectors with only one non-zero bit). The sequence **b**egins with an `B`, **e**nds with a `E` (the “trigger symbol”), and otherwise consists of randomly chosen symbols from the set `{a, b, c, d}` except for two elements at positions $t_1$ and $t_2$ that are either `X` or `Y`. For the `DifficultyLevel.HARD` case, the sequence length is randomly chosen between 100 and 110, $t_1$ is randomly chosen between 10 and 20, and $t_2$ is randomly chosen between 50 and 60. There are 4 sequence classes `Q`, `R`, `S`, and `U`, which depend on the temporal order of `X` and `Y`. The rules are: `X, X -> Q`; `X, Y -> R`; `Y, X -> S`; `Y, Y -> U`.

1). Dataset Exploration

The return type from a data generator is a tuple with length 2. The first item in the tuple is the batch of sequences with shape $(32, 9, 8)$. This is the data going to be fed into the network. There are eight different symbols in each row (`X`, `Y`, `a`, `b`, `c`, `d`, `B`, `E`). Each row is a one-hot vector. A sequence of rows represents a sequence of symbols. The first all-zero row is padding. We use padding when the length of the sequence is shorter than the maximum length in the batch.  The second item in the tuple is the corresponding batch of class labels with shape $(32, 4)$, since we have 4 classes (`Q`, `R`, `S`, and `U`). The first sequence is: `BbXcXcbE`. Then its decoded class label is $[1, 0, 0, 0]$, corresponding to `Q`. -->

目的は，シーケンスを分類することです。要素とターゲットは、局所的に表現されます（0 以外のビットが 1 つだけの入力ベクトル）。シーケンスは、は`B`で始まり，`E`（「トリガーシンボル」）で終わります。それ以外の場合は、$t_1$と$t_2$の１の要素を除いた、集合 `{a, b, c, d}` の中からランダムに選ばれたシンボルで構成されます。`DifficultyLevel.HARD` の場合、配列の長さは100〜110の間でランダムに選ばれ、$t_1$ は10〜20の間でランダムに選ばれ、$t_2$ は50〜60の間でランダムに選ばれます。配列には、`Q`, `R`, `S`, `U` の4つのクラスがあり、これは`X`, `Y` の時間的順序に依存します。次のようなルールです。：`X, X -> Q`; `X, Y -> R`; `Y, X -> S`; `Y, Y -> U`

1). データセット探索

データ生成器からの戻り値の型は、長さ2のタプルです。 タプルの最初の項目は、$(32, 9, 8)$の形をしたシーケンスのバッチです。これがネットワークに投入されるデータです。各行には8つの異なるシンボル(`X`, `Y`, `a`, `b`, `c`, `d`, `B`, `E`)があります。各行はone-hotベクトルです。行のシーケンスはシンボルのシーケンスを表します。最初の全ての要素がゼロの行はパディングです。シーケンスの長さがバッチの最大長よりも短い場合にパディングを使用します。 タプルの2番目の項目は、4つのクラス（`Q`, `R`, `S`, `U`）があるので、シェイプが$(32, 4)$の対応するクラスラベルのバッチです。最初のシーケンスは `BbXcXcbE` です。すると、そのデコードされたクラスラベルは $[1, 0, 0, 0]$ であり、`Q`に対応します。


<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-3/dataset.png" style="zoom: 15%; background-color:#DCDCDC;"/><br>
<b>Figure 29:</b> Input Vector Example
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/dataset.png" style="zoom: 15%; background-color:#DCDCDC;"/><br>
<b>図29:</b> 入力ベクトルの例
</center>


<!-- 2). Defining the Model and Training

Let’s create a simple recurrent network, an LSTM, and train for 10 epochs. In the training loop, we should always look for five steps:

 * Perform the forward pass of the model
 * Compute the loss
 * Zero the gradient cache
 * Backpropagate to compute the partial derivative of loss with regard to parameters
 * Step in the opposite direction of the gradient -->

 2). モデルの定義と訓練

単純なリカレントネットワーク、LSTMを作成し、10エポック訓練してみましょう。訓練のループでは、常に5つのステップを行います。

 * モデルの順伝播を実行する
 * 損失を計算する
 * 勾配のキャッシュをゼロにする
 * 誤差逆伝播によってパラメータに関しての損失の偏微分を計算する
 * 勾配の反対方向にステップを踏む

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-3/train_test_easy.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 30:</b> Simple RNN vs LSTM - 10 Epochs
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/train_test_easy.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図30:</b> 単純なRNN vs LSTM - 10エポック
</center>

<!-- With an easy level of difficulty, RNN gets 50% accuracy while LSTM gets 100% after 10 epochs. But LSTM has four times more weights than RNN and has two hidden layers, so it is not a fair comparison. After 100 epochs, RNN also gets 100% accuracy, taking longer to train than the LSTM. -->
10エポック後に、簡単なタスクでは、RNNは50%の精度を得るのに対し、LSTMは100%の精度を得ることができます。しかし、LSTMはRNNの4倍の重みを持っており、2つの隠れ層を持っているので、公平な比較ではありません。100エポック後のRNNの精度も100%となりますが、LSTMよりも学習に時間がかかります。

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-3/train_test_hard.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 31:</b> Simple RNN vs LSTM - 100 Epochs
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/train_test_hard.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図31:</b> 単純なRNN vs LSTM - 100エポック
</center>

<!-- If we increase the difficulty of the training part (using longer sequences), we will see the RNN fails while LSTM continues to work. -->
タスクの難易度を上げる（長いシーケンスを使う）と、LSTMが学習し続けている間にRNNが失敗することがわかります。


<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-3/hidden_state_lstm.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 32:</b> Visualization of Hidden State Value
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/hidden_state_lstm.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図32:</b> 隠れ状態の値の可視化
</center>

<!-- The above visualization is drawing the value of hidden state over time in LSTM. We will send the inputs through a hyperbolic tangent, such that if the input is below $-2.5$, it will be mapped to $-1$, and if it is above $2.5$, it will be mapped to $1$. So in this case, we can see the specific hidden layer picked on `X` (fifth row in the picture) and then it became red until we got the other `X`. So, the fifth hidden unit of the cell is triggered by observing the `X` and goes quiet after seeing the other `X`. This allows us to recognize the class of sequence. -->
上の可視化は、LSTMにおける隠れ状態の時間変化を描いたものです。入力が$-2.5$以下であれば$-1$に、$2.5$以上であれば$1$にマップされるように、tanhを通して入力を送ります。つまり、この場合、特定の隠れ層が `X` (図の5行目) にピックされて、もう1つの `X` を得るまで赤くなっていることがわかります。つまり、セルの5番目の隠れユニットは、`X`を観察すると活性化し、他の`X`を見た後は静かになるということです。これにより、シーケンスのクラスを識別することができます。


<!-- ### Signal Echoing -->
### 信号のエコー

<!-- Echoing signal n steps is an example of synchronized many-to-many task. For instance, the 1st input sequence is `"1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 ..."`, and the 1st target sequence is `"0 0 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 ..."`. In this case, the output is three steps after. So we need a short-time working memory to keep the information. Whereas in the language model, it says something that hasn't already been said. -->

信号のnステップのエコー処理は、同期化された多対多のタスクの一例です。例えば、第1入力シーケンスは `"1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 ..."` であり、第1ターゲットシーケンスは `"0 0 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 ..."` です。この場合、出力は3ステップ後になります。つまり、情報を保持するためには短時間のワーキングメモリが必要となります。一方、言語モデルでは、まだ言われていないことを言っています。

<!-- Before we send the whole sequence to the network and force the final target to be something, we need to cut the long sequence into little chunks. While feeding a new chunk, we need to keep track of the hidden state and send it as input to the internal state when adding the next new chunk. In LSTM, you can keep the memory for a long time as long as you have enough capacity. In RNN, after you reach a certain length, it starts to forget about what happened in the past. -->
シーケンス全体をネットワークに送り、最終的なターゲットを何かに強制する前に、長いシーケンスを小さなチャンクにカットする必要があります。新しいチャンクを送りながら、隠れ状態を追跡し、次の新しいチャンクを追加するときに内部状態への入力として送る必要があります。LSTMでは、十分な容量があれば長時間メモリを保持することができます。RNNでは、一定の長さに達すると過去のことを忘れ始めます。
