---
lang-ref: ch.06-2
lecturer: Yann LeCun
title: RNNs, GRUs, LSTMs, Attention, Seq2Seq, and Memory Networks
authors: Jiayao Liu, Jialing Xu, Zhengyang Bian, Christina Dominguez
date: 2 March 2020
lang: ja
translation-date: 6 Dec 2020
translator: Shiro Takagi
---


<!-- ## [Deep Learning Architectures](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=2620s) -->
## [深層学習のアーキテクチャ](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=2620s)

<!-- In deep learning, there are different modules to realize different functions. Expertise in deep learning involves designing architectures to complete particular tasks.  Similar to writing programs with algorithms to give instructions to a computer in earlier days, deep learning reduces a complex function into a graph of functional modules (possibly dynamic), the functions of which are finalized by learning.

As with what we saw with convolutional networks, network architecture is important. -->

深層学習では、異なる機能を実現するための異なるモジュールが存在します。深層学習の専門知識は、特定のタスクを行うためのアーキテクチャを設計することを含みます。 初期のコンピュータに指示を与えるためのアルゴリズムでプログラムを書くのと同様に、深層学習では複雑な機能を機能モジュールのグラフ（動的な場合もある）に還元し、その機能は学習によって最終的に決定されます。

畳み込みニューラルネットワークで見たものと同様に、ネットワークアーキテクチャが重要です。


<!-- ## Recurrent Networks

In a Convolutional Neural Network, the graph or interconnections between the modules cannot have loops. There exists at least a partial order among the modules such that the inputs are available when we compute the outputs.

As shown in Figure 1, there are loops in Recurrent Neural Networks. -->

## リカレントニューラルネットワーク(RNN)

畳み込みニューラルネットワークでは、モジュール間のグラフや相互接続にループを持つことはできません。出力を計算するときに入力が利用できるように、モジュール間には少なくとも部分的な順序が存在します。

図1に示すように、リカレントニューラルネットワークにはループがあります。

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-2/RNN_rolled.png" /><br>
Figure 1. Recurrent Neural Network with roll
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-2/RNN_rolled.png" /><br>
図1 ループを持つリカレントニューラルネットワーク
</center>
<!-- 
 - $x(t)$ : input that varies across time
 - $\text{Enc}(x(t))$: encoder that generates a representation of input
 - $h(t)$: a representation of the input
 - $w$: trainable parameters
 - $z(t-1)$: previous hidden state, which is the output of the previous time step
 - $z(t)$: current hidden state
 - $g$: function that can be a complicated neural network; one of the inputs is $z(t-1)$ which is the output of the previous time step
 - $\text{Dec}(z(t))$: decoder that generates an output -->

  - $x(t)$ : 時間を通じた入力
 - $\text{Enc}(x(t))$: 入力の表現を生成するエンコーダー
 - $h(t)$: 入力の表現
 - $w$: 学習可能パラメータ
 - $z(t-1)$: 前の時間ステップの出力に対応する、前の時間の隠れ状態
 - $z(t)$: 現在の隠れ状態
 - $g$: 複雑なニューラルネットワークになりうる関数。入力の一つは $z(t-1)$ であり、これは前の時間ステップの出力。
 - $\text{Dec}(z(t))$: 出力を生成するデコーター


<!-- ## Recurrent Networks: Unroll the loop

Unroll the loop in time. The input is a sequence $x_1, x_2, \cdots, x_T$. -->

## リカレントニューラルネットワーク：ループを展開する

ループを時間方向に展開します。入力は系列$x_1, x_2, \cdots, x_T$です。

<!-- <center>
 "
<img src="{{site.baseurl}}/images/week06/06-2/RNN_unrolled.png" /><br>
Figure 2. Recurrent Networks with unrolled loop
</center> -->
<center>
 "
<img src="{{site.baseurl}}/images/week06/06-2/RNN_unrolled.png" /><br>
図2：ループが展開されたリカレントニューラルネット
</center>

<!-- In Figure 2, the input is $x_1, x_2, x_3$.

At time t=0, the input $x(0)$ is passed to the encoder and it generates the representation $h(x(0)) = \text{Enc}(x(0))$ and then passes it to G to generate hidden state $z(0) = G(h_0, z', w)$. At $t = 0$, $z'$ in $G$ can be initialized as $0$ or randomly initialized. $z(0)$ is passed to decoder to generate an output and also to the next time step.

As there are no loops in this network, and we can implement backpropagation.

Figure 2 shows a regular network with one particular characteristic: every block shares the same weights. Three encoders, decoders and G functions have same weights respectively across different time steps.

BPTT: Backprop through time.  Unfortunately, BPTT doesn't work so well in the naive form of RNN. -->

図2において、入力は$x_1, x_2, x_3$です。

時刻$t=0$のとき、入力$x(0)$をエンコーダに渡し、表現$h(x(0)) = \text{Enc}(x(0))$を生成し、それを$G$に渡して隠れ状態$z(0) = G(h_0, z', w)$を生成します。$t = 0$のとき、$G$の$z'$は、$0$として初期化してもいいですし、ランダムに初期化してもいいです。z(0)$はデコーダに渡されて出力が生成され、次の時間ステップにも渡されます。

このネットワークにはループがないので、誤差逆伝播を実装することができます。

図2は、1つの特殊な特徴を持つ通常のネットワークを示しています：すべてのブロックが同じ重みを共有しています。3つのエンコーダ、デコーダ、G関数はそれぞれ異なる時間ステップで同じ重みを持っています。

BPTT（Backprop through time）: 時間方向まで含めた誤差逆伝播のことです。残念ながら、ナイーブな形式のRNNでは、BPTTはあまりうまく機能しません。

<!-- Problems with RNNs: -->
RNNの問題点

<!-- 1. Vanishing gradients
   - In a long sequence, the gradients get multiplied by the weight matrix (transpose) at every time step. If there are small values in the weight matrix, the norm of gradients get smaller and smaller exponentially.
2. Exploding gradients
   - If we have a large weight matrix and the non-linearity in the recurrent layer is not saturating, the gradients will explode. The weights will diverge at the update step. We may have to use a tiny learning rate for the gradient descent to work. -->

1. 勾配消失
   - 長いシーケンスでは、勾配は時間ステップごとに重み行列（の転置）に乗算されます。重み行列の値が小さい場合、勾配のノルムは指数関数的に小さくなります。
2. 勾配爆発
   - 大きな重み行列があり、リカレント層の非線形関数の出力が飽和していない場合、勾配は爆発的に増大します。これによって更新時に重みが発散します。勾配降下法が機能するためには、小さな学習率を使用しなければならないかもしれません。

<!-- One reason to use RNNs is for the advantage of remembering information in the past. However, it could fail to memorize the information long ago in a simple RNN without tricks.

An example that has vanishing gradient problem:

The input is the characters from a C Program. The system will tell whether it is a syntactically correct program. A syntactically correct program should have a valid number of braces and parentheses. Thus, the network should remember how many open parentheses and braces there are to check, and whether we have closed them all. The network has to store such information in hidden states like a counter.  However, because of vanishing gradients, it will fail to preserve such information in a long program. -->

RNNを使う理由の一つに、過去の情報を記憶できるという利点があります。しかし、仕掛けのない単純なRNNでは、かなり前の情報を記憶するのには失敗する可能性があります。

勾配消失がある例

入力はCプログラムの文字です。システムはそれが構文的に正しいプログラムであるかどうかを判断します。構文的に正しいプログラムは、有効な数の中括弧と括弧を持っていなければなりません。したがって、ネットワークは、チェックすべき開いている括弧と中括弧の数を覚えていて、それらが最終的にすべて閉じているかどうかを確認しなければなりません。ネットワークはそのような情報をカウンターのような隠れた状態で記憶しなければなりません。 しかし長いプログラムでは、勾配消失のために、そのような情報を保存することに失敗してしまいます。


<!-- ##  RNN Tricks

- clipping gradients:  (avoid exploding gradients)
   Squash the gradients when they get too large.
- Initialization (start in right ballpark avoids exploding/vanishing)
   Initialize the weight matrices to preserve the norm to some extent. For example, orthogonal initialization initializes the weight matrix as a random orthogonal matrix. -->

## RNNのコツ

- 勾配クリッピング (勾配爆発を避ける)：
   勾配が大きくなりすぎた場合には勾配を潰します。
- 初期化 (うまく初期状態を定めると、爆発や消失を避けることができます)：
   ある程度ノルムを維持するような、重み行列の初期化をします。例えば、直交初期化では、重み行列をランダムな直交行列として初期化します。

<!-- ## Multiplicative Modules -->
## 乗算モジュール

<!-- In multiplicative modules rather than only computing a weighted sum of inputs, we compute products of inputs and then compute weighted sum of that. -->
乗算モジュールでは、入力の加重和だけを計算するのではなく、入力の積を計算し、その積の加重和を計算します。

<!-- Suppose $x \in {R}^{n\times1}$, $W \in {R}^{m \times n}$, $U \in {R}^{m \times n \times d}$ and $z \in {R}^{d\times1}$. Here U is a tensor. -->
$x \in {R}^{n\times1}$, $W \in {R}^{m \times n}$, $U \in {R}^{m \times n \times d}$ そして $z \in {R}^{d\times1}$とします。 ここで U はテンソルです。

$$
w_{ij} = u_{ij}^\top z =
\begin{pmatrix}
u_{ij1} & u_{ij2} & \cdots &u_{ijd}\\
\end{pmatrix}
\begin{pmatrix}
z_1\\
z_2\\
\vdots\\
z_d\\
\end{pmatrix} = \sum_ku_{ijk}z_k
$$

$$
s =
\begin{pmatrix}
s_1\\
s_2\\
\vdots\\
s_m\\
\end{pmatrix} = Wx =  \begin{pmatrix}
w_{11} & w_{12} & \cdots &w_{1n}\\
w_{21} & w_{22} & \cdots &w_{2n}\\
\vdots\\
w_{m1} & w_{m2} & \cdots &w_{mn}
\end{pmatrix}
\begin{pmatrix}
x_1\\
x_2\\
\vdots\\
x_n\\
\end{pmatrix}
$$

<!-- where $s_i = w_{i}^\top x = \sum_j w_{ij}x_j$. -->
ただし$s_i = w_{i}^\top x = \sum_j w_{ij}x_j$です。

<!-- The output of the system is a classic weighted sum of inputs and weights. Weights themselves are also weighted sums of weights and inputs.

Hypernetwork architecture: weights are computed by another network. -->

システムの出力は、入力と重みの古典的な加重和です。重み自体もまた、入力と重みの加重和です。

ハイパーネットワークアーキテクチャ：重みは別のネットワークによって計算されます。


## Attention

<!-- $x_1$ and $x_2$ are vectors, $w_1$ and $w_2$ are scalars after softmax where $w_1 + w_2 = 1$, and  $w_1$ and $w_2$ are between 0 and 1.

$w_1x_1 + w_2x_2$ is a weighted sum of $x_1$ and $x_2$ weighted by coefficients $w_1$ and $w_2$.

By changing the relative size of $w_1$ and $w_2$, we can switch the output of $w_1x_1 + w_2x_2$ to $x_1$ or $x_2$ or some linear combinations of $x_1$ and $x_2$.

The inputs can have multiple $x$ vectors (more than $x_1$ and $x_2$). The system will choose an appropriate combination, the choice of which is determined by another variable z. An attention mechanism allows the neural network to focus its attention on particular input(s) and ignore the others.

Attention is increasingly important in NLP systems that use transformer architectures or other types of attention.

The weights are data independent because z is data independent. -->

$x_1$ と $x_2$ はベクトル、 $w_1$ と $w_2$ は softmax 後のスカラーで、 $w_1 + w_2 = 1$、 $w_1$ と $w_2$ は 0 から 1 の間の値です。

$w_1x_1 + w_2x_2$ は、 $x_1$ と $x_2$ を係数 $w_1$ と $w_2$ で加重したものです。

$w_1$と$w_2$の相対的な大きさを変えることで、$w_1x_1 + w_2x_2$の出力を、$x_1$または$x_2$、または$x_1$と$x_2$のいくつかの線形の組み合わせに切り替えることができます。

入力は、複数の $x$ ベクトル（$x_1$ と $x_2$ 以上）を持つことができます。attentionメカニズムは、ニューラルネットワークが特定の入力にattentionを向けさせ、他の入力を無視することを可能にします。

Attentionは、transformerアーキテクチャや他のタイプのattentionを使用する NLP システムでますます重要になってきています。

z はデータに依存しないので、重みはデータに依存しません。


## [Gated Recurrent Units (GRU)](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=3549s)

<!-- As mentioned above, RNN suffers from vanishing/exploding gradients and can’t remember states for very long. GRU, [Cho, 2014](https://arxiv.org/abs/1406.1078), is an application of multiplicative modules that attempts to solve these problems. It's an example of recurrent net with memory (another is LSTM). The structure of A GRU unit is shown below: -->

上述したように、RNNは勾配消失/爆発に苦しみ、あまり長く状態を記憶することができません。GRUs[Cho, 2014](https://arxiv.org/abs/1406.1078)、は、これらの問題を解決しようとする乗算モジュールの応用です。これはメモリ付きリカレントニューラルネットの一例です（別のものとしてLSTMがあります）。GRUユニットの構造は以下の通りです。

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-2/GRU.png" height="300px" style="background-color:#226;"/><br>
Figure 3. Gated Recurrent Unit
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-2/GRU.png" height="300px" style="background-color:#226;"/><br>
図3　Gated リカレントユニット
</center>

$$
\begin{array}{l}
z_t = \sigma_g(W_zx_t + U_zh_{t-1} + b_z)\\
r_t = \sigma_g(W_rx_t + U_rh_{t-1} + b_r)\\
h_t = z_t\odot h_{t-1} + (1- z_t)\odot\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)
\end{array}
$$

<!-- where $\odot$ denotes element-wise multiplication(Hadamard product), $x_t$ is the input vector, $h_t$ is the output vector, $z_t$ is the update gate vector, $r_t$ is the reset gate vector, $\phi_h$ is a hyperbolic tanh, and $W$,$U$,$b$ are learnable parameters. -->
ここで、$\odot$は要素毎の乗算(アダマール積)、$x_t$は入力ベクトル、$h_t$は出力ベクトル、$z_t$は更新ゲートベクトル、$r_t$はリセットゲートベクトル、$\phi_h$はtanh、$W$,$U$,$b$は学習可能なパラメータです。

<!-- To be specific, $z_t$ is a gating vector that determines how much of the past information should be passed along to the future. It applies a sigmoid function to the sum of two linear layers and a bias over the input $x_t$ and the previous state $h_{t-1}$.  $z_t$ contains coefficients between 0 and 1 as a result of applying sigmoid. The final output state $h_t$ is a convex combination of $h_{t-1}$ and $\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)$ via $z_t$. If the coefficient is 1, the current unit output is just a copy of the previous state and ignores the input (which is the default behaviour). If it is less than one, then it takes into account some new information from the input.

The reset gate $r_t$ is used to decide how much of the past information to forget. In the new memory content $\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)$, if the coefficient in $r_t$ is 0, then it stores none of the information from the past. If at the same time $z_t$ is 0, then the system is completely reset since $h_t$ would only look at the input. -->

具体的には、$z_t$は、過去の情報を未来にどれだけ渡すべきかを決めるゲーティングベクトルです。これは、入力$x_t$と前の状態$h_{t-1}$に対する2つの線形層とバイアスの和にシグモイド関数を適用したものです。 $z_t$には、シグモイドを適用した結果として0と1の間の係数が含まれています。最終的な出力状態$h_t$は、$h_{t-1}$と$z_t$を介した$\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)$の凸の組み合わせです。係数が1の場合、現在の出力は前の状態のコピーに過ぎず、入力を無視します(これがデフォルトの動作です)。係数が1より小さい場合は、入力からの新しい情報を考慮に入れます。

リセットゲート $r_t$ は、過去の情報をどれだけ忘れるかを決めるために使用されます。新しい記憶内容 $\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)$において、$r_t$の係数が0であれば、過去の情報は何も記憶しません。同時に$z_t$が0ならば、$h_t$は入力を見ているだけなので、システムは完全にリセットされます。

## LSTM (Long Short-Term Memory)

<!-- GRU is actually a simplified version of LSTM which came out much earlier, [Hochreiter, Schmidhuber, 1997](https://www.bioinf.jku.at/publications/older/2604.pdf). By building up memory cells to preserve past information, LSTMs also aim to solve long term memory loss issues in RNNs. The structure of LSTMs is shown below: -->
GRUは実はもっと前に出てきたLSTMの簡略版です[Hochreiter, Schmidhuber, 1997](https://www.bioinf.jku.at/publications/older/2604.pdf)。LSTMは、過去の情報を保存するためのメモリセルを構築することで、RNNの長期記憶喪失の問題を解決することも目的としています。LSTMの構造を以下に示します。

<center>
<img src="{{site.baseurl}}/images/week06/06-2/LSTM.png" height="300px"/><br>
図4. LSTM
</center>

$$
\begin{array}{l}
f_t = \sigma_g(W_fx_t + U_fh_{t-1} + b_f)\\
i_t = \sigma_g(W_ix_t + U_ih_{t-1} + b_i)\\
o_t = \sigma_o(W_ox_t + U_oh_{t-1} + b_o)\\
c_t = f_t\odot c_{t-1} + i_t\odot \tanh(W_cx_t + U_ch_{t-1} + b_c)\\
h_t = o_t \odot\tanh(c_t)
\end{array}
$$

<!-- where $\odot$ denotes element-wise multiplication, $x_t\in\mathbb{R}^a$ is an input vector to the LSTM unit, $f_t\in\mathbb{R}^h$ is the forget gate's activation vector, $i_t\in\mathbb{R}^h$ is the input/update gate's activation vector, $o_t\in\mathbb{R}^h$ is the output gate's activation vector, $h_t\in\mathbb{R}^h$ is the hidden state vector (also known as output), $c_t\in\mathbb{R}^h$ is the cell state vector. -->

ここで、$\odot$は、要素毎の積、$x_t\in\mathbb{R}^a$は、LSTMユニットへの入力ベクトル、$f_t\in\mathbb{R}^h$は、忘却ゲートの活性ベクトル、$i_t\in\mathbb{R}^h$は、入力/更新ゲートの活性ベクトルです。また、$o_t\in\mathbb{R}^h$は、出力ゲートの活性ベクトル、$h_t\in\mathbb{R}^h$  は、隠れ状態ベクトル（出力としても知られている）、$c_t\in\mathbb{R}^h$ は、セルの状態ベクトルです。

<!-- An LSTM unit uses a cell state $c_t$ to convey the information through the unit. It regulates how information is preserved or removed from the cell state through structures called gates. The forget gate $f_t$ decides how much information we want to keep from the previous cell state $c_{t-1}$ by looking at the current input and previous hidden state, and produces a number between 0 and 1 as the coefficient of $c_{t-1}$.  $\tanh(W_cx_t + U_ch_{t-1} + b_c)$ computes a new candidate to update the cell state, and like the forget gate, the input gate $i_t$ decides how much of the update to be applied. Finally, the output $h_t$ will be based on the cell state $c_t$, but will be put through a $\tanh$ then filtered by the output gate $o_t$.

Though LSTMs are widely used in NLP, their popularity is decreasing. For example, speech recognition is moving towards using temporal CNN, and NLP is moving towards using transformers. -->

LSTMユニットは、セルの状態$c_t$を使用して、ユニットを介して情報を伝達します。ゲートと呼ばれる構造を通して、セルの状態から情報をどのように保存したり削除したりするかを調節しています。忘却ゲート $f_t$ は、現在の入力と前の隠れ状態を見て、前のセルの状態 $c_{t-1}$ からどれだけの情報を残すかを決め、0から1の間の数を $c_{t-1}$ の係数として生成します。 そして、$\tanh(W_cx_t + U_ch_{t-1} + b_c)$は、セルの状態を更新するための新しい候補を計算し、忘却ゲートと同様に、入力ゲート$i_t$は、どの程度の更新を適用するかを決定します。最後に、出力$h_t$は、セルの状態$c_t$に基づいていますが、$\tanh$を通過し出力ゲート$o_t$によってフィルタリングされます。

LSTMは、NLPでは広く使われていますが、その人気は低下しています。例えば、音声認識では時間的なCNN、NLPではtransformerを使う方向に進んでいます。

## Sequence to Sequence Model

<!-- The approach proposed by [Sutskever NIPS 2014](https://papers.nips.cc/paper/5346-sequence-to-sequence-learning-with-neural-networks.pdf) is the first neural machine translation system to have comparable performance to classic approaches. It uses an encoder-decoder architecture where both the encoder and decoder are multi-layered LSTMs. -->
[Sutskever NIPS 2014](https://papers.nips.cc/paper/5346-sequence-to-sequence-learning-with-neural-networks.pdf)によって提案されたアプローチは、古典的なアプローチに匹敵する性能を持った初めてのニューラル機械翻訳システムでした。これは、エンコーダとデコーダの両方が多層LSTMであるエンコーダ/デコーダアーキテクチャを使用しています。

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-2/Seq2Seq.png" height="300px" /><br>
Figure 5. Seq2Seq
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-2/Seq2Seq.png" height="300px" /><br>
図5. Seq2Seq
</center>

<!-- Each cell in the figure is an LSTM. For the encoder (the part on the left), the number of time steps equals the length of the sentence to be translated. At each step, there is a stack of LSTMs (four layers in the paper) where the hidden state of the previous LSTM is fed into the next one. The last layer of the last time step outputs a vector that represents the meaning of the entire sentence, which is then fed into another multi-layer LSTM (the decoder), that produces words in the target language. In the decoder, the text is generated in a sequential fashion. Each step produces one word, which is fed as an input to the next time step.

This architecture is not satisfying in two ways: First, the entire meaning of the sentence has to be squeezed into the hidden state between the encoder and decoder. Second, LSTMs actually do not preserve information for more than about 20 words. The fix for these issues is called a Bi-LSTM, which runs two LSTMs in opposite directions.  In a Bi-LSTM the meaning is encoded in two vectors, one generated by running LSTM from left to right, and another from right to left.  This allows doubling the length of the sentence without losing too much information. -->

図中の各セルはLSTMです。エンコーダ（左の部分）の場合、時間ステップ数は翻訳する文の長さに等しくなります。各ステップでは、前のLSTMの隠れ状態が次のLSTMにフィードされるLSTMのスタック（紙面では4層）があります。最後の時間ステップの最後の層では、文全体の意味を表すベクトルが出力され、それが別の多層LSTM（デコーダ）に送り込まれ、目的言語の単語が生成されます。デコーダでは、テキストは逐次的に生成されます。各ステップでは1つの単語が生成され、それが次の時間ステップへの入力として供給されます。

このアーキテクチャは、２つの点で満足できるものではありません。第一に、文全体の意味がエンコーダとデコーダの間の隠れた状態に押し込められなければなりません。第２に、LSTMは実際には約20語以上の情報を保持できません。これらの問題を解決する方法は、Bi-LSTMと呼ばれるもので、これは2つのLSTMを逆方向に実行するものです。 Bi-LSTMでは、意味は2つのベクトルで符号化され、1つは左から右にLSTMを実行して生成され、もう1つは右から左に実行されます。 これにより、あまり多くの情報を失うことなく、文の長さを2倍にすることができます。


<!-- ## Seq2seq with Attention -->
## AttentionつきSeq2seq

<!-- The success of the approach above was short-lived. Another paper by [Bahdanau, Cho, Bengio](https://arxiv.org/abs/1409.0473)  suggested that instead of having a gigantic network that squeezes the meaning of the entire sentence into one vector, it would make more sense if at every time step we only focus the attention on the relevant locations in the original language with equivalent meaning, i.e. the attention mechanism. -->
上記のアプローチの成功は短命でした。[Bahdanau, Cho, Bengio](https://arxiv.org/abs/1409.0473)による別の論文では、文全体の意味を一つのベクトルに押し込むような巨大なネットワークを持つよりも、各時間ステップで、原語の中の同等の意味を持つ関連する場所だけに注意を集中させた方が、より意味があると提案しています（例えばattentionn機構を使うなどして）。

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-2/Seq2SeqwAttention.png" height="300px" /><br>
Figure 6. Seq2Seq with Attention
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-2/Seq2SeqwAttention.png" height="300px" /><br>
図6 AttentionつきSeq2seq
</center>
<!-- 
In Attention, to produce the current word at each time step, we first need to decide which hidden representations of words in the input sentence to focus on. Essentially, a network will learn to score how well each encoded input matches the current output of the decoder. These scores are normalized by a softmax, then the coefficients are used to compute a weighted sum of the hidden states in the encoder at different time steps. By adjusting the weights, the system can adjust the area of inputs to focus on. The magic of this mechanism is that the network used to compute the coefficients can be trained through backpropagation. There is no need to build them by hand!

Attention mechanisms completely transformed neural machine translation. Later, Google published a paper [*Attention Is All You Need*](https://arxiv.org/abs/1706.03762), and they put forward transformer, where each layer and group of neurons is implementing attention. -->

Attentionでは、各時間ステップで現在の単語を生成するために、まず、入力文中のどの単語の隠れ表現に注目するかを決定する必要があります。本質的には、ネットワークは、各エンコードされた入力がデコーダの現在の出力とどれだけ一致しているかをスコア化することを学習します。これらのスコアはソフトマックスで正規化され、係数は、異なる時間ステップでのエンコーダの隠れ状態の重み付けされた合計を計算するために使用されます。重みを調整することで、システムは焦点を当てる入力の領域を調整することができます。このメカニズムのすごいところは、係数を計算するために使用されるネットワークが誤差逆伝播によって学習できることです。手作業で構築する必要はありません!

Attention機構は、ニューラル機械翻訳を完全に変貌させました。その後、Googleは論文[*Attention Is All You Need*](https://arxiv.org/abs/1706.03762)を発表し、ニューロンの各層やグループがattentionを実装しているtransformerを発表しました。


## [Memory network](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=4575s)

<!-- Memory networks stem from work at Facebook that was started by [Antoine Bordes](https://arxiv.org/abs/1410.3916) in 2014 and [Sainbayar Sukhbaatar](https://arxiv.org/abs/1503.08895) in 2015.

The idea of a memory network is that there are two important parts in your brain: one is the **cortex**, which is where you have long term memory. There is a separate chunk of neurons called the **hippocampus** which sends wires to nearly everywhere in the cortex. The hippocampus is thought to be used for short term memory, remembering things for a relatively short period of time. The prevalent theory is that when you sleep, there is a lot of information transferred from the hippocampus to the cortex to be solidified in long term memory since the hippocampus has limited capacity.

For a memory network, there is an input to the network, $x$ (think of it as an address of the memory), and compare this $x$ with vectors $k_1, k_2, k_3, \cdots$ ("keys") through a dot product. Put them through a softmax, what you get are an array of numbers which sum to one. And there are a set of other vectors $v_1, v_2, v_3, \cdots$ ("values"). Multiply these vectors by the scalers from softmax and sum these vectors up (note the resemblance to the attention mechanism) gives you the result. -->

Memory networkは、2014年に[Antoine Bordes](https://arxiv.org/abs/1410.3916)と2015年に[Sainbayar Sukhbaatar](https://arxiv.org/abs/1503.08895)によって開始されたFacebookでの研究に由来しています。

Memory networkのアイデアは、脳には2つの重要な部分があるということです。一つは長期記憶を司どる**大脳皮質**であり、もう一つは大脳皮質のほぼすべての場所にワイヤーを送っている**海馬**と呼ばれるニューロンの別の塊です。海馬は短期記憶に使われると考えられており、比較的短い期間の記憶をしています。海馬の容量が限られているため、睡眠時には長期記憶に固めるために海馬から大脳皮質に多くの情報が転送されているというのが定説です。

Memory networkには、ネットワークへの入力$x$(メモリのアドレスと考えてください)があり、この$x$とベクトル$k_1, k_2, k_3, \cdots$(キー)をドット積で比較します。それらをソフトマックスにかけると、要素の総和が1となる配列が得られます。 これらのベクトルにsoftmaxで得たスカラーを掛けて、これらのベクトルを合計すると (attention機構に似ていることに注意してください) 結果が得られます。

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork1.png" height="300px"/><br>
Figure 7. Memory Network
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork1.png" height="300px"/><br>
図7 Memory Network
</center>

<!-- If one of the keys (e.g. $k_i$) exactly matches $x$, then the coefficient associated with this key will be very close to one. So the output of the system will essentially be $v_i$.

This is **addressable associative memory**. Associative memory is that if your input matches a key, you get *that* value. And this is just a soft differentiable version of it, which allows you to backpropagate and change the vectors through gradient descent.

What the authors did was tell a story to a system by giving it a sequence of sentences. The sentences are encoded into vectors by running them through a neural net that has not been pretrained. The sentences are returned to the memory of this type. When you ask a question to the system, you encode the question and put it as the input of a neural net, the neural net produces an $x$ to the memory, and the memory returns a value.

This value, together with the previous state of the network, is used to re-access the memory. And you train this entire network to produce an answer to your question. After extensive training, this model actually learns to store stories and answer questions. -->

キーの1つ(例えば $k_i$)が $x$ と完全に一致する場合、このキーに関連する係数は1に非常に近いものになります。したがって、システムの出力は本質的に $v_i$ となります。

これが **アドレス指定可能な連想記憶** です。連想記憶とは、入力があるキーにマッチした場合、その値を取得することです。そして、これはそれの微分可能なバージョンにすぎず、誤差逆伝播したり、勾配降下法によってベクトルを変化させたりすることができます。

著者らが行ったことは、システムに一連の文章を与えることで、システムに文の内容を伝えることでした。文章は、事前に訓練されていないニューラルネットを通過することで、ベクトルにエンコードされ、記憶になります。システムに質問をすると、その質問をエンコードしてニューラルネットの入力として入れることで、ニューラルネットはメモリに対して$x$を生成し、メモリは値を返します。

この値は、ネットワークの前の状態と一緒に、メモリに再アクセスするために使用されます。そして、このネットワーク全体を訓練して、質問に対する答えを生成します。大規模な訓練の後、このモデルは実際に文の内容を記憶して質問に答えるように学習します。

$$
\alpha_i = k_i^\top x \\
c = \text{softmax}(\alpha) \\
s = \sum_i c_i v_i
$$

<!-- In memory network, there is a neural net that takes an input and then produces an address for the memory, gets the value back to the network, keeps going, and eventually produces an output. This is very much like computer since there is a CPU and an external memory to read and write. -->
Memory networkでは、入力を受けてメモリのアドレスを生成し、その値をネットワークに返してもらいます。そしてそれに続いて、最終的には出力を出すニューラルネットがあります。読み書きするためのCPUと外部メモリがあるので、これはコンピュータと非常によく似ています。

<center>
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork2.png" height="200px" />
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork3.png" height="200px" /> <br>

<!-- Figure 8. Comparision between memory network and computer (Photo by <a href='https://www.khanacademy.org/computing/ap-computer-science-principles/computers-101/computer--components/a/computer-memory'>Khan Acadamy</a>)
</center> -->
図8. memory networkとコンピュータの比較 (Photo by <a href='https://www.khanacademy.org/computing/ap-computer-science-principles/computers-101/computer--components/a/computer-memory'>Khan Acadamy</a>)
</center>

<!-- There are people who imagine that you can actually build **differentiable computers** out of this. One example is the [Neural Turing Machine](https://arxiv.org/abs/1410.5401) from DeepMind, which was made public three days after Facebook's paper was published on arXiv.

The idea is to compare inputs to keys, generate coefficients, and produce values - which is basically what a transformer is.  A transformer is basically a neural net in which every group of neurons is one of these networks. -->

これを使って、実際に**微分可能なコンピュータ**を作れるのではないかと想像している人たちがいます。その一例がDeepMindの[Neural Turing Machine](https://arxiv.org/abs/1410.5401)で、Facebookの論文がarXivで公開された3日後に公開されました。

入力をキーと比較し、係数を生成し、バリューを生成するというもので、transformerがやっていることは基本的にこれと同じです。 Transformerとは、ニューロンのすべてのグループがこれらのネットワークの1つであるようなニューラルネットワークのことです。
