---
lang-ref: ch.06-1
lecturer: Yann LeCun
title: Applications of Convolutional Network
authors: Shiqing Li, Chenqin Yang, Yakun Wang, Jimin Tan
date: 2 Mar 2020
lang: ja
translation-date: 6 Dec 2020
translator: Shiro Takagi
---


<!-- ## [Zip Code Recognition](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=43s) -->
## [郵便番号の識別](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=43s)

<!-- In the previous lecture, we demonstrated that a convolutional network can recognize digits, however, the question remains, how does the model pick each digit and avoid perturbation on neighboring digits. The next step is to detect non/overlapping objects and use the general approach of Non-Maximum Suppression (NMS). Now, given the assumption that the input is a series of non-overlapping digits, the strategy is to train several convolutional networks and using either majority vote or picking the digits corresponding to the highest score generated by the convolutional network. -->
前回の講義では、畳み込みニューラルネットワークで数字を識別できることを示しましたが、モデルがどのようにして各数字を選択し、隣接する数字への摂動を回避するのかという疑問が残りました。次のステップでは、重なりのない物体を検出するために、NMS（Non-Maximum Suppression）と呼ばれる一般的なアプローチを用います。ここで、入力が重複していない数字の列であると仮定して、複数の畳み込みニューラルネットワークを訓練し、多数決、または、畳み込みニューラルネットワークによって生成された最も高いスコアに対応する数字を選ぶ、という戦略をとります。


<!-- ### Recognition with CNN -->
### 畳み込みニューラルネットワーク(CNN)による識別

<!-- Here we present the task of recognizing 5 non-overlapping zip codes. The system was not given any instructions on how to separate each digit but knows that is must predict 5 digits. The system (Figure 1) consists of 4 different sized convolutional networks, each producing one set of outputs. The output is represented in matrices. The four output matrices are from models with a different kernel width in the last layer. In each output, there are 10 rows, representing 10 categories from 0 to 9. The larger white square represents a higher score in that category. In these four output blocks, the horizontal sizes of the last kernel layers are 5, 4, 3 and 2 respectively. The size of the kernel decides the width of the model's viewing window on the input, therefore each model is predicting digits based on different window sizes. The model then takes a majority vote and selects the category that corresponds to the highest score in that window. To extract useful information, one should keep in mind that not all combinations of characters are possible, therefore error correction leveraging input restrictions is useful to ensure the outputs are true zip codes. -->
ここでは、5つの重複がない郵便番号を識別するタスクを示します。このシステムは、各数字をどのように分離するかについての指示は与えられていませんが、5つの数字を予測する必要があることを認識しています。このシステム（図1）は、4つの異なるサイズの畳み込みニューラルネットワークで構成されており、それぞれが1つの出力セットを生成します。出力は行列で表現されますが、4つの出力行列はそれぞれ、最終層のカーネル幅が異なる4つのモデルからのものです。各出力行列は、0から9までの10のカテゴリを表す10行から構成されます。白い四角が大きいほど、そのカテゴリのスコアが高いことを表しています。これら4つの出力ブロックは、最後のカーネル層の幅が、それぞれ5、4、3、2です。カーネルのサイズは、モデルの入力のどの程度をまとめて見るかの範囲（視認窓）を決定するものですので、各モデルは異なる視認窓の大きさに基づいて数字を予測していることになります。次に、モデルは多数決を取り、その窓内で最も高いスコアに対応するカテゴリを選択します。有用な情報を抽出するためには、すべての文字の組み合わせが可能ではないことを念頭に置いておく必要があります。そのため、入力に対する制限を利用した誤り訂正は、出力が真の郵便番号であることを保証するのに役立ちます。


<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-1/O1IN3JD.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 1:</b> Multiple classifiers on zip code recognition
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-1/O1IN3JD.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図1:</b> 郵便番号識別のための複数の分類器
</center>

<!-- Now to impose the order of the characters. The trick is to utilize a shortest path algorithm. Since we are given ranges of possible characters and the total number of digits to predict, We can approach this problem by computing the minimum cost of producing digits and transitions between digit. The path has to be continuous from the lower left cell to the upper right cell on the graph, and the path is restricted to only contain movements from left to right and bottom to top. Note that if the same number is repeated next to each other, the algorithm should be able to distinguish there are repeated numbers instead of predicting a single digit. -->
今度は文字に順番をつけます。ポイントは、最短経路アルゴリズムを利用することです。可能な文字の範囲と予測すべき数字の合計が与えられているので、数字を生成して数字間を遷移するための最小のコストを計算することで、この問題にアプローチすることができます。経路はグラフ上の左下のセルから右上のセルまで連続していなければならず、経路は左から右へ、下から上への移動のみを含むように制限されています。同じ数字が隣り合わせで繰り返される場合、アルゴリズムは一つの数字を予測するのではなく、繰り返される数字があることを区別できるようにしなければならないことに注意してください。


<!-- ## [Face detection](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1241s) -->
## [顔検出](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1241s)

<!-- Convolutional neural networks perform well on detection tasks and face detection is no exception. To perform face detection we collect a dataset of images with faces and without faces, on which we train a convolutional net with a window size such as 30 $\times$ 30 pixels and ask the network to tell whether there is a face or not. Once trained, we apply the model to a new image and if there are faces roughly within a 30 $\times$ 30 pixel window, the convolutional net will light up the output at the corresponding locations. However, two problems exist. -->
畳み込みニューラルネットワークは物体検出タスクに適しており、顔検出もその例外ではありません。顔検出を行うには、顔のある画像と顔のない画像のデータセットを収集し、その上で30 $\times$ 30ピクセルのようなウィンドウの大きさの畳み込みニューラルネットを訓練し、顔があるかどうかをネットワークに答えてもらいます。一度訓練されたモデルを新しい画像に適用し、30 $\times$ 30ピクセルのウィンドウ内に大体の顔があれば、畳み込みネットは対応する位置で出力を点灯させます。しかし、2つの問題があります。

<!-- - **False Positives**: There are many ways that a patch of an image is not a face. During the training stage, the model may not see all of them (i.e. a fully representative set.). Therefore, the model may suffer from a lot of false positives at test time. -->

- **偽陽性**：　顔ではない画像のパッチには様々なものがあります。学習段階では、モデルはそれらのすべて（すなわち、完全な代表集合）を見ることはできないかもしれません。そのため、モデルはテスト時に多くの偽陽性を生み出す可能性があります。

<!-- - **Different Face Size:** Not all faces are 30 $\times$ 30 pixels, so faces of differing sizes may not be detected. One way to handle this issue is to generate multi-scale versions of the same image. The original detector will detect faces around 30 $\times$ 30 pixels. If applying a scale on the image of factor $\sqrt 2$, the model will detect faces that were smaller in the original image since what was 30 $\times$ 30 is now 20 $\times$ 20 pixels roughly. To detect bigger faces, we can downsize the image. This process is inexpensive as half of the expense comes from processing the original non-scaled image. The sum of the expenses of all other networks combined is about the same as processing the original non-scaled image. The size of the network is the square of the size of the image on one side, so if you scale down the image by $\sqrt 2$, the network you need to run is smaller by a factor of 2. So the overall cost is $1+1/2+1/4+1/8+1/16…$, which is 2. Performing a multi-scale model only doubles the computational cost. -->

- **顔の大きさの違い**：　すべての顔が30 $\times$ 30ピクセルではないので、大きさの違う顔は検出されないかもしれません。この問題を解決する方法の一つとして、同じ画像のマルチスケール版を生成する方法があります。オリジナルの検出器では、30 $\times$ 30ピクセル前後の顔を検出します。もし、$\sqrt 2$のスケールを適用すると、30 $\times$ 30だったものが 20 $\times$ 20ピクセルになるので、元の画像では小さかった顔が検出されることになります。大きな顔を検出するには、画像のサイズを小さくすれば良いということになります。この処理にかかるコストの半分は、縮小されていない元々の画像を処理することで得られるので、この処理は容易に行えます。他のすべてのネットワークでかかるコストの合計は、元の非拡大画像を処理するのとほぼ同じです。ネットワークのサイズは、片側の画像のサイズの二乗なので、画像を$\sqrt 2$だけスケールダウンすると、実行する必要のあるネットワークは2倍小さくなります。 なので、全体のコストは$1+1/2+1/4+1/8+1/16...$で、これは2です。 マルチスケールモデルを実行すると、計算コストが2倍になります。


<!-- ### A multi-scale face detection system -->
### マルチスケール顔検出システム

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-1/8R3v0Dj.png" style="zoom: 30%; background-color:#DCDCDC;"/><br>
<b>Figure 2:</b> Face detection system
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-1/8R3v0Dj.png" style="zoom: 30%; background-color:#DCDCDC;"/><br>
<b>図2:</b> 顔検出システム
</center>

<!-- The maps shown in (Figure 3) indicate the scores of face detectors. This face detector recognizes faces that are 20 $\times$ 20 pixels in size. In fine-scale (Scale 3) there are many high scores but are not very definitive. When the scaling factor goes up (Scale 6), we see more clustered white regions. Those white regions represent detected faces. We then apply non-maximum suppression to get the final location of the face. -->
（図3）に示すマップは、顔検出器のスコアを示しています。この顔検出器は、20 $\times$ 20ピクセルの大きさの顔を認識しています。細かいスケール(スケール3)では、高いスコアが多いですが、あまり確定的ではありません。スケーリング係数を上げると（スケール６）、白い領域が多くなってきます。これらの白い領域は検出された顔を表しています。次に、non-maximum suppressionを適用して、顔の最終的な位置を求めます。

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-1/CQ8T00O.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 3:</b> Face detector scores for various scaling factors
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-1/CQ8T00O.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図3:</b> 様々なスケーリングについての顔検出スコア
</center>


<!-- ### Non-maximum suppression

For each high-scoring region, there is probably a face underneath. If more faces are detected very close to the first, it means that only one should be considered correct and the rest are wrong. With non-maximum suppression, we take the highest-scoring of the overlapping bounding boxes and remove the others. The result will be a single bounding box at the optimum location. -->

###  Non-maximum suppression

それぞれのスコアが高い領域には、おそらくその下に顔があります。より多くの顔が最初の顔に非常に近い位置で検出された場合、それは1つだけが正しく、残りは間違っていると考えるべきであることを意味します。 Non-maximum suppressionでは、重複するバウンディングボックスの中で最もスコアの高いものを取り、それ以外のものを除去します。その結果、最適な位置に1つのバウンディングボックスができます。

<!-- ### Negative mining

In the last section, we discussed how the model will run into a large number of false positives at test time as there are many ways for objects to appear similar to a face. No training set will include all the non-face objects that look like faces. We can mitigate this problem through negative mining. In negative mining, we create a negative dataset of non-face patches that the model detects as faces. The data is collected by running the model on inputs that are known to contain no faces. Then we retrain the detector using the negative dataset. We can repeat this process to increase the robustness of our model against false positives. -->

### Negative mining

最後のセクションでは、物体が顔に似て見える方法がたくさんあることによって、テスト時にモデルがどのようにして大量の偽陽性を生み出すのかを説明しました。訓練セットには、顔に似ているように見える顔以外のオブジェクトがすべて含まれているわけではありません。この問題は、negative miningによって軽減することができます。Negative miningでは、モデルが顔として検出した非顔パッチのネガティブデータセットを作成します。このデータは、顔が含まれていないことが知られている入力に対してモデルを実行することで収集されます。次に、ネガティブデータセットを使って検出器を再訓練します。このプロセスを繰り返すことで、偽陽性に対するモデルの頑健性を高めることができます。

<!-- ## Semantic segmentation

Semantic segmentation is the task of assigning a category to every pixel in an input image. -->

## セマンティックセグメンテーション

セマンティックセグメンテーションとは、入力画像の各ピクセルにカテゴリを割り当てる作業です。


<!-- ### [CNN for Long Range Adaptive Robot Vision](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1669s) -->
### [遠くまで視認できる適応的なロボットの視覚のためのCNN](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1669s)

<!-- In this project, the goal was to label regions from input images so that a robot can distinguish between roads and obstacles. In the figure, the green regions are areas the robot can drive on and the red regions are obstacles like tall grass. To train the network for this task, we took a patch from the image and manually label it traversable or not (green or red). We then train the convolutional network on the patches by asking it to predict the color of the patch. Once the system is sufficiently trained, it is applied to the entire image, labeling all the regions of the image as green or red. -->
このプロジェクトでは、ロボットが道路と障害物を区別できるように、入力画像から領域をラベル付けすることを目的としています。図では、緑色の領域がロボットが走行可能な領域であり、赤色の領域が背の高い草などの障害物です。このタスクのためのネットワークを訓練するために、画像からパッチを取り出し、それが横断可能かどうか（緑か赤か）を手動でラベル付けしました。次に、パッチの色を予測してもらうことで、パッチ上の畳み込みニューラルネットワークを訓練します。システムが十分に訓練されると、画像全体に適用され、画像のすべての領域に緑または赤のラベルが付けられます。

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-1/5mM7dTT.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 4:</b> CNN for Long Range Adaptive Robot Vision (DARPA LAGR program 2005-2008)
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-1/5mM7dTT.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図4:</b> 遠くまで視認できる適応的なロボットの視角のためのCNN (DARPA LAGR program 2005-2008)
</center>

<!-- There were five categories for prediction: 1) super green, 2) green, 3) purple: obstacle foot line, 4) red obstacle  5) super red: definitely an obstacle. -->
予測には5つのカテゴリーがありました。1)スーパー緑、2)緑、3)紫：障害物足線、4)赤の障害物5)スーパー赤：間違いなく障害物。

<!-- **Stereo Labels** (Figure 4, Column 2)
 Images are captured by the 4 cameras on the robot, which are grouped into 2 stereo vision pairs. Using the known distances between the stereo pair cameras, the positions of every pixel in 3D space are then estimated by measuring the relative distances between the pixels that appear in both the cameras in a stereo pair. This is the same process our brains use to estimate the distance of the objects that we see. Using the estimated position information, a plane is fit to the ground, and pixels are then labeled as green if they are near the ground and red if they are above it.

* **Limitations & Motivation for ConvNet**: The stereo vision only works up to 10 meters and driving a robot requires long-range vision. A ConvNet however, is capable of detecting objects at much greater distances, if trained correctly. -->

**ステレオラベル**（図4、コラム2）
 画像はロボットに搭載された4つのカメラによって撮影され、2つのステレオビジョンペアにグループ化されています。ステレオペアのカメラ間の既知の距離を使用して、ステレオペアの両方のカメラに現れるピクセル間の相対距離を測定することによって、3D 空間における各ピクセルの位置を推定します。これは、私たちの脳が目に見える物体の距離を推定するのと同じプロセスです。推定された位置情報を用いて、平面を地面にフィットさせ、地面に近い場合は緑、地面より上にある場合は赤のラベルを付けます。

* **限界と畳み込みニューラルネットを用いる動機**：
ステレオビジョンは10mまでしか使えませんが、ロボットを運転するためには長距離の視野が必要となります。しかし、畳み込みニューラルネットは正しく訓練されていれば、はるかに遠くの物体を検出することができます。

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-1/rcxY4Lb.png" style="zoom: 100%; background-color:#DCDCDC;"/><br>
<b>Figure 5:</b> Scale-invariant Pyramid of Distance-normalized Images
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-1/rcxY4Lb.png" style="zoom: 100%; background-color:#DCDCDC;"/><br>
<b>図5:</b> 距離が正規化された画像のスケール不変なピラミッド
</center>

<!-- * **Served as Model Inputs**: Important pre-processing includes building a scale-invariant pyramid of distance-normalized images (Figure 5). It is similar to what we have done earlier of this lecture when we tried to detect faces of multiple scales. -->

* **モデルの入力**：重要な前処理の一つとして、距離で正規化された画像のスケール不変なピラミッドを構築することが含まれます（図5）。これは、この講義の前半に複数のスケールの顔を検出しようとしたときに行ったことと似ています。

<!-- **Model Outputs** (Figure 4, Column 3)

The model outputs a label for every pixel in the image **up to the horizon**. These are classifier outputs of a multi-scale convolutional network. -->
* **モデルの出力** (図4、コラム3)：
このモデルは、画像の**水平線**までのピクセルごとにラベルを出力します。これらは、マルチスケール畳み込みニューラルネットワークの分類器の出力です。
<!-- TODO: up to horizon -->

<!-- * **How the Model Becomes Adaptive**: The robots have continuous access to the stereo labels, allowing the network to re-train, adapting to the new environment it's in. Please note that only the last layer of the network would be re-trained. The previous layers are trained in the lab and fixed. -->

* **モデルを適応的にする方法**： ロボットはステレオラベルに継続的にアクセスしているため、ネットワークは新しい環境に適応して再訓練を行うことができます。ネットワークの最後の層だけが再訓練されることに注意してください。前の層は事前に訓練され、固定されます。

<!-- **System Performance**

When trying to get to a GPS coordinate on the other side of a barrier, the robot "saw" the barrier from far away and planned a route that avoided it. This is thanks to the CNN detecting objects up 50-100m away. -->

**システムのパフォーマンス**

障壁の向こう側のGPS座標にたどり着こうとすると、ロボットは遠くから障壁を「見て」、それを避けるルートを計画しました。これはCNNが50～100m先までの物体を検知しているおかげです。

<!-- **Limitation**

Back in the 2000s, computation resources were restricted. The robot was able to process around 1 frame per second, which means it would not be able to detect a person that walks in its way for a whole second before being able to react. The solution for this limitation is a **Low-Cost Visual Odometry** model. It is not based on neural networks, has a vision of ~2.5m but reacts quickly. -->

**限界**

2000年年代前半には、計算リソースは限られていました。ロボットは1秒間に1フレーム程度の処理が可能でしたが、これは、ロボットが反応するまでの1秒間は、自分の前を歩いてきた人を検出できないことを意味します。この制限を解決するのが、**Low-Cost Visual Odometry**モデルです。これは、ニューラルネットワークに基づいておらず、2.5m程度の視野を持ちながらも、素早く反応します。


<!-- ### Scene Parsing and Labelling -->
### シーンの解析とラベリング

<!-- In this task, the model outputs an object category (buildings, cars, sky, etc.) for every pixel. The architecture is also multi-scale (Figure 6). -->
このタスクでは、モデルはピクセルごとにオブジェクトのカテゴリ（建物、車、空など）を出力します。アーキテクチャもマルチスケールです（図6）。
<!-- 
<center>
<img src="{{site.baseurl}}/images/week06/06-1/VpVbkl5.jpg" style="zoom: 30%; background-color:#DCDCDC;"/><br>
<b>Figure 6:</b> Multi-scale CNN for scene parsing
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-1/VpVbkl5.jpg" style="zoom: 30%; background-color:#DCDCDC;"/><br>
<b>Figure 6:</b> シーン解析のためのマルチスケールCNN
</center>

<!-- Notice that if we back project one output of the CNN onto the input, it corresponds to an input window of size $46\times46$ on the original image at the bottom of the Laplacian Pyramid. It means we are **using the context of $46\times46$ pixels to decide the category of the central pixel**.

However, sometimes this context size is not enough to determine the category for larger objects.

**The multiscale approach enables a wider vision by providing extra rescaled images as  inputs.** The steps are as follows:
1. Take the same image, reduce it by the factor of 2 and a factor of 4, separately.
2. These two extra rescaled images are fed to **the same ConvNet** (same weights, same kernels) and we get another two sets of Level 2 Features.
3. **Upsample** these features so that they have the same size as the Level 2 Features of the original image.
4. **Stack** the three sets of (upsampled) features together and feed them to a classifier.


Now the largest effective size of content, which is from the 1/4 resized image, is $184\times 184\, (46\times 4=184)$.

**Performance**: With no post-processing and running frame-by-frame, the model runs very fast even on standard hardware. It has a rather small size of training data (2k~3k), but the results are still record-breaking. -->


CNNの出力を入力に逆射影することは、ラプラシアンピラミッドの底にある原画像上のサイズ$46 \times 46$の入力ウィンドウに相当することに注意してください。つまり、中心画素のカテゴリを決めるために、**$46 \times 46$ ピクセルのコンテキストを使っていることになります**。

しかし、大きなオブジェクトの場合、このコンテキストサイズだけではカテゴリを決定できないことがあります。

**マルチスケール法では、リスケーリングされた画像を入力として提供することで、より広い視野を得ることができます**。次のようなステップで行われます。
1. 同じ画像を、2倍と4倍の係数で別々に縮小します。
2. これら2つの余分なリスケーリングされた画像を**同じ畳み込みニューラルネット**（同じ重み、同じカーネル）に投入し、レベル2の特徴量を2セット取得します。
3. **これらの特徴量をアップサンプル**して、元の画像のレベル2の特徴量と同じサイズになるようにします。
4. （アップサンプルされた）特徴量の3つのセットを**重ねて**、分類器に送ります。


これで、1/4サイズにリサイズされた画像から得られる最大の実効的なサイズは、$184 \times 184 (46 \times 4=184)$です。

**パフォーマンス**：事後処理を行わず、フレーム単位で実行しているため、標準的なハードウェアでも非常に高速に動作します。訓練データのサイズがやや小さい(2k~3k)ですが、非常に優れた結果を出します。
