---
lang-ref: ch.05-3
title: 畳み込みと自動微分エンジンを理解する
lecturer: Alfredo Canziani
authors: Leyi Zhu, Siqi Wang, Tao Wang, Anqi Zhang
date: 25 Feb 2020
lang: ja
translation-date: 04 Oct 2020
translator: Jesmer Wong
---


<!-- ## [Understanding 1D convolution](https://www.youtube.com/watch?v=eEzCZnOFU1w&t=140s)


In this part we will discuss convolution, since we would like to explore the sparsity, stationarity, compositionality of the data.

Instead of using the matrix$A$discussed in the [previous week]({{site.baseurl}}/en/week04/04-1), we will change the matrix width to the kernel size$k$. Therefore, each row of the matrix is a kernel. We can use the kernels by stacking and shifting (see 図1). Then we can have$m$layers of height$n-k+1$. -->
## [1次元畳み込みを理解する](https://www.youtube.com/watch?v=eEzCZnOFU1w&t=140s)

データのスパース性、定常性、構成性を議論したいので、このパートでは、畳み込みについて説明します。

[前の週]({{site.baseurl}}/ja/week04/04-1) で説明した行列$A$を使用する代わりに、行列の幅をカーネルサイズ$k$に変更します。 したがって、行列の各行はカーネルです。 スタックやシフトでカーネルを使用できます（図1を参照）。 すると、高さ$n-k + 1$の層を$m$層を作成できます。


<center>
<img src="{{site.baseurl}}/images/week05/05-3/Illustration_1D_Conv.png" alt="1" style="zoom:40%;" /><br>
<!-- <b>図1</b>: Illustration of 1D Convolution -->
<b>図1</b>: １次元畳み込みの例
</center>

<!-- The output is$m$(thickness) vectors of size$n-k+1$. -->
出力は、サイズ$n-k + 1$の厚さ$m$のベクトルです。

<center>
<img src="{{site.baseurl}}/images/week05/05-3/Result_1D_Conv.png" alt="2" style="zoom:40%;" /><br>
<!-- <b>図2</b>: Result of 1D Convolution -->
<b>図2</b>: １次元畳み込みの結果
</center>

<!-- Furthermore, a single input vector can viewed as a monophonic signal. -->
さらに、単一の入力ベクトルは単旋律の信号と見なすことができます。

<center>
<img src="{{site.baseurl}}/images/week05/05-3/Monophonic_Signal.png" alt="3" style="zoom:40%;" /><br>
<!-- <b>図3</b>: Monophonic Signal -->
<b>図3</b>: 単旋律の信号
</center>

<!-- Now, the input$x$is a mapping -->
今、入力$x$は写像です

$$
x:\Omega\rightarrow\mathbb{R}^{c}
$$

<!-- where$\Omega = \lbrace 1, 2, 3, \cdots \rbrace \subset \mathbb{N}^1$(since this is$1$dimensional signal / it has a$1$dimensional domain) and in this case the channel number$c$is$1$. When$c = 2$this becomes a stereophonic signal. -->
ここで、$\Omega = \lbrace 1, 2, 3, \cdots \rbrace \subset \mathbb {N}^1$（これは$1$次元の信号です。なぜなら$1$次元のドメインがあるからです。）で、この場合はチャネル数$c$は$1$です。$c = 2$の場合、これはステレオ（複旋律）信号になります。

<!-- For the 1D convolution, we can just compute the scalar product, kernel by kernel (see 図4). -->
１次元畳み込みの場合、カーネルごとにスカラー積で計算します（図4を参照）。

<center>
<img src="{{site.baseurl}}/images/week05/05-3/Layer_by_layer_scalar_product.png" alt="4" style="zoom:40%;" /><br>
<!-- <b>図4</b>: Layer-by-layer Scalar Product of 1D Convolution -->
<b>図4</b>: 層ごとにスカラー積での畳み込み
</center>


<!-- ## [Dimension of kernels and output width in PyTorch](https://www.youtube.com/watch?v=eEzCZnOFU1w&t=1095s)

Tips: We can use ***question mark*** in IPython to get access to the documents of functions. For example, -->
[PyTorchにおけるカーネルと出力幅の次元](https://www.youtube.com/watch?v=eEzCZnOFU1w&t=1095s)

ヒント：IPythonでは ***？*** を使用して、関数のドキュメントにアクセスできます。 例えば、

```python
Init signature:
nn.Conv1d(
	in_channels,           # number of channels in the input image
	out_channels,          # number of channels produced by the convolution
	kernel_size,           # size of the convolving kernel
	stride=1,              # stride of the convolution
	padding=0,             # zero-padding added to both sides of the input
	dilation=1,            # spacing between kernel elements
	groups=1,              # nb of blocked connections from input to output
	bias=True,             # if `True`, adds a learnable bias to the output
	padding_mode='zeros',  # accepted values `zeros` and `circular`
)
```


<!-- ### 1D convolution

We have$1$dimensional convolution going from$2$channels (stereophonic signal) to$16$channels ($16$kernels) with kernel size of$3$and stride of$1$. We then have$16$kernels with thickness$2$and length$3$. Let's assume that the input signal has a batch of size$1$(one signal),$2$channels and$64$samples. The resulting output layer has$1$signal,$16$channels and the length of the signal is$62$($=64-3+1$). Also, if we output the bias size, we'll find the bias size is$16$, since we have one bias per weight. -->
1次元畳み込み

カーネルサイズは$3$、ストライドは$1$で、$1$次元の畳み込みを$2$チャネル（ステレオ信号）から$16$チャネル（$16$カーネル）へ変換します。次は、厚さが$2$、長さが$3$の$16$カーネルが続きます。仮に入力信号のバッチサイズが$1$（1つの信号）であり、チャネル数は$2$、サンプル数は$64$とすると、出力層の信号数は$1$、チャネル数は$16$、信号の長さは$62$（$= 64-3 + 1$）となります。また、バイアスのサイズも出力すると、重みごとに1つのバイアスがあるため、バイアスのサイズは$16$であることがわかります。

```python
conv = nn.Conv1d(2, 16, 3)  # 2 channels (stereo signal), 16 kernels of size 3
conv.weight.size()          # output: torch.Size([16, 2, 3])
conv.bias.size()            # output: torch.Size([16])

x = torch.rand(1, 2, 64)    # batch of size 1, 2 channels, 64 samples
conv(x).size()              # output: torch.Size([1, 16, 62])

conv = nn.Conv1d(2, 16, 5)  # 2 channels, 16 kernels of size 5
conv(x).size()              # output: torch.Size([1, 16, 60])
```


<!-- ### 2D convolution

We first define the input data as$1$sample,$20$channels (say, we're using an hyperspectral image) with height$64$and width$128$. The 2D convolution has$20$channels from input and$16$kernels with size of$3 \times 5$. After the convolution, the output data has$1$sample,$16$channels with height$62$($=64-3+1$) and width$124$($=128-5+1$).　-->
2次元畳み込み

入力データを、高さ$64$、幅$128$の$1$サンプル、$20$チャネル（たとえば、ハイパースペクトル画像を使用）だとします。2次元畳み込みは、入力からの$20$チャネルと、サイズが$3 \times 5$の$16$カーネルです。 畳み込み後、出力データには$1$サンプル、高さ$62$（$= 64-3 + 1$）、幅$124$（$= 128-5 + 1$）の$16$チャネルがあります。

```python
x = torch.rand(1, 20, 64, 128)    # 1 sample, 20 channels, height 64, and width 128
conv = nn.Conv2d(20, 16, (3, 5))  # 20 channels, 16 kernels, kernel size is 3 x 5
conv.weight.size()                # output: torch.Size([16, 20, 3, 5])
conv(x).size()                    # output: torch.Size([1, 16, 62, 124])
```

<!-- If we want to achieve the same dimensionality, we can have paddings. Continuing the code above, we can add new parameters to the convolution function: `stride=1` and `padding=(1, 2)`, which means$1$on$y$direction ($1$at the top and$1$at the bottom) and$2$on$x$direction. Then the output signal is in the same size compared to the input signal. The number of dimensions that is required to store the collection of kernels when you perform 2D convolution is$4$.　-->
次元数が維持したい場合は、パディングを使用することができます。上記により、畳み込み関数に新しいパラメーター `stride = 1`と` padding =（1、2） `を追加できます。これは、$y$方向に$1$（上部に$1$、底部に$1$）と$x$方向に$2$を意味します。 その場合、出力信号のサイズは入力信号のサイズと同じです。 2次元畳み込みを実行するときにカーネルの関数を保存するために必要な次元の数は$4$です。

```python
# 20 channels, 16 kernels of size 3 x 5, stride is 1, padding of 1 and 2
conv = nn.Conv2d(20, 16, (3, 5), 1, (1, 2))
conv(x).size()  # output: torch.Size([1, 16, 64, 128])
```


<!-- ## [How automatic gradient works?](https://www.youtube.com/watch?v=eEzCZnOFU1w&t=1634s)

In this section we're going to ask torch to check all the computation over the tensors so that we can perform the computation of partial derivatives.

- Create a$2\times2$tensor$\boldsymbol{x}$with gradient-accumulation capabilities;
- Deduct$2$from all elements of$\boldsymbol{x}$and get$\boldsymbol{y}$; (If we print `y.grad_fn`, we will get `<SubBackward0 object at 0x12904b290>`, which means that `y` is generated by the module of subtraction$\boldsymbol{x}-2$. Also we can use `y.grad_fn.next_functions[0][0].variable` to derive the original tensor.)
- Do more operations:$\boldsymbol{z} = 3\boldsymbol{y}^2$;
- Calculate the mean of$\boldsymbol{z}$. -->
## [自動微分の仕組み](https://www.youtube.com/watch?v=eEzCZnOFU1w&t=1634s)

このセクションでは、偏微分を計算するように、PyTorchのテンソルにすべての計算をチェックするように依頼します。

- 勾配を蓄積する機能を備えた$2 \times2$テンソル$\boldsymbol {x}$を作成します。
- $\boldsymbol {x}$のすべての座標値から$2$を差し引き、$\boldsymbol {y}$を取ります。 （ `y.grad_fn`を出力すると、` <SubBackward0 object at 0x12904b290> `が得られます。つまり、` y`は減算$\boldsymbol {x} -2$のモジュールによって生成されます。また、`y.grad_fn.next_functions [0] [0] .variable`を使用して、元のテンソルを導出することもできます。）
- 次の操作は：$\boldsymbol {z} = 3 \boldsymbol {y} ^ 2$;
- $\boldsymbol {z}$の平均を計算します。

<center>
<img src="{{site.baseurl}}/images/week05/05-3/Flow_Chart.png" alt="5" style="zoom:60%;" /><br>
<b>図5</b>: 自動微分の例のフローチャート
</center>

<!-- Back propagation is used for computing the gradients. In this example, the process of back propagation can be viewed as computing the gradient$\frac{d\boldsymbol{a}}{d\boldsymbol{x}}$. After computing$\frac{d\boldsymbol{a}}{d\boldsymbol{x}}$by hand as a validation, we can find that the execution of `a.backward()` gives us the same value of *x.grad* as our computation.

Here is the process of computing back propagation by hand: -->
バックプロパゲーションは、勾配の計算に使用されます。 この例では、バックプロパゲーションのプロセスは、勾配$\frac {d \boldsymbol {a}} {d \boldsymbol {x}}$を計算するものと見ることができるでしょう。検証として$\frac {d \boldsymbol {a}} {d \boldsymbol {x}}$を手動で計算したすると、`a.backward（）`で計算した*x.grad*の値は、私たちの手動による計算の結果と同じだとわかります。

手動でバックプロパゲーションを計算するプロセスは次のとおりです。

$$
\begin{aligned}
a &= \frac{1}{4} (z_1 + z_2 + z_3 + z_4) \\
z_i &= 3y_i^2 = 3(x_i-2)^2 \\
\frac{da}{dx_i} &= \frac{1}{4}\times3\times2(x_i-2) = \frac{3}{2}x_i-3 \\
x &= \begin{pmatrix} 1&2\\3&4\end{pmatrix} \\
\left(\frac{da}{dx_i}\right)^\top &= \begin{pmatrix} 1.5-3&3-3\\[2mm]4.5-3&6-3\end{pmatrix}=\begin{pmatrix} -1.5&0\\[2mm]1.5&3\end{pmatrix}
\end{aligned}
$$

<!-- Whenever you use partial derivative in PyTorch, you get the same shape of the original data. But the correct Jacobian thing should be the transpose.　-->
PyTorchで偏微分を使用する場合、常に元のデータと同じ次元数が得られます。 しかし、正しいヤコビ行列は転置されたものになります。


<!-- ### From basic to more crazy

Now we have a$1\times3$vector$x$, assign$y$to the double$x$and keep doubling$y$until its norm is smaller than$1000$. Due to the randomness we have for$x$, we cannot directly know the number of iterations when the procedure terminates.　-->
### 基本的なものから変わったものへ

これで、$1 \times3$ベクトル$x$を手に入れ、$y$をダブル$x$に割り当て、ノルムが$1000$より小さくなるまで$y$を2倍し続けます。
$x$にはランダム性があるため、反復数計算はいつ終わるかは簡単にはわかりません。

```python
x = torch.randn(3, requires_grad=True)

y = x * 2
i = 0
while y.data.norm() < 1000:
    y = y * 2
    i += 1
```

<!-- However, we can infer it easily by knowing the gradients we have.　-->
ただし、勾配の値で推測できます。

```python
gradients = torch.FloatTensor([0.1, 1.0, 0.0001])
y.backward(gradients)

print(x.grad)
tensor([1.0240e+02, 1.0240e+03, 1.0240e-01])
print(i)
9
```

<!-- As for the inference, we can use `requires_grad=True` to label that we want to track the gradient accumulation as shown below. If we omit `requires_grad=True` in either$x$or$w$'s declaration and call `backward()` on$z$, there will be runtime error due to we do not have gradient accumulation on$x$or$w$. -->
推測に関しては、以下に示すように、 `requires_grad = True`を使用して、勾配の蓄積を追跡したいというラベルをつけます。$x$または$w$の宣言で `requires_grad = True`を省略し、$z$で` backward（） `を呼び出すと、$x$と$w$の勾配がいっさい積算されてないため、ランタイムエラーが発生します。

```python
# Both x and w that allows gradient accumulation
x = torch.arange(1., n + 1, requires_grad=True)
w = torch.ones(n, requires_grad=True)
z = w @ x
z.backward()
print(x.grad, w.grad, sep='\n')
```

<!-- And, we can have `with torch.no_grad()` to omit the gradient accumulation. -->
また、`with torch.no_grad()`で勾配の蓄積が省略できます。

```python
x = torch.arange(1., n + 1)
w = torch.ones(n, requires_grad=True)

# All torch tensors will not have gradient accumulation
with torch.no_grad():
    z = w @ x

try:
    z.backward()  # PyTorch will throw an error here, since z has no grad accum.
except RuntimeError as e:
    print('RuntimeError!!! >:[')
    print(e)
```


<!-- ## More stuff -- custom gradients

Also, instead of basic numerical operations, we can generate our own self-defined modules / functions, which can be plugged into the neural graph. The Jupyter Notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/extra/b-custom_grads.ipynb).

To do so, we need to inherit `torch.autograd.Function` and override `forward()` and `backward()` functions. For example, if we want to training nets, we need to get the forward pass and know the partial derivatives of the input respect to the output, such that we can use this module in any kind of point in the code. Then, by using back-propagation (chain rule), we can plug the thing anywhere in the chain of operations, as long as we know the partial derivatives of the input respect to the output.

In this case, there are three examples of ***custom modules*** in the *notebook*, the `add`, `split`, and `max` modules. For example, the custom addition module:　-->
## その他：勾配値をカスタマイズする

また、基本的な数値計算の代わりに、ニューラルグラフに導入できる自己定義モジュール/関数を生成 することができます。 Jupyter Notebookは[ここ](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/extra/b-custom_grads.ipynb)にあります。

そのためには、 `torch.autograd.Function`のクラスを継承し、` forward（） `関数と` backward（） `関数を上書きする必要があります。 たとえば、ネットワークを訓練する場合は、フォワードパスを取得し、出力に関する入力の偏微分を知ることで、コード内の任意の箇所でこの新モジュールが使用できるようにする必要があります。 すると、出力に対する入力の偏微分がわかっている限り、バックプロパゲーション（チェーンルール）を使って、連鎖した演算の任意のところにも何かしら導入することができます。

この場合、*ノートブック*には***カスタムモジュール***の3つの例、「add」、「split」、および「max」モジュールがあります。 たとえば、カスタム加算モジュールは次のとおりです。

```python
# Custom addition module
class MyAdd(torch.autograd.Function):

    @staticmethod
    def forward(ctx, x1, x2):
        # ctx is a context where we can save
        # computations for backward.
        ctx.save_for_backward(x1, x2)
        return x1 + x2

    @staticmethod
    def backward(ctx, grad_output):
        x1, x2 = ctx.saved_tensors
        grad_x1 = grad_output * torch.ones_like(x1)
        grad_x2 = grad_output * torch.ones_like(x2)
        # need to return grads in order
        # of inputs to forward (excluding ctx)
        return grad_x1, grad_x2
```

<!-- If we have addition of two things and get an output, we need to overwrite the forward function like this. And when we go down to do back propagation, the gradients copied over both sides. So we overwrite the backward function by copying.

For `split` and `max`, see the code of how we overwrite forward and backward functions in the *notebook*. If we come from the same thing and **Split**, when go down doing gradients, we should add / sum them. For `argmax`, it selects the index of the highest thing, so the index of the highest should be$1$while others being$0$. Remember, according to different custom modules, we need to overwrite its own forward pass and how they do gradients in backward function. -->
2つの和を計算して出力を取得する場合は、このようにフォーワードパス関数を上書きする必要があります。 そして、バックプロパゲーションを行うために計算グラフを降っていくと、勾配が両側にコピーされます。 そのため、バックワード関数をコピーして上書きします。

`split`と` max`については、*ノートブック*のフォーワードパス関数とバックワードパス関数を上書きする方法のコードを参照してください。 **Split**と同じものから来た場合、勾配をコピーしてから加算/合計する必要があります。 `argmax`の場合、最も高い値に属したインデックスは$1$で、他のインデックスは$0$のように、最も高い値に対応するインデックスを選択します。さまざまなカスタムモジュールに応じて、各自のフォワードパスと、バックワード関数での勾配の実行方法を上書きする必要があることを忘れないでください。
