---
lang-ref: ch.05-2
title: Optimisation Techniques II
title: 最適化テクニックII
lecturer: Aaron Defazio
authors: Guido Petri, Haoyue Ping, Chinmay Singhal, Divya Juneja
date: 24 Feb 2020
lang: ja
translation-date: 04 Oct 2020
translator: Jesmer Wong
---


<!-- ## [Adaptive methods](https://www.youtube.com/watch?v=--NZb480zlg&t=2675s) -->
## [アダプティブ（適応的な）方法](https://www.youtube.com/watch?v=--NZb480zlg&t=2675s)

<!-- SGD with momentum is currently the state of the art optimization method for a lot of ML problems. But there are other methods, generally called Adaptive Methods, innovated over the years that are particularly useful for poorly conditioned problems (if SGD does not work).

In the SGD formulation, every single weight in network is updated using an equation with the same learning rate (global $\gamma$). Here, for adaptive methods, we *adapt a learning rate for each weight individually*. For this purpose, the information we get from gradients for each weight is used.

Networks that are often used in practice have different structure in different parts of them. For instance, early parts of CNN may be very shallow convolution layers on large images and later in the network we might have convolutions of large number of channels on small images. Both of these operations are very different so a learning rate which works well for the beginning of the network may not work well for the latter sections of the network. This means adaptive learning rates by layer could be useful.

Weights in the latter part of the network (4096 in figure 1 below) directly dictate the output and have a very strong effect on it. Hence, we need smaller learning rates for those. In contrast, earlier weights will have smaller individual effects on the output, especially when initialized randomly. -->
モメンタムつき確率的勾配降下法(SGD)は、現在、多くの機械学習の問題に対する最先端の最適化手法のやりかたです。しかし、長年にわたって考え出され一般に適応的な方法と呼ばれる他の方法があって、これは悪条件の問題（SGDがうまくいかない場合）に対して特に役立ちます。

SGDでは、ネットワーク内のすべての重みは、同じ学習率（グローバル$\gamma$）を用いた式で更新されます。ここで、適応的な方法というのは、*各重みの学習率を個別に適応させる方法のことをいいます*。このために、各重みの勾配の情報も使用されます。

実応用上よく使用されるネットワークは、異なる部分に異なる構造を持っています。たとえば、CNNの入力層は大きな画像の非常に浅い畳み込み層であり、ネットワークの後半では、小さな画像の多数のチャネルの畳み込みで実現するようになっています。上記の操作は両方とも非常に異なっているため、前半の層に適用した学習率は、ネットワークの後半の層では必ずしも適用できない場合もあります。したがって、層ごとに適応的に学習率を微調整すると役立つ可能性があります。

ネットワークの後半部分（下の図1の4096）の重みは、出力を直接決定し、非常に強い影響を及ぼします。よって、それらにはより小さな学習率が必要です。対して、それより浅い層の重みは、特にランダムに初期化された場合、出力に対する個々の影響が小さくなります。


<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_vgg.png" style="zoom:40%"><br>
<b>図1: </b>VGG16
</center>


### RMSprop


<!-- The key idea of *Root Mean Square Propagation* is that the gradient is normalized by its root-mean-square.

In the equation below, squaring the gradient denotes that each element of the vector is squared individually. -->
*Root Mean Square Propagation（RMSProp，二乗平均平方根伝播）* の重要なアイデアは、勾配が二乗平均平方根で正規化されることです。

以下の式で、勾配を2乗することは、ベクトルの各座標値を個別に2乗するということです。

$$
\begin{aligned}
v_{t+1} &= {\alpha}v_t + (1 - \alpha) \nabla f_i(w_t)^2 \\
w_{t+1} &=  w_t - \gamma \frac {\nabla f_i(w_t)}{ \sqrt{v_{t+1}} + \epsilon}
\end{aligned}
$$

<!-- where $\gamma$ is the global learning rate, $\epsilon$ is a value close to machine $\epsilon$ (on the order of $10^{-7}$ or  $10^{-8}$) -- in order to avoid division by zero errors, and $v_{t+1}$ is the 2nd moment estimate.

We update $v$ to estimate this noisy quantity via an *exponential moving average* (which is a standard way of maintaining an average of a quantity that may change over time). We need to put larger weights on the newer values as they provide more information. One way to do that is down-weight old values exponentially. The values in the $v$ calculation that are very old are down-weighted at each step by an $\alpha$ constant, which varies between 0 and 1. This dampens the old values until they are no longer an important part of the exponential moving average.

The original method keeps an exponential moving average of a non-central second moment, so we don't subtract the mean here. The *second moment* is used to normalize the gradient element-wise, which means that every element of the gradient is divided by the square root of the second moment estimate. If the expected value of gradient is small, this process is similar to dividing the gradient by the standard deviation.

Using a small $\epsilon$ in the denominator doesn't diverge because when $v$ is very small, the momentum is also very small. -->
ここで、$\gamma$はグローバルな学習率であり、
$\epsilon$はゼロ除算を回避するためにゼロに近い値（$10^{-7}$または$10^{-8}$のオーダー）で設定され、
$v_{t + 1}$は2次モーメントの推定値です。

$v$を更新して、*指数移動平均*（時間とともに変化するある量を平均的に維持する標準的な方法）を介してこのノイズの量を推定します。新しい値はより多くの情報を提供しますので、より大きな重みを付ける必要があります。一つのやりかたは、古い値を指数衰減させることです。非常に古い$v$の値は、0から1の間の定数$\alpha$で各ステップで衰減させます。これにより、指数減衰させた古い値は、もう移動平均の計算に重要な部分ではなくなります。

元の方法では、中心化されていない2次モーメントで指数移動平均が保持されるため、ここでは平均を減算しません。 *2次モーメント*は、勾配を座標値ごとに正規化するために使用されます。つまり、勾配のすべての要素が2次モーメント推定値の平方根で除算されます。勾配の期待値が小さい場合、このプロセスは勾配を標準偏差で除算するのとほぼ同じです。

分母に小さな$\epsilon$を使用しても、$v$が非常に小さい場合、モメンタムも非常に小さいため、発散しません。



### ADAM

<!-- ADAM, or *Adaptive Moment Estimation*, which is RMSprop plus momentum, is a more commonly used method. The momentum update is converted to an exponential moving average and we don't need to change the learning rate when we deal with $\beta$. Just as in RMSprop, we take an exponential moving average of the squared gradient here. -->
ADAM、もしくは*Adaptive Moment Estimation、適応的モーメント推定*は、RMSpropにモメンタムをあわせる手法であり、より一般的に用いられています。 モメンタムの更新は指数移動平均に変換され、$\beta$を処理するときに一緒に学習率を変更する必要はありません。RMSpropの場合と同じく、ここでは勾配の2乗の指数移動平均を取ります。

$$
\begin{aligned}
m_{t+1} &= {\beta}m_t + (1 - \beta) \nabla f_i(w_t) \\
v_{t+1} &= {\alpha}v_t + (1 - \alpha) \nabla f_i(w_t)^2 \\
w_{t+1} &=  w_t - \gamma \frac {m_{t}}{ \sqrt{v_{t+1}} + \epsilon}
\end{aligned}
$$

<!-- where $m_{t+1}$ is the momentum's exponential moving average.　-->
ここの$m_{t+1}$はモーメントの指数移動平均です。

<!-- Bias correction that is used to keep the moving average unbiased during early iterations is not shown here. -->
初期の反復計算時に移動平均を維持するためのバイアス補正は、ここには示されていません。

<!-- ### Practical side

When training neural networks, SGD often goes in the wrong direction in the beginning of the training process, whereas RMSprop hones in on the right direction. However, RMSprop suffers from noise just as regular SGD, so it bounces around the optimum significantly once it's close to a local minimizer. Just like when we add momentum to SGD, we get the same kind of improvement with ADAM. It is a good, not-noisy estimate of the solution, so **ADAM is generally recommended over RMSprop**. -->
### 実際的な側面

ニューラルネットワークを訓練する場合、SGDは訓練プロセスの早期に間違った方向に進むことがよくありますが、RMSpropは正しい方向に向かうように補正をさせます。 ただし、RMSpropは通常のSGDと同じくノイズの影響を受けるため、極小値に近づくと、この極小値の周りで大幅に跳ね返ります。 SGDにモメンタムをつけるのと同じように、ADAMでも同じような改善が見られます。 ノイズの少ない最小値にたどり着けられるため、**ADAMは一般的にRMSpropよりも推奨されます**

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_comparison.png" style="zoom:45%"><br>
<b>図2: </b> SGD vs. RMSprop vs. ADAM
</center><br>

<!-- ADAM is necessary for training some of the networks for using language models. For optimizing neural networks, SGD with momentum or ADAM is generally preferred. However, ADAM's theory in papers is poorly understood and it also has several disadvantages:

* It can be shown on very simple test problems that the method does not converge.
* It is known to give generalization errors. If the neural network is trained to give zero loss on the data you trained it on, it will not give zero loss on other data points that it has never seen before. It is quite common, particularly on image problems, that we get worse generalization errors than when SGD is used. Factors could include that it finds the closest local minimum, or less noise in ADAM, or its structure, for instance.
* With ADAM we need to maintain 3 buffers, whereas SGD needs 2 buffers. This doesn't really matter unless we train a model on the order of several gigabytes in size, in which case it might not fit in memory.
* 2 momentum parameters need to be tuned instead of 1. -->

ADAMは、ニューラルネットを自然言語処理モデルとして用いるために訓練する上で、必要です。ニューラルネットワークを最適化するには、一般的にモーメント付きのSGDまたはADAMが推奨されます。ただし、論文に説明されたADAMの理論は十分に理解されておらず、いくつかの欠点もあります。

* 非常に単純なテスト問題で、収束しないこともあります。
* 汎化誤差を与えるとよく言われています。ニューラルネットワークが訓練用データに対して誤差を達成した場合、まだみたことない他のデータ点で訓練された損失はゼロになりません。特に画像の問題で、SGDを使用した場合よりも汎化誤差が悪化することがよくあります。より悪化する要因としては、ADAMが最も近い極小値を見つけること、ノイズの減少、またはその構造などが可能性として挙げられます。
* ADAMでは3つのバッファーを維持する必要がありますが、SGDでは2つのバッファーが必要です。数ＧＢのサイズのモデルを訓練しない限り、これは実応用上は問題がありません。かえって、モデルはメモリに収まらない可能性があります。
* 1つではなく2つのモメンタムパラメータを調整する必要があります。

<!-- ## [Normalization layers](https://www.youtube.com/watch?v=--NZb480zlg&t=3907s)

Rather than improving the optimization algorithms, *normalization layers* improve the network structure itself. They are additional layers in between existing layers. The goal is to improve the optimization and generalization performance.

In neural networks, we typically alternate linear operations with non-linear operations. The non-linear operations are also known as activation functions, such as ReLU. We can place normalization layers before the linear layers, or after the activation functions. The most common practice is to put them between the linear layers and activation functions, as in the figure below.　-->

## [正規化層](https://www.youtube.com/watch?v=--NZb480zlg&t=3907s)
最適化アルゴリズムを改善するより、*正規化層*はネットワーク構造自体も改善できます。 これらは、既存の層の間に追加される層です。 目標は、最適化と汎化のパフォーマンスを向上させることです。

ニューラルネットワークでは、通常、線性演算と非線性演算を交互に計算します。 非線形演算は、ReLUなどの活性化関数としてもよく知られています。 正規化層は、線形層の前、または活性化関数の後に配置できます。 最もよく行われる方法は、次の図のように、線形層と活性化関数の間に正規化層を配置することです。

| <center><img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_layer_a.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_layer_b.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_layer_c.png" width="225px"/></center> |
<!-- | (a) 正規化を追加する前                              |                (b) 正規化を追加した後                |                    (c) CNNの例                    | -->
(a) 正規化層を加えた前
(b) 正規化層を加えた後
(c) 畳み込みの例

<center><b>図3:</b> 正規化層の一般的な位置</center>
<!-- 正規化層と一般的な置きかた -->

<!-- In figure 3(c), the convolution is the linear layer, followed by batch normalization, followed by ReLU.　-->
図3（c）では、畳み込みは線形層であり、その後にバッチ正規化がつながり、その後にReLUが続きます。


<!-- Note that the normalization layers affect the data that flows through, but they don't change the power of the network in the sense that, with proper configuration of the weights, the unnormalized network can still give the same output as a normalized network. -->
正規化層はネットワークを流れるデータに影響を与えますが、重みを適切に設定していれば、正規化されていないネットワークでも正規化されたネットワークと同じ出力を依然として出すことができるという意味で、正規化はネットワークの表現力を変化させることはありません。


<!-- ### Normalization operations
正規化層の操作

This is the generic notation for normalization:
これは正規化に使用した符号：

$$
y = \frac{a}{\sigma}(x - \mu) + b
$$

<!-- where $x$ is the input vector, $y$ is the output vector, $\mu$ is the estimate of the mean of $x$, $\sigma$ is the estimate of the standard deviation (std) of $x$, $a$ is the learnable scaling factor, and $b$ is the learnable bias term. -->
ここで、$x$は入力ベクトル、$y$は出力ベクトル、$\mu$は$x$の平均の推定値、$\sigma$は$x$の標準偏差（std）の推定値です。 、$a$は学習可能なスケーリング係数であり、$b$は学習可能なバイアス項です。

<!-- Without the learnable parameters $a$ and $b$, the distribution of output vector $y$ will have fixed mean 0 and std 1. The scaling factor $a$ and bias term $b$ maintain the representation power of the network,*i.e.*the output values can still be over any particular range. Note that $a$ and $b$ do not reverse the normalization, because they are learnable parameters and are much more stable than $\mu$ and $\sigma$. -->

学習可能パラメーターである$a$と$b$がない場合、出力ベクトル$y$の分布は平均0標準偏差値1に固定されます。スケーリング係数$a$とバイアス項$b$は、ネットワークの表現力は維持できます。つまり、出力値は特定の範囲を超える可能性があります。$a$と$b$は学習可能なパラメーターであり、$\mu$と$\sigma$よりもはるかに安定しているため、正規化を逆算できないことを注意してください。


<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_operations.png"/><br>
<b>図4:</b> 正規化の操作の詳細
</center>

<!-- There are several ways to normalize the input vector, based on how to select samples for normalization. Figure 4 lists 4 different normalization approaches, for a mini-batch of $N$ images of height $H$ and width $W$, with $C$ channels:

- *Batch norm*: the normalization is applied only over one channel of the input. This is the first proposed and the most well-known approach. Please read [How to Train Your ResNet 7: Batch Norm](https://myrtle.ai/learn/how-to-train-your-resnet-7-batch-norm/) for more information.
- *Layer norm*: the normalization is applied within one image across all channels.
- *Instance norm*: the normalization is applied only over one image and one channel.
- *Group norm*: the normalization is applied over one image but across a number of channels. For example, channel 0 to 9 is a group, then channel 10 to 19 is another group, and so on. In practice, the group size is almost always 32. This is the approach recommended by Aaron Defazio, since it has good performance in practice and it does not conflict with SGD.

In practice, batch norm and group norm work well for computer vision problems, while layer norm and instance norm are heavily used for language problems.

There are several ways to normalize the input vector, based on how to select samples for normalization. Figure 4 lists 4 different normalization approaches, for a mini-batch of $N$ images of height $H$ and width $W$, with $C$ channels:

- *Batch norm*: the normalization is applied only over one channel of the input. This is the first proposed and the most well-known approach. Please read [How to Train Your ResNet 7: Batch Norm](https://myrtle.ai/learn/how-to-train-your-resnet-7-batch-norm/) for more information.
- *Layer norm*: the normalization is applied within one image across all channels.
- *Instance norm*: the normalization is applied only over one image and one channel.
- *Group norm*: the normalization is applied over one image but across a number of channels. For example, channel 0 to 9 is a group, then channel 10 to 19 is another group, and so on. In practice, the group size is almost always 32. This is the approach recommended by Aaron Defazio, since it has good performance in practice and it does not conflict with SGD.

In practice, batch norm and group norm work well for computer vision problems, while layer norm and instance norm are heavily used for language problems. -->

正規化をしようとするサンプルの選択方法に基づいて、入力ベクトルを正規化する方法はいくつかあります。
図4は、高さ$H$と幅さ$W$でチャネル数の$C$ミニバッチ数$N$の画像の4つの異なる正規化アプローチを示しています。

- *バッチ正規化*：正規化が入力の1つのチャネルにのみ適用されます。これは最初に提案されたよく知られているアプローチです。詳細は[ResNet 7の訓練方法：バッチノルム](https://myrtle.ai/learn/how-to-train-your-resnet-7-batch-norm/)を読んでください。
- *レイヤー正規化*：正規化がすべてのチャネルの1つの画像内に適用されます。
- *インスタンス正規化*：正規化が1つの画像と1つのチャネルにのみ適用されます。
- *グループ正規化*：正規化が1つの画像の多数のチャネルに適用されます。たとえば、チャネル0〜9はひとまとまりのグループであり、チャネル10〜19は別のグループです。実応用上は、グループサイズは32によく設定されます。これは、実際には優れたパフォーマンスを発揮し、SGDと競合しないため、Aaron Defazioが推奨するアプローチです。

実際には、バッチ正規化とグループ正規化はコンピュータビジョンの問題によく使われ、レイヤー正規化とインスタンス正規化は言語の問題によく使用されます。


<!-- ### Why does normalization help?

Although normalization works well in practice, the reasons behind its effectiveness are still disputed. Originally, normalization is proposed to reduce "internal covariate shift", but some scholars proved it wrong in experiments. Nevertheless, normalization clearly has a combination of the following factors:

- Networks with normalization layers are easier to optimize, allowing for the use of larger learning rates. Normalization has an optimization effect that speeds up the training of neural networks.
- The mean/std estimates are noisy due to the randomness of the samples in batch. This extra "noise" results in better generalization in some cases. Normalization has a regularization effect.
- Normalization reduces sensitivity to weight initialization.

As a result, normalization lets you be more "careless" -- you can combine almost any neural network building blocks together and have a good chance of training it without having to consider how poorly conditioned it might be. -->
### 正規化が役立つのはなぜですか？

正規化は実際にはうまく機能しますが、その有効性があるかどうかについてはまだ議論があります。もともとは、正規化は「内部共変量シフト」を減らすための提案でしたが、一部の学者は実験でそれが間違っていることを証明しました。にもかかわらず、正規化では明らかに次のいくつの要素が組み合わされています。

- 正規化層を備えたネットワークは最適化がより容易になり、より大きな学習率を使用できます。これによって、ニューラルネットワークの訓練を高速化する最適化効果があります。
- バッチ内のサンプルのランダム性のため、平均/標準推定値にノイズがあります。この余分な「ノイズ」により、場合によってはモデル汎化性能がよくなります。正規化には正則化効果があります。
- 正規化により、重みの初期化に対する感知度が低下します。

その結果、正規化により、もっと「注意深くならなくてよく」なります。つまり、条件がいかに悪いかを考慮せずとも　ほとんどすべてのニューラルネットワークのビルディングブロックスが組み合わせて高い訓練性を得ることができるのです。


<!-- ### Practical considerations

It’s important that back-propagation is done through the calculation of the mean and std, as well as the application of the normalization: the network training will diverge otherwise. The back-propagation calculation is fairly difficult and error-prone, but PyTorch is able to automatically calculate it for us, which is very helpful. Two normalization layer classes in PyTorch are listed below:

```python
torch.nn.BatchNorm2d(num_features, ...)
torch.nn.GroupNorm(num_groups, num_channels, ...)
```

Batch norm was the first method developed and is the most widely known. However, **Aaron Defazio recommends using group norm** instead. It’s more stable, theoretically simpler, and usually works better. Group size 32 is a good default.

Note that for batch norm and instance norm, the mean/std used are fixed after training, rather than re-computed every time the network is evaluated, because multiple training samples are needed to perform normalization. This is not necessary for group norm and layer norm, since their normalization is over only one training sample.


## [The Death of Optimization](https://www.youtube.com/watch?v=--NZb480zlg&t=4817s)

Sometimes we can barge into a field we know nothing about and improve how they are currently implementing things. One such example is the use of deep neural networks in the field of Magnetic Resonance Imaging (MRI) to accelerate MRI image reconstruction.　-->
### 実用上考慮すべき点

正規化の適用に加えて、平均と標準偏差計算した上でバックプロパゲーションを行うというのが重要です。そうしなければ、訓練が発散してしまうからです。バックプロパゲーションの計算はかなり難しく、エラーが発生しやすくなりますが、PyTorchは自動的に計算できるため、非常に役立ちます。 PyTorchの2つの正規化層クラスを以下に示します。

```python
torch.nn.BatchNorm2d（num_features、...）
torch.nn.GroupNorm（num_groups、num_channels、...）
```

バッチ正規化は最初に開発された方法であり、最もよく知られていますが、**Aaron Defazio（講師）は、代わりにグループ正規化**を使用することをお勧めします。より安定していて、理論的には単純で、よく効くといわれています。グループサイズ32が適切な初期値でよいでしょう。

バッチ正規化とインスタンス正規化の場合、複数の訓練サンプルを正規化するため、訓練したあと使用される平均/標準偏差はネットワークが評価されるたびに再計算されるのではなく定数となります。それに対して、グループ正規化とレイヤー正規化は単一サンプルで正規化されるため必要ありません。


## [最適化の死]（https://www.youtube.com/watch?v=-NZb480zlg&t=4817s）

時々、自分が何も知らない業界に入り込んで、そこ現在やっていることを改善することができます。そのような例の1つは、磁気共鳴画像法（MRI）の画像の再構成を加速するためのディープニューラルネットワークの使用です。


<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_conv_xkcd.png" style="zoom:60%"><br>
<b>図5:</b> うまくいくことがある！
</center>


<!-- ### MRI Reconstruction

In the traditional MRI reconstruction problem, raw data is taken from an MRI machine and an image is reconstructed from it using a simple pipeline/algorithm. MRI machines capture data in a 2-dimensional Fourier domain, one row or one column at a time (every few milliseconds). This raw input is composed of a frequency and a phase channel and the value represents the magnitude of a sine wave with that particular frequency and phase. Simply speaking, it can be thought of as a complex valued image, having a real and an imaginary channel. If we apply an inverse Fourier transform on this input, i.e add together all these sine waves weighted by their values, we can get the original anatomical image. -->
### 磁気共鳴画像(MRI)再構成

従来のMRI再構成問題では、生データがMRI装置から取得され、単純なパイプライン/アルゴリズムを使用して画像が再構成されます。 MRI装置は、1行または1列を数ミリ秒ごとに2次元フーリエドメインでデータを取得します。この生データは周波数と位相チャネルにある各自のサイン波の幅から構成されています。簡単に言えば、それは実数と虚数のチャネルを同時に持つ複素数の画像のことです。この入力に逆フーリエ変換を適用すると、つまり、サイン波の値の重みを合計すると、元の解剖学的画像を取得することができます。


<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_mri.png" style="zoom:60%"/><br>
<b>図6:</b> MRIの再構成
</center><br>

<!-- 
A linear mapping currently exists to go from the Fourier domain to the image domain and it's very efficient, literally taking milliseconds, no matter how big the image is. But the question is, can we do it even faster?


### Accelerated MRI

The new problem that needs to be solved is accelerated MRI, where by acceleration we mean making the MRI reconstruction process much faster. We want to run the machines quicker and still be able to produce identical quality images. One way we can do this and the most successful way so far has been to not capture all the columns from the MRI scan. We can skip some columns randomly, though it's useful in practice to capture the middle columns, as they contain a lot of information across the image, but outside them we just capture randomly. The problem is that we can't use our linear mapping anymore to reconstruct the image. The rightmost image in Figure 7 shows the output of a linear mapping applied to the subsampled Fourier space. It's clear that this method doesn't give us very useful outputs, and that there's room to do something a little bit more intelligent. -->
現在、画像の大きさを問わず、フーリエ領域から画像領域に移動するための線形写像が存在しますが、これは非常に効率的です。文字通り数ミリ秒以内で行われます。しかし、これはより速く生成できるのか問題です。


### 生成加速化MRI

解決する問題は加速MRIです。加速というのは、MRI再構成プロセスをどうやって高速化にするのかです。マシンをより高速に運行し、それでもほぼ同じ品質の画像を生成できるようにしたいと考えています。1つの方法であり、またこれまで最も成功した方法は、MRIスキャンからすべての列をキャプチャしないという考えでした。そこでは、画像のいくつかのランダムにスキップすのですが、画像の真ん中に多くの情報が含まれているため、これは実用上は役に立ちます。しかしそうすると、問題として、線形写像で画像を再構築するのはできなくなってしまいます。図7の右端の画像は、サブサンプリングされたフーリエ空間に適用された線形写像の出力を示しています。ここからわかるように、この方法ではあまり有用な出力量が得られません。明らかにもう少し賢くやって改善する余地がありそうです。


<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_acc_mri.png" style="zoom:45%"><br>
<b>図7:</b> サブサンプルされたフーリエ空間上の線形写像
</center><br>


<!-- ### Compressed sensing

One of the biggest breakthroughs in theoretical mathematics for a long time was compressed sensing. A paper by <a href="https://arxiv.org/pdf/math/0503066.pdf">Candes et al.</a> showed that theoretically, we can get a perfect reconstruction from the subsampled Fourier-domain image. In other words, when the signal we are trying to reconstruct is sparse or sparsely structured, then it is possible to perfectly reconstruct it from fewer measurements. But there are some practical requirements for this to work -- we don't need to sample randomly, rather we need to sample incoherently -- though in practice, people just end up sampling randomly. Additionally, it takes the same time to sample a full column or half a column, so in practice we also sample entire columns.

Another condition is that we need to have *sparsity* in our image, where by sparsity we mean a lot of zeros or black pixels in the image. The raw input can be represented sparsely if we do a wavelength decomposition, but even this decomposition gives us an approximately sparse and not an exactly sparse image. So, this approach gives us a pretty good but not perfect reconstruction, as we can see in Figure 8. However, if the input were very sparse in the wavelength domain, then we would definitely get a perfect image. -->
### 圧縮センシング

理論数学における最大の進歩の1つは、圧縮センシングでした。 <a href="https://arxiv.org/pdf/math/0503066.pdf"> Candes et al。</a>この論文は、理論的には、サブサンプリングされたフーリエドメインの画像から完全な再構成を取得できることを示しています。言い換えると、再構成しようとしている画像がスパースまたはスパースな構造である場合、より少ない数値で完全に再構築することが可能であるということです。しかし、これが効くためいくつかの実用上の制約があります。具体的には、ランダムサンプリングする必要はなく、まとまってないようにサンプリングする必要があります。実際には、ランダムにサンプリングされている場合が多いですが。さらに、列の全体ををサンプリングする時間はその列の半分と同じくらいかかるので、実際には列全体もサンプリングします。

もう1つの条件は、画像に*スパース性*が必要であるということです。スパース性とは、画像内に多数のゼロの値または黒いピクセルがあることを意味します。波長分解を行うと、生の入力はスパースに表現できるようになります。しかし、この分解でも、正確にきっちりとしたスパースな画像ではなく、ほぼスパースなものになります。したがって、このアプローチでは、図8に示すように、完全に再構成されないもののかなり良い程度の再構成が得られます。ただし、波長ドメインに見えた入力データが非常にスパースであるなら、間違いなく完全な再構成画像が得られます。

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_comp_sensing.png" style="zoom:50%"><br>
<b>図8: </b>圧縮センシング
</center><br>

<!-- Compressed sensing is based on the theory of optimization. The way we can get this reconstruction is by solving a mini-optimization problem which has an additional regularization term: -->
圧縮センシングの原理は、最適化の理論に基づいた方法です。 この再構成を取得する方法は、正則化項が追加された小さな最適化問題を解くことです。

$$
\hat{x} = \arg\min_x \frac{1}{2} \Vert M (\mathcal{F}(x)) - y \Vert^2 + \lambda TV(x)
$$

<!-- where $M$ is the mask function that zeros out non-sampled entries, $\mathcal{F}$ is the Fourier transform, $y$ is the observed Fourier-domain data, $\lambda$ is the regularization penalty strength, and $V$ is the regularization function.

The optimization problem must be solved for each time step or each "slice" in an MRI scan, which often takes much longer than the scan itself. This gives us another reason to find something better. -->
ここで、$M$はサンプリングされていないデータを排除するマスク関数、$\mathcal{F}$はフーリエ変換、$y$はフーリエで変換されたデータ、$\lambda$は正則化ペナルティ係数、 $V$は正則化関数です。

よってこの最適化問題は、MRIスキャンのタイムステップごとに、または各「スライス」されたタイムごとに対して解かれなければなりません。これは、MRI自体のスキャンタイムより長い時間がかかることになります。この制約が、より良い方法を見つける理由になっています。

<!-- ### Who needs optimization?

Instead of solving the little optimization problem at every time step, why not use a big neural network to produce the required solution directly? Our hope is that we can train a neural network with sufficient complexity that it essentially solves the optimization problem in one step and produces an output that is as good as the solution obtained from solving the optimization problem at each time step. -->
### 最適化はいつ必要なんですか？

各タイムステップで小さな最適化問題を解く代わりに、大きなニューラルネットワークを使用して解決するほうがいいんじゃないですか？という質問がわいてくるかもしれません。各タイムステップで最適化問題を解くことより十分な複雑さでニューラルネットワークを訓練して最適化問題を1つのステップで本質的に解決できるのは得だからです。


$$
\hat{x} = B(y)
$$

<!-- where $B$ is our deep learning model and $y$ is the observed Fourier-domain data.

15 years ago, this approach was difficult -- but nowadays this is a lot easier to implement. Figure 9 shows the result of a deep learning approach to this problem and we can see that the output is much better than the compressed sensing approach and looks very similar to the actual scan. -->
ここで、$B$は深層学習モデルであり、$y$はフーリエ変換されたデータです。

15年前は、このアプローチは困難でしたが、現在では、これを導入する方が簡単になります。 図9は、この問題に対する深層学習アプローチの結果を示しています。出力は圧縮センシングアプローチよりとても優れており、実際のスキャンと非常によく似ていることがわかります。

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_dl_approach.png" style="zoom:60%"><br>
<b>図9: </b>深層学習のアプローチ
</center><br>

<!-- The model used to generate this reconstruction uses an ADAM optimizer, group-norm normalization layers, and a U-Net based convolutional neural network. Such an approach is very close to practical applications and we will hopefully be seeing these accelerated MRI scans happening in clinical practice in a few years' time.
-->
この再構成の生成に使用されるモデルは、ADAMオプティマイザー、グループ正規化層、およびU-Netベースの畳み込みニューラルネットワークの組み合わせです。このようなアプローチは実際の応用の環境に非常に近く、このような加速されたMRIスキャンが数年以内に臨床診療で行われることを期待しています。
