---
lang-ref: ch.05-1
title: Optimisation Techniques I
title: 最適化テクニックI
lecturer: Aaron Defazio
authors: Vaibhav Gupta, Himani Shah, Gowri Addepalli, Lakshmi Addepalli
date: 24 Feb 2020
lang: ja
translation-date: 10 Sep 2020
translator: Jesmer Wong
---


<!-- ## [Gradient descent](https://www.youtube.com/watch?v=--NZb480zlg&t=88s) -->
## [勾配降下法](https://www.youtube.com/watch?v=--NZb480zlg&t=88s)

<!-- We start our study of Optimization Methods with the most basic and the worst (reasoning to follow) method of the lot, Gradient Descent.　-->
いろんな方法がありますが、その中で最も基本的だけれど最悪の（下記に説明する）方法である勾配降下法から、最適化手法の勉強を始めたいと思います。

<!-- **Problem:** -->
問題

$$
\min_w f(w)
$$

<!-- **Iterative Solution:**　-->
**反復解法：**

$$
w_{k+1} = w_k - \gamma_k \nabla f(w_k)
$$

<!-- where,
 - $w_{k+1}$ is the updated value after the $k$-th iteration,
 - $w_k$ is the initial value before the $k$-th iteration,
 - $\gamma_k$ is the step size,
 - $\nabla f(w_k)$ is the gradient of $f$. -->
 上記の
 - $w_{k+1}$は $k$-回の繰り返しで更新された値、
 - $w_k$は　$k$-回の更新する前の初期値、
 - $\gamma_k$はステップサイズ、
 - $\nabla f(w_k)$は$f$の勾配。


<!-- The assumption here is that the function $f$ is continuous and differentiable. Our aim is to find the lowest point (valley) of the optimization function. However, the actual direction to this valley is not known. We can only look locally, and therefore the direction of the negative gradient is the best information that we have. Taking a small step in that direction can only take us closer to the minimum. Once we have taken the small step, we again compute the new gradient and again move a small amount in that direction, till we reach the valley. Therefore, essentially all that the gradient descent is doing is following the direction of steepest descent (negative gradient).　-->

ここでの前提は、関数$f$が連続的で微分可能であることです。
目的は、最適化関数の最低点（谷）を見つけることです。 ただし、この谷への実際の方向は不明です。
局所的に探ることしかできないため、負の勾配が私達が手に入れられる最適な情報です。
その方向に小さいステップサイズで進んで、近づいていくだけです。 小さな一歩を踏み出してから、再び新しい勾配を計算し、谷に到達するまでその方向に少しだけ移動します。 すると、本質的に勾配降下法が行っているのは、最も急な降下（負の勾配）の方向に向かうことだけです。


<!-- The $\gamma$ parameter in the iterative update equation is called the **step size**. Generally we don't know the value of the optimal step-size; so we have to try different values. Standard practice is to try a bunch of values on a log-scale and then use the best one. There are a few different scenarios that can occur. The image above depicts these scenarios for a 1D quadratic. If the learning rate is too low, then we would make steady progress towards the minimum. However, this might take more time than what is ideal. It is generally very difficult (or impossible) to get a step-size that would directly take us to the minimum. What we would ideally want is to have a step-size a little larger than the optimal. In practice, this gives the quickest convergence. However, if we use too large a learning rate, then the iterates get further and further away from the minima and we get divergence. In practice, we would want to use a learning rate that is just a little less than diverging.　-->

反復更新におけるこのパラメーター$\gamma$は、**ステップサイズ**と呼ばれます。 最適なステップサイズの値は一般にわかりませんので、いろんな値を試す必要があります。 標準的な方法は、対数スケールで一連の値を試してから、最適な値を採用することです。

いくつかのシナリオが発生する可能性があります。上の画像は、パラメータが１次元の2次関数でのこれらのシナリオを示しています。 学習率が低すぎる場合、確実に最小値に進めますが、訓練時間が予想よりかなりかかる場合があります。

一般に、直接最小値に到達するステップサイズを選択することは非常に困難（または不可能）です。
このステップサイズという値は、最適値より少し大きいにするのが理想的です。
そうすると、実応用上は最も速く収束することができます。
逆に、学習率が大きすぎると、反復更新によって最小値から遠ざかり、発散してしまいます。
よって、学習率は発散するよりも少し小さいもの選択します。




<center>
<img src="{{site.baseurl}}/images/week05/05-1/step-size.png" style="zoom: 70%; background-color:#DCDCDC;" /><br>
<!-- <b>Figure 1:</b> Step sizes for 1D Quadratic -->
<b>図１:</b> 1次元の2次関数に対するステップサイズ
</center>


<!-- ## [Stochastic gradient descent](https://www.youtube.com/watch?v=--NZb480zlg&t=898s) -->
## [確率的勾配降下法](https://www.youtube.com/watch?v=--NZb480zlg&t=898s)


<!-- In Stochastic Gradient Descent, we replace the actual gradient vector with a stochastic estimation of the gradient vector. Specifically for a neural network, the stochastic estimation means the gradient of the loss for a single data point (single instance).　-->
確率的勾配降下法では、実際の勾配ベクトルより確率的に推定された勾配ベクトルで計算します。 特にニューラルネットワークの場合、確率的推定とは、単一のデータ点（単一のインスタンス）での損失の勾配のことです。

<!-- Let $f_i$ denote the loss of the network for the $i$-th instance.　-->
$f_i$はニューラルネットワークの第$i$個のインスタンスの損失関数のことで、

$$
f_i = l(x_i, y_i, w)
$$

<!-- The function that we eventually want to minimize is $f$, the total loss over all instances. -->
<!-- この$f$はすべてのインスタンスの合計損失であり、目標として最小化させたいのことです。 -->
最終的に最小化したい関数は、全てのインスタンスについての全体の損失である$f$です。

$$
f = \frac{1}{n}\sum_i^n f_i
$$

<!-- In SGD, we update the weights according to the gradient over $f_i$ (as opposed to the gradient over the total loss $f$).　-->
確率的勾配降下法(SGD)では、$f_i$の勾配によって重みを更新します（総損失$f$の勾配で更新することではありません。）

$$
\begin{aligned}
w_{k+1} &= w_k - \gamma_k \nabla f_i(w_k) & \quad\text{(i は一様にランダムに選ばれる)}
\end{aligned}
$$

<!-- If $i$ is chosen randomly, then $f_i$ is a noisy but unbiased estimator of $f$, which is mathematically written as: -->
$i$がランダムに選択された場合、$f_i$はノイズが多いものの、$f$の不偏推定量となります。これは数学的に次のように記述されます。

$$
\mathbb{E}[\nabla f_i(w_k)] = \nabla f(w_k)
$$

<!-- As a result of this, the expected $k$-th step of SGD is the same as the $k$-th step of full gradient descent: -->
これで、SGDの第$k$番目のステップの期待値は、フル勾配降下法の$k$番目のステップと同じになります。

$$
\mathbb{E}[w_{k+1}] = w_k - \gamma_k \mathbb{E}[\nabla f_i(w_k)] = w_k - \gamma_k \nabla f(w_k)
$$

<!-- Thus, any SGD update is the same as full-batch update in expectation. However, SGD is not just faster gradient descent with noise. Along with being faster, SGD can also get us better results than full-batch gradient descent. The noise in SGD can help us avoid the shallow local minima and find a better (deeper) minima. This phenomenon is called **annealing**.　-->
よって、SGDの更新は、フルバッチ更新と期待値の意味で同じです。 ただし、SGDは、単なるノイズを伴う勾配降下法ではありません。 SGDは高速であるだけでなく、フルバッチ勾配降下法よりも優れた結果を得ることができます。 SGDのノイズの部分は、浅い極小値を回避し、より良い（より深い）グローバルな最小値を見つけるのに役立ちます。 この現象は**アニーリング**と呼ばれます。


<center>
<img src="{{site.baseurl}}/images/week05/05-1/annealing.png"/><br>
<b>図2:</b> SGDによるアニーリング
</center>

<!-- In summary, the advantages of Stochastic Gradient Descent are as follows:

 1. There is a lot of redundant information across instances. SGD prevents a lot of these redundant computations.
 2. At early stages, the noise is small as compared to the information in the gradient. Therefore a SGD step is *virtually as good as* a GD step.
 3. *Annealing* - The noise in SGD update can prevent convergence to a bad(shallow) local minima.
 4. Stochastic Gradient Descent is drastically cheaper to compute (as you don't go over all data points).　-->
要約すると、確率的勾配降下法(SGD)の利点は次のとおりです。

  1. インスタンス間に多くの冗長な情報があります。 SGDは、これらの冗長な計算の多くを防ぎます。
  2. 初期段階では、勾配の情報と比較してノイズは小さいです。 したがって、SGDステップの降り方は普通の勾配降下法(GD)のステップと*ほぼ同じ*です。
  3. *アニーリング：* SGD更新のノイズにより、（浅い）グローバルではない極小値への収束が妨げられる可能性があります。
  4. 確率的勾配降下法は、計算量を大幅に削減できます（すべてのデータ点で計算しないため）。


<!-- ### Mini-batching -->

<!-- In mini-batching, we consider the loss over multiple randomly selected instances instead of calculating it over just one instance. This reduces the noise in the step update.　-->
### ミニバッチ処理
ミニバッチ処理では、1つのインスタンスだけで計算するのではなく、ランダムに選択された複数のインスタンスでの損失を考慮します。 これにより、ステップ更新に伴うノイズが減少します。

$$
w_{k+1} = w_k - \gamma_k \frac{1}{|B_i|} \sum_{j \in B_i}\nabla f_j(w_k)
$$

<!-- Often we are able to make better use of our hardware by using mini batches instead of a single instance. For example, GPUs are poorly utilized when we use single instance training. Distributed network training techniques split a large mini-batch between the machines of a cluster and then aggregate the resulting gradients. Facebook recently trained a network on ImageNet data within an hour, using distributed training.-->
単一のインスタンスの代わりにミニバッチを使用することで、多くの場合ハードウェアをより有効活用できます。 たとえば、単一のインスタンスで訓練する場合、GPUを十分に活用することができません。 分散ネットワークで訓練するという技術では、マシンの大きなクラスターの間に大きなミニバッチを分割し、結果の勾配を集計します。 Facebookは最近、分散学習を使用して、1時間以内にImageNetデータでネットワークを訓練しました。


<!-- It is important to note that Gradient Descent should never be used with full sized batches. In case you want to train on the full batch-size, use an optimization technique called LBFGS. PyTorch and SciPy both provide implementations of this technique. -->
勾配降下法をフルバッチで使用してはならないことに注意することが重要です。 フルバッチサイズで訓練する場合は、LBFGSと呼ばれる最適化手法がおすすめです。 PyTorchとSciPyはどちらも、この手法の実装を提供しています。

<!-- ## [Momentum](https://www.youtube.com/watch?v=--NZb480zlg&t=1672s)

<!-- In Momentum, we have two iterates ($p$ and $w$) instead of just one. The updates are as follows: -->
## [モメンタム](https://www.youtube.com/watch?v=--NZb480zlg&t=1672s)
モメンタムでは、更新パラメータは1個ではなく２個（$p$と$w$）あります。 更新式は次のとおりです。

$$
\begin{aligned}
p_{k+1} &= \hat{\beta_k}p_k + \nabla f_i(w_k) \\
w_{k+1} &=  w_k - \gamma_kp_{k+1} \\
\end{aligned}
$$

<!-- $p$ is called the SGD momentum. At each update step we add the stochastic gradient to the old value of the momentum, after dampening it by a factor $\beta$ (value between 0 and 1). $p$ can be thought of as a running average of the gradients. Finally we move $w$ in the direction of the new momentum $p$.　-->
$p$はSGDモメンタムと呼ばれます。 各更新ステップで、係数$\beta$（0から1の間の値）によって衰減させてから、確率的勾配を古いモメンタムに追加します。 $p$は、勾配の移動平均値と考えることができるでしょう。 最後に、$w$を新しいモメンタム$p$の方向に移動します。

<!-- Alternate Form: Stochastic Heavy Ball Method -->
代替形式：確率的ヘビーボール法

$$
\begin{aligned}
w_{k+1} &= w_k - \gamma_k\nabla f_i(w_k) + \beta_k(w_k - w_{k-1}) & 0 \leq \beta < 1
\end{aligned}
$$

<!-- This form is mathematically equivalent to the previous form. Here, the next step is a combination of previous step's direction ($w_k - w_{k-1}$) and the new negative gradient. -->
この形式は、前の形式と数学的に等価です。 ここで、次のステップは、前のステップの方向（$w_k - w_{k-1}$）と新しい負の勾配の組み合わせです。


<!-- ### Intuition

<!-- SGD Momentum is similar to the concept of momentum in physics. The optimization process resembles a heavy ball rolling down the hill. Momentum keeps the ball moving in the same direction that it is already moving in. Gradient can be thought of as a force pushing the ball in some other direction.　-->

### 直観

SGDのモメンタムは、物理学におけるモメンタムの概念に似ています。 最適化プロセスは、重いボールを丘に転がすことと似ています。 モメンタムは、ボールがすでに移動しているのと同じ方向に移動し続けるようにしています。勾配は、ボールを他の方向に押す力と考えることもできるでしょう。

<center>
<img src="{{site.baseurl}}/images/week05/05-1/momentum.png"/><br>
<b>図3:</b> モメンタムの効果<br>
<b>ソース:</b><a href="https://distill.pub/2017/momentum/" target="_blank"> distill.pub </a><br>
</center>

<!-- Rather than making dramatic changes in the direction of travel (as in the figure on the left), momentum makes modest changes. Momentum dampens the oscillations which are common when we use only SGD.　-->
（左の図のように）進行方向を激しく変更するのではなく、モメンタムは適度に変更を行います。 モメンタムは、SGDのみを使用する場合に一般に生じる振動を衰減させます。

<!-- The $\beta$ parameter is called the Dampening Factor. $\beta$ has to be greater than zero, because if it is equal to zero, you are just doing gradient descent. It also has to be less than 1, otherwise everything will blow up. Smaller values of $\beta$ result in change in direction quicker. For larger values, it takes longer to make turns.　-->
パラメーター$\beta$は衰減量と呼ばれます。 $\beta$はゼロより大きくなければなりません。ゼロの場合は、GDと同じだからです。 また、1未満である必要があります。そうでない場合、すべてが発散してしまいます。 $\beta$の値が小さいほど、方向の変更が速くなります。 値が大きいほど、ターンするのに時間がかかります。

<center>
<img src="{{site.baseurl}}/images/week05/05-1/momentum-beta.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>図4:</b> βが収束に与える影響
</center>


<!-- ### Practical guidelines

<!-- Momentum must pretty much be always be used with stochastic gradient descent.
$\beta$ = 0.9 or 0.99 almost always works well.

<!-- The step size parameter usually needs to be decreased when the momentum parameter is increased to maintain convergence. If $\beta$ changes from 0.9 to 0.99, learning rate must be decreased by a factor of 10. -->
### 実用上のガイドライン

モメンタムは、確率的勾配降下法で常に使用する必要があります。
$\beta$ = 0.9または0.99はほとんどの場合うまくいきます。

収束を維持するため、モメンタムパラメータを増やす一方、ステップサイズパラメータを減らす必要があります。 $\beta$が0.9から0.99に変更された場合、学習率を10分の1に減らす必要があります。


<!-- ### Why does momentum works? -->
### なぜモメンタムはうまくいくのか

<!-- #### Acceleration -->
#### 加速度

<!-- The following are the update rules for Nesterov's momentum.　-->
以下は、ネステロフのモメンタムの更新則です。

$$
p_{k+1} = \hat{\beta_k}p_k + \nabla f_i(w_k) \\
w_{k+1} =  w_k - \gamma_k(\nabla f_i(w_k) +\hat{\beta_k}p_{k+1})
$$

<!-- With Nesterov's Momentum, you can get accelerated convergence if you choose the constants very carefully. But this applies only to convex problems and not to Neural Networks.　-->
ネステロフのモメンタムは，定数を慎重に選択すると、収束を加速できます。 ただし、これは凸最適化問題にのみ適用され、ニューラルネットワークには適用されません。

<!-- Many people say that normal momentum is also an accelerated method. But in reality, it is accelerated only for quadratics. Also, acceleration does not work well with SGD, as SGD has noise and acceleration does not work well with noise. Therefore, though some bit of acceleration is present with Momentum SGD, it alone is not a good explanation for the high performance of the technique. -->
通常のモメンタムも加速された方法と言われていますが、実際には、二次関数に対して加速されるのみです。 また、SGDにはノイズがあり、加速はノイズではうまく機能しないため、加速はSGDではうまく機能しません。 したがって、モメンタムSGDには多少の加速がありますが、それだけでは、この手法の高性能を説明するのに適していません。


<!-- #### Noise smoothing
ノイズ平滑化

<!-- Probably a more practical and probable reason to why momentum works is Noise Smoothing.　-->
おそらく、より実際的でありうるあるモメンタムがうまくいく理由は、ノイズ平滑化です。


<!-- Momentum averages gradients. It is a running average of gradients that we use for each step update.　-->
モメンタムは勾配を平均します。 これは、各ステップの更新に使用する勾配の移動平均です。

<!-- Theoretically, for SGD to work we should take average over all step updates. -->
理論的には、SGDをうまく動かすには、すべてのステップの更新を平均する必要があります。

$$
\bar w_k = \frac{1}{K} \sum_{k=1}^K w_k
$$

<!-- The great thing about SGD with momentum is that this averaging is no longer necessary. Momentum adds smoothing to the optimization process, which makes each update a good approximation to the solution. With SGD you would want to average a whole bunch of updates and then take a step in that direction.　-->
モメンタムを用いたSGDの優れている点は、この平均化が不要になったことです。 モメンタムは、最適化プロセスに平滑化を追加します。これにより、各更新が解の適切な近似になります。 SGDを使用すると、一連の更新を平均して、その方向に一歩踏み出すことができます。

<!-- Both Acceleration and Noise smoothing contribute to high performance of momentum.　-->
加速とノイズ平滑化のおかげでモメンタムは高性能になっています。

<center>
<img src="{{site.baseurl}}/images/week05/05-1/sgd-vs-momentum.png" style="zoom: 35%; background-color:#DCDCDC;"/><br>
<b>Figure 5:</b> SGD <i>vs.</i> Momentum
</center>

<!-- With SGD, we make good progress towards solution initially but when we reach bowl (bottom of the valley) we bounce around in this floor. If we adjust learning rate we will bounce around slower. With momentum we smooth out the steps, so that there is no bouncing around. -->
SGDの場合、最初は解に向かって順調に進むのですが、ボウル（谷底）に到達すると、この床を跳ね回るようになります。学習率を調整すれば、跳ね回る速度は遅くすることができます。モメンタムを使えば、ステップを滑らかにすることで、跳ね回り自体をなくすことができます。
