---
lang-ref: ch.04-1
lecturer: Alfredo Canziani
title: 線形代数と畳み込み
authors: Yuchi Ge, Anshan He, Shuting Gu, and Weiyang Wen
date: 18 Feb 2020
lang: ja
translation-date: 10 Sep 2020
translator: Jesmer Wong
---

<!-- ## [Linear Algebra review](https://www.youtube.com/watch?v=OrBEon3VlQg&t=68s) -->
## [線形代数の復習](https://www.youtube.com/watch?v=OrBEon3VlQg&t=68s)

<!-- This part is a recap of basic linear algebra in the context of neural networks. We start with a simple hidden layer $\boldsymbol{h}$:
-->
このパートでは、ニューラルネットワークの文脈における基本的な線形代数についておさらいします。 まずは単純な隠れ層$\boldsymbol{h}$から始めます:

$$
\boldsymbol{h} = f(\boldsymbol{z})
$$

<!--
The output is a non-linear function $f$ applied to a vector $z$. Here $z$ is the output of an affine transformation $\boldsymbol{A} \in\mathbb{R^{m\times n}}$ to the input vector $\boldsymbol{x} \in\mathbb{R^n}$:
-->
この出力は　ベクトル$z$　に非線形関数　$f$　が適用された結果です。
ここの $z$ は　入力されたベクトル　$\boldsymbol{x} \in\mathbb{R^n}$　を$\boldsymbol{A} \in\mathbb{R^{m\times n}}$によってアフィン変換した結果です:

$$
\boldsymbol{z} = \boldsymbol{A} \boldsymbol{x}
$$

<!--
For simplicity biases are ignored. The linear equation can be expanded as:
-->
簡単にするために、バイアスを無視します。上記の線形方程式は次のように展開できます。

$$
\boldsymbol{A}\boldsymbol{x} =
\begin{pmatrix}
a_{11} & a_{12} & \cdots & a_{1n}\\
a_{21} & a_{22} & \cdots & a_{2n} \\
\vdots & \vdots & \ddots & \vdots \\
a_{m1} & a_{m2} & \cdots & a_{mn} \end{pmatrix} \begin{pmatrix}
x_1 \\ \vdots \\x_n \end{pmatrix} =
\begin{pmatrix}
    \text{---} \; \boldsymbol{a}^{(1)} \; \text{---} \\
    \text{---} \; \boldsymbol{a}^{(2)} \; \text{---} \\
    \vdots \\
    \text{---} \; \boldsymbol{a}^{(m)} \; \text{---} \\
\end{pmatrix}
\begin{matrix}
    \rvert \\ \boldsymbol{x} \\ \rvert
\end{matrix} =
\begin{pmatrix}
    {\boldsymbol{a}}^{(1)} \boldsymbol{x} \\ {\boldsymbol{a}}^{(2)} \boldsymbol{x} \\ \vdots \\ {\boldsymbol{a}}^{(m)} \boldsymbol{x}
\end{pmatrix}_{m \times 1}
$$

<!-- where $\boldsymbol{a}^{(i)}$ is the $i$-th row of the matrix $\boldsymbol{A}$.
-->
上記の $\boldsymbol{a}^{(i)}$ は行列 $\boldsymbol{A}$　のなかの第$i$行です。

<!-- To understand the meaning of this transformation, let us analyse one component of $\boldsymbol{z}$ such as $a^{(1)}\boldsymbol{x}$. Let  $n=2$, then $\boldsymbol{a} = (a_1,a_2)$ and $\boldsymbol{x}  = (x_1,x_2)$.
-->
この変換の意味を理解するために、$a^{(1)}\boldsymbol{x}$などの $\boldsymbol{z}$の1つの要素を分析してみましょう。例えば $n=2$とすると、$\boldsymbol{a} = (a_1,a_2)$　および　$\boldsymbol{x}  = (x_1,x_2)$となります。

<!-- $\boldsymbol{a}$ and $\boldsymbol{x}$ can be drawn as vectors in the 2D coordinate axis. Now, if the angle between $\boldsymbol{a}$ and $\hat{\boldsymbol{\imath}}$ is $\alpha$ and the angle between $\boldsymbol{x}$ and $\hat{\boldsymbol{\imath}}$ is $\xi$, then with trigonometric formulae $a^\top\boldsymbol{x}$ can be expanded as:
-->
$\boldsymbol{a}$および$\boldsymbol{x}$は、2次元座標系上のベクトルとして描画できます。 ここで、$\boldsymbol{a}$と$\hat{\boldsymbol{\imath}}$の間の角度が$\alpha$で、$\boldsymbol{x}$と$\hat{\boldsymbol{\imath}}$の間の角度が、$\xi$であるとします。すると、三角関数の公式を用いることで、$a^\top\boldsymbol{x}$は次のように展開できます。

$$
\begin {aligned}
\boldsymbol{a}^\top\boldsymbol{x} &= a_1x_1+a_2x_2\\
&=\lVert \boldsymbol{a} \rVert \cos(\alpha)\lVert \boldsymbol{x} \rVert \cos(\xi) + \lVert \boldsymbol{a} \rVert \sin(\alpha)\lVert \boldsymbol{x} \rVert \sin(\xi)\\
&=\lVert \boldsymbol{a} \rVert \lVert \boldsymbol{x} \rVert \big(\cos(\alpha)\cos(\xi)+\sin(\alpha)\sin(\xi)\big)\\
&=\lVert \boldsymbol{a} \rVert \lVert \boldsymbol{x} \rVert \cos(\xi-\alpha)
\end {aligned}
$$

<!-- The output measures the alignment of the input to a specific row of the matrix $\boldsymbol{A}$. This can be understood by observing the angle between the two vectors, $\xi-\alpha$. When $\xi = \alpha$, the two vectors are perfectly aligned and maximum is attained. If $\xi - \alpha = \pi$, then $\boldsymbol{a}^\top\boldsymbol{x}$ attains its minimum and the two vectors are pointing at opposite directions. In essence, the linear transformation allows one to see the projection of an input to various orientations as defined by $A$. This intuition is expandable to higher dimensions as well.

Another way to understand the linear transformation is by understanding that $\boldsymbol{z}$ can also be expanded as:
-->
この出力は入力されたベクトルが行列$\boldsymbol{A}$の特定の行とどのぐらい同じ方向を向いているかを測る値です。 
これは、2つのベクトルの間の角度　$\xi-\alpha$を観察することで、理解することができます。
$\xi = \alpha$である場合、2つのベクトルは完全に同じ方向を向いており、最大値となります。
もし　$\xi - \alpha = \pi$である場合、2つのベクトルはお互いに反対方向を指すため　$\boldsymbol{a}^\top\boldsymbol{x}$ 最小値となります。
要するに、この線形変換により、入力されたベクトルが$ A $で定義されたさまざまな方向へ射影された値を見ることができます。
このようなやりかたは、より高い次元にも適用することができます。

線形変換を理解するもう1つの方法は、$ \ boldsymbol {z} $も次のように展開すれば：

$$
\boldsymbol{A}\boldsymbol{x} =
\begin{pmatrix}
    \vert            & \vert            &        & \vert             \\
    \boldsymbol{a}_1 & \boldsymbol{a}_2 & \cdots & \boldsymbol{a}_n  \\
    \vert            & \vert            &        & \vert             \\
\end{pmatrix}
\begin{matrix}
    \rvert \\ \boldsymbol{x} \\ \rvert
\end{matrix} =
x_1 \begin{matrix} \rvert \\ \boldsymbol{a}_1 \\ \rvert \end{matrix} +
x_2 \begin{matrix} \rvert \\ \boldsymbol{a}_2 \\ \rvert \end{matrix} +
    \cdots +
x_n \begin{matrix} \rvert \\ \boldsymbol{a}_n \\ \rvert \end{matrix}
$$

<!-- The output is the weighted sum of the columns of matrix $\boldsymbol{A}$. Therefore, the signal is nothing but a composition of the input.
-->
出力は、行列$\boldsymbol{A}$の列で重み付けられた和です。
よって、信号は入力を組み合わせたものにすぎません。

<!-- ## [Extend Linear Algebra to convolutions](https://www.youtube.com/watch?v=OrBEon3VlQg&t=1030s)
-->
## [線形代数の概念を畳み込みへ展開](https://www.youtube.com/watch?v=OrBEon3VlQg&t=1030s)

<!-- Now we extend linear algebra to convolutions, by using the example of audio data analysis. We start with representing a fully connected layer as a form of matrix multiplication: -
-->
次に、音声データ分析の例を使用して、線形代数の概念を畳み込みに拡張します。 
まずは、全結合層を行列積の形式で表すと：

$$
\begin{bmatrix}
w_{11} & w_{12} & w_{13}\\
w_{21} & w_{22} & w_{23}\\
w_{31} & w_{32} & w_{33}\\
w_{41} & w_{42} & w_{43}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$

<!--
In this example, the weight matrix has a size of $4 \times 3$, the input vector has a size of $3 \times 1$ and the output vector has a of size $4 \times 1$.
-->
この例では、重み行列のサイズは$4 \times 3$、入力ベクトルのサイズは$3 \times 1$なので、出力ベクトルのサイズは$4 \times 1$です。

<!-- However, for audio data, the data is much longer (not 3-sample long). The number of samples in the audio data is equal to the duration of the audio (*e.g.* 3 seconds) times the sampling rate (*e.g.* 22.05 kHz). As shown below, the input vector $\boldsymbol{x}$ will be quite long. Correspondingly, the weight matrix will become "fat".
-->
ただし、音声データの場合、データサイズは非常に長くなります（サイズはもう3ではありません）。
音声データのサンプル数は、 *音声の時間（例：3秒）$\times$サンプリングレート（例： 22.05 kHz）* です。 下記のように、入力ベクトル$\boldsymbol{x}$は非常に長くなります。 よって、重み行列は「寸胴」になります。


$$
\begin{bmatrix}
w_{11} & w_{12} & w_{13} & w_{14} & \cdots &w_{1k}& \cdots &w_{1n}\\
w_{21} & w_{22} & w_{23}& w_{24} & \cdots & w_{2k}&\cdots &w_{2n}\\
w_{31} & w_{32} & w_{33}& w_{34} & \cdots & w_{3k}&\cdots &w_{3n}\\
w_{41} & w_{42} & w_{43}& w_{44} & \cdots & w_{4k}&\cdots &w_{4n}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$

<!-- The above formulation will be difficult to train. Fortunately there are ways to simplify the same.
-->
このような式は学習が困難になります。 幸いなことに、同じことを単純にできる方法があります。


<!-- ### Property: locality

Due to locality (*i.e.* we do not care for data points that are far away) of data, $w_{1k}$ from the weight matrix above, can be filled with 0 when $k$ is relatively large. Therefore, the first row of the matrix becomes a kernel of size 3. Let's denote this size-3 kernel as $\boldsymbol{a}^{(1)} = \begin{bmatrix} a_1^{(1)}  & a_2^{(1)}  & a_3^{(1)} \end{bmatrix}$.
-->
### 局所性

データの局所性（*例*：遠くにあるデータ点は対象外となる）により、
上記の重み行列の$w_{1k}$ は、$k$の値が大きい場合に0で埋めることができます。
よって、行列の最初の行のカーネルは3のサイズはになります。
このサイズ3のカーネルを$\boldsymbol{a}^{(1)} = \begin{bmatrix} a_1^{(1)}  & a_2^{(1)}  & a_3^{(1)} \end{bmatrix}$としましょう。

$$
\begin{bmatrix}
a_1^{(1)}  & a_2^{(1)}  & a_3^{(1)}  & 0 & \cdots &0& \cdots &0\\
w_{21} & w_{22} & w_{23}& w_{24} & \cdots & w_{2k}&\cdots &w_{2n}\\
w_{31} & w_{32} & w_{33}& w_{34} & \cdots & w_{3k}&\cdots &w_{3n}\\
w_{41} & w_{42} & w_{43}& w_{44} & \cdots & w_{4k}&\cdots &w_{4n}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$

<!-- ### Property: stationarity

Natural data signals have the property of stationarity (*i.e.* certain patterns/motifs will repeat). This helps us reuse kernel $\mathbf{a}^{(1)}$ that we defined previously. We use this kernel by placing it one step further each time (*i.e.* stride is 1), resulting in the following:
-->
### 定常性

自然信号には定常性があります（*特定のパターン/モチーフが繰り返されます*）。
ですので、先ほど定義したカーネル$\mathbf{a}^{(1)}$を再利用することができます。
毎回１ステップ飛ばし（*例*：ストライドが1）でこのカーネルを使用すると、下記のようになります：


$$
\begin{bmatrix}
a_1^{(1)} & a_2^{(1)}  & a_3^{(1)}  & 0 & 0 & 0 & 0&\cdots  &0\\
0 & a_1^{(1)}  & a_2^{(1)} & a_3^{(1)}  & 0&0&0&\cdots &0\\
0 & 0 & a_1^{(1)} & a_2^{(1)}  & a_3^{(1)}  & 0&0&\cdots &0\\
0 & 0 & 0& a_1^{(1)}  & a_2^{(1)}  &a_3^{(1)} &0&\cdots &0\\
0 & 0 & 0& 0 & a_1^{(1)}  &a_2^{(1)} &a_3^{(1)} &\cdots &0\\
\vdots&&\vdots&&\vdots&&\vdots&&\vdots
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix}
$$

<!-- Both the upper right part and lower left part of the matrix are filled with $0$s thanks to locality, leading to sparsity. The reuse of a certain kernel again and again is called weight sharing.
-->
局所性のおかげで、行列の右上部分と左下部分の両方も$0$ で埋めることができ、行列がスパースになります。
特定のカーネルを何度も再利用することは重み共有と呼ばれます。

<!-- ### Multiple layers of Toeplitz matrix

After these changes, the number of parameters we are left with is 3 (*i.e.* $a_1,a_2,a_3$). In comparison to the previous weight matrix, which had 12 parameters (*i.e.* $w_{11},w_{12},\cdots,w_{43}$), the current number of parameters is too restrictive and we would like to expand the same.

The previous matrix can be considered to be a layer (*i.e.* a convolutional layer) with the kernel $\boldsymbol{a}^{(1)}$. Then we can construct multiple layers with different kernels $\boldsymbol{a}^{(2)}$, $\boldsymbol{a}^{(3)}$, etc, thereby increasing the parameters.

Each layer has a matrix containing just one kernel that is replicated multiple times. This type of matrix is called a Toeplitz matrix. In every Toeplitz matrix, each descending diagonal from left to right is constant. The Toeplitz matrices that we use here are sparse matrices as well.

Given the first kernel $\boldsymbol{a}^{(1)}$ and the input vector $\boldsymbol{x}$, the first entry in the output given by this layer is, $a_1^{(1)} x_1 + a_2^{(1)} x_2 + a_3^{(1)}x_3$. Therefore, the whole output vector looks like the following: -
-->
### 多層テプリッツ行列

上記の特性を使って変更すると、残ったパラメーターの数は3つだけとなります（*例*： $a_1, a_2, a_3$）。 
これを前回の12個のパラメーターの重み行列（*例*： $w_ {11}, w_ {12}, \cdots, w_{43}$）と比較すると、今のパラメーター数は制限され過ぎています。これを同じように展開したいと考えます。

前の行列は、カーネル$\boldsymbol{a}^{（1）}$付きのある層（*例*：畳み込み層）と見なすことができます。
次に、異なったカーネル$\boldsymbol{a}^{（2）}$や$\boldsymbol{a}^{（3）}$などで複数の層を作成し、パラメーター数を増やすことができます。


各層は、ただ一つの多数複製されたカーネルを含む行列を持ちます。このタイプの行列は、テプリッツ行列と呼ばれます。このようなのテプリッツ行列では、対角要素は一定とされます。ここで使用するテプリッツ行列は、スパース性もあります。

最初のカーネル$\boldsymbol{a}^{（1）}$と入力ベクトル$\boldsymbol {x}$が与えられると、この層で出力の最初の要素は$a_1^{（1）}x_1 + a_2 ^ {（1）} x_2 + a_3 ^ {（1）} x_3$となります。したがって、出力ベクトル全体は次のようになります。

$$
\begin{bmatrix}
\mathbf{a}^{(1)}x[1:3]\\
\mathbf{a}^{(1)}x[2:4]\\
\mathbf{a}^{(1)}x[3:5]\\
\vdots
\end{bmatrix}
$$

<!-- The same matrix multiplication method can be applied on following convolutional layers with other kernels (*e.g.* $\boldsymbol{a}^{(2)}$ and $\boldsymbol{a}^{(3)}$) to get similar results.
-->
異なるカーネルを持つ次の畳み込み層*例*： $\boldsymbol{a}^{（2）}$と$\boldsymbol{a}^{（3）}$）に対しても同じ行列積を適用することができ、同様の結果を得ることができます。

<!-- ## [畳み込みについて - Jupyter Notebook](https://www.youtube.com/watch?v=OrBEon3VlQg&t=1709s)
-->
## [Listening to convolutions - Jupyter Notebook](https://www.youtube.com/watch?v=OrBEon3VlQg&t=1709s)

<!-- The Jupyter Notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/07-listening_to_kernels.ipynb).
-->
Jupyter Notebookは[ここ](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/07-listening_to_kernels.ipynb)にあります.

<!-- In this notebook, we are going to explore Convolution as a 'running scalar product'.
-->
このノートブックでは、「スカラー積」としての畳み込みのやりかたを理解していきます。

<!-- The library `librosa` enables us to load the audio clip $\boldsymbol{x}$ and its sampling rate. In this case, there are 70641 samples, sampling rate is 22.05kHz and total length of the clip is 3.2s. The imported audio signal is wavy (refer to Fig 1) and we can guess what it sounds like from the amplitude of $y$ axis. The audio signal $x(t)$ is actually the sound played when turning off the Windows system (refer to Fig 2).
-->
ライブラリ `librosa`を使用すると、オーディオクリップ$\boldsymbol {x}$とそのサンプリングレートを読み込むことができます。 この例では、サンプルは70641個あり、サンプリングレートは22.05kHz、クリップの全長は3.2秒です。読み込まれた音声信号はばらつきがあり（図1を参照）、$y$軸の振幅から見るとどのような声がするのかを推測することができます。音声信号$x(t)$は、実際にはWindowsシステムをオフにしたときに再生されるサウンドです（図2を参照）。

<center>
<img src="{{site.baseurl}}/images/week04/04-1/audioSignal.png" width="500px" /><br>
<b>図1</b>: 音声信号の可視化 <br>
</center>

<center>
<img src="{{site.baseurl}}/images/week04/04-1/notes.png" width="500px" /><br>
<b>図2</b>: 上の音声信号に対する注意<br>
</center>

<!-- We need to seperate the notes from the waveform. To achieve this, if we use Fourier transform (FT) all the notes would come out together and it will be hard to figure out the exact time and location of each pitch. Therefore, a localized FT is needed (also known as spectrogram). As is observed in the spectrogram (refer to Fig 3), different pitches peak at different frequencies (*e.g.* first pitch peaks at 1600). Concatenating the four pitches at their frequencies gives us a pitched version of the original signal.
-->
波形から音符を分離する必要があります。 これをフーリエ変換（FT）で行おうとすると、すべての音が一緒に出て、各ピッチの正確な時間と場所を把握するのが難しくなります。よって、局所化されたFTが必要となります（スペクトログラムとも呼ばれます）。スペクトログラムをみるとわかるように（図3を参照）、異なったピッチと異なった周波数でピークが見えます（*例：* 1600で最初のピッチピーク）。 それらの周波数で4つのピッチを連結すると、元の信号がピッチされたものが得られます。


<center>
<img src="{{site.baseurl}}/images/week04/04-1/spectrogram.png" width="500px" /><br>
<b>図3</b>: 音声信号とそのスペクトログラム<br>
</center>

<!-- Convolution of the input signal with all the pitches (all the keys of the piano for example) can help extract all notes in the input piece (*i.e.* the hits when the audio matches the specific kernels). The spectrograms of the original signal and the signal of the concatenated pitches is shown in Fig 4 while the frequencies of the original signal and the four pitches is shown in Fig 5. The plot of the convolutions of the four kernels with the input signal (original signal) is shown in Fig 6. Fig 6 along with the audio clips of the convolutions prove the effectiveness of the convolutions in extracting the notes.
-->
入力信号とすべてのピッチ（たとえば、ピアノのすべての音階）を畳み込むと、入力（*特定のカーネルが音声と一致したときに当たる*）のすべての音符を抽出できます。 元の信号といろんなピッチを連結した信号のスペクトログラムを図4に、元の信号と4つのピッチの周波数を図5に示します。4つのカーネルを入力信号（元の信号）と畳み込みこんだものを図6に示します。図6と畳み込みされた信号のオーディオクリップが、ノートの抽出における畳み込みの有効性を証明しています。

<!-- <center>
<img src="{{site.baseurl}}/images/week04/04-1/fig4.png" width="500px" /><br>
<b>Fig. 4</b>: Spectrogram of original signal (left) and Sepctrogram of the concatenation of pitches (right).<br>
</center>

<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig5.png" width="500px" /><br>
<b>Fig. 5</b>: First note of the melody.<br>
</center>

<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig6.png" width="500px" /><br>
<b>Fig. 6</b>: Convolution of four kernels.<br>
</center> -->

<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig4.png" width="500px" /><br>
<b>図4</b>: 元の信号のスペクトログラム（左）とピッチが連結されたもののスペクトログラム（右）<br>
</center>

<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig5.png" width="500px" /><br>
<b>図5</b>: メロディーの最初の音符.<br>
</center>

<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig6.png" width="500px" /><br>
<b>図6</b>: 4つのカーネルの畳み込み<br>
</center>

<!-- ## Dimensionality of different datasets
The last part is a short digression on the different representations of dimensionality and examples for the same. Here we consider input set $X$ is made of  functions mapping from domains $\Omega$ to channels $c$.


### Examples
-->
## 異なるデータセットの次元数

最後に、次元数のさまざまな表現とその例について、短い余談をします。
ここで、仮に入力セット$X$がドメイン$\Omega$からチャネル$c$にマッピングされたとします。


### 例

<!--
* Audio data: domain is 1-D, discrete signal indexed by time; number of channels $c$ can range from 1 (mono), 2 (stereo), 5+1 (Dolby 5.1), *etc.*
* Image data: domain is 2-D (pixels); $c$ can range from 1(greyscale), 3(colour), 20(hyperspectral), *etc.*
* Special relativity: domain is $\mathbb{R^4} \times \mathbb{R^4}$ (space-time $\times$ four-momentum); when $c = 1$ it is called Hamiltonian.
-->
* 音声データ：ドメインは1次元; 時間でインデックス付けられた離散信号； チャネル数$c$は、1（モノ）、2（ステレオ）、5 + 1（ドルビー5.1）*など*があります。
* 画像データ：ドメインは2次元（ピクセル）； $c$の範囲は、1（グレースケール）、3（カラー）、20（ハイパースペクトル）、*など*があります。
* 特殊相対論：ドメインは$\mathbb{R^4} \times \mathbb{R^4}$（時空$\times$ 4モメンタム）です。 $c=1$の場合、ハミルトニアンと呼ばれます。


<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig7.png" width="600px" /><br>
<b>図7</b>: 異なる信号の異なる次元<br>
</center>
