---
lang-ref: ch.03-3
title: Properties of natural signals
lecturer: Alfredo Canziani
authors: Ashwin Bhola, Nyutian Long, Linfeng Zhang, and Poornima Haridas
date: 11 Feb 2020
lang: ja
translation-date: 6 Dec 2020
translator: Shiro Takagi
---


<!-- ## [Properties of natural signals](https://www.youtube.com/watch?v=kwPWpVverkw&t=26s)

All signals can be thought of as vectors. As an example, an audio signal is a 1D signal $\boldsymbol{x} = [x_1, x_2, \cdots, x_T]$ where each value $x_t$ represents the amplitude of the waveform at time $t$. To make sense of what someone is speaking, your cochlea first converts the air pressure vibrations to signals and then your brain uses a language model to convert this signal to a language i.e. it needs to pick the most probable utterance given the signal. For music, the signal is stereophonic which has 2 or more channels to give you an illusion that the sound is coming from multiple directions. Even though it has 2 channels, it's still a 1D signal because time is the only variable along which the signal is changing.

An image is a 2D signal because the information is spatially depicted. Note that each point can be a vector in itself. This means that if we have $d$ channels in an image, each spatial point in the image is a vector of dimension $d$. A colour image has RGB planes, which means $d = 3$. For any point $x_{i,j}$, this corresponds to the intensity of red, green and blue colours respectively.

We can even represent language with the above logic. Each word corresponds to a one-hot vector with one at the position it occurs in our vocabulary and zeroes everywhere else. This means that each word is a vector of the size of the vocabulary.

Natural data signals follow these properties:
1. Stationarity: Certain motifs repeat throughout a signal. In audio signals, we observe the same type of patterns over and over again across the temporal domain. In images, this means that we can expect similar visual patterns repeat across the dimensionality.
2. Locality: Nearby points are more correlated than points far away. For 1D signal, this means that if we observe a peak at some point $t_i$, we expect the points in a small window around $t_i$ to have similar values as $t_i$ but for a point $t_j$ far away from $t_i$, $x_{t_i}$ has very less bearing on $x_{t_j}$. More formally, the convolution between a signal and its flipped counterpart has a peak when the signal is perfectly overlapping with it's flipped version. A convolution between two 1D signals (cross-correlation) is nothing but their dot product which is a measure of how similar or close the two vectors are. Thus, information is contained in specific portions and parts of the signal. For images, this means that the correlation between two points in an image decreases as we move the points away. If $x_{0,0}$ pixel is blue, the probability that the next pixel ($x_{1,0},x_{0,1}$) is also blue is pretty high but as you move to the opposite end of the image ($x_{-1,-1}$), the value of this pixel is independent of the pixel value at $x_{0,0}$.
3. Compositionality: Everything in nature is composed of parts that are composed of sub-parts and so on. As an example, characters form strings that form words, which further form sentences. Sentences can be combined to form documents. Compositionality allows the world to be explainable.

If our data exhibits stationarity, locality, and compositionality, we can exploit them with networks that use sparsity, weight sharing and stacking of layers. -->

## [自然界の信号の性質](https://www.youtube.com/watch?v=kwPWpVverkw&t=26s)

すべての信号は、ベクトルとして考えることができます。例えば、音声信号は1次元の信号$\boldsymbol{x} = [x_1, x_2, \cdots, x_T]$です。ただし、各$x_t$は時刻$t$での波形の振幅を表しています。誰かが何を話しているのかを理解するために、蝸牛はまず気圧の振動を信号に変換し、脳は言語モデルを使ってこの信号を言語に変換します。音楽の場合、信号は立体音響で、音が複数の方向から聞こえているように錯覚させるために2つ以上のチャンネルを持っています。2つのチャンネルを持っていても、時間だけが信号の変化に沿って変化しているので、1次元の信号であることに変わりはありません。

画像は、情報が空間的に描かれているので、２次元信号です。各点はそれ自体がベクトルであることに注意してください。つまり、画像の中に $d$ チャンネルがある場合、画像の各空間的な点は $d$ 次元のベクトルであることを意味します。カラー画像はRGBの平面を持っているので、 $d = 3$ ということになります。任意の点 $x_{i,j}$ について、これはそれぞれ赤、緑、青の色の強度に対応します。

上記の論理で言語を表現することもできます。各単語は、私たちの語彙の中で発生する位置に1を持ち、それ以外の場所では0を持つone-hotベクトルに対応しています。これは、各単語が語彙の大きさのベクトルであることを意味します。

自然データの信号は、以下の特性に従います。
1. 定常性：　特定のモチーフが信号全体に渡って繰り返されます。音声信号では、時間領域にわたって同じタイプのパターンが何度も何度も観察されます。画像では、同じような視覚的パターンが次元を超えて繰り返されることを意味します。
2. 局所性：　近くの点は遠くの点よりも相関が高くなります。1次元信号の場合、ある点 $t_i$ でピークを観測した場合、 $t_i$ の周りの小さな窓の中の点は $t_i$ と同じような値を持つと予想されますが、 $t_i$ から離れた点 $t_j$ では、 $x_{t_i}$ は $x_{t_j}$ との関係が非常に薄いことを意味しています。より正式には、信号と反転した信号の畳み込みは、信号が反転した信号と完全に重なったときにピークを迎えます。2つの1次元信号間の畳み込み(相互相関)は、2つのベクトルがどれだけ似ているか、あるいは近いかの指標である、互いのドット積以外の何ものでもありません。このように、情報は信号の特定の部分に含まれています。画像の場合、これは、画像内の2つの点の間の相関が、点を遠ざけるにつれて減少することを意味します。$x_{0,0}$ の画素が青である場合、次の画素($x_{1,0},x_{0,1}$)も青である確率はかなり高いですが、画像の反対側の端($x_{-1,-1}$)に移動するにつれて、この画素の値は $x_{0,0}$ の画素の値とは独立になります。
3. 構成性；　自然界に存在するすべてのものは、全体の部分のまた部分の・・・というように構成されています。例として、文字は文字列を形成して単語を形成し、それがさらに文を形成します。文は組み合わせて文書を形成することができます。構成性は世界を説明可能にします。

もしデータが定常性、局所性、構成性を示すならば、スパース性、重み共有、層の積み重ねを利用したネットワークでそれらを利用することができます。


<!-- ## [Exploiting properties of natural signals to build invariance and equivariance](https://www.youtube.com/watch?v=kwPWpVverkw&t=1074s)


### Locality  $\Rightarrow$ sparsity

Fig.1 shows a 5-layer fully connected network. Each arrow represents a weight to be multiplied by the inputs. As we can see, this network is very computationally expensive.

<center><img src="{{site.baseurl}}/images/week02/02-3/pre-inference4layers.png" width="400px" /><br>
<b>Figure 1:</b> Fully Connected Network</center>

If our data exhibits locality, each neuron needs to be connected to only a few local neurons of the previous layer. Thus, some connections can be dropped as shown in Fig.2. Fig.2(a) represents an FC network. Taking advantage of the locality property of our data, we drop connections between far away neurons in Fig.2(b). Although the hidden layer neurons (green) in Fig.2(b) don't span the whole input, the overall architecture will be able to account for all input neurons. The receptive field (RF) is the number of neurons of previous layers, that each neuron of a particular layer can see or has taken into account. Therefore, the RF of the output layer w.r.t the hidden layer is 3, RF of the hidden layer w.r.t the input layer is 3, but the RF of the output layer w.r.t the input layer is 5.

|<img src="{{site.baseurl}}/images/week03/03-3/Figure 2(a) Before Applying Sparsity.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure 2(b) After Applying Sparsity.png" width="300"/>|
|<b>Figure 2(a):</b> Before Applying Sparsity | <b>Figure 2(b):</b> After Applying Sparsity| -->

## [不変性と等価性を生み出すために自然の信号の性質を活用する](https://www.youtube.com/watch?v=kwPWpVverkw&t=1074s)


### 局所性 $Rightarrow$ スパース性

図1は、5層の全結合ネットワークを示しています。各矢印は、入力に乗算される重みを表しています。見ての通り、このネットワークは非常に計算量が多いです。

<center><img src="{{site.baseurl}}/images/week02/02-3/pre-inference4layers.png" width="400px" /><br>
<b>図1:</b> 全結合ネットワーク</center>

私たちのデータが局所性を示す場合、各ニューロンは、前の層の少数の局所ニューロンに接続する必要があります。そのため、図２に示すように、いくつかの接続を削除することができます。図2(a)は全結合ネットワークです。データの局所性を利用して、図2(b)では遠く離れたニューロン間の接続を落としています。図2(b)の隠れ層のニューロン(緑)は入力全体をカバーしているわけではありませんが、全体のアーキテクチャはすべての入力ニューロンをカバーすることができます。受容野（RF）は、特定の層の各ニューロンが見ることができる、あるいは考慮に入れた、前の層のニューロンの数です。したがって、隠れ層の出力層のRFは3、入力層のRFは3ですが、出力層のRFは5となります。

|<img src="{{site.baseurl}}/images/week03/03-3/Figure 2(a) Before Applying Sparsity.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure 2(b) After Applying Sparsity.png" width="300"/>|
|<b>図2(a):</b> スパース性を適用する前 | <b>図2(b):</b> スパース性を適用した後|

<!-- ### Stationarity $\Rightarrow$ parameters sharing

If our data exhibits stationarity, we could use a small set of parameters multiple times across the network architecture. For example in our sparse network, Fig.3(a), we can use a set of 3 shared parameters (yellow, orange and red). The number of parameters will then drop from 9 to 3! The new architecture might even work better because we have more data for training those specific weights.
The weights after applying sparsity and parameter sharing is called a convolution kernel.

|<img src="{{site.baseurl}}/images/week03/03-3/Figure 3(a) Before Applying Parameter Sharing.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure 3(b) After Applying Parameter Sharing.png" width="300"/>|
|<b>Figure 3(a):</b> Before Applying Parameter Sharing | <b>Figure 3(b):</b> After Applying Parameter Sharing|

Following are some advantages of using sparsity and parameter sharing:-
* Parameter sharing
  * faster convergence
  * better generalisation
  * not constained to input size
  * kernel indepence $\Rightarrow$ high parallelisation
* Connection sparsity
  * reduced amount of computation

Fig.4 shows an example of kernels on 1D data, where the kernel size is: 2(number of kernels) * 7(thickness of the previous layer) * 3(number of unique connections/weights).

The choice of kernel size is empirical. 3 * 3 convolution seems to be the minimal size for spatial data. Convolution of size 1 can be used to obtain a final layer that can be applied to a larger input image. Kernel size of even number might lower the quality of the data, thus we always have kernel size of odd numbers, usually 3 or 5.

|<img src="{{site.baseurl}}/images/week03/03-3/Figure_4a_kernels_ on_1D_data.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure_4b_zero_padding.png" width="350"/>|
|<b>Figure 4(a):</b> Kernels on 1D Data | <b>Figure 4(b):</b> Data with Zero Padding| -->


### 定常性　\Rightarrow$ パラメータ共有

データが定常性を示す場合には、ネットワークアーキテクチャー全体で小さなパラメータのセットを複数回使用することができます。例えば、図3(a)のスパースネットワークでは、3つの共有パラメータ（黄色、オレンジ、赤）のセットを使用することができます。そうすると、パラメータの数は9個から3個に減ってしまいます。新しいアーキテクチャは、これらの特定の重みを訓練するためのデータがより多くあるので、より良く機能するかもしれません。
スパース性とパラメータ共有を適用した後の重みは、畳み込みカーネルと呼ばれます。

|<img src="{{site.baseurl}}/images/week03/03-3/Figure 3(a) Before Applying Parameter Sharing.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure 3(b) After Applying Parameter Sharing.png" width="300"/>|
|<b>図3(a):</b> パラメータ共有適用前 | <b>図3(b):</b> パラメータ共有適用後|


以下は、スパース性とパラメータ共有を使用することの利点です。
* パラメータ共有
  * より速い収束
  * より良い汎化
  * 入力サイズに拘束されない
  * カーネルの独立性 $\Rightarrow$ 並列化
* 接続のばらつき
  * 計算量の削減

図４は、１次元データ上のカーネルの例を示しており、カーネルサイズは、２（カーネル数）×７（前の層の厚さ）×３（ユニークな接続の数／重さ）です。

カーネルサイズの選択は経験的なものです。3 * 3 の畳み込みが空間データの最小サイズであるように思われます。サイズ1の畳み込みは、より大きな入力画像に適用できる最終層を得るために使用することができます。偶数のカーネルサイズはデータの品質を低下させる可能性があるので、奇数のカーネルサイズ、通常は3や5を使用します。

|<img src="{{site.baseurl}}/images/week03/03-3/Figure_4a_kernels_ on_1D_data.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure_4b_zero_padding.png" width="350"/>|
|<b>図4(a):</b> １次元データに対するカーネル | <b>図4(b):</b> ゼロパディングのデータ|


<!-- ### Padding

Padding generally hurts the final results, but it is convenient programmatically. We usually use zero-padding: `size =  (kernel size - 1)/2`. -->

### パディング

パディングは一般的に最終的な結果に悪影響を与えますが、プログラム的には便利です。通常はゼロパディングを使用します。`サイズ = (カーネルサイズ - 1)/2`のようにします

<!-- ### Standard spatial CNN

A standard spatial CNN has the following properties:

* Multiple layers
  * Convolution
  * Non-linearity (ReLU and Leaky)
  * Pooling
  * Batch normalisation
* Residual bypass connection

Batch normalization and residual bypass connections are very helpful to get the network to train well.
Parts of a signal can get lost if too many layers have been stacked so, additional connections via residual bypass, guarantee a path from bottom to top and also for a path for gradients coming from top to bottom.

In Fig.5, while the input image contains mostly spatial information across two dimensions (apart from characteristic information, which is the colour of each pixel), the output layer is thick. Midway, there is a trade off between the spatial information and the characteristic information and the representation becomes denser. Therefore, as we move up the hierarchy, we get denser representation as we lose the spatial information.

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 5 Information Representations Moving up the Hierachy.png" width="350px" /><br>
<b>Figure 5:</b> Information Representations Moving up the Hierarchy</center> -->

### 標準的な空間的CNN

標準的な空間的CNNには以下の特性があります。

* 複数の層
  * 畳み込み
  * 非線形性(ReLUとLeaky ReLU)
  * プーリング
  * バッチ正規化
* Residual connection

バッチ正規化とresidual connectionは、ネットワークをうまく訓練するのに非常に役立ちます。
Residual connectionを介した追加の接続は、下から上へのパスと上から下への勾配のパスを保証します。

図5では、入力画像には2次元の空間情報がほとんど含まれていますが（各ピクセルの色である特徴情報は別として）、出力層は厚いです。途中で、空間情報と特徴情報の間にトレードオフが生じ、表現が密になります。したがって、階層が上がるにつれて、空間情報が失われ、表現が密になります。

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 5 Information Representations Moving up the Hierachy.png" width="350px" /><br>
<b>図5:</b> 階層を移動する情報表現</center>


<!-- ### [Pooling](https://www.youtube.com/watch?v=kwPWpVverkw&t=2376s)

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 6 Illustration of Pooling.png" width="350px" /><br>
<b>Figure 6:</b> Illustration of Pooling</center>

A specific operator, $L_p$-norm, is applied to different regions (refer to Fig.6). Such an operator gives only one value per region(1 value for 4 pixels in our example). We then iterate over the whole data region-by-region, taking steps based on the stride. If we start with $m * n$ data with $c$ channels, we will end up with $\frac{m}{2} * \frac{n}{2}$ data still with $c$ channels (refer to Fig.7).
Pooling is not parametrized; nevertheless, we can choose different polling types like max pooling, average pooling and so on. The main purpose of pooling reduces the amount of data so that we can compute in a reasonable amount of time.

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 7 Pooling results.png" width="350px" /><br>
<b>Figure 7:</b> Pooling results </center> -->

### [プーリング](https://www.youtube.com/watch?v=kwPWpVverkw&t=2376s)

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 6 Illustration of Pooling.png" width="350px" /><br>
<b>図6:</b> プーリングの図</center>

$L_p$-ノルムという演算子を、異なる領域に適用します（図6参照）。このような演算子は、1つの領域につき1つの値しか与えられません（今回の例では、4つの画素に対して1つの値を与えます）。次に、データ全体を領域ごとに繰り返していき、ストライドに基づいてステップを動かします。サイズ$m * n$ で $c$ チャネルを持つデータから始めると、 サイズ$\frac{m}{2} * \frac{n}{2}$ で$c$チャンネルを持つデータになります。図7を見てください。
プーリングはパラメトライズされていませんが、最大プーリングや平均プーリングなど、さまざまな種類のプーリングを選択することができます。プーリングの主な目的は、データ量を減らすことで、合理的な時間で計算できるようにすることです。

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 7 Pooling results.png" width="350px" /><br>
<b>図7:</b> プーリングの結果 </center>

<!-- ## CNN - Jupyter Notebook

The Jupyter notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/06-convnet.ipynb). To run the notebook, make sure you have the `pDL` environment installed as specified in [`README.md`](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/README.md).

In this notebook, we train a multilayer perceptron (FC network) and a convolution neural network (CNN) for the classification task on the MNIST dataset. Note that both networks have an equal number of parameters. (Fig.8)

<center> <img src="{{site.baseurl}}/images/week03/03-3/Figure 8 Instances from the Original MNIST Dataset.png" width="350px" /><br>
<b>Figure 8:</b> Instances from the Original MNIST Dataset </center>

Before training, we normalize our data so that the initialization of the network will match our data distribution (very important!). Also, make sure that the following five operations/steps are present in your training:

 1. Feeding data to the model
 2. Computing the loss
 3. Cleaning the cache of accumulated gradients with `zero_grad()`
 4. Computing the gradients
 5. Performing a step in the optimizer method

First, we train both the networks on the normalized MNIST data. The accuracy of the FC network turned out to be $87\%$ while the accuracy of the CNN turned out to be $95\%$. Given the same number of parameters, the CNN managed to train many more filters. In the FC network, filters that try to get some dependencies between things that are further away with things that are close by, are trained. They are completely wasted. Instead, in the convolutional network, all these parameters concentrate on the relationship between neighbour pixels.

Next, we perform a random permutation of all the pixels in all the images of our MNIST dataset. This transforms our Fig.8 to Fig.9. We then train both the networks on this modified dataset.

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 9 Instances from Permuted MNIST Dataset.png" width="350px" /><br>
<b>Figure 9:</b> Instances from Permuted MNIST Dataset</center>

The performance of the FC network almost stayed unchanged ($85\%$), but the accuracy of CNN dropped to $83\%$. This is because, after a random permutation, the images no longer hold the three properties of locality, stationarity, and compositionality, that are exploitable by a CNN. -->


## CNN - Jupyter Notebook

Jupyter Notebookは [ここ](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/06-convnet.ipynb) にあります。ノートブックを実行するには、[`README.md`](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/README.md) で指定された `pDL` 環境がインストールされていることを確認してください。

このノートでは、MNISTデータセットの分類タスクのために、多層パーセプトロン(FCネットワーク)と畳み込みニューラルネットワーク(CNN)を学習しています。なお、どちらのネットワークもパラメータ数は同じです。(図8)

<center> <img src="{{site.baseurl}}/images/week03/03-3/Figure 8 Instances from the Original MNIST Dataset.png" width="350px" /><br>
<b>図8:</b> 元のMNISTデータセットからのインスタンス </center>

訓練の前に、ネットワークの初期化がデータの分布と一致するようにデータを正規化します（非常に重要です！）。また、以下の5つの操作/ステップが訓練に存在することを確認してください。

 1. モデルにデータを供給する
 2. 損失の計算
 3. 蓄積された勾配のキャッシュを `zero_grad()` でクリーニングする
 4. 勾配の計算
 5. オプティマイザーを使ってパラメータを更新する

まず、正規化されたMNISTデータを用いて両者のネットワークを学習します。その結果、FCネットワークの精度は$87\%$、CNNの精度は$95\%$でした。同じパラメータ数であれば、CNNはより多くのフィルタを学習することができました。FCネットワークでは、遠くにあるものと近くにあるものとの間に依存関係を持たせようとするフィルタが訓練されます。それらは完全に無駄になります。その代わりに、畳み込みネットワークでは、これらのパラメータはすべて隣のピクセル間の関係に集中しています。

次に、MNISTデータセットの全ての画像の全ての画素に対して、ランダムな並べ替えを行います。これにより、図8を図9に変換し、この修正されたデータセット上で両方のネットワークを訓練します。

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 9 Instances from Permuted MNIST Dataset.png" width="350px" /><br>
<b>図9:</b> Permuted MNIST Datasetからのインスタンス</center>

FCネットワークの性能はほとんど変わらない($85\%$)ですが、CNNの精度は$83\%$に低下しました。これは、ランダムな並べ替えの後、画像がCNNで利用可能な局所性、定常性、構図性の３つの性質を保持しなくなったためです。
