---
lang-ref: ch.03-2
lecturer: Yann LeCun
title: ConvNet Evolutions, Architectures, Implementation Details and Advantages.
authors: Chris Ick, Soham Tamba, Ziyu Lei, Hengyu Tang
date: 10 Feb 2020
lang: ja
translation-date: 6 Dec 2020
translator: Shiro Takagi
---


<!-- ## [Proto-CNNs and evolution to modern CNNs](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=2949s)


### Proto-convolutional neural nets on small data sets

Inspired by Fukushima's work on visual cortex modelling, using the simple/complex cell hierarchy combined with supervised training and backpropagation lead to the development of the first CNN at University of Toronto in '88-'89 by Prof. Yann LeCun. The experiments used a small dataset of 320 'mouser-written' digits. Performances of the following architectures were compared:

1. Single FC(fully connected) Layer
2. Two FC Layers
3. Locally Connected Layers w/o shared weights
4. Constrained network w/ shared weights and local connections
5. Constrained network w/ shared weights and local connections 2 (more feature maps)

The most successful networks (constrained network with shared weights) had the strongest generalizability, and form the basis for modern CNNs. Meanwhile, singler FC layer tends to overfit.


### First "real" ConvNets at Bell Labs

After moving to Bell Labs, LeCunn's research shifted to using handwritten zipcodes from the US Postal service to train a larger CNN:

* 256 (16$\times$16) input layer
* 12 5$\times$5 kernels with stride 2 (stepped 2 pixels): next layer has lower resolution
* **NO** separate pooling


### Convolutional network architecture with pooling

The next year, some changes were made: separate pooling was introduced. Separate pooling is done by averaging input values, adding a bias, and passing to a nonlinear function (hyperbolic tangent function). The 2$\times$2 pooling was performed with a stride of 2, hence reducing resolutions by half. -->

## [初期のCNNと、現代のCNNへの進化](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=2949s)


### 畳み込みニューラルネットを用いた小さなデータセットの初期の畳み込み

視覚皮質のモデリングに関する福島の研究に触発されて、単純型細胞/複雑型細胞からなる階層構造、教師あり学習、そして誤差逆伝播を組み合わせたものを用いて、88-89年にトロント大学のYann LeCun教授が最初のCNNを開発しました。実験には320桁の「ムーサーが書いた」数字の小さなデータセットが使われました。以下のアーキテクチャの性能が比較されました。

1. 単一のFC(全結合)層
2. 2つのFC層
3. 重み共有なしで局所的に接続された層
4. 重みを共有し、局所接続を行う制約付きネットワーク
5. 重みを共有し、局所接続を行う制約付きネットワーク (より多くの特徴マップ)

最も成功したネットワーク（重みを共有した制約付きネットワーク）は最も良い汎化性能を持っており、これは現代のCNNの基礎を形成しています。一方、単一のFC層は過学習する傾向があります。


### ベル研究所での最初の「本物の」畳み込みニューラルネット

ベル研究所に移った後、LeCunnの研究は、より大きなCNNを訓練するために、米国郵政公社の手書きの郵便番号を使用することにシフトしました。

* サイズ256 (16$\times$16)の入力層。
* サイズ12 5$\times$5のカーネル。ただし、ストライドが2 (2ピクセルで止まる)、すなわち次のレイヤーは解像度が低減。
* セパレートプーリング**なし**。


### プーリングを用いた畳み込みネットワークアーキテクチャ

翌年、いくつかの変更が行われました：セパレートプーリングが導入されました。セパレートプーリングとは、入力値を平均化してバイアスを加え、非線形関数（tanh）に渡すことで行うものです。2$\times$2のプーリングは、ストライドを2にして実行され、解像度が半分になりました。


<!-- <center>
    <img src="{{site.baseurl}}/images/week03/03-2/detailed_convNet.png" width="600px" /><br>
    <b>Fig. 1</b> ConvNet Architecture
</center> -->
<center>
    <img src="{{site.baseurl}}/images/week03/03-2/detailed_convNet.png" width="600px" /><br>
    <b>図1</b> 畳み込みニューラルネットのアーキテクチャ
</center>
 
<!-- An example of a single convolutional layer would be as follows:
1. Take an input with size *32$\times$32*
2. The convolution layer passes a 5$\times$5 kernel with stride 1 over the image, resulting feature map size *28$\times$28*
3. Pass the feature map to a nonlinear function: size *28$\times$28*
4. Pass to the pooling layer that averages over a 2$\times$2 window with stride 2: size *14$\times$14*
5. Repeat 1-4 for 4 kernels

The first-layer, simple convolution/pool combinations usually detect simple features, such as oriented edge detections. After the first convolution/pool layer, the objective is to detect combinations of features from previous layers. To do this, steps 2 to 4 are repeated with multiple kernels over previous-layer feature maps, and are summed in a new feature map:

1. A new 5$\times$5 kernel is slid over all feature maps from previous layers, with results summed up. (Note: In Prof. LeCun's experiment in 1989 the connection is not full for computation purpose. Modern settings usually enforce full connections): size *10$\times$10*
2. Pass the output of the convolution to a nonlinear function: size *10$\times$10*
3. Repeat 1/2 for 16 kernels.
4. Pass the result to the pooling layer that averages over 2$\times$2 window with stride 2: size *5$\times$5* each feature map

To generate an output, the last layer of convolution is conducted, which seems like a full connections but indeed is convolutional.

1. The final convolution layer slides a 5$\times$5 kernel over all feature maps, with results summed up: size *1$\times$1*
2. Pass through nonlinear function: size *1$\times$1*
3. Generate the single output for one category.
4. Repeat all pervious steps for each of the 10 categories(in parallel)

See [this animation](http://cs231n.github.io/convolutional-networks/) on Andrej Karpathy's website on how convolutions change the shape of the next layer's feature maps. Full paper can be found [here](https://papers.nips.cc/paper/293-handwritten-digit-recognition-with-a-back-propagation-network.pdf).  -->

単一の畳み込み層の例としては、以下のようなものが考えられます。
1. サイズ*32$\times$32*の入力を取ります。
2. 畳み込み層で、5$\times$5のカーネルをストライド1で画像上を通過させます。その結果、サイズ*28$\times$28*の特徴マップが得られます。
3. 特徴マップを非線形関数に渡します。
4. ストライドが2で2$\times$2のウィンドウで平均をとるプーリング層に渡します：サイズは*14$times$14*となります。
5. 1-4を4カーネル分繰り返します。

第１層の単純な畳み込み／プーリングの組み合わせは、通常、方向エッジの検出のような単純な特徴を検出します。最初の畳み込み／プーリング層の後の層の目的は、前の層からの特徴の組み合わせを検出することです。このために、前層の特徴マップ上で複数のカーネルを用いてステップ２〜４を繰り返します。これが足し合わされることで、新しい特徴マップを得ることができます。

1. 新しい5$\times$5のカーネルを前の層の特徴マップの上でスライドさせ、得られた結果を合計します。(注: 1989年のLeCun教授の実験では、計算の都合上全結合を用いていません。最近の設定では、通常は全結合を用いています。
2. 畳み込みの出力を非線形関数に渡します。
3. 1と2を16個分繰り返します。
4. 結果を、ストライド2で2$\times$2のウィンドウを用いて平均操作をするプーリング層に渡します：各特徴マップについてサイズが*5$\times$5*です。

出力を生成するために、最後の層の畳み込みが行われます。これは全結合のように見えますが、実際には畳み込みです。

1. 最後の畳み込み層では、5$\times$5のカーネルを全ての特徴マップ上でスライドさせ、結果を合計したものです。これは、 サイズが*1$\times$1*となります。
2. 非線形関数を通過させます。
3. 1つのカテゴリに対応する、単一の出力を生成します。
4. 10個のカテゴリのそれぞれについて、これまでのすべてのステップを繰り返します(並行して)

畳み込みが次のレイヤーの特徴マップの形状をどのように変化させるかについては、Andrej Karpathy のウェブサイトの [このアニメーション](http://cs231n.github.io/convolutional-networks/) を参照してください。論文の全文は [ここ](https://papers.nips.cc/paper/293-handwritten-digit-recognition-with-a-back-propagation-network.pdf) にあります。


<!-- ### Shift equivariance -->
### 平行移動不変性

<!-- <center>
    <img src="{{site.baseurl}}/images/week03/03-2/shift_invariance.gif" width="600px" /><br>
    <b>Fig. 2</b> Shift Equivariance
</center> -->
<center>
    <img src="{{site.baseurl}}/images/week03/03-2/shift_invariance.gif" width="600px" /><br>
    <b>図2</b> 平行移動不変性
</center>

<!-- As demonstrated by the animation on the slides(here's another example), translating the input image results in same translation of the feature maps. However, the changes in feature maps are scaled by convolution/pooling operations. E.g. the 2$\times$2 pooling with stride 2 will reduce the 1-pixel shift in input layer to 0.5-pixel shift in the following feature maps. Spatial resolution is then exchanged for increased number of feature types, i.e. making the representation more abstract and less sensitive to shifts and distortions. -->
スライドのアニメーションで示されているように（ここでは別の例です）、入力画像を変換しても特徴マップは同じように変換されます。ただし、特徴マップの変化は、畳み込み・プーリング処理によってスケーリングされます。例えば、ストライド2で2$\times$2のプーリングを行うと、入力レイヤーの1ピクセルの平行移動が、次の特徴マップでは0.5ピクセルの平行移動になります。このようにして、空間分解能は特徴量の増加に交換され、表現はより抽象的になり、平行移動や歪みの影響を受けにくくなります。


<!-- ### Overall architecture breakdown

Generic CNN architecture can be broken down into several basic layer archetypes:

* **Normalisation**
  * Adjusting whitening (optional)
  * Subtractive methods e.g. average removal, high pass filtering
  * Divisive: local contrast normalisation, variance normalisation

* **Filter Banks**
  * Increase dimensionality
  * Projection on overcomplete basis
  * Edge detections

* **Non-linearities**
  * Sparsification
  * Typically Rectified Linear Unit (ReLU): $\text{ReLU}(x) = \max(x, 0)$

* **Pooling**
  * Aggregating over a feature map
  * Max Pooling: $\text{MAX}= \text{Max}_i(X_i)$

  * LP-Norm Pooling:  $$\text{L}p= \left(\sum_{i=1}^n \|X_i\|^p \right)^{\frac{1}{p}}$$

  * Log-Prob Pooling:  $\text{Prob}= \frac{1}{b} \left(\sum_{i=1}^n e^{b X_i} \right)$ -->

### アーキテクチャの全体的な内訳

一般的なCNNアーキテクチャは、いくつかの基本的な層のタイプに分解することができます。

* **正規化**
  * ホワイトニングの調整（オプション）
  * 減算法（例：平均の除去、ハイパスフィルタリング）
  * 局所的なコントラストの正規化、分散の正規化

* **フィルターバンク**
  * 次元を増やす
  * オーバーコンプリートな基底への射影
  * エッジ検出

* **非線形性**
  * スパース化
  * 一般に Rectified Linear Unit (ReLU): $\text{ReLU}(x) = \max(x, 0)$.

* **プーリング**
  * 特徴マップ上での集計
  * Max Pooling: $\text{MAX}= \text{Max}_i(X_i)$

  * LP-Norm Pooling:  $$\text{L}p= \left(\sum_{i=1}^n \|X_i\|^p \right)^{\frac{1}{p}}$$

  * Log-Prob Pooling:  $\text{Prob}= \frac{1}{b} \left(\sum_{i=1}^n e^{b X_i} \right)$


<!-- ## [LeNet5 and digit recognition](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=3830s)


### Implementation of LeNet5 in PyTorch

LeNet5 consists of the following layers (1 being the top-most layer):

1. Log-softmax
2. Fully connected layer of dimensions 500$\times$10
3. ReLu
4. Fully connected layer of dimensions (4$\times$4$\times$50)$\times$500
5. Max Pooling of dimensions 2$\times$2, stride of 2.
6. ReLu
7. Convolution with 20 output channels, 5$\times$5 kernel, stride of 1.
8. Max Pooling of dimensions 2$\times$2, stride of 2.
9. ReLu
10. Convolution with 20 output channels, 5$\times$5 kernel, stride of 1.

The input is a 32$\times$32 grey scale image (1 input channel).

LeNet5 can be implemented in PyTorch with the following code: -->



## [LeNet5と数字の識別](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=3830s)


### PyTorch での LeNet5 の実装

LeNet5は以下の層から構成されています（1は最上層）。

1. Log-softmax
2. 次元が500$\times$10の全結合層
3. ReLu
4. 次元が(4$\times$4$\times$50)$\times$500の全結合層
5. 次元が2$\times$2でストライドが2のMax Pooling層
6. ReLU
7. 出力チャンネル数が20で、カーネルサイズが5$\times$5で、 ストライドが1の畳み込み層
8. 次元が2$\times$2でストライドが2のMax Pooling層
9. ReLU
10. 出力チャンネル数が20で、カーネルサイズが5$\times$5で、 ストライドが1の畳み込み層

入力は32$\times$32のグレースケール画像(1入力チャンネル)です。

LeNet5は以下のコードでPyTorchで実装できます。

```python
class LeNet5(nn.Module):
    def __init__(self):
        super().__init__()
        self.conv1 = nn.Conv2d(1, 20, 5, 1)
        self.conv2 = nn.Conv2d(20, 20, 5, 1)
        self.fc1 = nn.Linear(4*4*50, 500)
        self.fc2 = nn.Linear(500, 10)

    def forward(self, x):
        x = F.relu(self.conv1(x))
        x = F.max_pool2d(x, 2, 2)
        x = F.relu(self.conv2(x))
        x = F.max_pool2d(x, 2, 2)
        x = x.view(-1, 4*4*50)
        x = F.relu(self.fc1)
        x = self.fc2(x)
    return F.logsoftmax(x, dim=1)
```

<!-- Although `fc1` and `fc2` are fully connected layers, they can be thought of as convolutional layers whose kernels cover the entire input. Fully connected layers are used for efficiency purposes.

The same code can be expressed using `nn.Sequential`, but it is outdated. -->

`fc1` と `fc2` は全結合層ですが、 カーネルが入力全体をカバーする畳み込み層と考えることができます。全結合層は効率化のために使われます。

同じコードを `nn.Sequential` を用いて表現することもできますが、それは時代遅れです。

<!-- ## Advantages of CNN

In a fully convolutional network, there is no need to specify the size of the input. However, changing the size of the input changes the size of the output.

Consider a cursive hand-writing recognition system. We do not have to break the input image into segments. We can apply the CNN over the entire image: the kernels will cover all locations in the entire image and record the same output regardless of where the pattern is located. Applying the CNN over an entire image is much cheaper than applying it at multiple locations separately. No prior segmentation is required, which is a relief because the task of segmenting an image is similar to recognizing an image.


### Example: MNIST

LeNet5 is trained on MNIST images of size 32$\times$32 to classify individual digits in the centre of the image. Data augmentation was applied by shifting the digit around, changing the size of the digit, inserting digits to the side. It was also trained with an 11-th category which represented none of the above. Images labelled by this category were generated either by producing blank images, or placing digits at the side but not the centre. -->

## CNNの利点

完全畳み込みネットワークでは、入力のサイズを指定する必要はありません。しかし、入力のサイズを変更すると、出力のサイズが変化します。

草書体の手書き識別するシステムを考えてみましょう。入力画像をセグメントに分割する必要はありません。カーネルは画像全体のすべての位置をカバーし、パターンがどこにあっても同じ出力を記録します。画像全体にCNNを適用することは、複数の場所に個別に適用するよりもはるかに安価です。事前のセグメンテーションが不要なので、画像をセグメンテーションする作業は画像を認識する作業と似ているので安心です。


### 例：MNIST

LeNet5は、サイズ32$\times$32のMNIST画像上で学習し、画像の中央にある個々の数字を分類します。データの拡張は、数字をずらしたり、数字の大きさを変えたり、横に数字を挿入したりして行いました。また、上述したような画像中央に数字がある10種類の画像のいずれにも該当しない、11番目のカテゴリでも学習しました。このカテゴリでラベル付けされた画像は、空白の画像とするか、中央ではなく横に数字を配置することで生成しました。

<!-- <center>
    <img src="{{site.baseurl}}/images/week03/03-2/various_input.gif" width="600px" /><br>
    <b>Fig. 3</b> Sliding Window ConvNet
</center> -->
<center>
    <img src="{{site.baseurl}}/images/week03/03-2/various_input.gif" width="600px" /><br>
    <b>図3</b> スライディングウィンドウ畳み込みニューラルネット
</center>

<!-- 
The above image demonstrates that a LeNet5 network trained on 32$\times$32 can be applied on a 32$\times$64 input image to recognise the digit at multiple locations. -->
上の画像は、32$\times$32で学習したLeNet5ネットワークを32$\times$64の入力画像に適用することで、様々な位置の数字を識別できることを示しています。


<!-- ## [Feature binding problem](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=4827s) -->
## [特徴結合問題](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=4827s)


<!-- ### What is the feature binding problem?

Visual neural scientists and computer vision people have the problem of defining the object as an object. An object is a collection of features, but how to bind all of the features to form this object? -->

### 特徴結合問題とは？

視覚神経科学者やコンピュータビジョンの研究者たちは、オブジェクトをオブジェクトとして定義する問題を抱えています。オブジェクトは特徴の集合体です。このオブジェクトを形成するために、すべての特徴を結合するにはどうすればよいのでしょうか？


<!-- ### How to solve it?

We can solve this feature binding problem by using a very simple CNN: only two layers of convolutions with poolings plus another two fully connected layers without any specific mechanism for it, given that we have enough non-linearities and data to train our CNN. -->

### どうやって解決するのか？

CNNを訓練するのに十分な非線形性とデータがあれば、そのための特別なメカニズムを持たずに、プーリングを持つ2層の畳み込みと、さらに2層の全結合層だけで、この特徴結合の問題を解決することができます。
<!-- 
<center>
    <img src="{{site.baseurl}}/images/week03/03-2/feature_binding.gif" width="600px" /><br>
    <b>Fig. 4</b> ConvNet Addressing Feature Binding
</center> -->
<center>
    <img src="{{site.baseurl}}/images/week03/03-2/feature_binding.gif" width="600px" /><br>
    <b>図4</b> 特徴結合問題に対処する畳み込みニューラルネット
</center>

<!-- The above animation showcases the ability of CNN to recognize different digits by moving a single stroke around, demonstrating its ability to address feature binding problems, i.e. recognizing features in a hierarchical, compositional way. -->
上のアニメーションでは、CNNが一つのストロークを移動させることで異なる数字を識別する能力を示しています。これは、CNNが特徴結合問題に対処する能力、つまり階層的で構成的な方法で特徴を識別する能力を持つことを示しています。

<!-- ### Example: dynamic input length

We can build a CNN with 2 convolution layers with stride 1 and 2 pooling layers with stride 2 such that the overall stride is 4. Thus, if we want to get a new output, we need to shift our input window by 4. To be more explicit, we can see the figure below (green units). First, we have an input of size 10, and we perform convolution of size 3 to get 8 units. After that, we perform pooling of size 2 to get 4 units. Similarly, we repeat the convolution and pooling again and eventually we get 1 output. -->

### 例: 可変な入力サイズ

全体のストライドが4になるように、ストライド1の畳み込み層を2つもちストライドが2のプーリング層を2つ持つCNNを構築することができます。したがって、新しい出力を得たい場合は、入力ウィンドウを4だけずらす必要があります。言いたいことをより明確にするために、下の図（緑のユニット）を見てください（図中の緑のユニット）。まず、サイズ10の入力があり、これに対してサイズ3の畳み込みを行い、8個のユニットを得ます。その後、サイズ2のプーリングを行い、4個のユニットを得ます。同様に、再び畳み込みとプーリングを繰り返し、最終的には1個の出力が得られます。
<!-- <center>
    <img src="{{site.baseurl}}/images/week03/03-2/example.jpg" width="600px" /><br>
    <b>Fig. 5</b> ConvNet Architecture On Variant Input Size Binding
</center> -->
<center>
    <img src="{{site.baseurl}}/images/week03/03-2/example.jpg" width="600px" /><br>
    <b>図5</b> 様々な入力サイズのバインディングについてのConvNetアーキテクチャ
</center>

<!-- Let’s assume we add 4 units at the input layer (pink units above), so that we can get 4 more units after the first convolution layer, 2 more units after the first pooling layer, 2 more units after the second convolution layer, and 1 more output. Therefore, window size to generate a new output is 4 (2 stride $\times$2)<!--the overall subsampling we have shown from input to output is 4 (2x2)-->
<!-- . Moreover, this is a demonstration of the fact that if we increase the size of the input, we will increase the size of every layer, proving CNNs' capability in handling dynamic length inputs. --> -->
ここで、入力層に4個のユニット（上のピンク色のユニット）を追加すると、第1の畳み込み層の後にさらに4個、第1のプーリング層の後にさらに2個、第2の畳み込み層の後にさらに2個、の隠れ層の出力が、そして1個の最終的な出力が得られることになります。したがって、新たな出力を生成するためのウィンドウサイズは4 (2 ストライド $\times$2)<!--入力から出力までの全体的なサブサンプリングは4 (2x2)-->となります。さらに、これは、入力のサイズを大きくすれば、すべての層のサイズも大きくなることを示しています。すなわち、CNNが可変長の入力を扱う能力を持っていることを証明しています。

<!-- ## What are CNN good for

CNNs are good for natural signals that come in the form of multidimensional arrays and have three major properties:
1. **Locality**: The first one is that there is a strong local correlation between values. If we take two nearby pixels of a natural image, those pixels are very likely to have the same colour. As two pixels become further apart, the similarity between them will decrease. The local correlations can help us detect local features, which is what the CNNs are doing. If we feed the CNN with permuted pixels, it will not perform well at recognizing the input images, while FC will not be affected. The local correlation justifies local connections.
2. **Stationarity**: Second character is that the features are essential and can appear anywhere on the image, justifying the shared weights and pooling. Moreover, statistical signals are uniformly distributed, which means we need to repeat the feature detection for every location on the input image.
3. **Compositionality**: Third character is that the natural images are compositional, meaning the features compose an image in a hierarhical manner. This justifies the use of multiple layers of neurons, which also corresponds closely with Hubel and Weisel's research on simple and complex cells.

Furthermore, people make good use of CNNs on videos, images, texts, and speech recognition. -->

## CNNは何に適しているのか？

CNNは多次元配列の形をした自然にある信号の処理に適しており、3つの大きな特性を持っています。

1. **局所性**：　1つ目は、値の間に強い局所的な相関があることです。自然画像の中の互いに近い2つのピクセルを取ると、それらのピクセルは同じ色を持っている可能性が非常に高いです。2つのピクセルが遠くなるにつれて、それらの間の類似性は減少します。局所的な相関は、局所的な特徴を検出するのに役立ちます。これがまさにCNNがやっていることです。CNNに並べ替えたピクセルを与えると、入力画像の認識がうまくいかなくなりますが、全結合層は影響を受けません。局所的な相関は局所的なつながりを用いることを正当化します。
2. **定常性**：　第二の特徴は、特徴が本質的であり、画像上のどこにでも現れる可能性があることであり、これは重み共有やプーリングを用いることを正当化します。さらに、信号は一様に分布しているため、入力画像上のすべての場所で特徴検出を繰り返す必要があります。
3. **構成性**：　3つ目の特徴は、自然画像が構成的であるということで、これは特徴が階層的に画像を構成していることを意味します。この特徴は、ニューロンを何層にも分けて使うことを正当化するものであり、ヒューベルとウィーゼルの単純型細胞と複雑型細胞の研究とも密接に対応しています。

さらに、ビデオ、画像、テキスト、音声認識などでCNNはうまく活用されています。
