---
lang-ref: ch.03-1
lang: ja
lecturer: Yann LeCun
title: ニューラルネットワークのパラメータ変換の可視化と畳み込みの基礎概念
authors: Jiuhong Xiao, Trieu Trinh, Elliot Silva, Calliea Pan
date: 10 Feb 2020
typora-root-url: 03-1
translation-date: 7 Sep 2020
translator: Takashi Shinozaki
---


<!-- ## [Visualization of neural networks](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=5s) -->
## [ニューラルネットワークの可視化](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=5s)


<!-- In this section we will visualise the inner workings of a neural network. -->
このセクションでは、ニューラルネットワークの内部動作の可視化を行います。

<!-- <center><img src="{{site.baseurl}}/images/week03/03-1/Network.png" alt="Network" style="zoom:35%;" /><br>
Fig. 1 Network Structure</center>

Figure 1 depicts the structure of the neural network we would like to visualise. Typically, when we draw the structure of a neural network, the input appears on the bottom or on the left, and the output appears on the top side or on the right. In Figure 1, the pink neurons represent the inputs, and the blue neurons represent the outputs. In this network, we have 4 hidden layers (in green), which means we have 6 layers in total (4 hidden layers + 1 input layer + 1 output layer). In this case, we have 2 neurons per hidden layer, and hence the dimension of the weight matrix ($W$) for each layer is 2-by-2. This is because we want to transform our input plane into another plane that we can visualize. -->

<center><img src="{{site.baseurl}}/images/week03/03-1/Network.png" alt="Network" style="zoom:35%;" /><br>
図1: ネットワーク構造</center>

図1は、可視化するニューラルネットワークの構造を示しています。一般的に、ニューラルネットワークを描くときには、入力を下側または左側に、出力を上側または右側に描きます。図1では、ピンク色のニューロンが入力を表し、青色のニューロンが出力を表しています。このネットワークでは4つの隠れ層（緑の部分）があり、合計6層（4つの隠れ層＋1つの入力層＋1つの出力層）で構成されています。この例では隠れ層ごとに2つのニューロンがあるので、各層の重み行列($W$)の次元は2×2になります。これによって入力平面を可視化しやすい別の平面に変換しています。

<!-- <center><img src="{{site.baseurl}}/images/week03/03-1/Visual1.png" alt="Network" style="zoom:35%;" /><br>
Fig. 2 Visualization of folding space</center>

The transformation of each layer is like folding our plane in some specific regions as shown in Figure 2. This folding is very abrupt, this is because all the transformations are performed in the 2D layer. In the experiment, we find that if we have only 2 neurons in each hidden layer, the optimization will take longer; the optimization is easier if we have more neurons in the hidden layers. This leaves us with an important question to consider: Why is it harder to train the network with fewer neurons in the hidden layers? You should consider this question yourself and we will return to it after the visualization of $\texttt{ReLU}$. -->

<center><img src="{{site.baseurl}}/images/week03/03-1/Visual1.png" alt="Network" style="zoom:35%;" /><br>
図2: folding spaceの可視化</center>

各層での変換は、図2のように、ある特定の領域ごとに平面を折りたたむようなことに対応します。これは、すべての変換が2次元で行われているためです。実験から、各隠れ層に2つのニューロンしかない場合には最適化により時間がかかり、より多くのニューロンがあると最適化がより簡単であることがわかりました。このことは検討すべき重要な問題を提起します。隠れ層のニューロン数が少ないと、なぜネットワークを訓練するのが難しいのでしょうか？この問題はあなた自身で考えるべきであり、次の$\texttt{ReLU}$の可視化の後でもう一度この問題に立ち返ります。

| <img src="{{site.baseurl}}/images/week03/03-1/Visual2a.png" alt="Network" style="zoom:45%;" /> | <img src="{{site.baseurl}}/images/week03/03-1/Visual2b.png" alt="Network" style="zoom:45%;" /> |
|(a)|(b)|

<!-- <center>Fig. 3 Visualization of ReLU operator</center>

When we step through the network one hidden layer at a time, we see that with each layer we perform some affine transformation followed by applying the non-linear ReLU operation, which eliminates any negative values. In Figures 3(a) and (b), we can see the visualisation of ReLU operator. The ReLU operator helps us to do non-linear transformations. After mutliple steps of performing an affine transformation followed by the ReLU operator, we are eventually able to linearly separate the data as can be seen in Figure 4. -->

<!-- <center>Fig. 3 Visualization of ReLU operator</center> -->
<center>図3: ReLU演算の可視化</center>

ネットワークの隠れ層を1層ずつ進んでいくと、各層でアフィン変換が行われ、その後に非線形のReLU演算が適用されることで、負の値が除去されていくことがわかります。図3(a)と(b)に、ReLU演算子の可視化の結果を示します。ReLU演算子は非線形変換を行うのに役立ちます。ReLU演算子をともなったアフィン変換を何度も実行することによって、最終的には図4に示すように、データを線形分離することができます。

<!-- <center><img src="{{site.baseurl}}/images/week03/03-1/Visual3.png" alt="Network" style="zoom:30%;" /><br>
Fig. 4 Visualization of Outputs</center>

This provides us with some insight into why the 2-neuron hidden layers are harder to train. Our 6-layer network has one bias in each hidden layers. Therefore if one of these biases moves points out of top-right quadrant, then applying the ReLU operator will eliminate these points to zero. After that, no matter how later layers transform the data, the values will remain zero. We can make a neural network easier to train by making the network "fatter" - i.e. adding more neurons in hidden layers - or we can add more hidden layers, or a combination of the two methods. Throughout this course we will explore how to determine the best network architecture for a given problem, stay tuned. -->

<center><img src="{{site.baseurl}}/images/week03/03-1/Visual3.png" alt="Network" style="zoom:30%;" /><br>
図4: 出力の可視化</center>

この結果は、2つのニューロンからなる隠れ層が訓練しにくい理由についての、いくつかの洞察を与えてくれます。この6層ネットワークは、各隠れ層ごとに1つのバイアスを持っています。したがって、これらのバイアスのうちの1つが右上の象限から点を移動させた場合、その点の値はReLU演算子によってゼロになります。値が一度ゼロになると、後の層がどのようにデータを変換しても、値はゼロのままです。ニューラルネットワークを「太く」する - 具体的には隠れ層により多くのニューロンを追加する - あるいはより多くの隠れ層を追加するか、またはその両方を行うことによって - 訓練しやすくすることができます。このコースでは、与えられた問題に対して最適なネットワークアーキテクチャを決定する方法を探っていきます。

<!-- ## [Parameter transformations](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=477s) -->
## [パラーメータ変換](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=477s)

<!-- General parameter transformation means that our parameter vector $w$ is the output of a function. By this transformation, we can map original parameter space into another space. In Figure 5, $w$ is actually the output of $H$ with the parameter $u$. $G(x,w)$ is a network and $C(y,\bar y)$ is a cost function. The backpropagation formula is also adapted as follows, -->

一般的なパラメータ変換とは、パラメータベクトル$w$が関数の出力であることを意味します。この変換によって、元のパラメータ空間を別の空間に写すことができます。図5で$w$はパラメータ$u$を持つ$H$の出力であり、$G(x,w)$はネットワーク関数、$C(y,\bar y)$はコスト関数となります。この時、バックプロパゲーションは以下のように適用することができます。

$$
u \leftarrow u - \eta\frac{\partial H}{\partial u}^\top\frac{\partial C}{\partial w}^\top
$$

$$
w \leftarrow w - \eta\frac{\partial H}{\partial u}\frac{\partial H}{\partial u}^\top\frac{\partial C}{\partial w}^\top
$$

<!-- These formulas are applied in a matrix form. Note that the dimensions of the terms should be consistent. The dimension of $u$,$w$,$\frac{\partial H}{\partial u}^\top$,$\frac{\partial C}{\partial w}^\top$ are $[N_u \times 1]$,$[N_w \times 1]$,$[N_u \times N_w]$,$[N_w \times 1]$, respectively. Therefore, the dimension of our backpropagation formula is consistent. -->

これらの式は行列演算として適用されます。なお、各項の次元は一致している必要があります。$u$,$w$,$\frac{\partial H}{\partial u}^\top$,$\frac{\partial C}{\partial w}^\top$の次元は、それぞれ、$[N_u \times 1]$,$[N_w \times 1]$,$[N_u \times N_w]$,$[N_w \times 1]$,$[N_w \times 1]$となります。したがって、バックプロパゲーションの次元は一致していることになります。


<!-- <center><img src="{{site.baseurl}}/images/week03/03-1/PT.png" alt="Network" style="zoom:35%;" /><br>
Fig. 5 General Form of Parameter Transformations</center> -->
<center><img src="{{site.baseurl}}/images/week03/03-1/PT.png" alt="Network" style="zoom:35%;" /><br>
図5 一般的なパラメータ変換の形式</center>

<!-- ### A simple parameter transformation: weight sharing -->
### シンプルなパラメータ変換: 重み共有

<!-- A Weight Sharing Transformation means $H(u)$ just replicates one component of $u$ into multiple components of $w$. $H(u)$ is like a **Y** branch to copy $u_1$ to $w_1$, $w_2$. This can be expressed as, -->

重み共有変換とは、単一の$u$に由来する$H(u)$を、複数の$w$に複製することを意味します。つまり$H(u)$は、$u_1$を$w_1$, $w_2$へと複製するY字型分岐のようなものとなり、次のように表すことができます。

$$
w_1 = w_2 = u_1, w_3 = w_4 = u_2
$$

<!-- We force shared parameters to be equal, so the gradient w.r.t. to shared parameters will be summed in the backprop. For example the gradient of the cost function $C(y, \bar y)$ with respect to $u_1$ will be the sum of the gradient of the cost function $C(y, \bar y)$ with respect to $w_1$ and the gradient of the cost function $C(y, \bar y)$ with respect to $w_2$. -->

共有パラメーターが等しくなるように強制するため、共有されたパラメータの勾配はバックプロパゲーション時に足し合わされます。たとえば、$u_1$に関するコスト関数$C(y, \bar y)$の勾配は、$w_1$に関するコスト関数$C(y, \bar y)$の勾配と、$w_2$に関するコスト関数$C(y, \bar y)$の勾配との合計となります。


<!-- ### Hypernetwork -->
### ハイパーネットワーク

<!-- A hypernetwork is a network where the weights of one network is the output of another network. Figure 6 shows the computation graph of a "hypernetwork". Here the function $H$ is a network with parameter vector $u$ and input $x$. As a result, the weights of $G(x,w)$ are dynamically configured by the network $H(x,u)$. Although this is an old idea, it remains very powerful. -->

ハイパーネットワークとは、あるネットワークの重みが別のネットワークの出力であるネットワークのことです。図6は「ハイパーネットワーク」の計算グラフを示しています。ここで関数$H$は、パラメータベクトル$u$と入力$x$を持つネットワークとなっており、$G(x,w)$の重みは、ネットワーク$H(x,u)$によって動的に設定されます。ハイパーネットワークは古くからある考え方ですが、今でも非常に強力な方法であることに変わりはありません。

<center><img src="{{site.baseurl}}/images/week03/03-1/HyperNetwork.png" alt="Network" style="zoom:35%;" /><br>
<!-- Fig. 6 "Hypernetwork"</center> -->
図6: 「ハイパーネットワーク」の構造</center>


<!-- ### Motif detection in sequential data -->
### 連続したデータにおけるモチーフ検出

<!-- Weight sharing transformation can be applied to motif detection. Motif detection means to find some motifs in sequential data like keywords in speech or text. One way to achieve this, as shown in Figure 7, is to use a sliding window on data, which moves the weight-sharing function to detect a particular motif (i.e. a particular sound in speech signal), and the outputs (i.e. a score) goes into a maximum function. -->

重み共有変換はモチーフ検出に応用することができます。モチーフ検出とは、音声やテキストのキーワードのように、連続したデータの中からいくつかのモチーフを見つけることを意味します。これを実現する方法の一つとして、図7に示すように、データ上で移動窓を使用して、特定のモチーフ(例えば、音声信号中の特定の音)を検出するために重み共有関数を移動させ、その出力(例えば、スコア)をmax関数によって統合します。

<center><img src="{{site.baseurl}}/images/week03/03-1/Motif.png" alt="Network" style="zoom:30%;" /><br>
<!-- Fig. 7 Motif Detection for Sequential Data</center> -->
図7: 連続したデータでのモチーフ検出</center>

<!-- In this example we have 5 of those functions. As a result of this solution, we sum up five gradients and backpropagate the error to update the parameter $w$. When implementing this in PyTorch, we want to prevent the implicit accumulation of these gradients, so we need to use `zero_grad()` to initialize the gradient. -->

図7の例では5つの重み共有関数を用意しています。この解決策の結果、5つの勾配を合計し、誤差を逆伝播させてパラメータ$w$を更新しています。PyTorchでこれを実装するには、これらの勾配が暗黙のうちに足し合わされるのを防ぐため、`zero_grad()`を使って勾配を初期化する必要があります。


<!-- ### Motif detection in images -->
### 画像におけるモチーフ検出

<!-- The other useful application is motif detection in images. We usually swipe our "templates" over images to detect the shapes independent of position and distortion of the shapes. A simple example is to distinguish between "C" and "D",  as Figure 8 shows. The difference between "C" and "D" is that "C" has two endpoints and "D" has two corners. So we can design "endpoint templates" and "corner templates". If the shape is similar to the "templates", it will have thresholded outputs. Then we can distinguish letters from these outputs by summing them up. In Figure 8, the network detects two endpoints and zero corners, so it activates "C". -->

もう一つの応用は画像におけるモチーフ検出です。私たちは通常、画像上で「テンプレート」を走査することによって、位置や形の歪みの影響を受けない形の検出を行っています。簡単な例として「C」と「D」を区別を見てみましょう(図8)。「C」と「D」の違いは、「C」には2つの端点があり、「D」には2つの角があることです。そこで、「端点テンプレート」と「角テンプレート」を設計します。「テンプレート」と似たような形状であれば、閾値を超えた出力を持つことになります。そして、これらの出力を合計することで、「C」と「D」を区別することができます。図8では、ネットワークが2つの端点と0つの角を検出しているので、「C」が活性化されています。

<center><img src="{{site.baseurl}}/images/week03/03-1/MotifImage.png" alt="Network" style="zoom:35%;" /><br>
<!-- Fig. 8 Motif Detection for Images</center> -->
図8: 画像でのモチーフ検出</center>

<!-- It is also important that our "template matching" should be shift-invariant - when we shift the input, the output (i.e. the letter detected) shouldn't change. This can be solved with weight sharing transformation. As Figure 9 shows, when we change the location of "D", we can still detect the corner motifs even though they are shifted. When we sum up the motifs, it will activate the "D" detection. -->

また、このような「テンプレートマッチング」がシフト不変であることも重要です - 入力をシフトさせても、出力（検出された文字）は変化しません。これは、重み共有変換で解決できます。図9に示すように、「D」の位置を変えても、位置のシフトした角のモチーフを検出することができます。モチーフを合計するとによって、「D」を検出することができます。

<center><img src="{{site.baseurl}}/images/week03/03-1/ShiftInvariance.png" alt="Network" style="zoom:35%;" /><br>
<!-- Fig. 9 Shift Invariance</center> -->
図9: シフト不変</center>

<!-- This hand-crafted method of using local detectors and summation to for digit-recognition was used for many years. But it presents us with the following problem: How can we design these "templates" automatically? Can we use neural networks to learn these "templates"? Next, We will introduce the concept of **convolutions** , that is, the operation we use to match images with "templates". -->

局所的な検出器と総和を用いた「hand-crafted」な方法による認識は長年使われてきましたが、同時に次のような問題を提起します。このような「テンプレート」を自動的にデザインすることは可能でしょうか？我々はニューラルネットワークを用いてこのような「テンプレート」を学習させることができるでしょうか？次の節では、**畳み込み**という概念を導入することによって、画像に「テンプレート」を適用する方法を紹介します。


<!-- ## Discrete convolution -->
## 離散的畳み込み


<!-- ### Convolution -->
### 畳み込み

<!-- The precise mathematical definition of a convolution in the 1-dimensional case between input $x$ and $w$ is: -->

入力$x$と$w$との1次元の畳み込みの正確な数学的定義は次のようになります。

$$y_i = \sum_j w_j x_{i-j}$$

<!-- In words, the $i$-th output is computed as the dot product between the **reversed** $w$ and a window of the same size in $x$. To compute the full output, start the window at the beginning, shift this window by one entry each time and repeat until $x$ is exhausted. -->

ここで$i$番目の出力は、**逆順の**$w$と、$w$と同じサイズの窓で切り出された$x$とのドット積として計算されます。すべての出力を計算するためには、窓を先頭から開始して1つずつシフトしてゆき、$x$がなくなるまで繰り返します。


<!-- ### Cross-correlation -->
### 相互相関

<!-- In practice, the convention adopted in deep learning frameworks such as PyTorch is slightly different. Convolution in PyTorch is implemented where $w$ is **not reversed**: -->

実際には、PyTorchなどのディープラーニングのフレームワークで採用されている慣習は少し異なります。PyTorchの畳み込みは、$w$が**逆順とならない**形で実装されています。

$$y_i = \sum_j w_j x_{i+j}$$

<!-- Mathematicians call this formulation "cross-correlation". In our context, this difference is just a difference in convention. Practically, cross-correlation and convolution can be interchangeable if one reads the weights stored in memory forward or backward. -->

数学者はこの定式化を「相互相関」と呼びますが、我々の文脈では，この違いは単なる慣習の違いに過ぎません。実際には、メモリに格納されている重みを前から読むか、後ろから読むかで、相互相関と畳み込みは交換可能です。

<!-- Being aware of this difference is important, for example, when one want to make use of certain mathematical properties of convolution/correlation from mathematical texts. -->

この違いを意識することは、例えば、数学のテキストから、畳み込み/相関の、ある数学的性質を利用したい場合などに重要となります。


<!-- ### Higher dimensional convolution -->
### 高次元の畳み込み

<!-- For two dimensional inputs such as images, we make use of the two dimensional version of convolution: -->

画像のような2次元の入力に対しては，2次元での畳み込みを利用します。

$$y_{ij} = \sum_{kl} w_{kl} x_{i+k, j+l}$$

<!-- This definition can easily be extended beyond two dimensions to three or four dimensions. Here $w$ is called the *convolution kernel* -->

この定義は、2次元以上の3次元や4次元に簡単に拡張することができます。ここでは$w$を*畳み込みカーネル*と呼びます。


<!-- ### Regular twists that can be made with the convolutional operator in DCNNs -->
### DCNNにおける畳み込み演算でよく用いられる特殊なパラメータ

<!-- 1. **Striding**: instead of shifting the window in $x$ one entry at a time, one can do so with a larger step (for example two or three entries at a time).

Example: Suppose the input $x$ is one dimensional and has size of 100 and $w$ has size 5. The output size with a stride of 1 or 2 is shown in the table below:

| Stride       | 1                          | 2                          |
| ------------ | -------------------------- | -------------------------- |
| Output size: | $\frac{100 - (5-1)}{1}=96$ | $\frac{100 - (5-1)}{2}=48$ | -->

1. **ストライド**: $x$内のウィンドウを一度に1エントリずつ移動するのではなく、より大きなステップで移動させます(例えば、一度に2エントリや3エントリを移動します)。
例: 入力$x$が一次元でサイズが100、$w$のサイズが5であるとします。ストライドが1または2の場合の出力サイズは、下の表のようになります。

| ストライド   | 1                          | 2                          |
| ------------ | -------------------------- | -------------------------- |
| 出力サイズ:  | $\frac{100 - (5-1)}{1}=96$ | $\frac{100 - (5-1)}{2}=48$ |

<!-- 2. **Padding**: Very often in designing Deep Neural Networks architectures, we want the output of convolution to be of the same size as the input. This can be achieved by padding the input ends with a number of (typically) zero entries, usually on both sides. Padding is done mostly for convenience. It can sometimes impact performance and result in strange border effects, that said, when using a ReLU non-linearity, zero padding is not unreasonable. -->

2. **パディング**: ディープニューラルネットワークのアーキテクチャを設計する際には、畳み込みの出力を入力と同じサイズにしたいことがよくあります。これは、入力の両端に(通常は)ゼロのエントリをいくつか(通常は両側に)パディングすることで実現できます。パディングは主に利便性のために行われます。これはしばしばパフォーマンスに影響を与え、奇妙な境界効果をもたらすことがありますが、ReLUの非線形性を利用する場合、ゼロパディングは不合理ではありません。


## Deep Convolution Neural Networks (DCNNs)

<!-- As previously described, deep neural networks are typically organized as repeated alternation between linear operators and point-wise nonlinearity layers. In convolutional neural networks, the linear operator will be the convolution operator described above. There is also an optional third type of layer called the pooling layer. -->

前述のように、ディープニューラルネットワークは、典型的には、線形演算の層と要素ごとの非線形演算の層を交互に繰り返されるように構成されています。畳み込みニューラルネットワークでは、線形演算は上述の畳み込み演算となります。また、プーリング層と呼ばれる第３のタイプの層も存在します。

<!-- The reason for stacking multiple such layers is that we want to build a hierarchical representation of the data. CNNs do not have to be limited to processing images, they have also been successfully applied to speech and language. Technically they can be applied to any type of data that comes in the form of arrays, although we also these arrays to satisfy certain properties. -->

このような層を複数重ねる理由は、データの階層的な表現を構築したいからです。CNNは画像の処理のみだけではなく、音声や言語への応用にも成功しています。技術的には、配列で表すことのできるあらゆるタイプのデータに適用できますが、これらの配列は特定の性質を満たす必要があります。

<!-- Why would we want to capture the hierarchical representation of the world? Because the world we live in is compositional. This point is alluded to in previous sections. Such hierarchical nature can be observed from the fact that local pixels assemble to form simple motifs such as oriented edges. These edges in turn are assembled to form local features such as corners, T-junctions, etc. These edges are assembled to form motifs that are even more abstract. We can keep building on these hierarchical representation to eventually form the objects we observe in the real world. -->

なぜ私たちは世界の階層的な表現を獲得したいのでしょうか？それは、私たちが住んでいる世界は構成的だからです。この点については、前のセクションでも触れました。このような階層的な性質は、局所的なピクセルが集まって特定の方向を持つエッジのような単純なモチーフを形成していることなどからも観察することができます。これらのエッジは、コーナーやT字路などの局所的な特徴を形成するために組み合わされます。また、これらのエッジは、より抽象的なモチーフを形成するために組み合わされます。このような階層的な表現を積み重ねることで、最終的には実世界で観測される物体を形成することができるのです。


<center><img src="{{site.baseurl}}/images/week03/03-1/cnn_features.png" alt="CNN Features" style="zoom:35%;" /><br>
<!-- Figure 10. Feature visualization of convolutional net trained on ImageNet from [Zeiler & Fergus 2013]</center> -->
図10: ImageNetで学習された畳み込みネットワークの特徴の可視化 [Zeiler & Fergus 2013]</center>

<!-- This compositional, hierarchical nature we observe in the natural world is therefore not just the result of our visual perception, but also true at the physical level. At the lowest level of description, we have elementary particles, which assembled to form atoms, atoms together form molecules, we continue to build on this process to form materials, parts of objects and eventually full objects in the physical world. -->

私たちが自然界で観察するこの構成的、階層的な性質は、単に私たちの視覚的な知覚の結果ではなく、物理的なレベルでも当てはまります。最も低いレベルの記述では、原子を形成するために集まった素粒子があり、原子が一緒になって分子を形成して、このようなプロセスを繰り返す事によって、物質や物体の一部、そして最終的には完全な物体を形成されます。

<!-- The compositional nature of the world might be the answer to Einstein's rhetorical question on how humans understand the world they live in: -->

世界の構成的性質は、人間が自分たちが住んでいる世界をどのように理解しているかについてのEinsteinの修辞的な質問への答えになるかもしれません。

<!-- > The most incomprehensible thing about the universe is that it is comprehensible. -->
> 宇宙について最も理解できないことは、それが理解可能であるということである。

<!-- The fact that humans understand the world thanks to this compositional nature still seems like a conspiracy to Yann. It is, however, argued that without compositionality, it will take even more magic for humans to comprehend the world they live in. Quoting the great mathematician Stuart Geman: -->

人間がこの構成性のおかげで世界を理解しているという事実は、陰謀のようにも思えてしまいます。しかし、構成性がなければ、人間が自分たちの住んでいる世界を理解するには、さらに魔法が必要になるとも言われています。以下に偉大な数学者Stuart Gemanの言葉を引用します。

<!-- > The world is compositional or God exists. -->
> 世界は構成的であるか、神が存在するかのどちらかである。


<!-- ## [Inspirations from Biology](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=2254s) -->
## [生物からのヒント](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=2254s)

<!-- So why should Deep Learning be rooted in the idea that our world is comprehensible and has a compositional nature? Research conducted by Simon Thorpe helped motivate this further. He showed that the way we recognize everyday objects is extremely fast. His experiments involved flashing a set of images every 100ms, and then asking users to identify these images, which they were able to do successfully. This demonstrated that it takes about 100ms for humans to detect objects. Furthermore, consider the diagram below, illustrating parts of the brain annotated with the time it takes for neurons to propagate from one area to the next: -->

なぜディープラーニングは、私たちの世界は理解可能であり、構成的な性質を持っているという考えに根ざしたものでなければならないのでしょうか？Simon Thorpeが行った研究は、このような考えをさらに推し進めることに役立ちます。Thropeは、私たちが日常的な物体を認識する方法が非常に高速であることを示しました。実験で、100ミリ秒ごとに一組の画像を点滅させ、被験者に画像を識別してもらったところ、きちんと識別できることがわかりました。これは人間が物体を検出するのに約100ミリ秒かかることを示しています。下の図は、目から入った信号が脳の各部位をどのくらいの時間で伝わっているかを示したものです。

<center><img src="{{site.baseurl}}/images/week03/03-1/Simon_Thorpe.png" alt="Simon_Thorpe" style="zoom:55%;" /></center>

<!-- <div align="center">Figure 11. Simon Thorpe's model of visual information flow in the brain <div> -->
<div align="center">図11: Simon Thorpeの脳における視覚情報処理のモデル<div>

<!-- Signals pass from the retina to the LGN (helps with contrast enhancement, gate control, etc.), then to the V1 primary visual cortex, V2, V4, then to the inferotemporal cortex (PIT), which is the part of the brain where categories are defined. Observations from open-brain surgery showed that if you show a human a film, neurons in the PIT will fire only when they detect certain images -- such as Jennifer Aniston or a person's grandmother -- and nothing else. The neural firings are invariant to things such as position, size, illumination, your grandmother's orientation, what she's wearing, etc. -->

信号は、網膜から外側膝状体(lateral geniculate body (LGN), コントラスト強調やゲート制御を行っています)を経て、第1次視覚野(V1)、さらにV2、V4を通って、側頭皮質(PIT)とよばれる物体の種類を分類する脳部位に伝わっていきます。直視下脳手術における実験から、PITのニューロンは特定の画像、例えば有名な女優や被験者のおばあちゃんを見せられたときにのみ発火し、それ以外は発火しないことが知られています。このようなニューロンの活動は、対象の位置や、大きさ、照明、おばあちゃんの向きや服装などに左右されません。

<!-- Furthermore, the fast reaction times with which humans were able to categorize these items -- barely enough time for a few spikes to get through -- demonstrates that it's possible to do this without additional time spent on complex recurrent computations. Rather, this is a single feed-forward process. -->

さらに、人間がこれらの対象を識別するための反応時間(数本のスパイクが通過するのにやっとな時間)は、複雑な再帰的計算に余計な時間を費やすことなく、このような識別が可能であることを示しています。つまり、単一のフィードフォワード処理で行われていると考えられます。

<!-- These insights suggested that we could develop a neural network architecture which is completely feed-forward, yet still able to solve the problem of recognition, in a way that is invariant to irrelevant transformations of the input. -->

これらの洞察は、完全にフィードフォワードでありながらも、識別に無関係な変換に影響されずに認識課題を解決できるニューラルネットワークのアーキテクチャを開発できることを示唆しています。

<!-- One further insight from the human brain comes from Gallant & Van Essen, whose model of the human brain illustrates two distinct pathways: -->

人間の脳からのさらなる洞察は、GallantとVan Essenによるもので、彼らのモデルは人間の脳が2つの分離した経路を持つことを示しています。

<center><img src="{{site.baseurl}}/images/week03/03-1/Gallant_and_Van_Essen.png" alt="Gallant_and_Van_Essen" style="zoom:55%;" /></center>

<!-- <div align="center">Figure 12. Gallen & Van Essen's model of dorsal & ventral pathways in the brain <div> -->
<div align="center">図12: GallantとVan Essenによる脳の背側およびに腹側経路のモデル<div>

<!-- The right side shows the ventral pathway, which tells you what you're looking at, while the left side shows the dorsal pathway, which identifies locations, geometry, and motion. They seem fairly separate in the human (and primate) visual cortex (with a few interactions between them of course). -->

図12の右側は何を見ているかを伝える腹側経路を示し、左側は位置、形状、運動を識別する背側経路を示しています。これらは人間(と霊長類)の視覚野ではかなり分離されていると考えられています(もちろん、多少の相互作用はあります)。


<!-- ### Hubel & Weisel's contributions (1962) -->
### HubelとWeiselによる研究 (1962)

<center><img src="{{site.baseurl}}/images/week03/03-1/Hubel_and_Weisel.png" alt="Hubel_and_Weisel" style="zoom:55%;" /></center>

<!-- <div align="center">Figure 13. Hubel & Weisel's experiments with visual stimuli in cat brains <div> -->
<div align="center">図13: HubelとWeiselによる猫の脳における視覚実験<div>

<!-- Hubel and Weisel experiments used electrodes to measure neural firings in cat brains in response to visual stimuli. They discovered that neurons in the V1 region are only sensitive to certain areas of a visual field (called "receptive fields"), and detect oriented edges in that area. For example, they demonstrated that if you showed the cat a vertical bar and start rotating it, at a particular angle the neuron will fire. Similarly, as the bar moves away from that angle, the activation of the neuron diminishes. These activation-selective neurons Hubel & Weisel named "simple cells", for their ability to detect local features. -->

HubelとWeiselは、電極を使って、視覚刺激に対応する猫の脳内の神経発火を測定しました。彼らは、V1領域のニューロンは、視野の特定の領域(「受容野」と呼ばれます)だけに反応し、その領域の特定の方向のエッジを検出することを発見しました。例えば、猫に回転する真っ直ぐな棒を見せると、特定の角度の時にニューロンが発火し、特定の角度から遠ざかるにつれて、活動が減少することを確認しました。これらの特徴選択的に活動するニューロンを、HubelとWeiselは、局所的な特徴を検出することから「単純細胞」と名付けました。

<!-- They also discovered that if you move the bar out of the receptive field, that particular neuron doesn't fire any more, but another neuron will. There are local feature detectors corresponding to all areas of the visual field, hence the idea that the human brain processes visual information as a collection of "convolutions". -->

また彼らは、ある特徴選択的なニューロンは、棒を受容野の外に移動させると発火しなくなりますが、今度は別のニューロンが発火することを発見しました。視野全体にこのような局所的な特徴検出器がまんべんなく存在することから、人間の脳は視覚情報を「畳み込み」の集合体として処理していると考えることができます。

<!-- Another type of neuron, which they named "complex cells", aggregate the output of multiple simple cells within a certain area. We can think of these as computing an aggregate of the activations using a function such as maximum, sum, sum of squares, or any other function not depending on the order. These complex cells detect edges and orientations in a region, regardless of where those stimuli lie specifically within the region. In other words, they are shift-invariant with respect to small variations in positions of the input. -->

もう一つのタイプのニューロンは、彼らが「複雑細胞」と名付けたもので、ある領域内の複数の単純細胞の出力を集約します。これは、最大値、総和、二乗和などの関数や、順序に依存しないその他の関数を使って、活動の集合を計算していると考えることができます。これらの複雑細胞は、領域内のどこに刺激があるかに関係なく、領域内のエッジや方位を検出します。これは、入力の位置のわずかな変化に対してシフト不変であると言い換えることができます。


<!-- ### Fukushima's contributions (1982) -->
### 福島による研究 (1982)

<center><img src="{{site.baseurl}}/images/week03/03-1/Fukushima.png" alt="Fukushima" style="zoom:55%;" /></center>

<!-- <div align="center">Figure 14. Fukushima's CNN model <div>

Fukushima was the first to implement the idea of multiple layers of simple cells and complex cells with computer models, using a dataset of handwritten digits. Some of these feature detectors were hand-crafted or learned, though the learning used unsupervised clustering algorithms, trained separately for each layer, as backpropagation was not yet in use.

Yann LeCun came in a few years later (1989, 1998) and implemented the same architecture, but this time trained them in a supervised setting using backpropagation. This is widely regarded as the genesis of modern convolutional neural networks. (Note: Riesenhuber at MIT in 1999 also re-discovered this architecture, though he didn't use backpropagation.) -->

<div align="center">図14: 福島のCNNモデル<div>

福島は1982年に、単純細胞と複雑細胞によっての構成された多層の畳み込みニューラルネットワークのモデルを世界で初めて実装し、手書き数字のデータセットに適用しました。ネットワークの特徴検出器はhand-craftedであるか、もしくは学習によって獲得されるものとなっていましたが、学習にバックプロパゲーションはまだ用いられておらず、教師なしのクラスタリングアルゴリズムによって各層ごとに別々に学習していました。

数年後（1989、1998年）に Yann LeCun が、同様のアーキテクチャを実装し、バックプロパゲーションを用いて教師ありの設定での学習を実現しました。一般的にはこれが現代の畳み込みニューラルネットワークの起源とみなされています。(注: 1999年にMITのRiesenhuberもこのアーキテクチャを再発見しましたが、彼はバックプロパゲーションを使用していませんでした)。
