---
lang-ref: ch.02-3
lang: ja
title: 人工ニューラルネットワーク(ANN)
lecturer: Alfredo Canziani
authors:
date: 4 Feb 2020
typora-root-url: 02-3
translation-date: 2 Dec 2020
translator: Shiro Takagi
---

<!-- ## [Supervised learning for classification](https://www.youtube.com/watch?v=WAn6lip5oWk&t=150s) -->
## [分類のための教師あり学習](https://www.youtube.com/watch?v=WAn6lip5oWk&t=150s)

<!-- * Consider **Fig. 1(a)** below. The points in this graph lie on the branches of the spiral, and live in $\R^2$. Each colour represents a class label. The number of unique classes is $K = 3$. This is represented mathematically by **Eqn. 1(a)**.

* **Fig. 1(b)** shows a similar spiral, with an added Gaussian noise term. This is represented mathematically by **Eqn. 1(b)**.

  In both cases, these points are not linearly separable. -->

* 下の **図1(a)** を考えてみましょう。このグラフの点は、螺旋の枝の上にあり、$\R^2$の中にいます。それぞれの色はクラスのラベルを表しています。一意なクラスの数は $K = 3$ です。これは、数学的には、**式1(a)** で表されます。

* **図1(b)** は、ガウスノイズ項を加えた、同様の螺旋を示しています。これは数学的には **式1(b)** で表されます。

  どちらの場合も、これらの点は線形分離不可能です。

  <!-- <center>
  <table border="0">
    <td>
      <center>
    <img src="{{site.baseurl}}/images/week02/02-3/clean-spiral.png" width="350px" /><br>
       <b>Fig. 1(a)</b> "Clean" 2D spiral
       </center>
      </td>
      <td>
      <center>
      <img src="{{site.baseurl}}/images/week02/02-3/noisy-spiral.png" width="350px" /><br>
       <b>Fig. 1(b)</b> "Noisy" 2D spiral
       </center>
      </td>
  </table>
  </center> -->

  <center>
  <table border="0">
    <td>
      <center>
    <img src="{{site.baseurl}}/images/week02/02-3/clean-spiral.png" width="350px" /><br>
       <b>図1(a)</b> 「ノイズがない」２次元螺旋
       </center>
      </td>
      <td>
      <center>
      <img src="{{site.baseurl}}/images/week02/02-3/noisy-spiral.png" width="350px" /><br>
       <b>図1(b)</b> 「ノイズがある」２次元螺旋
       </center>
      </td>
  </table>
  </center>


$$
X_{k}(t)=t\left(\begin{array}{c}{\sin \left[\frac{2 \pi}{K}(2 t+k-1)\right]} \\ {\cos \left[\frac{2 \pi}{K}(2 t+k-1)\right]}\end{array}\right) \\
0 \leq t \leq 1, \quad k=1, ..., K
$$

  <!-- <center><b>Eqn. 1(a)</b> </center> -->
  <center><b>式1(a)</b> </center>

$$
  X_{k}(t)=t\left(\begin{array}{c}{\sin \left[\frac{2 \pi}{K}(2 t+k-1 +\mathcal{N}\left(0, \sigma^{2}\right))\right]} \\ {\cos \left[\frac{2 \pi}{K}(2 t+k-1 +\mathcal{N}\left(0, \sigma^{2}\right))\right]}\end{array}\right)\\0 \leq t \leq 1, \quad k=1, ..., K
$$

<!-- <center><b>Eqn. 1(b)</b></center> -->
<center><b>式1(b)</b></center>

<!-- What does it mean to perform **classification**? Consider the case of **logistic regression**. If logistic regression for classification is applied to this data, it will create a set of **linear planes** (decision boundaries) in an attempt to separate the data into its classes. The issue with this solution is that in each region, there are points belonging to multiple classes. The branches of the spiral cross the linear decision boundaries. This is **not** a great solution!

**How do we fix this?** We transform the input space such that the data are forced to be linearly separable. Over the course of training a neural network to do this, the decision boundaries that it learns will try to adapt to the distribution of the training data.

**Note:** A neural network is always represented from the **bottom up**. The first layer is at the bottom, and the last at the top. This is because conceptually, the input data are low-level features for whatever task the neural network is attempting. As the data traverse **upward** through the network, each subsequent layer extracts features at a higher level. -->

**分類**を行うとはどういうことでしょうか？ **ロジスティック回帰**の場合を考えてみましょう。分類のためのロジスティック回帰がこのデータに適用された場合、データをそのクラスに分離しようとして、**線形平面**（決定境界）の集合を作成します。この解決策の問題点は、各領域に複数のクラスに属する点があることです。螺旋の枝は線形決定境界を横切っています。これは、**優れた解決策ではありません!**

**どうやってこれを解決するのでしょうか？** 入力空間を線形分離可能になるように変換します。これを行うためにニューラルネットワークを訓練する過程で、ニューラルネットワークが学習する決定境界は訓練データの分布に適応しようとします。

**注**：この講義では、ニューラルネットワークは常に**入力に近い層から順に下から上に**表現されます。最初の層が一番下にあり、最後の層が一番上にあります。これは、概念的には、入力データはニューラルネットワークが試みようとしているタスクのための低次の特徴だからです。データがネットワークを通って**上向き**に移動すると、後続の各層はより高次の特徴を抽出します。

<!-- ## Training data

Last week, we saw that a newly initialised neural network transforms its input in an arbitrary way. This transformation, however, isn't **(initially)** instrumental in performing the task at hand. We explore how, using data, we can force this transformation to have some meaning that is relevant to the task at hand. The following are data used as training input for a network.

* $\vect{X}$ represents the input data, a matrix of dimensions $m$ (number of training data points) x $n$ (dimensionality of each input point). In case of the data shown in Figures **1(a)** and **1(b)**, $n = 2$. -->

## 訓練データ

先週、新しく初期化されたニューラルネットワークが入力を任意の方法で変換することを見ました。しかし、この変換は、目下のタスクを実行するのに **(最初は)** 役に立ちません。データを使用して、どのようにしてこの変換を強制的に、目下のタスクに関連する何らかの意味を持たせることができるかを探ります。以下は、ネットワークの訓練の入力として使用されるデータです。

* $\vect{X}$は入力データを表現しています。これは$m$ (訓練データ点の数) x $n$ (各入力点の次元)の行列です。図**1(a)**、**1(b)** のデータの場合、$n = 2$です。

<!-- <center>
<img src="{{site.baseurl}}/images/week02/02-3/training-data.png" width="600px" /><br>
<b>Fig. 2</b> Training data
</center> -->
<center>
<img src="{{site.baseurl}}/images/week02/02-3/training-data.png" width="600px" /><br>
<b>図2</b> 訓練データ
</center>

<!-- * Vector $\vect{c}$  and matrix $\boldsymbol{Y}$ both represent class labels for each of the $m$ data points. In the example above, there are $3$ distinct classes.

  * $c_i \in \lbrace 1, 2, \cdots, K \rbrace$, and $\vect{c} \in \R^m$. However, we may not use $\vect{c}$ as training data. If we use distinct numeric class labels  $c_i \in \lbrace 1, 2, \cdots, K \rbrace$, the network may infer an order within the classes that isn't representative of the data distribution.
  * To bypass this issue, we use a **one-hot encoding**. For each label $c_i$, a $K$ dimensional zero-vector $\vect{y}^{(i)}$ is created, which has the $c_i$-th element set to $1$ (see **Fig. 3** below). -->

* ベクトル $\vect{c}$ と行列 $\boldsymbol{Y}$ は、それぞれの $m$ データ点のクラスラベルを表しています。上の例では、$3$ 個のクラスがあります。

  * $c_i \in \lbrace 1, 2, \cdots, K \rbrace$, そして $\vect{c} \in \R^m$です。 ただし、訓練データとして $\vect{c}$ を使用しない場合もあります。また、クラスラベルを異なる数値ラベル$c_i \in \lbrace 1, 2, \cdots, K \rbrace$にしてしまうと、クラス内での順序を推測してしまい、データの分布とは異なるものになってしまう可能性があります。
  * この問題を回避するために、**one-hot符号化**を使用します。各ラベル$c_i$に対して、$K$次元のゼロベクトル$\vect{y}^{(i)}$を作成し、$c_i$番目の要素を$1$とします(下図の**図3**参照)。

<!-- <center>
<img src="{{site.baseurl}}/images/week02/02-3/one-hot.png" width="250px" /><br>
<b>Fig. 3</b> One hot encoding
</center> -->
<center>
<img src="{{site.baseurl}}/images/week02/02-3/one-hot.png" width="250px" /><br>
<b>図3</b> one-hot符号化
</center>

  <!-- * Therefore, $\boldsymbol Y \in \R^{m \times K}$. This matrix can also be thought of as having some probabilistic mass, which is fully concentrated on one of the $$K$$ spots. -->
  * よって、$\boldsymbol Y \in \R^{m \times K}$です。この行列は、$$K$$の一つの点に完全に集中しているある確率質量を持っていると考えることもできます。

<!-- ## Fully (FC) connected layers -->
## 全結合層

<!-- We will now take a look at what a fully connected (FC) network is, and how it works. -->
ここでは、全結合（FC）ネットワークとは何か、その仕組みを見ていきましょう。

<!-- <center>
<img src="{{site.baseurl}}/images/week02/02-3/FC-net.png" height="250px" /><br>
<b>Fig. 4</b> Fully connected neural network
</center> -->
<center>
<img src="{{site.baseurl}}/images/week02/02-3/FC-net.png" height="250px" /><br>
<b>図4</b> 全結合ニューラルネットワーク
</center>

<!-- Consider the network shown above in **Fig. 4**. The input data, $\boldsymbol x$, is subject to an affine transformation defined by $ \boldsymbol W_h$, followed by a non-linear transformation. The result of this non-linear transformation is denoted as $\boldsymbol h$, representing a **hidden** output, i.e. one that is not **seen** from outside the network. This is followed by another affine transformation ($\boldsymbol W_y$), followed by another non-linear transformation. This produces the final output, $\boldsymbol{ \hat{y}} $. This network can be represented mathematically by the equations in **Eqn. 2** below. $$f$$ and $$g$$ are both non-linearities. -->

**図4** のネットワークを考えてみましょう。入力データである$\boldsymbol x$には、$\boldsymbol W_h$で定義されたアフィン変換が行われ、その後、非線形変換が行われます。この非線形変換の結果を $\boldsymbol h$ と呼びます。これは**隠れ層の出力**、つまりネットワークの外から見ることのできない出力を表しています。これに対して、別のアフィン変換（$\boldsymbol W_y$）に続いて、別の非線形変換が行われます。これが最終的な出力である$\boldsymbol{\hat{y}}$ を生成します。このネットワークは、以下の **式2** で数学的に表すことができます。ここで、$f$と$g$はともに非線形活性化関数です。

$$
\begin{aligned}
&\boldsymbol h=f\left(\boldsymbol{W}_{h} \boldsymbol x+ \boldsymbol b_{h}\right)\\
&\boldsymbol{\hat{y}}=g\left(\boldsymbol{W}_{y} \boldsymbol h+ \boldsymbol b_{y}\right)
\end{aligned}
$$

<!-- <center><b>Eqn. 2</b> Mathematics behind a FC network</center> -->
<center><b>式2</b> FCネットワークの背後にある数学</center>

<!-- A basic neural network such as the one shown above is merely a set of successive pairs, with each pair being an affine transformation followed by a non-linear operation (squashing). Frequently used non-linear functions include ReLU, sigmoid, hyperbolic tangent, and softmax.

The network shown above is a 3-layer network:

 1. input neuron
 2. hidden neuron
 3. output neuron

Therefore, a $3$-layer neural network has $2$ affine transformations. This can be extrapolated to a $n$-layer network.

Now let's move to a more complicated case.

Let's do a case of 3 hidden layers, fully connected in each layer. An illustration can be found in **Fig. 5** -->

上記のような基本的なニューラルネットワークは、単に連続したペアの集合であり、各ペアではアフィン変換に続いて非線形演算（スカッシング）が行われます。よく使われる非線形関数には、ReLU、シグモイド、tanh、ソフトマックスなどがあります。

上図のネットワークは3層のネットワークです。

 1. 入力ニューロン
 2. 隠れニューロン
 3. 出力ニューロン

したがって、$3$層のニューラルネットワークは、$2$つのアフィン変換を持っています。これは、$n$層のネットワークに一般化することができます。

では、もっと複雑なケースに移りましょう。

3つの隠れ層があり、各層が全結合である場合を考えてみましょう。図は、**図5**にあります。

<!-- <center>
<img src="{{site.baseurl}}/images/week02/02-3/pre-inference4layers.png" /><br>
<b>Fig. 5</b> Neural net with 3 hidden layers
</center> -->
<center>
<img src="{{site.baseurl}}/images/week02/02-3/pre-inference4layers.png" /><br>
<b>図5</b> 三層の隠れ層を持つニューラルネット
</center>

<!-- Let's consider a neuron $j$ in the second layer. It's activation is: -->
第二層のニューロン $j$ を考えてみましょう。そのactivationは

$$
a^{(2)}_j = f(\boldsymbol w^{(j)} \boldsymbol x + b_j) = f\Big( \big(\sum_{i=1}^n w_i^{(j)} x_i\big) +b_j ) \Big)
$$

<!-- where $\vect{w}^{(j)}$ is the $j$-th row of $\vect{W}^{(1)}$. -->
となります。ただし、$\vect{w}^{(j)}$は$\vect{W}^{(1)}$の$j$行目です。

<!-- Notice that the activation of the input layer in this case is just the identity. The hidden layers can have activations like ReLU, hyperbolic tangent, sigmoid, soft (arg)max, etc.

The activation of the last layer in general would depend on your use case, as explained in [this](https://piazza.com/class/k5spqaanqk51ks?cid=36) Piazza post. -->

この場合の入力層のactivationは、単なる恒等写像であることに注意してください。隠れ層は、ReLU、tanh、シグモイド、ソフト(arg)maxなどの活性化関数を持つことができます。

一般的に最後の層の活性化関数は、[この](https://piazza.com/class/k5spqaanqk51ks?cid=36) Piazzaの投稿で説明されているように、使用ケースに依存します。


<!-- ## Neural network (inference)

Let's think about the three-layer (input, hidden, output) neural network again, as seen in **Fig. 6** -->

## ニューラルネットワーク (推論)

**図6**にあるような3層（入力、隠れ、出力）のニューラルネットワークについてもう一度考えてみましょう。


<!-- <center>
<img src="{{site.baseurl}}/images/week02/02-3/2-layer-inference.png" height="250px"/><br>
<b>Fig. 6</b> Three-layer neural network
</center> -->
<center>
<img src="{{site.baseurl}}/images/week02/02-3/2-layer-inference.png" height="250px"/><br>
<b>図6</b> 三層ニューラルネットワーク
</center>

<!-- What kind of functions are we looking at? -->
どんな関数を見ているのでしょうか？

$$
\boldsymbol {\hat{y}} = \boldsymbol{\hat{y}(x)}, \boldsymbol{\hat{y}}: \mathbb{R}^n \rightarrow \mathbb{R}^K, \boldsymbol{x} \mapsto \boldsymbol{\hat{y}}
$$

<!-- However, it is helpful to visualize the fact that there is a hidden layer, and the mapping can be expanded as: -->
ただし、隠れ層があることを可視化しておくと便利で、写像を次のように展開することができます。

$$
\boldsymbol{\hat{y}}: \mathbb{R}^{n} \rightarrow \mathbb{R}^d \rightarrow \mathbb{R}^K, d \gg n, K
$$

<!-- What might an example configuration for the case above look like? In this case, one has input of dimension two ($n=2$), the single hidden layer could have dimensionality of 1000 ($d = 1000$), and we have 3 classes ($C=3$). There are good practical reasons to not have so many neurons in one hidden layer, so it could make sense to split that single hidden layer into 3 with 10 neurons each ($1000 \rightarrow 10 \times 10 \times 10$). -->

上記の場合の設定例は、どのように見えるでしょうか？この場合、2次元の入力があり($n=2$)、1つの隠れ層の次元数は1000($d = 1000$)で、3つのクラスがあります($C=3$)。1つの隠れ層にそれほど多くのニューロンを入れたくないという実用的な理由があるので、その1つの隠れ層を10個ずつのニューロンで3つに分割するのは理にかなっているかもしれません ($1000 \rightarrow 10 \times 10 \times 10$)。


<!-- ## [Neural network (training I)](https://www.youtube.com/watch?v=WAn6lip5oWk&t=822s) -->
## [ニューラルネットワーク (訓練I)](https://www.youtube.com/watch?v=WAn6lip5oWk&t=822s)
<!-- 
So what does typical training look like? It is helpful to formulate this into the standard terminology of losses.

First, let us re-introduce the soft (arg)max and explicitly state that it is a common activation function for the last layer, when using negative log-likelihood loss, in cases for multi-class prediction. As stated by Professor LeCun in lecture, this is because you get nicer gradients than if you were to use sigmoids and square loss. In addition, your last layer will already be normalized (the sum of all the neurons in the last layer come out to 1), in a way that is nicer for gradient methods than explicit normalization (dividing by the norm).

The soft (arg)max will give you logits in the last layer that look like this: -->

では、典型的な訓練とはどのようなものなのでしょうか？これを損失の標準的な用語に定式化しておくと便利です。

まず、soft(arg)maxを再導入します。そして、この活性化関数は、多クラス予測のために負の対数尤度損失を使う場合、最後の層に用いられる一般的な活性化関数であることを明示しておきましょう。LeCun教授が講義で述べているように、これは、シグモイドや二乗損失を使用する場合よりも良い勾配を得ることができるからです。さらに、この活性化関数を使うことで、最後の層はすでに正規化された状態になります(最後の層のすべてのニューロンの和が1になります)が、これは明示的な正規化(ノルムで割る)よりも勾配法に適しています。

soft (arg)maxを使うと、最後の層のロジットは次のようになります。

$$
\text{soft{(arg)}max}(\boldsymbol{l})[c] = \frac{ \exp(\boldsymbol{l}[c])}   {\sum^K_{k=1} \exp(\boldsymbol{l}[k])}  \in (0, 1)
$$
<!-- 
It is important to note that the set is not closed because of the strictly positive nature of the exponential function.

Given the set of the predictions $\matr{\hat{Y}}$, the loss will be: -->

指数関数は厳密に正であるという性質を持つため、集合は閉じていないことに注意してください。

予測値の集合が $\matr{\hat{Y}}$ であるとすると、損失は次のようになります。

$$
\mathcal{L}(\boldsymbol{\hat{Y}}, \boldsymbol{c}) = \frac{1}{m} \sum_{i=1}^m \ell(\boldsymbol{\hat{y}_i}, c_i), \quad
\ell(\boldsymbol{\hat{y}}, c) = -\log(\boldsymbol{\hat{y}}[c])
$$

<!-- Here c denotes the integer label, not the one hot encoding representation.

So let's do two examples, one where an example is correctly classified, and one where it is not.

Let's say -->

ここで $c$ は整数のラベルを表し、one-hot符号化の表現ではありません。

そこで、あるサンプルが正しく分類されている場合とそうでない場合の 2 つの例をやってみましょう。

以下のようにしましょう。

$$
\boldsymbol{x}, c = 1 \Rightarrow \boldsymbol{y} =
{\footnotesize\begin{pmatrix}
1 \\
0 \\
0
\end{pmatrix}}
$$

<!-- What is the instance wise loss?

For the case of *nearly perfect prediction* ($\sim$ means *circa*): -->

インスタンスごとの損失はどうなるでしょうka
？

ほぼ*完璧な予測*の場合には、（$\sim$ は *おおよそ* の意味）

$$
\hat{\boldsymbol{y}}(\boldsymbol{x}) =
{\footnotesize\begin{pmatrix} \sim 1 \\ \sim 0 \\ \sim 0 \end{pmatrix}}
 \Rightarrow \ell \left(
{\footnotesize\begin{pmatrix} \sim 1 \\ \sim 0 \\ \sim 0 \end{pmatrix}}
, 1\right) \rightarrow 0^{+}
$$

<!-- For the case of *nearly absolutely wrong*: -->
*ほぼ絶対に間違っている*場合には、

$$ \hat{\boldsymbol{y}}(\boldsymbol{x}) =
{\footnotesize\begin{pmatrix} \sim 0 \\ \sim 1 \\ \sim 0 \end{pmatrix}}
\Rightarrow \ell \left(
{\footnotesize\begin{pmatrix} \sim 0 \\ \sim 1 \\ \sim 0 \end{pmatrix}}
, 1\right) \rightarrow +\infty  $$

<!-- Note in the above examples, $\sim 0 \rightarrow 0^{+}$ and $\sim 1 \rightarrow 1^{-}$. Why is this so? Take a minute to think.

**Note**: It is important to know that if you use `CrossEntropyLoss`, you will get `LogSoftMax` and negative loglikelihood `NLLLoss` bundled together, so don't do it twice! -->

上の例では、$\sim 0 \rightarrow 0^{+}$ と $\sim 1 \rightarrow 1^{-}$ となっています。なぜでしょうか？ちょっと考えてみてください。

**注** `CrossEntropyLoss`を使うと、`LogSoftMax`と負の対数尤度`NLLLoss`が一緒になってしまうので、二度手間にならないようにしましょう。


<!-- ## [Neural network (training II)](https://www.youtube.com/watch?v=WAn6lip5oWk&t=2188s) -->
## [ニューラルネットワーク（訓練II）](https://www.youtube.com/watch?v=WAn6lip5oWk&t=2188s)

<!-- For training, we aggregate all trainable parameters -- weight matrices and biases -- into a collection we call $\mathbf{\Theta} = \lbrace\boldsymbol{W_h, b_h, W_y, b_y} \rbrace$. This allows us to write the objective function or loss as: -->

学習のためには、学習可能なパラメータ（重み行列とバイアス）を我々が$\mathbf{\Theta} = \lbrace\boldsymbol{W_h, b_h, W_y, b_y} \rbrace$と呼ぶものに集約します。これにより、目的関数や損失を次のように書くことができます。

$$
J \left( \mathbf{\Theta} \right) = \mathcal{L} \left( \boldsymbol{\hat{Y}} \left( \mathbf{\Theta} \right), \boldsymbol c \right) \in \mathbb{R}^{+}
$$
<!-- 
This makes the loss depend on the output of the network  $\boldsymbol {\hat{Y}} \left( \mathbf{\Theta} \right)$, so we can turn this into an optimization problem.

A simple illustration of how this works can be seen in **Fig. 7**, where $J(\vartheta)$, the function we need to minimise, has only a scalar parameter $\vartheta$. -->

これにより、損失はネットワークの出力 $\boldsymbol {\hat{Y}} \left( \mathbf{\Theta} \right)$に依存することになるので、最適化問題にすることができます。

これがどのように動作するかの簡単な説明は、**図7**にあります。ここで、最小化する関数$J(\vartheta)$は、スカラーパラメータ$\vartheta$しか持ちません。

<!-- <center>
<img src="{{site.baseurl}}/images/week02/02-3/1-GD.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Fig. 7</b> Optimizing a loss function through gradient descent.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week02/02-3/1-GD.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>図7</b> 勾配降下法による損失関数の最適化
</center>

<!-- We pick a random initialization point $\vartheta_0$ -- with associated loss $J(\vartheta_0)$. We can compute the derivative evaluated at that point $J'(\vartheta_0) = \frac{\text{d} J(\vartheta)}{\text{d} \vartheta} (\vartheta_0)$. In this case, the slope of the derivative is positive. So we need to take a step in the direction of steepest descent. In this case, that is $-\frac{\text{d} J(\vartheta)}{\text{d} \vartheta}(\vartheta_0)$.

The iterative repetition of this process is known as gradient descent. Gradient methods are the primary tools to train a neural network.

In order to compute the necessary gradients, we have to use back-propagation -->

ランダムな初期値$\vartheta_0$、そしてそれによって定まる損失$J(\vartheta_0)$を定めます。その点で評価された微分$J'(\vartheta_0) = \frac{\text{d} J(\vartheta)}{\text{d} \vartheta} (\vartheta_0)$を計算することができます。この場合、微分の傾きは正の値になります。ということで、急降下の方向に一歩踏み出す必要があります。この場合、それは $-\frac{\text{d} J(\vartheta)}{\text{d} \vartheta}(\vartheta_0)$です。

このプロセスを反復的に繰り返すことを 勾配降下法といいます。勾配法はニューラルネットワークを訓練するための主要な方法です。

必要な勾配を計算するためには、以下に示すような誤差逆伝播を用いなければなりません

$$ \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{W_y}} = \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{\hat{y}}} \; \frac{\partial \, \boldsymbol{\hat{y}}}{\partial \, \boldsymbol{W_y}} \quad \quad \quad  \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{W_h}} = \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{\hat{y}}} \; \frac{\partial \, \boldsymbol{\hat{y}}}{\partial \, \boldsymbol h} \;\frac{\partial \, \boldsymbol h}{\partial \, \boldsymbol{W_h}} $$


<!-- ## Spiral classification - Jupyter notebook -->
## 螺旋の分類 - Jupyter notebook

<!-- The Jupyter notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/04-spiral_classification.ipynb). In order to run the notebook, make sure you have `the dl-minicourse` environment installed as specified in [README.md](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/README.md).

An explanation of how to use `torch.device()` can be found in [last week's notes](https://atcold.github.io/pytorch-Deep-Learning-Minicourse/en/week01/01-3/).

Like before, we are going to be working with points in $\mathbb{R}^2$ with three different categorical labels - in red, yellow and blue - as can be seen in **Fig. 8**. -->

Jupyter notebookは [ここ](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/04-spiral_classification.ipynb) にあります。Notebookを実行するには、[README.md](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/README.md) で指定された `dl-minicourse` 環境がインストールされていることを確認してください。

`torch.device()` の使い方については、[先週のノート](https://atcold.github.io/pytorch-Deep-Learning-Minicourse/en/week01/01-3/)に説明があります。

前回と同様に、$\mathbb{R}^2$の中の点を、赤、黄、青の3色のラベルで表現してみましょう。

<!-- <center>
<img src="{{site.baseurl}}/images/week02/02-3/2-data.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>Fig. 8</b> Spiral classification data.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week02/02-3/2-data.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>図8</b> 螺旋分類データ
</center>

<!-- `nn.Sequential()` is a container, which passes modules to the constructor in the order that they are added; `nn.linear()` is miss-named as it applies an **affine** transformation to the incoming data: $\boldsymbol y = \boldsymbol W \boldsymbol x + \boldsymbol b$. For more information, refer to the [PyTorch documentation](https://pytorch.org/docs/stable/nn.html).

Remember, an affine transformation is five things: rotation, reflection, translation, scaling and shearing.

As it can be seen in **Fig. 9**, when trying to separate the spiral data with linear decision boundaries - only using `nn.linear()` modules, without a non-linearity between them - the best we can achieve is an accuracy of 50%. -->

`nn.Sequential()`は、追加された順にモジュールをコンストラクタに渡すコンテナですが、`nn.linear()` は、**アフィン変換**$\boldsymbol y = \boldsymbol W \boldsymbol x + \boldsymbol b$を適用するので、名前が間違っています。詳しくは [PyTorchのドキュメント](https://pytorch.org/docs/stable/nn.html) を参照してください。

アフィン変換とは、回転、反射、平行移動、スケーリング、剪断の5つであることを覚えておいてください。

**図9**にあるように、線形決定境界で螺旋データを分離しようとした場合、つまり`nn.linear()` モジュールのみを使用しそれらの間に非線形性を持たせな買った場合、最高の分類精度は50%です。

<!-- <center>
<img src="{{site.baseurl}}/images/week02/02-3/3-linear.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Fig. 9</b> Linear decision boundaries.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week02/02-3/3-linear.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>図9</b> 線形決定境界
</center>

<!-- When we go from a linear model to one with two `nn.linear()` modules and a `nn.ReLU()` between them, the accuracy goes up to 95%. This is because the boundaries become non-linear and adapt much better to the spiral form of the data, as it can be seen in **Fig. 10**. -->
線形モデルから、2つの `nn.linear()` モジュールとその間の `nn.ReLU()` モジュールを持つモデルに移行すると、精度は95%まで上がります。これは、**図10**に示すように、境界線が非線形になり、データの螺旋状の形によく適応するからです。
<!-- 
<center>
<img src="{{site.baseurl}}/images/week02/02-3/4-non-linear.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
    <b>Fig. 10</b> Non-linear decision boundaries.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week02/02-3/4-non-linear.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
    <b>図10</b> 非線形決定境界
</center>

<!-- An example of a regression problem which can't be solved correctly with a linear regression, but is easily solved with the same neural network structure can be seen in [this notebook](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/05-regression.ipynb) and **Fig. 11**, which shows 10 different networks, where 5 have a `nn.ReLU()` link function and 5 have a `nn.Tanh()`. The former is a piecewise linear function, whereas the latter is a continuous and smooth regression. -->
線形回帰では正しく解けないけれど、同じニューラルネットワーク構造では簡単に解ける回帰問題の例を[このnotebook](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/05-regression.ipynb)と**図11**に示します。そこには、10の異なるネットワークが示されています。そのうち5つは`nn.ReLU()`を用いていて、残りの5つは`nn.Tanh()`を用いています。前者は断片的な線形関数であるのに対し、後者は連続的で滑らかな回帰です。


<!-- <center>
<img src="{{site.baseurl}}/images/week02/02-3/5-nn-reg.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
<b>Fig. 11</b>: 10 Neural networks, along with their variance and standard deviation.<br>
Left: Five <code>ReLU</code> networks.  Right: Five <code>tanh</code> networks.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week02/02-3/5-nn-reg.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
<b>図11</b>: 10個のニューラルネットとその分散と標準偏差<br>
左: 5つの <code>ReLU</code> ネットワーク 右:　5つの <code>tanh</code> ネットワーク
</center>

<!-- The yellow and green lines show the standard deviation and variance for the networks. Using these is useful for something similar to a "confidence interval" - since the functions give a single prediction per output. Using ensemble variance prediction allows us to estimate the uncertainty with which the prediction is being made. The importance of this can be seen in **Fig. 12**, where we extend the decision functions outside the training interval and these tend towards $+\infty, -\infty$. -->
黄色と緑の線は、ネットワークの標準偏差と分散を示しています。これらを使用することは、「信頼区間」のようなものに便利です。なぜなら、関数は出力ごとに単一の予測を与えるからです。アンサンブル分散予測を使用すると、予測が行われている不確実性を推定することができます。この重要性は、**図12**で見ることができます。ここでは、決定関数を訓練区間の外に拡張していますが、これらは$+\infty, -\infty$に向かっている傾向があります。

<!-- <center>
<img src="{{site.baseurl}}/images/week02/02-3/6-nn-confidence.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
<b>Fig. 12</b> Neural networks, with variance and standard deviation, outside training interval.<br>
Left: Five <code>ReLU</code> networks.  Right: Five <code>tanh</code> networks.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week02/02-3/6-nn-confidence.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
<b>図12</b> ニューラルネットとその分散と標準偏差。訓練区間の外。<br>
左: 5つの <code>ReLU</code> ネットワーク  右: 5つの <code>tanh</code> ネットワーク
</center>

<!-- To train any Neural Network using PyTorch, you need 5 fundamental steps in the training loop:

1. `output = model(input)` is the model's forward pass, which takes the input and generates the output.
2. `J = loss(output, target <or> label)` takes the model's output and calculates the training loss with respect to the true target or label.
3. `model.zero_grad()` cleans up the gradient calculations, so that they are not accumulated for the next pass.
4. `J.backward()` does back-propagation and accumulation: It computes $\nabla_\texttt{x} J$ for every variable $\texttt{x}$ for which we have specified `requires_grad=True`. These are accumulated into the gradient of each variable: $\texttt{x.grad} \gets \texttt{x.grad} +  \nabla_\texttt{x} J$.
5. `optimiser.step()` takes a step in gradient descent: $\vartheta \gets \vartheta - \eta\, \nabla_\vartheta J$.

When training a NN, it is very likely that you need these 5 steps in the order they were presented. -->

PyTorchを使ってニューラルネットワークを学習するには、5つの基本的なステップが必要です。

1. `output = model(input)` はモデルの順伝播で、入力を受けて出力を生成します。
2. `J = loss(output, target <or> label)` はモデルの出力を受け取り、真のターゲットまたはラベルに対する訓練誤差を計算します。
3. `model.zero_grad()` は勾配計算をクリーンアップし、次のパスに蓄積されないようにします。
4. `J.backward()` は逆伝播と勾配の蓄積を行います。`requires_grad=True`となっている各変数$\texttt{x}$について$\nabla_\texttt{x} J$を計算します。これらは各変数の勾配に蓄積されます：$\texttt{x.grad} \gets \texttt{x.grad} +  \nabla_\texttt{x} J$。
5. `optimiser.step()` は、勾配降下法のステップを進め、重みを更新します。

NNを学習する際には、この5つのステップが提示された順に、必要になる可能性が高いです。
