---
lang-ref: ch.02-2
lang: ja
lecturer: Yann LeCun
title: NNモジュールに対する勾配の計算と、誤差逆伝播法のコツ
authors: Micaela Flores, Sheetal Laad, Brina Seidel, Aishwarya Rajan
date: 3 Feb 2020
translation-date: 2 Dec 2020
translator: Shiro Takagi
---


<!-- ## [A concrete example of backpropagation and intro to basic neural network modules](https://www.youtube.com/watch?v=d9vdh3b787Y&t=2989s) -->
## [誤差逆伝播の具体的な例と基本的なニューラルネットモジュールの導入](https://www.youtube.com/watch?v=d9vdh3b787Y&t=2989s)


<!-- ### Example

We next consider a concrete example of backpropagation assisted by a visual graph. The arbitrary function $G(w)$ is inputted into the cost function $C$, which can be represented as a graph. Through the manipulation of multiplying the Jacobian matrices, we can transform this graph into the graph that will compute the gradients going backwards. (Note that PyTorch and TensorFlow do this automatically for the user, i.e., the forward graph is automatically "reversed" to create the derivative graph that backpropagates the gradient.) -->

### 例

次に、グラフを用いて誤差逆伝播の具体例を考えます。任意の関数 $G(w)$ をコスト関数 $C$ に入力すると、グラフとして表現できます。ヤコビ行列を乗算する操作によって、このグラフを勾配の逆伝播を計算するグラフに変換することができます(PyTorch と TensorFlow は、ユーザーのために自動的にこれを行うことに注意してください。つまり、順伝播のグラフを自動的に「反転」させて、勾配を逆伝播する微分グラフを作成します)。

<center><img src="{{site.baseurl}}/images/week02/02-2/02-2-1.png" alt="Gradient diagram" style="zoom:40%;" /></center>

<!-- In this example, the green graph on the right represents the gradient graph. Following the graph from the topmost node, it follows that -->
この例では、右の緑のグラフが勾配グラフを表しています。一番上のノードからグラフをたどると、次のようになります。

$$
\frac{\partial C(y,\bar{y})}{\partial w}=1 \cdot \frac{\partial C(y,\bar{y})}{\partial\bar{y}}\cdot\frac{\partial G(x,w)}{\partial w}
$$

<!-- In terms of dimensions, $\frac{\partial C(y,\bar{y})}{\partial w}$ is a row vector of size $1\times N$ where $N$ is the number of components of $w$; $\frac{\partial C(y,\bar{y})}{\partial \bar{y}}$  is a row vector of size $1\times M$, where $M$ is the dimension of the output; $\frac{\partial \bar{y}}{\partial w}=\frac{\partial G(x,w)}{\partial w}$ is a matrix of size $M\times N$, where $M$ is the number of outputs of $G$ and $N$ is the dimension of $w$.

Note that complications might arise when the architecture of the graph is not fixed, but is data-dependent. For example, we could choose neural net module depending on the length of input vector. Though this is possible, it becomes increasingly difficult to manage this variation when the number of loops exceeds a reasonable amount. -->

次元に関していうと、$\frac{\partial C(y,\bar{y})}{\partial w}$ はサイズが $1\times N$ の行ベクトルです。ただし$N$ は $w$の要素の数です。また、$\frac{\partial C(y,\bar{y})}{\partial \bar{y}}$ はサイズが $1\times M$の行ベクトルです。ただし $M$ は出力の次元です。$\frac{\partial \bar{y}}{\partial w}=\frac{\partial G(x,w)}{\partial w}$ はサイズが $M\times N$の行列です。 ただし、$M$ は $G$ の出力の数で、$N$ は$w$の次元です。

グラフのアーキテクチャが固定ではなく、データに依存している場合、複雑な問題が発生する可能性があることに注意してください。例えば、入力ベクトルの長さに応じてニューラルネットモジュールを選択することができます。これは可能ですが、ループの数がそれなりに多くなると、このバリエーションを管理するのが難しくなります。

<!-- ### Basic neural net modules

There exist different types of pre-built modules besides the familiar Linear and ReLU modules. These are useful because they are uniquely optimized to perform their respective functions (as opposed to being built by a combination of other, elementary modules). -->

### 基本的なニューラルネットのモジュール

おなじみの Linear や ReLU モジュール以外にも、さまざまなタイプの組みこみモジュールが存在します。これらのモジュールは、それぞれの機能を実行するために独自に最適化されているので便利です (他の基本的なモジュールの組み合わせで構築されるのとは対照的です)。

- 線形演算: $Y=W\cdot X$

$$
\begin{aligned}
\frac{dC}{dX} &= W^\top \cdot \frac{dC}{dY} \\
\frac{dC}{dW} &= \frac{dC}{dY} \cdot X^\top
\end{aligned}
$$

- ReLU: $y=(x)^+$

  $$
  \frac{dC}{dX} =
      \begin{cases}
        0 & x<0\\
        \frac{dC}{dY} & \text{それ以外}
      \end{cases}
  $$

<!-- - Duplicate: $Y_1=X$, $Y_2=X$

  - Akin to a "Y - splitter" where both outputs are equal to the input.

  - When backpropagating, the gradients get summed

  - Can be split into n branches similarly -->

- 複製： $Y_1=X$, $Y_2=X$

  - 両方の出力が入力と等しくなる 「Y - splitter」に似ています。

  - 逆伝播を行うと、勾配の和が得られます。

  - 同様にn本の枝に分けることができます

    $$
    \frac{dC}{dX}=\frac{dC}{dY_1}+\frac{dC}{dY_2}
    $$


<!-- - Add: $Y=X_1+X_2$

  - With two variables being summed, when one is perturbed, the output will be perturbed by the same quantity, i.e., -->
- 足し算： $y=x_1+x_2$

  - 2つの変数が合計されている状態で、一方が摂動されると、出力は同じ量摂動されます、つまり

    $$
    \frac{dC}{dX_1}=\frac{dC}{dY}\cdot1 \quad \text{and}\quad \frac{dC}{dX_2}=\frac{dC}{dY}\cdot1
    $$


- 最大: $Y=\max(X_1,X_2)$

  <!-- -  Since this function can also be represented as -->
  - この関数は、次のように表すこともできます

    $$
    Y=\max(X_1,X_2)=\begin{cases}
          X_1 & X_1 > X_2 \\
          X_2 & \text{それ以外}
       \end{cases}
    \Rightarrow
    \frac{dY}{dX_1}=\begin{cases}
          1 & X_1 > X_2 \\
          0 & \text{それ以外}
       \end{cases}
    $$

  <!-- - Therefore, by the chain rule, -->
  - したがって、連鎖律から、

$$
\frac{dC}{dX_1}=\begin{cases}
      \frac{dC}{dY}\cdot1 & X_1 > X_2 \\
      0 & \text{それ以外}
   \end{cases}
$$


## [LogSoftMax vs SoftMax](https://www.youtube.com/watch?v=d9vdh3b787Y&t=3953s)

<!-- *SoftMax*, which is also a PyTorch module, is a convenient way of transforming a group of numbers into a group of positive numbers between 0 and 1 that sum to one. These numbers can be interpreted as a probability distribution. As a result, it is commonly used in classification problems. $y_i$ in the equation below is a vector of probabilities for all the categories. -->
*SoftMax*はPyTorchのモジュールでもあり、数値のグループを0から1の間の正の数値のグループに変換する便利な方法です。これらの数値は確率分布として解釈することができます。その結果、分類問題でよく使われます。下の式の $y_i$ は、すべてのカテゴリの確率のベクトルです。

$$
y_i = \frac{\exp(x_i)}{\sum_j \exp(x_j)}
$$

<!-- However, the use of softmax leaves the network susceptible to vanishing gradients. Vanishing gradient is a problem, as it prevents weights downstream from being modified by the neural network, which may completely stop the neural network from further training. The logistic sigmoid function, which is the softmax function for one value, shows that when s is large, $h(s)$ is 1, and when s is small, $h(s)$ is 0. Because the sigmoid function is flat at $h(s) = 0 $ and $h(s) = 1$, the gradient is 0, which results in a vanishing gradient. -->
しかし、softmaxを使用すると、ネットワークは勾配消失の影響を受けやすくなります。勾配消失は、下流の重みがニューラルネットワークによって変更されるのを防ぎ、ニューラルネットワークがそれ以上の訓練を完全に止めてしまう可能性があるため、問題となります。1つの値に対するソフトマックス関数であるロジスティックシグモイド関数は、sが大きいときは$h(s)$が1、小さいときは$h(s)$が0であることを示しています。 シグモイド関数は$h(s)=0$と$h(s)=1$では平坦なので、勾配は0となり、勾配消失が発生します。

<center><img src="{{site.baseurl}}/images/week02/02-2/02-2-2.png" alt="Sigmoid function to illustrate vanishing gradient" style="background-color:#DCDCDC;" /></center>

$$
h(s) = \frac{1}{1 + \exp(-s)}
$$

<!-- Mathematicians came up with the idea of logsoftmax in order to solve for the issue of the vanishing gradient created by softmax. *LogSoftMax* is another basic module in PyTorch. As can be seen in the equation below, *LogSoftMax* is a combination of softmax and log. -->
数学者は、softmaxで作られた勾配が消える問題を解決するために、logsoftmaxのアイデアを思いつきました。*LogSoftMax*はPyTorchのもう一つの基本モジュールです。下の式でわかるように、*LogSoftMax*はsoftmaxとlogを組み合わせたものです。

$$
\log(y_i )= \log\left(\frac{\exp(x_i)}{\Sigma_j \exp(x_j)}\right) = x_i - \log(\Sigma_j \exp(x_j))
$$

<!-- The equation below demonstrates another way to look at the same equation. The figure below shows the $\log(1 + \exp(s))$ part of the function. When s is very small, the value is 0, and when s is very large, the value is s. As a result it doesn’t saturate, and the vanishing gradient problem is avoided. -->
下の式は、同じ式を見る別の方法を示しています。下の図は、この関数の「$\log(1 + \exp(s))$」の部分です。sが小さいときは0、大きいときはsになります。結果として出力が飽和せず、勾配消失問題が回避されます。

$$
\log\left(\frac{\exp(s)}{\exp(s) + 1}\right)= s - \log(1 + \exp(s))
$$

<center><img src="{{site.baseurl}}/images/week02/02-2/02-2-3.png" width='400px' alt="Plot of logarithmic part of the functions" /></center>


<!-- ## [Practical tricks for backpropagation](https://www.youtube.com/watch?v=d9vdh3b787Y&t=4891s) -->
## [誤差逆伝播法の実応用上のコツ](https://www.youtube.com/watch?v=d9vdh3b787Y&t=4891s)


<!-- ### Use ReLU as the non-linear activation function

ReLU works best for networks with many layers, which has caused alternatives like the sigmoid function and hyperbolic tangent $\tanh(\cdot)$ function to fall out of favour. The reason ReLU works best is likely due to its single kink which makes it scale equivariant.


### Use cross-entropy loss as the objective function for classification problems

Log softmax, which we discussed earlier in the lecture, is a special case of cross-entropy loss. In PyTorch, be sure to provide the cross-entropy loss function with *log* softmax as input (as opposed to normal softmax).


### Use stochastic gradient descent on minibatches during training

As discussed previously, minibatches let you train more efficiently because there is redundancy in the data; you shouldn't need to make a prediction and calculate the loss on every single observation at every single step to estimate the gradient.


### Shuffle the order of the training examples when using stochastic gradient descent

Order matters. If the model sees only examples from a single class during each training step, then it will learn to predict that class without learning why it ought to be predicting that class. For example, if you were trying to classify digits from the MNIST dataset and the data was unshuffled, the bias parameters in the last layer would simply always predict zero, then adapt to always predict one, then two, etc. Ideally, you should have samples from every class in every minibatch.

However, there's ongoing debate over whether you need to change the order of the samples in every pass (epoch). -->


### 非線形活性化関数としてReLUを使用

ReLUは層数の多いネットワークに最適で、 シグモイド関数や$\tanh(\cdot)$関数のような代替案が人気を失っています。ReLUが最もよく機能する理由は、その単一のキンクがスケールに関して同変だからでしょう。


### 分類問題の目的関数としてクロスエントロピー損失を使用

先ほどの講義で説明した Log softmax は、クロスエントロピー損失の特殊なケースです。PyTorchでは、必ずクロスエントロピー損失関数を入力として*log* softmaxを指定してください（通常のsoftmaxではなく）。


### 学習中のミニバッチで確率的勾配降下法を使用

前述したように、ミニバッチを使うと、データに冗長性があるので、より効率的な学習が可能になります。全ての観測一つ一つについて1ステップで勾配を推定するために予測をしたり誤差を計算したりする必要はありません。


### 確率的勾配降下法を使う場合、学習例の順序をシャッフル

順番は重要です。もしモデルが各学習ステップで単一のクラスのデータしか見ていない場合、なぜそのクラスを予測すべきなのかを学習せずに、そのクラスを予測するように学習してしまいます。例えば、MNISTのデータセットから数字を分類しようとしていて、データがシャッフルされていない場合、最後の層のバイアス・パラメータは、単純に常に0を予測し、その後、常に1を予測するように適応し、次に2を予測するように適応します。理想的には、すべてのミニバッチにすべてのクラスのサンプルがあるべきです。

しかし、パス（エポック）ごとにサンプルの順番を変える必要があるかどうかについては、現在も議論が続いています。


<!-- ### Normalize the inputs to have zero mean and unit variance

Before training, it's useful to normalize each input feature so that it has a mean of zero and a standard deviation of one. When using RGB image data, it is common to take mean and standard deviation of each channel individually and normalize the image channel-wise. For example, take the mean $m_b$ and standard deviation $\sigma_b$ of all the blue values in the dataset, then normalize the blue values for each individual image as. -->

### 平均値がゼロで分散が１になるように入力を正規化

学習の前に、各入力特徴量の平均値が0、標準偏差が1になるように正規化しておくと便利です。RGB画像データを使用する場合、各チャンネルの平均と標準偏差を個別に取り、チャンネルごとに正規化するのが一般的です。例えば、データセットに含まれる全ての青の値の平均 $m_b$ と標準偏差 $\sigma_b$ を取り、個々の画像の青の値を次のように正規化します。

$$
b_{[i,j]}^{'} = \frac{b_{[i,j]} - m_b}{\max(\sigma_b, \epsilon)}
$$

<!-- where $\epsilon$ is an arbitrarily small number that we use to avoid division by zero. Repeat the same for green and red channels. This is necessary to get a meaningful signal out of images taken in different lighting; for example, day lit pictures have a lot of red while underwater pictures have almost none. -->
ここで $\epsilon$ は、ゼロによる除算を避けるために使う任意の小さな数です。緑と赤のチャンネルについても同じことを繰り返します。これは、異なる照明で撮影した画像から意味のある信号を得るために必要なことです。

<!-- ### Use a schedule to decrease the learning rate

The learning rate should fall as training goes on. In practice, most advanced models are trained by using algorithms like Adam which adapt the learning rate instead of simple SGD with a constant learning rate.


### Use L1 and/or L2 regularization for weight decay

You can add a cost for large weights to the cost function. For example, using L2 regularization, we would define the loss $L$ and update the weights $w$ as follows: -->

### 学習率を下げるためにスケジュールを使用

学習率は、訓練が進むにつれて低下させるべきです。実際には、ほとんどの高度なモデルは、学習率が一定の単純な SGD の代わりに、学習率を適応させる Adam のようなアルゴリズムを使用して学習します。


### 重みの減衰には、L1 および/または L2 正則化を使用

重みが大きい場合のペナルティをコスト関数に追加することができます。例えば、L2正則化を使って、損失$L$を定義し、重み$w$を以下のように更新します。

$$
L(S, w) = C(S, w) + \alpha \Vert w \Vert^2\\
\frac{\partial R}{\partial w_i} = 2w_i\\
w_i = w_i - \eta\frac{\partial L}{\partial w_i} = w_i - \eta \left( \frac{\partial C}{\partial w_i} + 2 \alpha w_i \right)
$$

<!-- To understand why this is called weight decay, note that we can rewrite the above formula to show that we multiply $w_i$ by a constant less than one during the update. -->
なぜこれを重み減衰と呼ぶのかを理解するために、上の式を書き換えます。すると、更新中に $w_i$ に 1 よりも小さい定数を乗算することになっていることがわかります。

$$
w_i = (1 - 2 \eta \alpha) w_i - \eta\frac{\partial C}{\partial w_i}
$$

<!-- L1 regularization (Lasso) is similar, except that we use $\sum_i \vert w_i\vert$ instead of $\Vert w \Vert^2$.

Essentially, regularization tries to tell the system to minimize the cost function with the shortest weight vector possible. With L1 regularization, weights that are not useful are shrunk to 0. -->

L1正則化(Lasso)は、$\Vert w \Vert^2$の代わりに、$\sum_i \vert w_i\vert$を使用することを除いて、似ています。

本質的に、正則化は、システムに、可能な限り最短の重みベクトルで コスト関数を最小化するように伝えようとします。L1正則化では、役に立たない重みは0に縮小されます。
<!-- 
### Weight initialisation

The weights need to be initialised at random, however, they shouldn't be too large or too small such that output is roughly of the same variance as that of input. There are various weight initialisation tricks built into PyTorch. One of the tricks that works well for deep models is Kaiming initialisation where the variance of the weights is inversely proportional to square root of number of inputs. -->

### 重みの初期化

重みはランダムに初期化する必要がありますが、出力が入力とほぼ同じ分散になるように、大きすぎても小さすぎてもいけません。PyTorchには、さまざまな重みの初期化方法が組み込まれています。深層モデルでうまく機能する方法の1つは、重みの分散が入力数の平方根に反比例するKaimingの初期化です。


<!-- ### Use dropout

Dropout is another form of regularization. It can be thought of as another layer of the neural net: it takes inputs, randomly sets $n/2$ of the inputs to zero, and returns the result as output. This forces the system to take information from all input units rather than becoming overly reliant on a small number of input units thus distributing the information across all of the units in a layer. This method was initially proposed by <a href="https://arxiv.org/abs/1207.0580">Hinton et al (2012)</a>.

For more tricks, see  <a href="http://yann.lecun.com/exdb/publis/pdf/lecun-98b.pdf">LeCun et al 1998</a>.

Finally, note that backpropagation doesn't just work for stacked models; it can work for any directed acyclic graph (DAG) as long as there is a partial order on the modules. -->

### ドロップアウトを使う

ドロップアウトは正則化の別の形式です。これはニューラルネットのもう一つの層と考えることができます。すなわち、入力を取り、入力のうち $n/2$ をランダムにゼロに設定し、その結果を出力として返すような層です。これにより、システムは少数の入力ユニットに過度に依存するのではなく、すべての入力ユニットから情報を取得することを強制され、その結果、層内のすべてのユニットに情報を分散させることができます。この方法は、<a href="https://arxiv.org/abs/1207.0580">Hinton et al (2012)</a>によって最初に提案されました。

より多くのトリックについては、<a href="http://yann.lecun.com/exdb/publis/pdf/lecun-98b.pdf">LeCun et al 1998</a>を参照してください。

最後に、誤差逆伝播法はスタックモデルだけでなく、モジュールに部分的な順序がある限り、有向非巡回グラフ（DAG）でも動作することに注意してください。
