---
lang-ref: ch.02-1
lang: ja
lecturer: Yann LeCun
title: 勾配法と誤差逆伝播アルゴリズムの紹介
authors: Amartya Prasad, Dongning Fang, Yuxin Tang, Sahana Upadhya
date: 3 Feb 2020
translation-date: 2 Dec 2020
translator: Shiro Takagi
---


<!-- ## [Gradient Descent optimization algorithm](https://www.youtube.com/watch?v=d9vdh3b787Y&t=29s) -->
## [勾配法](https://www.youtube.com/watch?v=d9vdh3b787Y&t=29s)


<!-- ### Parametrised models -->
### パラメトリックモデル

$$
\bar{y} = G(x,w)
$$

<!-- Parametrised models are simply functions that depend on inputs and trainable parameters. There is no fundamental difference between the two, except that trainable parameters are shared across training samples whereas the input varies from sample to sample. In most deep learning frameworks, parameters are implicit, that is, they aren't passed when the function is called. They are 'saved inside the function', so to speak, at least in the object-oriented versions of models.

The parametrised model (function) takes in an input, has a parameter vector and produces an output. In supervised learning, this output goes into the cost function ($C(y,\bar{y}$)), which compares the true output (${y}$) with the model output ($\bar{y}$). The computation graph for this model is shown in Figure 1. -->

パラメトリックモデルは、単に入力と訓練可能なパラメータに依存する関数です。この2つの間には基本的な違いはありませんが、入力がサンプルごとに異なるのに対し、訓練可能なパラメータは訓練サンプル間で共有されます。ほとんどの深層学習フレームワークでは、パラメータは暗黙的なものであり、関数が呼び出されたときには渡されません。少なくともオブジェクト指向モデルでは、パラメータはいわば「関数の中に保存されている」のです。

パラメトリックモデル（関数）は、入力を受け取り、パラメータベクトルを持ち、出力を生成します。教師あり学習では、この出力はコスト関数($C(y,\bar{y}$))に入り、真の出力(${y}$)とモデルの出力($\bar{y}$)を比較します。このモデルの計算グラフを図1に示します。

<!-- | <center><img src="{{site.baseurl}}/images/week02/02-1/Figure1.jpg" alt="Figure1" style="zoom: 33%;" /></center> |
| <center>Figure 1: Computation Graph representation for a Parametrised Model </center>| -->
<center><img src="{{site.baseurl}}/images/week02/02-1/Figure1.jpg" alt="Figure1" style="zoom: 33%;" /></center> |
| <center>図1: パラメトリックモデルを表現した計算グラフ </center>|

<!-- Examples of parametrised functions -

- Linear Model - Weighted Sum of Components of the Input Vector : -->

パラメータ付けられた関数の例

- 線形モデル - 入力ベクトルの成分の加重和

  $$
  \bar{y} = \sum_i w_i x_i, C(y,\bar{y}) = \Vert y - \bar{y}\Vert^2
  $$

<!-- - Nearest Neighbor - There is an input $\vect{x}$ and a weight matrix $\matr{W}$ with each row of the matrix indexed by $k$. The output is the value of $k$ that corresponds to the row of $\matr{W}$ that is closest to $\vect{x}$: -->
- 最近傍 - 入力 $\vect{x}$ と重み行列 $\matr{W}$ があります。出力は、$\vect{x}$に最も近い$\matr{W}$の行に対応する$k$の値です。

  $$
  \bar{y} = \underset{k}{\arg\min} \Vert x - w_{k,.} \Vert^2
  $$

  <!-- Parameterized models could also involve complicated functions. -->
  パラメトリックモデルにはより複雑な関数も含まれます。


<!-- #### Block diagram notations for computation graphs -->
#### 計算グラフのブロック図による表記

<!-- - Variables (tensor, scalar, continuous, discrete)
    - <img src="{{site.baseurl}}/images/week02/02-1/x.PNG" alt="x" style="zoom:50%;" /> is an observed input to the system
    - <img src="{{site.baseurl}}/images/week02/02-1/y.PNG" alt="y" style="zoom:50%;" /> is a computed variable which is produced by a deterministic function -->

- 変数 (テンソル、スカラー、 連続、 離散)
    - <img src="{{site.baseurl}}/images/week02/02-1/x.PNG" alt="x" style="zoom:50%;" /> は、観測された、システムへの入力です。
    - <img src="{{site.baseurl}}/images/week02/02-1/y.PNG" alt="y" style="zoom:50%;" /> は、決定論的な関数によって計算された変数です。

<!-- - Deterministic functions

    <img src="{{site.baseurl}}/images/week02/02-1/deterministic_function.PNG" alt="deterministic_function" style="zoom:50%;" />

    - Takes in multiple inputs and can produce multiple outputs
    - It has an implicit parameter variable (${w}$)
    - The rounded side indicates the direction in which it is easy to compute. In the above diagram, it is easier to compute ${\bar{y}}$ from ${x}$ than the other way around -->

- 決定論的な関数

    <img src="{{site.baseurl}}/images/week02/02-1/deterministic_function.PNG" alt="deterministic_function" style="zoom:50%;" />

    - 複数の入力を受けて、複数の出力を返すことができます。
    - 暗黙的なパラメータ変数 (${w}$)を持っています。
    - 丸みを帯びた部分は計算しやすい方向を示しています。上の図では、${x}$から${\bar{y}}$を計算する方が、逆よりも計算しやすいことがわかります。

<!-- - Scalar-valued function -->

  <!-- <img src="{{site.baseurl}}/images/week02/02-1/scalar-valued.PNG" alt="scalar-valued" style="zoom:50%;" />

    - Used to represent cost functions
    - Has an implicit scalar output
    - Takes multiple inputs and outputs a single value (usually the distance between the inputs) -->

- スカラー値関数

  <img src="{{site.baseurl}}/images/week02/02-1/scalar-valued.PNG" alt="scalar-valued" style="zoom:50%;" />

    - コスト関数を表現するために使われます。
    - 暗黙的なスカラーの出力を持っています。
    - 複数の入力を受けて、単一の出力を返します (通常は入力の間の距離)。

<!-- #### Loss functions

Loss function is a function that is minimized during training. There are two types of losses:

1) Per Sample Loss -
$$
 L(x,y,w) = C(y, G(x,w))
$$
2) Average Loss -

​	For any set of Samples $$S = \{(x[p],y[p]) \mid p=0,1...P-1 \}$$

​	Average Loss over the Set S is given by :  $$L(S,w) = \frac{1}{P} \sum_{(x,y)} L(x,y,w)$$

| <center><img src="{{site.baseurl}}/images/week02/02-1/Average_Loss.png" alt="Average_Loss" style="zoom:33%;" /></center> |
|   <center>Figure 2: Computation graph for model with Average Loss    </center>|

In the standard Supervised Learning paradigm, the loss (per sample) is simply the output of the cost function. Machine Learning is mostly about optimizing functions (usually minimizing them). It could also involve finding Nash Equilibria between two functions like with GANs. This is done using Gradient Based Methods, though not necessarily Gradient Descent. -->

#### 損失関数

損失関数は学習中に最小化される関数です。二つのタイプの損失があります。

1) サンプルごとの損失 -

$$
 L(x,y,w) = C(y, G(x,w))
$$

2) 平均損失 -

​	任意のサンプルの集合 $$S = \{(x[p],y[p]) \mid p=0,1...P-1 \}$$　に対して

集合 $S$ の平均損失は次のようになります $$L(S,w) = \frac{1}{P} \sum_{(x,y)} L(x,y,w)$$

| <center><img src="{{site.baseurl}}/images/week02/02-1/Average_Loss.png" alt="Average_Loss" style="zoom:33%;" /></center> |
|   <center>図2: 平均損失をもつモデルの計算グラフ    </center>|

<!-- In the standard Supervised Learning paradigm, the loss (per sample) is simply the output of the cost function. Machine Learning is mostly about optimizing functions (usually minimizing them). It could also involve finding Nash Equilibria between two functions like with GANs. This is done using Gradient Based Methods, though not necessarily Gradient Descent. -->
標準的な教師あり学習のパラダイムでは、損失（サンプルあたり）は単にコスト関数の出力です。機械学習は、主に関数の最適化（通常は最小化）に関するものです。また、GANのように2つの関数間のナッシュ均衡を見つけることも含まれます。これは必ずしも勾配降下法とは限りませんが、勾配ベースの手法を用いて行われます。

<!-- ### Gradient descent -->
### 勾配降下法

<!-- A **Gradient Based Method** is a method/algorithm that finds the minima of a function, assuming that one can easily compute the gradient of that function. It assumes that the function is continuous and differentiable almost everywhere (it need not be differentiable everywhere).

**Gradient Descent Intuition** - Imagine being in a mountain in the middle of a foggy night. Since you want to go down to the village and have only limited vision, you look around your immediate vicinity to find the direction of steepest descent and take a step in that direction. -->

**勾配に基づく方法**は、関数の勾配を簡単に計算できると仮定して、関数の最小値を求める方法/アルゴリズムです。これは、関数が連続的で、ほぼすべての場所で微分可能であることを前提としています（すべての場所で微分可能である必要はありません）。

**勾配降下法の直感** - 霧が立ち込める山の中にいることを想像してみてください。あなたは村に下りたいと思っています。視界が限られているので、あなたは自分のすぐ近くを見回して、最も急な下り坂の方向を見つけ、その方向に一歩を踏み出します。

<!-- **Different methods of Gradient Descent** -->
**勾配降下法の様々な方法**

<!-- - Full (batch) gradient descent update rule : -->
- 完全な (バッチ) 勾配降下法の更新則

  $$
  w \leftarrow w - \eta \frac{\partial L(S,w)}{\partial w}
  $$

<!-- - For SGD (Stochastic Gradient  Descent), the update rule becomes : -->
- SGD (確率的勾配降下法)については、更新則は次のようになります。
  <!-- - Pick a $p$ in $\text{0...P-1}$, then update -->
  - $\text{0...P-1}$から$p$を選び、次のように更新します

    $$
    w \leftarrow w - \eta \frac{\partial L(x[p], y[p],w)}{\partial w}
    $$

<!-- Where $${w}$$ represents the parameter to be optimized. -->
ここで$${w}$$は最適化するパラメータを表しています。

<!-- $\eta \text{ is a constant here but in more sophisticated algorithms, it could be a matrix}$. -->
$\eta$はここでは定数ですが、もっと洗練されたアルゴリズムでは、行列などになることもあります。

<!-- If it is a positive semi-definite matrix, we'll still move downhill but not necessarily in the direction of steepest descent. In fact the direction of steepest descent may not always be the direction we want to move in.

If the function is not differentiable, i.e, it has a hole or is staircase like or flat, where the gradient doesn't give you any information, one has to resort to other methods - called 0-th Order Methods or Gradient-Free Methods. Deep Learning is all about Gradient Based Methods.

However, RL (Reinforcement Learning) involves **Gradient Estimation** without the explicit form for the gradient. An example is a robot learning to ride a bike where the robot falls every now and then. The objective function measures how long the bike stays up without falling. Unfortunately, there is no gradient for the objective function. The robot needs to try different things.

The RL cost function is not differentiable most of the time but the network that computes the output is gradient-based. This is the main difference between supervised learning and reinforcement learning. With the latter, the cost function C is not differentiable. In fact it completely unknown. It just returns an output when inputs are fed to it, like a blackbox. This makes it highly inefficient and is one of the main drawbacks of RL - particularly when the parameter vector is high dimensional (which implies a huge solution space to search in, making it hard to find where to move).

A very popular technique in RL is Actor Critic Methods. A critic method basically consists of a second C module which is a known, trainable module. One is able to train the C module, which is differentiable, to approximate the cost function/reward function. The reward is a negative cost, more like a punishment. That’s a way of making the cost function differentiable, or at least approximating it by a differentiable function so that one can backpropagate. -->

これが半正定値行列であれば、まだ下山はできますが、必ずしも急な下り坂の方向に移動するとは限りません。実際には、最も急な下り坂の方向は、必ずしも我々が移動したい方向とは限りません。

関数が微分できない、つまり穴があったり階段のようだったり平坦だったりするような場合、勾配は何の情報も与えてくれません。この場合、0次法や勾配なし法と呼ばれる他の方法に頼らなければなりません。ディープラーニングでは、勾配に基づいた方法がすべてです。

しかし、RL(強化学習)では、勾配の明示的な形式を使わずに、**勾配の推定**を行います。例えば、ロボットが自転車に乗ることを学習することを考えます。この時、ロボットはたまに転んでしまうことがあります。目的関数は、自転車から落ちずにどれくらいの時間留まるかを測定します。残念ながら、目的関数には勾配がありません。ロボットはいろいろなことを試す必要があります。

RLのコスト関数はほとんどの場合微分できませんが、出力を計算するネットワークは勾配ベースです。これが教師あり学習と強化学習の大きな違いです。後者では、コスト関数Cは微分できません。実際、それは完全に未知です。ブラックボックスのように、入力が与えられると出力を返すだけです。これは非常に非効率的であり、RLの主な欠点の1つです。特に、パラメータベクトルが高次元である場合に問題になります（これは、探索するための巨大な解空間を意味し、どこに移動すべきかを見つけるのが困難になります）。

RLで非常に人気のある手法は、actor-critic法です。Critic法は基本的に、既知の訓練可能な第2のモジュールで構成されています。微分可能なCモジュールを訓練して、コスト関数/報酬関数を近似することができます。報酬は負のコストであり、罰のようなものです。これは、コスト関数を微分可能にしたり、少なくとも微分可能な関数で近似したりして、誤差逆伝播法を用いることができるようにする方法です。


<!-- ## [Advantages of SGD and backpropagation for traditional neural nets](https://www.youtube.com/watch?v=d9vdh3b787Y&t=1036s) -->
## [従来のニューラルネットにおけるSGDと誤差逆伝播の利点](https://www.youtube.com/watch?v=d9vdh3b787Y&t=1036s)


<!-- ### Advantages of Stochastic Gradient Descent (SGD) -->
### 確率的勾配降下法 (SGD)の利点

<!-- In practice, we use stochastic gradient to compute the gradient of the objective function w.r.t the parameters. Instead of computing the full gradient of the objective function, which is the average of all samples, stochastic gradient just takes one sample, computes the loss, $L$, and the gradient of the loss w.r.t the parameters, and then takes one step in the negative gradient direction. -->
実際には、パラメータについての目的関数の勾配を計算するために、確率的な勾配を使用します。確率的な勾配は、すべてのサンプルの平均である完全な勾配を計算する代わりに、1つのサンプルを取り、損失$L$およびその損失のパラメータに関する勾配を計算します。そして、負の勾配の方向に1ステップ更新するだけです。

$$
w \leftarrow w - \eta \frac{\partial L(x[p], y[p],w)}{\partial w}
$$

<!-- In the formula, $w$ is approached by $w$ minus the step-size, times the gradient of the per-sample loss function w.r.t the parameters for a given sample, ($x[p]$,$y[p]$).

If we do this on a single sample, we will get a very noisy trajectory as shown in Figure 3. Instead of the loss going directly downhill, it’s stochastic. Every sample will pull the loss towards a different direction. It’s just the average that pulls us to the minimum of the average. Although it looks inefficient, it’s much faster than batch gradient descent at least in the context of machine learning when the samples have some redundancy. -->

式の中では、与えられたサンプル($x[p]$,$y[p]$)毎の損失関数のパラメータに関する勾配にステップサイズをかけたものを、$w$から引くことで、$w$に近づけています。

これを1つのサンプルで行うと、図3に示すような非常にノイズの多い軌跡が得られます。損失が直接下降していくのではなく、確率的に降下しています。すべてのサンプルが損失を異なる方向に引き寄せます。それは、平均値の最小値に引っ張られているだけです。効率が悪いように見えますが、少なくとも機械学習の文脈では、サンプルに冗長性がある場合には、バッチ勾配降下法よりもはるかに高速です。
<!-- 
| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure2.png" alt="Figure2" style="zoom:80%;" /></center> |
| <center>Figure 3: Stochastic Gradient Descent trajectory for per sample update </center>| -->
 <center><img src="{{site.baseurl}}/images/week02/02-1/Figure2.png" alt="Figure2" style="zoom:80%;" /></center> |
| <center>図3: サンプルごとの更新の確率的勾配降下法の軌跡 </center>|

<!-- In practice, we use batches instead of doing stochastic gradient descent on a single sample. We compute the average of the gradient over a batch of samples, not a single sample, and then take one step. The only reason for doing this is that we can make more efficient use of the existing hardware  (i.e. GPUs, multicore CPUs) if we use batches since it's easier to parallelize. Batching is the simplest way to parallelize. -->
実際には、単一のサンプルで確率的勾配降下法を行う代わりにバッチを使用します。私たちは、単一のサンプルではなく、サンプルのバッチにわたって勾配の平均を計算し、その後、1ステップ更新します。これを行う理由は、単に、バッチを使用した方が並列化が容易なので、既存のハードウェア（GPUやマルチコアCPUなど）をより効率的に利用できるからです。並列化するにはバッチが一番簡単です。

<!-- ### Traditional neural network -->
### 従来のニューラルネットワーク 

<!-- Traditional Neural Nets are basically interspersed layers of linear operations and point-wise non-linear operations. For linear operations, conceptually it is just a matrix-vector multiplication. We take the (input) vector multiplied by a matrix formed by the weights. The second type of operation is to take all the components of the weighted sums vector and pass it through some simple non-linearity (i.e. $\texttt{ReLU}(\cdot)$, $\tanh(\cdot)$, …). -->
従来のニューラルネットでは、基本的に線形演算と要素ごとの非線形演算の層が散在しています。線形演算については、概念的には行列-ベクトルの乗算にすぎません。（入力）ベクトルに重みで形成された行列を乗算したものを取ります。第二のタイプの演算は、加重和ベクトルの全成分を取り、単純な非線形関数(例えば、$\texttt{ReLU}(\cdot)$, $\tanh(\cdot)$, ....)を通過させるものです。

<!-- | <center><img src="{{site.baseurl}}/images/week02/02-1/Figure3.png" alt="Figure3" style="zoom:30%;" /></center> |
|             <center>Figure 4: Traditional Neural Network             </center>| -->
| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure3.png" alt="Figure3" style="zoom:30%;" /></center> |
|             <center>図4: 従来のニューラルネットワーク             </center>|

<!-- 
Figure 4 is an example of a 2-layer network, because what matters are the pairs (i.e linear+non-linear). Some people call it a 3-layer network because they count the variables. Note that if there are no non-linearities in the middle, we may as well have a single layer because the product of two linear functions is a linear function.

Figure 5 shows how the linear and non-linear functional blocks of the network stack: -->

図4は2層ネットワークの例ですが、重要なのはペア（つまり線形+非線形）です。変数を数えるので3層ネットワークと呼ぶ人もいます。もし中間層に非線形性がなければ、2つの線形関数の積が線形関数になるので、1層にしてもよいことに注意してください。

図5は、ネットワークの線形関数ブロックと非線形関数ブロックがどのように積み重なっているかを示しています。

<!-- | <center><img src="{{site.baseurl}}/images/week02/02-1/Figure4.png" alt="Figure4" style="zoom:30%;" /></center> |
|  <center>Figure 5: Looking inside the linear and non-linear blocks   </center>| -->
| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure4.png" alt="Figure4" style="zoom:30%;" /></center> |
|  <center>図5: 線形ブロックと非線形ブロックの中身  </center>|


<!-- In the graph, $s[i]$ is the weighted sum of unit ${i}$ which is computed as: -->
このグラフでは、$s[i]$はユニット${i}$の重み付き和で、次のように計算されます

$$
s[i]=\Sigma_{j \in UP(i)}w[i,j]\cdot z[j]
$$

<!-- where $UP(i)$ denotes the predecessors of $i$ and  $z[j]$ is the $j$th output from the previous layer.

The output $z[i]$ is computed as: -->

ここで、$UP(i)$は$i$に入ってくるものを表し、$z[j]$は前のレイヤーからの$j$番目の出力です。

出力 $z[i]$ は次のように計算されます。

$$
z[i]=f(s[i])
$$

<!-- where $f$ is a non-linear function. -->
ここで$f$は非線形関数です。


<!-- ### Backpropagation through a non-linear function -->
### 非線形関数を通した誤差逆伝播法

<!-- The first way to do backpropagation is to backpropagate through a non linear function. We take a particular non-linear function $h$ from the network and leave everything else in the blackbox. -->
誤差逆伝播を行う最初の方法は、非線形関数を通して誤差逆伝播を行うことです。ネットワークから特定の非線形関数 $h$ を取り出し、他のすべてをブラックボックスに入れておきます。

<!-- | <center><img src="{{site.baseurl}}/images/week02/02-1/Figure5.png" alt="Figure5" style="zoom: 25%;" /></center> |
|    <center>Figure 6: Backpropagation through non-linear function     </center>| -->
| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure5.png" alt="Figure5" style="zoom: 25%;" /></center> |
|    <center>図6: 非線形関数を通した誤差逆伝播    </center>|

<!-- We are going to use the chain rule to compute the gradients: -->
勾配を計算するために連鎖律を用います

$$
g(h(s))' = g'(h(s))\cdot h'(s)
$$

<!-- where $h'(s)$ is the derivative of $z$ w.r.t $s$ represented by $\frac{\mathrm{d}z}{\mathrm{d}s}$.
To make the connection between derivatives clear, we rewrite the formula above as: -->
ここで、$h'(s)$は、$s$についての$z$の微分で、$\frac{\mathrm{d}z}{\mathrm{d}s}$で表されます。
微分同士の関係を明確にするために、上の式を次のように書き換えます

$$
\frac{\mathrm{d}C}{\mathrm{d}s} = \frac{\mathrm{d}C}{\mathrm{d}z}\cdot \frac{\mathrm{d}z}{\mathrm{d}s} = \frac{\mathrm{d}C}{\mathrm{d}z}\cdot h'(s)
$$

<!-- Hence if we have a chain of those functions in the network, we can backpropagate by multiplying by the derivatives of all the ${h}$ functions one after the other all the way back to the bottom. -->

<!-- It’s more intuitive to think of it in terms of perturbations. Perturbing $s$ by $\mathrm{d}s$ will perturb $z$ by: -->

したがって、もしネットワーク内にこれらの関数の連鎖があるならば、すべての${h}$ 関数の微分を乗算して誤差逆伝播し、入力層に戻ることができます。

摂動を加えるという観点から考えると、より直感的です。sを$\mathrm{d}s$で摂動すると、次のように$z$を摂動することになります


$$\mathrm{d}z = \mathrm{d}s \cdot h'(s)$$

<!-- This would in turn perturb C by: -->
そしてこれは下のようにCを摂動することになります

$$
\mathrm{d}C = \mathrm{d}z\cdot\frac{\mathrm{d}C}{\mathrm{d}z} = \mathrm{d}s\cdot h’(s)\cdot\frac{\mathrm{d}C}{\mathrm{d}z}
$$

<!-- Once again, we end up with the same formula as the one shown above. -->
もう一度、上に示したのと同じような式を得ることができました。


<!-- ### Backpropagation through a weighted sum -->
### 重み付き和を通した誤差逆伝播

<!-- For a linear module, we do backpropagation through a weighted sum. Here we view the entire network as a blackbox except for 3 connections going from a ${z}$ variable to a bunch of $s$ variables. -->
線形モジュールに対しては、重み付き和を用いて誤差逆伝播を行います。ここでは、${z}$変数から$s$変数たちに向かう3つの接続を除いて、ネットワーク全体をブラックボックスとみなしています。

<!-- | <center><img src="{{site.baseurl}}/images/week02/02-1/Figure6.png" alt="Figure6" style="zoom: 25%;" /></center> |
|        <center>Figure 7: Backpropagation through weighted sum        </center>| -->
 <center><img src="{{site.baseurl}}/images/week02/02-1/Figure6.png" alt="Figure6" style="zoom: 25%;" /></center> |
|        <center>図7: 重み付き和を通った誤差逆伝播       </center>|


<!-- This time the perturbation is a weighted sum. Z influences several variables. Perturbing $z$ by $\mathrm{d}z$ will perturb $s[0]$, $s[1]$ and $s[2]$ by: -->
今回は摂動は重み付き和です。Zは様々な変数に影響します。$z$を$\mathrm{d}z$で摂動すると、$s[0]$, $s[1]$ そして $s[2]$を次のように摂動します

$$
\mathrm{d}s[0]=w[0]\cdot \mathrm{d}z
$$

$$
\mathrm{d}s[1]=w[1]\cdot \mathrm{d}z
$$

$$
\mathrm{d}s[2]=w[2]\cdot\mathrm{d}z
$$

 <!-- This will perturb C by -->
 これはCを次のように摂動します

$$
\mathrm{d}C = \mathrm{d}s[0]\cdot \frac{\mathrm{d}C}{\mathrm{d}s[0]}+\mathrm{d}s[1]\cdot \frac{\mathrm{d}C}{\mathrm{d}s[1]}+\mathrm{d}s[2]\cdot\frac{\mathrm{d}C}{\mathrm{d}s[2]}
$$

<!-- Hence C is going to vary by the sum of the 3 variations: -->
したがって、Cは3つの変化の合計によって変化することになります

$$
\frac{\mathrm{d}C}{\mathrm{d}z} = \frac{\mathrm{d}C}{\mathrm{d}s[0]}\cdot w[0]+\frac{\mathrm{d}C}{\mathrm{d}s[1]}\cdot w[1]+\frac{\mathrm{d}C}{\mathrm{d}s[2]}\cdot w[2]
$$


<!-- ## [PyTorch implementation of neural network and a generalized backprop algorithm](https://www.youtube.com/watch?v=d9vdh3b787Y&t=2288s) -->
## [ニューラルネットワークと一般化された誤差逆伝播のPyTorch実装](https://www.youtube.com/watch?v=d9vdh3b787Y&t=2288s)


<!-- ### Block diagram of a traditional neural net -->
### 従来のニューラルネットのブロック図による表記

<!-- - Linear blocks $s_{k+1}=w_kz_k$
- Non-linear blocks $z_k=h(s_k)$ -->
- 線形ブロック $s_{k+1}=w_kz_k$
- 非線形ブロック $z_k=h(s_k)$

  <center><img src="{{site.baseurl}}/images/week02/02-1/Figure 7.png" alt="Figure 7" style="zoom: 33%;" /></center>

<!-- $w_k$: matrix $z_k$: vector $h$: application of scalar ${h}$ function to every component. This is a 3-layer neural net with pairs of linear and non-linear functions, though most modern neural nets do not have such clear linear and non-linear separations and are more complex. -->
それぞれ、$w_k$: 行列、 $z_k$: ベクトル、 $h$: スカラー関数${h}$を各成分に適用したもの、です。これは線形関数と非線形関数のペアを持つ3層のニューラルネットです。最近のニューラルネットの多くはこのような明確な線形と非線形の分離がなく、より複雑ですが。


<!-- ### PyTorch implementation -->
### PyTorch実装

```python
import torch
from torch import nn
image = torch.randn(3, 10, 20)
d0 = image.nelement()

class mynet(nn.Module):
    def __init__(self, d0, d1, d2, d3):
        super().__init__()
        self.m0 = nn.Linear(d0, d1)
        self.m1 = nn.Linear(d1, d2)
        self.m2 = nn.Linear(d2, d3)

    def forward(self,x):
        z0 = x.view(-1)  # flatten input tensor
        s1 = self.m0(z0)
        z1 = torch.relu(s1)
        s2 = self.m1(z1)
        z2 = torch.relu(s2)
        s3 = self.m2(z2)
        return s3
model = mynet(d0, 60, 40, 10)
out = model(image)
```

<!-- - We can implement neural nets with object oriented classes in PyTorch. First we define a class for the neural net and initialize linear layers in the constructor using predefined nn.Linear class. Linear layers have to be separate objects because each of them contains a parameter vector. The nn.Linear class also adds the bias vector implicitly. Then we define a forward function on how to compute outputs with $\text{torch.relu}$ function as the nonlinear activation. We don't have to initialize separate relu functions because they don't have parameters.

- We do not need to compute the gradient ourselves since PyTorch knows how to back propagate and calculate the gradients given the forward function. -->

- PyTorchでは、オブジェクト指向クラスを使ってニューラルネットを実装することができます。まず、ニューラルネットのクラスを定義し、コンストラクタで定義済みの nn.Linear クラスを使って線形層を初期化します。線形層は、それぞれにパラメータベクトルが含まれているので、別々のオブジェクトにする必要があります。nn.Linearクラスはバイアスベクトルも暗黙的に追加します。そして、$\text{torch.relu}$関数を非線形活性化関数として、出力を計算するためのフォワード関数を定義します。relu関数はパラメータを持たないので、個別に初期化する必要はありません。

- PyTorchはフォワード関数に対してどのように勾配を計算して伝播させるのかを知っているので、実装する人が陽に勾配を計算する必要はありません。


<!-- ### Backprop through a functional module -->
### 関数モジュールを通した誤差逆伝播

<!-- We now present a more generalized form of backpropagation. -->
より一般化された誤差逆伝播の式を示します。

<!-- | <center><img src="{{site.baseurl}}/images/week02/02-1/Figure9.png" alt="Figure9" style="zoom:33%;" /></center> |
|    <center>Figure 8: Backpropagation through a functional module     </center>| -->
 <center><img src="{{site.baseurl}}/images/week02/02-1/Figure9.png" alt="Figure9" style="zoom:33%;" /></center> |
|    <center>図8: 関数モジュールを通した誤差逆伝播     </center>|


<!-- - Using chain rule for vector functions -->
- ベクトル関数に対して連鎖律を適用して、

  $$
   z_g : [d_g\times 1]
  $$

  $$
   z_f:[d_f\times 1]
  $$

  $$
  \frac{\partial c}{\partial{z_f}}=\frac{\partial c}{\partial{z_g}}\frac{\partial {z_g}}{\partial{z_f}}
  $$

  $$
  [1\times d_f]= [1\times d_g]\times[d_g\times d_f]
  $$

  <!-- This is the basic formula for $\frac{\partial c}{\partial{z_f}}$ using the chain rule. Note that the gradient of a scalar function with respect to a vector is a vector of the same size as the vector with respect to which you differentiate. In order to make the notations consistent, it is a row vector instead of a column vector. -->
  これは、連鎖律を使った  $\frac{\partial c}{\partial{z_f}}$  の基本式です。スカラー関数のベクトルに対する勾配は、微分するベクトルと同じ大きさのベクトルであることに注意してください。表記に一貫性を持たせるために、列ベクトルではなく行ベクトルとしています。

<!-- - Jacobian matrix -->
- ヤコビ行列

  $$
  \left(\frac{\partial{z_g}}{\partial {z_f}}\right)_{ij}=\frac{(\partial {z_g})_i}{(\partial {z_f})_j}
  $$

  <!-- We need $\frac{\partial {z_g}}{\partial {z_f}}$ (Jacobian matrix entries) to compute the gradient of the cost function with respect to $z_f$ given gradient of the cost function with respect to $z_g$. Each entry $ij$ is equal to the partial derivative of the $i$th component of the output vector with respect to the $j$th component of the input vector.

  If we have a cascade of modules, we keep multiplying the Jacobian matrices of all the modules going down and we get the gradients w.r.t all the internal variables. -->

  $z_g$についてのコスト関数の勾配が与えられたもとで、$z_f$に対するコスト関数の勾配を計算するために、 $\frac{\partial {z_g}}{\partial {z_f}}$ (ヤコビ行列の要素)が必要です。各要素 $ij$ は、入力ベクトルの $j$ 番目の成分に対する出力ベクトルの $i$ 番目の成分の偏微分に等しいです。

  モジュールが連なっている場合、すべてのモジュールのヤコビ行列を乗算し続けると、すべての内部変数の勾配が得られます。


<!-- ### Backprop through a multi-stage graph -->
### マルチステージグラフを通した誤差逆伝播

<!-- Consider a stack of many modules in a neural network as shown in Figure 9. -->
図9に示すように、ニューラルネットワークの多くのモジュールのスタックを考えてみましょう。

<!-- | <center><img src="{{site.baseurl}}/images/week02/02-1/Figure10.png" alt="Figure10" style="zoom:33%;" /></center> |
|         <center>Figure 9: Backprop through multi-stage graph         </center>| -->
| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure10.png" alt="Figure10" style="zoom:33%;" /></center> |
|         <center>図9: マルチステージグラフを通じた誤差逆伝播        </center>|
<!-- 
For the backprop algorithm, we need two sets of gradients - one with respect to the states (each module of the network) and one with respect to the weights (all the parameters in a particular module). So we have two Jacobian matrices associated with each module. We can again use chain rule for backprop. -->
誤差逆伝播のアルゴリズムには、状態（ネットワークの各モジュール）に関するものと、重み（特定のモジュールのすべてのパラメータ）に関するものの2つの勾配のセットが必要です。つまり、各モジュールに関連付けられた2つのヤコビ行列が必要になります。誤差逆伝播には再び連鎖律を使うことができます。

<!-- - Using chain rule for vector functions -->
- ベクトル関数に連鎖律を使う

  $$
  \frac{\partial c}{\partial {z_k}}=\frac{\partial c}{\partial {z_{k+1}}}\frac{\partial {z_{k+1}}}{\partial {z_k}}=\frac{\partial c}{\partial {z_{k+1}}}\frac{\partial f_k(z_k,w_k)}{\partial {z_k}}
  $$

  $$
  \frac{\partial c}{\partial {w_k}}=\frac{\partial c}{\partial {z_{k+1}}}\frac{\partial {z_{k+1}}}{\partial {w_k}}=\frac{\partial c}{\partial {z_{k+1}}}\frac{\partial f_k(z_k,w_k)}{\partial {w_k}}
  $$

<!-- - Two Jacobian matrices for the module
    - One with respect to $z[k]$
    - One with respect to $w[k]$ -->
- モジュールに関する二つのヤコビ行列
    - $z[k]$に関するもの
    - $w[k]$に関するもの


