---
lang-ref: ch.01-3
lang: ja
title: 問題のモチベーション、線形代数、そして可視化
lecturer: Alfredo Canziani
authors: Derek Yen, Tony Xu, Ben Stadnick, Prasanthi Gurumurthy
date: 28 Jan 2020
translation-date: 2 Dec 2020
translator: Shiro Takagi
---


<!-- ## Resources -->
## リソース

<!-- Please follow Alfredo Canziani [on Twitter @alfcnz](https://twitter.com/alfcnz). Videos and textbooks with relevant details on linear algebra and singular value decomposition (SVD) can be found by searching Alfredo's Twitter, for example type `linear algebra (from:alfcnz)` in the search box. -->
Alfredo Canziani [Twitter @alfcnz](https://twitter.com/alfcnz)をフォローしてください。線形代数や特異値分解(SVD)に関する詳細なビデオや教科書は、Alfredoのツイッターで検索することができます。例えば`linear algebra (from:alfcnz)`と検索してみてください。


<!-- ## [Transformations and motivation](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=233s)

As a motivating example, let us consider image classification. Suppose we take a picture with a 1 megapixel camera. This image will have about 1,000 pixels vertically and 1,000 pixels horizontally, and each pixel will have three colour dimensions for red, green, and blue (RGB). Each particular image can then be considered as one point in a 3 million-dimensional space. With such massive dimensionality, many interesting images we might want to classify -- such as a dog *vs.* a cat -- will essentially be in the same region of the space.

In order to effectively separate these images, we consider ways of transforming the data in order to move the points. Recall that in 2-D space, a linear transformation is the same as matrix multiplication. For example, the following are linear transformations:

-   Rotation (when the matrix is orthonormal).
-   Scaling (when the matrix is diagonal).
-   Reflection (when the determinant is negative).
-   Shearing.

Note that translation alone is not linear since 0 will not always be mapped to 0, but it is an affine transformation. Returning to our image example, we can transform the data points by translating such that the points are clustered around 0 and scaling with a diagonal matrix such that we "zoom in" to that region. Finally, we can do classification by finding lines across the space which separate the different points into their respective classes. In other words, the idea is to use linear and nonlinear transformations to map the points into a space such that they are linearly separable. This idea will be made more concrete in the following sections. -->

## [変換とモチベーション](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=233s)

動機を与える例として、画像の分類を考えてみましょう。1メガピクセルのカメラで写真を撮ったとします。この画像は、縦に約1,000ピクセル、横に約1,000ピクセルの画素を持ち、各画素は赤、緑、青（RGB）の3つの色の次元を持っています。それぞれの画像は、300万次元空間の1点と考えることができます。このような巨大な次元により、犬と猫のように分類したいと思うような興味深い画像は、本質的に空間の同じ領域に存在することになります。

これらの画像を効果的に分離するために、点を移動させるためのデータの変換方法を考えます。2次元空間では、線形変換は行列積と同じであることを思い出してください。例えば、以下のような線形変換があります。

- 回転（行列が正規直交の場合）
- 拡大縮小（対角行列の場合）
- 鏡映（行列式が負の場合）
- せん断

0 が常に 0 に写像されるとは限らないので、平行移動だけでは線形ではないことに注意してください。画像の例に戻ると、点が0の周りにクラスタリングされるように変換し、その領域に「ズームイン」するように対角行列でスケーリングすることで、データ点を変換することができます。最後に、異なる点をそれぞれのクラスに分ける線を空間全体に見つけることで、分類を行うことができます。言い換えれば、線形変換と非線形変換を使って、点を線形分離可能な空間にマッピングするという考え方です。この考え方は、次の節でより具体的に説明します。


<!-- ## [Data visualization - separating points by colour using a network](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=798s)

In our visualization, we have five branches of a spiral, with each branch corresponding to a different colour. The points live in a two dimensional plane and can be represented as a tuple; the colour represents a third dimension which can be thought of as the different classes for each of the points. We then use the network to separate each of the points by colour.

| <center><img src="{{site.baseurl}}/images/week01/01-3/Spiral1.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week01/01-3/Spiral2.png" width="200px"/></center> |
|             (a) Input points, pre-network             |            (b) Output points, post-network             |

<center> Figure 1: Five colour spiral </center>
The network \"stretches\" the space fabric in order to separate each of the points into different subspaces. At convergence, the network separates each of the colours into different subspaces of the final manifold. In other words, each of the colours in this new space will be linearly separable using a one vs all regression. The vectors in the diagram can be represented by a five by two matrix; this matrix can be multiplied to each point to return scores for each of the five colours. Each of the points can then be classified by colour using their respective scores. Here, the output dimension is five, one for each of the colours, and the input dimension is two, one for the x and y coordinates of each of the points. To recap, this network basically takes the space fabric and performs a space transformation parametrised by several matrices and then by non-linearities. -->

## [データの可視化 - ネットワークを使って色で点を区切る](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=798s)

この可視化では、5つの枝を持つ螺旋があり、それぞれの枝は異なる色に対応しています。点は２次元平面上にあり、タプルとして表現することができます。色は三次元を表現しており、これは各点ごとに異なるクラスであると考えることができます。そして、ネットワークを使用して、各点を色で区切ります。

| <center><img src="{{site.baseurl}}/images/week01/01-3/Spiral1.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week01/01-3/Spiral2.png" width="200px"/></center> |
|             (a) 入力点、ネットワークに通す前            |            (b) 出力点、ネットワークに通した後             |

<center> 図1: 5色の螺旋 </center>
ネットワークは、それぞれの点を異なる部分空間に分離するために、空間構造を引き伸ばします。収束すると、ネットワークは、最終的な多様体の異なる部分空間に各色を分離します。言い換えれば、この新しい空間の色のそれぞれは、１対すべての回帰において線形分離可能になります。図中のベクトルは、5×2の行列で表すことができます。この行列は、各点に乗算することで、5つの色のそれぞれのスコアを返すことができます。ここでは、出力次元は5で、色ごとに1つずつ、入力次元は2で、それぞれ点xとyの座標に1つずつです。要約すると、このネットワークは基本的に空間構造を受け取り、いくつかの行列と非線形性によってパラメトライズされた空間の変換を行います。

<!-- ### Network architecture -->
### ネットワークアーキテクチャ

<!-- <center>
<img src="{{site.baseurl}}/images/week01/01-3/Network.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
Figure 2: Network Architecture
</center> -->
<center>
<img src="{{site.baseurl}}/images/week01/01-3/Network.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
図2: ネットワークアーキテクチャ
</center>

<!-- The first matrix maps the two dimensional input to a 100 dimensional intermediate hidden layer. We then have a non-linear layer, `ReLU` or Rectified Linear Unit, which is simply *positive part* $(\cdot)^+$ function. Next, to display our image in a graphical representation, we include an embedding layer that maps the 100 dimensional hidden layer input to a two-dimensional output. Lastly, the embedding layer is projected to the final, five-dimensional layer of the network, representing a score for each colour. -->
最初の行列は、2次元の入力を100次元の隠れ層にマッピングします。次に、非線形層、`ReLU`（Rectified Linear Unit）ですが、これは単に*正の部分* を返す関数$(\cdot)^+$です。そして、画像をグラフィカルに表示するために、100次元の隠れ層の入力を2次元の出力にマッピングする埋め込み層を加えます。最後に、埋め込み層は、各色のスコアを表すネットワークの最終的な5次元の層に射影します。


<!-- ## [Random projections - Jupyter Notebook](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=1693s)

The Jupyter Notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/02-space_stretching.ipynb). In order to run the notebook, make sure you have the `pDL` environment installed as specified in [`README.md`](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/README.md). -->


## [ランダム射影 - Jupyter Notebook](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=1693s)

Jupyter Notebook は [ここ](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/02-space_stretching.ipynb)から見つかります。このノートブックを動かすためには、[`README.md`](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/README.md)で説明されているような`pDL`環境をインストールしていなければなりません。


### PyTorch `device`
<!--
PyTorch can run on both the CPU and GPU of a computer. The CPU is useful for sequential tasks, while the GPU is useful for parallel tasks. Before executing on our desired device, we first have to make sure our tensors and models are transferred to the device's memory. This can be done with the following two lines of code: -->

PyTorch はコンピュータの CPU と GPU の両方で動作します。CPUはシーケンシャルなタスクに、GPUはパラレルなタスクに適しています。目的のデバイスで実行する前に、まず、テンソルとモデルがデバイスのメモリに転送されていることを確認する必要があります。これは以下の2行のコードで行うことができます。

```python
device = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")
X = torch.randn(n_points, 2).to(device)
```

<!-- The first line creates a variable, called `device`, that is assigned to the GPU if one is available; otherwise, it defaults to the CPU. In the next line, a tensor is created and sent to the device's memory by calling `.to(device)`. -->
最初の行では、`device`という変数を作成し、GPUが利用可能であればGPUに代入します。次の行では、`.to(device)`を呼び出すことでテンソルが作成され、デバイスのメモリに送られます。

<!--
### Jupyter Notebook tip

To see the documentation for a function in a notebook cell, use `Shift + Tab.` -->

### Jupyter Notebookのヒント

ノートブックのセル内の関数のドキュメントを見るには、`Shift + Tab`を押してください。



<!-- ### Visualizing linear transformations

Recall that a linear transformation can be represented as a matrix. Using singular value decomposition, we can decompose this matrix into three component matrices, each representing a different linear transformation. -->

### 線形変換の可視化

線形変換は行列として表現できることを思い出してください。特異値分解を用いて、行列を、それぞれ異なる線形変換を表す3つの成分行列に分解することができます。

$$
W = U\begin{bmatrix}s_1 & 0 \\ 0 & s_2 \end{bmatrix} V^\top
$$

<!-- In eq. (1), matrices $U$ and $V^\top$ are orthogonal and represent rotation and reflection transformations. The middle matrix is diagonal and represents a scaling transformation.

We visualize the linear transformations of several random matrices in Fig. 3. Note the effect of the singular values on the resulting transformations.

The matrices used were generated with Numpy; however, we can also use PyTorch's `nn.Linear` class with `bias = False` to create linear transformations. -->

式(1)において、行列 $U$ と $V^\top$ は互いに直交する行列で、それぞれ回転変換と鏡映変換を表しています。真ん中の行列は対角行列で、スケーリング変換を表しています。

いくつかのランダムな行列の線形変換を図3に示します。特異値が結果の変換に与える影響に注目してください。

使用した行列は Numpy で生成したものですが、PyTorch の `nn.Linear` クラスで `bias = False` を指定して線形変換を行うこともできます。

| ![]({{site.baseurl}}/images/week01/01-3/initial_scatter_lab1.png) | ![]({{site.baseurl}}/images/week01/01-3/matrix_multiplication_lab1.png) | ![]({{site.baseurl}}/images/week01/01-3/matrix_multiplication_lab1_2.png) |
|     (a) Original points       |   (b) $s_1$ = 1.540, $s_2$ = 0.304  |   (c) $s_1$ = 0.464, $s_2$ = 0.017    |

<!-- <center> Figure 3:  Linear transformations from random matrices </center> -->
<center> 図3:  ランダム行列からの線形変換 </center>


<!-- ### Non-linear transformations -->
### 非線形変換

<!-- Next, we visualize the following transformation: -->
次に、下の変換を可視化します。

$$
f(\vx) = \tanh\bigg(\begin{bmatrix} s & 0 \\ 0 & s \end{bmatrix} \vx \bigg)
$$

<!-- Recall, the graph of $\tanh(\cdot)$ in Fig. 4. -->
図４の$\tanh(\cdot)$の図を思い出してください。

<!-- <center>
<img src="{{site.baseurl}}/images/week01/01-3/tanh_lab1.png" width="250px" /><br>
Figure 4: hyperbolic tangent non-linearity
</center> -->
<center>
<img src="{{site.baseurl}}/images/week01/01-3/tanh_lab1.png" width="250px" /><br>
図4: tanh非線形性
</center>
<!--
The effect of this non-linearity is to bound points between $-1$ and $+1$, creating a square. As the value of $s$ in eq. (2) increases, more and more points are pushed to the edge of the square. This is shown in Fig. 5. By forcing more points to the edge, we spread them out more and can then attempt to classify them. -->


この非線形性は、$-1$ と $+1$ の間の点を束縛し、正方形を作ります。(2)式の $s$ の値が大きくなるにつれて、より多くの点が正方形の端に押し出されます。これを図5に示します。より多くの点を周辺に押し付けることで、点をより大きく広げることができ、これによって分類を試みることができます。
<!-- 
| <img src="{{site.baseurl}}/images/week01/01-3/matrix_multiplication_with_nonlinearity_s=1_lab1.png" width="200px" /> | <img src="{{site.baseurl}}/images/week01/01-3/matrix_multiplication_with_nonlinearity_s=5_lab1.png" width="200px" /> |
|                 (a) Non-linearity with $s=1$                 |                 (b) Nonlinearity with $s=5$                  |

<center> Figure 5:   Non-linear Transformations </center>
-->

| <img src="{{site.baseurl}}/images/week01/01-3/matrix_multiplication_with_nonlinearity_s=1_lab1.png" width="200px" /> | <img src="{{site.baseurl}}/images/week01/01-3/matrix_multiplication_with_nonlinearity_s=5_lab1.png" width="200px" /> |
|                 (a) $s=1$の非線形性                 |                 (b) $s=5$の非線形性                  |

<center> 図5:   非線形変換 </center>


<!-- ### Random neural net

Lastly, we visualize the transformation performed by a simple, untrained neural network. The network consists of a linear layer, which performs an affine transformation, followed by a hyperbolic tangent non-linearity, and finally another linear layer. Examining the transformation in Fig. 6, we see that it is unlike the linear and non-linear transformations seen earlier. Going forward, we will see how to make these transformations performed by neural networks useful for our end goal of classification.

<center>
<img src="{{site.baseurl}}/images/week01/01-3/untrained_nn_transformation_lab1.png" width="200px" /><br>
Figure 6:  Transformation from an untrained neural network
</center> -->

### ランダムニューラルネット

最後に、単純な、訓練されていないニューラルネットワークによって実行される変換を可視化します。このネットワークは、アフィン変換を行う線形層、tanh非線形、そして最後に別の線形層から構成されています。図6の変換を見てみると、先ほどの線形変換や非線形変換とは異なることがわかります。今後、ニューラルネットワークによるこれらの変換を、最終的な目的である分類に役立てるにはどうすればよいかを見ていきます。

<center>
<img src="{{site.baseurl}}/images/week01/01-3/untrained_nn_transformation_lab1.png" width="200px" /><br>
図6:  学習されていないニューラルネットによる変換
</center>
