---
lang-ref: ch.01-2
lang: ja
lecturer: Yann LeCun
title: CNNの進化と使用、そして、なぜ深層学習なのか？
authors: Marina Zavalina, Peeyush Jain, Adrian Pearl, Davida Kollmar
date: 27 Jan 2020
translation-date: 2 Dec 2020
translator: Shiro Takagi
---


<!-- ## [Evolution of CNNs](https://www.youtube.com/watch?v=0bMe_vCZo30&t=2965s) -->
## [CNNの進化](https://www.youtube.com/watch?v=0bMe_vCZo30&t=2965s)

<!-- In animal brains, neurons react to edges that are at particular orientations. Groups of neurons that react to the same orientations are replicated over all of the visual field.

Fukushima (1982) built a neural net (NN) that worked the same way as the brain, based on two concepts. First, neurons are replicated across the visual field. Second, there are complex cells that pool the information from simple cells (orientation-selective units). As a result, the shift of the picture will change the activation of simple cells, but will not influence the integrated activation of the complex cell (convolutional pooling).

LeCun (1990) used backprop to train a CNN to recognize handwritten digits. There is a demo from 1992 where the algorithm recognizes the digits of any style. Doing character/pattern recognition using a model that is trained end-to-end was new at that time. Previously, people had used feature extractors with a supervised model on top.

These new CNN systems could recognize multiple characters in the image at the same time. To do it, people used a small input window for a CNN and swiped it over the whole image. If it activated, it meant there was a particular character present.

Later, this idea was applied to faces/people detection and semantic segmentation (pixel-wise classification). Examples include Hadsell (2009) and Farabet (2012). This eventually became popular in industry, used in autonomous driving applications such as lane tracking.

Special types of hardware to train CNN were a hot topic in the 1980s, then the interest dropped, and now it has become popular again.

The deep learning (though the term was not used at that time) revolution started in 2010-2013. Researchers focused on inventing algorithms that could help train large CNNs faster. Krizhevsky (2012) came up with AlexNet, which was a much larger CNN than those used before, and trained it on ImageNet (1.3 million samples) using GPUs. After running for a couple of weeks AlexNet beat the performance of the best competing systems by a large margin -- a 25.8% vs 16.4% top-5 error rate.

After seeing AlexNet's success, the computer vision (CV) community was convinced that CNNs work. While all papers from 2011-2012 that mentioned CNNs had been rejected, since 2016 most accepted CV papers use CNNs.

Over the years, the number of layers used has been increasing: LeNet -- 7, AlexNet -- 12, VGG -- 19, ResNet -- 50. However, there is a trade-off between the number of operations needed to compute the output, the size of the model, and its accuracy. Thus, a popular topic now is how to compress the networks to make the computations faster. -->

動物の脳では、ニューロンは、特定の方向にあるエッジに反応します。同じ方向に反応するニューロンのグループは、視覚野全体に複製されています。

福島(1982)は、2つの概念に基づいて、脳と同じように働くニューラルネット(NN)を構築しました。第一に、ニューロンは視覚野全体に複製されているということです。第二に、単純型細胞（方位選択ユニット）からの情報をプールする複雑型細胞が存在するということです。その結果、像のシフトは単純型細胞の活性化に変化を与えますが、複雑型細胞の統合的な活性化には影響を与えません（畳み込みプーリング）。

LeCun(1990)は手書きの数字を識別するCNNの訓練に誤差逆伝播法を使いました。1992年のデモでは、任意のスタイルの数字を認識しています。エンドツーエンドで学習されたモデルを使って文字・パターン認識を行うことは、当時としては新しいことでした。それまでは、教師ありモデルの前に特徴量抽出器を置いていました。
これらの新しいCNNシステムは、画像中の複数の文字を同時に認識することができました。そのためには、CNN用の小さな入力ウィンドウを使って、画像全体をスワイプしました。それが活性化すれば、特定の文字が存在することを意味します。

その後、このアイデアは、顔や人物の検出やセマンティックセグメンテーション（ピクセル単位の分類）にも応用されました。例としては、Hadsell (2009)やFarabet (2012)などがあります。これはやがて産業界でも普及し、車線追跡などの自動運転の応用場面でも使われるようになりました。

CNNを訓練するための特殊なタイプのハードウェアは1980年代に話題になりましたが、その後は関心が下がり、今では再び人気が出てきています。

ディープラーニング（当時はこの用語は使われていませんでしたが）革命は2010年から2013年に始まりました。研究者たちは、大規模なCNNをより速く訓練するのに役立つアルゴリズムを発明することに焦点を当てていました。Krizhevsky(2012)は、それまで使われていたCNNよりもはるかに大規模なAlexNetを考え出し、GPUを使ってImageNet(130万サンプル)で訓練をしました。数週間学習を回した後、AlexNetは競合する当時最高のシステムの性能を大差で上回りました。具体的には、トップ5の誤差率は25.8%に対して16.4%でした。

AlexNetの成功を見て，コンピュータビジョン（CV）コミュニティはCNNが機能することを確信しました。2011年から2012年までのCNNに言及した論文はすべてリジェクトされていましたが、2016年以降はほとんどのCV論文でCNNが使われています。

この数年の間に、使用される層の数は増加しています。LeNetは7層、AlexNetは12層、VGGは19層、ResNetは50層となっています。しかし、出力の計算に必要な演算数、モデルのサイズ、精度の間にはトレードオフがあります。そこで、ネットワークを圧縮して計算を高速化する方法が、現在の人気のトピックとなっています。


<!-- ## [Deep Learning and Feature Extraction](https://www.youtube.com/watch?v=0bMe_vCZo30&t=3955s) -->

<!-- Multilayer networks are successful because they exploit the compositional structure of natural data. In compositional hierarchy, combinations of objects at one layer in the hierarchy form the objects at the next layer. If we mimic this hierarchy as multiple layers and let the network learn the appropriate combination of features, we get what is called Deep Learning architecture. Thus, Deep Learning networks are hierarchical in nature.

Deep learning architectures have led to an incredible progress in computer vision tasks ranging from identifying and generating accurate masks around the objects to identifying spatial properties of an object. Mask-RCNN and RetinaNet architectures mainly led to this improvement.

Mask RCNNs have found their use in segmenting individual objects, i.e. creating masks for each object in an image. The input and output are both images. The architecture can also be used to do instance segmentation, i.e. identifying different objects of the same type in an image. Detectron, a Facebook AI Research (FAIR) software system, implements all these state-of-the-art object detection algorithms and is open source.

Some of the practical applications of CNNs are powering autonomous driving and analysing medical images.

Although the science and mathematics behind deep learning is fairly understood, there are still some interesting questions that require more research. These questions include: Why do architectures with multiple layers perform better, given that we can approximate any function with two layers? Why do CNNs work well with natural data such as speech, images, and text? How are we able to optimize non-convex functions so well? Why do over-parametrised architectures work?

Feature extraction consists of expanding the representational dimension such that the expanded features are more likely to be linearly separable; data points in higher dimensional space are more likely to be linearly separable due to the increase in the number of possible separating planes.

Earlier machine learning practitioners relied on high quality, hand crafted, and task specific features to build artificial intelligence models, but with the advent of Deep Learning, the models are able to extract the generic features automatically. Some common approaches used in feature extraction algorithms are highlighted below:

- Space tiling
- Random Projections
- Polynomial Classifier (feature cross-products)
- Radial basis functions
- Kernel Machines

Because of the compositional nature of data, learned features have a hierarchy of representations with increasing level of abstractions. For example:

-  Images - At the most granular level, images can be thought of as pixels. Combination of pixels constitute edges which when combined forms textons (multi-edge shapes). Textons form motifs and motifs form parts of the image. By combining these parts together we get the final image.
-  Text - Similarly, there is an inherent hierarchy in textual data. Characters form words, when we combine words together we get word-groups, then clauses, then by combining clauses we get sentences. Sentences finally tell us what story is being conveyed.
-  Speech - In speech, samples compose bands, which compose sounds, which compose phones, then phonemes, then whole words, then sentences, thus showing a clear hierarchy in representation. -->

## [深層学習と特徴抽出](https://www.youtube.com/watch?v=0bMe_vCZo30&t=3955s)

多層ネットワークが成功しているのは、自然のデータの構成的な構造を利用しているからです。構成的な階層では、ある階層のオブジェクトの組み合わせが次の階層のオブジェクトを形成します。この階層を多層として模倣し、ネットワークに適切な特徴の組み合わせを学習させると、いわゆるディープラーニングアーキテクチャが得られます。このように、ディープラーニングネットワークは階層的な性質を持っています。

ディープラーニングアーキテクチャは、物体の周囲の正確なマスクの識別と生成から、物体の空間的特性の識別まで、コンピュータビジョンのタスクにおいて驚異的な進歩をもたらしました。マスクRCNNとRetinaNetアーキテクチャが、主にこのような進歩をもたらしました。
マスクRCNNは、個々のオブジェクトのセグメンテーション、すなわち、画像内の各オブジェクトのマスクを作成する際に使用されています。入力と出力は両方とも画像です。このアーキテクチャは、インスタンスセグメンテーション、すなわち、画像内の同じタイプの異なるオブジェクトを識別するためにも使用できます。Facebook AI Research（FAIR）のソフトウェアシステムであるDetectronは、これらの最先端の物体検出アルゴリズムをすべて実装しており、オープンソースになっています。

CNNの実用的な応用例としては、自動運転や医療画像の分析などがあります。

ディープラーニングの背後にある科学と数学はかなり理解されていますが、まだまだ研究が必要な興味深い問題がいくつかあります。これらの疑問には以下のようなものがあります。2つの層でどんな関数も近似できるのに、なぜ複数の層を持つアーキテクチャの方が性能が良いのか？なぜCNNは音声、画像、テキストなどの自然なデータに対してうまく機能するのか？非凸関数をどうやってこれほどうまく最適化できるのか？オーバーパラメトライズドなアーキテクチャはなぜ機能するのか？などです。

特徴抽出は、拡張された特徴が線形分離可能である可能性が高くなるように表現次元を拡張することからなります。

初期の機械学習では、人工知能モデルを構築するために、高品質で手作業で作られたタスク固有の特徴に頼っていました。しかし、ディープラーニングの出現により、モデルは自動的に一般的な特徴を抽出することができるようになりました。特徴抽出アルゴリズムで使用されている一般的なアプローチを以下に紹介します。

- スペースタイリング
- ランダム射影
- 多項式分類器 (特徴量の交差積)
- 放射基底関数
- カーネルマシン

データの構成性のため、学習された特徴は抽象度が高くなるにつれて表現の階層を持ちます。例えば、以下のようなものがあります。

- 画像 - 最も細かいレベルでは、画像はピクセルとして考えることができます。ピクセルの組み合わせはエッジを構成し、それらが組み合わされることでtexton（複数のエッジ形状）が形成されます。textonはモチーフを形成し、モチーフは画像の一部を形成します。これらの部分を組み合わせることで、最終的な画像を得ることができます。
- テキスト - 同様に、テキストデータにも固有の階層があります。文字は単語を形成し、単語を組み合わせることで単語群を形成し、次に節を形成し、節を組み合わせることで文を形成します。文は、最終的にどのようなストーリーが伝えられているのかを教えてくれます。
- 音声 - 音声では、サンプルがバンドを構成し、それが音を構成し、それが単音を構成し、次に音素を構成し、次に単語全体を構成し、次に文を構成し、このように表現に明確な階層性があることを示しています。

<!-- ## [Learning representations](https://www.youtube.com/watch?v=0bMe_vCZo30&t=4767s)

There are those who dismiss Deep Learning: if we can approximate any function with 2 layers, why have more?

For example: SVMs find a separating hyperplane "in the span of the data", meaning predictions are based on comparisons to training examples. SVMs are essentially a very simplistic 2 layer neural net, where the first layer defines "templates" and the second layer is a linear classifier. The problem with 2 layer fallacy is that the complexity and size of the middle layer is exponential in $N$ (to do well with a difficult task, need LOTS of templates). But if you expand the number of layers to $\log(N)$, the layers become linear in $N$. There is a trade-off between time and space.

An analogy is designing a circuit to compute a boolean function with no more than two layers of gates -- we can compute **any boolean function** this way! But, the complexity and resources of the first layer (number of gates) quickly becomes infeasible for complex functions.

What is "deep"?

- An SVM isn't deep because it only has two layers
- A classification tree isn't deep because every layer analyses the same (raw) features
- A deep network has several layers and uses them to build a **hierarchy of features of increasing complexity**

How can models learn representations (good features)?

Manifold hypothesis: natural data lives in a low-dimensional manifold. Set of possible images is essentially infinite, set of "natural" images is a tiny subset. For example: for an image of a person, the set of possible images is on the order of magnitude of the number of face muscles they can move (degrees of freedom) ~ 50. An ideal (and unrealistic) feature extractor represents all the factors of variation (each of the muscles, lighting, *etc.*).

Q&A from the end of lecture:

- For the face example, could some other dimensionality reduction technique (*i.e.* PCA) extract these features?
  - Answer: would only work if the manifold surface is a hyperplane, which it is not -->

## [表現の学習](https://www.youtube.com/watch?v=0bMe_vCZo30&t=4767s)

ディープラーニングを否定する人たちがいます: どんな関数でも2つの層で近似できるなら、なぜそれ以上の層を持つ必要があるのでしょうか?

例えば SVMは「データ全体に渡って」分離する超平面を見つけます。これは、予測が訓練サンプルの比較に基づいていることを意味しています。SVMは本質的に非常に単純な2層のニューラルネットであり、第1層が「テンプレート」を定義し、第2層が線形分類器です。2層に関する誤謬の問題点は、中間層の複雑さとサイズが$N$について指数関数的であることです（難しいタスクをうまくこなすためには、たくさんのテンプレートが必要だということです）。しかし、層の数を $\log(N)$ に拡張すると、層は $N$について線形になります。時間と空間の間にはトレードオフがあるのです。

アナロジーとして、2層以上のゲートでブール関数を計算する回路を設計することが考えられます -- **どんなブール関数も**この方法で計算できます! しかし、最初の層（ゲート数）の複雑さとリソースは、複雑な関数にはすぐに実行不可能になります。

では「ディープ」とは何でしょう？

- SVMは2つの層しかないので、ディープではありません。
- 分類木は、すべてのレイヤーが同じ（生の）特徴を分析するので、深くはありません。
- ディープネットワークにはいくつかの層があり、それらを使用して**複雑さを増す特徴の階層を構築します**。

モデルはどのようにして表現（良い特徴）を学習できるのでしょうか？

多様体仮説：自然なデータは低次元の多様体の中に存在するというものです。可能な画像の集合は本質的に無限ですが、「自然な」画像の集合はごく一部です。例えば、人物の画像の場合、可能な画像の集合は、人物が動かせる顔の筋肉の数（自由度）〜50のオーダーです。理想的な（非現実的な）特徴抽出器は、すべての変動要因（筋肉、照明、*など*）を表現します。

講義の最後からQ&A。

- 顔の例では、他の次元削減技術(PCA*など*)でこれらの特徴を抽出できますか？
  - 答え: 多様体表面が超平面である場合にのみ機能しますが、そうではありません。
