---
lang-ref: ch.01-1
lang: ja
lecturer: Yann LeCun
title: ディープラーニングへのモチベーションとその歴史とインスピレーション
authors: Yunya Wang, SunJoo Park, Mark Estudillo, Justin Mae
date: 27 Jan 2020
translation-date: 5 Oct 2020
translator: Shohei Ogawa
---


<!-- ## [Course plan](https://www.youtube.com/watch?v=0bMe_vCZo30&t=217s) -->

## [コースの予定](https://www.youtube.com/watch?v=0bMe_vCZo30&t=217s)

<!--
Basics of Supervised Learning, Neural Nets, Deep Learning
Backpropagation and architectural components
Convolutional neural network and its applications
More Deep Learning Architectures
Regularization Tricks / Optimization Tricks / Understanding how Deep Learning works
Energy-based models
Self-supervised learning and beyond
-->

- 教師あり学習、ニューラルネット、ディープラーニングの基礎
- 誤差逆伝播法とアーキテクチャの要素
- 畳み込みニューラルネットワークとその応用
- 更に多くのディープラーニングのアーキテクチャについて
- 正規化と最適化で知っておくと役立つポイントとディープラーニングがどのようにタスクを行うかについての理解
- エネルギーベースモデル
- 自己教師あり学習とそれ以上のこと

<!-- ## Inspiration of Deep Learning and its history -->

## ディープラーニングのインスピレーションとその歴史

<!-- On a conceptual level, deep learning is inspired by the brain but not all of the brain's details are relevant. For a comparison, aeroplanes were inspired by birds. The principle of flying is the same but the details are extremely different.  -->

ディープラーニングは概念レベルでは脳の一部をきっかけとして誕生しましたが脳の詳細全てに関係する訳ではありません。同じようなこととして飛行機は鳥から着想を得ましたが飛行機と鳥が空を飛ぶ原理は根本的に違うということが挙げられます。

<!-- The history of deep learning goes back to a field which changed its name now to cybernetics. It started in the 1940s with McCulloch and Pitts. They came up with the idea that neurons are threshold units with on and off states. You could build a Boolean circuit by connecting neurons with each other and conduct logical inference with neurons. The brain is basically a logical inference machine because neurons are binary. Neurons compute a weighted sum of inputs and compare that sum to its threshold. It turns on if it's above the threshold and turns off if it's below, which is a simplified view of how neural networks work.  -->

ディープラーニングの歴史は現在では人工頭脳学と呼ばれるかつて存在した分野にまで遡ります。1940年代にMcCullochとPittsが扱い始め、ニューロンはオンとオフの状態がある閾値をもつ要素であるという考えに至りました。ニューロンを繋ぎ合わせることでブール回路を作れば論理的推論を行うことができるのではないかと考えられました。基本的にはニューロンの二値性のため脳は論理的推論を行う機械であると言えます。ニューロンは入力情報の重み付き和を計算しニューロンそれ自身が持つ閾値と比較します。もし計算された和が閾値より高ければニューロンはオン状態になり、閾値以下ではオフ状態になりますが、これがニューラルネットワークがなぜうまく機能するのかを説明できる簡略化された見方です。

<!-- In 1947, Donald Hebb had the idea that neurons in the brain learn by modifying the strength of the connections between neurons. This is called hyper learning, where if two neurons are fired together, then the connection linked between them increases; if they don't fire together, then the connection decreases.  -->

1947年、Donald Hebbは脳内にあるニューロンが他のニューロン間の結びつきの強さを変えることで学習ができるという考えに至りました。この考え方はハイパーラーニングと呼ばれ、もし二つのニューロンが同時に活性化すれば結びつきが強くなり、そうでなければ結びつきを弱めるということを意味します。

<!-- Later in 1948, cybernetics were proposed by Norbert Wiener, which is the idea that by having systems with sensors and actuators, you have a feedback loop and a self-regulatory system. The rules of the feedback mechanism of a car all come from this work.  -->

1948年終盤には、センサーとアクチュエータを用いたシステムでフィードバックループと自己抑制を備えたシステムを構築することができるという考え方が人工頭脳学としてNorbert Wienerによって提唱されました。自動車のフィードバックの仕組みは全てここから来ています。

<!-- In 1957, Frank Rosenblatt proposed the Perceptron, which is a learning algorithm that modifies the weights of very simple neural nets.  -->

1857年にはFrank Rosenblattがとても単純なニューラルネットワークの重みを変化させるという学習アルゴリズムであるパーセプトロンというものを提唱しました。

<!-- Overall, this idea of trying to build intellectual machines by simulating lots of neurons was born in 1940s, took off in 1950s, and completely died in late 1960s. The main reasons for the field dying off in 1960 are:
- The researchers used neurons that were binary. However, the way to get backpropagation to work is to use activation functions that are continuous. At that time, researchers didn't have the idea of using continuous neurons and they didn't think they can train with gradients because binary neurons are not differential.
- With continuous neurons, one would have to multiply the activation of a neuron by a weight to get a contribution to the weighted sum. However, before 1980, the multiplication of two numbers, especially floating-point numbers, were extremely slow. This resulted in another incentive to avoid using continuous neurons.  -->

総合的に見ると、ニューロンの仕組みを真似することで知能機械を生み出そうというコンセプトは1940年代に生まれ、1950年代に注目を集めたものの1960年代後半には完全に廃れたものとなりました。1960年代にこうなってしまった理由としては：
- 誤差逆伝播法をうまく行うためには連続である活性化関数を使う必要がありましたが、研究者はニューロンが完全に二値を取るものとして扱っていました。その当時、連続的なニューロンを用いるという考え方には至らず、二値のみを取るニューロンは微分不可であり勾配を計算して学習を行えるとは考えませんでした。
- 連続なニューロンを使う場合、重み付き和による作用を求めるにはニューロンの活性化値と重みの積を取る必要があると考えられていましたが、1980年以前は二つの数値（特に浮動小数点の値）同士の積をコンピューター上で求めるのは非常に低速であったこともあり連続の活性化関数はあまり現実的ではありませんでした。

<!-- Deep Learning took off again in 1985 with the emergence of backpropagation. In 1995, the field died again and the machine learning community abandoned the idea of neural nets. In early 2010, people start using neuron nets in speech recognition with huge performance improvement and later it became widely deployed in the commercial field. In 2013, computer vision started to switch to neuron nets. In 2016, the same transition occurred in natural language processing. Soon, similar revolutions will occur in robotics, control, and many other fields. -->

1985年に誤差逆伝播法の誕生とともにディープラーニングが再び注目され始めたものの、1995年には過去のものとなり機械学習の分野ではニューラルネットの考え方には誰も見向きもしなくなりました。2010年代初頭には音声認識の分野でニューラルネットが利用され始めて良い結果を残し、その後商用目的で広く使われました。2013年にはニューラルネットがコンピュータビジョンの分野で幅広く使われ始め、2016年には自然言語処理の分野でも幅広く使われ始めました。ロボティクス、制御、その他の分野でも同様の変化が起こるでしょう。

<!-- ### Supervised Learning -->
### 教師あり学習

<!-- $90\%$ of deep learning applications use supervised learning. Supervised learning is a process by which, you collect a bunch of pairs of inputs and outputs, and the inputs are feed into a machine to learn the correct output. When the output is correct, you don't do anything. If the output is wrong, you tweak the parameter of the machine and correct the output toward the one you want. The trick here is how you figure out which direction and how much you tweak the parameter and this goes back to gradient calculation and backpropagation.  -->

$90\%$のディープラーニングの利用例が教師あり学習を用いています。教師あり学習とは、入力と対応する出力の組み合わせをたくさん使って入力情報から正しい出力を出すようにコンピューター上のシステムに学習させることです。もし出力が正解なら何もせず、もし不正解なら正しい出力を出せるようにシステムのパラメーターを変更します。ここで重要なのはどの方向にどれだけパラメーターを変化させるかを求めることであり、勾配計算と誤差逆伝播法を使うこととなります。

<!-- Supervised learning stems from Perceptron and Adaline. The Adaline is based on the same architecture with weighted inputs; when it is above the threshold, it turns on and below the threshold, it turns off. The Perceptron is a 2-layer neuron net where the second layer is trainable and the first layer is fixed. Most of the time, the first layer is determined randomly and that's what they call associative layers.  -->

教師あり学習はパーセプトロンとアダラインから派生しています。アダラインはパーセプトロンと同じですが重み付きの入力を使います。入力がある閾値より大きければオン状態になり、そうでなければオフ状態になります。パーセプトロンは二層のニューラルネットであり、一層目は固定されていますが二層目は訓練可能です。ほとんどの場合、一層目はランダムに決められ連想層と呼ばれます。


<!-- ## [History of Pattern Recognition and introduction to Gradient Descent](https://www.youtube.com/watch?v=0bMe_vCZo30&t=1461s) -->
## [パターン認識の歴史と勾配降下法への導入](https://www.youtube.com/watch?v=0bMe_vCZo30&t=1461s)

<!-- The foregoing is the conceptual basis of pattern recognition before deep learning developed. The standard model of pattern recognition consists of feature extractor and trainable classifier. Input goes into the feature extractor, extracting relevant useful characteristics of inputs such as detecting an eye when the purpose is recognizing the face. Then, the vector of features is fed to the trainable classifier for computing weighted sum and comparing it with the threshold. Here, a trainable classifier could be a perceptron or single neural network. The problem is feature extractor should be engineered by hand. Which means, pattern recognition/computer vision focus on feature extractor considering how to design it for a particular problem, not much devoted to a trainable classifier.  -->

前述の内容はディープラーニングが普及する前にパターン認識の分野で取り入れられていた基本的なコンセプトです。特徴量抽出器と学習可能分類器を使うことがパターン認識においては一般的でした。例えば顔認識を行いたい時に目を検出することなど、入力されたデータの関連性のある有用な特徴を抽出します。そして得られた特徴量ベクトルを用いて学習可能な分類器で重み付き和を計算し閾値と比較します。パーセプトロンや一層だけのニューラルネットワークが用いるべき学習可能な分類器の候補となります。ただこの場合、人の手によって特徴量抽出を行う必要があり問題となります。つまりパターン認識とコンピュータビジョンにおいては、ある問題に対して使えそうな特徴抽出器の検討に注意が行きがちで、学習可能な分類器の設計はあまり重要視されないということです。

<!-- After the emergence and development of deep learning, the 2-stage process changed to the sequences of modules. Each module has tunable parameters and nonlinearity. Then, stack them making multiple layers. This is why it is called “deep learning”. The reason why using nonlinearity rather than linearity is that two linear layers could be one linear layer since the composition of two linear is linear.  -->

ディープラーニングが出現し成熟した頃には、その二段階プロセスが数々の部品が繋ぎ合わさったものへと変貌していました。それらの部品それぞれが調整可能なパラメータと非線形性を持っており、重なり合って複数の階層を構成します。これが「ディープラーニング」と呼ばれる所以です。ここで線形ではなく非線形性を与えるのはもし２つの層が両方とも線形性を持つならそれらは一つの線形の層で表すことができるためです。

<!-- The simplest multi-layer architecture with tunable parameters and nonlinearity could be: the input is represented as a vector such as an image or audio. This input is multiplied by the weight matrix whose coefficient is a tunable parameter. Then, every component of the result vector is passed through a nonlinear function such as ReLU. Repeating this process, it becomes a basic neural network. The reason why it is called a neural network is that this architecture calculates the weighted sum of components of input by corresponding rows of a matrix.  -->

訓練可能なパラメータと非線形性を持つ複数層を持つアーキテクチャで最も単純なものとしては、画像や音がベクトル表現として入力され、訓練可能な重みとの積となり、そしてその積の要素一つずつに対してReLUのような非線形関数を適用するものです。このプロセスを繰り返すことにより基本的なニューラルネットワークとなります。これがニューラルネットワークと呼ばれているのは、このアーキテクチャが入力の要素の重み付き和を、行列の列に対応させながら計算するからです。

<!-- Back to the point of supervised learning, we are comparing the resulting output with target output then optimize the objective function which is the loss, computing a distance/penalty/divergence between the result and target. Then, average this cost function over the training set. This is the goal we want to minimize. In other words, we want to find the value of the parameters that minimize this average.  -->

教師あり学習の話に戻ると、実際の出力内容と出力されるべき内容とで距離・ペナルティ・ダイバージェンスを計算して比較し、損失となる目的関数の最適化を行います。そして、このコスト関数を訓練データ全体で平均し最小化したいと考えます。言い換えれば、この平均値が最小となるようなパラメーターの値を求めたいということです。

<!-- The method of how to find it is computing gradient. For example, if we are lost in a smooth mountain at foggy night and want to go to the village in the valley. One way could be turning around and seeing which way the steepest way is to go down then take a small step down. The direction is (negative) gradient. With the assumption that the valley is convex, we could reach the valley.  -->

そのパラメータを求めるためには勾配計算を行います。例えば、霧の出た夜中に平滑な山で道に迷ってしまい、谷にある村に向かおうとしているとしましょう。その場で周囲を見てどの方向に進むのが下り勾配が最も急になるかを見つけその方向に一歩進みます。その方向は（負の）勾配（グラーディエント）となります。もし谷が下に凸であることを仮定すればこの方法で谷底に辿りつくことができ、一つの方法として考えられます。

<!-- The more efficient way is called Stochastic Gradient Descent (SGD). Since we want to minimize average loss over the training set, we take one sample or small group of samples and calculate the error, then use gradient descent. Then, we take a new sample and get a new value for the error, then get the gradient which is a different direction normally. Two of the main reasons for using SGD are that it helps a model to converge fast empirically if the training set is very large and it enables better generalization, which means getting similar performance on various sets of data.  -->

更に効率的な方法としては確率的勾配降下法（Stochastic Gradient Descent - SGD）が挙げられます。訓練データ全体での損失の平均値の最小化を行いたいのですから、サンプルの一部を選んで誤差を計算し勾配降下法を用い、またサンプル別の部分を用いて新しい誤差を計算し勾配を取得します。このとき基本的には新しい勾配はその前のもととは異なる値を取ります。SGDを用いる主な理由としては、訓練データが非常に大きいときにでも素早く収束に至りやすいことが経験的に知られていることと、様々なデータセットに対して同様の結果が得られるかを表す汎化性能が良くなりやすいことの二つがあります。

<!-- ### [Computing gradients by backpropagation](https://www.youtube.com/watch?v=0bMe_vCZo30&t=2336s) -->
### [誤差逆伝播法による勾配の計算方法](https://www.youtube.com/watch?v=0bMe_vCZo30&t=2336s)

<!-- Computing gradients by backpropagation is a practical application of the chain rule. The backpropagation equation for the input gradients is as follows: -->

誤差逆伝播法による勾配の計算は連鎖則の実用的な応用であり、入力に関しての勾配を求める誤差逆伝播の式は以下のようになります：

$$
\begin{aligned}
\frac{\partial C}{\partial \boldsymbol{x}_{i - 1}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial \boldsymbol{x}_i}{\partial \boldsymbol{x}_{i - 1}} \\
\frac{\partial C}{\partial \boldsymbol{x}_{i - 1}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial f_i(\boldsymbol{x}_{i - 1}, \boldsymbol{w}_i)}{\partial \boldsymbol{x}_{i - 1}}
\end{aligned}
$$

<!-- The backpropagation equation for the weight gradients is as follows: -->

重みに関しての勾配を求める誤差逆伝播の式は以下のようになります：

$$
\begin{aligned}
\frac{\partial C}{\partial \boldsymbol{w}_{i}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial \boldsymbol{x}_i}{\partial \boldsymbol{w}_{i}} \\
\frac{\partial C}{\partial \boldsymbol{w}_{i}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial f_i(\boldsymbol{x}_{i - 1}, \boldsymbol{w}_i)}{\partial \boldsymbol{w}_{i}}
\end{aligned}
$$

<!-- Note that instead of scalar inputs, they will be vector inputs. More generally, multi-dimensional inputs. Backpropagation allows you to compute the derivative of the difference of the output you want and the output you get (which is the value of the objective function) with respect to any value inside the network. Finally, backpropagation is essential as it applies to multiple layers.  -->

ここで注意したいのは入力がスカラー値ではなくベクトル値であり、より一般には多次元の入力値となることです。誤差逆伝播法により、正しい出力と実際の出力の差分についてネットワーク上にあるいかなる値に関する微分も計算することができ、この差分が目的関数ともなります。誤差逆伝播法はネットワーク上の複数の層に用いることができるため重要です。

<!-- It is important to consider how to interpret inputs. For example, an image of 256$$\times$$256 would require a 200,000 valued matrix. These would be huge matrices that the neural network layers will need to handle. It would be impractical to utilize such matrices. Therefore, it is important to make hypothesis of the structure of the matrix.  -->

入力をどのように変換するかも大切です。例えば、256$$\times$$256の画像では200,000個の値を持つ行列が必要となるでしょう。このような行列はニューラルネットの層が扱うには大きすぎて実用的ではありません。そのため行列の構造について仮説を組み立てることが重要になってきます。

<!-- ## Hierarchical representation of the Visual Cortex -->

## 視覚野の階層的表現

<!-- Experiments by Fukushima gave us an understanding of how our brain interprets the input to our eyes. In summary, it was discovered that neurons in front of our retina compress the input (known as contrast normalization) and the signal travels from our eyes to our brain. After this, the image gets processed in stages and certain neurons get activated for certain categories. Hence, the visual cortex does pattern recognition in a hierarchical manner.  -->

福島による実験によって脳がどのようにして眼からの情報を解釈するかへの理解が得られました。端的に言えば、網膜の前にあるニューロンにより入力情報が圧縮されて（これはコントラスト正規化として知られています）更に信号が眼から脳へと伝わることが分かりました。その後伝わった視覚情報が階層的に処理され、特定のカテゴリーに対応するあるニューロンが活性化することで情報の分類が成されます。このようにして視覚野は階層的にパターン認識をしています。

<!-- Experiments in which researchers poked electrodes in specific areas of the visual cortex, specifically the V1 area made researchers realize that certain neurons react to motifs that appear in a very small area in a visual field and similarly with neighbouring neurons and neighbouring areas in the visual field. Additionally, neurons that react to the same visual field, react to different types of edges in an organized manner (*e.g.* vertical or horizontal edges). It is also important to note that there's also the idea that the visual process is essentially a feed forward process. Hence, somehow fast recognition can be done without some recurrent connections.  -->

視覚野の特定の部位、特に一次視覚野 （V1）に電極を差し込むことで行う実験により、視野の極々一部に出現した模様に対して特定のニューロンが反応を示し、さらにその近くにある違う模様に対しては最初のニューロンの近くのニューロンが反応することが分かりました。さらに、視野の同じ部分に反応するニューロンは様々な種類のエッジに対して規則的に反応する（例えば辺が垂直か水平か）ことも分かりました。また、視覚プロセスが本質的にはフィードフォーワードの過程であるという考え方があるということを知っておくのも重要です。こうして循環的な接続無しで高速に認識を行うことができるのです。
