---
lang: it
lang-ref: ch.12
title: Settimana 12
translation-date: 1 Oct 2020
translator: Francesca Guiso
---


## Lezione parte A
<!-- ## Lecture part A -->

In questa sezione discuteremo delle varie architetture utilizzate nelle applicazioni dell'elaborazione del linguaggio naturale, detta anche detta anche _NLP_ (dall'inglese _Natural Language Processing_). Iniziamo dalle _CNN_, le _RNN_, giungendo infine alle architetture all'avanguardia: i _Transformer_ (letteralmente: trasformatore). Discutiamo poi dei vari moduli compresi nei _Transformer_ e di come essi facciano in modo che quest'architettura si presti bene al NLP. Infine, discutiamo di alcuni "trucchi" che ci permettono di addestrare i _transformer_ in maniera efficace.

<!-- In this section we discuss the various architectures used in NLP applications, beginning with CNNs, RNNs, and eventually covering the state of-the art architecture, transformers. We then discuss the various modules that comprise transformers and how they make transformers advantageous for NLP tasks. Finally, we discuss tricks that allow transformers to be trained effectively. -->


## Lezione parte B
<!-- ## Lecture part B -->

In questa sezione introduciamo l'algoritmo di ricerca _beam search_ (letteralmente, ricerca a raggio) che fa da via di mezzo fra la decodificazione _greedy_ (avida) e la ricerca esaustiva (_exhaustive search_). Consideriamo il caso di voler campionare dalla distribuzione generativa (ovvero, quando si genera un testo) ed introduciamo il campionamento _top-k_. Di seguito, introduciamo i modelli _sequence-to-sequence_ (letteralmente: da-sequenza-a-sequenza) con una variante _transformer_, e la retrotraduzione (_backtranslation_). Infine, introduciamo l'approccio non-supervisionato all'apprendimento di rappresentazioni (_embedding_) e presentiamo i modelli _word2vec_ ("da-parola-a-vettore"), _GPT_, e _BERT_.

<!-- In this section we introduce beam search as a middle ground betwen greedy decoding and exhaustive search. We consider the case of wanting to sample from the generative distribution (*i.e.* when generating text) and introduce "top-k" sampling. Subsequently, we introduce sequence to sequence models (with a transformer variant) and backtranslation. We then introduce unsupervised learning approaches for learning embeddings and discuss word2vec, GPT, and BERT. -->

## Pratica
<!-- ## Practicum -->

Introduciamo il concetto di attenzione, focalizzandoci sull'auto-attenzione (_self-attention_) e le rappresentazioni dell'input generate nello strato nascosto. Di seguito, introduciamo il paradigma del _key-value store_ e vediamo un modo di rappresentare quesiti (_queries_), chiavi (_keys_), e valori (_values_) come rotazioni di un input. Infine, utilizziamo il concetto di attenzione per interpretare l'archiettutra del _transformer_, facendo un _forward pass_ attraverso il _transformer_ basico, e mettendo a confronto il paradigma _encoder-decoder_ ed un'architettura sequenziale.

<!-- We introduce attention, focusing on self-attention and its hidden layer representations of the inputs. Then, we introduce the key-value store paradigm and discuss how to represent queries, keys, and values as rotations of an input. Finally, we use attention to interpret the transformer architecture, taking a forward pass through a basic transformer, and comparing the encoder-decoder paradigm to sequential architectures. -->
