---
lang-ref: ch.12-2
lang: it
title: Decodificare i modelli di linguaggio
lecturer: Mike Lewis
authors: Trevor Mitchell, Andrii Dobroshynskyi, Shreyas Chandrakaladharan, Ben Wolfson
date: 20 Apr 2020
translator: Marco Zullich
translation-date: 20 Jan 2021
---


## [Beam Search](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=2732s)

La *Beam Search* è un'altra tecnica per decodificare un modello di linguaggio e produrre un testo. Ad ogni passo, l'algoritmo tiene traccia delle $k$ traduzioni parziali (*ipotesi*) più probabili (*migliori*).

<!-- Beam search is another technique for decoding a language model and producing text. At every step, the algorithm keeps track of the $k$ most probable (best) partial translations (hypotheses). The score of each hypothesis is equal to its log probability. -->

L'algoritmo seleziona l'ipotesi con miglior punteggio.

<!-- The algorithm selects the best scoring hypothesis. -->

<center>
<img src="{{site.baseurl}}/images/week12/12-2/Beam_Decoding.png" width="60%"/><br>
<b>Fig. 1</b>: decodificazione del <i>Beam Search</i> <!--Beam Decoding-->
</center>

Come funziona la ramificazione dell'albero di cui in Fig. 1?

<!-- How deep does the beam tree branch out ? -->

L'albero continua a ramificare finché non raggiunge un simbolo che indichi la fine della frase. Quando il modello restituisce come output tale segnale, l'ipotesi è completa.

<!-- The beam tree continues until it reaches the end of sentence token. Upon outputting the end of sentence token, the hypothesis is finished. -->

Come mai, nella traduzione automatica neurale, un'ampiezza del fascio (*beam size*) grande risulta spesso in traduzioni vuote?

<!-- Why (in NMT) do very large beam sizes often results in empty translations? -->

In fase di addestramento l'algoritmo spesso non utilizza un fascio (*beam*) in quanto molto costoso. Usa invece una fattorizzazione auto-regressiva (ovvero, dato il precedente output corretto, predice delle possibili $n+1$ prime parole). Il modello non viene esposto ai propri errori durante la fase di addestramento, ed è quindi possibile che sia presente una certa dose di insensatezza nel fascio.

<!-- At training time, the algorithm often does not use a beam, because it is very expensive. Instead it uses auto-regressive factorization (given previous correct outputs, predict the $n+1$ first words). The model is not exposed to its own mistakes during training, so it is possible for “nonsense” to show up in the beam. -->

L'algoritmo continua finché tutte le $k$ ipotesi producono dei simboli di conclusione della frase o finché una lunghezza massima $T$ viene raggiunta.

<!-- Summary: Continue beam search until all $k$ hypotheses produce end token or until the maximum decoding limit T is reached. -->


### Campionamento

<!-- ### Sampling -->

Potremmo non desiderare di generare la sequenza più probabile, ma campionare dalla distribuzione del modello.

<!-- We may not want the most likely sequence. Instead we can sample from the model distribution. -->

Tuttavia, questo tipo di campionamento ha i suoi problemi. Dal momento in cui viene campionata una sequenza non buona, il modello si trova ad essere esposto ad uno stato mai visto durante l'addestramento, il che aumenta le probabilità di continuare una catena di valutazioni "cattiva". L'algoritmo potrebbe quindi rimanere bloccato in un circolo vizioso.

<!-- However, sampling from the model distribution poses its own problem. Once a "bad" choice is sampled, the model is in a state it never faced during training, increasing the likelihood of continued "bad" evaluation. The algorithm can therefore get stuck in horrible feedback loops. -->


### Campionamento top-k

<!-- NOTA PER I REVISORI: mi sono permesso di espandere un minimo le traduzioni in IT in quanto ho ritenuto che la versione EN fosse troppo stringata a discapito della comprensibilità; inoltre, alcuni termini (renormalize, top-k) sono di uso comune nel lessico tecnico inglese ma poco usate in italiano. -->

<!-- ### Top-K Sampling -->

Si va a campionare da una distribuzione di ipotesi limitata alle migliori $k$. Partendo dalla distribuzione complessiva delle ipotesi, è necessario ri-normalizzare la distribuzione troncata affinché sia effettivamente una distribuzione di probabilità. Fatto ciò, possiamo effettuare il campionamento.

<!-- A pure sampling technique where you truncate the distribution to the $k$ best and then renormalise and sample from the distribution. -->

<center>
<img src="{{site.baseurl}}/images/week12/12-2/Top_K_Sampling.png" width="60%"/><br>
<b>Fig. 2</b>: campionamento <i>top-k</i>
<!-- Top K Sampling -->
</center>


#### Domanda: perché il campionamento top-k funziona così bene?

<!-- #### Question: Why does Top-K sampling work so well? -->

Questa tecnica funziona bene perché, essenzialmente, vuole prevenire l'uscita dalla varietà definita dal "buon linguaggio", che invece si può incontrare (come visto nella sezione "Campionamento"); questa prevenzione si ottiene utilizzando solamente la testa della distribuzione complessiva, troncando la coda di ipotesi meno probabili.

<!-- This technique works well because it essentially tries to prevent falling off of the manifold of good language when we sample something bad by only using the head of the distribution and chopping off the tail. -->


## Valutare la generazione del testo

<!-- ## Evaluating Text Generation -->

La valutazione del modello di linguaggio richiede semplicemente il calcolo della log-verosimiglianza dei dati di test. Tuttavia, questo calcolo su dati testuali è complicato. Si possono valutare metriche, comunemente utilizzate, di sovrapposizione di parole con riferimento (es. BLUE, ROUGE), ma queste hanno i loro problemi.

<!-- Evaluating the language model requires simply log likelihood of the held-out data. However, it is difficult to evaluate text. Commonly word overlap metrics with a reference (BLEU, ROUGE etc.) are used, but they have their own issues. -->


## Modelli sequenza-per-sequenza (sequence-to-sequence)

<!-- ## Sequence-To-Sequence Models -->


### Modelli di linguaggio condizionali

<!-- ### Conditional Language Models -->

I modelli di linguaggio condizionali (*Conditional Language Models*) non sono utili per la generazione di campioni casuali in inglese, ma per generare un testo dato un input.

<!-- Conditional Language Models are not useful for generating random samples of English, but they are useful for generating a text given an input. -->

Esempi:
- data una frase in francese, generarne la traduzione in inglese
- dato un documento, generarne un riassunto
- dato un dialogo, generare la frase successiva
- data una domanda, generare una risposta


<!-- Examples:

- Given a French sentence, generate the English translation
- Given a document, generate a summary
- Given a dialogue, generate the next response
- Given a question, generate the answer -->


### Modelli sequenza-per-sequenza

<!-- ### Sequence-To-Sequence Models -->

Generalmente, il testo di input viene codificato (*encoded*). Il risultato della codificazione viene chiamato "vettore di pensieri" (*thought vector*) e viene passato al decodificatore per generare dei simboli una parola alla volta.

<!-- Generally, the input text is encoded. This resulting embedding is known as a "thought vector", which is then passed to the decoder to generate tokens word by word. -->

<center>
<img src="{{site.baseurl}}/images/week12/12-2/s2s_Models.png" width="60%"/><br>
<b>Fig. 3</b>: vettore di pensieri
<!-- Thought Vector -->
</center>


### Transformer sequenza-per-sequenza

<!-- ### Sequence-To-Sequence Transformer -->

Il *transformer* sequenza-per-sequenza è composto di due livelli:

<!-- The sequence-to-sequence variation of transformers has 2 stacks: -->

1. Codificatore (*Encoder stack*) – all'auto-attenzione non sovrapposta una maschera, così ogni simbolo di input può rivolgere la sua attenzione a ogni altro simbolo di input

<!-- 1. Encoder Stack – Self-attention isn't masked so every token in the input can look at every other token in the input -->

2. Decodificatore (*Decoder stack*) – oltre ad utilizzare l'auto-attenzione, utilizza anche l'attenzione verso tutto l'input

<!-- 2. Decoder Stack – Apart from using attention over itself, it also uses attention over the complete inputs -->

<center>
<img src="{{site.baseurl}}/images/week12/12-2/s2s_transformers.png" width="80%"/><br>
<b>Fig. 4</b>: transformer sequenza-per-sequenza
<!-- Sequence to Sequence Transformer -->
</center>

Ogni simbolo di output ha una connessione diretta ad ogni simbolo di output precedente e ad ogni parola dell'input. Le connessioni rendono questi modelli molto espressivi e potenti: i *transformer* hanno migliorato i precedenti risultati delle traduzioni ad opera di modello ricorrenti e convoluzionali.

<!-- Every token in the output has direct connection to every previous token in the output, and also to every word in the input. The connections make the models very expressive and powerful. These transformers have made improvements in translation score over previous recurrent and convolutional models. -->


## [Traduzione inversa](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=3811s)

<!-- ## [Back-translation](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=3811s) -->

L'addestramento di questi modelli richiede una gran quantità di dati etichettati. Una buona fonte di dati in questo senso sono gli atti del parlamento europeo: il testo è tradotto manualmente in varie lingue e lo possiamo utilizzare sia come input che come output del modello.

<!-- When training these models, we typically rely on large amounts of labelled text. A good source of data is from European Parliament proceedings - the text is manually translated into different languages which we then can use as inputs and outputs of the model. -->


### Problematiche

<!-- ### Issues -->

- Non tutte le lingue sono rappresentate nel parlamento europeo: ciò significa che non otterremo testi tradotti per tutte le lingue di nostro interesse. Come troviamo dati per l'addestramento in un'altra lingua?
- Poiché i modelli come i *transformer* funzionano molto meglio con grandi quantitativi di dati, come usiamo del testo monolinguistico (ovvero, senza accoppiate input/output) per l'addestramento?

<!-- - Not all languages are represented in the European parliament, meaning that we will not get translation pair for all languages we might be interested in. How do we find text for training in a language we can't necessarily get the data for?
- Since models like transformers do much better with more data, how do we use monolingual text efficiently, *i.e.* no input / output pairs? -->

Assumiamo di voler addestrare un modello per tradurre testo dal tedesco all'inglese. L'idea della traduzione inversa è quella di, innanzitutto, addestrare un "modello inverso" dall'inglese al tedeco.

<!-- Assume we want to train a model to translate German into English. The idea of back-translation is to first train a reverse model of English to German -->

- Usando un limitato numero di dati già tradotti, possiamo acquisire delle frasi in due diverse lingue
- Una volta ottenuto un modello inglese → tedesco, traduciamo un gran quantitativo di singole parole inglesi in tedesco

<!-- - Using some limited bi-text we can acquire same sentences in 2 different languages -->
<!-- - Once we have an English to German model, translate a lot of monolingual words from English to German. -->

Infine, addestriamo il modello dal tedesco all'inglese utilizzando le parole tedesche che sono state "tradotte inversamente" nel passaggio precedente. Si noti che:

<!-- Finally, train the German to English model using the German words that have been 'back-translated' in the previous step. We note that: -->

- Indipendentemente da quanto non sia buono il modello inverso, passiamo da traduzioni tedesche di scarsa qualità, ma le traduzioni verso l'inglese sono "pulite"
- Il modello deve imparare a capire bene l'inglese, ben oltre le accoppiate inglese/tedesco a nostra disposizione: dobbiamo quindi usare una gran quantità di testo monolingue in inglese.

<!-- - It doesn't matter how good the reverse model is - we might have noisy German translations but end up translating to clean English.
- We need to learn to understand English well beyond the data of English / German pairs (already translated) - use large amounts of monolingual English -->


### Traduzione inversa iterativa

<!-- ### Iterated Back-translation -->

- La procedura di traduzione inversa può essere iterata così da generare un numero persino maggiore di dati testuali in entrambe le lingue, raggiungendo performance di molto maggiori: è necessario continuare ad addestrare il modello usando dati monolingue.
- Aiuta molto quando non sono presenti dall'inizio dati "paralleli" in entrambe le lingue

<!-- - We can iterate the procedure of back-translation in order to generate even more bi-text data and reach much better performance - just keep training using monolingual data.
- Helps a lot when not a lot of parallel data -->


## Traduzione automatica multilingue massiva

<!-- ## Massive multilingual MT -->

<center>
<img src="{{site.baseurl}}/images/week12/12-2/multi-language-mt.png" width="60%"/><br>
<b>Fig. 5</b>: traduzione multilingue massiva
<!-- Multilingual MT -->
</center>

- Anziché provare ad apprendere una traduzione da una lingua all'altra, si costruisce una rete neurale per imparare a tradurre in più lingue.
- Il modello impara delle generiche informazioni indipendenti dalla singola lingua.

<!-- - Instead of trying to learn a translation from one language to another, try to build a neural net to learn multiple language translations.
- Model is learning some general language-independent information. -->

<center>
<img src="{{site.baseurl}}/images/week12/12-2/multi-mt-results.gif" width="60%"/><br>
<b>Fig. 6</b>: risultati della rete neurale per traduzione multilingue
<!-- Multilingual NN Results -->
</center>

Si hanno degli ottimi risultati risultati, specialmente se vogliamo addestrare un modello a tradurre verso lingue per le quali non si hanno molti dati a disposizione ("linguaggi a basse risorse").

<!-- Great results especially if we want to train a model to translate to a language that does not have a lot of available data for us (low resource language). -->


## Apprendimento non supervisionato per l'NLP

<!-- ## Unsupervised Learning for NLP -->

Ci sono enormi quantità di testi non etichettati e pochi dati supervisionati. Come si può apprendere cose a proposito di un linguaggio semplicemente leggendo del testo non etichettato?

<!-- There are huge amounts of text without any labels and little of supervised data. How much can we learn about the language by just reading unlabelled text? -->


### `word2vec`

Intuizione: parole che compaiono vicine in un testo sono probabilmente correlate; speriamo così che, solamente osservando un testo in inglese non catalogato, possiamo impararne il significato.

<!-- Intuition - if words appear close together in the text, they are likely to be related, so we hope that by just looking at unlabelled English text, we can learn what they mean. -->

- L'obiettivo è apprendere una rappresentazione di uno spazio vettoriale delle parole (ovvero di impararne una codificazione).

<!-- - Goal is to learn vector space representations for words (learn embeddings) -->

Compito di pre-addestramento - mascherare delle parole e usare le parole vicine per riempire gli spazi mancanti.

<!-- Pretraining task - mask some word and use neighbouring words to fill in the blanks. -->

<center>
<img src="{{site.baseurl}}/images/week12/12-2/word2vec-masking.gif" width="60%"/><br>
<b>Fig. 7</b>: rappresentazione visiva della mascheratura operata per word2vec
<!-- word2vec masking visual -->
</center>

Ad esempio, qui, l'indea è che sia più plausibile che le parole *horned* ("dotato di corna") e *silver-haired* ("dai capelli d'argento") compaiano nel contesto dell'"unicorno" (*unicorn*) rispetto ad altri animali.

<!-- For instance, here, the idea is that "horned" and "silver-haired" are more likely to appear in the context of "unicorn" than some other animal. -->

Si prendono le parole e vi si applica una proiezione lineare

<!-- Take the words and apply a linear projection -->

<center>
<img src="{{site.baseurl}}/images/week12/12-2/word2vec-embeddings.png" width="60%"/><br>
<b>Fig. 8</b>:  codificazione operata da word2vec
<!-- word2vec embeddings -->
</center>

Vogliamo conoscere

<!-- Want to know -->

$$
p(\texttt{unicorno} \mid \texttt{Gli oggetti "???" dai capelli d'argento siano precedentemente sconosciuti})
$$

$$
p(x_n \mid x_{-n}) = \text{softmax}(\text{E}f(x_{-n})))
$$

Le codificazioni delle parole hanno una determinata struttura

<!-- Word embeddings hold some structure -->

<center>
<img src="{{site.baseurl}}/images/week12/12-2/embeddings-structure.png" width="60%"/><br>
<b>Fig. 9</b>: esempio di struttura della codificazione
<!-- Embedding structure example -->
</center>

- L'idea è che se prendiamo la codificazione di "re" (*king*) dopo l'addestramento e vi sommiamo la codificazione di "femmina" (*female*), otteniamo una codificazione che sia molto vicina a quella di "regina" (*queen*)
- Vengono esposte delle differenze semantiche significative nello spazio vettoriale

<!-- - The idea is if we take the embedding for "king" after training and add the embedding for "female" we will get an embedding very close to that of "queen"
- Shows some meaningful differences between vectors -->


#### Domanda: le rappresentazioni delle parole sono dipendenti o indipendenti dal contesto?

<!-- #### Question: Are the word representation dependent or independent of context? -->

Indipendenti e non hanno idea di come si relazionano con altre parole.

<!-- Independent and have no idea how they relate to other words -->


#### Domanda: quale sarebbe un esempio di una situazione in cui questo modello farebbe difficoltà?

<!-- #### Question: What would be an example of a situation that this model would struggle in? -->

L'interpretazione delle parole dipende fortemente dal contesto. Quindi, nel caso di parole ambigue - che hanno significati multipli - il modello farà difficoltà in quanto le codificazioni dei vettori non cattureranno il contesto necessario a comprendere correttamente la parola.

<!-- Interpretation of words depends strongly on context. So in the instance of ambiguous words - words that may have multiple meanings - the model will struggle since the embeddings vectors won't capture the context needed to correctly understand the word. -->


### GPT

Per aggiungere il contesto, possiamo addestrare un modello di linguaggio condizionale. Dato questo modello, il quale predice una parola ad ogni istante temporale, si rimpiazza ogni output del modello con una qualche altra caratteristica.

<!-- To add context, we can train a conditional language model. Then given this language model, which predicts a word at every time step, replace each output of model with some other feature. -->

- Pre-addestramento - predire la prossima parola
- Affinamento - adattarsi ad un compito specifico. Esempi:
  - predire se una parola è un sostantivo o un aggettivo
  - dato del testo che include delle recensioni di Amazon, predire il *valore del sentimento* per queste recensioni

<!-- - Pretraining - predict next word
- Fine-tuning - change to a specific task. Examples:
  - Predict whether noun or adjective
  - Given some text comprising an Amazon review, predict the sentiment score for the review -->

Questo approccio è buono perché possiamo ri-utilizzare il modello. Possiamo pre-addestrarne uno grande ed affinarlo su altri compiti.

<!-- This approach is good because we can reuse the model. We pretrain one large model and can fine tune to other tasks. -->


### ELMo

GPT considera solamente il contesto *verso sinistra*, il che significa che il modello non può dipendere da parole future - ciò limita di parecchio le cose che il modello può ottenere.

<!-- GPT only considers leftward context, which means the model can't depend on any future words - this limits what the model can do quite a lot. -->

L'approccio diviene quindi quello di addestrare _due_ modelli:

<!-- Here the approach is to train _two_ language models -->

- uno sul testo da sinistra a destra
- uno sul testo da destra a sinistra
- si concatena l'output dei due modelli al fine di ottenere la rappresentazione della parola. Quindi, si condiziona su entrambi i contesti (destra e sinistra).

<!-- 
- One on the text left to right
- One on the text right to left
- Concatenate the output of the two models in order to get the word representation. Now can condition on both the rightward and leftward context. -->

Questa è comunque ancora una combinazione *superficiale*, vorremmo delle interazioni più complesse fra i due contesti.

<!-- This is still a "shallow" combination, and we want some more complex interaction between the left and right context. -->


### BERT

BERT è simile a *word2vec* nel senso che abbiamo un compito di "riempire i vuoti". Tuttavia, in *word2vec* avevamo delle proiezioni lineari, mentre in BERT c'è un grosso transformer che riesce a concentrarsi su più contesti. Per addestrarlo, mascheriamo il 15% dei simboli e proviamo a predire quanto abbiamo mascherato.

<!-- BERT is similar to word2vec in the sense that we also have a fill-in-a-blank task. However, in word2vec we had linear projections, while in BERT there is a large transformer that is able to look at more context. To train, we mask 15% of the tokens and try to predict the blank. -->

Si può scalare BERT (RoBERTa):

<!-- Can scale up BERT (RoBERTa): -->

- semplificare l'obiettivo di pre-addestramento di BERT
- aumentare la dimensione del *batch*
- addestrare su un grosso numero di GPU
- addestrare su ancora più testo

<!-- - Simplify BERT pre-training objective
- Scale up the batch size
- Train on large amounts of GPUs
- Train on even more text -->

Vi sono dei grossi miglioramenti sulle performance di BERT: nel compito di rispondere alle domande ottiene ora performance sovrumane.

<!-- Even larger improvements on top of BERT performance - on question answering task performance is superhuman now. -->


## [Pre-addestramento per NLP](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=4963s)

<!-- ## [Pre-training for NLP](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=4963s) -->

Diamo ora una rapida occhiata a diversi approcci di pre-addestramento auto-supervisionato finora ricercati per l'NLP.

<!-- Let us take a quick look at different self-supervised pre training approaches that have been researched for NLP. -->

- XLNet:

  Anziché predire tutti i simboli mascherati indipendenemente fra loro, XLNet li predice in maniera autoregressiva in ordine casuale

<!-- - XLNet:

  Instead of predicting all the masked tokens conditionally independently, XLNet predicts masked tokens auto-regressively in random order -->

- SpanBERT:

  Maschera sequenze di parole consecutive anziché singoli simboli.

<!-- - SpanBERT

   Mask spans (sequence of consecutive words) instead of tokens -->

- ELECTRA:

  Anziché mascherare le parole sostituiamo i simboli con altri simboli similari. Quindi, risolviamo un problema di classificazione binaria provando a prevedere se i simboli sono stati sostituiti oppure sono originali.

  <!-- Rather than masking words we substitute tokens with similar ones.  Then we solve a binary classification problem by trying to predict whether the tokens have been substituted or not. -->

- ALBERT:

  Una versione leggera di BERT: si modifica BERT e lo si rende più leggero tramite la condivisione dei pesi fra i vari strati. Ciò riduce i parametri del modello e le computazioni coinvolte. È interessante notare come gli autori di ALBERT non hanno dovuto fare molti compromessi per quanto concerne l'accuratezza del loro modello.

  <!-- A Lite Bert: We modify BERT and make it lighter by tying the weights across layers. This reduces the parameters of the model and the computations involved. Interestingly, the authors of ALBERT did not have to compromise much on accuracy. -->

- XLM:

  BERT multilinguistico: anziché fornire al modello testo solo in inglese, gli forniamo input in più lingue. Come atteso, impara meglio le connessioni comuni fra varie lingue.

  <!-- Multilingual BERT: Instead of feeding such English text, we feed in text from multiple languages. As expected, it learned cross lingual connections better. -->

I punti chiave dei modelli sopra menzionati sono:
- Molti obiettivi di pre-addestramento funzionano bene
- Le interazioni profonde bidirezionali fra parole sono cruciali per l'efficacia del modello
- Si hanno grossi guadagni dallo scalamento verso l'alto del pre-addestramento, e non si sono ancora trovati chiari limiti

<!-- The key takeaways from the different models mentioned above are

- Lot of different pre-training objectives work well!

- Crucial to model deep, bidirectional interactions between words

- Large gains from scaling up pre-training, with no clear limits yet -->


La maggior parte dei modelli finora discussi sono costruiti al fine di risolvere problemi di classificazione testuale. Tuttavia, per risolvere problemi di generazione del testo, dove si genera l'ouptut in maniera sequenziale, come nel modello `seq2seq`, abbiamo bisogno di un approccio di pre-addestramento leggermente diverso.

<!-- Most of the models discussed above are engineered towards solving the text classification problem. However, in order to solve text generation problem, where we generate output sequentially much like the `seq2seq` model, we need a slightly different approach to pre training. -->


#### Tecniche di pre-addestramento per una generazione condizionata: BART e TS

<!-- #### Pre-training for Conditional Generation: BART and T5 -->

BART: pre-addestramento di modelli `seq2seq` tramite la rimozione di rumore dal testo

<!-- BART: pre-training `seq2seq` models by de-noising text -->

Per il pre-addestramento di BART, prendiamo in considerazione una frase e la corrompiamo tramite la mascherazione di simboli a caso. Anziché predire i simboli mascherati (come nell'obiettivo di BERT), diamo in input l'intera sequenza corrotta e cerchiamo di predire l'intera frase corretta.

<!-- In BART, for pretraining we take a sentence and corrupt it by masking tokens randomly. Instead of predicting the masking tokens (like in the BERT objective), we feed the entire corrupted sequence and try to predict the entire correct sequence. -->

Questo approccio di pre-addestramento `seq2seq` ci dà una flessibilità nella progettazione degli schemi di corruzione. Possiamo decidere di cambiare l'ordine delle frasi, di rimuoverne, di introdurne di nuove, ecc.

<!-- This `seq2seq` pretraining approach give us flexibility in designing our corruption schemes. We can shuffle the sentences, remove phrases, introduce new phrases, etc. -->

BART è stato in grado di comportarsi al pari di RoBERTa nei compiti SQUAD e GLUE. Tuttavia, dettò un nuovo stato dell'arte nella generazione di riassunti, di dialogo e sui dataset di risposta alle domande astrattiva.

<!-- BART was able to match RoBERTa on SQUAD and GLUE tasks. However, it was the new SOTA on summarization, dialogue and abstractive QA datasets. These results reinforce our motivation for BART, being better at text generation tasks than BERT/RoBERTa. -->


### Questioni aperte nell'NLP

<!-- ### Some open questions in NLP -->

- Come si integra la conoscenza del mondo?
- Come modelliamo documenti lunghi? (usualmente, i modelli basati su BERT usano 512 simboli)
- Come espletiamo compiti di apprendimento multiobiettivo al meglio?
- Si può effettuare un affinamento con meno dati?
- Questi modelli sono veramente in grado di comprendere il linguaggio?

<!-- - How should we integrate world knowledge
- How do we model long documents?  (BERT-based models typically use 512 tokens)
- How do we best do multi-task learning?
- Can we fine-tune with less data?
- Are these models really understanding language? -->


### Riassunto

<!-- ### Summary -->

- Addestrare modelli su una grande quantità di dati dà risultati migliori rispetto alla modellazione esplicita della struttura del linguaggio.

<!-- - Training models on lots of data beats explicitly modelling linguistic structure. -->

  Secondo una prospettiva di varianza vs. distorsione, i *transformer* sono modelli a bassa distorsione (molto espressivi). Addestrare questi modelli su molti dati è meglio di modellare esplicitamente la struttura linguistica (alta distorsione). Le archietture dovrebbero comprimere le sequenze tramite colli di bottiglia (*bottlenecks*).

<!-- From a bias variance perspective, Transformers are low bias (very expressive) models. Feeding these models lots of text is better than explicitly modelling linguistic structure (high bias). Architectures should be compressing sequences through bottlenecks -->

- I modelli possono apprendere molto del linguaggio predicendo parole in testo non categorizzato. Ciò è un ottimo obiettivo di apprendimento non supervisionato. Dopo di ciò, l'affinazione per compiti specifici è cosa facile.

<!-- - Models can learn a lot about language by predicting words in unlabelled text. This turns out to be a great unsupervised learning objective. Fine tuning for specific tasks is then easy -->

- Il contesto bidirezionale è cruciale ai fini del corretto funzionamento del modello

<!-- - Bidirectional context is crucial -->


### Ulteriori approfondimenti da domande pervenute dopo la lezione

<!-- ### Additional Insights from questions after class: -->

Quali sono altri modi di quantificare la "comprensione del linguaggio"? Come capiamo se questi modelli sono veramente in grado di comprendere il linguaggio?

<!-- What are some ways to quantify 'understanding language’? How do we know that these models are really understanding language? -->

«*La coppa non entrava nella valigia perché era troppo grande*»: comprendere qual è il soggetto del secondo periodo è complicato per le macchine. Gli umani sono bravi in questo compito. C'è un dataset che si concentra su esempi di questa difficoltà; gli umani vi ottengono una performance del 95%. I programmi informatici sono stati in gradi di arrivare attorno al 60% prima della rivoluzione introdotta dai *transformer*. I *transformer* moderni sono in grado di ottenere più del 90% su questo dataset: ciò suggerisce che tali modelli non stanno solo memorizzando o "sfruttando" i dati, ma imparano concetti e oggetti tramite i motivi statistici contenuti nei dati.

<!-- "The trophy did not fit into the suitcase because it was too big”: Resolving the reference of ‘it’ in this sentence is tricky for machines. Humans are good at this task. There is a dataset consisting of such difficult examples and humans achieved 95% performance on that dataset. Computer programs were able to achieve only around 60% before the revolution brought about by Transformers. The modern Transformer models are able to achieve more than 90% on that dataset. This suggests that these models are not just memorizing / exploiting the data but learning concepts and objects through the statistical patterns in the data. -->

Inoltre, BERT e RoBERTa ottengono performance sovrumane su SQUAD e GLUE. I riassunti testuali generati da BART sembrano molto realistici all'occhio umano (alti valori di BLEU). Questi fatti sono prova che i modelli comprendono il linguaggio in un certo modo.

<!-- Moreover, BERT and RoBERTa achieve superhuman performance on SQUAD and Glue. The textual summaries generated by BART look very real to humans (high BLEU scores). These facts are evidence that the models do understand language in some way. -->


#### Linguaggio concreto

<!-- #### Grounded Language -->

L'insegnante (Mike Lewis, ricercatore presso Facebook AI Research) sta lavorando ad un concetto denomimato "linguaggio concreto". L'obiettivo di questo campo di ricerca è la costruzione di agenti conversanti che possano chiacchierare o negoziare. Questi sono due compiti astratti che non hanno dei chiari obiettivi se comparati alla classificazione o alla generazione di riassunti di testo.


<!-- Interestingly, the lecturer (Mike Lewis, Research Scientist, FAIR) is working on a concept called ‘Grounded Language’. The aim of that field of research is to build conversational agents that are able to chit-chat or negotiate. Chit-chatting and negotiating are abstract tasks with unclear objectives as compared to text classification or text summarization. -->


#### Siamo in grado di valutare se il modello ha già una conoscenza del mondo?

<!-- #### Can we evaluate whether the model already has world knowledge? -->

La "conoscenza del mondo" è un concetto astratto. Possiamo testare i modelli, ad un livello molto base, nella loro conoscenza del mondo ponendo loro domande a proposito dei concetti di cui siamo interessati. Modelli come BERT, RoBERTa e T5 hanno miliardi di parametri. Considerato che tali modelli sono addestrati sulla base di enormi raccolte di testo informativo come Wikipedia, avranno memorizzato dei fatti usando i loro parametri e saranno quindi in grado di rispondere alle nostre domande. Inoltre, possiamo anche pensare di condurre i medesimi test di conoscenza prima e dopo l'affinazione del modello su un dato obiettivo. Ciò ci potrebbe dare un'idea di quanta informazione il modello avrà "dimenticato".

<!-- ‘World Knowledge’ is an abstract concept. We can test models, at the very basic level, for their world knowledge by asking them simple questions about the concepts we are interested in.  Models like BERT, RoBERTa and T5 have billions of parameters. Considering these models are trained on a huge corpus of informational text like Wikipedia, they would have memorized facts using their parameters and would be able to answer our questions. Additionally, we can also think of conducting the same knowledge test before and after fine-tuning a model on some task. This would give us a sense of how much information the model has ‘forgotten’. -->
