---
lang: it
lang-ref: ch.11-3
lecturer: Alfredo Canziani
title: Articolo "Prediction and Policy learning Under Uncertainty" (PPUU)
authors: Anuj Menta, Dipika Rajesh, Vikas Patidar, Mohith Damarapati
date: 14 Apr 2020
translation-date: 13 Sep 2020
translator: Francesca Guiso
---

## [Introduzione e impostazione del problema](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=63s)

<!-- ## [Introduction and problem setup](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=63s) -->

Supponiamo di voler imparare a guidare utilizzando l'apprendimento delle politiche (_policy/reinforcement learning, RL_) senza avere un modello della realtà (_model-free_). Nel _RL_, addestriamo i modelli permettendogli di compiere degli errori ed imparare da essi. Questo però non è il metodo migliore (per imparare a guidare) dato che un errore potrebbero portarci in paradiso/all'inferno, e quindi l'apprendimento diventa inutile.

Consideriamo un modo più "umano" di imparare a guidare una macchina. Consideriamo un esempio in cui bisogna cambiare corsia. Presupponiamo che la macchina si muova a 100 km/h, che sono più o meno 30 miglia/s, se guardiamo 30 miglia in avanti, è come guardare nel futuro di 1 secondo.

<!-- Let us say we want to learn how to drive in a model-free Reinforcement learning way. We train models in RL by letting the model make mistakes and learn from them. But this is not the best way since mistakes might take us to heaven/hell where there is no point in learning.

So, let us talk about a more 'human' way to learn how to drive a car. Consider an example of lane switching. Assuming the car is moving at 100 km/h, which roughly translates to 30 m/s, if we look 30 m in front of us, we are roughly looking 1 s into the future. -->

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure1.png" style="zoom: 20%; background-color:#DCDCDC;" /><br>
<b>Fig. 1:</b> Guardando il futuro durante la guida
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure1.png" style="zoom: 20%; background-color:#DCDCDC;" /><br>
<b>Figure 1:</b> Looking into future while driving
</center> -->

Se dovessimo girare la macchina, dovremmo prendere una decisione basata sul futuro imminente. Per girare fra un paio di metri, compiamo un'azione adesso, che in questo contesto significa girare il volante. Prendere una decisione non dipende solo dall'autista ma anche dagli altri veicoli circondanti la macchina nel traffico. Dato che non sappiamo in maniera deterministica come si muoveranno i veicoli che abbiamo attorno, è molto difficile tenere conto di tutte le possibilità.

Cerchiamo di capire meglio quello che succede in questo scenario. Abbiamo un agente (qui rappresentato da un cervello) che prende l'input  $s_t$ (la posizione, velocità e le immagini del contesto) e produce un'azione $a_t$ (il controllo del volante, l'accelerazione, e i freni). Compiendo l'azione sull'ambiente ci troviamo in un nuovo stato, che ha un costo $c_t$.

<!-- If we were turning, we need to make a decision based on the near future. To take a turn in a few meters, we take an action now, which in this context is turning the steering wheel. Making a decision not only depends on your driving but also the surrounding vehicles in the traffic. Since everyone around us is not so deterministic, it is very hard to take every possibility into account.

Let us now break down what is happening in this scenario. We have an agent(represented here by a brain) that takes the input $s_t$ (position, velocity and context images) and produces an action $a_t$(steering control, acceleration and braking).  The environment takes us to a new state and returns a cost $c_t$. -->

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure2.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<b>Fig. 2:</b> Illustrazione di un agente nella realtà
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure2.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<b>Figure 2:</b> Illustration of an agent in the real world
</center> -->

Questo è come una rete semplice in cui possiamo prendere azioni secondo lo stato specifico in cui ci troviamo, e poi la realtà ci mostra il prossimo stato e le consequenze delle nostre azioni. Questo è un sistema "privo di modelli" (_model-free_) perché con ciascun'azione interagiamo con la realtà. Ma possiamo addestrare un agente senza dover interagire con la realtà?

Si, possiamo! Scopriamo come farlo nella sezione "Apprendimento di un modello della realtà".

<!-- This is like a simple network where you take actions given a specific state and the world gives us the next state and the next consequence. This is model-free because with every action we are interacting with the real world. But can we train an agent without actually interacting with the real world?

Yes, we can! Let us find out in the "Learning world model" section. -->

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure3.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<b>Fig. 3:</b> Illustrazione di un agente nel modello della realtà
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure3.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<b>Figure 3:</b> Illustration of an agent in the world model
</center> -->

## Dati

<!-- ## Data set -->

Prima di discutere di come apprendere il modello della realtà, esploriamo i dati che abbiamo. Abbiamo 7 telecamere montate sopra ad un palazzo di 30 piani che si affaccia sull'autostrada interstatale. Aggiustiamo le telecamere per ottenere una visuale dall'alto verso il basso _top-down_ e poi estraiamo le "scatole" che definiscono il confine (_bounding box_) di ciascun veicolo. <!-- come tradurre bounding box? --> Nel periodo $t$, possiamo determinare $p_t$ che rappresenta la posizione della macchina, $v_t$ che ne rappresenta la velocità, e $i_t$ che ne rappresenta lo stato corrente del traffico attorno al veicolo.

Dato che conosciamo le kinemtiche della guida, possiamo invertirle per capire quali sono le azioni che l'autista sta prenendo. Ad esempio, se la macchina si muove in maniera uniforme e rettilinea, sappiamo che l'accelerazione è zero (cioé che non è stata presa un'azione).

<!-- Before discussing how to learn the world model, let us explore the dataset we have. We have 7 cameras mounted on top of a 30 story building facing the interstate. We adjust the cameras to get the top-down view and then extract bounding boxes for each vehicle. At a time $t$, we can determine $p_t$ representing the position, $v_t$
representing the velocity and $i_t$ representing the current traffic state around the vehicle.

Since we know the kinematics of the driving, we can invert them to figure out what are the actions that the driver is taking. For example, if the car is moving in a rectilinear uniform motion, we know that the acceleration is zero(meaning there is no action) -->

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure4.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Fig. 4:</b> Rappresentazione artificiale di un singolo frame
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure4.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 4:</b> Machine representation of a single frame
</center> -->

L'illustrazione in blu è il _feed_ e l'illustrazione in verde è la cosiddetta rappresentazione artificiale (_machine representation_). Per capire meglio, abbiamo isolato un paio di veicoli (demarcati nell'illustrazione di sopra). Le visuali che vediamo di sotto sono le _bounding box_ dei campi visivi di questi veicoli.

<!-- The illustration in blue is the feed and the illustration in green is what we can call the machine representation. To understand this better, we have isolated a few vehicles(marked in the illustration). The views we see below are the bounding boxes of the field-of-view of these vehicles. -->


## Costi

<!-- ## Cost -->

In questo caso abbiamo due tipi di costi diversi: il costo della corsia e il costo della prossimità. Il costo della corsia ci dice quanto siamo ben posizionati all'interno della corsia e il costo della prossimità ci dice quanto siamo vicini alle altre macchine.

<!-- There are two different types of costs here: lane cost and proximity cost. Lane cost tells us how well we are within a lane and proximity cost tells us how close we are to the other cars. -->

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure5.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Fig. 5:</b> Costo della corsia
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure5.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 5:</b> Lane cost
</center> -->

Nella figura di sopra, le linee tratteggiate rappresentano il confine reale delle corsie, mentre le linee rosse indicano il costo della corsia data la posizione attuale della macchina. Le linee rosse si spostano con gli spostamenti della macchina. Il costo è dato dall'altezza dell'intersezione fra le linee rosse e la potenziale curva (in azzurro). Se la macchina è posizionata al centro della corsia, entrambi le linee rosse rientreranno nel confine della corsia, risultando in un costo uguale a zero. Se, invece, la macchina si allontana dal centro della corsia, le linee rosse si sposteranno con essa, risultando in un costo maggiore di zero.

<!-- In the above figure, dotted lines represent actual lanes and red lines help us figure out the lane cost given the current position of our car.  Red lines move as our car moves. The height of the intersection of the red lines with the potential curve (in cyan) gives us the cost. If the car is in the centre of the lane, both the red lines overlap with the actual lanes resulting in zero cost. On the other hand, as the car moves away from the centre, the red lines also move to result in a non-zero cost. -->

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure6.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 6:</b> Proximity cost
</center> -->

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure6.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Fig. 6:</b> Costo della prossimità
</center>

Il costo della prossimità ha a sua volta due componenti ($\mathcal{L}_x$ e $\mathcal{L}_y$). $\mathcal{L}_y$ è simile al costo della corsia e $\mathcal{L}_x$ dipende dalla velocità della nostra macchina. La curva arancione nella figura 6 rappresenta la distanza di sicurezza. Con l'aumentare della velocità della macchina, la curva arancione diventa più ampia. Quindi più velocemente cammina la macchina, più bisognerà guardarsi avanti e indietro. $\mathcal{L}_x$ rappresenta l'altezza dell'intersezione fra una macchina e la curva arancione.

Moltiplicando queste due componenti otteniamo il costo di prossimità.

<!-- Proximity cost has two components ($\mathcal{L}_x$ and $\mathcal{L}_y$). $\mathcal{L}_y$ is similar to the lane cost and $\mathcal{L}_x$ depends on the speed of our car. The Orange curve in Figure 6 tells us about the safety distance. As the speed of the car increases, the orange curve widens. So faster the car is travelling, the more you will need to look ahead and behind. The height of the intersection of a car with the orange curve determines $\mathcal{L}_x$.

The product of these two components gives us the proximity cost. -->


## Apprendimento di un modello della realtà

<!-- ## Learning world model -->

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure7.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<b>Fig. 7:</b> Illustrazione del modello della realtà
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure7.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<b>Figure 7:</b> Illustration of the world model
</center> -->

Il modello della realtà prende come input un'azione $a_t$ (movimento del volante, freno, e accelerazione) e $s_{1:t}$ (la sequenza di stati, dove ogni stato viene rappresentato dalla posizione, la velocità, e le immagini del contesto in un determinato momento) e fa una previsione sul prossimo stato $\hat s_{t+1}$. Poi, osserviamo ciò che avviene realmente ($s_{t+1}$). Ottimizziamo l'errore quadratico medio fra ciò che il modello ha previsto ($\hat s_{t+1}$) ed il _target_, ovvero ciò che è accaduto realmente ($s_{t+1}$) ed addestriamo così il modello.

<!-- The world model is fed with an action $a_t$ (steering, brake, and acceleration) and $s_{1:t}$ (sequence of states where each state is represented by position, velocity and context images at that time) and it predicts the next state $\hat s_{t+1}$.  On the other hand, we have the real world which tells us what actually happened ($s_{t+1}$). We optimize MSE (Mean Squared Error) between prediction ($\hat s_{t+1}$) and target ($s_{t+1}$) to train our model. -->


## Previsore-decodificatore deterministico

<!-- ## Deterministic predictor-decoder -->

Un modo per addestrare il modello della realtà è quello di usare un modello "previsore-decodificatore" <!-- ? --> (_predictor-decoder model_), che adesso spiegheremo.

<!-- One way to train our world model is by using a predictor-decoder model explained below. -->

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure8.png" style="zoom: 20%; background-color:#DCDCDC;" /><br>
<b>Fig. 8:</b> Previsore-decodificatore deterministico per apprendere il modello della realtà
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure8.png" style="zoom: 20%; background-color:#DCDCDC;" /><br>
<b>Figure 8:</b> Deterministic predictor-decoder to learn the world model
</center> -->

Come illustrato nella Fig. 8, abbiamo una sequenza di stati ($s_{1:t}$) e azioni ($a_t$) che vengono date come input al "previsore" (_predictor module_). Il previsore genera come output una rappresentazione nascosta del futuro, che viene data come input al decodificatore. Questo decodifica la rappresentazione nascosta del futuro e genera una previsione ($\hat s_{t+1}$). Poi addestriamo il modello minimizzando l'errore quadratico medio fra la previsione $\hat s_{t+1}$ e il _target_ $s_{t+1}$.

<!-- As depicted in Figure 8, we have a sequence of states($s_{1:t}$) and action ($a_t$) which are provided to the predictor module. The predictor outputs a hidden representation of the future which is passed on to the decoder. The decoder is decoding the hidden representation of the future and outputs a prediction($\hat s_{t+1}$). We then train our model by minimising MSE between prediction $\hat s_{t+1}$ and target $s_{t+1}$. -->

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure9.png" style="zoom: 20%; background-color:#DCDCDC;" /><br>
<b>Fig. 9:</b> Futuro reale vs. future deterministco
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure9.png" style="zoom: 20%; background-color:#DCDCDC;" /><br>
<b>Figure 9:</b> Actual future vs. Deterministic future
</center> -->

Purtroppo, questo non funziona!

Possiamo vedere che l'output deterministico non è molto chiaro, perché il modello prende la media su tutte le possibilità future. Questo è paragonabile alla multi-modalità del futuro di cui abbiamo parlato qualche lezione fa, in cui abbiamo immaginato di far cadere una penna a caso dal centro. Prendendo la media su tutte le possibili posizioni in cui la penna potrebbe cadere finiremo per concludere che la penna non si è spostata affatto, il che sarebbe un errore.

Possiamo risolvere questo problema introducendo delle variabili latenti nel nostro modello.

<!-- Unfortunately, this does not work!

We see that the deterministic output becomes very hazy. This is because our model is averaging over all the future possibilities. This can be compared to the future's multimodality discussed a couple of classes earlier, where a pen placed at origin is dropped randomly. If we take the average across all locations, it gives us a belief that pen never moved which is incorrect.

We can address this problem by introducing latent variables in our model. -->


## [Rete di previsione variazionale](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=1779s)

<!-- ## [Variational predictive network](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=1779s) -->

Al fine di risolvere il problema che abbiamo discusso nella sezione precedente, aggiungiamo una variabile latente a bassa dimensionalità $z_t$ alla rete originale, che passa tramite un _module_ di "espansione" $f_{exp}$ che fa corrispondere le dimensionalità.

<!-- To solve the problem stated in the previous section, we add a low dimensional latent variable $z_t$ to the original network which goes through an expansion module $f_{exp}$ to match the dimensionality. -->

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure10.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Fig. 10:</b> Rete di previsione variazionale - addestramento
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure10.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 10:</b> Variational predictive network - train
</center> -->


La $z_t$ viene scelta in modo da minimizzare l'errore quadratico medio per una previsione specifica. Regolando la variabile latente, possiamo comunque raggiungere un errore quadratico medio di zero tramite la discesa del gradiente sullo spazio latente. Fare questo però è molto costoso. Invece, possiamo predire la variabile latente utilizzando un codificatore. Il codificatore utilizza lo stato futuro per generare una distribuzione con una media e una varianza dalla quale possiamo campionare $z_t$.

Durante la fase di addestramento, possiamo vedere cosa accade guardando il futuro e raccogliendo informazioni che utilizzeremo per predire la variabile latente. Tuttavia, non abbiamo accesso al futuro durante la fase di _test_. Possiamo risolvere questo problema costringendo il codificatore a generare una distribuzione a posteriori che sia il più possibilmente simile alla distribuzione a priori, ottimizzando la divergenza di Kullback-Leibler (_KL_).

<!-- The $z_t$ is chosen such that the MSE is minimized for a specific prediction. By tuning the latent variable, you can still get MSE to zero by doing gradient descent into latent space. But this is very expensive. So, we can actually predict that latent variable using an encoder. Encoder takes the future state to give us a distribution with a mean and variance from which we can sample $z_t$.

During training, we can find out what is happening by looking into the future and getting information from it and use that information to predict the latent variable. However, we don't have access to the future during testing time. We fix this by enforcing the encoder to give us a posterior distribution as close as possible to the prior by optimizing KL divergence. -->

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure11.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Fig. 11:</b> Rete di previsione variazionale - addestramento (con distribuzione a priori)
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure11.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 11:</b> Variational predictive network - train (with prior distribution)
</center> -->

Ora, vediamo la fase d'inferenza - come facciamo a guidare?

<!-- Now, let us look at the inference - How do we drive? -->

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure12.png" style="zoom: 32%; background-color:#DCDCDC;" /><br>
<b>Fig. 12:</b> Rete di previsione variazionale - inferenza
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure12.png" style="zoom: 32%; background-color:#DCDCDC;" /><br>
<b>Figure 12:</b> Variational predictive network - inference
</center> -->

Campioniamo la variabile latente a bassa dimensionalità $z_t$ dalla distribuzione a priori costringendo il codificatore a renderla simile a questa distribuzione. Dopo aver fatto la previsione $\hat s_{t+1}$, la rimettiamo (tramite un processo auto-regressivo) ed otteniamo la prossima previsione $\hat s_{t+2}$, e continuiamo ad alimentare la rete così.

<!-- We sample the low-dimensional latent variable $z_t$ from the prior by enforcing the encoder to shoot it towards this distribution. After getting the prediction $\hat s_{t+1}$, we put it back (in an auto-regressive step) and get the next prediction $\hat s_{t+2}$ and keep feeding the network this way. -->

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure13.png" style="zoom: 22%; background-color:#DCDCDC;" /><br>
<b>Fig. 13:</b> Futuro reale vs. futuro deterministco
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure13.png" style="zoom: 22%; background-color:#DCDCDC;" /><br>
<b>Figure 13:</b> Actual future vs Deterministic
</center> -->

Sul lato destro della figura di sopra, vediamo quattro diversi campionamenti dalla distribuzione normale. Cominciamo con lo stesso stato iniziale e fornire 200 valori diversi della variabile latente.

<!-- On the right hand side in the above figure, we can see four different draws from the normal distribution. We start with same initial state and provide different 200 values to the latent variable. -->

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure14.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<b>Fig. 14:</b> Futuro reale vs. futuro deterministico - dopo un movimento
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure14.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<b>Figure 14:</b> Actual future vs Deterministic - after movement
</center> -->

Possiamo notare che se forniamo diverse variabili latenti generiamo diverse sequenze di stati con comportamenti diversi. Questo significa che abbiamo una rete che genera il futuro. Piuttosto affascinante!

Cos'altro bisogna fare?

Ora possiamo utilizzare questa grande quantità di dati per addestrare la nostra politica ottimizzando i costi di corsia e di prossimità di cui abbiamo parlato precedentemente.

Questi molteplici futuri provengono dalla sequenza di variabili latenti che diamo come input alla rete. L'ascesa del gradiente - ovvero, provare ad aumentare il costo di prossimità nello spazio latente - ci permette di ottenere la sequenza di varibili latenti secondo le quali ci potremmo scontrare con le altre macchine.

<!-- We can notice that providing different latent variables generates different sequences of states with different behaviours. Which means we have a network that generates the future. Quite fascinating!

What's next?

We can now use this huge amount of data to train our policy by optimizing the lane and proximity costs described above.

These multiple futures come from the sequence of latent variables that you feed to the network. If you perform gradient ascent - in the latent space, you try to increase the proximity cost so you get the sequence of latent variables such that the other cars are going to be driving into you. -->

## Insensibilità alle azioni e _dropout_ latente

<!-- ## Action insensitivity & latent dropout -->

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure15.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Fig. 15:</b> Problemi - Insensibilità alle azioni
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure15.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 15:</b> Issues - Action Insensitivity
</center> -->

Dato che abbiamo accesso al futuro, se giriamo verso sinistra anche lievemente, l'ambiente circondante si sposterà alla nostra destra e questo contribuirà enormemente all'errore quadratico medio (_mean squared error, MSE_). La perdita _MSE_ viene minimizzata quando la variabile latente riesce ad "informare" la base della rete che tutto verrà spostato sulla nostra destra - che non è ciò che vorremmo! Possiamo capire quando tutto girerà verso destra perché questa è un'operazione deterministica.

La freccia grossa nella Fig. 15 rappresenta una fuoriuscita (_leak_) d'informazione. Quindi la rete non è più sensibile all'azione corrente che viene data al previsore.

<!-- Given that you actually have access to the future, if you turn to the left even slightly, everything is going to be turning to the right and that will contribute in a huge way to the MSE. The MSE loss can be minimized if the latent variable can inform the bottom part of the network that everything is going to turn to the right - which is not what we want! We can tell when everything turns to the right since that is a deterministic task.

The big arrow in Figure 15 signifies a leak of information and therefore it was not any more sensitive to the current action being provided to the predictor. -->

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure16.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Fig. 16:</b> Problema - Insensibilità alle azioni
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure16.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 16:</b> Issue - Action Insensitivity
</center> -->

Nella Fig. 16, nel diagramma più a destra abbiamo la vera sequenza di variabili latenti (le variabili latenti che ci permettono di ottenere il futuro più preciso) e non abbiamo la vera sequenza di azioni prese dall'esperto. Le due figure alla sinistra di questa mostrano un campionamento di una variabile latente e la vera sequenza di azioni, quindi ci aspettiamo di vedere un cambiamento di direzione. La figura più a sinistra ha la vera sequenza di variabili latenti ma con azioni arbitrarie. Si viede chiaramente che il cambio di direzione è dovuto più alla variabile latente che all'azione, che codificano la rotazione e l'azione (campionati da altri episodi).

Come risolvere questo problema?

<!-- In figure 16, in the rightmost diagram we have the real sequence of latent variables (the latent variables that allow us to get the most precise future) and we have the real sequence of actions taken by the expert. The two figures to the left of this one have randomly sampled latent variables but the real sequence of actions so we expect to see the steering. The last one on the left-hand side has the real sequence of latent variable but arbitrary actions and we can clearly see that the turning came mostly from the latent rather than the action, which encodes the rotation and the action (which are sampled from other episodes).

How to fix this problem? -->

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure17.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Fig. 17:</b> Soluzione - eliminare la variabile latente
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure17.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 17:</b> Fix - Latent Dropout
</center> -->

Il problema non è necessariamente un problema di fuoriuscita di memoria ma di fuoriuscita d'informazione. Lo risolviamo eliminando la variabile latente, campionandola invece dalla distribuzione a priori. Non abbiamo bisogno dell'output dell'encoder ($f_{enc}$) ma scegliamo dalla distribuzione a priori. Così facendo, non è più possibile codificare la rotazione nella variabile latente. Quindi, l'informazione viene codificata nell'azione piuttosto che nella variabile latente.

<!-- The problem is not a memory leak but an information leak. We fix this problem by simply dropping out this latent and sampling it from the prior distribution at random. We don't always rely on the output of the encoder ($f_{enc}$) but pick from the prior. In this way, you cannot encode the rotation in the latent variable any more. In this way, information gets encoded in the action rather than the latent variable. -->

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure18.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Fig. 18:</b> Performance eliminando la variabile latente
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure18.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 18:</b> Performance with latent dropout
</center> -->

Nelle ultime due immagini a destra, vediamo due diversi insiemi di variabili latenti, che hanno una vera sequenza di azioni e queste reti sono state addestrate con il "trucco" dell'eliminazione della variabile latente. Ora vediamo che la rotazione viene codificata nell'azione e non più dalla variabile latente.

<!-- In the last two images on the right-hand side, we see two different sets of latent variables having a real sequence of actions and these networks have been trained with the latent dropout trick. We can now see that the rotation is now encoded by the action and no longer by the latent variables. -->


## [Addestrare l'agente](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=3232s)

<!-- ## [Training the agent](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=3232s) -->

Nelle sezioni precedenti, abbiamo visto come ottenere un modello della realtà simulando le esperienze reali.  In questa sezione, utilizzeremo questo modello della realtà per addestrare il nostro agente. Il nostro obiettivo è quello di imparare la politica per prendere un'azione data ka storia degli stati precedenti. Dato uno stato $s_t$ (velocità, posizione & immagini di contesto), l'agente prenderà un'azione $a_t$ (accelerazione, freni & movimento del volante), il modello della realtà genererà un nuovo stato ed un costo ad esso associato $(s_t, a_t)$, che è una combinazione del costo di prossimità (_proximity_) ed il costo di corsia (_lane_).

$$
c_\text{compito} = c_\text{prossimità} + \lambda_l c_\text{corsia}
$$

Come discusso nelle sezioni precedenti, per evitare previsioni sfocate, dobbiamo campionare la variabile latenti $z_t$ dall'encoder dello stato futuro $s_{t+1}$ oppure dalla distribuzione a priori $P(z)$. Il modello della realtà prende come input gli stati precedenti $s_{1:t}$, le azioni prese dal nostro agente, e le variabile latente $z_t$ per predire lo stato successivo $\hat s_{t+1}$ and the cost. Questo costituisce un modulo che viene replicato diverse volte (Fig. 19) per darci una previsione finale e una perdita su cui ottimizzare.

<!-- In the previous sections, we saw how we can obtain a world model by simulating real world experiences.  In this section, we will use this world model to train our agent.  Our goal is to learn the policy to take an action given the history of previous states.  Given a state $s_t$ (velocity, position & context images), the agent takes an action $a_t$ (acceleration, brake & steering), the world model outputs a next state and cost associated with that $(s_t, a_t)$ pair which is a combination of proximity cost and lane cost. -->

<!-- $$
c_\text{task} = c_\text{proximity} + \lambda_l c_\text{lane}
$$ -->

<!-- As discussed in the previous section, to avoid hazy predictions, we need to sample latent variable $z_t$ from the encoder module of the future state $s_{t+1}$ or from prior distribution $P(z)$.  The world model gets previous states $s_{1:t}$, action taken by our agent and latent variable $z_t$ to predict the next state $\hat s_{t+1}$ and the cost.  This constitutes one module that is replicated multiple times (Figure 19) to give us final prediction and loss to optimize. -->

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure19.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Fig. 19:</b> Architettura del modello "specifico al compito"
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure19.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 19:</b> Task specific model architecture
</center> -->

Adesso che abbiamo il modello pronto, vediamo come funziona !!

<!-- So, we have our model ready.  Let’s see how it looks !! -->

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure20.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Fig. 20:</b> Politica appredsa: l'agente si scontra oppure si allontana dalla strada
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure20.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 20:</b> Learned policy: Agent either collides or moves away from the road
</center> -->

Purtroppo, non funziona. Le politiche addestrate in questo modo non sono utili in quanto apprendono a predire tutto nero dato che questo risulta in un costo uguale a zero.

Come possiamo risolvere questo problema? Possiamo provare ad imitare altri veicoli per migliorare le nostre previsioni?

<!-- Unfortunately, this does not work.  Policy trained this way is not useful as it learns to predict all black since it results in zero cost.

How can we address this issue? Can we try imitating other vehicles to improve our predictions? -->

## Imitando l'esperto

<!-- ## Imitating the expert -->

Come facciamo ad imitare gli esperti qui? Vogliamo che la previsione del nostro modello dopo aver preso una particolare azione da uno stato sia il più vicino possibile al futuro reale. Questo si comporta come un agente esperto che regolarizza la nostra fase di addestramento. La nostra funzione di costo ora include sia il costo per questo compito (_task_) specifico (ovvero i costi di prossimità e corsia) ma anche questo termine del "regolarizzatore esperto" (_expert regulariser_). Ora, dato che calcoliamo anche la perdita rispetto al futuro reale, dobbiamo rimuovere le variabili latenti dal modello perché questo ci da una previsione specifica, ma questo contesto funziona meglio se utilizziamo la previsione media.

$$
\mathcal{L} = c_\text{compito} + \lambda u_\text{esperto}
$$


<!-- How do we imitate the experts here? We want the prediction of our model after taking a particular action from a state to be as close as possible to the actual future. This acts as an expert regulariser for our training. Our cost function now includes both the task specific cost(proximity cost and lane cost) and this expert regulariser term. Now as we are also calculating the loss with respect to the actual future, we have to remove the latent variable from the model because the latent variable gives us a specific prediction, but this setting works better if we just work with the average prediction. -->

<!-- $$
\mathcal{L} = c_\text{task} + \lambda u_\text{expert}
$$ -->

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure21.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Fig. 21:</b> Architettura del modello basato sull'imitazione degli esperti
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure21.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 21:</b>  Expert regularization based model architecture
</center> -->

Quindi quanto funziona bene questo modello?

<!-- So how does this model perform? -->

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure22.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Fig. 22:</b> Politica appresa sulla base dell'imitazione degli esperti
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure22.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 22:</b> Learned policy by imitating the experts
</center> -->

Come vediamo nella figura di sopra, il modello funziona incredibilmente bene ed impara a fare previsioni molto buone. Questo è un modello basato sull'apprendimento tramite l'imitazione, abbiamo provato a modellare in modo che l'agente provi ad imitare gli altri.

Ma possiamo fare di meglio?
Abbiamo addestrato l'autoencoder variazionale per poi rimuoverlo alla fine?

Fatto sta che possiamo migliorare ancora di più se cerchiamo di minimizzare l'incertezza delle previsioni _forward_ del modello.

<!-- As we can see in the above figure, the model actually does incredibly well and learns to make very good predictions. This was model based imitation learning, we tried to model our agent to try to imitate others.

But can we do better?
Did we just train the Variational Autoencoder to remove it in the end?

It turns out we can still improve if we look to minimize the uncertainty of the forward model predictions. -->


## Minimizzare l'incertezza del modello

<!-- ## Minimizing the Forward Model Uncertainty -->

Cosa s'intende per minimizzare l'incertezza (_uncertainty_) delle previsioni _forward_ del modello, e come lo si fa? Prima di rispondere a questo domdada, ripassiamo un concetto che abbiamo visto nella pratica della terza settimana.

Se addestriamo più di un modello sugli stessi dati, tutti i modelli devono concordare sui punti nella regione di addestramento (mostrati in rosso), che risulta in varianza zero nella regione di addestramento. Spostandoci più lontano dalla regione di addestramento, le traiettorie della perdita di questi modelli cominciano a divergere e la varianza aumenta. Questo viene illustrato nella figura 23. Dato che la varianza è differenziabile, possiamo utilizzare la discesa del gradiente sulla varianza per minimizzarla.

<!-- What do we mean by minimizing forward model uncertainty and how would we do it? Before we answer that, let’s recap something we saw in the third week’s practicum.

If we train multiple models on the same data, all those models agree on the points in the training region (shown in red) resulting in zero variance in the training region. But as we move further away from the training region, the trajectories of loss functions of these models start diverging and variance increases. This is depicted in the figure 23.  But as the variance is differentiable, we can run gradient descent over the variance in order to minimize it. -->


<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure23.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>Fig. 23:</b> Visualizzazione del costo attraverso l'intero spazio d'input
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure23.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>Figure 23:</b> Cost visualization across the entire input space
</center> -->

Tornando alla nostra discussione, osserviamo che imparare una politica utilizzando solo dati osservati è difficile perché la distribuzione di stati che produce al momento di esecuzione può essere diverso da quello che osserviamo durante la fase di addestramento. Il modello della realtà può fare previsioni arbitrarie che stanno al di fuori degli esempi su cui è stato addestrato, che potrebbe essere associato (erroneamente) ad un costo basso. La rete a politiche potrebbe sfruttare questi errori nel modello dinamico e produrre azioni che portano a stati erroneamente ottimistici.

Per evitare questo problema, proponiamo un costo addizionale, che misura l'incertezza sul modello dinamico rispetto alle proprie previsioni. Questo può essere calcolato dando lo stesso input e azione a tante diverse "maschere" di _dropout_, e calcolando poi la varianza sui diversi outputs. Questo incoraggia alla rete di politiche di produrre solo azioni di cui il modello _forward_ è "convinto".

<!-- Coming back to our discussion, we observe that learning a policy using only observational data is challenging because the distribution of states it produces at execution time may differ from what was  observed during the training phase. The world model may make arbitrary predictions outside the domain it was trained on, which may wrongly result in low cost. The policy network may then exploit these errors in the dynamics model and produce actions which lead to wrongly optimistic states.

To address this, we propose an additional cost which measures the uncertainty of the dynamics model about its own predictions. This can be calculated by passing the same input and action through several different dropout masks, and computing the variance across the different outputs.  This encourages the policy network to only produce actions for which the forward model is confident. -->

$$
\mathcal{L} = c_\text{compito} + \lambda c_\text{incertezza}
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure24.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Fig. 24:</b> Architettura del modello basato sul regolarizzatore dell'incertezza
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure24.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 24:</b> Uncertainty regulariser based model architecture
</center> -->

Quindi, il regolarizzatore dell'incertezza ci aiuta ad apprendere una politica migliore?

Sì, la politica appresa tramite questo metodo è meglio di quelle dei modelli precedenti.


<!-- So, does uncertainty regulariser help us in learning better policy?

Yes, it does. The policy learned this way is better than the previous models. -->

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure25.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Fig. 25:</b> Politica appresa sulla base del regolarizzatore dell'incertezza
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure25.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 25:</b> Learned policy based on uncertainty regulariser
</center> -->

## Valutazione

<!-- ## Evaluation -->

La Fig. 26 dimostra quanto bene ha imparato il nostro agente a guidare nel traffico. La macchina gialla è l'autista originale,la macchina blu è l'agente appreso, e tutte le macchine verdi vengono "occluse" (non posso essere controllate).

<!-- Figure 26 shows how well our agent learned to drive in dense traffic.  Yellow car is the original driver, blue car is our learned agent and all green cars are blind to us (cannot be controlled). -->

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure26.gif" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Fig. 26:</b> Performance del modello con regolarizzatore dell'incertezza
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-3/figure26.gif" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 26:</b> Performance of model with uncertainty regulariser
</center> -->
