---
lang: it
lang-ref: ch.11-2
lecturer: Yann LeCun
title: Funzioni di perdita (cont.) e funzioni di perdita per i modelli ad energia
authors: Charles Brillo-Sonnino, Shizhan Gong, Natalie Frank, Yunan Hu
date: 13 Apr 2020
translation-date: 12 Sep 2020
translator: Francesca Guiso
---

### [Perdita ad entropia incrociata binaria - `nn.BCELoss()`](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=3207s)

<!-- ### [Binary Cross Entropy (BCE) Loss - `nn.BCELoss()`](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=3207s) -->

$$
\ell(x,y) = L = \{l_1,...,l_N\}^T, \qquad l_n = -w_n[y_n\log x_n+(1-y_n)\log(1-x_n)]
$$

Questa perdita è un esempio speciale della funzione di entropia incrociata binaria (_binary cross entropy, BCE_), che ci permette di semplificare la funzione quando si hanno solo due categorie. Questa viene utilizzata per misurare l'errore di una ricostruzione, come ad esempio per un _autoencoder_. La formula presuppone che $x$ e $y$ siano probabilità, e quindi che prendano valori fra 0 ed 1.

<!-- $$
\ell(x,y) = L = \{l_1,...,l_N\}^T, \qquad l_n = -w_n[y_n\log x_n+(1-y_n)\log(1-x_n)]
$$

This loss is a special case of cross entropy for when you have only two classes so it can be reduced to a simpler function. This is used for measuring the error of a reconstruction in, for example, an auto-encoder. This formula assume $x$ and $y$ are probabilities, so they are strictly between 0 and 1. -->


### Perdita di divergenza Kullback-Leibler - `nn.KLDivLoss()`

<!-- ### Kullback-Leibler Divergence Loss - `nn.KLDivLoss()` -->

$$
\ell(x,y) = L = \{l_1,...,l_N\}^T, \qquad l_n = y_n(\log y_n-x_n)
$$

Questa è una semplice funzione di perdita per quando la _target_ segue una distribuzione _one-hot_ (*i.e.* $y$ è una variabile categorica). Come nella funzione di perdita _BCE_, presupponiamo che i valori di $x$ e $y$ rappresentino probabilità. Questo ha lo svantaggio che, se la funzione non viene affiancata ad una funzione di _softmax_ o _log-softmax_ potrebbero sorgere problematiche di stabilità numerica.

<!-- $$
\ell(x,y) = L = \{l_1,...,l_N\}^T, \qquad l_n = y_n(\log y_n-x_n)
$$

This is simple loss function for when your target is a one-hot distribution (*i.e.* $y$ is a category). Again it assumes $x$ and $y$ are probabilities. It has the disadvantage that it is not merged with a softmax or log-softmax so it may have numerical stability issues. -->


### Perdita _BCE_ con Logit - `nn.BCEWithLogitsLoss()`

<!-- ### BCE Loss with Logits - `nn.BCEWithLogitsLoss()` -->

$$
\ell(x,y) = L = \{l_1,...,l_N\}^T, \qquad l_n = -w_n[y_n\log \sigma(x_n)+(1-y_n)\log(1-\sigma(x_n))]
$$

Questa versione di perdita ad entropia incrociata binaria prende come input dei punteggi ai quali non è stata applicata la funzione di _softmax_ (e quindi non presuppone che il valore dell'input $x$ sia compreso fra 0 ed 1). Questi vengono passati ad una funzione sigmoide, che garantisce che i valori di output siano compresi fra 0 e 1. Combinando le funzioni di perdita in questo modo aumenta la probabilità che la perdita sia stabile numericamente.

<!-- $$
\ell(x,y) = L = \{l_1,...,l_N\}^T, \qquad l_n = -w_n[y_n\log \sigma(x_n)+(1-y_n)\log(1-\sigma(x_n))]
$$

This version of binary cross entropy loss takes scores that haven't gone though softmax so it does not assume x is between 0 and 1. It is then passed though a sigmoid to ensure it is in that range. The loss function is more likely to be numerically stable when combined like this. -->


### Perdita a classifica di margine - `nn.MarginRankingLoss()`

<!-- ### Margin Ranking Loss - `nn.MarginRankingLoss()` -->

$$
L(x,y) = \max(0, -y*(x_1-x_2)+\text{margine})
$$

Le perdite a margine costituiscono una categoria importante fra le funzioni di perdita. Se si hanno due input, questa funzione di perdita fa si che un input sia più grande dell'altro di almeno un margine. In questo caso $y$ è una variabile binaria $\in \{ -1, 1\}$. Immaginiamo che i due input siano i punteggi di due categorie: vogliamo che il punteggio per la categoria corretta sia maggiore del punteggio per la categoria sbagliata di almeno un margine. Come nella funzione di perdita _hinge_, se $y*(x_1-x_2)$ è maggiore del margine, il costo è uguale a 0. Se è minore, il costo aumenta linearmente. Se dovessimo usare questa funzione di perdita per la classificazione, dovremmo avere $x_1$ come punteggio della categoria corretta e $x_2$ come punteggio maggiore fra le categorie sbagliate nel _mini-batch_. Se utilizzata in un modello ad energia, (di cui discuteremo successivamente), questa funzione di perdita "spingerà verso il basso" (assegnando cosí un valore di energia minore) la risposta corretta $x_1$ e "spingerà verso l'alto" (assegnando cosí un valore di energia maggiore) la risposta sbagliata $x_2$.

<!-- $$
L(x,y) = \max(0, -y*(x_1-x_2)+\text{margin})
$$

Margin losses are an important category of losses. If you have two inputs, this loss function says you want one input to be larger than the other one by at least a margin. In this case $y$ is a binary variable $\in \{ -1, 1\}$. Imagine the two inputs are scores of two categories. You want the score for the correct category larger than the score for the incorrect categories by at least some margin.  Like hinge loss, if $y*(x_1-x_2)$ is larger than margin, the cost is 0. If it is smaller, the cost increases linearly. If you were to use this for classification, you would have $x_1$ be the score of the correct answer and $x_2$ be the score of the highest scoring incorrect answer in the mini-batch. If used in energy based models (discussed later), this loss function pushes down on the correct answer $x_1$ and up on the incorrect answer $x_2$. -->

### Perdita a margini a triade - `nn.TripletMarginLoss()`

<!-- ### Triplet Margin Loss - `nn.TripletMarginLoss()` -->

$$
L(a,p,n) = \max\{d(a_i,p_i)-d(a_i,n_i)+\text{margine}, 0\}
$$

Questa perdita viene utilizzata per misurare la similitudine relativa fra esempi. Ad esempio, se passiamo due immagini della stessa categoria ad una CNN e ottieniamo due vettori, vorremmo che la distanza fra due vettori sia la minore possibile. Se invece abbiamo due immagini con categorie diverse, vorremmo che la distanza fra i due vettori sia la maggiore possibile. Questa funzione di perdita spinge verso zero la distanza fra vettori rappresentanti la stessa categoria, e spinge oltre un determinato margine la distanza fra due vettori rappresentanti categorie diverse. Tuttavia, l'unica cosa che importa è che la distanza fra le coppie "giuste" sia minore della distanza fra le coppie "sbagliate".

<!-- $$
L(a,p,n) = \max\{d(a_i,p_i)-d(a_i,n_i)+\text{margin}, 0\}
$$

This loss is used for measuring a relative similarity between samples.  For example, you put two images with the same category through a CNN and get two vectors. You want the distance between those two vectors to be as small as possible. If you put two images with different categories through a CNN, you want the distance between those vectors to be as large as possible. This loss function tries to send the first distance toward 0 and the second distance larger than some margin.  However, the only thing that matter is that the distance between the good pair is smaller than the distance between the bad pair. -->

<center>
<img src="{{site.baseurl}}/images/week11/11-2/tml.png" width="100%"/><br>
<b>Fig. 1</b>: Perdita a margini a triade
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-2/tml.png" width="100%"/><br>
<b>Fig. 1</b>: Triplet Margin Loss
</center> -->

Questa perdita venne utilizzata originariamente per addestrare un sistema di ricerca di immagini per Google. Digitando una ricerca su Google, il sistema la codifica come vettore, che poi viene paragonato ad altri vettori di immagini già identificate. Google ripesca quelle immagini i cui vettori hanno la distanza minore dal vettore di input.

<!-- This was originally used to train an image search system for Google. At that time, you would type a query into Google and it would encode that query into a vector. It would then compare that vector to a bunch of vectors from images that were previously indexed. Google would then retrieve the images that were the closest to your vector. -->


### Perdita a margine morbido - `nn.SoftMarginLoss()`

<!-- ### Soft Margin Loss - `nn.SoftMarginLoss()` -->

$$
L(x,y) = \sum_i\frac{\log(1+\exp(-y[i]*x[i]))}{x.\text{nElement()}}
$$

Questa funziona crea un criterio che ottimizza un sistema di classificazione logistica a due classi tra un tensore di input $x$ e un tensore di _target_ $y$  (contenente valori uguali a 1 o -1).

* Questa è la versione _softmax_ di una perdita a margine. Si hanno vari esempi positivi ed esempi negativi da passare tramite il _softmax_. La funzione poi prova a rendere $\text{exp}(-y[i]*x[i])$ per il valore corretto di $x[i]$ minore di qualunque altro.
* Questa funzione di perdita "ravvicina" i valori positivi di $y[i]*x[i]$ e "spinge" i valori negative ad essere lontani l'uno dall'altro. Al contrario di un margine "duro", questa funziona ha un effetto continuo sulla perdita, che diminuisce in maniera esponenziale.

<!-- $$
L(x,y) = \sum_i\frac{\log(1+\exp(-y[i]*x[i]))}{x.\text{nelement()}}
$$

Creates a criterion that optimizes a two-class classification logistic loss between input tensor $x$  and target tensor $y$  (containing 1 or -1).

* This softmax version of a margin loss. You have a bunch of positives and a bunch of negatives you want to pass through a softmax. This loss function then tries to make $\text{exp}(-y[i]*x[i])$ for the correct $x[i]$ smaller than for any other.
* This loss function wants to pull the positive values of $y[i]*x[i]$ closer together and push the negative values far apart but, as opposed to a hard margin, with some continuous, exponentially decaying effect on the loss . -->


### Perdita hinge per molteplici categorie - `nn.MultiLabelMarginLoss()`

<!-- ### Multi-Class Hinge Loss - `nn.MultiLabelMarginLoss()` -->

$$
L(x,y)=\sum_{ij}\frac{max(0,1-(x[y[j]]-x[i]))}{x.\text{dimensione}(0)}
$$

Questa funzione a margine permette a diversi input di avere un numero variabile di output. In questo caso abbiamo diverse categorie per le quali vorremmo dei punteggi alti, e prendiamo la somma della funzione di perdita _hinge_ su tutte le categorie. Per gli _EBM_, questa funzione di perdita spinge verso il basso le categorie desiderate, e spinge verso l'alto quelle non desiderate.

<!-- $$
L(x,y)=\sum_{ij}\frac{max(0,1-(x[y[j]]-x[i]))}{x.\text{size}(0)}
$$

This margin-base loss allows for different inputs to have variable amounts of targets. In this case you have several categories for which you want high scores and it sums the  hinge loss over all categories. For EBMs, this loss function pushes down on desired categories and pushes up on non-desired categories. -->

### Perdita di hinge ad immersione - `nn.HingeEmbeddingLoss()`

<!-- ### Hinge Embedding Loss - `nn.HingeEmbeddingLoss()` -->

$$
l_n =
\left\{
             \begin{array}{lr}
             x_n, &\quad y_n=1,  \\
             \max\{0,\Delta-x_n\}, &\quad y_n=-1  \\
             \end{array}
\right.
$$

La perdita di _Hinge_ ad immersione viene utilizzata per l'apprendimento semi-supervisionato (semi-supervised learning) attraverso una misura della somiglianza fra due input. Questa funziona "ravvicina" gli esempi simili e allontana gli esempi dissimili l'uno dall'altro. La variabile $y$ ci indica la direzione (ravvicinamento vs. allontanamento) del punteggio per una coppia di input. Utilizzando una perdita _hinge_, il punteggio è positivo se $y$ è uguale a 1 ed è uguale ad un margine $\Delta$ se $y$ è uguale a -1.

<!-- $$
\begin{equation}
l_n =
\left\{
             \begin{array}{lr}
             x_n, &\quad y_n=1,  \\
             \max\{0,\Delta-x_n\}, &\quad y_n=-1  \\
             \end{array}
\right.
\end{equation}
$$

Hinge embedding loss used for semi-supervised learning by measuring whether two inputs are similar or dissimilar. It pulls together things that are similar and pushes away things are dissimilar. The $y$ variable indicates whether the pair of scores need to go in a certain direction. Using a hinge loss, the score is positive if $y$ is 1 and some margin $\Delta$ if $y$ is -1. -->

### Perdita di coseno ad immersione - `nn.CosineEmbeddingLoss()`

<!-- ### Cosine Embedding Loss - `nn.CosineEmbeddingLoss()` -->

$$
l_n =
  \left\{
             \begin{array}{lr}
             1-\cos(x_1,x_2), & \quad y=1,  \\
             \max(0,\cos(x_1,x_2)-\text{margine}), & \quad y=-1
             \end{array}
   \right.
$$

Questa funzione di perdita misura la somiglianza fra due input, utilizzando la distanza del coseno di similitudine, e viene tipicamente utilizzata per apprendere immersioni non-lineari o per l'apprendimento semi-supervisionato.

* Definito in maniera alternativa, 1 meno il coseno dell'angolo fra due vettori è praticamente la distanza Euclidea normalizzata.
* Il vantaggio <!-- svantaggio? --> di questa funzione è che quando si hanno due vettori e li si vuole rendere molto distanti fra di loro, lo si può ottenere semplicemente rendendo i vettori molto lunghi. Ovviamente questo non è ottimale, perché non vogliamo aumentare la lunghezza dei vettori ma ruotarli nella direzione giusta. Per questo, si normalizzano i vettori e si calcola la distanza Euclidea fra di loro.
* Per le coppie di vettori "positive" (appartenenti alla stessa categoria), questa perdita tenta di allineare i vettori fra di loro il più possibile. Per le coppie "negative" (appartenenti a categorie diverse), la perdita rende il coseno minore di un margine, che deve avere un valore basso ma positivo.
* In uno spazio ad alta dimensionalità, abbiamo una concentrazione alta di punti <!--?--> attorno all'"equatore" della sfera. Dopo aver normalizzato i vettori, tutti i punti si trovano distribuiti sulla sfera. Desideriamo che i punti semanticamente simili siano vicini. Gli esempi dissimili, invece, dovrebbero essere ortogonali. Non vogliamo che siano in direzione opposta perché vi è un solo punto al polo opposto <!--?-->. Dato che sull'"equatore" abbiamo una grande quantità di spazio, vorremmo avere un margine dal valore basso cosí da poter sfruttare tutta l'area in questa regione.

<!-- $$
\begin{equation}
l_n =
\left\{
             \begin{array}{lr}
             1-\cos(x_1,x_2), & \quad y=1,  \\
             \max(0,\cos(x_1,x_2)-\text{margin}), & \quad y=-1
             \end{array}
\right.
\end{equation}
$$

This loss is used for measuring whether two inputs are similar or dissimilar, using the cosine distance, and is typically used for learning nonlinear embeddings or semi-supervised learning.

* Thought of another way, 1 minus the cosine of the angle between the two vectors is basically the normalised Euclidean distance.
* The advantage of this is that whenever you have two vectors and you want to make their distance as large as possible, it is very easy to make the network achieve this by make the vectors very long. Of course this is not optimal. You don't want the system to make the vectors big but rotate vectors in the right direction so you normalise the vectors and calculate the normalised Euclidean distance.
* For positive cases, this loss tries to make the vectors as aligned as possible. For negative pairs, this loss tries to make the cosine smaller than a particular margin. The margin here should be some small positive value.
* In a high dimensional space, there is a lot of area near the equator of the sphere. After normalisation, all your points are now normalised on the sphere. What you want is samples that are semantically similar to you to be close. The samples that are dissimilar should be orthogonal. You don't want them to be opposite each other because there is only one point at the opposite pole. Rather, on the equator, there is a very large amount of space so you want to make the margin some small positive value so you can take advantage of all this area. -->


### [Perdita a classificazione temporale connettivista (Temporal Classification, CTC) - `nn.CTCLoss()`](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=4103s)

Calcola la perdita fra una serie temporale continua (non segmentata) e una sequenza di _target_.
*  La perdita _CTC_ prende la somma sulle probabilità di diversi allineamenti fra la sequenza d'input e la sequenza di _target_. Questo produce un valore di perdita che è differenziabile rispetto a ciascun nodo di input.
* L'allineamnto dell'input e il target viene presunto essere "_many-to-one_" <!-- come tradurre many-to-one? -->, il che limita la lunghezza della sequenza di target così da renderla minore o uguale alla lunghezza della sequenza d'input.
* Questa funzione di perdita è utile quando l'_output_ è una sequqnza di vettori, che corrispondono a dei punteggi per ogni categoria.

<!-- ### [Connectionist Temporal Classification (CTC) Loss - `nn.CTCLoss()`](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=4103s)

Calculates loss between a continuous (unsegmented) time series and a target sequence.
*  CTC loss sums over the probability of possible alignments of input to target, producing a loss value which is differentiable with respect to each input node.
* The alignment of input to target is assumed to be "many-to-one", which limits the length of the target sequence such that it must less than or equal to the input length.
* Useful when your output is a sequence of vectors, which is correspond to scores of categories. -->

<center>
<img src="{{site.baseurl}}/images/week11/11-2/Fig1.png" width="85%"/><br>
<b>Fig. 2</b>: Perdita CTC per il riconoscimento vocale
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-2/Fig1.png" width="85%"/><br>
<b>Fig. 2</b>: CTC Loss for speech recognition
</center> -->

Esempio di applicazione: sistema di riconoscimento vocale
* Obiettivo: predirre quale parola viene pronunciata ogni 10 millisecondi.
* Ciascuna parola viene rappresentata da una sequqnza di suoni.
* Dipende dalla velocità della parlata della persona, suoni di diversa lunghezza si possono mappare alla stessa parola.
* Bisogna trovare la mappatura migliore che collega la sequenza di input alla sequenza di output. Un buon metodo per ottenere questo è quello di utilizzare programmazione dinamica per trovare il cammino a costo minimo.

<!-- Application Example: Speech recognition system
* Goal: Predict what word is being pronounced every 10 milliseconds.
* Each word is represented by a sequence of sounds.
* Depends on the person's speaking speed, different length of the sounds might be mapped to the same word.
* Find the best mapping from the input sequence to the output sequence. A good method for this is using dynamic programming to find the minimum cost path. -->

<center>
<img src="{{site.baseurl}}/images/week11/11-2/Fig2.png" width="85%" style="background-color:white;"/><br>
<b>Fig. 3</b>: Impostazione della mappatura "many-to-one"
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-2/Fig2.png" width="85%" style="background-color:white;"/><br>
<b>Fig. 3</b>: Many-to-one mapping setup
</center> -->

# Modelli ad energia (Parte IV) - Funzioni di perdita

<!-- # Energy-Based Models (Part IV) - Loss Function -->

## Architetture e la funzione di perdita

<!-- ## Architecture and Loss Functional -->

Una famiglia di funzioni di energia: $\mathcal{E} = \{E(W,Y, X) : W \in \mathcal{W}\}$.

Dati di addestramento: $S = \{(X^i, Y^i): i = 1 \cdots P\}$

Funzionale di perdita: $\mathcal{L} (E, S)$
* Funzionale significa una funzione di un'altra funzione. Nel nostro caso, la funzionale $\mathcal{L} (E, S)$ è una funzione della funzione di energia $E$.
* Poiché $E$ è parametrizzata da $W$, possiamo trasformare il funzionale in una funzione di perdita $W$: $\mathcal{L} (W, S)$
* Qeusta misura la qualità della funzione di energia sui dati di addestramento.
* È invariante alle permutazioni e alle ripetizioni degli esempi.

Addestramento: $W^* = \min_{W\in \mathcal{W}} \mathcal{L}(W, S)$.

Forma della funzionale di perdita:
* $L(Y^i, E(W, \mathcal{Y}, X^i))$ è la perdita _per-sample_ (per un singolo esempio).
* $Y^i$ è il valore di _target_, può essere una categoria, un'immagine, etc.
* $E(W, \mathcal{Y}, X^i)$ è la superficie di energia per un determinato $X_i$ con il variare di $Y$.
* $R(W)$ è la regolarizzazione

$$
\mathcal{L}(E, S) = \frac{1}{P} \sum_{i=1}^P L(Y^i, E(W,\mathcal{Y}, 	X^i)) + R(W)
$$

<!-- Family of energy functions: $\mathcal{E} = \{E(W,Y, X) : W \in \mathcal{W}\}$.

Training set: $S = \{(X^i, Y^i): i = 1 \cdots P\}$

Loss functional: $\mathcal{L} (E, S)$
* Functional means a function of another function. In our case, the functional $\mathcal{L} (E, S)$ is a function of the energy function $E$.
* Because $E$ is parametrised by $W$, we can turn the functional to a loss function of $W$: $\mathcal{L} (W, S)$
* Measures the quality of an energy function on training set
* Invariant under permutations and repetitions of the samples.

Training: $W^* = \min_{W\in \mathcal{W}} \mathcal{L}(W, S)$.

Form of the loss functional:
* $L(Y^i, E(W, \mathcal{Y}, X^i))$ is per-sample loss
* $Y^i$ is desired answer, can be category or a whole image, etc.
* $E(W, \mathcal{Y}, X^i)$ is energy surface for a given $X_i$ as $Y$ varies
* $R(W)$ is regulariser

$$
\mathcal{L}(E, S) = \frac{1}{P} \sum_{i=1}^P L(Y^i, E(W,\mathcal{Y}, 	X^i)) + R(W)
$$ -->

## Definire una buona funzione di perdita

<!-- ## Designing a Good Loss Function -->

**Abbassare** l'energia degli esempi corretti.

**Aumentare** l'energia sugli esempi sbagliati, in particolare se hanno energia minore degli esempi corretti.

<!-- **Push down** on the energy of the correct answer.

**Push up** on the energies of the incorrect answers, particularly if they are smaller than the correct one. -->

## Esempi di una funziona di perdita

<!-- ## Examples of Loss Functions -->

### Perdita ad energia

<!-- ### Energy Loss -->

$$
L_{energia} (Y^i, E(W, \mathcal{Y}, X^i)) = E(W, Y^i, X^i)
$$

Questa funzione di perdita semplicemente riduce il valore di energia   per gli esempi corretti. Se la rete non è definita nella maniera giusta, può finire per avere una funziona di energia piuttosto piatta, poiché la funzione di perdita riduce l'energia degli esempi corretti senza però aumentare l'energia nelle altre regioni. Quindi, il sistema potrebbe crollare.


### Perdita log-verosomiglianza negativa (_negative log-likelihood, NLL_)

<!-- ### Negative Log-Likelihood Loss -->

$$
L_{NLL}(W, S) = \frac{1}{P} \sum_{i=1}^P (E(W, Y^i, X^i) + \frac{1}{\beta} \log \int_{y \in \mathcal{Y}} e^{\beta E(W, y, X^i)})
$$

Questa funzione di perdita ridue l'energia degli esempi corretti, aumentando l'energia di tutti gli altri esempi in maniera proporzionale alla loro probabilità. Questo si riduce alla perdita percettrone (_perceptron loss_) quando $\beta \rightarrow \infty$. Questa funziona è stata utilizzata da molto tempo in diversi contesti per effettuare l'addestramento discriminativo (_discriminative training_) con output strutturati (_structured outputs_).

Un modello probabilistico è un EBM in cui:

* Si può prendere l'integrale rispetto ad Y di una funzione ad energia (la variabile da predire)
* La funzione di perdita è la funzione di log-verosomiglianza negativa.

<!-- $$
L_{nll}(W, S) = \frac{1}{P} \sum_{i=1}^P (E(W, Y^i, X^i) + \frac{1}{\beta} \log \int_{y \in \mathcal{Y}} e^{\beta E(W, y, X^i)})
$$

This loss function pushes down on the energy of the correct answer while pushing up on the energies of all answers in proportion to their probabilities. This reduces to the perceptron loss when $\beta \rightarrow \infty$. It has been used for a long time in many communities for discriminative training with structured outputs.

A probabilistic model is an EBM in which:

* The energy can be integrated over Y (the variable to be predicted)
* The loss function is the negative log-likelihood -->


### [Perdita percettrone](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=4998s)

<!-- ### [Perceptron Loss](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=4998s) -->

$$
L_{percettrone}(Y^i,E(W,\mathcal Y, X^*))=E(W,Y^i,X^i)-\min_{Y\in \mathcal Y} E(W,Y,X^i)
$$

Questa funzione di perdita è molto simile alla funzione di perdita del percettrone di più di 60 anni fa. La funzione è sempre positiva perché prende il minimo degli $Y^i$, quindi $E(W,Y^i,X^i)-\min_{Y\in\mathcal Y} E(W,Y,X^i)\geq E(W,Y^i,X^i)-E(W,Y^i,X^i)=0$. La stesso calcolo dimostra che la funzione è uguale a zero solo quando $Y^i$ è l'_output_ giusto.

Questa perdita rende l'energia dell'esempio corretto molto bassa, allo stesso tempo facendo aumentare il più possibile l'energia di tutti gli altri esempi. Tuttavia, questa perdita non preclude che la funzione dia lo stesso valore a ciascun esempio sbagliato $Y^i$, quindi in un certo senso non è una buona perditaper sistemi non-lineari. Per migliorare questa perdita, definiamo il concetto di "errore più grave" (*most offending incorrect answer*, letteralmente: la risposta sbagliata più offensiva).

<!-- $$
L_{perceptron}(Y^i,E(W,\mathcal Y, X^*))=E(W,Y^i,X^i)-\min_{Y\in \mathcal Y} E(W,Y,X^i)
$$

Very similar to the perceptron loss from 60+ years ago, and it's always positive because the minimum is also taken over $Y^i$, so $E(W,Y^i,X^i)-\min_{Y\in\mathcal Y} E(W,Y,X^i)\geq E(W,Y^i,X^i)-E(W,Y^i,X^i)=0$. The same computation shows that it give exactly zero only when $Y^i$ is the correct answer.

This loss makes the energy of the correct answer small, and at the same time, makes the energy for all other answers as large as possible. However, this loss does not prevent the function from giving the same value to every incorrect answer $Y^i$, so in this sense, it is a bad loss function for non-linear systems. To improve this loss, we define the *most offending incorrect answer*. -->


## Perdita a margine generalizzato

<!-- ## Generalized Margin Loss -->

<!-- What is the best way to translate "answer" from English in this case? -->

**Errore più grave**: caso discreto
Supponiamo che $Y$ sia una variabile discreta. Allora per un esempio di addestramento $(X^i,Y^i)$, l'_errore più grave_ $\bar Y^i$ è quell'output che ha l'energia minore fra tutti i possibili output sbagliati:

$$
\bar Y^i=\text{argmin}_{y\in \mathcal Y\text{ e }Y\neq Y^i} E(W, Y,X^i)
$$

**Errore più grave**: caso continuo
Supponiamo che $Y$ sia una variabile continua. Allora per un esempio di addestramento $(X^i,Y^i)$, l'_errore più grave_ $\bar Y^i$ è quell'output che ha l'energia minore fra tutti i possibili output sbagliati che sono almeno $\epsilon$ dall'output corretto:

$$
\bar Y^i=\text{argmin}_{Y\in \mathcal Y\text{ e }\|Y-Y^i\|>\epsilon} E(W,Y,X^i)
$$

Nel caso discreto, l'*errore più grave* è quello che ha il valore di energia minore che però non è l'output corretto. Nel caso continuo, l'energia per $Y$ nelle vicinanze di $Y^i$ dovrebbe essere approssimativamente $E(W,Y^i,X^i)$. Inoltre, l'$\text{argmin}$ preso sui valori di $Y$ non uguali a $Y^i$ sarebbe 0. Di consequenza, scegliamo una distanza $\epsilon$ e decidiamo che sono le $Y$ che sono almeno a $\epsilon$ di distanza da $Y_i$ possono essere considerate "errori". Questo è il motivo per cui l'ottimizzazione si compie solo sulle $Y$ che sono almeno a $\epsilon$ di distanza da $Y^i$.

Se la funzione d'energia è in grado di fare sí che l'energia dell'"errore più grave" sia maggiore (di un determinato margine) dell'energia dell'esempio corretto, allora questa funzione di energia dovrebbe funzionare bene.

<!-- **Most offending incorrect answer**: discrete case
Let $Y$ be a discrete variable. Then for a training sample $(X^i,Y^i)$, the *most offending incorrect answer* $\bar Y^i$ is the answer that has the lowest energy among all possible answers that are incorrect:

$$
\bar Y^i=\text{argmin}_{y\in \mathcal Y\text{ and }Y\neq Y^i} E(W, Y,X^i)
$$

**Most offending incorrect answer**: continuous case
Let $Y$ be a continuous variable. Then for a training sample $(X^i,Y^i)$, the *most offending incorrect answer* $\bar Y^i$ is the answer that has the lowest energy among all answers that are at least $\epsilon$ away from the correct answer:

$$
\bar Y^i=\text{argmin}_{Y\in \mathcal Y\text{ and }\|Y-Y^i\|>\epsilon} E(W,Y,X^i)
$$

In the discrete case, the *most offending incorrect answer* is the one with smallest energy that isn't the correct answer. In the continuous case, the energy for $Y$ extremely close to $Y^i$ should be close to $E(W,Y^i,X^i)$. Furthermore, the $\text{argmin}$ evaluated over $Y$ not equal to $Y^i$ would be 0. As a result, we pick a distance $\epsilon$ and decide that only $Y$'s at least $\epsilon$ from $Y_i$ should be considered the "incorrect answer". This is why the optimization is only over $Y$'s of distance at least $\epsilon$ from $Y^i$.

If the energy function is able to ensure that the energy of the *most offending incorrect answer* is higher than the energy of the correct answer by some margin, then this energy function should work well. -->


## Esempi di funzioni di perdita a margine generalizzato

<!-- ## Examples of Generalized Margin Loss Functions -->


### Perdita _hinge_

$$
L_{\text{hinge}}(W,Y^i,X^i)=( m + E(W,Y^i,X^i) - E(W,\bar Y^i,X^i) )^+
$$

Dove $\bar Y^i$ è l'"errore più grave". Questa perdita fa sí che la differenza fra l'output giusto e l'errore più grave sia come minimo uguale a $m$.

<!-- ### Hinge Loss -->

<!-- $$
L_{\text{hinge}}(W,Y^i,X^i)=( m + E(W,Y^i,X^i) - E(W,\bar Y^i,X^i) )^+
$$

Where $\bar Y^i$ is the *most offending incorrect answer*. This loss enforces that the difference between the correct answer and the most offending incorrect answer be at least $m$. -->

<center>
<img src="{{site.baseurl}}/images/week11/11-2/hinge.png" width="60%"/><br>
<b>Fig. 4</b>: Perdita Hinge
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-2/hinge.png" width="60%"/><br>
<b>Fig. 4</b>: Hinge Loss
</center> -->

<!-- Q: How do you pick $m$?

A: It's arbitrary, but it affects the weights of the last layer. -->


<!-- ### Log Loss -->

<!-- $$
L_{\log}(W,Y^i,X^i)=\log(1+e^{E(W,Y^i,X^i)-E(W,\bar Y^i,X^i)})
$$

This can be thought of as a "soft" hinge loss. Instead of composing the difference of the correct answer and the most offending incorrect answer with a hinge, it's now composed with a soft hinge. This loss tries to enforce an "infinite margin", but because of the exponential decay of the slope it doesn't happen. -->

Domanda: Come scegliamo $m$?

Risposta: È arbitrario, ma la scelta ha un effetto sui pesi dell'ultimo strato della rete. -->


### Perdita Logaritmica (_Log Loss_)

$$
L_{\log}(W,Y^i,X^i)=\log(1+e^{E(W,Y^i,X^i)-E(W,\bar Y^i,X^i)})
$$

Si può pensare di questa funzione come una versione "morbida" della perdita _hinge_. Invece di calcolare la differenza fra la risposta corretta e l'"errore più grave," utilizziamo una versione morbida di _hinge_. Questa perdita prova a fare sí che ci sia un "margine infinito", ma poiché la sua pendenza decade esponenzialmente, questo non accade.

<center>
<img src="{{site.baseurl}}/images/week11/11-2/log.png" width="60%"/><br>
<b>Fig. 5</b>: Perdita Logaritmica
</center>

### Perdita _Square-Square_ (quadratica-quadratica)

<!-- ### Square-Square Loss -->

$$
L_{sq-sq}(W,Y^i,X^i)=E(W,Y^i,X^i)^2+(\max(0,m-E(W,\bar Y^i,X^i)))^2
$$

Questa perdita comprende l'energia al quadrato e la perdita hinge al quadrato. Questa combinazione tenta di minimizzare l'energia mantenendo un margine di almeno $m$ sulla distanza dall'"errore più grave". Questo è molto simile alle funzioni di perdita utilizzate nelle reti neurali cosiddette "siamesi" (_Siamese nets_).

<!-- $$
L_{sq-sq}(W,Y^i,X^i)=E(W,Y^i,X^i)^2+(\max(0,m-E(W,\bar Y^i,X^i)))^2
$$

This loss combines the square of the energy with a square hinge. The combination tries to minimize the energy and but enforce margin at least $m$ on the most offending incorrect answer. This is very similar to the loss used in Siamese nets. -->


## Altre funzioni di perdita

<!-- ## Other Losses -->

Ne esistono parecchie altre. Qui di seguito riassumiamo le funzioni buone e non.

<!-- There are a whole bunch. Here is a summary of good and bad loss functions. -->

<center>
<img src="{{site.baseurl}}/images/week11/11-2/other.png" width="100%" style="background-color:white;"/><br>
<b>Fig. 6</b>: Selezione delle funzioni di perdita per EBM
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-2/other.png" width="100%" style="background-color:white;"/><br>
<b>Fig. 6</b>: Selection of EBM loss functions
</center> -->

La colonna di destra indica se la funzione ad energia impone un margine. La tipica perdita ad energia non spinge alcuna regione verso l'alto e quindi non ha un margine. La perdita ad energia non funziona per ogni tipo di problema. La perdita percettrone non funziona in generale, ma solo quando si ha una parametrizzazione lineare della funzione di energia. Alcune funzioni di perdita hanno un margine finito come la perdita _hinge_, mentre altre hanno margini infiniti, come la perdita _hinge_ "morbida".

Domanda: In che modo viene trovato l'"errore più grave" $\bar Y_i$ nel caso continuo?

Risposta: Vogliamo aumentare l'energia dei punti che sono sufficientemente distanti da $Y^i$, perché se ci avviciniamo troppo, i parametri potrebbero non cambiare più di tanto perché la funzione definita da una rete neurale diventa "rigida". In generale, questo è un problema difficile ed è proprio quello che provano a risolvere i metodi che utilizzano esempi contrastivi. Non c'è un modo giusto per trovarlo.

Una perdita di tipo _hinge_ contrastiva più generica è la seguente:

$$
L(W,X^i,Y^i)=\sum_y H(E(W, Y^i,X^i)-E(W,y,X^i)+C(Y^i,y))
$$

Presupponiamo che $Y$ sia discreta (se fosse continua la somma verrebbe sostituita da un integrale). Qui, $E(W, Y^i,X^i)-E(W,y,X^i)$ è la differenza fra $E$ valutato sull'output corretto ed $E$ valutato su un'altro output. $C(Y^i,y)$ è il margine, ed generalmente rappresenta una misura di distanza fra $Y^i$ e $y$. La motivazione per questo è che vogliamo che l'aumentare degli esempi sbagliati $y$ dipenda dalla distanza fra $y$ e l'esempio corretto $Y_i$. Questa può essere una perdita più difficile da ottimizzare.

<!-- The right-hand column indicates if the energy function enforces a margin. The plain old energy loss does not push up anywhere, so it doesn't have a margin. The energy loss doesn't work for every problem. The perceptron loss works if you have a linear parametrisation of your energy but not in general. Some of them have a finite margin like the hinge loss, and some have an infinite margin like the soft hinge.

Q: How is the most offending incorrect answer found $\bar Y_i$ found in the continuous case?

A: You want to push up on a point that is sufficiently far from $Y^i$, because if it's too close, the parameters may not move much since the function defined by a neural net is "stiff". But in general, this is hard and this is the problem that methods selecting contrastive samples try to solve. There's no single correct way to do it.

A slightly more general form for hinge type contrastive losses is:

$$
L(W,X^i,Y^i)=\sum_y H(E(W, Y^i,X^i)-E(W,y,X^i)+C(Y^i,y))
$$

We assume that $Y$ is discrete, but if it were continuous, the sum would be replaced by an integral. Here, $E(W, Y^i,X^i)-E(W,y,X^i)$ is the difference of $E$ evaluated at the correct answer and some other answer. $C(Y^i,y)$ is the margin, and is generally a distance measure between $Y^i$ and $y$. The motivation is that the amount we want to push up on a incorrect sample $y$ should depend on the distance between $y$ and the correct sample $Y_i$. This can be a more difficult loss to optimize. -->
