---
lang: it
lang-ref: ch.11-1
lecturer: Yann LeCun
title: Funzioni di attivazione e di perdita (parte 1)
authors: Haochen Wang, Eunkyung An, Ying Jin, Ningyuan Huang
date: 13 Apr 2020
translation-date: 15 Aug 2020
translator: Francesca Guiso
---

## [Funzioni di attivazione](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=15s)

<!-- ## [Activation functions](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=15s) -->

In questa lezione, faremo un riassunto delle funzioni di attivazione più importanti e la loro implementazione in PyTorch. Queste provengono da diversi articoli che affermano che ciascuna di esse funzioni meglio per un determinato tipo di problema.
<!-- In today's lecture, we will review some important activation functions and their implementations in PyTorch. They came from various papers claiming these functions work better for specific problems. -->

### Unità Lineare Rettificata (_Rectified Linear Unit, ReLU_) - `nn.ReLU()`
<!-- ### ReLU - `nn.ReLU()`-->

$$
\text{ReLU}(x) = (x)^{+} = \max(0,x)
$$

<!--
$$
\text{ReLU}(x) = (x)^{+} = \max(0,x)
$$ -->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/ReLU.png" height="400px" /><br>
<b>Fig. 1</b>: ReLU
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/ReLU.png" height="400px" /><br>
<b>Fig. 1</b>: ReLU
</center> -->

### RReLU - `nn.RReLU()`
<!-- ### RReLU - `nn.RReLU()`-->

Ci sono diverse varianti di _ReLU_. Definiamo ReLU casuale (_Random ReLU, RReLU_) come di seguito.

$$
\text{RReLU}(x) = \begin{cases}
      x, & \text{if} x \geq 0\\
      ax, & \text{otherwise}
    \end{cases}
$$

<!-- There are variations in ReLU. The Random ReLU (RReLU) is defined as follows.

$$
\text{RReLU}(x) = \begin{cases}
      x, & \text{if} x \geq 0\\
      ax, & \text{otherwise}
    \end{cases}
$$ -->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/RRelU.png" width="700" /><br>
<b>Fig. 2</b>: ReLU, "Leaky" ReLU/PReLU, RReLU
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/RRelU.png" width="700" /><br>
<b>Fig. 2</b>: ReLU, Leaky ReLU/PReLU, RReLU
</center> -->

Si noti che per il _RReLU_, $a$ è una variabile casuale che mantiene i campionamenti in un determinato _range_ durante la fase di addestramento, e che rimane fissa durante la fase di _test_. Anche nel _PReLU_ , $a$ viene addestrato. Per il *Leaky ReLU* (ReLU con perdita), $a$ è fisso.
<!-- Note that for RReLU, $a$ is a random variable that keeps samplings in a given range during training, and remains fixed during testing. For PReLU , $a$ is also learned. For Leaky ReLU, $a$ is fixed. -->

### LeakyReLU - `nn.LeakyReLU()`
<!-- ### LeakyReLU - `nn.LeakyReLU()` -->

$$
\text{LeakyReLU}(x) = \begin{cases}
      x, & \text{if} x \geq 0\\
      a_\text{negative slope}x, & \text{otherwise}
    \end{cases}
$$

<!-- $$
\text{LeakyReLU}(x) = \begin{cases}
      x, & \text{if} x \geq 0\\
      a_\text{negative slope}x, & \text{otherwise}
    \end{cases}
$$ -->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/LeakyReLU.png" height="400px" /><br>
<b>Fig. 3</b>: "Leaky" ReLU
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/LeakyReLU.png" height="400px" /><br>
<b>Fig. 3</b>: LeakyReLU
</center> -->

Qui $a$ è un parametro fisso. Il divisore dell'equazione di sopra previene il problema del ReLU "scomparente" (*dying ReLU*), ovvero che i neuroni ReLU diventino di fatto inattivi, avendo valore 0 per qualunque _input_, e che anche il gradiente sia 0. Una pendenza negativa permette alla rete di compiere la retro-propagazione e quindi di apprendere <!-- qualcosa di utile-->.

Il _Leaky ReLU_ è necessario per le reti "fini" (_skinny network_), in cui è quasi impossibile ottenere gradienti da propagare indietro con il ReLU ordinario. Con il _Leaky ReLU_ la rete può avere un gradiente anche in quelle regioni in cui il _ReLU_ ordinario avrebbe azzerato tutti i valori.

<!-- Here $a$ is a fixed parameter. The bottom part of the equation prevents the problem of dying ReLU which refers to the problem when ReLU neurons become inactive and only output 0 for any input. Therefore, its gradient is 0. By using a negative slope, it allows the network to propagate back and learn something useful.

LeakyReLU is necessary for skinny network, which is almost impossible to get gradients flowing back with vanilla ReLU. With LeakyReLU, the network can still have gradients even we are in the region where everything is zero out. -->

### PReLU - `nn.PReLU()`

<!-- ### PReLU - `nn.PReLU()` -->

$$
\text{PReLU}(x) = \begin{cases}
      x, & \text{if} x \geq 0\\
      ax, & \text{otherwise}
    \end{cases}
$$

Qui $a$ è un parametro da addestrare.

<!-- $$
\text{PReLU}(x) = \begin{cases}
      x, & \text{if} x \geq 0\\
      ax, & \text{otherwise}
    \end{cases}
$$

Here $a$ is a learnable parameter. -->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/PReLU.png" height="400px" /><br>
<b>Fig. 4</b>: ReLU
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/PReLU.png" height="400px" /><br>
<b>Fig. 4</b>: ReLU
</center> -->

Le funzioni di attivazione di sopra (_ReLU, LeakyReLU, PReLU_) sono invarianti ai riscalamenti.

<!-- The above activation functions (i.e. ReLU, LeakyReLU, PReLU) are scale-invariant. -->

### Softplus - `Softplus()`
<!-- ### Softplus - `Softplus()` -->

$$
\text{Softplus}(x) = \frac{1}{\beta} * \log(1 + \exp(\beta * x))
$$

<!-- $$
\text{Softplus}(x) = \frac{1}{\beta} * \log(1 + \exp(\beta * x))
$$ -->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Softplus.png" height="400px" /><br>
<b>Fig. 5</b>: Softplus
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/Softplus.png" height="400px" /><br>
<b>Fig. 5</b>: Softplus
</center> -->

_Softplus_ è un'approssimazione differenziabile (liscia) della funzione _ReLU_ e può essere utilizzata per vincolare l'output in modo che sia sempre positivo. La funzione assomiglia sempre più a _ReLU_ al crescere di $\beta$.

<!-- Softplus is a smooth approximation to the ReLU function and can be used to constrain the output of a machine to always be positive.

The function will become more like ReLU, if the $\beta$ gets larger and larger. -->

### ELU - `nn.ELU()`

<!-- ### ELU - `nn.ELU()` -->

$$
\text{ELU}(x) = \max(0, x) + \min(0, \alpha * (\exp(x) - 1)
$$

<!-- $$
\text{ELU}(x) = \max(0, x) + \min(0, \alpha * (\exp(x) - 1)
$$ -->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/ELU.png" height="400px" /><br>
<b>Fig. 6</b>: ELU
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/ELU.png" height="400px" /><br>
<b>Fig. 6</b>: ELU
</center> -->

Al contrario di _ReLU_, l'unità lineare esponenziale (_Exponential Linear Unit, ELU_) può generare valori negativi, permettendo al sistema di avere un _output_ uguale a zero in media. Il modello può quindi convergere più in fretta. Le varianti _CELU_ (_Continuously Differentiable Exponential Linear Units_) e _SELU_ (_Scaled Exponential Linear Unit_) sono semplicemente ri-parametrizzazioni di _ELU_.

<!-- Unlike ReLU, it can go below 0 which allows the system to have average output to be zero. Therefore, the model may converge faster. And its variations (CELU, SELU) are just different parametrizations. -->

### CELU - `nn.CELU()`

<!-- ### CELU - `nn.CELU()` -->

<!-- $$
\text{CELU}(x) = \max(0, x) + \min(0, \alpha * (\exp(x/\alpha) - 1)
$$ -->

$$
\text{CELU}(x) = \max(0, x) + \min(0, \alpha * (\exp(x/\alpha) - 1)
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/CELU.png" height="400px" /><br>
<b>Fig. 7</b>: CELU
</center>


### SELU - `nn.SELU()` -->

$$
\text{SELU}(x) = \text{scale} * (\max(0, x) + \min(0, \alpha * (\exp(x) - 1))
$$

<!-- ### SELU - `nn.SELU()` -->

<!-- $$
\text{SELU}(x) = \text{scale} * (\max(0, x) + \min(0, \alpha * (\exp(x) - 1))
$$ -->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/SELU.png" height="400px" /><br>
<b>Fig. 8</b>: SELU
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/SELU.png" height="400px" /><br>
<b>Fig. 8</b>: SELU
</center> -->

### GELU - `nn.GELU()`

$$
\text{GELU(x)} = x * \Phi(x)
$$

dove $\Phi(x)$ è la funzione di distribuzione cumulativa (_cdf_) per la distribuzione normale.

<!-- ### GELU - `nn.GELU()` -->

<!-- $$
\text{GELU(x)} = x * \Phi(x)
$$ -->

<!-- where $\Phi(x)$ is the Cumulative Distribution Function for Gaussian Distribution. -->

<!-- where $\Phi(x)$ is the Cumulative Distribution Function for Gaussian Distribution. -->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/GELU.png" height="400px" /><br>
<b>Fig. 9</b>: GELU
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/GELU.png" height="400px" /><br>
<b>Fig. 9</b>: GELU
</center> -->

### ReLU6 - `nn.ReLU6()`

$$
\text{ReLU6}(x) = \min(\max(0,x),6)
$$

<!-- ### ReLU6 - `nn.ReLU6()` -->

<!-- $$
\text{ReLU6}(x) = \min(\max(0,x),6)
$$ -->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/ReLU6.png" height="400px" /><br>
<b>Fig. 10</b>: ReLU6
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/ReLU6.png" height="400px" /><br>
<b>Fig. 10</b>: ReLU6
</center> -->

Questa funzione è la funzione _ReLU_ che si appiattisce a valori pari o maggiori a 6. Tuttavia, non vi è una ragione particolare che motiva la scelta del valore 6. Possiamo invece utilizzare la funzione sigmoide come di seguito.

<!-- This is ReLU saturating at 6. But there is no particular reason why picking 6 as saturation, so we can do better by using Sigmoid function below. -->


### Sigmoid - `nn.Sigmoid()`

<!-- ### Sigmoid - `nn.Sigmoid()` -->

$$
\text{Sigmoid}(x) = \sigma(x) = \frac{1}{1 + \exp(-x)}
$$

<!-- $$
\text{Sigmoid}(x) = \sigma(x) = \frac{1}{1 + \exp(-x)}
$$ -->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Sigmoid.png" height="400px" /><br>
<b>Fig. 11</b>: Funzione Sigmoide
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/Sigmoid.png" height="400px" /><br>
<b>Fig. 11</b>: Sigmoid
</center> -->

Se accatastiamo funzioni sigmoidi su diversi strati, questo potrebbe creare inefficienza nell'apprendimento della rete e potrebbe dover richiedere un'attenta inizializzazione. Questo perché se l'input è molto grande o molto piccolo, il gradiente della funzione sigmoide è quasi 0. Di consequenza non vi è un gradiente da retro-propagare per aggiornare i parametri della rete, un fenomeno noto come il problema del gradiente saturo (*saturated gradient problem*). Quindi, per le reti neurali profonde preferiamo una sola funzione di attivazione con un punto angoloso (ad esempio _ReLU_).

<!-- If we stack sigmoids in many layers, it may be inefficient for the system to learn and requires careful initialization. This is because if the input is very large or small, the gradient of the sigmoid function is close to 0. In this case, there is no gradient flowing back to update the parameters, known as saturating gradient problem. Therefore, for deep neural networks, a single kink function (such as ReLU) is preferred. -->


### Tanh - `nn.Tanh()`

<!-- ### Tanh - `nn.Tanh()` -->

$$
\text{Tanh}(x) = \tanh(x) = \frac{\exp(x) - \exp(-x)}{\exp(x) + \exp(-x)}
$$

<!-- $$
\text{Tanh}(x) = \tanh(x) = \frac{\exp(x) - \exp(-x)}{\exp(x) + \exp(-x)}
$$ -->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Tanh.png" height="400px" /><br>
<b>Fig. 12</b>: Tanh
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/Tanh.png" height="400px" /><br>
<b>Fig. 12</b>: Tanh
</center> -->

La funzione tangente iperbolica (_hyperbolic tangent, tanh_) è praticamente identica alla funzione sigmoide tranne per il fatto che è centrata in un intervallo fra -1 e 1. L'output della funzione sarà, di media, vicino allo zero e di consequenza il modello convergerà più velocemente. Si noti che solitamente si converge più velocemente quando ciascun input è di media vicino a zero, come ad esempio la normalizzazione _batch_ (_Batch Normalization_, _BatchNorm_).

<!-- Tanh is basically identical to Sigmoid except it is centred, ranging from -1 to 1. The output of the function will have roughly zero mean. Therefore, the model will converge faster.  Note that convergence is usually faster if the average of each input variable is close to zero. One example is Batch Normalization. -->


### Softsign - `nn.Softsign()`

$$
\text{SoftSign}(x) = \frac{x}{1 + |x|}
$$

<!-- ### Softsign - `nn.Softsign()` -->

<!-- $$
\text{SoftSign}(x) = \frac{x}{1 + |x|}
$$ -->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Softsign.png" height="400px" /><br>
<b>Fig. 13</b>: Softsign
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/Softsign.png" height="400px" /><br>
<b>Fig. 13</b>: Softsign
</center> -->

È simile alla funzione sigmoide perché si avvicina all'asintoto lentamente, quindi attenua (fino a un certo punto) il problema del gradiente scomparente (_vanishing gradient problem_).

<!-- It is similar to the Sigmoid function but gets to the asymptote slowly and alleviate the gradient vanishing problem (to some extent). -->


<!-- ### Hardtanh - `nn.Hardtanh()` -->

<!-- $$
\text{HardTanh}(x) = \begin{cases}
      1, & \text{if} x > 1\\
      -1, & \text{if} x < -1\\
      x, & \text{otherwise}
\end{cases}
$$ -->

### Hardtanh - `nn.Hardtanh()`

$$
\text{HardTanh}(x) = \begin{cases}
      1, & \text{if} x > 1\\
      -1, & \text{if} x < -1\\
      x, & \text{otherwise}
\end{cases}
$$

Il _range_ dell'intervallo lineare [-1, 1] può essere aggiustato utilizzando `min_val` e `max_val`.

<!-- The range of the linear region [-1, 1] can be adjusted using `min_val` and `max_val`. -->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Hardtanh.png" height="400px" /><br>
<b>Fig. 14</b>: Hardtanh
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/Hardtanh.png" height="400px" /><br>
<b>Fig. 14</b>: Hardtanh
</center> -->

Funziona sorprendentemente bene, particolarmente quando si vincolano i pesi in modo che rientrino in un _range_ di valori bassi.

<!-- It works surprisingly well especially when weights are kept within the small value range. -->


### Threshold - `nn.Threshold()`

<!-- ### Threshold - `nn.Threshold()` -->

$$
  y = \begin{cases}
      x, & \text{if} x > \text{threshold}\\
      v, & \text{otherwise}
    \end{cases}
$$

<!-- $$
  y = \begin{cases}
      x, & \text{if} x > \text{threshold}\\
      v, & \text{otherwise}
    \end{cases}
$$ -->

Questa funzione viene utilizzata raramente perché non se ne può retro-propagare il gradiente. Anche questo ha impedito che si utilizzasse la retro-propagazione negli anni '60 e '70, quando si utilizzavano neuroni binari.

<!-- It is rarely used because we cannot propagate the gradient back. And it is also the reason preventing people from using back-propagation in 60s and 70s when they were using binary neurons. -->


### Tanhshrink - `nn.Tanhshrink()`

<!-- ### Tanhshrink - `nn.Tanhshrink()` -->

<!-- $$
\text{Tanhshrink}(x) = x - \tanh(x)
$$ -->

$$
\text{Tanhshrink}(x) = x - \tanh(x)
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Tanhshrink.png" height="400px" /><br>
<b>Fig. 15</b>: Tanhshrink
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/Tanhshrink.png" height="400px" /><br>
<b>Fig. 15</b>: Tanhshrink
</center> -->

Questa funzione viene utilizzata raramente, se non per calcolare il valore di una variabile latente tramite la codifica rarefatta (_sparse coding_).

<!-- It is rarely used except for sparse coding to compute the value of the latent variable. -->


### Softshrink - `nn.Softshrink()`

$$
  \text{SoftShrinkage}(x) = \begin{cases}
      x - \lambda, & \text{if} x > \lambda\\
      x + \lambda, & \text{if} x < -\lambda\\
      0, & \text{otherwise}
    \end{cases}
$$

<!-- ### Softshrink - `nn.Softshrink()` -->

<!-- $$
  \text{SoftShrinkage}(x) = \begin{cases}
      x - \lambda, & \text{if} x > \lambda\\
      x + \lambda, & \text{if} x < -\lambda\\
      0, & \text{otherwise}
    \end{cases}
$$ -->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Softshrink.png" height="400px" /><br>
<b>Fig. 16</b>: Softshrink
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/Softshrink.png" height="400px" /><br>
<b>Fig. 16</b>: Softshrink
</center> -->

Questa funzione rimpicciolisce l'input di un fattore costante, e lo manda a zero quando il suo valore si avvicina a zero. La si può pensare come un passo del gradiente secondo il criterio $\ell_1$. La funzione è anche uno dei passi dell'algoritmo _Iterative Shrinkage-Thresholding Algorithm (ISTA)_. Tuttavia, non viene utilizzata frequentemente come attivazione nelle reti neurali standard.

<!-- This basically shrinks the variable by a constant towards 0, and forces to 0 if the variable is close to 0. You can think of it as a step of gradient for the $\ell_1$ criteria. It is also one of the step of the Iterative Shrinkage-Thresholding Algorithm (ISTA). But it is not commonly used in standard neural network as activations. -->


### Hardshrink - `nn.Hardshrink()`

$$
  \text{HardShrinkage}(x) = \begin{cases}
      x, & \text{if} x > \lambda\\
      x, & \text{if} x < -\lambda\\
      0, & \text{otherwise}
    \end{cases}
$$

<!-- ### Hardshrink - `nn.Hardshrink()` -->

<!-- $$
  \text{HardShrinkage}(x) = \begin{cases}
      x, & \text{if} x > \lambda\\
      x, & \text{if} x < -\lambda\\
      0, & \text{otherwise}
    \end{cases}
$$ -->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Hardshrink.png" height="400px" /><br>
<b>Fig. 17</b>: Hardshrink
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/Hardshrink.png" height="400px" /><br>
<b>Fig. 17</b>: Hardshrink
</center> -->

Viene utilizzato raramente, se non per la codifica rarefatta.

<!-- It is rarely used except for sparse coding. -->


### LogSigmoid - `nn.LogSigmoid()`

$$
\text{LogSigmoid}(x) = \log\left(\frac{1}{1 + \exp(-x)}\right)
$$

<!-- ### LogSigmoid - `nn.LogSigmoid()` -->

<!-- $$
\text{LogSigmoid}(x) = \log\left(\frac{1}{1 + \exp(-x)}\right)
$$ -->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/LogSigmoid.png" height="400px" /><br>
<b>Fig. 18</b>: LogSigmoid
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week11/11-1/LogSigmoid.png" height="400px" /><br>
<b>Fig. 18</b>: LogSigmoid
</center> -->

Viene utilizzata principalmente come funzione di perdita, non viene comunemente utilizzata come funzione di attivazione.

<!-- It is mostly used in the loss function but not common for activations. -->

### Softmin - `nn.Softmin()`

<!-- ### Softmin - `nn.Softmin()` -->

$$
\text{Softmin}(x_i) = \frac{\exp(-x_i)}{\sum_j \exp(-x_j)}
$$

<!-- $$
\text{Softmin}(x_i) = \frac{\exp(-x_i)}{\sum_j \exp(-x_j)}
$$ -->

Trasforma i numeri in una distribuzione di probabilità.

<!-- It turns numbers into a probability distribution. -->


### Soft(arg)max - `nn.Softmax()`

<!-- ### Soft(arg)max - `nn.Softmax()` -->

<!-- $$
\text{Softmax}(x_i) = \frac{\exp(x_i)}{\sum_j \exp(x_j)}
$$ -->

$$
\text{Softmax}(x_i) = \frac{\exp(x_i)}{\sum_j \exp(x_j)}
$$


<!-- ### LogSoft(arg)max - `nn.LogSoftmax()` -->

### LogSoft(arg)max - `nn.LogSoftmax()`

<!-- $$
\text{LogSoftmax}(x_i) = \log\left(\frac{\exp(x_i)}{\sum_j \exp(x_j)}\right)
$$ -->

$$
\text{LogSoftmax}(x_i) = \log\left(\frac{\exp(x_i)}{\sum_j \exp(x_j)}\right)
$$

Viene utilizzata principalmente come funzione di perdita, non viene comunemente utilizzata come funzione di attivazione.

<!-- It is mostly used in the loss function but not common for activations. -->


## [Domande e risposte sulle funzioni di attivazione](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=861s)

<!-- ## [Q&A activation functions](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=861s) -->


### Domande su `nn.PReLU()`

- Perché utilizziamo lo stesso valore di $a$ per tutti i canali?

  > Si possono avere diversi $a$ per ogni canale. Si può usare $a$ come parametro per ogni unità della rete. Inoltre, $a$ può essere condiviso come mappatura delle caratteristiche.

<!-- ### `nn.PReLU()` related questions -->

<!-- - Why would we want the same value of $a$ for all channels?

  > Different channels could have different $a$. You could use $a$ as a parameter of every unit. It could be shared as a feature map as well. -->

- $a$ è un valore da apprendere? Ci sono dei vantaggi nell'apprendere $a$?

  > $a$ può essere apprendibile oppure fisso.
  > La ragione per cui potremmo voler fissare $a$ è al fine di garantire che l'attivazione non lineare possa avere un gradiente diverso da zero anche nelle regioni negative.
  > Rendere $a$ un parametro apprendibile permette invece al sistema di trasformare la funzione non lineare in una mappatura lineare oppure in un raddrizzamento <!-- come tradurre full rectification? -->. Questo potrebbe essere utile per alcune applicazioni, come ad esempio per implementare un rilevatore di _edge_ indipendente dalla sua polarità.

<!-- - Do we learn $a$? Is learning $a$ advantageous?

  > You can learn $a$ or fix it.
  > The reason for fixing is to ensure that nonlinearity gives you a non-zero gradient even if it's in a negative region.
  > Making $a$ learnable allows the system to turn nonlinearity into either linear mapping or full rectification. It could be useful for some applications like implementing an edge detector regardless of the edge polarity. -->

- Quanto dev'essere complessa la funzione non lineare?

  > In teoria, possiamo parametrizzare un'intera funzione non lineare in maniera molto complessa, utilizzando ad esempio _spring parameters_, polinomi di Chebyshev, etc. La parametrizzazione può diventare una parte del processo di apprendimento.


<!-- - How complex do you want your non-linearity to be?

  > Theoretically, we can parametrise an entire nonlinear function in very complicated way, such as with spring parameters, Chebyshev polynomial, etc. Parametrising could be a part of learning process. -->

- Qual è un vantaggio della parametrizzazione rispetto ad avere più unità nel sistema?

  > Dipende da quello che si vuole fare. Ad esempio, per la regressione in uno spazio a bassa dimensionalità, la paramterizzazione può essere utile. Tuttavia, se il compito è in uno spazio ad alta dimensionalità, come per il riconoscimento delle immagini, può bastare una qualunque funzione non lineare, e le funzioni monotone funzionano meglio.
  > In poche parole, si può parametrizzare qualunque funzione, ma non è detto che questo porti un grande vantaggio.

<!-- - What is an advantage of parametrising over having more units in your system?

  > It really depends on what you want to do. For example, when doing regression in a low dimensional space, parametrisation might help. However, if your task is in under a high dimensional space such as image recognition, just "a" nonlinearity is necessary and monotonic nonlinearity will work better.
  > In short, you can parametrize any functions you want but it doesn't bring a huge advantage. -->

### Domande sui punti angolosi

<!-- ### Kink related questions -->

- Un punto angoloso rispetto a due punti angolosi

  > Le funzioni con due punti angolosi creano implicitamente una nozione di scala. Questo significa che se i pesi dell'_input_ vengono moltiplicati per due, o se l'ampiezza del segnale viene moltiplicata per due, gli output saranno completamente diversi. Il segnale potrebbe prendere un valore diverso dalla funzione non lineare, risultando in un comportamento dell'_output_ completamente diverso. Tuttavia, se abbiamo una funzione con un solo punto angoloso, moltiplicare l'_input_ per due risulterebbe semplicemente in un _output_ moltiplicato per due.

<!-- - One kink versus double kink

  > Double kink is a built-in scale in it. This means that if the input layer is multiplied by two (or the signal amplitude is multiplied by two), then outputs will be completely different. The signal will be more in nonlinearity, thus you will get a completely different behaviour of the output. Whereas, if you have a function with only one kink, if you multiply the input by two, then your output will be also multiplied by two.
  ^ I find this super confusing.

  > Double kink has a built-in scale in it. This means that if the input layer weights are multiplied by two (or the signal amplitude is multiplied by two), then outputs will be completely different. The signal may be treated differently by the non-linearity, thus you may get a completely different behaviour of the output. Whereas, if you have a function with only one kink, if you multiply the input by two, then your output will be also multiplied by two. -->

- Quali sono le differenze tra le funzioni di attivazione con punti angolosi e quelle non lineari ma lisce? Quando e perché ne preferiamo una rispetto all'altra?

  > Si tratta dell'invarianza ai riscalamenti. Se si ha un punto angoloso e moltiplichiamo l'_input_ per due questo risulta in un _output_ moltiplicato per due. Se invece abbiamo una transizione liscia fra una parte della funzione e l'altra, e per esempio moltiplichiamo l'_input_ per 100, l'_output_ potrebbe rassomigliare all'_output_ di una funzione con punto angoloso perché la parte liscia viene rimpicciolita di un fattore di 100. Se si divide l'_input_ per 100, il punto angoloso diventa una funzione convessa molto liscia. Quindi, cambiando la scala dell'_input_ cambiamo il comportamento della funzione di attivazione.

  > Talvolta questo può creare problemi. Ad esempio, quando addestriamo una rete neurale con più di uno strato, se abbiamo due strati consecutivi non possiamo controllare la dimensione relativa dei pesi di uno strato e dell'altro. Se abbiamo una funzione non lineare che è "sensibile" alla scala degli input, la rete sarà vincolata dalla dimensione dei pesi da utilizzare nel primo strato, perché cambiarne la dimensione potrebbe risultare in un comportamento completamente diverso.

  > Un modo per risolvere questo problema sarebbe di imporre una scala fissa sui pesi di ogni strato cosí da poter normalizzare tutti i pesi a seconda dello strato a cui appartengono, ad esempio con la normalizzazione _batch_. Di consequenza, la varianza di ciascuna unità della rete diventa fissa. Fissata la scala, il sistema non ha più modo di scegliere quale parte della funzione non lineare da utilizzare se si ha una funzione con due punti angolosi. Questo potrebbe essere un problema se la parte "fissa" dovesse diventare troppo "lineare". Ad esempio, la funzione sigmoide diventa lineare per valori intorno a zero, e quindi gli output della normalizzazione _batch_ (vicini a zero) potrebbero di fatto non essere attivati da una funzione non lineare.
  >
  > Non è del tutto chiaro perché le reti profonde funzionino meglio con funzioni di attivazione con un unico punto angoloso. Probabilmente, questo è dovuto alla loro proprietà di invarianza ai riscalamenti.

<!-- - Differences between a nonlinear activation having kinks and a smooth nonlinear activation. Why/when one of them is preferred?

  > It is a matter of scale equivariance. If kink is hard, you multiply the input by two and the output is multiplied by two. If you have a smooth transition, for example, if you multiply the input by 100, the output looks like you have a hard kink because the smooth part is shrunk by a factor of 100. If you divide the input by 100, the kink becomes a very smooth convex function. Thus, by changing the scale of the input, you change the behaviour of the activation unit.

  > Sometimes this could be a problem. For example, when you train a multi-layer neural net and you have two layers that are one after the other. You do not have a good control for how big the weights of one layer is relative to the other layer's weights. If you have nonlinearity that cares about scales, your network doesn't have a choice of what size of weight matrix can be used in the first layer because this will completely change the behaviour.

  > One way to fix this problem is setting a hard scale on the weights of every layer so you can normalise the weights of layers, such as batch normalisation. Thus, the variance that goes into a unit becomes always constant. If you fix the scale, then the system doesn't have any way of choosing which part of the nonlinearity will be using in two kink function systems. This could be a problem if this 'fixed' part becomes too 'linear'. For example, Sigmoid becomes almost linear near zero, and thus batch normalisation outputs (close to 0) could not be activated 'non-linearly'.
  >
  > It is not entirely clear why deep networks work better with single kink functions. It's probably due to the scale equivariance property. -->

### Coefficiente di temperatura in una funzione soft(arg)max

- Quando si usa il coefficiente di temperatura e perché viene utilizzato?

  > In una certa misura la temperatura è ridondante rispetto ai pesi in ingresso. Se abbiamo delle somme pesate in ingresso alla nostra softmax, il parametro $\beta$ è ridondante rispetto alla dimensione dei pesi.

  > La temperatura controlla quanto sarà duro l'output delle distribuzione. Per valori molto grandi di $\beta$ diventa molto vicino all'uno oppure allo zero. Quando $\beta$ è piccolo, è più morbido. Se il limite di $\beta$ è uguale a zero è come una media, se $\beta$ va ad infinito si comporta come argmax e non è più morbido. Quindi, se si ha una forma di normalizzazione prima del softmax, agire su questo parametro permette di controllarne la durezza.
  > A volte si può iniziare con un $\beta$ piccolo in modo da ottenere una discesa del gradiente dal comportamento corretto ed in seguito, mentre l'elaborazione procede e se si vuole una decisione più dura nel meccanismo di soglia, si incrementa $\beta$. Possiamo quindi rifinire le decisioni. Questo trucco viene chiamato tempratura. Per molti esperti è un utile meccanismo di auto attenzione.


<!-- ### Temperature coefficient in a soft(arg)max function -->

<!-- - When do we use the temperature coefficient and why do we use it?

  > To some extent, the temperature is redundant with incoming weights. If you have weighted sums coming into your softmax, the $\beta$ parameter is redundant with the size of weights.

  > Temperature controls how hard the distribution of output will be. When $\beta$ is very large, it becomes very close to either one or zero. When $\beta$ is small, it is softer. When the limit of $\beta$ equals to zero, it is like an average. When $\beta$ goes infinity, it behaves like argmax. It's no longer its soft version. Thus, if you have some sort of normalisation before the softmax then, tuning this parameter allows you to control the hardness.
  > Sometimes, you can start with a small $\beta$ so that you can have well-behaved gradient descents and then, as running proceeds, if you want a harder decision in your attention mechanism, you increase $\beta$. Thus, you can sharpen the decisions. This trick is called as annealing. It can be useful for a mixture of experts like a self attention mechanism. -->

## [Funzioni di perdita](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=1990s)

<!-- ## [Loss functions](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=1990s) -->

PyTorch ha implementato molte funzioni di perdita. Qui di seguito ne vedremo alcune.

<!-- PyTorch also has a lot of loss functions implemented. Here we will go through some of them. -->


### `nn.MSELoss()`

<!-- ### `nn.MSELoss()` -->

Questa funzione, anche chiamata perdita L2 (_L2 loss_) dà l'errore quadratico medio (_mean squared error, MSE_) - la norma L2 quadrata - fra ogni elemento nell'input $x$ e l'obiettivo $y$.

Se utilizziamo un _minibatch_ di $n$ esempi, ci saranno $n$ perdite, una per ciascun esempio nel _batch_. Possiamo far sí che la funzione di perdita mantenga queste perdite in un vettore, oppure che li sintetizzi in qualche altro modo.

Se non vogliamo sintetizzare le perdite (specifichiamo `reduction='none'`), la perdita sarà:

$$l(x,y) = L = \{l_1, \dots, l_N\}^\top, l_n = (x_n - y_n)^2$$

dove $N$ è la dimensione del _batch_, $x$ e $y$ sono i _tensor_ di dimensione arbitraria con un totale di $n$ elementi ciascuno.

Le alternative per sintetizzare sono come di seguito (si noti che il valore predefinito è la media, ovvero `reduction='mean'`).

$$l(x,y) = \begin{cases}\text{mean}(L), \quad &\text{if reduction='mean'}\\
\text{sum}(L), \quad &\text{if reduction='sum'}
\end{cases}$$

L'operazione di somma opera comunque su ciascun elemento, che poi viene diviso per $n$.

Si può evitare la divisione per $n$ selezionando ``reduction = 'sum'``.


<!-- This function gives the mean squared error (squared L2 norm) between each element in the input $x$ and target $y$. It is also called L2 loss.

If we are using a minibatch of $n$ samples, then there are $n$ losses, one for each sample in the batch. We can tell the loss function to keep that loss as a vector or to reduce it.

If unreduced (i.e. set `reduction='none'`), the loss is

$$l(x,y) = L = \{l_1, \dots, l_N\}^\top, l_n = (x_n - y_n)^2$$

where $N$ is the batch size, $x$ and $y$ are tensors of arbitrary shapes with a total of n elements each.

The reduction options are below (note that the default value is `reduction='mean'`).

$$l(x,y) = \begin{cases}\text{mean}(L), \quad &\text{if reduction='mean'}\\
\text{sum}(L), \quad &\text{if reduction='sum'}
\end{cases}$$

The sum operation still operates over all the elements, and divides by $n$.

The division by $n$ can be avoided if one sets ``reduction = 'sum'``. -->

### `nn.L1Loss()`

<!-- ### `nn.L1Loss()` -->

Questo misura l'errore assoluto medio (_mean absolute error, MAE_) fra ciascun elemento dell'input $x$ e dell'obiettivo $y$ (o fra l'_output_ reale e l'_output_ atteso).

Se non sintetizziamo (specifichiamo `reduction='none'`), la perdita sarà:

$$l(x,y) = L = \{l_1, \dots, l_N\}^\top, l_n = \vert x_n - y_n\vert$$

dove $N$ è la dimensione del _batch_, $x$ e $y$ sono i _tensor_ di dimensione arbitraria con un totale di $n$ elementi ciascuno.

Vi sono alternative di sintesi (`reduction`), come prendere la media (`'mean'`) o la somma (`'sum'`), che funzionano come le `reduction` di `nn.MSELoss()`.

<!-- This measures the mean absolute error (MAE) between each element in the input $x$ and target $y$ (or the actual output and desired output).

If unreduced (i.e. set `reduction='none'`), the loss is

$$l(x,y) = L = \{l_1, \dots, l_N\}^\top, l_n = \vert x_n - y_n\vert$$

, where $N$ is the batch size, $x$ and $y$ are tensors of arbitrary shapes with a total of n elements each.

It also has `reduction` option of `'mean'` and `'sum'` similar to what `nn.MSELoss()` have. -->

**Modi d'uso:** La perdita L1 (_L1 loss_) è più robusta rispetto a valori anomali e rumore rispetto alla perdita L2. Con la perdita L2, si prende il quadrato dell'errore sui valori anomali/rumorosi, quindi la funzione di costo è molto sensibile a tali valori.

**Problema:** La perdita L1 non è differenziabile al minimo (0). Quindi dobbiamo prestare attenzione quando ne prendiamo il gradiente (ovvero, con _Softshrink_). Questo problema motiva la perdita L1 "liscia" (_SmoothL1Loss_) come di seguito.

<!-- **Use Case:** L1 loss is more robust against outliers and noise compared to L2 loss. In L2, the errors of those outlier/noisy points are squared, so the cost function gets very sensitive to outliers.

**Problem:** The L1 loss is not differentiable at the bottom (0). We need to be careful when handling its gradients (namely Softshrink). This motivates the following SmoothL1Loss. -->

### `nn.SmoothL1Loss()`

<!-- ### `nn.SmoothL1Loss()` -->

Questa funzione utilizza la perdita L2 se l'errore assoluto per elemento è minore di 1, la perdita L1 altrimenti.

$$\text{loss}(x, y) = \frac{1}{n} \sum_i z_i$$

dove $z_i$ è dato da

$$z_i = \begin{cases}0.5(x_i-y_i)^2, \quad &\text{if } |x_i - y_i| < 1\\
|x_i - y_i| - 0.5, \quad &\text{otherwise}
\end{cases}$$

Anch'essa ha diversi metodi di sintesi (`reduction`).

Questa funzione è stata pubblicizzata da Ross Girshick ([Fast R-CNN](https://arxiv.org/abs/1504.08083)). La funzione di perdita L1 liscia (_Smooth L1 Loss_) è anche nota come perdita di Huber (_Huber Loss_), oppure come rete "elastica" (_Elastic Network_) quando la si utilizza come funzione obiettivo.

**Modi d'uso:** È meno sensibile ai valori estremi rispetto alla perdita dell'errore quadratico medio (`MSELoss`) ed è liscia per i valori bassi. Questa funzione viene usata spesso per la (_computer vision_, _CV_) per resistere ai valori estremi.

**Problema:** Questa funzione ha una scala ($0.5$ nella funzione di sopra).


<!-- This function uses L2 loss if the absolute element-wise error falls below 1 and L1 loss otherwise.

$$\text{loss}(x, y) = \frac{1}{n} \sum_i z_i$$
, where $z_i$ is given by

$$z_i = \begin{cases}0.5(x_i-y_i)^2, \quad &\text{if } |x_i - y_i| < 1\\
|x_i - y_i| - 0.5, \quad &\text{otherwise}
\end{cases}$$

It also has `reduction` options.

This is advertised by Ross Girshick ([Fast R-CNN](https://arxiv.org/abs/1504.08083)). The Smooth L1 Loss is also known as the Huber Loss or the Elastic Network when used as an objective function.

**Use Case:** It is less sensitive to outliers than the `MSELoss` and is smooth at the bottom. This function is often used in computer vision for protecting against outliers.

**Problem:** This function has a scale ($0.5$ in the function above).
 -->

### L1 vs. L2 for Computer Vision

<!-- ### L1 vs. L2 for Computer Vision -->

Nella fase di previsione, abbiamo diversi $y$:

* Se utilizziamo _MSE_ (perdita L2), la previsione sarà una media di tutte le possibili $y$, che nella _CV_ costituisce un'immagine sfocata.
* Se utilizziamo la perdita L1, il valore di $y$ che minimizza la norma L1 è la mediana, ovvero uno dei valori di $y$ e quindi non è sfocato. Si noti però che la mediana è difficile da definire in spazi pluri-dimensionali.

L'utilizzo di L1 porta ad una immagine più nitida per la previsione.

<!-- In making predictions when we have a lot of different $y$'s:

* If we use MSE (L2 Loss), it results in an average of all $y$, which in CV it means we will have a blurry image.
* If we use L1 loss, the value $y$ that minimize the L1 distance is the medium, which is not blurry, but note that median is difficult to define in multiple dimensions.

Using L1 results in sharper image for prediction. -->

### `nn.NLLLoss()`

<!-- ### `nn.NLLLoss()` -->

È la funzione di perdita _negative log-likelihood_ che si utilizza per addestrare un classificatore con _C_ classi.

Si noti che, matematicamente, l'input della `NLLLoss` dovrebbe essere composto da verosomiglianze logaritmiche, ma PyTorch non impone questo vincolo. Questo ha l'effetto di rendere il componente desiderato grande a piacere.

La versione "non ridotta" (ovvero, con :attr:`reduction` settato su ``'none'``) della perdita è come di seguito:

$$\ell(x, y) = L = \{l_1,\dots,l_N\}^\top, \quad
        l_n = - w_{y_n} x_{n,y_n}, \quad
        w_{c} = \text{weight}[c] \cdot \mathbb{1}\{c \not= \text{ignore\_index}\}$$

dove $N$ è la dimensione del _batch_.

Se la `reduction` non è ``'none'`` (il valore predefinito è ``'mean'``), allora la perdita è come di seguito:

$$\ell(x, y) = \begin{cases}
            \sum_{n=1}^N \frac{1}{\sum_{n=1}^N w_{y_n}} l_n, &
            \text{if reduction} = \text{'mean';}\\
            \sum_{n=1}^N l_n,  &
            \text{if reduction} = \text{'sum'.}
        \end{cases}$$

Questa funzione di perdita ha un argomento facoltativo, `weight` (peso), un tensore 1D, con il quale si assegna un peso a ciascuna delle classi. Questo è utile quando si ha un dataset di addestramento sbilanciato.

<!-- It is the negative log likelihood loss used when training a classification problem with C classes.

Note that, mathematically, the input of `NLLLoss` should be (log) likelihoods, but PyTorch doesn't enforce that. So the effect is to make the desired component as large as possible.

The unreduced (i.e. with :attr:`reduction` set to ``'none'``) loss can be described as:

$$\ell(x, y) = L = \{l_1,\dots,l_N\}^\top, \quad
        l_n = - w_{y_n} x_{n,y_n}, \quad
        w_{c} = \text{weight}[c] \cdot \mathbb{1}\{c \not= \text{ignore\_index}\}$$

,where $N$ is the batch size.

If `reduction` is not ``'none'`` (default ``'mean'``), then

$$\ell(x, y) = \begin{cases}
            \sum_{n=1}^N \frac{1}{\sum_{n=1}^N w_{y_n}} l_n, &
            \text{if reduction} = \text{'mean';}\\
            \sum_{n=1}^N l_n,  &
            \text{if reduction} = \text{'sum'.}
        \end{cases}$$

This loss function has an optional argument `weight` that can be passed in using a 1D Tensor assigning weight to each of the classes. This is useful when dealing with imbalanced training set. -->

#### Pesi & classi sbilanciate:

<!-- #### Weights & Imbalanced Classes: -->

Il vettore di pesi è utile se la frequenza delle categorie/classi è diversa. Ad esempio, la frequenza dell'influenza è maggiore della frequenza del tumore ai polmoni. Possiamo semplicemente aumentare il peso per quelle categorie che hanno frequenza minore.

Tuttavia, invece di settare il peso, è meglio pareggiare la frequenza degli esempi durante la fase di addestramento in modo da poter sfruttare al meglio la discesa stocastica del gradiente.

Per pareggiare la frequenza delle classi durante la fase di addestramento, mettiamo gli esempi di ciascuna classe in diversi "bidoni". Poi generiamo ciascuna _minibatch_ estraendo lo stesso numero di esempi da ciascun bidone. Una volta esauriti gli esempi da estrarre dal bidone più piccolo, procediamo reiterando sugli esempi del bidone più piccolo finché non esauriamo gli esempi della classe prevalente. Questo metodo ci offre la stessa frequenza per tutte le categorie iterando attraverso questi bidoni. Si noti che non si dovrebbe mai pareggiare le classi senza utilizzare **tutti** gli esempi della categoria più prevalente -- non si lasciano indietro dati!

Una problematica evidente del metodo di sopra è che la nostra rete non rileverebbe la frequenza relativa di ciascuna categoria. Per risolvere questo problema, ritocchiamo il sistema addestrando alla fine un paio di epoche sui dati che riflettono la vera frequnza delle categorie, così che il sistema si adatti agli errori sistematici dello strato di _output_, favorendo le categorie che si verificano più frequentemente.

Per sviluppare un po' di intuizione per questo schema, ritorniamo all'esempio dal campo medico. Gli studenti di medicina studiano le malattie rare tanto quanto le malattie frequenti (anzi, forse studiano di più le malattie rare, che spesso sono anche le più complesse). Imparano ad adattarsi alle caratteristiche di ognuna di esse, correggendo poi per distinguere quelle rare.

<!-- Weight vector is useful if the frequency is different for each category/class. For example, the frequency of the common flu is much higher than the lung cancer. We can simply increase the weight for categories that has small number of samples.

However, instead of setting the weight, it's better to equalize the frequency in training so that we can exploits stochastic gradients better.

To equalize the classes in training, we put samples of each class in a different buffer. Then generate each minibatch by picking the same number samples from each buffer. When the smaller buffer runs out of samples to use, we iterate through the smaller buffer from the beginning again until every sample of the larger class is used. This way gives us equal frequency for all categories by going through those circular buffers. We should never go the easy way to equalize frequency by **not** using all samples in the majority class. Don't leave data on the floor!

An obvious problem of the above method is that our NN model wouldn't know the relative frequency of the actual samples. To solve that, we fine-tune the system by running a few epochs at the end with the actual class frequency, so that the system adapts to the biases at the output layer to favour things that are more frequent.

To get an intuition of this scheme, let's go back to the medical school example: students spend just as much time on rare disease as they do on frequent diseases (or maybe even more time, since the rare diseases are often the more complex ones). They learn to adapt to the features of all of them, then correct it to know which are rare. -->

### `nn.CrossEntropyLoss()`

<!-- ### `nn.CrossEntropyLoss()` -->

Questa funzione combina `nn.LogSoftmax` e `nn.NLLLoss` in una singola classe. L'unione delle due funzioni rende il punteggio della classe corretta il più grande possibile. 

La ragione per cui le due funzioni vengono messe insieme è per garantire la stabilità numerica del calcolo del gradiente. Quando il valore del _softmax_ è vicino a $1$ o $0$, il suo logaritmo può avvicinarsi a $0$ o $-\infty$. La pendenza del logaritmo intorno a $0$ ê vicino a $\infty$, il che crea problemi numerici nel passo intermedio della retropropagazione. Combinando le due funzioni i gradienti si saturano fornendoci, alla fine, un risultato accettabile.

L'input dovrebbe essere il punteggio non normalizzato per ciascuna classe.

La perdita può esser descritta con:

$$\text{loss}(x, c) = -\log\left(\frac{\exp(x[c])}{\sum_j \exp(x[j])}\right)
= -x[c] + \log\left(\sum_j \exp(x[j])\right)$$

o nel caso in cui viene specificato l'argomento `weight`:

$$\text{loss}(x, c) = w[c] \left(-x[c] + \log\left(\sum_j\exp(x[j])\right)\right)$$

Prendiamo la media delle perdite sulle osservazioni di ciascun _minibatch_.

La perdita Cross Entropy ha un'interpretazione nella fisica, legata alla Kullback–Leibler divergence (KL divergence), con la quale si misura la divergenza fra due distribuzioni. Qui, le pseudo-distribuzioni vengono rappresentate dal vettore $x$ (le previsioni) e la distribuzione di _target_ (un vettore _one-hot_ che ha valore 0 per le classi sbagliate e 1 per le classi corrette).

Matematicamente, abbiamo:

$$H(p,q) = H(p) + \mathcal{D}_{KL} (p \mid\mid q)$$

dove $$H(p,q) = - \sum_i p(x_i) \log (q(x_i))$$ è la cross-entropy (fra le due distribuzioni), $$H(p) = - \sum_i p(x_i) \log (p(x_i))$$ è la _entropy_, e $$\mathcal{D}_{KL} (p \mid\mid q) = \sum_i p(x_i) \log \frac{p(x_i)}{q(x_i)}$$ è la _KL_ _divergence_.

<!-- This function combines `nn.LogSoftmax` and `nn.NLLLoss` in one single class. The combination of the two makes the score of the correct class as large as possible.

The reason why the two functions are merged here is for numerical stability of gradient computation. When the value after softmax is close to 1 or 0, the log of that can get close to 0 or $-\infty$. Slope of log close to 0 is close to $\infty$, causing the intermediate step in backpropagation to have numerical issues. When the two functions are combined, the gradients is saturated so we get a reasonable number at the end.

The input is expected to be unnormalised score for each class.

The loss can be described as:

$$\text{loss}(x, c) = -\log\left(\frac{\exp(x[c])}{\sum_j \exp(x[j])}\right)
= -x[c] + \log\left(\sum_j \exp(x[j])\right)$$

or in the case of the `weight` argument being specified:

$$\text{loss}(x, c) = w[c] \left(-x[c] + \log\left(\sum_j\exp(x[j])\right)\right)$$

The losses are averaged across observations for each minibatch.

A physical interpretation of the Cross Entropy Loss is related to the Kullback–Leibler divergence (KL divergence), where we are measuring the divergence between two distributions. Here, the (quasi) distributions are represented by the x vector (predictions) and the target distribution (a one-hot vector with 0 on the wrong classes and 1 on the right class).

Mathematically,

$$H(p,q) = H(p) + \mathcal{D}_{KL} (p \mid\mid q)$$

where $$H(p,q) = - \sum_i p(x_i) \log (q(x_i))$$ is the cross-entropy (between two distributions), $$H(p) = - \sum_i p(x_i) \log (p(x_i))$$ is the entropy, and $$\mathcal{D}_{KL} (p \mid\mid q) = \sum_i p(x_i) \log \frac{p(x_i)}{q(x_i)}$$ is the KL divergence. -->

### `nn.AdaptiveLogSoftmaxWithLoss()`

<!-- ### `nn.AdaptiveLogSoftmaxWithLoss()` -->

Questa è un'approssimazione efficiente della funzione di _softmax_ per un grande numero di classi (ad esempio, milioni di classi). Questa funzione sfrutta dei trucchi per aumentare la velocità di computazione.

I dettagli di questo metodo vengono descritti in [Efficient softmax approximation for GPUs](https://arxiv.org/abs/1609.04309) di Edouard Grave, Armand Joulin, Moustapha Cissé, David Grangier, Hervé Jégou.

<!-- This is an efficient softmax approximation of softmax for large number of classes (for example, millions of classes). It implements tricks to improve the speed of the computation.

Details of the method is described in [Efficient softmax approximation for GPUs](https://arxiv.org/abs/1609.04309) by Edouard Grave, Armand Joulin, Moustapha Cissé, David Grangier, Hervé Jégou. -->
