---
lang-ref: ch.10-3
lang: it
title: Il controllore per la retromarcia di un camion
lecturer: Alfredo Canziani
authors: Muyang Jin, Jianzhi Li, Jing Qian, Zeming Lin
date: 7 Apr 2020
translator: Marco Zullich
translation-date: 6 Sep 2020
---

<div hidden>
    $$\gdef \tcab {\Theta_{\mathrm{cab}}}$$
    $$\gdef \xcab {x_{\mathrm{cab}}}$$
    $$\gdef \ycab {y_{\mathrm{cab}}}$$
    $$\gdef \ttrailer {\Theta_{\mathrm{trailer}}}$$
    $$\gdef \xtrailer {x_{\mathrm{trailer}}}$$
    $$\gdef \ytrailer {y_{\mathrm{trailer}}}$$
</div>


## [Configurazione del problema](https://www.youtube.com/watch?v=A3klBqEWR-I&t=59s)

<!-- ## [Setup](https://www.youtube.com/watch?v=A3klBqEWR-I&t=59s) -->

L'obiettivo di questo compito è la costruzione di un **controllore auto-supervisionato** (*self-supervised controller*) che controlli lo sterzo di un camion mentre percorre in retromarcia il percorso da una posizione iniziale arbitraria ad una piattaforma di carico.

<!-- The goal of this task is to build a **self-learning controller** which controls the steering of the truck while it backs up to the loading dock from any arbitrary initial position. -->

Si noti che **è permesso solamente muoversi in retromarcia**, come mostrato nella Fig. 1.

<!-- Note that **only backing up is allowed,** as shown below in Figure 1. -->

|![]({{site.baseurl}}/images/week10/10-3/fig1.png)|
|<center><b>Fig. 1</b>: il camion, il rimorchio e la piattaforma di carico</center>|
<!-- The Truck, Trailer and Loading Dock -->

Lo **stato** del camion è rappresentato da sei parametri:

<!-- The **state** of the truck is represented by six parameters: -->

- $\tcab$: l'angolo del camion (rispetto all'orizzontale)
- $\xcab, \ycab$ le coordinate cartesiane della ralla (o della testa del rimorchio)
- $\ttrailer$: l'angolo del rimorchio
- $\xtrailer, \ytrailer$: le coordinate cartesiane del (retro del) rimorchio

 <!-- - $\tcab$: Angle of the truck
 - $\xcab, \ycab$: The cartesian of the yoke (or front of the trailer).
 - $\ttrailer$: Angle of the trailer
 - $\xtrailer, \ytrailer$: The cartesian of the (back of the) trailer. -->

L'**obiettivo** del controllore è selezionare un angolo appropriato $\phi$ per ogni intervallo di tempo $k$, alla fine del quale il camion effettuerà la retromarcia percorrendo una piccola distanza fissa. Il successo prescinde da due criteri:

1. Il retro del rimorchio è parallelo al muro della piattaforma di carico, ovvero $\ttrailer = 0$, e
2. Il retro del rimorchio $\xtrailer, \ytrailer$ è più vicino possibile alle coordinate puntuali della piattaforma ($x_{dock}, y_{dock}$) come mostrato nella figura sopra.

<!-- The **goal** of the controller is to select an appropriate angle $\phi$ at each time $k$, where after the truck will back up in a fixed small distance. Success depends on two criteria: 
1. The back of the trailer is parallel to the wall loading dock, e.g. $\ttrailer = 0$.
2. The back of the trailer ($\xtrailer, \ytrailer$) is as close as possible to the point ($x_{dock}, y_{dock}$) as shown above. -->


## Parametri e visualizzazioni aggiuntive

<!-- ## More Parameters and Visualization -->

|![]({{site.baseurl}}/images/week10/10-3/fig2.png)|
|<center><b>Fig. 2</b>: parametri per la visualizzazione</center>|
<!-- Parameters for visualization -->

In questa sezione, consideriamo un gruppo di parametri aggiuntivi come mostrato nella Fig. 2.
Data la lunghezza $L$ della cabina di guida, $d_1$ è la distanza fra cabina e rimorchio e $d_2$ la distanza del rimorchio. Possiamo ora calcolare la variazione di angolo e posizione:

<!-- In this section, we also consider a few more parameters shown in Figure 2. -->
<!-- Given car length $L$, $d_1$ the distance between car and trailer and $d_2$ the length of the trailer, etc, we can calculate the change of angle and positions: -->

$$
\begin{aligned}
\dot{\theta_0} &= \frac{s}{L}\tan(\phi)\\
\dot{\theta_1} &= \frac{s}{d_1}\sin(\theta_1 - \theta_0)\\
\dot{x}        &= s\cos(\theta_0)\\
\dot{y}        &= s\sin(\theta_0)
\end{aligned}
$$

dove $s$ denota la velocità (di segno positivo e negativo) e $\phi$ l'angolo negativo di sterzata.
Ora possiamo rappresentare lo stato solamente tramite quattro parametri: $\xcab$, $\ycab$, $\theta_0$ e $\theta_1$.
Ciò perché i parametri di lunghezza $\xtrailer, \ytrailer$ sono noti in quanto ricavabili da $\xcab, \ycab, d_1, \theta_1$.

<!-- Here, $s$ denotes the signed speed and $\phi$ the negative steering angle.
Now we can represent the state by only four parameters: $\xcab$, $\ycab$, $\theta_0$ and $\theta_1$.
This is because Length parameters are known and $\xtrailer, \ytrailer$ is determined by $\xcab, \ycab, d_1, \theta_1$. -->

Nel Jupyter Notebook della *repository* Deep Learning, troviamo degli ambienti di esempio, come mostrato nelle Figg. 3.1-3.4:

<!-- In the Jupyter Notebook from the Deep Learning repository, we have some sample environments shown in Figures 3.(1-4): -->

| <img src="{{site.baseurl}}/images/week10/10-3/fig3.png" height="150" width="300"/> |<img src="{{site.baseurl}}/images/week10/10-3/fig4.png" height="150" width="300"/>|
| **Fig. 3.1**: grafico di esempio dell'ambiente <!-- Sample plot of the environment --> | **Fig. 3.2**: chiusura a libro della cabina sul rimorchio (effetto *jackknife*)<!-- Driving into itself (jackknifing) --> |
| <img src="{{site.baseurl}}/images/week10/10-3/fig5.png" height="150" width="300"/> |<img src="{{site.baseurl}}/images/week10/10-3/fig6.png" height="150" width="300"/>|
| **Fig. 3.3**: uscita dai bordi <!-- Going out of boundary --> |**Fig. 3.4**: raggiungimento della piattaforma <!--Reaching the dock-->|

Ad ogni intervallo temporale $k$ viene inviato un segnale di sterzo compreso fra $-\frac{\pi}{4}$ e $\frac{\pi}{4}$ e il camion si muoverà in retro dell'angolo corrispondente.

<!-- At each time step $k$, a steering signal which ranges from $-\frac{\pi}{4}$ to $\frac{\pi}{4}$ will be fed in and the truck will take back up using the corresponding angle. -->

Ci sono numerose situazioni in cui la simulazione può essere interrotta:
- il camion si accartoccia su se stesso (*chiusura a libro* della cabina sul rimorchio, anche conosciuto come "effetto *jackknife*", v. Fig. 3.2);
- il camion esce dai bordi dell'ambiente di simulazione (v. Fig. 3.3);
- il camion raggiunge la piattaforma di carico (v. Fig. 3.4).

<!-- There are several situations where the sequence can end:
 - If the truck drives into itself (jackknifes, as in Figure 3.2)
 - If the truck goes out of boundary (shown in Figure 3.3)
 - If the truck reaches the dock (shown in Figure 3.4) -->


## [Addestramento](https://www.youtube.com/watch?v=A3klBqEWR-I&t=1184s)

<!-- ## [Training](https://www.youtube.com/watch?v=A3klBqEWR-I&t=1184s) -->

Il processo di addestramento si costituisce di due momenti: (1) addestramento di una rete neurale ad emulazione delle cinematiche concernenti il camion e il rimorchio e (2) addestramento di una rete neurale come controllore del camion.

<!-- The training process involves two stages: (1)  training of a neural network to be an emulator of the truck and trailer kinematics and (2) training of a neural network controller to control the truck. -->


| ![]({{site.baseurl}}/images/week10/10-3/fig7.png) |
| <center><b>Fig. 4</b>: diagramma di riepilogo </center> |
<!-- Overview Diagram -->

Come mostrato qui sopra, nel diagramma astratto, i due blocchi sono le due reti che vanno addestrate. Ad ogni intervallo temporale $k$, la rete chiamata *Trailer Truck Kinematics* ("cinematiche del rimorchio e del camion"), che chiamiamo "emulatore" (*emulator*), riceve in input il vettore di stato esadimensionale e il segnale di sterzata generato dal controllore (*Neural-Net Controller*) e genera un nuovo stato esadimensionale per l'intervallo $k+1$.

<!-- As shown above, in the abstract diagram, the two blocks are the two networks that will be trained. At each time step $k$, the "Trailer Truck Kinematics", or what we have been calling the emulator, takes in the 6-dimension state vector and the steering signal generated from the controller and generate a new 6-dimension state at time $k + 1$. -->


### L'emulatore

<!-- ### Emulator -->

L'emulatore prende in input la posizione corrente ($\tcab^t$,$\xcab^t, \ycab^t$, $\ttrailer^t$, $\xtrailer^t$, $\ytrailer^t$) e la direzione di sterzo ($\phi^t) e restituisce lo stato all'intervallo temporale successivo ($\tcab^{t+1}$,$\xcab^{t+1}, \ycab^{t+1}$, $\ttrailer^{t+1}$, $\xtrailer^{t+1}$, $\ytrailer^{t+1}$). È una rete neurale con uno strato nascosto densamente connnesso e funzione di attivazione ReLU, più uno strato di output lineare. Si utilizza l'errore quadratico medio (MSE, *Mean Square Error*) come funzione di perdita e si addestra l'emulatore tramite la discesa stocastica del gradiente.

<!-- The emulator takes the current location ($\tcab^t$,$\xcab^t, \ycab^t$, $\ttrailer^t$, $\xtrailer^t$, $\ytrailer^t$) plus the steering direction $\phi^t$ as input and outputs the state at next timestep ($\tcab^{t+1}$,$\xcab^{t+1}, \ycab^{t+1}$, $\ttrailer^{t+1}$, $\xtrailer^{t+1}$, $\ytrailer^{t+1}$). It consists of a linear hidden layer, with ReLu activation function, and an linear output layer. We use MSE as the loss function and train the emulator via stochastic gradient descent. -->

|![]({{site.baseurl}}/images/week10/10-3/fig8.png)|
|  <center><b>Fig. 5</b>: Addestramento della rete neurale-emulatore<!--Training the Neural-net Emulator--></center>|

Data questa configurazione, il simulatore ci fornisce la posizione del prossimo intervallo data la posizione attuale e l'angolo di sterzo. Di conseguenza, non abbiamo veramente bisogno di una rete neurale che emuli il simulatore. Tuttavia, in sistemi più complessi, potremmo non avere accesso alle equazioni sottostanti il sistema, ovvero alle leggi universali poste in una forma che agevola la computazione. Potremmo ipoteticamente osservare solamente i dati di sequenze di segnali di sterzo e i corrispondenti percorsi del camion. In questo caso, si vuole addestrare una rete per emulare le dinamiche di questo sistema complesso.

<!-- In this setup, the the simulator can tell us the location of next step given the current location and steering angle. Therefore, we don’t really need a neural-net that emulates the simulator. However, in a more complex system, we may not have access to the underlying equations of the system, i.e. we do not have the laws of the universe in a nice computable form. We may only observe data that records sequences of steering signals and their corresponding paths. In this case, we want to train a neural-net to emulate the dynamic of this complex system. -->

Per addestrare l'emulatore, ci sono due funzioni importanti nel file `Class truck` che necessitano di essere analizzate quando addestriamo l'emulatore.

<!-- In order to train enumlator, there are two important function in `Class truck` we need to look into when we train the emulator. -->

La prima delle due è la funzione `step`, che definisce lo stato di output del camion al termine della computazione.

<!-- First is the `step` function which gives the output state of the truck after computation. -->

```python
def step(self, ϕ=0, dt=1):

    # controllo di condizioni illegali
    if self.is_jackknifed(): # Jackknife
        print('The truck is jackknifed!')
        return

    if self.is_offscreen(): # Camion fuori schermo
        print('The car or trailer is off screen')
        return

    self.ϕ = ϕ
    x, y, W, L, d, s, θ0, θ1, ϕ = self._get_atributes()

    # aggiornamento dello stato
    self.x += s * cos(θ0) * dt
    self.y += s * sin(θ0) * dt
    self.θ0 += s / L * tan(ϕ) * dt
    self.θ1 += s / d * sin(θ0 - θ1) * dt
```

La seconda è la funzione `stato` che restituisce lo stato corrente del camion.

<!-- Second is the `state` function which gives the current state of the truck. -->

```python
def state(self):
        return (self.x, self.y, self.θ0, *self._traler_xy(), self.θ1)
```

Prima di tutto vengono generate due liste. Generiamo una lista di input aggiungendo l'angolo di sterzo `ϕ` e lo stato iniziale del camion tramite la chiamata `truck.state()`; dopodiché generiamo una lista di output concatenando le variabili di output che possono venir calcolate chiamando `truck.step(ϕ)`.

<!-- We generate two lists first. We generate an input list by appending the randomly generated steering angle `ϕ` and the initial state which coming from the truck by running `truck.state()`. And we generate an output list that is appended by the output state of the truck which can be computed by `truck.step(ϕ)`. -->

Ora si può addestrare l'emulatore:

<!-- We now can train the emulator: -->

```python
cnt = 0
for i in torch.randperm(len(train_inputs)):
    ϕ_state = train_inputs[i]
    next_state_prediction = emulator(ϕ_state)

    next_state = train_outputs[i]
    loss = criterion(next_state_prediction, next_state)

    optimiser_e.zero_grad()
    loss.backward()
    optimiser_e.step()

    if cnt == 0 or (cnt + 1) % 1000 == 0:
        print(f'{cnt + 1:4d} / {len(train_inputs)}, {loss.item():.10f}')
    cnt += 1
```

Si noti che la chiamata `torch.randperm(len(train_inputs))` restituisce una permutazione casuale degli indici da $0$ alla lunghezza degli input di addestramento meno $1$. Dopo la permutazione degli indici, ad ogni intervallo viene selezionato `ϕ_state` dalla `i`-esima posizione della lista di input. Si passa `ϕ_state` alla funzione di emulazione, la quale produce uno strato di output lineare, e otteniamo la previsione per il prossimo stato (`next_state_prediction`). L'emulatore è una rete neurale definita qui sotto:

<!-- Notice that `torch.randperm(len(train_inputs))` gives us a random permutation of the indices within the range $0$ to length of training inputs minus $1$. After the permutation of indices, each time `ϕ_state` is chosen from the input list at the index `i`. We input `ϕ_state` through the emulator function that has a linear output layer and we get `next_state_prediction`. Notice that the emulator is a neural netork defined as below: -->

```python
emulator = nn.Sequential(
    nn.Linear(steering_size + state_size, hidden_units_e),
    nn.ReLU(),
    nn.Linear(hidden_units_e, state_size)
)
```

Si utilizza MSE per calcolare la perdita fra la lo stato reale e quello previsto: lo stato reale proviene dall'`i`-esimo elemento della lista di output, corrispondente al `ϕ_state` ottenuto dalla lista di input.

<!-- Here we use MSE to calculate the loss between the true next state and the next state prediction, where the true next state is coming from the output list with index `i` that corresponding to the index of the `ϕ_state` from input list. -->


### Il controllore

<!-- ### Controller -->

Con riferimento alla Fig. 5, il blocco $\matr{C}$ rappresenta il controllore. Riceve in ingresso lo stato corrente e restituisce un angolo di sterzo. Il blocco $\matr{T}$ (l'emulatore) riceve sia lo stato che l'angolo e produce lo stato successivo.

<!-- Refer to Figure 5. Block $\matr{C}$ represents the controller. It takes in the current state and ouputs a steering angle. Then block $\matr{T}$ (emulator) takes both the state and angle to produce the next state. -->

|![]({{site.baseurl}}/images/week10/10-3/fig13.png)|
| <center><b>Fig. 5</b>: diagramma di flusso per la transizione dello stato <!--State Transition flow diagram--></center>|

Per l'addestramento del controllore, iniziamo da uno stato iniziale casuale e ripetiamo la procedura ($\matr{C}$ e $\matr{T}$) finché il rimorchio si trova parallelo alla piattaforma. L'errore è calcolato comparando la posizione del rimorchio e quella della piattaforma.
Ricaviamo quindi i gradienti usando la retropropagazione e aggiorniamo i parametri del controllore tramite SGD.

<!-- To train the controller, we start from a random initial state and repeat the procedure($\matr{C}$ and $\matr{T}$) until the trailer is parallel to the dock. The error is calculated by comparing the trailer location and dock location.
We then find the gradients using backpropagation and update parameters of the controller via SGD. -->


### [Struttura dettagliata del modello](https://www.youtube.com/watch?v=A3klBqEWR-I&t=2328s)

<!-- ### [Detailed Model Structure](https://www.youtube.com/watch?v=A3klBqEWR-I&t=2328s) -->

Questo è un grafico dettagliato del processo ($\matr{C}$, $\matr{T}$). Iniziamo con uno stato (vettore a 6 dimensioni), lo moltiplichiamo per una matrice di pesi addestrabili ottenendo 25 unità nascoste, che moltiplichiamo per un vettore di pesi addestrabili ad ottenere l'output (segnale di sterzo). Analogamente, passiamo lo stato e l'angolo $\phi$ (complessivamente un vettore di 7 dimensioni) attraverso due strati a produrre lo stato dell'intervallo successivo.

<!-- This is a detailed graph of ($\matr{C}$, $\matr{T}$) process. We start with a state (6 dimension vector), multiply it with a tunable weights matrix and get 25 hidden units. Then we pass it through another tunable weights vector to get the output (steering signal). Similarly, we input the state and angle $\phi$ (7 dimension vector) through two layers to produce the state of next step. -->

![]({{site.baseurl}}/images/week10/10-3/fig14.png)
| <center><b>Fig. 6</b>: vista di dettaglio di emulatore e controllore </center>|

Per analizzare questo passaggio più nel dettaglio, mostriamo l'esatta implementazione dell'emulatore:

<!-- To see this more clearly, we show the exact implementation of the emulator: -->

```python
state_size = 6
steering_size = 1
hidden_units_e = 45

emulator = nn.Sequential(
    nn.Linear(steering_size + state_size, hidden_units_e),
    nn.ReLU(),
    nn.Linear(hidden_units_e, state_size)
)

optimiser_e = SGD(emulator.parameters(), lr=0.005)
criterion = nn.MSELoss()
```


### Esempi di movimento

<!-- ### Examples of Movement -->

Di seguito vengono mostrati quattro esempi di movimento per stati iniziali differenti. Si noti che il numero d'intervalli temporali di ogni episodio non è fisso.

<!-- Following are four examples of movement for different initial state. Notice that the number of time steps in each episode varies. -->

|![]({{site.baseurl}}/images/week10/10-3/fig16.png) | ![]({{site.baseurl}}/images/week10/10-3/fig17.png) |
|![]({{site.baseurl}}/images/week10/10-3/fig18.png) | ![]({{site.baseurl}}/images/week10/10-3/fig19.png) |
| <center><b>Fig. 7</b>: esempi di movimento per quattro differenti stati iniziali </center>|

### Ulteriori risorse:

<!-- ### Additional Resources: -->

Una *demo* funzionante è reperibile all'indirizzo [https://tifu.github.io/truck_backer_upper/](https://tifu.github.io/truck_backer_upper/).
Si dia un'occhiata anche al codice, che può essere trovato qui [https://github.com/Tifu/truck_backer_upper](https://github.com/Tifu/truck_backer_upper).

<!-- A full working demo can be found at: [https://tifu.github.io/truck_backer_upper/](https://tifu.github.io/truck_backer_upper/).
Please check out the code as well, which can be found at [https://github.com/Tifu/truck_backer_upper](https://github.com/Tifu/truck_backer_upper). -->
